      FUNCTION CENTER(INPUT_STRING)
C----------------------------------------------------------------------*
C     FUNCTION:     CENTER                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-21-79 @ 17:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS FUNCTION CENTERS AN INPUT CHARACTER STRING    *
C                   AND RETURNS THE CENTERED RESULT.  THE LENGTH OF    *
C                   THE RETURNED STRING IS BASED SOLELY ON THE         *
C                   'CHARACTER' DECLARATION USED TO DEFINE THE CENTER  *
C                   FUNCTION IN THE CALLING PROGRAM.  FOR EXAMPLE, IF  *
C                   CENTER IS DECLARED CHARACTER*100 IN THE CALLING    *
C                   PROGRAM, ALL RETURNED CHARACTER STRINGS WILL BE    *
C                   100 CHARACTERS IN LENGTH.                          *
C----------------------------------------------------------------------*
C     VARAIBLE MAP                                                     *
C----------------------------------------------------------------------*
C     CENTER:            RETURNED CENTERED CHARACTER STRING            *
C                                                                      *
C     CEN040:            ALTERNATE ENTRYPOINT:  40-COLUMN WIDTH        *
C                                                                      *
C     CEN066:            ALTERNATE ENTRYPOINT:  66-COLUMN WIDTH        *
C                                                                      *
C     CEN080:            ALTERNATE ENTRYPOINT:  80-COLUMN WIDTH        *
C                                                                      *
C     CEN132:            ALTERNATE ENTRYPOINT: 132-COLUMN WIDTH        *
C                                                                      *
C     COLUMN:            COLUMN INDEX                                  *
C                                                                      *
C     INPUT_STRING:      INPUT CHARACTER STRING TO BE CENTERED         *
C                                                                      *
C     LETTERS:           NUMBER OF CHARACTERS TO BE CENTERED           *
C                                                                      *
C     LIMIT:             TOTAL INPUT_STRING CHARACTER LENGTH           *
C                                                                      *
C     OUTPUT_WIDTH:      NUMBER OF CHARACTERS IN RETURNED STRING       *
C                                                                      *
C     START:             FIRST NON-BLANK CHARACTER IN INPUT_STRING     *
C                                                                      *
C     STOP:              LAST NON-BLANK CHARACTER IN INPUT_STRING      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! SPACE CHARACTER
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER TWO              = 2              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) CEN040
      CHARACTER*(*) CEN066
      CHARACTER*(*) CEN080
      CHARACTER*(*) CEN132
      CHARACTER*(*) CENTER
      CHARACTER*(*) INPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 COLUMN
      INTEGER*4 FIRST
      INTEGER*4 LENGTH
      INTEGER*4 LETTERS
      INTEGER*4 LIMIT
      INTEGER*4 OUTPUT_WIDTH
      INTEGER*4 START
      INTEGER*4 STOP
C----------------------------------------------------------------------*
C                                                                      *
C     ALTERNATE ENTRYPOINTS                                            *
C                                                                      *
C----------------------------------------------------------------------*
      ENTRY CEN040(INPUT_STRING)
      ENTRY CEN066(INPUT_STRING)
      ENTRY CEN080(INPUT_STRING)
      ENTRY CEN132(INPUT_STRING)
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     CALCULATE FIRST AND LAST NON-BLANK CHARACTER POSITIONS IN STRING *
C----------------------------------------------------------------------*
  100 CONTINUE
      CENTER=BLANK
      OUTPUT_WIDTH=LEN(CENTER)
      STOP=LENGTH(INPUT_STRING)
      IF (STOP .EQ. ZERO) GO TO 900
      START=FIRST(INPUT_STRING)
C----------------------------------------------------------------------*
C     SECTION 200                                                      *
C----------------------------------------------------------------------*
C     CENTER THE TEXT IN THE OUTPUT BUFFER                             *
C----------------------------------------------------------------------*
  200 CONTINUE
      LETTERS=STOP-START+ONE
      IF (LETTERS .GT. OUTPUT_WIDTH) LETTERS=OUTPUT_WIDTH
      CENTER((((OUTPUT_WIDTH-LETTERS)/TWO)+ONE):)=
     1     INPUT_STRING(START:STOP)
C----------------------------------------------------------------------*
C     SECTION 900
C----------------------------------------------------------------------*
C     EXIT FUNCTION CENTER                                             *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF FUNCTION CENTER                                           *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DECFMT(INPUT_NUMBER,OUTPUT_STRING,SIGFIG)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DECFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         06-01-80 @ 12:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS AN INTEGER NUMBER INTO A  *
C                   DECIMAL CHARACTER STRING WITH 'SIGFIG' NUMBER      *
C                   OF DECIMAL DIGITS, RIGHT-JUSTIFIED AND BLANK       *
C                   FILLED.                                            *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT_NUMBER:      NUMBER TO BE CONVERTED.                       *
C                                                                      *
C     OUTPUT_STRING:     OUTPUT CHARACTER STRING.                      *
C                                                                      *
C     SIGFIG:            NUMBER OF VALID DIGITS IN OUTPUT_STRING.      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER MAXDEC           = 11             ! MAX # OF DECIMAL DIGITS 
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*)   OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 INPUT_NUMBER
      INTEGER*4 SIGFIG
      INTEGER*4 LIMIT
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     CONVERT INPUT_NUMBER TO OUTPUT_STRING AND RETURN SIGFIG          *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=JMIN0(LEN(OUTPUT_STRING),MAXDEC)
      IF (LIMIT .EQ. ZERO) GO TO 900
  
      IF ((SIGFIG .LE. ZERO) .OR. (SIGFIG .GT. LIMIT)) SIGFIG=LIMIT

      OUTPUT_STRING=BLANK
      ENCODE (SIGFIG,1000,OUTPUT_STRING) INPUT_NUMBER
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     SUBROUTINE TERMINATION                                           *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(I<SIGFIG>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DECFMT                                         *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DECODE_HEXDEC(INPUT_STRING,NUMBER,EMPTY,ERROR)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DECODE_HEXDEC                                      *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         07-21-80 @ 19:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE PERFORMS HEX CHARACTER STRING TO   *
C                   INTEGER*4 CONVERSION IN A FASHION THAT IS USEFUL   *
C                   IN INTERACTIVE APPLICATIONS.  THE INPUT FORMAT IS  *
C                   FREE-FORM.  DECIMAL POINTS ARE FORBIDDEN.          *
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     DELETE_BLANKS:     COMPRESSES BLANKS FROM A CHARACTER STRING     *
C                                                                      *
C     FIRST:             RETURNS THE FIRST NON-BLANK CHARACTER         *
C                        POSITION IN A PASSED CHARACTER STRING         *
C                                                                      *
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER POSITION *
C                        IN A PASSED CHARACTER STRING                  *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     EMPTY:             FLAG SET WHEN INPUT STRING IS ALL-BLANK       *
C                                                                      *
C     ERROR:             FLAG SET WHEN NUMERIC CONVERSION ERROR OCCURS *
C                                                                      *
C     INPUT_STRING:      INPUT CHARACTER STRING TO BE PROCESSED        *
C                                                                      *
C     NUMBER:            INTEGER*4 NUMBER RETURNED                     *
C                                                                      *
C     START:             FIRST NON-BLANK CHARACTER POSITION IN INPUT   *
C                                                                      *
C     STRING:            OUTPUT CHARACTER STRING TO BE DECODED         *
C                                                                      *
C     STRING_LENGTH:     LAST NON-BLANK CHARACTER POSITION IN INPUT    *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) INPUT_STRING 
      CHARACTER*025 STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 FIRST
      INTEGER*4 NUMBER
      INTEGER*4 START
      INTEGER*4 STRING_LENGTH
C----------------------------------------------------------------------*
C     LOGICAL*4                                                        *
C----------------------------------------------------------------------*
      LOGICAL*4 EMPTY
      LOGICAL*4 ERROR
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DECODE THE NUMERIC CHARACTER STRING                              *
C----------------------------------------------------------------------*
  100 CONTINUE
      ERROR=.FALSE.
      NUMBER=ZERO
      START=FIRST(INPUT_STRING)
      EMPTY=(START .EQ. ZERO)
      IF (EMPTY) GO TO 900
      STRING=INPUT_STRING(START:)
      CALL DELETE_BLANKS(STRING)
      STRING_LENGTH=LENGTH(STRING)

      ERROR=.TRUE.
      DECODE(STRING_LENGTH,1000,STRING,ERR=900) NUMBER
      ERROR=.FALSE.
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT FROM SUBROUTINE DECODE_HEXDEC                               *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(Z<STRING_LENGTH>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DECODE_HEXDEC                                  *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DECODE_INTEGER(INPUT_STRING,NUMBER,EMPTY,ERROR)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DECODE_INTEGER                                     *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         07-21-80 @ 19:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE PERFORMS CHARACTER STRING TO       *
C                   INTEGER*4 CONVERSION IN A FASHION THAT IS USEFUL   *
C                   IN INTERACTIVE APPLICATIONS.  THE INPUT FORMAT IS  *
C                   FREE-FORM.  DECIMAL POINTS ARE FORBIDDEN.          *
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     DELETE_BLANKS:     COMPRESSES BLANKS FROM A CHARACTER STRING     *
C                                                                      *
C     FIRST:             RETURNS THE FIRST NON-BLANK CHARACTER         *
C                        POSITION IN A PASSED CHARACTER STRING         *
C                                                                      *
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER POSITION *
C                        IN A PASSED CHARACTER STRING                  *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     EMPTY:             FLAG SET WHEN INPUT STRING IS ALL-BLANK       *
C                                                                      *
C     ERROR:             FLAG SET WHEN NUMERIC CONVERSION ERROR OCCURS *
C                                                                      *
C     INPUT_STRING:      INPUT CHARACTER STRING TO BE PROCESSED        *
C                                                                      *
C     NUMBER:            INTEGER*4 NUMBER RETURNED                     *
C                                                                      *
C     START:             FIRST NON-BLANK CHARACTER POSITION IN INPUT   *
C                                                                      *
C     STRING:            OUTPUT CHARACTER STRING TO BE DECODED         *
C                                                                      *
C     STRING_LENGTH:     LAST NON-BLANK CHARACTER POSITION IN INPUT    *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) INPUT_STRING 
      CHARACTER*025 STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 FIRST
      INTEGER*4 NUMBER
      INTEGER*4 START
      INTEGER*4 STRING_LENGTH
C----------------------------------------------------------------------*
C     LOGICAL*4                                                        *
C----------------------------------------------------------------------*
      LOGICAL*4 EMPTY
      LOGICAL*4 ERROR
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DECODE THE NUMERIC CHARACTER STRING                              *
C----------------------------------------------------------------------*
  100 CONTINUE
      ERROR=.FALSE.
      NUMBER=ZERO
      START=FIRST(INPUT_STRING)
      EMPTY=(START .EQ. ZERO)
      IF (EMPTY) GO TO 900
      STRING=INPUT_STRING(START:)
      CALL DELETE_BLANKS(STRING)
      STRING_LENGTH=LENGTH(STRING)

      ERROR=.TRUE.
      DECODE(STRING_LENGTH,1000,STRING,ERR=900) NUMBER
      ERROR=.FALSE.
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT FROM SUBROUTINE DECODE_INTEGER                              *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(I<STRING_LENGTH>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DECODE_INTEGER                                 *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DECODE_NUMBER(INPUT_STRING,NUMBER,EMPTY,ERROR)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DECODE_NUMBER                                      *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-27-79 @ 09:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE PERFORMS CHARACTER STRING TO       *
C                   REAL*8 CONVERSION IN A FASHION THAT IS USEFUL IN   *
C                   INTERACTIVE APPLICATIONS.  THE INPUT FORMAT IS     *
C                   FREE-FORM.  DECIMAL POINTS ARE OPTIONAL.  EITHER   *
C                   A 'D' OR 'E' CHARACTER IS ACCEPTABLE AS THE        *
C                   EXPONENT INDICATOR.                                *
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     DELETE_BLANKS:     COMPRESSES BLANKS FROM A CHARACTER STRING     *
C                                                                      *
C     FIRST:             RETURNS THE FIRST NON-BLANK CHARACTER         *
C                        POSITION IN A PASSED CHARACTER STRING         *
C                                                                      *
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER POSITION *
C                        IN A PASSED CHARACTER STRING                  *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     DEC_INDEX:         POSITION OF DECIMAL POINT IN INPUT STRING     *
C                                                                      *
C     EMPTY:             FLAG SET WHEN INPUT STRING IS ALL-BLANK       *
C                                                                      *
C     ERROR:             FLAG SET WHEN NUMERIC CONVERSION ERROR OCCURS *
C                                                                      *
C     EXP_INDEX:         POSITION OF EXPONENT FIELD IN INPUT STRING    *
C                                                                      *
C     INPUT_STRING:      INPUT CHARACTER STRING TO BE PROCESSED        *
C                                                                      *
C     NUMBER:            REAL*8 NUMBER RETURNED                        *
C                                                                      *
C     START:             FIRST NON-BLANK CHARACTER POSITION IN INPUT   *
C                                                                      *
C     STRING:            OUTPUT CHARACTER STRING TO BE DECODED         *
C                                                                      *
C     STRING_LENGTH:     LAST NON-BLANK CHARACTER POSITION IN INPUT    *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER DECIMAL          = '.'            ! DECIMAL POINT CHECK
      PARAMETER D_FORMAT         = 'D'            ! REAL*8 EXPONENT CHECK
      PARAMETER E_FORMAT         = 'E'            ! REAL*4 EXPONENT CHECK
      PARAMETER I_FORMAT         = '.0D+00'       ! INTEGER*4 CONVERSION
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER SIX              = 6              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) INPUT_STRING 
      CHARACTER*025 STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 DEC_INDEX
      INTEGER*4 EXP_INDEX
      INTEGER*4 FIRST
      INTEGER*4 START
      INTEGER*4 STRING_LENGTH
C----------------------------------------------------------------------*
C     LOGICAL*4                                                        *
C----------------------------------------------------------------------*
      LOGICAL*4 EMPTY
      LOGICAL*4 ERROR
C----------------------------------------------------------------------*
C     REAL*8                                                           *
C----------------------------------------------------------------------*
      REAL*8 NUMBER
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DECODE THE NUMERIC CHARACTER STRING                              *
C----------------------------------------------------------------------*
  100 CONTINUE
      ERROR=.FALSE.
      NUMBER=ZERO
      START=FIRST(INPUT_STRING)
      EMPTY=(START .EQ. ZERO)
      IF (EMPTY) GO TO 900
      STRING=INPUT_STRING(START:)
      CALL DELETE_BLANKS(STRING)
      STRING_LENGTH=LENGTH(STRING)

      DEC_INDEX=INDEX(STRING,DECIMAL)
      EXP_INDEX=JMAX0(INDEX(STRING,D_FORMAT),INDEX(STRING,E_FORMAT))

      IF ((DEC_INDEX .EQ. ZERO) .AND. (EXP_INDEX .EQ. ZERO)) THEN
           STRING((STRING_LENGTH+ONE):)=I_FORMAT
      
      ELSE IF (DEC_INDEX .EQ. ZERO) THEN
           STRING(EXP_INDEX:)=DECIMAL//STRING(EXP_INDEX:)
     
      END IF

      ERROR=.TRUE.
      STRING_LENGTH=LENGTH(STRING)
      DECODE(STRING_LENGTH,1000,STRING,ERR=900) NUMBER
      ERROR=.FALSE.
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT FROM SUBROUTINE DECODE_NUMBER                               *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(D<STRING_LENGTH>.<JMAX0((STRING_LENGTH-SIX),ONE)>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DECODE_NUMBER                                  *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DELETE_BLANKS(INPUT_STRING)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DELETE_BLANKS                                      *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-02-79 @ 10:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE DELETES ALL IMBEDDED BLANKS WITHIN *
C                   A PASSED CHARACTER STRING.  UPON EXIT, ONLY        *
C                   TRAILING BLANKS WILL BE PRESENT IN INPUT_STRING.   *
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER POSITION *
C                        IN A PASSED CHARACTER STRING.                 *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     COLUMN:            INPUT COLUMN INDEX                            *
C                                                                      *
C     INPUT_STRING:      STRING TO BE COMPRESSED (BLANKS ELIMINATED).  *
C                                                                      *
C     LIMIT:             LAST NON-BLANK CHARACTER IN INPUT_STRING      *
C                                                                      *
C     OUTCOL:            OUTPUT COLUMN INDEX                           *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER INPUT_STRING*(*)
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 COLUMN
      INTEGER*4 LENGTH
      INTEGER*4 LIMIT
      INTEGER*4 OUTCOL
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DELETE ALL BLANKS FROM INPUT_STRING                              *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=LENGTH(INPUT_STRING)
      IF (LIMIT .EQ. ZERO) GO TO 900
      OUTCOL=ONE

      DO 110 COLUMN=ONE,LIMIT
      IF (INPUT_STRING(COLUMN:COLUMN) .NE. BLANK) THEN
           INPUT_STRING(OUTCOL:OUTCOL)=INPUT_STRING(COLUMN:COLUMN)
           IF (COLUMN .NE. OUTCOL) INPUT_STRING(COLUMN:COLUMN)=BLANK
           OUTCOL=OUTCOL+ONE
      END IF
  110 CONTINUE
C----------------------------------------------------------------------*
C     EXIT WITH INPUT_STRING COMPRESSED OF ALL BLANKS                  *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DELETE_BLANKS                                  *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE DELETE_CONTROL(INPUT_STRING)
C----------------------------------------------------------------------*
C     SUBROUTINE:   DELETE_CONTROL                                     *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         02-07-81 @ 08:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE DELETES ALL IMBEDDED CONTROL       *
C                   CHARACTERS WITHIN A PASSED CHARACTER STRING.       *
C                   UPON EXIT, INPUT_STRING WILL CONTAIN NO CONTROL    *
C                   CHARACTERS AND WILL BE PADDED WITH TRAILING BLANKS.*
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER POSITION *
C                        IN A PASSED CHARACTER STRING.                 *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     ASCII:             ONE ASCII CHARACTER                           *
C                                                                      *
C     COLUMN:            INPUT COLUMN INDEX                            *
C                                                                      *
C     INPUT_STRING:      STRING TO BE COMPRESSED (BLANKS ELIMINATED).  *
C                                                                      *
C     LIMIT:             LAST NON-BLANK CHARACTER IN INPUT_STRING      *
C                                                                      *
C     OUTCOL:            OUTPUT COLUMN INDEX                           *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER DELETE           = '7F'X          ! ASCII DELETE CODE
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER STRIP_PARITY     = '7F'X          ! ASCII STRIP PARITY BIT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER INPUT_STRING*(*)
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 ASCII
      INTEGER*4 COLUMN
      INTEGER*4 LENGTH
      INTEGER*4 LIMIT
      INTEGER*4 OUTCOL
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DELETE ALL CONTROL CHARACTERS FROM INPUT_STRING                  *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=LENGTH(INPUT_STRING)
      IF (LIMIT .EQ. ZERO) GO TO 900
      OUTCOL=ONE


      DO COLUMN=ONE,LIMIT
      ASCII=JIAND(ICHAR(INPUT_STRING(COLUMN:COLUMN)),STRIP_PARITY)

      IF ((ASCII .GE. ICHAR(BLANK)) .AND. (ASCII .NE. DELETE)) THEN
           INPUT_STRING(OUTCOL:OUTCOL)=CHAR(ASCII)
           IF (COLUMN .NE. OUTCOL) INPUT_STRING(COLUMN:COLUMN)=BLANK
           OUTCOL=OUTCOL+ONE
      ELSE
           INPUT_STRING(COLUMN:COLUMN)=BLANK
      END IF

      ENDDO
C----------------------------------------------------------------------*
C     EXIT WITH INPUT_STRING COMPRESSED OF ALL CONTROL CHARACTERS      *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF SUBROUTINE DELETE_CONTROL                                 *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE ENGFMT(NUMBER,OUTPUT_STRING,SIGFIG)                
C----------------------------------------------------------------------*
C     SUBROUTINE:   ENGFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-25-79 @ 17:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS A NUMBER TO ENGINEERING   *
C                   NOTATION CHARACTER FORMAT, AND RETURNS A CHARACTER *
C                   STRING CONTAINING THE RESULT OF THE CONVERSION.    *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT PARAMETERS                                                 *
C----------------------------------------------------------------------*
C     SUBROUTINE ENGFMT(NUMBER,OUTPUT_STRING,SIGFIG)                   *
C                                                                      *
C                                                                      *
C     NUMBER           - REAL*8 NUMBER TO BE CONVERTED TO ENGINEERING  *
C                        NOTATION CHARACTER FORMAT                     *
C                                                                      *
C     OUTPUT_STRING    - DESTINATION BUFFER FOR CHARACTER OUTPUT.      *
C                        MUST BE OF TYPE CHARACTER.                    *
C                                                                      *
C     SIGFIG           - NUMBER OF SIGNIFICANT FIGURES TO BE DISPLAYED *
C                        IF SIGFIG < 3 THIS ROUTINE MAY BE EXPECTED    *
C                        TO OUTPUT AS MANY SIGNIFICANT FIGURES FIGURES *
C                        AS NEEDED TO MAINTAIN A VALID ENGINEERING     *
C                        NOTATION REPRESENTATION.                      *
C                                                                      *
C                        NOTE:  TOTAL OUTPUT WIDTH IS SIGFIG+6         *
C----------------------------------------------------------------------*
C     INTERNAL VARIABLES                                               *
C----------------------------------------------------------------------*
C     DIGITS           - ACTUAL NUMBER OF SIGNIFICANT FIGURES PRINTED  *
C                                                                      *
C     LEFT_DIGITS      - NUMBER OF DIGITS TO THE LEFT OF THE DECIMAL   *
C                                                                      *
C     OUTPUT_WIDTH     - NUMBER OF CHARACTERS MOVED TO OUTPUT_STRING   *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! SPACE CHARACTER
      PARAMETER LIMIT_DIGITS     = 15             ! LIMIT ON SIGFIG
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ONE_KILO         = 1000           ! UPPER BOUND ON FORMAT
      PARAMETER SIX              = 6              ! SIGFIG OVERHEAD
      PARAMETER THREE            = 3              ! USEFUL CONSTANT
      PARAMETER TWO              = 2              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 DIGITS   
      INTEGER*4 LEFT_DIGITS   
      INTEGER*4 OUTPUT_WIDTH   
      INTEGER*4 SIGFIG   
C----------------------------------------------------------------------*
C     REAL*8                                                           *
C----------------------------------------------------------------------*
      REAL*8 EXPONENT
      REAL*8 NUMBER           
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     PRODUCE A CHARACTER STRING REPRESENTATION OF 'NUMBER' IN         *
C     ENGINEERING NOTATION FORMAT, INSURING AT LEAST ONE OUTPUT DIGIT  *
C----------------------------------------------------------------------*
  100 CONTINUE          

      IF (NUMBER .EQ. ZERO) THEN
           LEFT_DIGITS=ONE
      ELSE
           EXPONENT=DLOG10(DABS(NUMBER))
      
           IF (EXPONENT .GE. ZERO) THEN
                LEFT_DIGITS=EXPONENT-
     1               ((JIDINT(EXPONENT)/THREE)*THREE)+ONE
           ELSE
                EXPONENT=EXPONENT+((JIDINT(DABS(EXPONENT))/THREE)+ONE)
     1               *THREE
                LEFT_DIGITS=EXPONENT-
     1               (JIDINT(EXPONENT/THREE)*THREE)+ONE
           END IF

      END IF

      DIGITS=JMIN0(JMAX0(SIGFIG,LEFT_DIGITS),LIMIT_DIGITS)
      OUTPUT_WIDTH=DIGITS+SIX
      OUTPUT_STRING=BLANK
      ENCODE(OUTPUT_WIDTH,1000,OUTPUT_STRING) NUMBER

      IF (DIGITS .EQ. LEFT_DIGITS)
     1     OUTPUT_STRING((LEFT_DIGITS+TWO):(LEFT_DIGITS+TWO))=BLANK
      
      IF (((DABS(NUMBER) .LT. ONE_KILO) .AND. (DABS(NUMBER) .GE. ONE)) 
     1     .OR. (NUMBER .EQ. ZERO)) OUTPUT_STRING((DIGITS+THREE):)=BLANK
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(<LEFT_DIGITS>PE<OUTPUT_WIDTH>.<DIGITS-ONE>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE ENGFMT                                         *
C----------------------------------------------------------------------*
      RETURN    
      END       
      SUBROUTINE EXPFMT(NUMBER,OUTPUT_STRING,SIGFIG)                
C----------------------------------------------------------------------*
C     SUBROUTINE:   EXPFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-25-79 @ 14:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS A NUMBER TO EXPONENTIAL   *
C                   NOTATION CHARACTER FORMAT, AND RETURNS A CHARACTER *
C                   STRING CONTAINING THE RESULT OF THE CONVERSION.    *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT PARAMETERS                                                 *
C----------------------------------------------------------------------*
C     SUBROUTINE EXPFMT(NUMBER,OUTPUT_STRING,SIGFIG)                   *
C                                                                      *
C                                                                      *
C     NUMBER           - REAL*8 NUMBER TO BE CONVERTED TO EXPONENTIAL  *
C                        NOTATION CHARACTER FORMAT                     *
C                                                                      *
C     OUTPUT_STRING    - DESTINATION BUFFER FOR CHARACTER OUTPUT.      *
C                        MUST BE OF TYPE CHARACTER.                    *
C                                                                      *
C     SIGFIG           - NUMBER OF SIGNIFICANT FIGURES TO BE DISPLAYED *
C                        IF SIGFIG < 1 THIS ROUTINE MAY BE EXPECTED    *
C                        TO OUTPUT AS MANY SIGNIFICANT FIGURES FIGURES *
C                        AS NEEDED TO MAINTAIN A VALID EXPONENTIAL     *
C                        NOTATION REPRESENTATION.                      *
C                                                                      *
C                        NOTE:  TOTAL OUTPUT WIDTH IS SIGFIG+6         *
C----------------------------------------------------------------------*
C     INTERNAL VARIABLES                                               *
C----------------------------------------------------------------------*
C     DIGITS           - ACTUAL NUMBER OF SIGNIFICANT FIGURES OUTPUT   *
C                                                                      *
C     OUTPUT_WIDTH     - NUMBER OF CHARACTERS MOVED TO OUTPUT_STRING   *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! SPACE CHARACTER
      PARAMETER LIMIT_DIGITS     = 15             ! LIMIT ON SIGFIG
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER SIX              = 6              ! SIGFIG OVERHEAD
      PARAMETER THREE            = 3              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 DIGITS   
      INTEGER*4 OUTPUT_WIDTH   
      INTEGER*4 SIGFIG   
C----------------------------------------------------------------------*
C     REAL*8                                                           *
C----------------------------------------------------------------------*
      REAL*8 NUMBER           
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     PRODUCE A CHARACTER STRING REPRESENTATION OF 'NUMBER' IN         *
C     EXPONENTIAL NOTATION FORMAT, INSURING AT LEAST ONE OUTPUT DIGIT  *
C----------------------------------------------------------------------*
  100 CONTINUE          
      DIGITS=JMIN0(JMAX0(SIGFIG,ONE),LIMIT_DIGITS)
      OUTPUT_WIDTH=DIGITS+SIX
      OUTPUT_STRING=BLANK
      ENCODE(OUTPUT_WIDTH,1000,OUTPUT_STRING) NUMBER
      IF (DIGITS .EQ. ONE) OUTPUT_STRING(THREE:THREE)=BLANK
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(1PE<OUTPUT_WIDTH>.<DIGITS-ONE>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE EXPFMT                                         *
C----------------------------------------------------------------------*
      RETURN                                                                    
      END                                                                       
      FUNCTION FIRST(INPUT_STRING)
C----------------------------------------------------------------------*
C     FUNCTION:     FIRST                                              *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-02-79 @ 10:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS FUNCTION COMPUTES THE FIRST NON-BLANK         *
C                   CHARACTER POSITION IN INPUT_STRING.                *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     COLUMN:            COLUMN INDEX                                  *
C                                                                      *
C     FIRST:             LAST NON-BLANK CHARACTER WITHIN INPUT_STRING. *
C                                                                      *
C     INPUT_STRING:      STRING TO BE SEARCHED FOR FIRST CHARACTER.    *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER INPUT_STRING*(*)
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 COLUMN
      INTEGER*4 FIRST
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     FIND THE FIRST NON-BLANK CHARACTER IN INPUT_STRING               *
C----------------------------------------------------------------------*
  100 CONTINUE
      FIRST=ZERO
   
      DO 110 COLUMN=ONE,LEN(INPUT_STRING)
      IF (INPUT_STRING(COLUMN:COLUMN) .NE. BLANK) THEN
           FIRST=COLUMN
           GO TO 900
      END IF
  110 CONTINUE
C----------------------------------------------------------------------*
C     EXIT WITH FIRST CHARACTER POSITION AS FIRST                      *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF FUNCTION FIRST                                            *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE GET_WORD(INPUT_STRING,NEXT_WORD)
C----------------------------------------------------------------------*
C     SUBROUTINE:   GET_WORD                                           *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-02-79 @ 10:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS ROUTINE RETURNS THE NEXT WORD FROM            *
C                   INPUT_STRING AND THEN ELIMINATES THAT WORD FROM    *
C                   INPUT_STRING.  IT IS ASSUMED THAT ALL WORDS WILL   *
C                   BE DELIMETED BY BLANKS.                            *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     COLUMN:            COLUMN INDEX                                  *
C                                                                      *
C     INPUT_STRING:      INPUT CHARACTER STRING TO BE WORD-SEARCHED    *
C                                                                      *
C     LIMIT:             LAST NON-BLANK POSITION IN INPUT_STRING       *
C                                                                      *
C     NEXT_WORD:         NEXT WORD IN INPUT_STRING                     *
C                                                                      *
C     START:             FIRST NON-BLANK CHARACTER IN INPUT_STRING     *
C                                                                      *
C     STOP:              LAST NON-BLANK CHARACTER IN NEXT_WORD         *
C----------------------------------------------------------------------*
C     EXTERNALS                                                        *
C----------------------------------------------------------------------*
C     FIRST:             RETURNS THE FIRST NON-BLANK CHARACTER         *
C                        POSITION IN THE PASSED CHARACTER STRING.      *
C                                                                      *
C     LENGTH:            RETURNS THE LAST NON-BLANK CHARACTER          *
C                        POSITION IN THE PASSED CHARACTER STRING.      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) INPUT_STRING
      CHARACTER*(*) NEXT_WORD
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 COLUMN
      INTEGER*4 FIRST
      INTEGER*4 LENGTH
      INTEGER*4 LIMIT
      INTEGER*4 START
      INTEGER*4 STOP
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     DETERMINE FIRST NON-BLANK CHARACTER POSITION IN INPUT_STRING     *
C----------------------------------------------------------------------*
  100 CONTINUE
      NEXT_WORD=BLANK
      LIMIT=LENGTH(INPUT_STRING)
      IF (LIMIT .EQ. ZERO) GO TO 900
      START=FIRST(INPUT_STRING)
C----------------------------------------------------------------------*
C     SECTION 200                                                      *
C----------------------------------------------------------------------*
C     DETERMINE LAST NON-BLANK CHARACTER POSITION IN NEXT_WORD         *
C----------------------------------------------------------------------*
  200 CONTINUE
      
      DO 210 COLUMN=START,LIMIT
      IF (INPUT_STRING(COLUMN:COLUMN) .EQ. BLANK) GO TO 300
      STOP=COLUMN
  210 CONTINUE
C----------------------------------------------------------------------*
C     SECTION 300                                                      *
C----------------------------------------------------------------------*
C     LOAD NEXT_WORD AND DELETE THE NEXT WORD FROM INPUT_STRING        *
C----------------------------------------------------------------------*
  300 CONTINUE
      NEXT_WORD=INPUT_STRING(START:STOP)
     
      IF (STOP .EQ. LIMIT) THEN
           INPUT_STRING=BLANK
      ELSE
           INPUT_STRING=INPUT_STRING(STOP+ONE:)
      END IF
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT SUBROUTINE GET_WORD                                         *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF SUBROUTINE GET_WORD                                       *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE HEXFMT(INPUT_NUMBER,OUTPUT_STRING,SIGFIG)
C----------------------------------------------------------------------*
C     SUBROUTINE:   HEXFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         06-01-80 @ 12:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS AN INTEGER NUMBER INTO A  *
C                   HEXADECIMAL CHARACTER STRING WITH 'SIGFIG' NUMBER  *
C                   OF HEXADECIMAL DIGITS, LEFT-JUSTIFIED AND ZERO     *
C                   FILLED.                                            *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT_NUMBER:      NUMBER TO BE CONVERTED.                       *
C                                                                      *
C     OUTPUT_STRING:     OUTPUT CHARACTER STRING.                      *
C                                                                      *
C     SIGFIG:            NUMBER OF VALID DIGITS IN OUTPUT_STRING.      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER MAXHEX           = 8              ! MAX # OF HEX DIGITS 
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
      PARAMETER ZEROFILL         = '0'            ! ZERO FILL OUTPUT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*)   OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 INPUT_NUMBER
      INTEGER*4 SIGFIG
      INTEGER*4 LIMIT
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     CONVERT INPUT_NUMBER TO OUTPUT_STRING AND RETURN SIGFIG          *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=JMIN0(LEN(OUTPUT_STRING),MAXHEX)
      IF (LIMIT .EQ. ZERO) GO TO 900
  
      IF ((SIGFIG .LE. ZERO) .OR. (SIGFIG .GT. LIMIT)) SIGFIG=LIMIT

      OUTPUT_STRING=BLANK
      ENCODE (SIGFIG,1000,OUTPUT_STRING,ERR=900) INPUT_NUMBER
C----------------------------------------------------------------------*
C     SECTION 200                                                      *
C----------------------------------------------------------------------*
C     ZERO FILL HEXADECIMAL FIELD BEFORE RETURNING TO USER             *
C----------------------------------------------------------------------*
  200 CONTINUE
      
      DO 210 POINTER=ONE,SIGFIG
      IF (OUTPUT_STRING(POINTER:POINTER) .NE. BLANK) GO TO 900
      OUTPUT_STRING(POINTER:POINTER)=ZEROFILL
  210 CONTINUE
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     SUBROUTINE TERMINATION                                           *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(Z<SIGFIG>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE HEXFMT                                         *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE INTFMT(INPUT_NUMBER,OUTPUT_STRING,LENGTH)
C----------------------------------------------------------------------*
C     SUBROUTINE:   INTFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-06-79 @ 12:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS AN INTEGER NUMBER INTO A  *
C                   LEFT-JUSTIFIED CHARACTER STRING AND RETURNS THE    *
C                   NUMBER OF DIGITS CONTAINED WITHIN THE RETURNED     *
C                   CHARACTER STRING.                                  *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT_NUMBER:      NUMBER TO BE CONVERTED.                       *
C                                                                      *
C     OUTPUT_STRING:     OUTPUT CHARACTER STRING.                      *
C                                                                      *
C     LENGTH:            NUMBER OF VALID DIGITS IN OUTPUT_STRING.      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER MINUS            = '-'            ! NEGATIVE SIGN
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER TEN              = 10             ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(TEN) DIGITS
      CHARACTER*(*)   OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 DIGIT
      INTEGER*4 INPUT_NUMBER
      INTEGER*4 LENGTH
      INTEGER*4 LIMIT
      INTEGER*4 NUMBER
      INTEGER*4 UPPER_DIGITS
C----------------------------------------------------------------------*
C     DATA                                                             *
C----------------------------------------------------------------------*
      DATA DIGITS             / '0123456789'  /
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     CONVERT INPUT_NUMBER TO OUTPUT_STRING AND RETURN LENGTH          *
C----------------------------------------------------------------------*
  100 CONTINUE
      LENGTH=ONE
      LIMIT=LEN(OUTPUT_STRING)
      NUMBER=JIABS(INPUT_NUMBER)
      OUTPUT_STRING=BLANK

  110 CONTINUE
      UPPER_DIGITS=NUMBER/TEN
      DIGIT=NUMBER-(UPPER_DIGITS*TEN)+ONE
      NUMBER=UPPER_DIGITS
      OUTPUT_STRING=DIGITS(DIGIT:DIGIT)//OUTPUT_STRING
      
      IF ((NUMBER .EQ. ZERO) .OR. (LENGTH .EQ. LIMIT)) 
     1     GO TO 900
      
      LENGTH=LENGTH+ONE
      GO TO 110
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT SUBROUTINE RETURNING NUMERIC STRING AND NUMBER OF DIGITS    *
C----------------------------------------------------------------------*
  900 CONTINUE
      
      IF (INPUT_NUMBER .LT. ZERO) THEN
           OUTPUT_STRING=MINUS//OUTPUT_STRING
           LENGTH=JMIN0((LENGTH+ONE),LIMIT)
      END IF
C----------------------------------------------------------------------*
C     END OF SUBROUTINE INTFMT                                         *
C----------------------------------------------------------------------*
      RETURN
      END
      FUNCTION LENGTH(INPUT_STRING)
C----------------------------------------------------------------------*
C     FUNCTION:     LENGTH                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-02-79 @ 10:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE COMPUTES THE LOGICAL LENGTH OF A   *
C                   CHARACTER STRING BY RETURNING THE LAST NON-BLANK   *
C                   CHARACTER POSITION WITHIN THAT STRING.             *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     COLUMN:            COLUMN INDEX                                  *
C                                                                      *
C     INPUT_STRING:      STRING TO BE SEARCHED FOR LOGICAL LENGTH.     *
C                                                                      *
C     LENGTH:            LAST NON-BLANK CHARACTER WITHIN INPUT_STRING. *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER INPUT_STRING*(*)
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 COLUMN
      INTEGER*4 LENGTH
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     FIND THE LAST NON-BLANK CHARACTER IN INPUT_STRING                *
C----------------------------------------------------------------------*
  100 CONTINUE
      LENGTH=ZERO
   
      DO 110 COLUMN=LEN(INPUT_STRING),ONE,-ONE
      IF (INPUT_STRING(COLUMN:COLUMN) .NE. BLANK) THEN
           LENGTH=COLUMN
           GO TO 900
      END IF
  110 CONTINUE
C----------------------------------------------------------------------*
C     EXIT WITH LAST CHARACTER POSITION IN LENGTH                      *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF FUNCTION LENGTH                                           *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE METFMT(NUMBER,OUTPUT_STRING,SIGFIG)                
C----------------------------------------------------------------------*
C     SUBROUTINE:   METFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-25-79 @ 15:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS A NUMBER TO METRIC        *
C                   NOTATION CHARACTER FORMAT, AND RETURNS A CHARACTER *
C                   STRING CONTAINING THE RESULT OF THE CONVERSION.    *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT PARAMETERS                                                 *
C----------------------------------------------------------------------*
C     SUBROUTINE METFMT(NUMBER,OUTPUT_STRING,SIGFIG)                   *
C                                                                      *
C                                                                      *
C     NUMBER           - REAL*8 NUMBER TO BE CONVERTED TO METRIC       *
C                        NOTATION CHARACTER FORMAT                     *
C                                                                      *
C     OUTPUT_STRING    - DESTINATION BUFFER FOR CHARACTER OUTPUT.      *
C                        MUST BE OF TYPE CHARACTER.                    *
C                                                                      *
C     SIGFIG           - NUMBER OF SIGNIFICANT FIGURES TO BE DISPLAYED *
C                        IF SIGFIG < 3 THIS ROUTINE MAY BE EXPECTED    *
C                        TO OUTPUT AS MANY SIGNIFICANT FIGURES FIGURES *
C                        AS NEEDED TO MAINTAIN A VALID METRIC          *
C                        NOTATION REPRESENTATION.                      *
C                                                                      *
C                        NOTE:  TOTAL OUTPUT WIDTH IS SIGFIG+5         *
C----------------------------------------------------------------------*
C     INTERNAL VARIABLES                                               *
C----------------------------------------------------------------------*
C     DIGITS           - ACTUAL NUMBER OF SIGNIFICANT FIGURES PRINTED  *
C                                                                      *
C     INDEX            - POWER-OF-TEN INDEX FOR METRIC PREFIX          *
C                                                                      *
C     LEFT_DIGITS      - NUMBER OF DIGITS TO THE LEFT OF THE DECIMAL   *
C                                                                      *
C     OUTPUT_WIDTH     - NUMBER OF CHARACTERS MOVED TO OUTPUT_STRING   *
C                                                                      *
C     PREFIX           - METRIC PREFIX DATA TABLE                      *
C                                                                      *
C     RIGHT_DIGITS     - NUMBER OF DIGITS TO THE RIGHT OF THE DECIMAL  *
C                                                                      *
C     SCALE            - METRIC SCALE FACTORS DATA TABLE               *
C                                                                      *
C     TEMP_TEST        - SCALED 'NUMBER' USED FOR TEST PURPOSES        *
C                                                                      *
C     TEMP_VALUE       - SCALED 'NUMBER' USED FOR OUTPUT PURPOSES      *
C                                                                      *
C     WIDTH            - OUTPUT FLOATING POINT FIELD WIDTH             *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! SPACE CHARACTER
      PARAMETER FIVE             = 5              ! SIGFIG OVERHEAD
      PARAMETER LIMIT_DIGITS     = 15             ! LIMIT ON SIGFIG
      PARAMETER NULL             = 6              ! NULL INDEX:  NO PREFIX
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER TEN              = 10             ! METRIC INDEX OFFSET
      PARAMETER THREE            = 3              ! USEFUL CONSTANT
      PARAMETER TWO              = 2              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) OUTPUT_STRING
      CHARACTER*(THREE) PREFIX(TEN)
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 DIGITS   
      INTEGER*4 I
      INTEGER*4 INDEX    
      INTEGER*4 LEFT_DIGITS   
      INTEGER*4 OUTPUT_WIDTH   
      INTEGER*4 RIGHT_DIGITS   
      INTEGER*4 SIGFIG   
      INTEGER*4 WIDTH    
C----------------------------------------------------------------------*
C     REAL*8                                                           *
C----------------------------------------------------------------------*
      REAL*8 NUMBER           
      REAL*8 SCALE            
      REAL*8 TEMP_TEST           
      REAL*8 TEMP_VALUE           
C----------------------------------------------------------------------*
C     DIMENSION                                                        *
C----------------------------------------------------------------------*
      DIMENSION SCALE (0013)
C----------------------------------------------------------------------*
C     DATA                                                             *
C----------------------------------------------------------------------*
      DATA PREFIX            / 'F  ', 'P  ', 'N  ', 'U  ', 'M  ',
     1                         '   ', 'K  ', 'MEG', 'G  ', 'T  ' /
      DATA SCALE             / +1.0D-15, +1.0D-12, +1.0D-09, +1.0D-06,  
     1                         +1.0D-03, +1.0D+00, +1.0D+03, +1.0D+06,
     2                         +1.0D+09, +1.0D+12, +1.0D+01, +1.0D+02,
     3                         +1.0D+03  /
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     COMPUTE PREFIX EXPONENT                                          *
C----------------------------------------------------------------------*
  100 CONTINUE          
      TEMP_VALUE=ABS(NUMBER)

      DO 110 I=TWO,(TEN+ONE)
      INDEX=I-ONE         
      IF (TEMP_VALUE .LT. SCALE(I)) GO TO 200           
  110 CONTINUE          
C----------------------------------------------------------------------*
C     SECTION 200                                                      *
C----------------------------------------------------------------------*
C     DETERMINE THE NUMBER OF DIGITS TO THE LEFT OF THE DECIMAL POINT  *
C----------------------------------------------------------------------*
  200 CONTINUE      
      IF (NUMBER .EQ. ZERO) INDEX=NULL  
      TEMP_VALUE=NUMBER/SCALE(INDEX)        
      TEMP_TEST=ABS(TEMP_VALUE)                

      DO 210 I=ONE,THREE  
      LEFT_DIGITS=I      
      IF (TEMP_TEST .LT. SCALE(I+TEN)) GO TO 300                
  210 CONTINUE      
C----------------------------------------------------------------------*
C     SECTION 300                                                      *
C----------------------------------------------------------------------*
C     PRODUCE A CHARACTER STRING REPRESENTATION OF 'NUMBER' IN         *
C     ENGINEERING NOTATION FORMAT, THEN APPEND METRIC PREFIX.          *
C----------------------------------------------------------------------*
  300 CONTINUE
      DIGITS=JMIN0(SIGFIG,LIMIT_DIGITS)
      IF (DIGITS .LT. LEFT_DIGITS) DIGITS=LEFT_DIGITS
      RIGHT_DIGITS=DIGITS-LEFT_DIGITS
      OUTPUT_WIDTH=DIGITS+FIVE
      WIDTH=DIGITS+TWO
      OUTPUT_STRING=BLANK
      ENCODE(OUTPUT_WIDTH,3000,OUTPUT_STRING) TEMP_VALUE,PREFIX(INDEX)
      IF (RIGHT_DIGITS .EQ. ZERO)
     1     OUTPUT_STRING(LEFT_DIGITS+TWO:LEFT_DIGITS+TWO)=BLANK
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 3000 FORMAT(F<WIDTH>.<RIGHT_DIGITS>,A3)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE METFMT                                         *
C----------------------------------------------------------------------*
      RETURN                                                                    
      END                                                                       
      SUBROUTINE OCTFMT(INPUT_NUMBER,OUTPUT_STRING,SIGFIG)
C----------------------------------------------------------------------*
C     SUBROUTINE:   OCTFMT                                             *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         07-18-80 @ 11:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS SUBROUTINE CONVERTS AN INTEGER NUMBER INTO    *
C                   AN OCTAL CHARACTER STRING WITH 'SIGFIG' NUMBER     *
C                   OF OCTAL DIGITS, LEFT-JUSTIFIED AND ZERO FILLED.   *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     INPUT_NUMBER:      NUMBER TO BE CONVERTED.                       *
C                                                                      *
C     OUTPUT_STRING:     OUTPUT CHARACTER STRING.                      *
C                                                                      *
C     SIGFIG:            NUMBER OF VALID DIGITS IN OUTPUT_STRING.      *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER BLANK            = ' '            ! DEFINE SPACE CHARACTER
      PARAMETER MAXOCT           = 11             ! MAX # OF OCTAL DIGITS 
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
      PARAMETER ZEROFILL         = '0'            ! ZERO FILL OUTPUT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*)   OUTPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 INPUT_NUMBER
      INTEGER*4 SIGFIG
      INTEGER*4 LIMIT
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     CONVERT INPUT_NUMBER TO OUTPUT_STRING AND RETURN SIGFIG          *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=JMIN0(LEN(OUTPUT_STRING),MAXOCT)
      IF (LIMIT .EQ. ZERO) GO TO 900
  
      IF ((SIGFIG .LE. ZERO) .OR. (SIGFIG .GT. LIMIT)) SIGFIG=LIMIT

      OUTPUT_STRING=BLANK
      ENCODE (SIGFIG,1000,OUTPUT_STRING,ERR=900) INPUT_NUMBER
C----------------------------------------------------------------------*
C     SECTION 200                                                      *
C----------------------------------------------------------------------*
C     ZERO FILL HEXADECIMAL FIELD BEFORE RETURNING TO USER             *
C----------------------------------------------------------------------*
  200 CONTINUE
      
      DO 210 POINTER=ONE,SIGFIG
      IF (OUTPUT_STRING(POINTER:POINTER) .NE. BLANK) GO TO 900
      OUTPUT_STRING(POINTER:POINTER)=ZEROFILL
  210 CONTINUE
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     SUBROUTINE TERMINATION                                           *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     FORMATS                                                          *
C----------------------------------------------------------------------*
 1000 FORMAT(O<SIGFIG>)
C----------------------------------------------------------------------*
C     END OF SUBROUTINE OCTFMT                                         *
C----------------------------------------------------------------------*
      RETURN
      END
      FUNCTION PARSE(SEARCH_LIST,LIST_START,LIST_LENGTH,SEARCH_STRING)
C----------------------------------------------------------------------*
C     FUNCTION:     PARSE                                              *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-23-79 @ 17:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS FUNCTION PERFORMS RUDIMENTARY STRING PARSING  *
C                   BY SEARCHING A MASTER LIST OF CHARACTER STRINGS    *
C                   FOR A MATCH BASED ON A SEARCH STRING.  THE VALUE   *
C                   RETURNED BY THE FUNCTION IS THE POINTER TO THE     *
C                   MATCHING CHARACTER STRING IN THE SEARCH LIST.      *
C                   IF NO MATCH IS FOUND, ZERO IS RETURNED.            *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     SEARCH_LIST:       CHARACTER ARRAY TO BE SEARCHED FOR AN         *
C                        OCCURRANCE OF 'SEARCH_STRING'                 *
C                                                                      *
C     LIST_START:        STARTING SEARCH INDEX FOR SEARCH_LIST ARRAY   *
C                                                                      *
C     LIST_LENGTH:       NUMBER OF ENTRIES IN THE SEARCH LIST TO BE    *
C                        SCANNED FOR A POSSIBLE MATCH WITH THE         *
C                        SEARCH STRING                                 *
C                                                                      *
C     SEARCH_STRING:     CHARACTER STRING TO BE SEARCHED FOR IN THE    *
C                        SEARCH LIST                                   *
C                                                                      *
C     PARSE:             RETURNS THE INDEX OF THE FIRST OCCURRANCE OF  *
C                        'SEARCH_STRING' IN 'SEARCH_LIST'              *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER ONE              = 1              ! USEFUL CONSTANT
      PARAMETER ZERO             = 0              ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) SEARCH_LIST    (ONE)
      CHARACTER*(*) SEARCH_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 LIMIT
      INTEGER*4 LIST_INDEX
      INTEGER*4 LIST_LENGTH
      INTEGER*4 LIST_POINTER
      INTEGER*4 LIST_START
      INTEGER*4 PARSE
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     SEARCH FOR STRING IN STRING LIST AND RETURN POINTER OF MATCH     *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=JMIN0(LEN(SEARCH_LIST(ONE)),LEN(SEARCH_STRING))
      
      IF (LIMIT .NE. ZERO) THEN

           DO 110 LIST_INDEX=LIST_START,(LIST_START+LIST_LENGTH-ONE)
           LIST_POINTER=LIST_INDEX
           IF (SEARCH_LIST(LIST_INDEX)(ONE:LIMIT) .EQ. 
     1          SEARCH_STRING(ONE:LIMIT)) GO TO 900
  110      CONTINUE

      END IF

      LIST_POINTER=ZERO
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT FUNCTION PARSE                                              *
C----------------------------------------------------------------------*
  900 CONTINUE
      PARSE=LIST_POINTER
C----------------------------------------------------------------------*
C     END OF FUNCTION PARSE                                            *
C----------------------------------------------------------------------*
      RETURN
      END
      SUBROUTINE UPPER_CASE(INPUT_STRING)
C----------------------------------------------------------------------*
C     SUBROUTINE:   UPPER_CASE                                         *
C----------------------------------------------------------------------*
C     LANGUAGE:     VAX-11 FORTRAN IV PLUS 01                          *
C     SYSTEM:       VAX-11/780                                         *
C                   MOSTEK CORPORATION                                 *
C                   COMPUTER AIDS TO DESIGN DEPARTMENT                 *
C                   1215 WEST CROSBY ROAD                              *
C                   CARROLLTON, TEXAS  75006                           *
C                   (214)  323-8813                                    *
C----------------------------------------------------------------------*
C     PROGRAMMER:   KEVIN KLUGHART                                     *
C----------------------------------------------------------------------*
C     DATE:         08-01-79 @ 09:00 CDST                              *
C----------------------------------------------------------------------*
C     PURPOSE:      THIS ROUTINE STRIPS THE PARITY BITS AND CONVERTS   *
C                   LOWER-CASE TO UPPER-CASE CHARACTERS IN THE PASSED  *
C                   CHARACTER STRING INPUT_STRING.                     *
C----------------------------------------------------------------------*
C     VARIABLE MAP                                                     *
C----------------------------------------------------------------------*
C     ASCII_CODE:        NUMERIC CHARACTER CODE OF CURRENT CHARACTER   *
C                                                                      *
C     COLUMN:            COLUMN INDEX                                  *
C                                                                      *
C     INPUT_STRING:      CHARACTER STRING TO BE CONVERTED TO PARITY-   *
C                        STRIPPED UPPER-CASE ONLY CHARACTERS           *
C                                                                      *
C     LIMIT:             NUMBER OF CHARACTERS TO BE CONVERTED          *
C----------------------------------------------------------------------*
C     PARAMETERS                                                       *
C----------------------------------------------------------------------*
      PARAMETER ALPHA_HI         = '7B'X          ! UPPER ALPHA ASCII LIMIT
      PARAMETER ALPHA_LO         = '60'X          ! LOWER ALPHA ASCII LIMIT
      PARAMETER ALPHA_OFFSET     = '20'X          ! ALPHA LOWERCASE OFFSET
      PARAMETER ONE              = '01'X          ! USEFUL CONSTANT
      PARAMETER STRIP_PARITY     = '7F'X          ! PARITY BIT MASK
      PARAMETER ZERO             = '00'X          ! USEFUL CONSTANT
C----------------------------------------------------------------------*
C     CHARACTER                                                        *
C----------------------------------------------------------------------*
      CHARACTER*(*) INPUT_STRING
C----------------------------------------------------------------------*
C     INTEGER*4                                                        *
C----------------------------------------------------------------------*
      INTEGER*4 ASCII_CODE
      INTEGER*4 COLUMN
      INTEGER*4 LIMIT
C----------------------------------------------------------------------*
C     SECTION 100                                                      *
C----------------------------------------------------------------------*
C     STRIP PARITY BIT AND SHIFT LOWER-CASE TO UPPER-CASE CHARACTERS   *
C----------------------------------------------------------------------*
  100 CONTINUE
      LIMIT=LEN(INPUT_STRING)
      IF (LIMIT .EQ. ZERO) GO TO 900

      DO 110 COLUMN=ONE,LIMIT
      ASCII_CODE=JIAND(ICHAR(INPUT_STRING(COLUMN:COLUMN)),STRIP_PARITY)
      IF ((ASCII_CODE .GT. ALPHA_LO) .AND. (ASCII_CODE .LT. ALPHA_HI))
     1     ASCII_CODE=ASCII_CODE-ALPHA_OFFSET
      INPUT_STRING(COLUMN:COLUMN)=CHAR(ASCII_CODE)
  110 CONTINUE
C----------------------------------------------------------------------*
C     SECTION 900                                                      *
C----------------------------------------------------------------------*
C     EXIT SUBROUTINE UPPER_CASE                                       *
C----------------------------------------------------------------------*
  900 CONTINUE
C----------------------------------------------------------------------*
C     END OF SUBROUTINE UPPER_CASE                                     *
C----------------------------------------------------------------------*
      RETURN
      END
