
{***********************************************************************

 NOTE: This file for use with build PRM modules only.  User's can find
       all necessary CONST, TYPE and PROCEDURE calls in PRMPREFIX.PAS.

 *********************************************************************** }
  
CONST
  NameSize	= 30 ;		{ sz of input file name, do not alter }

  { example labels and sizes follow - user defines buffer sizes and labels }
  KeyXSize	= 8 ;		{ user defines size of largest key }
  KeyYSize	= 6 ;		{ user defines these labels and sizes }  

TYPE

  { following record is for example only }
  RecDef = RECORD	{ user defines field names and sizes }
    CASE integer OF	
      1 : (FXDat1 : ARRAY [1..10] OF CHAR ;
           FXDat2 : integer ) ;
      2 : (FYItem1 : ARRAY [1..30] OF CHAR ;
           FYItem2 : REAL ) ;
    END ;	{ User Defined Record }


  TwoWord	= ARRAY [1..2] OF integer ;	{ record number size }
  KeyDef	= RECORD
    CASE integer OF	{ user defines keylabels and sizes, as many as req. }
      1 : ( KeyX : ARRAY [1..KeyXSize] OF CHAR) ;
      2 : ( KeyY : ARRAY [1..KeyYSize] OF CHAR) ;
      3 : ( RNum : TwoWord ) ;    { use this def. of relative rec. # if req. }
    END ;

  RmsFileName	= ARRAY [1..NameSize] OF CHAR ;	{ file name, do not alter }
  RmsStatus	= ARRAY [1..2] OF integer ;	{ returned rms status codes }

  {    The following record holds the file being descibed with options
   selected by the user.  Space for this buffer is allocated in the user
   area.  Rab and Fab for the file is allocated within this buffer.  The
   address of this buffer is initially passed to Open then passed with 
   all record operations (get, put, update, delete, find and close) so 
   the routines know what file the operation is being performed on.
  }
  OrgTypes	= (SEQ,REL,IDX) ;	{ block i/o not supported }
  AllowTypes	= (Share,NoShare) ;      { what others can do }
  AccessTypes	= (PRead,PWrite,PBoth) ; { what you can do to the file }
  FormType = (FFIX,FVAR,FSTREAM) ;	{ record format type }

  { specify file options, if field not altered, default will be selected }
  RmsFileDesc	= RECORD
    { -- Use with PRMOPE to define an existing file to be opened  -- }
    Org		: OrgTypes ;	{ spec. file type, no default }
    FileName	: RmsFileName ;	{ full spec. of rms file, no default }
    LogChan	: integer ;	{ spec. ch. n, no def., n<= TKB UNITS=n }
    Allow	: AllowTypes ;	{ what others may do with file, def Noshare }
    Access	: AccessTypes ;	{ what you may do to the file, default Read }
    RecordSize  : INTEGER ;	{ spec. max. file rec. sz, user rec. buf can 
      be < full, spec. bytes to xfer with recsize in Ret & StoRecord buffers }
    Windows	: INTEGER ;	{ no. of ret. windows, default usually 7 }

    { enable the following options with a capital "Y", any other = default }
    DeferWrite	: CHAR ;	{ IDX, defer write, def. write each record }
    Unlock    	: CHAR ;  	{ do not lock file if prg. bombs, def. "L" }
    ObeyFill	: CHAR ;	{ obey bucket fill numbers, def. fill to max }
    MassInsert	: CHAR ;	{ IDX, ref. rms-11 macro ref. man. rab rop }
    FileEnd	: CHAR ;	{ SEQ only, place file stream at end of file }

    { file creation fields }
    RecForm	: FormType ;	{ rec. format, FSTREAM for seq., Def.= FFix }
    Allocation  : TwoWord ;	{ no. blocks allocated to file, def. 0 blks }
    BucketSize	: integer ;	{ data bucket size, default size 1 bucket }
    ExtQua	: integer ;	{ no. blks dynamic extend file, default 1}
    { Enable following with capital "Y", if not loaded, default is selected }
    Contiguous	: CHAR ;	{ create a contiguous file, Def. fragmented }
    Temporary	: char ;	{ delete the file when closed, def. no del. }

    Fab		: FabRec ;	{ array [1..80] of char for user prg.}
    Rab		: RabRec 	{ array [1..80] of char for user prg.}
  END ;	{ RmsFileDesc Record }


  SearchTypes	= (EQ,GT,GE,RFA,NEX,REC) ; { for GET use KeyData(EQ'=',GT'>',
                    GE'>='), RFA, next seq. rec(NEX) or Rec. # (org=REL) }
  ThreeWord	= ARRAY [1..3] OF Integer ;	{ for RFA's, big file huh }
  RecOps	= (PGET,PFIND,PPUT,PUPDATE) ;
  RetRecord = RECORD
    { - USE with PRMRET, INPUT - to GET and FIND - INPUT/OUTPUT ref. to PRM }
    KeyNum	: Threeword ;	{ INPUT- IDX Key # or RFA, search defines }
    Search	: SearchTypes ;	{ INPUT - spec. search opr }
    RecSize	: integer ;	{ INPUT - sz rec. to GET, (sz of rec. buffer)
                                  OUTPUT- sz rec. returned to user rec. buf }
    RFAout	: ThreeWord ;	{ OUTPUT- valid if search <> RFA }
    KeySize	: integer ;	{ INPUT - size of key data, <= full key size }
    KeyData	: KeyDef ;	{ INPUT - IDX or REL, key string or rec. # }
  END ;	{ RetRecord RECORD Definition }

  StoRecord = RECORD
      { USE with PRMSTO, Input to PUT and UPDATE - INPUT/OUTPUT ref. to PRM }
      RecSize	: integer ;	{ INPUT - spec. part or all or rec. buffer 
                                  data to be stored, <= full rec. sz }
      RFAOut	: ThreeWord ;	{ OUTPUT - rfa where record was stored }
      Key	: KeyDef ;	{ INPUT - REL ONLY, spec. rec. # for store }
    END ;	{ StoRecord Record }

  KType = (StrKey,IntKey) ;	{ string or unsigned integer key type }
  IdxKeyDesc = RECORD	{ used with prmkey to define key of indexed file }
                        { use prior to PrmCre of an indexed file type }
      KeyNum	: Integer ;	{ key of ref. #, def. asc. order, start 0 }
      KeyPos	: Integer ;	{ byte position of key in rec., start byte 0 }
      KeySiz	: Integer ;	{ size of the key defining, max. = 255 }
      KeyTyp	: KType ;	{ string or unsigned integer, def.=string }
      KeyDup	: char ;	{ 'Y' to allow duplicate keys, def. no dup }
      KeyChg	: char ;	{ 'Y' for key changes, alt. only, def no chg }
      KeyNul	: char ;	{ null key value, alt. string keys only }
    END ;	{ IdxKeyDesc }

