.ENABLE SUBSTITUTION
.SETS UIC <UIC>
;
; Build and Assemble Concantenated Executive.
;
; This command file creates and assembles a concantenated RSX-11M
; executive.  The command file requires the following files to be
; present in SY0:'UIC'.
;
;	STEP1.TEC	Phase 1 Teco command file
;	STEP2.TEC	Phase 2 Teco command file
;	MACRO.MAC	Initial concantenated source
;	C5TA.MAC	Fake C5TA source module
;
; In addition, the following files from the system generation must
; be present in SY0:'UIC'.
;
;	RSXBLD.CMD	Task Build command file
;	RSXMC.MAC	Configuration prefix file
;	SYSTB.MAC	Device table source file
;
; Finally, psuedo device IN: must be assigned to the disk containing
; the executive sources. The sources are assumed to be in [11,10].
; The executive library file is assumed to be in LB:[1,1]EXEMC.MLB.
; Also, the tasks TEC, PIP, MAC, and CRF must be installed. If all
; is correct, answer the next question 'YES'. Otherwise, the command
; file will pause and allow you complete the necessary setup.
;
.ASK FLAG CONTINUE WITH FILE
.IFF FLAG .PAUSE
;
; Create PIP command file from RSXBLD.CMD and copy executive.
;
TEC @STEP1.TEC
@RSXPIP.CMD
;
; Format RSX11M.MAC into correct form.
;
TEC @STEP2.TEC
;
; Assemble executive, getting list and cref.
;
MAC ,RSX11M/-SP/CR=LB0:[1,1]EXEMC/ML,SY0:'UIC'RSXMC/PA:1,RSX11M
;
; Waiting on CREF to finish.
;
.WAIT CRF...
;
; All done.
;
