#-h- cls              614  asc  29-apr-81 19:42:30  [002,100]
 common / cls / verbos, dodate, revers, sortit, dirsw,
		dohead, packit, scrat(FILENAMESIZE)

 integer verbos		# verbose switch - init NO; set by -vt
 integer dodate		# dodate switch - init NO ; set by -t
 integer revers		# revers switch - init NO ; set by -r
 integer sortit		# if need to sort entries ; init SORTBYDEFAULT
			# sortit is set to YES if (dodate == YES |
			# revers == YES)
 integer dirsw		# do directory switch - init NO; set by -d
 integer dohead		# print header on verbose listings; init = NO
 integer packit		# pack non-verbose files in 5 columns; init=YES
 character scrat	# scratch file name
#-h- ls.r            5056  asc  29-apr-81 19:42:32  [002,100]
#-h- defns            279  asc  23-apr-81 12:24:40  [002,102]
 define(FCOLWIDTH,18)
 define(SORTBYDEFAULT,NO)
 define(FLMAX,10)
define(HEADER_LINE_1,"filename            protection      last modified     size   owner@n")
define(HEADER_LINE_2,"--------          --------------  ----------------- -------  -----@n@n")
 define(RIGHT_MARGIN,80)
#-h- main            2673  asc  23-apr-81 12:24:42  [002,102]
 DRIVER(ls)

 integer level, opendr, desc, depth, ptr(MAXDIRECTS), j, getpat, outfil,
	 create, gdrprm, i, length, match, n, open, getlin, getarg,
	 status, nxtcol
 character ppath(FILENAMESIZE), defpat(2), file(FILENAMESIZE),
	   buf(MAXLINE), pat(132), obuf(MAXLINE)

 include cls

 string dirpat "?*/"
 string head1 HEADER_LINE_1
 string head2 HEADER_LINE_2

 data defpat/PERCENT, EOS/

 call initls(file)
 level = 0
 if (dohead == YES)
    {
    call putlin(head1, STDOUT)
    call putlin(head2, STDOUT)
    }
 if (packit == YES)
    call inpack(nxtcol, RIGHT_MARGIN, obuf, STDOUT)
 repeat
    {
    level = level + 1
    status = getarg(level, ppath, FILENAMESIZE)
    if (status == EOF & level > 1)
	break
    else if (status == EOF)
	call gwdir(ppath, PATH)
    call scopy(defpat, 1, file, 1)
    if (opendr(ppath, desc) == ERR)
	{
	call scopy(ppath, 1, buf, 1)
	call mkpath(buf, ppath)
	call exppth(ppath, depth, ptr, buf)
	j = ptr(depth)
	junk = gtftok(ppath, j, file)
	j = ptr(depth)
	ppath(j) = EOS
	if (opendr(ppath, desc) == ERR)
	    call cant(ppath)
	}
    if (dirsw == YES)
	call concat(file, dirpat, file)
    call fold(file)
    if (getpat(file, pat) == ERR)
	call error("Illegal pattern.")
    if (sortit == YES)
	{
	outfil = create(scrat, WRITE)
	if (outfil == ERR)
	    call error("Error creating temporary file.")
	}
    else
	outfil = STDOUT
    while (gdrprm(desc, file) != EOF)
	{
	i = length(file) + 1
	file(i) = NEWLINE
	file(i+1) = EOS
	call fold(file)
	if (match(file, pat) == YES)
	    {
	    i = length(file)
	    file(i) = EOS
	    if (packit == YES & outfil == STDOUT)
		call dopack(file, nxtcol, RIGHT_MARGIN, obuf, STDOUT)
	    else
		{
		if (verbos == YES)
		    {
		    call gdraux(desc, file, buf, ppath)
		    if (dodate == YES)
		        call putlin(ppath, outfil)
		    call putlin(file, outfil)
		    n = FCOLWIDTH - length(file)
		    for (i=1; i <= n; i=i+1)
		        call putch(BLANK, outfil)
		    call putlin(buf, outfil)
		    }
		else
		    call putlin(file, outfil)
		call putch(NEWLINE, outfil)
		}
	    }
	}
    call closdr(desc)
    if (sortit == YES)
	{
	call close(outfil)
	call sortls(scrat, revers, buf)
	outfil = open(scrat, READ)
	if (outfil == ERR)
	    call error("Error in opening sorted scratch file.")
	while (getlin(buf, outfil) != EOF)
	    {
	    if (dodate == YES)
		i = TCOLWIDTH + 1
	    else
		i = 1
	    if (packit == YES)
		{
		i = 1
		junk = getwrd(buf, i, file)
		call dopack(file, nxtcol, RIGHT_MARGIN, obuf, STDOUT)
		}
	    else
		call putlin(buf(i), STDOUT)
	    }
	call close(outfil)
	}
    if (packit == YES)
	call flpack(nxtcol, RIGHT_MARGIN, obuf, STDOUT)
    }
 call endls

 DRETURN
 end
#-h- endls             67  asc  23-apr-81 12:24:45  [002,102]
 subroutine endls

 include cls

 call remove(scrat)

 return
 end
#-h- initls          1027  asc  23-apr-81 12:24:46  [002,102]
 subroutine initls(arg)

 integer i, getarg, index, isatty
 character arg(FILENAMESIZE)

 include cls

string usestr "usage:  ls [-1dhnrtv] [path]..."

 call query(usestr)
 verbos = NO
 dohead = NO
 dodate = NO
 revers = NO
 dirsw = NO
 packit = isatty(STDOUT)
 sortit = SORTBYDEFAULT
 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    call fold(arg)
    if (arg(1) == MINUS)
	{
	if (index(arg, LETV) > 0)
	    verbos = YES
	if (index(arg, LETH) > 0)
	    dohead = YES
	if (index(arg, LETT) > 0)
	    dodate = YES
	if (index(arg, LETR) > 0)
	    revers = YES
	if (index(arg, LETN) > 0 & SORTBYDEFAULT == NO)
	    sortit = YES		# sort by name
	if (index(arg, LETD) > 0)
	    dirsw = YES
	if (index(arg, DIG1) > 0)
	    packit = NO
	call delarg(i)
	i = i + 1
	}
    }
 if (dodate == YES)
    verbos = YES
 if (dodate == YES | revers == YES)
    sortit = YES
 if (verbos == NO)
    dohead = NO
 else
    packit = NO		# packing impossible in verbose mode
 if (sortit == YES)
    call scratf(ls0, scrat)

 return
 end
#-h- sortls           700  asc  29-apr-81 19:39:49  [002,100]
 subroutine sortls(file, revers, buf)

 character file(ARB), descr(PIDSIZE), buf(ARB),
	   proc(FILENAMESIZE), spath(arith(FILENAMESIZE,*,3))
 integer revers, i, spawn, loccom

 string suffix IMAGE_SUFFIX
 string pluso " +o"
 string mr " -r"
 string sort "sort"

 i = 1
 call stcopy(sort, 1, buf, i)
 call chcopy(BLANK, buf, i)
 call stcopy(file, 1, buf, i)
 call stcopy(pluso, 1, buf, i)
 call stcopy(file, 1, buf, i)
 if (revers == YES)
    call stcopy(mr, 1, buf, i)
 buf(i) = EOS
 call impath(spath)
 if (loccom(sort, spath, suffix, proc) != BINARY)
    call error("Cannot locate sort image file.")
 if (spawn(proc, buf, descr, WAIT) == ERR)
    call error("error in spawning sort")
 return
 end
#-h- ls.rof          1354  asc  08-may-81 16:41:35  [002,100]
.pl 60
.in 5
.rm 70
.he /LS/%/LS/
.fo //-#-/
.bp 1
.in +3
.ti -3
NAME

ls
- list contents of directory

.ti -3
SYNOPSIS

ls [-1dhnrtv] [pathname] ...

.ti -3
DESCRIPTION

ls
lists information about each file argument.  When no argument is given, the
default directory is listed.  The file arguments
may include any of the legal regular expressions described in the man entry
for the editor, with the added feature that the comparisons will be case
insensitive.
By default, the files are listed
in the order in which they are found in the directory.  There
are six options:

.in +3
.ti -3
-1 force single column output to the terminal.  The default is multi-column
output to the terminal, single to a disk file.
.ti -3
-d print only directory files found in this directory
.ti -3
-h print a header at the top of verbose listings
.ti -3
-n sort the directory by name
.ti -3
-v
list in verbose format
.ti -3
-t
sort by time modified (oldest first)
.ti -3
-r
reverse the sense of the sort

.in -3
As an example of usage of ls, the following command will cause all of
the files which contain the string tst anywhere in the file name to be
deleted:

.in +3
% ls tst | args rm
.in -3

.ti -3
FILES

lstemp1, lstemp2

.ti -3
AUTHOR

Joe Sventek wrote ls.

.ti -3
SEE ALSO

ed - text editor for description of regular expressions
.br
args - argument exploder
.br
