#-h- cgrep            412  asc  27-apr-81 15:51:54  [002,100]
# cgrep - common block for grep
# place on a file named cgrep
# used only by grep
 common / cgrep / count, header, list, except

 integer count	# if grep is to count matches, only; init = NO
 integer header # if grep is display file header; init = YES
 integer list   # if grep is to only list files with at least on match; init=NO
 integer except # if grep is to use line which do not match expression; init=NO
#-h- grep.r          2335  asc  27-apr-81 15:51:55  [002,100]
#-h- defns             19  asc  27-apr-81 15:50:14  [002,100]
define(NUMWIDTH,6)
#-h- main            1190  asc  27-apr-81 15:50:15  [002,100]
DRIVER(grep)

integer exprst, i, j
integer getarg, index, getpat, equal

filedes fd
filedes open

character arg(MAXARG), pat(MAXPAT)

include cgrep

string usestr "usage:  grep [-chlx] expression [file ...]"
string illmsg "illegal pattern: "
string minust "-"
string stdins "stdin"

call query(usestr)
count = NO
header = YES
list = NO
except = NO
if (getarg(1, arg, MAXARG) == EOF)
  call error(usestr)
else if (arg(1) == MINUS)
  {
  exprst = 2
  call fold(arg)
  if (index(arg, LETC) > 0)
    count = YES
  if (index(arg, LETH) > 0)
    header = NO
  if (index(arg, LETL) > 0)
    list = YES
  if (index(arg, LETX) > 0)
    except = YES
  }
else
  exprst = 1
if (getarg(exprst, arg, MAXARG) == EOF)
  call error(usestr)
else if (getpat(arg, pat) == ERR)
  {
  call putlin(illmsg, ERROUT)
  call error(arg)
  }
for ([i=1; j=exprst+1]; getarg(j, arg, MAXARG) != EOF; [i=i+1; j=j+1])
  {
  if (equal(arg, minust) == YES)
    {
    fd = STDIN
    call strcpy(stdins, arg)
    }
  else
    {
    fd = open(arg, READ)
    if (fd == ERR)
      call cant(arg)
    }
  call dogrep(fd, arg, pat)
  if (fd != STDIN)
    call close(fd)
  }
if (i == 1)
  call dogrep(STDIN, stdins, pat)

DRETURN
end
#-h- dogrep           940  asc  27-apr-81 15:50:16  [002,100]
subroutine dogrep(fd, file, pat)

filedes fd

integer mcount, matchd
integer getlin, match

character file(FILENAMESIZE), pat(MAXPAT), line(MAXLINE)

include cgrep

mcount = 0
while (getlin(line, fd) != EOF)
  {
  matchd = match(line, pat)
  if ((matchd == YES & except == NO) | (matchd == NO & except == YES))
    {
    mcount = mcount + 1
    if (mcount == 1 & count == NO)
      if (list == YES)		# only list files
        {
        call putlin(file, STDOUT)
        call putch(NEWLINE, STDOUT)
        return
        }
      else if (header == YES)
        {
        call putch(NEWLINE, STDOUT)
        call putlin(file, STDOUT)
        call putch(COLON, STDOUT)
        call putch(NEWLINE, STDOUT)
        }
    if (count == NO)
      call putlin(line, STDOUT)
    }
  }
if (count == YES)
  {
  call putint(mcount, NUMWIDTH, STDOUT)
  call putch(BLANK, STDOUT)
  call putlin(file, STDOUT)
  call putch(NEWLINE, STDOUT)
  }

return
end
#-h- grep.rof        1320  asc  11-may-81 11:48:39  [002,100]
.bp 
.pl 60
.rm 70 
.in 0 
.he 'GREP'5/2/81'GREP'
.fo ''-#-' 
.fi 
.in +7
.ti -7
NAME 
.br
grep - search file[s] for a pattern
.sp 1 
.ti -7
SYNOPSIS 
.br
grep [-chlx] expression [file] ...
.sp 1 
.ti -7
DESCRIPTION 
.br
`grep' searches the names files (or standard input if none
are specified) for occurrences of the expression.  The set of valid
expressions are the same as those for `find', `ch' and `ed'.  The
manual entries for those tools may be consulted for full details.
The output of `grep' is dependent upon which switches are selected:
.sp
.in +5
.ti -5
None When one or more occurrences of the expression are found in a file,
the file name is displayed, with each line in which the expression occurs
listed below the file name.
.sp
.ti -3
-c Only the number of matching lines in each file is displayed.
.sp
.ti -3
-h Do not display the file names.
.sp
.ti -3
-l Only the names of files which contain matching lines are displayed, one
per line.
.sp
.ti -3
-x Display (or count) only those lines which do NOT contain the expression.
.in -5
.sp 1
.ti -7
FILES 
.br
None
.sp 1 
.ti -7
SEE ALSO 
.br
.nf
find - find groups of expressions in a file
ch - globally change expressions within a file
ed - text editor
.fi
.sp 1 
.ti -7
DIAGNOSTICS 
.br

.sp 1 
.ti -7
AUTHORS 
.br
Joe Sventek
.sp 1 
.ti -7
BUGS 
.br

