#-h- d.r             1935  asc  08-apr-81 10:02:31  [002,101]
#-h- defns            132  asc  08-apr-81 10:02:20  [002,101]
# definitions for d, the in-memory sorted directory lister
 define(RIGHT_MARGIN,80)
 define(MEM_SIZE,5000)
 define(AVE_TOK_SIZE,12)
#-h- main            1679  asc  08-apr-81 10:02:20  [002,101]
# main routine for d - in-memory sorted directory lister
 DRIVER(d)

 integer level, desc, depth, ptr(MAXDIRECTS), j, i, status, nxtcol,
	 junk
 integer opendr, getpat, gdrprm, length, match, getarg, gtftok,
	 imput, imget
 character ppath(FILENAMESIZE), file(FILENAMESIZE),
	   buf(FILENAMESIZE), pat(132), obuf(MAXLINE)
 DS_DECL(mem, MEM_SIZE)

 pointer sarray
 pointer iminit

 string defpat "%"

 call query("usage:  d [path] ...")
 level = 0
 call inpack(nxtcol, RIGHT_MARGIN, obuf, STDOUT)
 repeat
    {
    level = level + 1
    status = getarg(level, ppath, FILENAMESIZE)
    if (status == EOF & level > 1)
	break
    else if (status == EOF)
	call gwdir(ppath, PATH)
    sarray = iminit(MEM_SIZE, AVE_TOK_SIZE)
    if (sarray == LAMBDA)
      call error("Error initializing in-memory sort.")
    call strcpy(defpat, file)
    if (opendr(ppath, desc) == ERR)
	{
	call strcpy(ppath, buf)
	call mkpath(buf, ppath)
	call exppth(ppath, depth, ptr, buf)
	j = ptr(depth)
	junk = gtftok(ppath, j, file)
	j = ptr(depth)
	ppath(j) = EOS
	if (opendr(ppath, desc) == ERR)
	    call cant(ppath)
	}
    call fold(file)
    if (getpat(file, pat) == ERR)
	call error("Illegal pattern.")
    while (gdrprm(desc, file) != EOF)
	{
	i = length(file) + 1
	file(i) = NEWLINE
	file(i+1) = EOS
	call fold(file)
	if (match(file, pat) == YES)
	    {
	    file(i) = EOS
	    if (imput(sarray, file) == ERR)
		{
		call remark("Too many files for in-memory sort.")
		break
		}
	    }
	}
    call closdr(desc)
    call imsort(sarray)
    while (imget(sarray, file) != EOF)
	call dopack(file, nxtcol, RIGHT_MARGIN, obuf, STDOUT)
    call flpack(nxtcol, RIGHT_MARGIN, obuf, STDOUT)
    }

 DRETURN
 end
#-h- d.rof            758  asc  02-may-81 22:18:42  [002,100]
.bp 
.pl 60
.rm 70 
.in 0 
.he 'D'5/2/81'D'
.fo ''-#-' 
.fi 
.in +7
.ti -7
NAME 
.br
d - fast directory list in sort order
.sp 1 
.ti -7
SYNOPSIS 
.br
d [path] ...
.sp 1 
.ti -7
DESCRIPTION 
.br
`d' lists the files matching the specified pattern in sort
order, packed in 5 columns across the page.  The packing occurs
regardless of whether standard output is a terminal or not, in contrast
to the actions of `ls'.
If no `path' arguments are specified, all files in the current working
directory are listed.  The forms of `path' are identical to those for `ls'.
.sp 1
.ti -7
FILES 
.br
None
.sp 1 
.ti -7
SEE ALSO 
.br
.nf
ls - general directory listing tool
.fi
.sp 1 
.ti -7
DIAGNOSTICS 
.br

.sp 1 
.ti -7
AUTHORS 
.br
Joe Sventek
.sp 1 
.ti -7
BUGS 
.br

