#-h- cprsym           246  asc  08-apr-81 09:19:17  [002,101]
 # symbols for compress and expand tools
 # put on a file called 'cprsym'
 # Used only by compress and expand
 
 #must have RCODE > (MAXCHUNK + BLANK) or RCODE = 0
 define(RCODE,125)
 define(MAXCHUNK,arith(RCODE,-,incr(BLANK)))
 define(THRESH,4)
#-h- cpress.r        1881  asc  08-apr-81 09:19:18  [002,101]
#-h- main             528  asc  08-apr-81 09:18:36  [002,101]
 ## cpress - compress input files

 include cprsym

 DRIVER(cpress)
 
 character buf(MAXLINE)
 integer getarg, open
 integer i
 #must have RCODE > (MAXCHUNK + BLANK) or RCODE = 0
 
 call query("usage:  cpress [file] ...")
 for (i=1; ; i=i+1)
	{
	if (getarg(i,buf,MAXLINE) == EOF)
		{
		if (i != 1)
			break
		int = STDIN
		}
	else if (buf(1) == MINUS & buf(2) == EOS)
		int = STDIN
	else
		{
		int = open(buf,READ)
		if (int == ERR)
			call cant(buf)
		}
	call press (int)
	if (int != STDIN)
		call close(int)
	}

 DRETURN
 end
#-h- press            704  asc  08-apr-81 09:18:37  [002,101]
 ## press - compress file -int-
 subroutine press (int)
 character getch
 character buf(MAXCHUNK), c, lastc
 integer int, nrep, nsave
 #must have RCODE > (MAXCHUNK + BLANK) or RCODE = 0
 
 nsave = 0
 for (lastc=getch(lastc,int); lastc != EOF; lastc = c)
	{
	for (nrep=1; getch(c,int) == lastc; nrep = nrep + 1)
		if (nrep >= MAXCHUNK)	#count repetitions
			break
	if (nrep < THRESH)		#append short string
		for (; nrep > 0; nrep = nrep - 1)
			{
			nsave = nsave + 1
			buf(nsave) = lastc
			if (nsave >= MAXCHUNK)
				call putbuf(buf, nsave)
			}
	else
		{
		call putbuf(buf, nsave)
		call putc(RCODE)
		call putc(lastc)
		call putcnt(nrep)
		}
	}
 call putbuf(buf, nsave)		#put last chunk
 return
 end
#-h- putbuf           246  asc  08-apr-81 09:18:38  [002,101]
 ## putbuf - output buf(1) ... buf(nsave),  clear nsave
 subroutine putbuf(buf, nsave)
 character buf(MAXCHUNK)
 integer i, nsave
 
 if (nsave > 0)
	{
	call putcnt(nsave)
	for (i=1; i<=nsave; i=i+1)
		call putc(buf(i))
	}
 nsave = 0
 return
 end
#-h- putcnt           155  asc  08-apr-81 09:18:38  [002,101]
## putcnt - output integer offset by BLANK as a character
 subroutine putcnt(int)

 integer int
 character c

 c = int + BLANK
 call putc(c)

 return
 end
#-h- cpress.rof       793  asc  02-may-81 21:54:13  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'CPRESS'1/15/79'CPRESS'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
cpress - compress input files
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
cpress
[file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Cpress
compresses runs of repeated characters in the input files.
The output file can eventually be expanded with the tool 'expand'.
 
If no input files are given, or the filename '-' appears, input will
be from the standard input.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
expand
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if an input file cannot be opened; further processing
is terminated.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
From Kernighan & Plauger's 'Software Tools', with modifications by
Debbie Scherrer.
.sp 1 
.in 
BUGS 
.br 
.in 7 
