#-h- alist.r         5057  asc  27-apr-81 23:35:30  [002,100]
#-h- defns            206  asc  08-apr-81 07:45:24  [002,101]
 define(PAGE_LENGTH,60)
 define(FORMFEED,12)
 define(NUM_WIDTH,5)		# with of page number field
 define(PAGE_WIDTH,72)		# width of page
 define(INDEX_WIDTH,25)		# width of index entry
 define(MEM_SIZE,2500)
#-h- main            2351  asc  08-apr-81 07:45:25  [002,101]
 DRIVER(alist)

 integer i, int, page, lcnt, j, junk, scrat
 integer nxtfil, open, getlin, getwrd, equal, imput, imget
 character file(FILENAMESIZE), path(FILENAMESIZE), lin(MAXLINE), wrd(MAXLINE)

 DS_DECL(mem,MEM_SIZE)

 pointer inmemt
 pointer iminit

 string hdrstr "#-h-"
 string lipsis "    ....."
 string biglip "     Page"
 string toc "Table of Contents"
 string sindex "Index of Entries"

 call query("usage:  alist [file] ...")
 for (i=1; nxtfil(i, file, path, scrat) != EOF; i=i+1)
    {
    int = open(file, READ)
    if (int == ERR)
	call cant(file)
    inmemt = iminit(MEM_SIZE, INDEX_WIDTH)
    if (inmemt == LAMBDA)
        call error("Error initializing in-memory sort area.")
    if (i > 1)
	call putch(FORMFEED, STDOUT)
    call fmthdr(path, toc, lin)
    call putlin(lin, STDOUT)
    call putch(NEWLINE, STDOUT)
    page = 0
    lcnt = 0
    while (getlin(lin, int) != EOF)
	{
	j = 1
	junk = getwrd(lin, j, wrd)
	if (equal(wrd, hdrstr) == YES)
	    {
	    page = page + 1
	    call skipbl(lin, j)
	    call puthdr(lin(j), lipsis, page)
	    junk = getwrd(lin, j, wrd)		# fetch file name
	    call fold(wrd)
	    call fmtndx(wrd, page, lin)
	    junk = imput(inmemt, lin)		# store index entry
	    lcnt = 1
	    }
	else if (lcnt >= PAGE_LENGTH)
	    {
	    page = page + 1
	    lcnt = 1
	    }
	else
	    lcnt = lcnt + 1
	}
    call close(int)
    call imsort(inmemt)		# sort the index
    call putch(FORMFEED, STDOUT)
    call fmthdr(path, sindex, lin)
    call putlin(lin, STDOUT)
    call putch(NEWLINE, STDOUT)
    while (imget(inmemt, lin) != EOF)
        {
        for (j=1; j <= arith(arith(PAGE_WIDTH,-,INDEX_WIDTH),/,2); j=j+1)
	    call putch(BLANK, STDOUT)
        call putlin(lin, STDOUT)
        call putch(NEWLINE, STDOUT)
        }
    int = open(file, READ)
    page = 0
    lcnt = 0
    while (getlin(lin, int) != EOF)
	{
	j = 1
	junk = getwrd(lin, j, wrd)
	if (equal(wrd, hdrstr) == YES)
	    {
	    page = page + 1
	    call putch(FORMFEED, STDOUT)
	    call puthdr(lin, biglip, page)
	    lcnt = 1
	    }
	else if (lcnt >= PAGE_LENGTH)
	    {
	    page = page + 1
	    call putch(FORMFEED, STDOUT)
	    lcnt = 1
	    call putlin(lin, STDOUT)
	    }
	else
	    {
	    lcnt = lcnt + 1
	    call putlin(lin, STDOUT)
	    }
	}
    call close(int)
    if (scrat == YES)
        call remove(file)
    }

 DRETURN
 end
#-h- fmthdr           656  asc  27-apr-81 23:33:26  [002,100]
subroutine fmthdr(path, middle, buf)

character path(FILENAMESIZE), middle(ARB), buf(ARB), date(10), time(10)
integer j, limit, init, now(7)
integer length

data init /YES/

if (init == YES)
  {
  init = NO
  call getnow(now)
  call fmtdat(date, time, now, LETTER)
  }
j = 1
call stcopy(path, 1, buf, j)
limit = (PAGE_WIDTH - length(middle)) / 2 + 1
while (j <= limit)
  call chcopy(BLANK, buf, j)
call stcopy(middle, 1, buf, j)
limit = PAGE_WIDTH - length(date) - length(time) - 1
while (j <= limit)
  call chcopy(BLANK, buf, j)
call stcopy(date, 1, buf, j)
call chcopy(BLANK, buf, j)
call stcopy(time, 1, buf, j)
call chcopy(NEWLINE, buf, j)

return
end
#-h- fmtndx           350  asc  08-apr-81 07:45:29  [002,101]
subroutine fmtndx(file, page, buf)

character file(FILENAMESIZE), buf(ARB), num(incr(NUM_WIDTH))
integer page, nblank, i, j
integer length, itoc

nblank = INDEX_WIDTH - length(file) - itoc(page, num, incr(NUM_WIDTH))
j = 1
call stcopy(file, 1, buf, j)
for (i=1; i <= nblank; i=i+1)
  call chcopy(BLANK, buf, j)
call scopy(num, 1, buf, j)

return
end
#-h- nxtfil           652  asc  08-apr-81 07:45:29  [002,101]
integer function nxtfil(i, file, path, scrat)

integer i, scrat, int
integer getarg, create
character file(FILENAMESIZE), path(FILENAMESIZE)

string seed "als"
string stdpth "Standard input"

if (getarg(i, file, FILENAMESIZE) != EOF)
  {
  call mkpath(file, path)
  scrat = NO
  nxtfil = OK
  }
else if (i > 1)
  nxtfil = EOF
else
  {
  call scratf(seed, file)
  int = create(file, WRITE)
  if (int != ERR)
    {
    scrat = YES
    call fcopy(STDIN, int)
    call close(int)
    call scopy(stdpth, 1, path, 1)
    nxtfil = OK
    }
  else
    {
    call remark("Cannot create scratch file  for standard input.")
    nxtfil = EOF
    }
  }

return
end
#-h- puthdr           470  asc  08-apr-81 07:45:30  [002,101]
 subroutine puthdr(first, middle, page)

 character first(ARB), middle(ARB)
 integer page, i, limit
 integer length

 limit = arith(PAGE_WIDTH,-,NUM_WIDTH) - length(middle)
 for (i=1; i <= limit; i=i+1)
    if (first(i) == NEWLINE | first(i) == EOS)
        break
    else
        call putch(first(i), STDOUT)
 for ( ; i <= limit; i=i+1)
    call putch(BLANK, STDOUT)
 call putlin(middle, STDOUT)
 call putdec(page, NUM_WIDTH)
 call putch(NEWLINE, STDOUT)

 return
 end
#-h- alist.rof       1028  asc  02-may-81 21:16:36  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'ALIST'1/11/79'ALIST'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
alist - generate paginated listing of source archive
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
alist [file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
`alist' generates a paginated listing of archive files.  A table of contents
with the relative page number in the listing is displayed first, with
each element of the archive file starting on a new page.
The second page of the listing contains a sorted index of entries,
with the starting page number.  If no files are specified, the standard
input is read.
`alist' considers
each line which starts with the string "#-h-" to be the beginning of a
new entry, so that nested archives will be handled reasonably.
The listing is displayed on standard output, and may be piped into lpr
to queue to the printer.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
pr - print files
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
Joe Sventek
.sp 1 
.in 
BUGS 
.br 
.in 7 
