#-h- split.r         1767  asc  26-apr-81 08:19:10  [002,100]
#-h- main             835  asc  26-apr-81 08:17:52  [002,100]
 ## split - split a file into pieces
 DRIVER(split)
 
 integer getarg, create, open, ctoi, nlcopy
 character buf(MAXLINE), outf(FILENAMESIZE)
 integer nl, i, j, in, usein, out
 data outf(1), outf(2) / LETX, EOS/
 
 call query("usage:  split [-n] [file [name]].")
 nl = 1000
 usein = NO
 in = STDIN
 			#pick up file name(s)
 for (i=1; getarg(i,buf,MAXLINE)!=EOF; i=i+1)
	{
	if (buf(1) == MINUS)
		{
		if (buf(2) == EOS)
			usein = YES
		else
			{
			j = 2
			nl = max(ctoi(buf,j), 1)
			}
		}
	else if (usein == NO)
		{
		in = open(buf,READ)
		if (in == ERR)
			call cant(buf)
		usein = YES
		}
	else
		call scopy(buf, 1, outf, 1)
	}
 
	#main loop to break up file
 repeat
	{
	call extnam(outf, buf)
	out = create(buf, WRITE)
	if (out == ERR)
		call cant(buf)
	if (nlcopy(in, out, nl) == EOF)
		break
	call close(out)
	}
 DRETURN
 end
#-h- extnam           452  asc  26-apr-81 08:17:53  [002,100]
 ## extnam - add unique extension to filename -file-
 subroutine extnam (file, name)
 character file(ARB), name(ARB), append(3)
 integer length
 
 data append(1), append(2), append(3) /LETA, LETA, EOS/
 
 call scopy(file, 1, name, 1)
 if (append(2) > LETZ)
	{
	append(2) = LETA
	append(1) = append(1) + 1
	if (append(1) > LETZ)
		call error ('out of file names.')
	}
 call scopy(append, 1, name, length(name)+1)
 append(2) = append(2) + 1
 return
 end
#-h- nlcopy           294  asc  26-apr-81 08:17:54  [002,100]
 ## nlcopy - copy n lines from file in to file out
 integer function nlcopy (in, out, n)
 character buf(MAXLINE)
 integer getlin
 integer in, out, n, i
 
 for (i=1; i<=n; i=i+1)
	{
	if (getlin(buf,in) == EOF)
		{
		nlcopy = EOF
		return
		}
	call putlin(buf, out)
 	}
 nlcopy = OK
 return
 end
#-h- split.rof        827  asc  11-may-81 12:08:22  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'SPLIT'1/11/79'SPLIT'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
split - split a file into pieces
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
split
[-n] [file [name] ]
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Split
reads
file
and writes it in n-line pieces (default 1000),
as many as necessary, onto a set of output files.
The name of the output file is
name
with
aa
appended, and so on lexicographically.
If no output name is given,
x
is default.
 
If no input file is given, or if - is given in its stead, then the
standard input file is used.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
The Unix command 'split'
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if the input file could not be opened.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Debbie Scherrer
.sp 1 
.in 
BUGS 
.br 
.in 7 
