#-h- sched.r         1383  asc  29-apr-81 20:20:21  [002,100]
#-h- defns             87  asc  27-apr-81 11:36:11  [002,100]
 define(DEFAULTREPS,1)
 define(DEFAULTSECS,1)
 define(MINREPS,1)
 define(MAXREPS,HUGE)
#-h- main            1172  asc  29-apr-81 20:16:39  [002,100]
 DRIVER(sched)

 integer found, reps, secs, i, getarg, j, n, ctoi, length, spawn, astart
 integer loccom
 character arg(MAXLINE), proces(FILENAMESIZE),
	   descr(PIDSIZE), clower

 string suffix IMAGE_SUFFIX
 string sh "sh"
 string args(ARGBUFSIZE) "sh -c "
 string usestr 'usage:  sched [-r<reps>] [-t<seconds>] "shell command"'

 call query(usestr)
 astart = length(args) + 1
 found = NO
 reps = DEFAULTREPS
 secs = DEFAULTSECS
 for (i=1; getarg(i, arg, MAXLINE) != EOF; i=i+1)
    if (arg(1) == MINUS & clower(arg(2)) == LETR)
	{
	j = 3
	n = ctoi(arg, j)
	if (n < MINREPS)
	    reps = MINREPS
	else if (n > MAXREPS)
	    reps = MAXREPS
	else
	    reps = n
	}
    else if (arg(1) == MINUS & clower(arg(2)) == LETT)
	{
	j = 3
	secs = ctoi(arg, j)
	}
    else
	{
	found = YES
	call scopy(arg, 1, args, astart)
	}
 if (found == NO)
    call error(usestr)
 call impath(arg)		# get standard image search path
 if (loccom(sh, arg, suffix, proces) != BINARY)
    call error("Error locating shell image file.")
 for (i=1; i <= reps; i=i+1)
    {
    call sleep(secs)
    if (spawn(proces, args, descr, WAIT) == ERR)
	call error("Error in spawning command")
    }

 DRETURN
 end
#-h- sched.rof       1112  asc  03-may-81 14:24:46  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he :SCHED:10/29/80:SCHED:
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
sched - a way to repetitively invoke a command
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
sched [-r<repetitions>] [-t<seconds>] "shell command"
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
sched causes the command typed in quotes to be repetitively invoked.
The defaults are to invoke the command once, and to wait 1 second before
each invocation.  This utility is quite nice for statistics gathering,
since sched may be run in the background, with the diagnostic output being
appended to some log file.  For example:

% sched -r360 -t10 "pip t.=[105,3]/tb; cat t >>tmp.log; rm t"

would generate a log file of the disk space in use in the tools tmp
directory, running every ten seconds for the next hour.
The resulting log file could then be scanned to see how the disk usage
fluctuates, edited so that the information could be input to a histogram
utility, etc.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
Joe Sventek
.sp 1 
.in 
BUGS 
.br 
.in 7 
