#-h- resolve.r       2260  asc  27-apr-81 08:32:50  [002,100]
#-h- defns            169  asc  27-apr-81 08:30:28  [002,100]
 ## definitions for the RESOLVE tool
 # put on a file named 'defns'
 # Used by the resolve tool
 
  define(NEXPR,10)	# maximum number of expressions allowed on cmd line
#-h- main            1528  asc  27-apr-81 08:30:29  [002,100]
 DRIVER(resolve)

 character exp(MAXARG,NEXPR), pat(MAXPAT,NEXPR), lin(MAXLINE),
	   arg(MAXARG), infile(FILENAMESIZE)
 integer i, getarg, except, andpat, count, elevel, itoc, getpat,
	 mcount, getlin, matchd, status, gmatch, index, int, open

 string usestr "usage:  resolve [-acx] expression [expression] ..."

 data except/NO/
 data andpat/NO/
 data count /NO/
 data elevel/0/

 call query(usestr)
 call adrfil(infile)
 int = open(infile, READ)
 if (int == ERR)
    call cant(infile)
 for (i=1; getarg(i, arg, MAXARG) != EOF; i=i+1)
    if (arg(1) == MINUS)
	{
	call scopy(arg, 1, lin, 1)
	call fold(lin)
	if (index(lin, LETA) > 0)
	    andpat = YES
	if (index(lin, LETC) > 0)
	    count = YES
	if (index(lin, LETX) > 0)
	    except = YES
	}
    else if (elevel < NEXPR)
	{
	elevel = elevel + 1
	call fold(arg)
	call scopy(arg, 1, exp(1, elevel), 1)
	}
    else
	{
	call putlin("Maximum number of expressions permitted is ", ERROUT)
	status = itoc(NEXPR, arg, MAXARG)
	call error(arg)
	}
 if (elevel == 0)
    call error(usestr)
 for (i=1; i <= elevel; i=i+1)
    if (getpat(exp(1,i), pat(1,i)) == ERR)
	{
	call putlin("illegal pattern: ", ERROUT)
	call error(exp(1,i))
	}
 mcount = 0
 while (getlin(lin, int) != EOF)
    {
    matchd = gmatch(lin, pat, elevel, andpat)
    if ((matchd == YES & except == NO) | (matchd == NO & except == YES))
	if (count == YES)
	    mcount = mcount + 1
	else
	    call putlin(lin, STDOUT)
    }
 if (count == YES)
    {
    call putdec(mcount, 1)
    call putc(NEWLINE)
    }

 DRETURN
 end
#-h- gmatch           377  asc  27-apr-81 08:30:30  [002,100]
 integer function gmatch(lin, pat, elevel, andpat)

 integer elevel, andpat, match, i, status
 character lin(ARB), pat(MAXPAT, NEXPR)

 gmatch = andpat
 for (i=1; i <= elevel; i=i+1)
    {
    status = match(lin, pat(1,i))
    if (andpat == NO & status == YES)
	{
	gmatch = YES
	break
	}
    else if (andpat == YES & status == NO)
	{
	gmatch = NO
	break
	}
    }

 return
 end
#-h- resolve.rof      720  asc  08-may-81 17:09:31  [002,100]
.in 0
.rm 70
.pl 60
.he :RESOLVE:6/8/79:RESOLVE:
.fo ::-#-:
.bp
.in +7
.ti -7
NAME
.br
resolve - resolve mail system user names
.sp
.ti -7
SYNOPSIS
.br
resolve expression [expression ...]
.sp
.ti -7
DESCRIPTION
.br
resolve
searches the mail database for lines matching the text pattern
"expression". (Valid text patterns are the same as for find.)  Resolve
will display on the standard output all lines which match any one of
the given expressions.
.sp
.ti -7
FILES
.br
.sp
.ti -7
SEE ALSO
.br
find - search a file for text patterns
.br
mail - software tools mail facility
.br
users - list users to whom mail may be sent
.sp
.ti -7
DIAGNOSTICS
.br
None
.sp
.ti -7
AUTHOR
.br
Joe Sventek
.sp
.ti -7
BUGS/DEFICIENCIES
.br
