#-h- cprint           748  asc  27-apr-81 12:27:29  [002,100]
 ## common block to hold info for pr tool
 #  put on a file called 'cprint'
 #  used only by the pr tool
 
 common /cprint/  mar1, mar2, bmar, dohead, dotail, plen
        integer mar1    #distance between top of page and header
                        #(default = 3)
        integer mar2    #distance between header and text
                        #(default = 2)
        integer bmar    #distance between text and bottom of page
                        #(default = 6)
        integer dohead  #flag to cause/suppress printing of header
                        # (default = YES)
        integer dotail  #flag to cause/suppress printing of bottom 
                        #margin  (default = YES)
        integer plen    #page length (default = 66)
#-h- pr.r            3275  asc  27-apr-81 12:27:32  [002,100]
#-h- defns             96  asc  27-apr-81 12:13:31  [002,100]
  # include ratdef
 define(MARGIN1,0)
 define(MARGIN2,2)
 define(BMARGIN,0)
 define(PAGELEN,62)
#-h- main            1343  asc  27-apr-81 12:13:32  [002,100]
 ## print - print files with headings
 DRIVER(pr)
    character name(FILENAMESIZE)
    integer getarg, open, ctoi
    integer fd, i, j
    include cprint
    string stdinp "Standard input"
    string usestr "usage:  pr [l<n>] [file] ..."
  
    call query(usestr)
    mar1 = MARGIN1		#set defaults
    mar2 = MARGIN2
    bmar = BMARGIN
    dohead = YES
    plen = PAGELEN
    fd = ERR
    for (i = 1; getarg(i, name, FILENAMESIZE) ^= EOF; i = i + 1) 
	{
       if (name(1) == MINUS & name(2) != EOS)
                {                  #it is anticipated that more
                                   #options may be added in the future
		if (name(2) == LETL | name(2) == BIGL) #set page length
			{
                         j = 3
                         plen = ctoi(name, j)
                         if ((plen-mar1-mar2-bmar-2) <= 0)
                              call error ("page too small.")
			}
		else
			call remark ("ignoring invalid argument.")
		}
        else if (name(1) == MINUS & name(2) == EOS)
	        {
		fd = STDIN
		call fprint (stdinp, STDIN)
		}
	else
		{
       		fd = open(name, READ)
       		if (fd == ERR)
          		call cant(name)
       		call fprint(name, fd)
       		call close(fd)
                }
       }
    if (fd ==ERR)    # no input file specified
       call fprint(stdinp, STDIN)
    DRETURN
    end
#-h- fprint           892  asc  27-apr-81 12:13:34  [002,100]
 # fprint - print file "name" from  fd
    subroutine fprint(name, fd)
    character line(MAXLINE), name(ARB), date(10), time(10)
    integer getlin
    integer fd, lineno, pageno, now(7)
  
    include cprint
 
    call getnow(now)
    call fmtdat(date, time, now, LETTER)
    pageno = 0
    lineno = 0
    while (getlin(line, fd) ^= EOF) {
       if (lineno == 0)
          {
          pageno = pageno + 1
          if (dohead == YES)
		{
          	call skip(mar1)
          	call head(name, date, time, pageno)
          	call skip(mar2)
                lineno = mar1 + mar2 + 1
                }
          }
       call putlin(line, STDOUT)
       lineno = lineno + 1
       if (lineno + bmar >= plen)
          {
          call skip(bmar)
          lineno = 0
          }
       }
    if (lineno > 0)
       {
       call skip(plen-lineno)
        call skip(bmar)
	}
    return
    end
#-h- head             478  asc  27-apr-81 12:13:36  [002,100]
 # head - print top of page header
    subroutine head(name, date, time, pageno)
    character name(ARB), date(ARB), time(ARB)
    integer pageno
    string page "   Page  "
    string twoblk "  "
  
    call putch(FF, STDOUT)
    call putlin(name, STDOUT)
    call putlin(twoblk, STDOUT)
    call putlin(date, STDOUT)
    call putch(BLANK, STDOUT)
    call putlin(time, STDOUT)
    call putlin(page, STDOUT)
    call putdec(pageno, 1)
    call putc(NEWLINE)
    return
    end
#-h- skip             156  asc  27-apr-81 12:13:37  [002,100]
 # skip - output  n  blank lines
    subroutine skip(n)
    integer i, n
  
    for (i = 1; i <= n; i = i + 1)
       call putc(NEWLINE)
    return
    end
#-h- pr.rof          1215  asc  08-may-81 17:02:03  [002,100]
.pl 60
.bp 1
.in 0
.he 'PR (1)'1/15/77'PR (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
pr - paginate files to standard output
.nf
.sp
.ti -3
SYNOPSIS
.br
pr [-ln] [file] ...
.fi
.sp
.ti -3
DESCRIPTION
.br
Pr
paginates the named files to standard output.
Each file is printed as a sequence of pages.  Each page
is 66 lines
long, including a 6-line header and 3-line footer.
The header includes the file name, possibly the date, and
the page number.
 
If the file '-' is specified, or no file names are given,
the standard input is read.
 
Option flags include:
.in +11
.ti -5
-ln   Sets the page length to 'n'.
Default page length is 66.
.in -11
.sp
.fi
.ne 2
.ti -3
SEE ALSO
.br
os, detab, mcol, format, cat
.sp
.ti -3
DIAGNOSTICS
.br
ignoring invalid argument
.in +3
An option flag was specified which pr did not understand
 
.in -3
A message is printed if an input file could not be opened
.sp
.ti -3
AUTHORS
.br
Original from the Kernighan-Plauger 'Software Tools' book,
with modifications by David Hanson and friends (U. of Arizona)
and Debbie Scherrer (LBL)
.sp
.ti -3
BUGS/DEFICIENCES
.br
The header and trailer spacing can be modified by adjusting the 
MARGIN1, MARGIN2, and
BMARGIN definitions in the source code.
