#-h- os.r            1749  asc  24-apr-81 12:05:34  [002,100]
#-h- defns            217  asc  24-apr-81 11:58:18  [002,100]
 ## definitions for overstrike tool
 # put on a file named 'defns'
 # Used only by overstrike
 
 define(NOSKIP,PLUS)		#suppress carriage-return/line feed
 define(SKIP,BLANK)
 define(NEWPAGE,DIG1)		# top of page on ^L
#-h- main             614  asc  24-apr-81 11:50:34  [002,100]
 ## os - convert backspaces into multiple lines
 DRIVER(os)
 
 character buf(MAXLINE)
 integer getarg, open, assign
 integer i
 
 call query("usage:  os [file] ...")
 call filnfo(STDOUT, buf, i)
 if (assign(buf, STDOUT, PRINT) == ERR)
    call error("Cannot reset standard output to PRINT carriage control.")
 for (i=1; ; i=i+1)
	{
	if (getarg(i,buf,MAXLINE) == EOF)
		{
		if (i != 1)
			break
		int = STDIN
		}
	else if (buf(1) == MINUS & buf(2) == EOS)
		int = STDIN
	else
		{
		int = open(buf,READ)
		if (int == ERR)
			call cant(buf)
		}
	call overs (int)
	if (int != STDIN)
		call close(int)
	}
 DRETURN
 end
#-h- overs            732  asc  24-apr-81 12:01:32  [002,100]
 ## overs - convert backspaces into multiple lines from file -int-
 subroutine overs(int)
 character getch
 character c
 integer col, newcol, int
 
 col = 1
 repeat
	{
	newcol = col
	while (getch(c,int) == BACKSPACE)	#eat up backspaces
		newcol = max(newcol-1, 1)
	if (newcol < col)			#start overstrike line
		{
		call putc(NEWLINE)
		call putc(NOSKIP)
		for (col=1; col<newcol; col=col+1)
			call putc(BLANK)
		}
	else if (col == 1 & c == FF)		# top of page
		{
		call putc(NEWPAGE)
		col = col + 1
		next
		}
	else if (col == 1 & c != EOF)		#start normal line
		call putc(SKIP)
						#else middle of line
	if (c == EOF)
		break
	call putc(c)				#normal character
	if (c == NEWLINE)
		col = 1
	else
		col = col + 1
	}
 return
 end
#-h- os.rof           848  asc  08-may-81 16:58:23  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he 'OS'1/16/79'OS'
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
os - overstrike - convert backspaces into multiple lines
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
os
[file] ...
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
Os
(overstrike) looks for backspaces in the files specified and 
generates a sequence of print lines with carriage control codes
to reproduce the effect of the backspaces.
 
If no files are given, or the filename '-' appears, input is
taken from the standard input.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
lpr
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
A message is printed if an input file cannot be opened; further
processing is terminated.
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
.sp 1 
Original from Kernighan & Plauger's 'Software Tools', with modifications
by Debbie Scherrer.
.sp 1 
.in 
BUGS 
.br 
.in 7 
