#-h- cmcol            379  asc  27-apr-81 13:10:06  [002,100]
 ## common block to hold line buffers for mcol tool
 #  put on a file called 'cmcol'
 #  used only by the mcol tool
 
   common /ccol/ col, nextbf, linbuf(MAXBUF), linptr(MAXPTR)
      integer col	# current column number on formatted page
      integer nextbf	# next available slot in linbuf
      character linbuf	# holds a formatted page
      integer linptr	# points to lines
#-h- mcol.r          5674  asc  27-apr-81 13:10:08  [002,100]
#-h- defns            165  asc  27-apr-81 13:06:50  [002,100]
 # include ratdef
 define(COLUMNS,2)	# defaults
 define(PAGESIZE,55)
 define(GUTTER,8)
 define(LINESIZE,60)
 define(MAXBUF,7000)	# size limits
 define(MAXPTR,1200)

#-h- main            1146  asc  27-apr-81 13:06:51  [002,100]
# mcol - format standard input into multiple columns
 DRIVER(mcol)
   integer pagsiz, linsiz, ncols, gutsiz, lineno, nlines, i, j, fd
   integer readln, ctoi, getarg, mod, max, open
   character arg(MAXLINE)
   include cmcol

   string usestr "usage:  mcol [-cn] [-ln] [-wn] [-gn] [-dn] [file] ..."

   call query(usestr)
   for (i = 1; i <= MAXPTR; i = i + 1)	# clear pointer array
      linptr(i) = 0
   col = 0
   nextbf = 1
   pagsiz = PAGESIZE		# set defaults
   linsiz = LINESIZE
   ncols = COLUMNS
   gutsiz = GUTTER
   fd = ERR
   for (i = 1; getarg(i, arg, MAXLINE) ^= EOF; i = i + 1)
	{
      if (arg(1) == MINUS & arg(2) ^= EOS) 
          call colarg (arg, pagsiz, ncols, gutsiz, linsiz)
      else if (arg(1) == MINUS & arg(2) == EOS)
               call docol (pagsiz, ncols, gutsiz, linsiz, STDIN)
       else
             {
             fd = open(arg, READ)
             if (fd == ERR)
		call cant(arg)
             call docol(pagsiz, ncols, gutsiz, linsiz, fd)
             call close (fd)
             }
         }
   if (fd == ERR)        #read STDIN
         call docol (pagsiz, ncols, gutsiz, linsiz, STDIN)
  DRETURN
   end
#-h- colarg          1157  asc  27-apr-81 13:06:54  [002,100]
 ## colarg - process flags for mcol tool
 subroutine colarg (arg, pagsiz, ncols, gutsiz, linsiz)
 integer pagsiz, ncols, gutsiz, linsiz, j
 integer ctoi
 character arg(ARB)
 
 j = 3
 j = ctoi(arg, j)
 if (arg(2) == LETC | arg(2) == BIGC)
	{
	 ncols = j
	 if (ncols <= 0)
		call error ("invalid column count.")
	}
 else if (arg(2) == LETL | arg(2) == BIGL)
	{
 	pagsiz = j
	if (pagsiz <= 0)
		call error ("invalid page size.")
	}
  else if ( (arg(2) == LETW | arg(2) == BIGW) |
            (arg(2) == LETS | arg(2) == LETS) )  #UofA convention
	{
 	linsiz = j
	if (linsiz <= 0)
		call error ("invalid column width.")
	}
 else if (arg(2) == LETG | arg(2) == BIGG)
	{
 	gutsiz = j
	if (gutsiz < 0)
		call error ("invalid gutter width.")
	}
 else if (arg(2) == LETD | arg(2) == BIGD) 
	{
 	pagsiz = 23		# display defaults
 	linsiz = 10
 	ncols = 7
 	gutsiz = 1
 	if (j > 0)   # set column width and number of columns
		{
 		linsiz = j
 		ncols = max(1, 81/(linsiz+1))
 		if (ncols > 1) 
			{
 			gutsiz = (79 - (linsiz+1)*ncols)/(ncols - 1)+1
 			if (gutsiz <= 0)
 				ncols = ncols - 1
 			}
 		}
	}
 else
 	call remark ("ignoring invalid flag.")
 return
 end
#-h- docol            692  asc  27-apr-81 13:06:56  [002,100]
 ## docol - process file for mcol
 subroutine docol (pagsiz, ncols, gutsiz, linsiz, fd)
 integer pagsiz, ncols, gutsiz, linsiz, fd, nlines, lineno, i
 integer readln
 include cmcol
 
 nlines = pagsiz*ncols	# total number of lines/page
 if (nlines > MAXPTR)
        call error ("too many lines.")
 for (lineno = 1; readln(i, linsiz, fd) ^= EOF; lineno = lineno + 1)
      {
      call inject(i, lineno)
      if (lineno >= nlines) {
         call outbuf(pagsiz, linsiz, gutsiz)
         lineno = 0
         }
      }
   if (lineno > 1) {
      pagsiz = lineno/ncols
      if (mod(lineno, ncols) ^= 0)
         pagsiz = pagsiz + 1
      call outbuf(pagsiz, linsiz, gutsiz)
      }
 return
 end
#-h- inject           235  asc  27-apr-81 13:06:58  [002,100]
# inject - insert pointer ptr into linptr array
   subroutine inject(ptr, lineno)
   integer ptr, lineno
   include cmcol

   if (lineno > MAXPTR)
      call error("insufficient buffer space.")
   linptr(lineno) = ptr
   return
   end
#-h- outbuf           520  asc  27-apr-81 13:06:59  [002,100]
# outbuf - dump current buffer to formatted page
   subroutine outbuf(pagsiz, linsiz, gutsiz)
   integer pagsiz, linsiz, gutsiz
   integer i, j
   include cmcol

   for (i = 1; linptr(i) ^= 0; i = i + 1) {
      call outlin(linbuf(linptr(i)))
      linptr(i) = 0
      for (j = i + pagsiz; linptr(j) ^= 0; j = j + pagsiz) {
         call outtab((linsiz + gutsiz)*((j - 1)/pagsiz))
         call outlin(linbuf(linptr(j)))
         linptr(j) = 0
         }
      call outch(NEWLINE)
      }
   nextbf = 1
   return
   end
#-h- outch            189  asc  27-apr-81 13:07:00  [002,100]
# outch - output c to formatted page
   subroutine outch(c)
   character c
   include cmcol

   call putc(c)
   if (c == NEWLINE)
      col = 0
   else
      col = col + 1
   return
   end
#-h- outlin           185  asc  27-apr-81 13:07:01  [002,100]
# outlin - output str to formatted page
   subroutine outlin(str)
   character str(ARB)
   integer i

   for (i = 1; str(i) ^= EOS; i = i + 1)
      call outch(str(i))
   return
   end
#-h- outtab           160  asc  27-apr-81 13:07:02  [002,100]
# outtab - tab to column n on formatted page
   subroutine outtab(n)
   integer n
   include cmcol

   while (col < n)
      call outch(BLANK)
   return
   end
#-h- readln           605  asc  27-apr-81 13:07:03  [002,100]
# readln - read next line (<= linsiz) into linbuf; return location p
   integer function readln(p, linsiz, fd)
   integer p, linsiz, fd
   integer i
   character getch
   character c
   include cmcol

   p = nextbf
   for (i = 1; getch(c, fd) ^= EOF; i = i + 1) {
      if (c == NEWLINE)
         break
      if (i <= linsiz) {
         if (nextbf >= MAXBUF)
            call error("insufficient buffer space.")
         linbuf(nextbf) = c
         nextbf = nextbf + 1
         }
      }
   if (c == EOF & i == 1)
      return (EOF)
   linbuf(nextbf) = EOS
   nextbf = nextbf + 1
   return (i - 1)
   end
#-h- mcol.rof        2359  asc  08-may-81 16:49:08  [002,100]
.pl 60
.bp 1
.in 0
.he 'MCOL (1)'10/1/78'MCOL (1)'
.sp 2
.in +3
.fi
.ti -3
NAME
.br
mcol - multicolumn formatting
.nf
.sp
.ti -3
SYNOPSIS
.br
mcol [-cn] [-ln] [-wn] [-gn] [-dn] [file ...]
.fi
.sp
.ti -3
DESCRIPTION
.br
Mcol reads the named files and formats them into multicolumn
output on the standard output.
If the filename "-" is given, or no files are specified, the
standard input is read.
 
The options are as follows.
.sp
.in +5
.ti -5
-cn  Format the output into "n" columns.  Default is 2.
.sp
.ti -5
-ln  Set the output page size to "n".  Mcol produces its output
in pages, but does not place separators between the pages on
the assumption that some subsequent processor will do that.
(The default page length is 55.)
.sp
.ti -5
-wn  Set the column width to "n" characters.  Lines longer than "n"
characters are truncated.
(The default column width is 60.)
.sp
.ti -5
-gn  Set the "gutter" width to "n".  The gutter is the white space
between columns.
(The default gutter width is 8.)
.sp
.ti -5
-dn  Assume output is to be printed on a display terminal.  The
column size is set to "n" characters and the page size is set to
24 lines.  The number of columns and gutter width are computed
to maximize the amount of information on a single screen.
If "n" is omitted, 10 is used, which is useful for displaying
lists of file names.
.sp
.in -5
.fi
.sp
.ti -3
FILES
.br
None
.sp
.ti -3
SEE ALSO
.br
.sp
.ne 2
.ti -3
DIAGNOSTICS
.br
.nf
invalid column count
invalid page size
invalid column width
invalid gutter width
.br
.fi
.in +3
The value of one of the option flags is invalid or exceeds
the limitations of mcol.
.sp
.ti -3
ignoring invalid flag
.br
A command argument option flag was given which mcol didn't recognize.
.in -3
.sp
insufficient buffer space
.br
.in +3
Mcol could not buffer an entire page.  This is usually the result
of options that specify a large page size or many columns.
The buffer size is set by the MAXBUF definition in the source code.
.in -3
.sp
too many lines
.in +3
.br
The number of lines per page times the number of columns
exceeded mcol's line buffer space.
The maximum number of lines allowed is set by the MAXPTR definition
in the source code.
.in -3
.fi
.sp
.ne 2
.ti -3
BUGS/DEFICIENCIES
.br
.sp
.ti -3
AUTHORS
.br
Original by David Hanson and friends (U. of Arizona), with
modifications by Debbie Scherrer (LBL).
