#-h- cisam            211  asc  27-apr-81 16:04:10  [002,100]
 common / cisam / dif, width, justfy

 integer dif		# number of records between isam'ed records
 integer width		# width of key field in index
 integer justfy		# type of justification desired on key; init = LEFT
#-h- isam.r          2271  asc  27-apr-81 16:04:11  [002,100]
#-h- defns            111  asc  27-apr-81 16:02:16  [002,100]
 define(DEFAULT_WIDTH,25)
 define(DEFAULT_DIF,1)
 define(DEFAULT_JUSTFY,LEFT)
 define(LEFT,0)
 define(RIGHT,1)
#-h- main             725  asc  27-apr-81 16:02:17  [002,100]
 DRIVER(isam)

 linepointer oldadr, addr
 integer n, status, i, junk
 integer getlin, getwrd, doline, ptreq
 character oldwrd(MAXLINE), buf(MAXLINE), word(MAXLINE)

 include cisam

 call query("usage:  isam [-d<dif>] [-w<width>] [-j<l/r>].")
 call getcmd			# crack command line
 oldwrd(1) = EOS
 call ptrcpy(NULLPOINTER, oldadr)
 n = 0
 repeat
    {
    call markl(STDIN, addr)
    status = getlin(buf, STDIN)
    if (status != EOF)
	{
	n = n + 1
	i = 1
	junk = getwrd(buf, i, word)
	if (doline(n) == YES)
	    call outlin(word, addr)
	call strcpy(word, oldwrd)
	call ptrcpy(addr, oldadr)
	}
    }
 until (status == EOF)
 if (doline(n) == NO & ptreq(oldadr, NULLPOINTER) == NO)
    call outlin(oldwrd, oldadr)

 DRETURN
 end
#-h- doline           159  asc  27-apr-81 16:02:18  [002,100]
 integer function doline(n)

 integer n

 include cisam

 if (dif == 1)
    return(YES)
 else if (mod(n, dif) == 1)
    return(YES)
 else
    return(NO)

 end
#-h- getcmd           696  asc  27-apr-81 16:02:19  [002,100]
 subroutine getcmd

 character arg(FILENAMESIZE)
 integer getarg, ctoi
 integer i, j

 include cisam

 dif = DEFAULT_DIF
 width = DEFAULT_WIDTH
 justfy = DEFAULT_JUSTFY

 for (i=1; getarg(i, arg, FILENAMESIZE) != EOF; i=i+1)
    {
    call fold(arg)
    if (arg(1) == MINUS)
	    if (arg(2) == LETD)
		{
		j = 3
		dif = ctoi(arg, j)
		if (dif <= 0)
		    dif = DEFAULT_DIF
		}
	    else if (arg(2) == LETW)
		{
		j = 3
		width = ctoi(arg, j)
		if (width <= 0)
		    width = DEFAULT_WIDTH
		}
	    else if (arg(2) == LETJ)
		{
		if (arg(3) == LETL)
		    justfy = LEFT
		else if (arg(3) == LETR)
		    justfy = RIGHT
		}
	    else
		call badarg(arg)
    else
	call badarg(arg)
    }

 return
 end
#-h- outlin           270  asc  27-apr-81 16:02:20  [002,100]
 subroutine outlin(word, addr)

 character word(ARB)
 linepointer addr

 include cisam

 if (justfy == RIGHT)
    call putstr(word, width, STDOUT)
 else
    call putstr(word, -width, STDOUT)
 call putc(BLANK)
 call putptr(addr, STDOUT)
 call putc(NEWLINE)

 return
 end
#-h- isam.rof        1095  asc  06-may-81 08:08:42  [002,100]
.pl 60
.bp 
.rm 70 
.in 0 
.he :ISAM:10/29/80:ISAM:
.fo ''-#-' 
.fi 
NAME 
.br 
.in 7 
isam - generate index for pseudo-indexed-sequential access
.sp 1 
.in 
SYNOPSIS 
.br 
.in 7 
isam [-d<dif>] [-w<width>] [-j<l/r>]
.sp 1 
.in 
DESCRIPTION 
.br 
.in 7 
isam is used to generate an index for a text file such that the index may
be used later to permit indexed-sequential access to the file.
isam reads every `dif'th line (default is 1) from the standard input,
noting its disk address with
a call to markl.  It uses getwrd to retrieve the first "word" from the line
and uses this as the primary key to the record.  This key is then output
to standard output in a field `width' wide (default is 25) and justified
according to the -j switch (default left).  The two-word address from
markl is then output as decimal integers before the index record is
flushed.
.sp 1
.in 
FILES 
.br 
.in 7 
.sp 1 
.in 
SEE ALSO 
.br 
.in 7 
spell - spelling error finder; uses an isam-generated index
.sp 1 
.in 
DIAGNOSTICS 
.br 
.in 7 
.sp 1 
.in 
AUTHORS 
.br 
.in 7 
Joe Sventek
.sp 1 
.in 
BUGS 
.br 
.in 7 
