#-h- asplit.r        1772  asc  08-apr-81 08:06:12  [002,101]
#-h- main             880  asc  08-apr-81 08:05:53  [002,101]
 DRIVER(asplit)

 character header(5), tag(FILENAMESIZE), buf(MAXLINE), clower,
	   file(FILENAMESIZE)
 integer getlin, i, getarg, nmatch, out, open, verbos, scline

 data header/SHARP, MINUS, LETH, MINUS, EOS/
 data tag(1)/EOS/

 call query("usage:  asplit [-tstring] [-v].")
 verbos = NO
 for (i=1; getarg(i, buf, MAXLINE) != EOF; i=i+1)
    if (buf(1) == MINUS & clower(buf(2)) == LETT)
	call scopy(buf, 3, tag, 1)
    else if (buf(1) == MINUS & clower(buf(2)) == LETV)
	verbos = YES
    else
	{
	call putlin(buf, ERROUT)
	call remark(": invalid argument.")
	}
 out = STDOUT
 while (getlin(buf, STDIN) != EOF)
    if (nmatch(buf, 1, header) > 0)
	{
	call close(out)
	if (scline(buf, tag, file) == ERR)
	    call cant(buf)
	out = open(file, WRITE)
	if (out == ERR)
	    call cant(file)
	if (verbos == YES)
	    call remark(file)
	}
    else
	call putlin(buf, out)
 DRETURN
 end
#-h- nmatch           247  asc  08-apr-81 08:05:54  [002,101]
 integer function nmatch(lin, from, pat)

 character lin(MAXLINE), pat(ARB)
 integer from, i, j

 i = from
 for (j=1; pat(j) != EOS; j = j + 1)
    {
    if (lin(i) != pat(j))
	{
	nmatch = 0
	return
	}
    i = i + 1
    }
 nmatch = i
 return
 end
#-h- scline           459  asc  08-apr-81 08:05:55  [002,101]
 integer function scline(buf, tag, file)

 character buf(ARB), tag(ARB), file(ARB), type, c
 integer i, j

 for (i=1; buf(i) != BLANK; i=i+1) ;	# skip over header
 call skipbl(buf, i)			# skip over blanks
 c = type(buf(i))
 for (j=1; c == LETTER | c == DIGIT | c == PERIOD; j=j+1)
    {
    file(j) = buf(i)
    i = i + 1
    c = type(buf(i))
    }
 if (j == 1)
    scline = ERR
 else
    {
    call scopy(tag, 1, file, j)
    scline = OK
    }

 return
 end
#-h- asplit.rof      1768  asc  02-may-81 21:25:19  [002,100]
.in 5
.rm 75
.pl 60
.he 'ASPLIT'8/25/80'ASPLIT'
.fo //-#-/
.bp 1
NAME
.in +3

asplit - salvage garbaged archive files

.ti -3
SYNOPSIS

asplit <file [-tstring] [-v]

.ti -3
DESCRIPTION

asplit reads the standard input file, looking for lines beginning with the
archive header flag (#-h-).  Upon locating such a line, the next word after
the header is used to generate a file name, and all lines read up to the
next pseudo-header line are written onto that file.  When generating the
file name, only the characters found before a left parenthesis are used, if
one is found.  If the -t switch is used, the string appended to the -t is
appended to each file name before the file is opened, thus permitting
a fixed tag string to be formatted into the file name.  If the -v option
is specified, the name of each file is reported on ERROUT as it is opened.
Any lines found at the beginning of the file before the first pseudo-header
line is copied to standard output.

asplit is commonly used to salvage an archive which has been garbaged, or to
take a monster fortran source program file and break it up into subroutines.
A script file (breakup) may be found on the tools binary directory which will
cause each subprogram of the form "subroutine snarf" or "... function snarf" to
be placed on a file of the name "snarf.qq".  The only side effect of this
transformation is that the source will be in lower case, and may be remedied
by modifying the file breakup.

.ti -3
FILES

none

.ti -3
SEE ALSO

ar - file archiver: the -s switch does essentially the same thing as asplit,
except that it tries to rebuild the source file as a new archive, which does
not always work in pathological cases.

.ti -3
AUTHOR

asplit was written by Joe Sventek

.ti -3
BUGS/DEFICIENCIES
.br
