/*
         This file contains definitions  for  virtual  memory
         simulation  using files. Associated with these def's
         are the allocf/freefl routines etc. 
*/
#define AVAIL 520l    /*  location of the avail listhead           */
#define NIL 0l        /*  value of a null address                  */
#define SMALL 16l     /*  smallest block permited in free list     */
#define MINIMUM 8l    /*  least storage we will ever allocate      */
struct filefl {       /*  a free list in a file is forward linked  */
	long fsize;   /*  size of this free block                  */
	long floc;    /*  next free block (or NIL)                 */
	};
/*
    The  following  get  or put structures. They accept a seek address
    and a pointer to a structure. The pointer is used two ways, 1st to
    get the address in memory of the structure, and 2nd  the  compiler
    knows the size of the structure by using the pointer. 

    FILEX must be user defined (via a #define). It thus permits one to
    use  these  macros  and specify only once what the file descripter
    is. It is recommended that the file descripter used in a  file  is
    always the same name (in different functions). 

    As  a  check,  FILEX  must be defined before the user declares the
    include "files.h". 

*/

#define getn(seek,varr,size) getat(FILEX,seek,&varr,size)
#define putn(seek,varr,size) putat(FILEX,seek,&varr,size)
#define getvar(seek,varr) getat(FILEX,seek,&varr,sizeof(varr))
#define putvar(seek,varr) putat(FILEX,seek,&varr,sizeof(varr))
#define getstruct(seek,pointer) getat(FILEX,seek,pointer,sizeof(*pointer))
#define putstruct(seek,pointer) putat(FILEX,seek,pointer,sizeof(*pointer))

#define SLONG sizeof(long)
#define RELATIVE -1l     /* value for seek meaning from current place */

        extern putat();
        extern getat();
	extern long falloc();
	extern long ffree();
