(*
 
	Component :	READDIR.PAS  --  Summarize disk usage
 
	Date:		August 14, 1980
			August 25, 1980 -- ACCHIST.DAT added
			October 1, 1980 -- BIOMENTRICS read two disks
 
	Author:		Tom Mathieu
			Battelle-Northwest
			Box 999
			Richland, Washington 99352
			(509) 375-3711
 
	Source:		Swedish Pascal
 
	Calling Seq:	RUN [11,1]READDIR
 
	Inputs:		DR0:[0,0]*.DIR
			DR1:[0,0]*.DIR
 
	Outputs:	ACCDISKA.DAT
 
	Comments:
*)

 
PROGRAM READDIR (TTY);		(***   Disk Utilization Summary Analysis   ***)
 
 
TYPE	MDF = RECORD		(***   Master File Directory Record   ***)
		MDFID	: INTEGER;
		MDFSEQ  : INTEGER;
		MDFFIL	: INTEGER;
		MDFNAM  : ARRAY [1..3] OF INTEGER;
		MDFVER,MDFTYP  : INTEGER
		END;
 
	TWOCH = ARRAY [1..2] OF CHAR;
 
VAR	F,D	: TEXT;
	I,J	: INTEGER;
	M	: FILE OF MDF;
	DBLKS	: REAL;
	TBLKS   : REAL;
	HIGH,LOW,ISW : INTEGER;
	ILUN,IUNT : INTEGER;
	IDEV  : TWOCH;
	FUFD	: ARRAY[1..10] OF CHAR;
	FTYP	: ARRAY[1..3] OF CHAR;
	TODAY	: ARRAY [1..10] OF CHAR;
	SYSNAME : ARRAY [1..14] OF CHAR;
 
 
 
PROCEDURE R50ASC (VAR I,J:INTEGER; VAR C1:CHAR);   EXTERN(FORTRAN);
PROCEDURE GETSIZ (VAR C:CHAR; VAR I,J,K:INTEGER);  EXTERN(FORTRAN);
PROCEDURE GETSZ2 (VAR C:CHAR; VAR I,J,K:INTEGER);  EXTERN(FORTRAN);
 
 

(*$R-,T-*)
(*******************************************************************)
 
		(***  MAIN LINE  ***)
BEGIN
 
REWRITE(D,'ACCDISKA.DAT');
TIME(TODAY);
 
(****************   READ DISK USAGE FILE DR0:   ***********************)
 
WRITELN(TODAY,' Reading DR0: ...');
FUFD := '[   ,   ] ';
J := 0;  TBLKS := 0;
FUFD[10] := CHR(0);
RESET(M,'000000.DIR','(0,0)');
IF IORESULT(M) <> 1 THEN WRITELN('[0,0] File will not open')
ELSE
  WHILE NOT EOF(M)  DO
    BEGIN
    I := 3;
    R50ASC(I,M^.MDFNAM[1],FUFD[2]);
    R50ASC(I,M^.MDFNAM[2],FUFD[6]);
    R50ASC(I,M^.MDFTYP,   FTYP[1]);
    IF (FTYP='DIR') AND ((FUFD[4]<>'0') ! (FUFD[2]<>'0') ! (FUFD[3]<>'0')) THEN
     BEGIN
     GETSIZ(FUFD[1],HIGH,LOW,ISW);
     IF ISW < 0 THEN WRITELN('Disk error UIC -- ',FUFD)
     ELSE IF ISW > 0 THEN
      BEGIN
      IF LOW < 0 THEN BEGIN DBLKS := 2.0*HIGH+1; LOW := MAXINT+LOW+1 END
		 ELSE DBLKS := 2.0*HIGH;
      DBLKS := DBLKS * 32768.0 + LOW;
      WRITELN(D,FUFD,DBLKS:10:0,ISW);
      TBLKS := TBLKS + DBLKS;
      J := SUCC(J);
      END;
     END;
    GET(M);
    END;
 
 
WRITELN(D,'DR1:DSKUSE',0.0:10:0,0);

(****************   READ DISK USAGE FILE DR1:   ***********************)
 
TIME(TODAY);
WRITELN(TODAY,' Reading DR1: ...');
FUFD := '[   ,   ] ';
J := 0;  TBLKS := 0;
FUFD[10] := CHR(0);
RESET(M,'000000.DIR','(0,0)','DR1:');
IF IORESULT(M) <> 1 THEN WRITELN('DR1:[0,0] File will not open')
ELSE
  WHILE NOT EOF(M)  DO
    BEGIN
    I := 3;
    R50ASC(I,M^.MDFNAM[1],FUFD[2]);
    R50ASC(I,M^.MDFNAM[2],FUFD[6]);
    R50ASC(I,M^.MDFTYP,   FTYP[1]);
    IF (FTYP='DIR') AND ((FUFD[4]<>'0') ! (FUFD[2]<>'0') ! (FUFD[3]<>'0')) THEN
     BEGIN
     GETSZ2(FUFD[1],HIGH,LOW,ISW);
     IF ISW < 0 THEN WRITELN('Disk error UIC -- ',FUFD)
     ELSE IF ISW > 0 THEN
      BEGIN
      IF LOW < 0 THEN BEGIN DBLKS := 2.0*HIGH+1; LOW := MAXINT+LOW+1 END
		 ELSE DBLKS := 2.0*HIGH;
      DBLKS := DBLKS * 32768.0 + LOW;
      WRITELN(D,FUFD,DBLKS:10:0,ISW);
      TBLKS := TBLKS + DBLKS;
      J := SUCC(J);
      END;
     END;
    GET(M);
    END;
 
TIME(TODAY);
WRITELN(TODAY,' All done.');
END.
