;	BUILD TECO FOR RSX-11 AND VAX/VMS COMPATIBILITY MODE
; LINK TO FCSRES RESIDENT LIBRARY
;
; TASK BUILD FILE FOR RSX-11 TECO.  TO WORK IN ITS NORMAL FASHION,
; TECO SHOULD BE INSTALLED THRICE:
;
;	...MAK		FOR THE "MAKE" COMMAND
;	...MUN		FOR THE "MUNG" COMMAND
;	...TEC		FOR THE "TECO" COMMAND
;
; TO INSTALL IN VAX/VMS, COPY THE IMAGE INTO "SYS$SYSTEM:TEC.EXE".
; IF DESIRED, INSTALL AS OPEN WITH THE INSTALL UTILITY.
; DEFINE COMMANDS (IN YOUR LOGIN.COM):
;
;	$ MAKE :== "$SYS$SYSTEM:TEC MAKE"
;	$ MUNG :== "$SYS$SYSTEM:TEC MUNG"
;	$ TECO :== "$SYS$SYSTEM:TEC TECO"
;
TK:[1,54]TEC/CP/-FP/MM,MP:[43,10]TEC/MA/-SP=[43,10]TECFCS/MP

TASK=...TEC
PAR=GEN:0:60000
PRI=55
LIBR=FCSRES:RO:7
;
; LUN 1 IS USED FOR THE INDIRECT COMMAND FILE.
; LUN 2 IS USED FOR CONSOLE I/O.
; LUN 3 IS USED FOR THE OUTPUT FILE.
; LUN 4 IS USED FOR THE INPUT FILE.
; LUN 5 IS USED BY THE ERROR PROCESSOR.
; LUN 6 IS USED FOR THE TEMP DIRECTORY.
; LUN 7 IS USED FOR "EN" COMMANDS.
;
UNITS=7
ASG=SY:1:3:4:6:7
ASG=LB:5
ASG=TI:2
;
; PATCH THE LUN USED BY THE ERROR PROCESSOR (GERRM).
;
GBLPAT=ERRFMT:.EOLUN:5
;
; TE.INI IS A PATCH LOCATION TO CHANGE TECO START UP HANDLING.
;
;	000001 => AUTOMATICALLY LOAD VTEDIT
;	000002 => **INTERNAL, MUST NEVER BE SET**
;	000004 => DON'T TRY TO FIND OR USE MEMORY FILE (TECF00.TMP)
;	000010 => **INTERNAL, MUST NEVER BE SET**
;	000020 => USE VTEDIT SEEALL MODE
;	000040 => USE VTEDIT HOLD SCREEN MODE
;	000100 => **INTERNAL, MUST NEVER BE SET**
;	000200 => AUTOMATICALLY ENTER SPLIT SCREEN SCROLLING MODE
;	000400 => NO AUTOMATIC FILE CREATION IF SPECIFIED FILE DOESN'T EXIST
;	001000 => **INTERNAL, MUST NEVER BE SET**
;	002000 => NO AUTOMATIC MODULE UPDATES
;	004000 => **INTERNAL, MUST NEVER BE SET**
;	010000 => DON'T TRY TO FIND OR USE INITIALIZATION FILE (TECO.INI)
;	020000 => **INTERNAL, MUST NEVER BE SET**
;	040000 => **INTERNAL, MUST NEVER BE SET**
;	100000 => **INTERNAL, MUST NEVER BE SET**
;
GBLPAT=ROOT:TE.INI:0
;
; TECO DOESN'T NEED MUCH STACK SPACE, SO LIMIT THE SP STACK.
;
STACK=200
;
; TECO'S DYNAMIC MEMORY IS ALLOCATED FROM THE REGION STARTING AT THE
; END OF THE TASK IMAGE AND ENDING AT THE END OF THE PARTITION.
;
; RECOMMENDED MINIMUM TASK SIZE:
;
EXTTSK=6000
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF TECO'S PUSH DOWN LIST.
; IT MAY BE NECESSARY TO INCREASE THIS TO ACCOMMODATE MANY LEVELS OF
; ITERATION, MACRO CALLS, ETC.
;
GBLDEF=PDLSIZ:200
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF THE SEARCH BUFFER.
; IT MAY BE INCREASED TO ACCOMMODATE VERY LONG SEARCH STRINGS.
;
GBLDEF=SCHSIZ:200
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF THE TAG BUFFER.
; IT MAY BE INCREASED TO ACCOMMODATE VERY LONG TAGS.
;
GBLDEF=TAGSIZ:200
;
; THE REMAINING SPACE IS DYNAMICALLY SHARED BETWEEN TEXT BUFFER AND
; Q-REGISTER STORAGE.  THE FOLLOWING PARAMETER DEFINES THE MINIMUM
; AMOUNT OF SPACE REQUIRED:
;
GBLDEF=MBFSIZ:2000
;
/
