#-h- inclsym          210 asc 08-oct-80 07:48:05
 # definitions for INCL tool
 # put on a file named 'inclsym'
 # Used only by the include tool
 
 define(NFILES,arith(MAXOFILES,-,3))	#max nbr of included files
			#(should be max nbr of open files allowed -3)
#-h- incl.r          1777 asc 08-oct-80 07:48:06
#-h- main             300 asc 07-may-80 15:43:08
 #---------------------------------------------------------------------
 # include symbol definitions
 #        include symbols
         include inclsym
 #---------------------------------------------------------------------
##	incl -- main program
 
 
#	call initr4
#	call incl
#	call endr4
#	end
 
#-h- incls           1379 asc 07-may-80 15:43:09
 ## incl - replace include file by contents of line
# subroutine incl
 subroutine main
 character line(MAXLINE), str(MAXLINE)
 integer equal, getlin, getwrd, open
 integer infile(NFILES), len, level, loc
 integer getarg, i
 character incld(8)
 data incld(1) /LETI/
 data incld(2) /LETN/
 data incld(3) /LETC/
 data incld(4) /LETL/
 data incld(5) /LETU/
 data incld(6) /LETD/
 data incld(7) /LETE/
 data incld(8) /EOS/
 
 for (i=1; ; i=i+1)
	{
	if (getarg(i, line, MAXLINE) == EOF)
		{
		if (i!= 1)  break
		infile(1) = STDIN
		}
	else if (line(1) == MINUS & line(2) == EOS)
		infile(1) = STDIN
	else if (line(1) == QMARK & line(2) == EOS)
		call error ('usage:  incl [file ...].')
	else
		{
		infile(1) = open(line,READ)
		if (infile(1) == ERR)
			call cant (line)
		}
	for (level=1; level > 0; level = level - 1)
		{
		while (getlin(line, infile(level)) != EOF)
			{
			loc = 1
			len = getwrd(line, loc, str)
			call fold(str)		#fold to lower case
			if (equal(str,incld) == NO)
				call putlin (line, STDOUT)
			else
				{
				level = level + 1
				if (level > NFILES)
				  call error ('includes nested too deeply.')
				len = getwrd(line, loc,str)
				infile(level) = open(str,READ)
				if (infile(level) == ERR)
				  call cant (str)
				}
			}
		if (infile(level) != 1)
			call close (infile(level))
		}
	if (infile(1) != STDIN)
		call close (infile(1))
	}
 
 return
 end
