C
C
C	P D S U P X . C O M
C	===================
C	                   
C
C  COMPONENT:	USER PROFILE EXTENSION FILE DEFINITION AND COMMON
C  ---------
C
C  DATE:	27-FEB-80
C  ----
C
C  AUTHOR:	GR JOHNSON
C  ------	BATTELLE NORTHWEST
C		P O BOX 999
C		RICHLAND WA 99352
C
C  SOURCE:	FORTRAN IV-PLUS
C  ------
C
C
C  SELECT UPX PROCESSING:
C  ---------------------
C
C >>>
C >>>	PARAMETER UPX = .TRUE.		! UPX PROCESSING ENABLED
	PARAMETER UPX = .FALSE.		! UPX PROCESSING DISABLED
C
C
C  OPEN PARAMETERS:
C  ---------------
C
C	NAME		= UPXFNM
C	ACCESS		= 'DIRECT'
C	FORM		= 'UNFORMATTED'
C	RECORDSIZE	= 8
C
C
C  FILE NAME:
C  ---------
C
	PARAMETER UPXFNM = 'LB:[1,100]PDSUPX.DAT'
C
C
C  RECORD BUFFER:
C  -------------
C
	BYTE	  UPXREC(32)
C
C
C  RECORD DEFINITION:
C  -----------------
C
	INTEGER	  UPXUSN(4)		! USERNAME
	INTEGER	  UPXUSR		!     USER
	INTEGER	  UPXWON(2)		!     WORK-ORDER
	INTEGER	  UPXSUF		!     SUFFIX
C					!
	INTEGER	  UPXUIC		! USER-ID CODE
C					!
	INTEGER	  UPXPRI		! DEFAULT PRIVILEGE MASK
	INTEGER	  UPXBPR		! DEFAULT PRIVILEGE MASK (BATCH)
C					!
	INTEGER	  UPXUNA		! USERNAME AUTHORIZATION STATUS
C					!
	REAL	  UPXCHG		! YTD CHARGES
	INTEGER	  UPXDLC		! DATE LAST CHARGED
C					!
	INTEGER	  UPXWOF		! PDSWOF RECORD POINTER
	INTEGER	  UPXUDF		! PDSUDF RECORD POINTER
C					!
	BYTE	  UPXXXX(6)		! RESERVED
C
	EQUIVALENCE (UPXUSN,UPXREC(1))
	EQUIVALENCE (UPXUSR,UPXREC(1))
	EQUIVALENCE (UPXWON,UPXREC(3))
	EQUIVALENCE (UPXSUF,UPXREC(7))
	EQUIVALENCE (UPXUIC,UPXREC(9))
	EQUIVALENCE (UPXPRI,UPXREC(11))
	EQUIVALENCE (UPXBPR,UPXREC(13))
	EQUIVALENCE (UPXUNA,UPXREC(15))
	EQUIVALENCE (UPXCHG,UPXREC(17))
	EQUIVALENCE (UPXDLC,UPXREC(21))
	EQUIVALENCE (UPXWOF,UPXREC(23))
	EQUIVALENCE (UPXUDF,UPXREC(25))
	EQUIVALENCE (UPXXXX,UPXREC(27))
C
C
C  RECORD ACCESS POINTERS:
C  ----------------------
C
C  USER PROFILE EXTENSION (UPX) RECORDS ARE MAPPED INTO THE USER PROFILE
C  FILE AS FOLLOWS:
C
C		  UPXPNT = (UPFPNT - UPFFRP) + UPXFRP
C
C		  UPXFRP = 2
C		  UPXLRP = (UPFLRP - UPFFRP) + UPXFRP
C
C		  UPXERP = (UPFERP - UPFFRP) + UPXFRP
C
C
	INTEGER	  UPXPNT		! RECORD POINTER
C
	PARAMETER UPXFRP = 2		! FIRST RECORD POINTER
	INTEGER	  UPXLRP		! LAST RECORD POINTER
C
	INTEGER	  UPXERP		! EMPTY RECORD POINTER
C
C
C  USERNAME AUTHORIZATION STATUS BIT FLAGS:
C  ---------------------------------------
C
	PARAMETER UNANTU = 1		! OFF-HOUR PROCESSING ENABLED
	PARAMETER UNADAL = 2		! DISK ALLOCATION EXCEEDED
	PARAMETER UNAREM = 4		! USERNAME FLAGGED FOR REMOVE
C
C
C  COMMON BLOCK DEFINITION:
C  -----------------------
C
	COMMON /PDSUPX/	UPXREC,
	2		UPXPNT,UPXLRP,UPXERP
C
C

