/*
 * I/O vector.
 * Defined in `as'.
 */
typedef struct {
	int	v_flag;		/* Flags */
	int	v_uget;		/* Unget char., -1 if none */
	inT	v_r0;		/* Temp 0 */
	inT	v_r1;		/* Temp 1 */
	char	*v_rbuf;	/* Rec. buf ptr. */
	int	v_rbsz;		/* Rec. buf size */
	int	v_iosb[2];	/* I/O status block */
	int	v_lun;		/* Logical unit number */
	long	v_rblk;		/* Seek block */
	int	v_rbyt;		/* Seek byte */
	char	*v_bbuf;	/* Block buf. ptr. */
	char	v_rtyp;		/* Record type */
	char	v_ratt;		/* Record attributes */
	int	v_rsiz;		/* Size of largest record */
	long	v_hibk;		/* Size of file (blocks) */
	long	v_efbk;		/* EOF block, write seek block */
	int	v_ffby;		/* EOF bytes, write seek byte */
	int	v_fid[3];	/* File id */
	int	v_fnam[3];	/* File name (RAD50) */
	int	v_ftyp;		/* File type (RAD50) */
	int	v_fver;		/* File version */
	int	v_stat;		/* FNB status */
	int	v_next;		/* FNB search status */
	int	v_did[3];	/* Directory file id */
	char	v_dvnm[2];	/* Device name */
	int	v_unit;		/* Unit number */
} iov_t;

/* Flags */
#define VF_OUT	0100000		/* Output IOV */
#define VF_REC	040000		/* Record device */
#define VF_TTY	020000		/* Terminal device */
#define VF_EOF	010000		/* Input device at EOF */
#define VF_ERR	004000		/* Error */
#define VF_FIL	002000		/* File accessed on LUN */
#define VF_BAD	001000		/* Buffer bad */
#define VF_NOS	000400		/* No newlines (output) */
#define VF_UBF	000200		/* Unbuffered */
#define VF_EOR	(VF_EOF|VF_ERR)	/* End of input mask */
