/*
 * deadly.h
 * Header file.
 */
#define	NONE	0		/* None of the specials */
#define	TOP	1		/* Top of screen */
#define	BOTTOM	2		/* Bottom of the screen */
#define LEFT	3		/* Left arrow */
#define RIGHT	4		/* Right arrow */
#define	ENTER	5		/* Enter data */
#define	DELETE	6		/* Delete entry */
#define	QUIT	7		/* Quit */
#define REFRESH 8		/* Refresh screen */
#define	SKIP	9		/* Skip field */

/*
 * Colour.
 */
#define	DARK	0		/* Default background */
#define	DIM	1		/* Default fixed */
#define	BRIGHT	2		/* Default item */

/*
 * Structure describing a screen.
 */
struct	screen
{
	int	s_current;	/* Current item - first = 0 */
	char	s_fcolour;	/* Current foreground colour */
	char	s_bcolour;	/* Current background colour */
	struct	fixed *s_fixed;	/* Ptr. to fixed part */
	int	s_nfixed;	/* Number of them */
	struct	item  *s_item;	/* Ptr. to items */
	int	s_nitem;	/* Number of them */
	int	s_botlim;	/* Bottom limit */
	int	s_toplim;	/* Top limit */
};

/*
 * Structure describing the fixed
 * part of a screen.
 */
struct	fixed
{
	char	f_row;		/* Row */
	char	f_col;		/* Column */
	char	*f_data;	/* Stuff */
};

/*
 * Structure describing an item
 * on the screen.
 */
struct	item
{
	char	i_row;		/* Row */
	char	i_col;		/* Column */
	char	i_style;	/* Style */
	char	i_flag;		/* Flags */
	char	i_fcolour;	/* Foreground colour */
	char	i_bcolour;	/* Background colour */
	int	i_size;		/* Field size */
	char	*i_tmpl;	/* Template */
	char	*i_old;		/* Old data */
	char	*i_new;		/* New data */
};

/* Styles */
#define	I_ALPHA	0		/* Alpha */
#define	I_NUM	1		/* Numeric */

/* Flags */
#define I_SYS	01		/* System item, protected, call on entry */
#define I_OP	02		/* Operator entered item */
#define I_EXIT	04		/* Call sys after operator entry */
#define	I_NECHO	010		/* No echo */
#define I_SKIP  020		/* No call and no operator. 13-Jul-79 */

/*
 * Externals.
 */
extern	int	nscreen;
extern	FILE	*tfp;
extern	struct	screen	*csp;
extern	struct	screen	screen[];
extern	struct	item	*itemptr();

/*
 * Macros.
 */
#define	citem	(csp->s_current)
#define botlim  (csp->s_botlim)
#define toplim  (csp->s_toplim)
