10	REM OTHELLO AUTHOR RICHARD DUDA PAGE 61 OCT 77 BYTE
20	REM PLAYS OTHELLO WITH TWO STRATEGIES:
30	REM   1 TAKE THE MAX NUMBEROR OF PIECES
40	REM    2 ADD A BONUS FOR OUTSIDE POSITION
50	REM BOARD IS THE ARRAY A, BOUNDED BY 0'S(BLANKS)
60	REM  A=0 FOR EMPTY
70	REM  A=B FOR BLACK--X(INTERNALLY -1)
80	REM  A=W FOR WHITE--0 (INTERNALLY +1)
90	REM I AND J ALWAYS USED FOR ROW/COL INDICES
100	REM I4 AND J4 STORE INCREMENTS TO THE 8 NEIGHBORS
110	REM C$ AND D$ STORE CHARACTERS A-H,X,.,0 FOR OUTPUT
120	DIM A(9,9),I4(8),J4(8),C$(8),D$(2)
130	REM INITIAL GREETING
140	PRINT "GREETINGS FROM OTHELLO"
150	PRINT "DO YOU WANT INSTRUCTIONS?  (Y OR N)";
160	INPUT X$
170	IF X$ = "N" THEN 390
180	IF X$ <> "Y" THEN 160
190	PRINT
200	PRINT "OTHELLO IS PLAYED ON AN 8 X 8 CHECKER BOARD,"
210	PRINT "ROWS NUMBERED 1 TO 8 AND COLS A TO H."
220	PRINT "THE INITIAL CONFIGURATION IS ALL BLANK, EXCEPT"
230	PRINT "FOR THE CENTER FOUR SQUARES, WHICH FORM THE"
240	 PRINT "FOLLOWING PATTERN:"
250	PRINT"       0 X"
260	 PRINT "       X 0"
270	PRINT
280	PRINT "TRY TO PLACE YOUR PIECE SO THAT IT 'OUTFLANKS'"
290	PRINT"MINE, CREATING A HORIZONTAL,  VERTICAL, OR"
300	PRINT"DIAGONAL RUN OF MY PIECES BOUNDED AT EACH END"
310	PRINT "BY AT LEAST ONE OF YOURS. THIS WILL 'FLIP' MY" 
320	PRINT "PIECES, TURNING THEM INTO YOURS."
330	PRINT "NOTE: YOU MUST CAPTURE AT LEAST ONE OF MY"
340	PRINT "PIECES IN THIS WAY IF IT IS AT ALL POSSIBLE."
350	PRINT "IF IT IS NOT POSSIBLE, YOU FORFEIT YOUR TURN BY"
360	PRINT "ENTERING 0,0 FOR YOU (ROW,COL) MOVE."
370	PRINT
380	REM INITIALIZE
390	PRINT "SHOULD I WAIT BEFORE MAKING MY MOVES? (Y OR N) ";
400	F2=0
410	INPUT X$
420	IF X$ ="N" THEN 460
430	IF X$ <> "Y" THEN 410
440	F2 =1
450	PRINT "OK. TYPING ANY CHARACTER WILL LET ME GO."
460	PRINT "SHOULD I PLAY MY BEST STRATEGY (Y OR N) ";
470	S2 =0
480	INPUT X$
490	IF X$ = "N" THEN 520
500	IF X$ <> "Y" THEN 480
510 	S2=2
520	B=-1
530	W=+1
540	D$(B+1)="X"
550	D$(0+1)="."
560	D$(W+1)="0"
565	DATA 0,-1,-1,-1,0,1,1,1
570	FOR K= 1 TO 8
580	READ I4(K)
590	NEXT K
600	DATA 1,1,0,-1,-1,-1,0,1
610	FOR K=1 TO 8
620	READ J4(K)
630	NEXT K
641	C$(1)="A"
642	C$(2)="B"
643	C$(3)="C"
644	C$(4)="D"
645	C$(5)="E"
646	C$(6)="F"
647	C$(7)="G"
648	C$(8)="H"
690	REM SET UP A NEW GAME
700	FOR I=0 TO 9
710	FOR J=0 TO 9
720	A(I,J)=0
730	NEXT J
740	NEXT I
750	A(4,4)=W
760	A(5,5)=W
770	A(4,5)=B
780	A(5,4)=B
790	C1=2
800	H1=2
810	N1=4
820	Z=0
830	REM HUMAN'S CHOICES
840	PRINT "DO YOU WANT TO HAVE X OR O ";
850	C=W
860	H=B
870	INPUT X$
880	IF X$ = "X" THEN 920
890	IF X$ <> "O" THEN 870
900	C=B
910 	H=W
920	PRINT "DO YOU WANT TO GO FIRST (Y OR N) ";
930	INPUT X$
940	IF X$="N" THEN 1020
950	IF X$<>"Y" THEN 930
960	REM PRINT INITIAL BOARD
970	GOSUB 3100
980	GOTO 1690
990	REM COMPUTER'S MOVE
1000	IF F2=0 THEN 1020
1010	INPUT X$
1020	B1=-1
1030	I3=0
1035	J3=0
1040	T1=C
1050	T2=H
1060	REM SCAN FOR BLANK SQUARE
1070	FOR I=1 TO 8
1080	FOR J=1 TO 8
1090	IF A(I,J)<>0THEN 1380
1100	REM FOUND A BLANK SQUARE
1110	REM DOES IT HAVE AN OPPONENT NEIGHBOR?
1120 	GOSUB 2620
1130	IF F1=0 THEN 1380
1140	REM FOUND AN OPPONENT NEIGHBOR
1150	REM HOW MANY OF HIS PIECES CAN I FLIP?
1160	REM (DON'T DO IT NOW)
1170	U=-1
1180	GOSUB 2820
1190	REM ECTRA POINTS FOR BOUNDARY POSITIO
1200	IF S1=0 THEN 1380
1210 	IF 0+(I-1)*(I-8)<>0 THEN 1230
1220	S1=S1+S2
1230	IF 0+(J-1)*(J-8)<>0 THEN 1260
1240	S1=S1+S2
1250	REM IS THIS BETTER THAN THE BEST FOUND SO FAR?
1260	IF S1< B1 THEN 1380
1270	IF S1> B1 THEN 1340
1280	REM  A TIE -- RANDOM DECISION
1290	REM THE NEXT TWO CAN BE DELETED IF NO
1300	REM RANDOM NUMBER GENERATER IS AVAILABLE.
1310	R=RND(1)
1320	IF R> .5 THEN 1380
1330	REM YES
1340	B1=S1
1350	I3=I
1360	J3=J
1370	REM END OF SCAN LOOP
1380	NEXT J
1390	NEXT I
1400	REM COULD WE DO ANYTHING?
1410	IF B1>0 THEN 1480
1420	REM NO
1430	PRINT "I HAVE TO FORFEIT MY MOVE"
1440	IF Z=1 THEN 2190
1450	Z=1
1460	GO TO 1690
1470	REM MAKE THE MOVE
1480	Z=0
1490	PRINT "I WILL MOVE TO  ";
1500	PRINT I3;
1510	PRINT ", ";
1520	PRINT C$(J3)
1530	I=I3
1540	J=J3
1550	U=1
1560	GOSUB 2820
1570	C1=C1+S1+1
1580	H1=H1-S1
1590	N1=N1+1
1600	PRINT "THAT GIVES ME ";
1610	PRINT S1;
1620	PRINT " OF YOUR PIECES"
1630	REM PRINT OUT BOARD
1640	GOSUB3100
1650	REM TEST FOR END OF GAME
1660	IF H1=0 THEN 2190
1670	IF N1=64 THEN 2190
1680	REM HUMAN'S MOVE
1690	T1=H
1700	T2=C
1710	PRINT "YOUR MOVE -- (ROW,COL) ";
1720	INPUT I,X$
1730	IF I<0 THEN 1710
1740	IF I>8 THEN 1710
1750	IF I<>0 THEN 1820
1760	PRINT "ARE YOUR FORFEITING YOUR TURN (Y OR N)? "
1770	INPUT X$
1780	IF X$ <> "Y" THEN 1710
1790	IF Z=1 THEN 2190
1800	Z=1
1810	GO TO 1000
1820 	J=POS("ABCDEFGH",X$)
1830	IF J=0 GO TO 1720
1860	REM CHECK IF BLANK
1870	IF A(I,J) =0 THEN 1910
1880	PRINT "SORRY, THAT SQUARE IS OCCUPIED -- TRY AGAIN"
1890	GO TO 1720
1900	REM CHECK FOR LEGAL NEIGHBOR
1910	GOSUB 2620
1920	IF F1=1 THEN 1970
1930	PRINT "SORRY, YOU ARE NOT NEXT TO ONE OF MY PIECES";
1940	PRINT " --  TRY AGAIN"
1950	GO TO 1720
1960	REM CHECK IF LEGAL RUN
1970	U=-1
1980	GOSUB 2820
1990	IF S1>0 THEN 2030
2000	PRINT "SORRY, THAT DOESN'T FLANK A ROW -- TRY AGAIN"
2010	GO TO 1720
2020	REM EVERYTHING LEGAL -- MAKE HUMAN MOVE
2030	Z=0
2040	PRINT "THAT GIVES YOU ";
2050	PRINT S1;
2060	PRINT " OF MY PIECES"
2070	U=1
2080	GOSUB2820
2090	H1=H1+S1+1
2100	C1=C1-S1
2110	N1=N1+1
2120	REM PRINT OUT BOARD
2130	GOSUB 3100	
2140	REM TEST FOR END OF GAME
2150	IF C1=0 THEN 2190
2160	IF N1=64 THEN 2190
2170	GO TO 1000
2180	REM END OF GAME WRAPUP
2190	PRINT
2200	PRINT "YOU HAVE ";
2210	PRINT H1;
2220	PRINT " PIECES AND I HAVE ";
2230	PRINT C1;
2240	PRINT " PIECES"
2250	IF H1=C1 THEN 2290
2260	IF H1>C1 THEN 2310
2270	PRINT " WELL I WON THAT ONE"
2280	GO TO 2320
2290	PRINT "A TIE!!"
2300	GO TO 2500
2310	PRINT "YOU WON."
2320	C1=C1-H1
2330	IF C1>0 THEN 2350
2340	C1=-C1
2350	C1=(64*C1)/N1
2360	PRINT "THAT WAS A ";
2370	IF C1<11 THEN 2490
2380	IF C1<25 THEN 2470
2390	IF C1<39 THEN 2450
2400	IF C1<53 THEN 2430
2410	PRINT "PERFECT GAME"
2420 GO TO 2500
2430	PRINT "WAKAWAY"
2440	GO TO 2500
2450	PRINT "FIGHT"
2460	GO TO 2500
2470	PRINT "HOT GAME"
2480	GO TO 2500
2490	PRINT "SQUEAKER"
2500	PRINT
2510	PRINT"DO YOU WANT TO PLAY ANOTHER GAME (Y OR N)?";
2520	INPUT X$
2530	IF X$="Y" THEN 700
2540	IF X$<>"N" THEN 2520
2550	PRINT "THANKS FOR PLAYING"
2560	STOP
2620	FOR I1=-1 TO 1
2630	FOR J1 =-1 TO 1
2640	IFA(I+I1,J+J1) = T2 THEN 2710
2650	NEXT J1
2660	NEXT I1
2680	F1=0
2690	RETURN
2710	F1=1
2720	RETURN
2820	S1=0
2830	FOR K=1 TO 8
2840	I5=I4(K)
2850	J5=J4(K)
2860	I6=I+I5
2870	J6=J+J5
2880	S3=0
2890	IF A(I6,J6) <> T2 THEN 3070
2900	REM LOOP THROUGH THE RUN
2910	S3=S3+1
2920	I6=I6+I5
2930	J6=J6+J5
2940	IF A(I6,J6) =T1 THEN 2970
2950	IF A(I6,J6) =0 THEN 3070
2960	GO TO 2910
2970	S1=S1+S3
2980	IF U<>1 THEN 3070
2990	REM UPDATE BOARD
3000	I6=I
3010	J6=J
3020	FOR K1= 0 TO S3
3030	A(I6,J6)=T1
3040	I6=I6+I5
3050	J6=J6+J5
3060	NEXTK1
3070	NEXT K
3080	RETURN
3090	REM SUB PRINT BOARD
3100	PRINT
3110	PRINT "   A B C D E F G H"
3120	FOR I=1 TO 8
3130	PRINT I;
3140	FOR J=1 TO 8
3160	PRINT LEFT(D$(A(I,J)+1),2);
3170	NEXT J
3180	PRINT
3190	NEXT I
3200 PRINT
3210    RETURN
3220	END
