/
/ PDP-11 C.
/ Stdio.
/
/ I/O Vector.
/

	.globl	V_FLAG,	VF_OUT,	VF_TTY,	VF_EOF,	VF_ERR
	.globl	V_UGET,	V_R0,	V_R1,	V_RBUF,	V_RBSZ
	.globl	V_IOSB,	V_LUN,	V_RBLK,	V_RBYT,	V_BBUF
	.globl	V_RTYP,	V_RATT,	V_RSIZ,	V_HIBK,	V_EFBK
	.globl	V_FFBY,	V_FID,	V_FNAM,	V_FTYP,	V_FVER
	.globl	V_STAT,	V_NEXT,	V_DID,	V_DVNM,	V_UNIT
	.globl	V_LENG,	VF_REC,	VF_FIL,	VF_BAD,	VF_EOR
	.globl	VF_NOS, VF_UBF, VF_H72, VF_H26

V_FLAG	=	0		/Flags
	VF_OUT	=	100000		/Output IOV
	VF_REC	=	040000		/Record device
	VF_TTY	=	020000		/TTY device
	VF_EOF	=	010000		/Input device at EOF
	VF_ERR	=	004000		/Error
	VF_FIL	=	002000		/File accessed on lun
	VF_BAD	=	001000		/Buffer bad
	VF_NOS	=	000400		/No newlines (output)
	VF_UBF	=	000200		/Unbuffered
	VF_H72	=	000100		/Handshake - 7221
	VF_H26	=	000040		/Handshake - 2649
	VF_EOR	=	VF_EOF+VF_ERR	/End of input mask

V_UGET	=	V_FLAG+2	/Ungetc character
V_R0	=	V_UGET+2	/Temp 0
V_R1	=	V_R0+2		/Temp 1
V_RBUF	=	V_R1+2		/Pointer to record buffer
V_RBSZ	=	V_RBUF+2	/Record buffer size
V_IOSB	=	V_RBSZ+2	/I/O status block
V_LUN	=	V_IOSB+4	/Lun
V_RBLK	=	V_LUN+2		/Seek address
V_RBYT	=	V_RBLK+4	/Byte address
V_BBUF	=	V_RBYT+2	/Block buffer pointer

/
/ This section is a copy of the FCS sttributes area
/ of an FDB.
/

V_RTYP	=	V_BBUF+2	/Record type
V_RATT	=	V_RTYP+1	/Record attributes
V_RSIZ	=	V_RATT+1	/Record size
V_HIBK	=	V_RSIZ+2	/Highst block in the file
V_EFBK	=	V_HIBK+4	/EOF block in the file
V_FFBY	=	V_EFBK+4	/First free byte in the file

/
/ This section is a copy of a filename block.
/

V_FID	=	V_FFBY+2	/File id
V_FNAM	=	V_FID+6		/File name
V_FTYP	=	V_FNAM+6	/File type
V_FVER	=	V_FTYP+2	/File version
V_STAT	=	V_FVER+2	/Filename block status
V_NEXT	=	V_STAT+2	/Context for next find
V_DID	=	V_NEXT+2	/Directory id
V_DVNM	=	V_DID+6		/Device name
V_UNIT	=	V_DVNM+2	/Device unit

V_LENG	=	V_UNIT+2	/Size of IOV
