/
/ Fskip.
/

	.globl	fskip

/
/ fskip(fp);
/ FILE *fp;
/
/ This unusual routine skips over the next record in
/ a disc file.
/ It gets an error on record devices.
/ Returns the size of thr record that it skipped, or
/ 0 on errors. Note that 0 is a valid record size,
/ and `feof' and/or `ferr' should be called.
/

fskip:	jsr	r0,__csav	/Get a frame.

	mov	12(r5),r4	/r4 = `fp'
	bit	$VF_EOR,(r4)	/At EOF or ERR?
	bne	3f		/Yes, nop.

	bit	$VF_REC,(r4)	/Record device?
	beq	2f		/No
	bis	$VF_ERR,(r4)	/If so, error
	br	3f

2:	bit	$VF_FIL,(r4)	/File on the lun?
	beq	1f		/No
	cmp	V_RBLK(r4),V_EFBK(r4) /Check for end of file
	bhi	0f
	blo	1f
	cmp	V_RBLK+2(r4),V_EFBK+2(r4)
	bhi	0f
	blo	1f
	cmp	V_RBYT(r4),V_FFBY(r4)
	blo	1f

0:	bis	$VF_EOF,(r4)	/Set `at eof' flag.
	br	3f

1:	bitb	$R.FIX,V_RTYP(r4) /If fixed length records
	beq	0f
	mov	V_RSIZ(r4),r3	/Get FCS size
	br	1f

0:	call	get		/Get RCW
	mov	r0,r3
	call	get
	swab	r0
	bis	r0,r3

	bitb	$FD.BLK,V_RATT(r4) /RCW = -1 magic
	beq	1f
	cmp	r3,$-1
	bne	1f
	call	next
	br	2b

1:	mov	r3,r2		/Skip over the record

0:	dec	r2
	bmi	0f
	call	get
	br	0b

0:	bit	$1,r3		/If odd, skip pad byte
	beq	0f
	call	get

0:	bitb	$R.FIX,V_RTYP(r4) /FD.BLK skip.
	beq	0f
	bitb	$FD.BLK,V_RATT(r4)
	beq	0f
	call	next

0:	mov	r3,r0		/Return size
	br	0f

3:	clr	r0		/Error, return 0

0:	jmp	__cret

/
/ Advance to next block.
/

next:	add	$1,V_RBLK+2(r4)	/Fix block number
	adc	V_RBLK(r4)
	clr	V_RBYT(r4)	/Byte 0
	bis	$VF_BAD,(r4)	/Must do a read!
	return

/
/ Get byte.
/

get:	cmp	V_RBYT(r4),$512. /At end of block
	blo	0f
	call	next		/Next block.

0:	bit	$VF_BAD,(r4)	/Need to read?
	beq	0f
	bic	$VF_BAD,(r4)
	call	__rvb

0:	mov	V_RBYT(r4),r0	/Get byte number.
	inc	V_RBYT(r4)
	add	V_BBUF(r4),r0	/Get pointer.
	movb	(r0),r0		/The byte
	bic	$!377,r0
	return
