;************************************************************************
;************************************************************************
;***********************       S R D . C M D        *********************
;************************************************************************
;************************************************************************
.GOTO BEGIN
;
;	S R D . C M D	V5.0	19-Nov-79
;
;	This command file was created along with version 5.0
;	of SRD. It is intended for use with ...AT., and seems
;	to work under IAS V3.0, and RSX-11M V3.1 and 3.2.
;
;	This command file will create the necessary files to build
;	SRD, and optionally assemble and task-build.
;
;	TO BUILD SRD FOR THE FOLLOWING SYSTEMS:
;
;	R$$11M	--	RSX-11M MAPPED
;	R$$11U	--	RSX-11M UNMAPPED
;	R$$11D	--	RSX-11D
;	I$$AS	--	IAS V3.0
;
;
.BEGIN:	.SETF	R$$11M
	.SETF	R$$11U
	.SETF	D$$CAL
	.SETF	F$$CS
	.SETF	R$$11D
	.SETF	I$$AS
	.SETF	W$$ILD
	.SETT	E$$IS
	.ENABLE	ESCAPE
;
;	Question/Answer phase
;	
;	To get help hit ESCAPE from any prompt.
;
.0010:	.ASK	SYSTEM	Are you using RSX-11M, MAPPED 
	.IFF	<ESCAPE>	.GOTO	0020
;
;	If you are using RSX-11M V3.0 or later, and you
;	are using the MAPPED system, answer yes to this
;	question.
;
	.GOTO	0010
;
.0020:	.IFF	SYSTEM	.GOTO 0100
	.SETT	R$$11M
	.SETS	OPTNS	"/MM"
	.SETS	SY$TEM	"11M"
	.ASK	D$$CAL	Are you using dynamic checkpoint allocation
.0030:	.IFF	<ESCAPE>	.GOTO	0040
;
;	If your system is generated with dynamic checkpoint
;	allocation, and you want SRD to take advantage of
;	it, answer yes to the following question.
;
	.GOTO	0030
;
.0040:	.ASK	F$$CS	Are you using FCSRES
	.IFF	<ESCAPE>	.GOTO	0050
;
;	If you have built FCSRES on your system, it will be
;	used by SRD, thus decreasing the total size of SRD
;	by approximately 3 k-words.
;
	.GOTO	0040
;
.0050:	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0400
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0050
;
.0100:	.ASK	SYSTEM	Are you using RSX-11M, UNMAPPED
	.IFF	<ESCAPE>	.GOTO	0110
;
;	If you are using RSX-11M UNMAPPED, answer yes
;	to the following question. This merely tells the
;	taskbuilder to build the task with the /-MM switch.
;
	.GOTO	0100
;
.0110:	.IFF	SYSTEM	.GOTO 0200
	.SETT	R$$11U
	.SETS	OPTNS	"/-MM"
	.SETS	SY$TEM	"11U"
;
.0150:	.ASK	E$$IS	Does your machine have EIS
	.IFF	<ESCAPE>	.GOTO	0400
;
;	EIS stands for the Extended Instruction Set. This question
;	is asked so that the SOB instruction can be correctly
;	simulated on a non-EIS machine. (E.G. 11-03,11-40, etc)
;
	.GOTO	0150
;
.0200:	.ASK	SYSTEM	Are you using RSX-11D
	.IFF	<ESCAPE>	.GOTO	0210
;
;	If you are using RSX-11D V6.2 or before, then answer yes to
;	the following question. Note that this will produce
;	the exact same SRD as for IAS, except that the naming
;	conventions will be different.
;
	.GOTO	0200
;
.0210:	.IFF	SYSTEM  .GOTO 0300
	.SETS	OPTNS	"/MU"
	.SETT	R$$11D
	.SETS	SY$TEM	"11D"
	.GOTO	0400
;
.0300:	.ASK	SYSTEM	Are you using IAS
	.IFF	<ESCAPE>	.GOTO	0310
;
;	If you are using any of the three flavors of IAS V3.0 or
;	IAS V2.0, answer yes to the following question. Note that
;	in the task-build command file, that SYSRES is used as the
;	default system library.
;
	.GOTO	0300
;
.0310:	.IFF	SYSTEM  .GOTO BEGIN
	.SETS	OPTNS	"/MU"
	.SETT	I$$AS
	.SETS	SY$TEM	"IAS"
	.GOTO	0400
;
.0400:	.ASK	W$$ILD	Do you want special WILDCARD support
	.IFF	<ESCAPE>	.GOTO	0410
;
;	If the conditional symbol WILD$ is  defined  in  SRDPRE.MAC,
;	treat  the  file  specification  string given in the command
;	line as if it has wild card matching after the name and type
;	fields  given,  unless  /DE,  /SD,  or /PU is specified (but
;	never if the file specification appears in an /SE:  or  /SD:
;	switch).  A previous version of SRD treated any file specif-
;	ication in this manner, even if  it  appeared  in  the  /SE:
;	switch.   Thus  there  was  no method of obtaining only *.CM
;	files, if any *.CMD files existed, or only TALL.*  files  if
;	any  TALLER.* files existed.  The version from the New Orle-
;	ans tape corrected this problem.  However, to list all files
;	beginning  with OMSI, one must specify >SRD /SE:OMSI* rather
;	than simply >SRD OMSI .  In order to make SRD easier to  use
;	in our most common situation, without removing its new capa-
;	bility, we chose to make this modification.   If  any  files
;	are to be deleted, we always require the stricter syntax, to
;	help insure that no file is deleted just  because  its  name
;	may be similar to those being deleted.
;
	.GOTO	0400
;
.0410:	.ASKN	[1024.:24576.:8192.] EXTEND	Enter task extension
	.IFF	<ESCAPE>	.GOTO	0420
;
;	The task extension defines the buffer area used by SRD to
;	read the directory file into. The task extension must be 
;	specified in units of 256. word blocks. A good means of
;	determining the size needed is to look at the [0,0] directory
;	for the largest directory file, and have this extension large
;	enough to handle it. The smallest extension(1024.) will handle
;	directories up to 4. blocks long, where the largest extension
;	(24576.) will handle directories up to 98. blocks long. The
;	default extension will handle directories up to 32. blocks long.
;
	.GOTO 0410
;
.0420:	.ASK	PROCED	Q/A complete, do you want to continue
	.IFF	<ESCAPE>	.GOTO	0422
;
;	If you answer Y, then the command files to build SRD will
;	be created. If you answer N, then this command file will
;	exit without generating anything but a passing memory.
;
	.GOTO	0420
;
.0422:	.IFF	PROCED	/
	.ENABLE	SUBSTITUTION
;	Creating SRD'SY$TEM'.TKB
	.OPEN	SRD'SY$TEM'.TKB
	.ENABLE	DATA
;
;	SRD'SY$TEM'.TKB
;
SRD'SY$TEM''OPTNS'/-FP,SRD'SY$TEM'/-SP=SRD'SY$TEM'/MP
;
TSKV	=SSTVC$:7
STACK	=128
ASG	=TI:1
ASG	=SY:2:3
ASG	=TI:4
UNITS	=4
.DISABLE	DATA
	.IFT	I$$AS .OR  .IFT R$$11D .DATA LIBR	=SYSRES:RO
	.IFT	I$$AS	.DATA TASK	=$$$SRD
	.IFT	R$$11D .OR .IFT R$$11M .DATA TASK	=...SRD
	.IFT	F$$CS	.DATA LIBR	=FCSRES:RO
.ENABLE	DATA
EXTTSK	='EXTEND'
/
.DISABLE	DATA
.CLOSE
;	Creating SRD'SY$TEM'.ODL
	.OPEN	SRD'SY$TEM'.ODL
	.ENABLE	DATA
;
;		SRD'SY$TEM'.ODL
;
;	** SRD OVERLAY DESCRIPTION **
;
; UPDATED	14-AUG-79
;
	.NAME	OV1INI
	.NAME	OPNFNB
	.NAME	CSI12
	.ROOT	SRDR-*(O1,O2,O4,O5)
SRDR:	.FCTR	SRDATA-SRDROT-SRDSUB
O1:	.FCTR	SRDINI-*(O11)
O2:	.FCTR	SRDNUD-SRDOPR-SRDSRT
O5:	.FCTR	SRDDBF
.DISABLE	DATA
	.IFF	R$$11D .AND .IFF I$$AS .GOTO 0600
	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-SRDTRP
O11:	.FCTR	OV1INI-*(OP1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:PRINT
.DISABLE	DATA
	.GOTO	0700
.0600:	.ENABLE	DATA
O4:	.FCTR	SRDLST-SRDTST-*(O41,O42)
O41:	.FCTR	SRDTRP
O42:	.FCTR	LB:[1,1]SYSLIB/LB:PUTSQ
O11:	.FCTR	OV1INI-*(OP1,PRS1,CSI1)
OP1:	.FCTR	OPNFNB-LB:[1,1]SYSLIB/LB:OPFNB:$PRINT
	.NAME	PRSFNB
PRS1:	.FCTR	PRSFNB-LB:[1,1]SYSLIB/LB:PARSE
.DISABLE	DATA
.0700:	.ENABLE	DATA
CSI1:	.FCTR	CSI12-LB:[1,1]SYSLIB/LB:.CSI1:.CSI2
	.END
.DISABLE	DATA
	.CLOSE
;	Creating SRDPRE.MAC
	.OPEN	SRDPRE.MAC
	.ENABLE	DATA
;
;	VERSION 5 OF SRD
;
	.NLIST
;
; SRD PRE FIX FILE
;
;	UPDATED: 1-DEC-76
;
;	UPDATED: 08-MAR-79
;
;	UPDATED: 05-AUG-79
;
;	UPDATED: 19-NOV-79	H.R.TUMBLIN, DUMC
;
; CONDITIONALS DEPENDING ON THE SYSTEM FOR WHICH THIS IS
; BEING ASSEMBLED...
;
.DISABLE	DATA
	.IFT	R$$11M	.DATA R$$11M	=1 ;DEFINE THIS SYMBOL FOR RSX-11M
	.IFT	E$$IS	.DATA E$$IS	=1 ;DEFINE THIS FOR EIS SYSTEMS
	.IFT	R$$11D	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR RSX-11D
	.IFT	I$$AS	.DATA I$$AS	=1 ;DEFINE THIS SYMBOL FOR IAS
	.IFT	D$$CAL	.DATA D$$CAL	=1 ;DEFINE THIS SYMBOL (AND R$$11M) FOR
	.IFT	W$$ILD	.DATA WILD$	=1 ;DEFINE TO APPEND WILD CARD FILE NAME
	.ENABLE	DATA
;			;MATCHING CHARACTERS TO FILE NAME FIELD FOR AN IMPLIED
;			;SELECTION
;
	TTYLUN	= 4		; LUN FOR TERMINAL I/O
	EFN1	= 1		; UTILITY EVENT FLAG
 	CMDLUN	= 1		; LUN FOR CMD INPUT
	UFDLUN	= 2		; LUN TO READ USER-FILE-DIECTORY
	LSTLUN	= 3		; LUN TO LIST SORTED DIRECTORY
	DSKEFN	= 1		; EFN FOR UFD READ SYNC.
;
; ERROR REQUEST CODES
;
	DIRB	= 0		; DIRECTORY TOO BIG!
	GCME	= 1		; ERROR READINF COMMAND
	CS1E	= 2		; COMMAND SYNTAX ERROR
	CS2I	= 3		; INPUT FILE COMMANDD SYNTAX ERROR
	CS2O	= 4		; OUTPUT FILE SYNTAX ERROR
	MFDE	= 7		; MFD OPEN ERROR
	PRSE	= 10		; PARSE FILE ERROR
	OPNE	= 11		; OPEN FAILURE
	OPNI	= 12		; OPEN FAILURE ON INPUT FILE
	OPNO	= 13		; OPEN FAILURE ON OUTPUT FILE
	DIRF	= 14		; DIRECTORY FIND ERR
	NOFL	= 15		; NO SUCH FILES
	BADD	= 16		; BAD DATE FORMAT
	HDRE	= 17		; HEADER READ ERR
	PUTE	= 20		; FAILED TO WRITE RECORD
	GETE	= 21		; FAILED TO READ RECORD
	WRTE	= 22		; FAILED TO WRITE BOLCK
	REDE	= 23		; FAILED TO GET BLOCK
	FDEL	= 24		; FAILED TO DELETE FILE
	PRIV	= 25		; PRIVILEGE VIOLATION
;
; MACRO TO GENERATE AN ERROR MESSAGE REQUEST
;	FOR A FATAL ERROR
;
	.MACRO	FERR	NUM
	TRAP	NUM
	.ENDM
	.MACRO	DIAG	NUM
	TRAP	200!NUM
	.ENDM
;
; SOME LOCAL DEFINITIONS
;
;	SWITCH MASK DEFINTIONS
;
	NASW	= 100000	; SORT BY NAME SW
	PUSW	= 20000		; PURGE THE FILES SELCTED
	SPSW	= 10000		; SPOOL FILE
	HVSW	= 4000		; SELECT HIGHER VERSION
	NESW	= 2000		; NEGATE SELECTION DECISION
	BESW	= 1000		; BEFORE DATE SUBSWITCH
	AFSW	= 400		; AFTER DATE SUBSW
	WBSW	= 200		; WRITE BACK SWITCH
	SVSW	= 100		; SELECT VERSION SWITCH
	SDSW	= 40		; SELECTIVE DELETE
	FUSW	= 20		; FULL LISTING
	DASW	= 10		; DATE SELECTION ACTIVE
	SESW	= 4		; SELECTIVE LISTING SWITCH
	LISW	= 2		; NO LISTING SWITCH
	DESW	= 1		; DELETE ALWAYS
;
;	2ND SWITCH MASK WORD DEFINITIONS
;
	BFSW	= 20		; DISPLAY INTERNAL BUFFER SIZE
	IDSW	= 10		; LIST SRD VERSION
	COSW	= 4		; SELECT CONTIGUOUS FILES
	LOSW	= 2		; SELECT LOCKED FILES
	MUSW	= 1		; SELECT MULTI-HEADER FILES
;
; FLAG BIT DEFINITIONS
;
	HDFL	= 100000	; LINE HEADER NOT PRINTED
	FLFL	= 200		; FILES LISTED
;
; USER-CONTROLLED FILE CHARACTERISTICS FLAG BIT DEFINITIONS (HEADER BYTE H.UCHA)
;
	COFLAG	= 200
	LOFLAG	= 100
;
;	DIRECTORY OFFSETS AND VALUES
;
;
	MFDNUM	=	4	; FILE ID NUMBER FOR FILE 000000.DIR
	MFDSEQ	=	4	; FILE SEQ NUMBER FOR MFD
;
; DIRECTORY OFFSETS
;
	D.SIZ	= 20		; SIZE OF DIR. ENTRY
	D.FNAM	= 6		; OFFSET TO NAME
	D.TYP	= 14		; OFFSET TO FILE TYPE
	D.VER	= 16		; ...AND VERSION
 
	.IF NDF	E$$EIS
	.MACRO	SOB RG,PLC
	DEC	RG
	BNE	PLC
	.ENDM
	.ENDC
;
; MACRO TO DO TASK EXPANSION. KEEP THIS UNTIL THE RSX-11M PEOPLE
; MANAGE TO GET IT INTO THE MACRO LIBRARY.
;
	.MACRO	EXRG$S	SIZE
	.MCALL	DIR$
	CLR	-(SP)
	MOV	SIZE,-(SP)
	MOV	#<3*400!89.>,-(SP)
	DIR$
	.ENDM	EXRG$S


	.LIST
.DISABLE	DATA
	.CLOSE
	.SETF	PROCED
.0430:	.ASK	PROCED	Command files generated, Continue
	.IFF	<ESCAPE>	.GOTO	0440
;
;	At this point, all the necessary command, overlay, and prefix
;	files have been generated. If you answer Y to continue, then 
;	SRD will be assembled and task-built. If you answer N, then
;	this command file will exit, preserving the command files.
;
	.GOTO	0430
.0440:	.IFF	PROCED	/
;
;	Assemble the source modules
;
MAC @SRDASM
;
;	Now taskbuild SRD
;
TKB @SRD'SY$TEM'.TKB
;
	.SETF	PROCED
	.ASK	PROCED	Delete listing files
	.IFT	PROCED	PIP *.LST;*/DE
	.SETF	PROCED
	.ASK	PROCED	Print listing files
	.IFT	PROCED  QUE LP:=*.LST
	.SETF	PROCED
	.ASK	PROCED	Delete object files
	.IFT	PROCED	PIP *.OBJ;*/DE
	.SETF	PROCED
	.ASK	PROCED	Delete MAP file
	.IFT	PROCED	PIP *.MAP;*/DE
;
;	SRD Build complete
;
/
