;	BUILD TECO FOR RSX-11d/ias
;
; TASK BUILD FILE FOR RSX-11 TECO.  TO WORK IN ITS NORMAL FASHION,
; TECO SHOULD BE INSTALLED THRICE:
;
;	MAK		FOR "MAKE" AS 'MCR MAK'
;	MUN		FOR "MUNG" AS 'MCR MUN'
;	TEC		FOR "TECO" AS 'MCR TEC'
;
; note: there will be 5 multiply defined symbols from tkb. their
; appearance is arbitrary, unwarrantedm and harmless.
;
TEC,TEC/MA/-SP=TECLNK/MP

TASK=...TEC
LIBR=SYSRES:RO
PRI=55
;
; LUN 1 IS USED FOR THE INDIRECT COMMAND FILE.
; LUN 2 IS USED FOR CONSOLE I/O.
; LUN 3 IS USED FOR THE OUTPUT FILE.
; LUN 4 IS USED FOR THE INPUT FILE.
; LUN 5 IS USED BY THE ERROR PROCESSOR.
; LUN 6 IS USED FOR THE TEMP DIRECTORY.
; LUN 7 IS USED FOR "EN" COMMANDS.
;
UNITS=7
ASG=SY:1:3:4:6:7
ASG=LB:5
ASG=TI:2
;
; PATCH THE LUN USED BY THE ERROR PROCESSOR (GERRM).
;
GBLPAT=ERRFMT:.EOLUN:5
;
; TECO DOESN'T NEED MUCH STACK SPACE, SO LIMIT THE SP STACK.
;
STACK=200
;
; TECO'S DYNAMIC MEMORY IS ALLOCATED FROM THE REGION STARTING AT THE
; END OF THE TASK IMAGE AND ENDING AT THE END OF THE PARTITION.
;
; RECOMMENDED MINIMUM TASK SIZE:
;
EXTTSK=15000
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF TECO'S PUSH DOWN LIST.
; IT MAY BE NECESSARY TO INCREASE THIS TO ACCOMMODATE MANY LEVELS OF
; ITERATION, MACRO CALLS, ETC.
;
GBLDEF=PDLSIZ:100
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF THE SEARCH BUFFER.
; IT MAY BE INCREASED TO ACCOMMODATE VERY LONG SEARCH STRINGS.
;
GBLDEF=SCHSIZ:200
;
; THE FOLLOWING PARAMETER SETS THE SIZE OF THE TAG BUFFER.
; IT MAY BE INCREASED TO ACCOMMODATE VERY LONG TAGS.
;
GBLDEF=TAGSIZ:200
;
; THE REMAINING SPACE IS DYNAMICALLY SHARED BETWEEN TEXT BUFFER AND
; Q-REGISTER STORAGE.  THE FOLLOWING PARAMETER DEFINES THE MINIMUM
; AMOUNT OF SPACE REQUIRED:
;
GBLDEF=MBFSIZ:2000
;
/
