/
/ Password encryption.
/ 	mov	$key,r0
/	jsr	pc,crypt
/

crypt:	...

/
/ Set up key space with clever
/ junk.
/

	mov	r0,r1
	mov	$key,r0
	movb	$004,(r0)+
	movb	$034,(r0)+

1:	cmp	r0,$key+64.
	bhis	1f
	movb	(r1)+,(r0)+
	br	1b

1:	dec	r0
	mov	$key,r1

1:	movb	-1(r0),r2
	movb	(r1)+,r3
	xor	r3,r2
	movb	r2,(r0)+
	cmp	r0,$key+128.
	blo	1b

/
/ Establish wheel codes and cage codes.
/

	mov	$wheelcode,r4
	mov	$cagecode,r5
	mov	$256.,-(sp)

2:	clr	r2
	clr	(r4)
	mov	$wheeldiv,r3

3:	clr	r0
	mov	(sp),r1
	div	(r3)+,r0
	add	r1,r2
	bic	$40,r2
	bis	shift(r2),(r4)
	cmp	r3,$wheeldiv+6.
	bhis	4f
	bis	shift+4(r2),(r5)

4:	cmp	r3,$wheeldiv+10.
	blo	3b
	sub	$2,(sp)
	tst	(r4)+
	tst	(r5)+
	cmp	r4,$wheelcode+256.
	blo	2b
	tst	(sp)+

/
/ Make internal settings of the machine.
/

	mov	$key,r0
	mov	$cage,r2
	mov	$wheel,r3

1:	movb	(r0)+,r1
	bic	$!177,r1
	asl	r1
	mov	cagecode(r1),(r2)+
	mov	wheelcode(r1),(r3)+
	cmp	r0,$key+128.
	blo	1b

/
/ Spin the cage against the wheel
/ to produce output.
/

	mov	$word,r4
	mov	$wheel+128.,r3

3:	mov	-(r3),r2
	mov	$cage,r0
	clr	r5

1:	bit	r2,(r0)+
	beq	2f
	incb	r5

2:	cmp	r0,$cage+256.
	blo	1b

/
/ We have a piece of output from
/ the current wheel.
/ It needs to be folded to remove
/ lingering hopes of reversal.
/

	mov	r4,-(sp)
	clr	r4
	div	$26.+26.+10.,r4
	add	$'0,r5
	cmp	r5,$'9
	blos	1f
	add	$'A-'9-1,r5
	cmp	r5,$'Z
	blos	1f
	add	$'a-'Z-1,r5

1:	mov	(sp)+,r4
	movb	r5,(r4)+
	cmp	r3,$word+8.
	blo	3b

/
/ Data.
/

key:	.blkb	128.
word:	.blkb	32.
cage:	.blkb	256.
wheel:	.blkb	256.
wheelcode:	.=.+256.
cagecode:	.=.+256.
