(*$R-*)
program PS1PS2COMMANDS(TTY);
const
  COUNT1=47; COUNT2=75; BLANK=' '; DASH='-';
type
  LINE = array [0..79] of CHAR;
  SENDBUFFER = RECORD
    WAIT : INTEGER;
    LENGTH  : INTEGER;
    DATA : LINE
  END;
var
  SEND : SENDBUFFER;
  I : INTEGER;
  J : INTEGER;
  OBJECT : INTEGER;
  OBLIST : INTEGER;
  DEBUG  : INTEGER;
  XREFL  : INTEGER;
  SOURCE : INTEGER;
  LISTING : INTEGER;
  OPTIONS : INTEGER;
  GCMLDATA : LINE;
  PS1MASK : LINE;
  PS2MASK : LINE;
  LLENGTH : INTEGER;
  OPTS : array [0..4] of CHAR;
  PILE : ARRAY [0..8] OF CHAR;
  FL : INTEGER;
  RESULT : INTEGER;
 
procedure GCML(var BUFF:LINE; var LTH:INTEGER);EXTERN;
procedure WAIT(var ANSWER:INTEGER);EXTERN;
procedure VSEND(var BUFF:SENDBUFFER; LTH:INTEGER);EXTERN;
 
function PARSE:BOOLEAN;
begin
  if LLENGTH > 4 then begin
    I := 0;
    while GCMLDATA[I] <> BLANK do I := SUCC(I);
    while GCMLDATA[I] = BLANK do I := SUCC(I);
    if GCMLDATA[I] = DASH then begin
      J := 0;
      I := SUCC(I);
      repeat
        OPTS[J] := GCMLDATA[I];
        I :=SUCC(I); J := SUCC(J);
      until GCMLDATA[I] = BLANK;
      while GCMLDATA[I] = BLANK do I := SUCC(I)
      end;
    for J := I to LLENGTH do PILE[J-I] := GCMLDATA[J];
    FL := LLENGTH - I;
    PARSE := TRUE
  end
  else
    PARSE := FALSE;
end;   (* PARSE *)
 
procedure INITIALIZE;
begin
  OBJECT := 28;
  OBLIST := 42;
  DEBUG := 56;
  XREFL := 70;
  SOURCE := 20;
  LISTING := 42;
  OPTIONS := 5;
  PS1MASK := 'PS1 -                .PAS INT DAT          .LST                                 ';
  PS2MASK := 'PS2 -      INT DAT           .OBJ          .OLS          .DBG          .XLS     ';
  OPTS := '     '
end;  (* INITIALIZE *)
 
begin (* main line *)
  INITIALIZE;
  GCML(GCMLDATA,LLENGTH);
  if PARSE then begin
    for I := OPTIONS to OPTIONS+4 do begin
      PS1MASK[I] := OPTS[I-OPTIONS];
      PS2MASK[I] := OPTS[I-OPTIONS]
    end;
    for I := 0 to FL do begin
      PS2MASK[OBJECT] := PILE[FL-I]; OBJECT := PRED(OBJECT);
      PS2MASK[OBLIST] := PILE[FL-I]; OBLIST := PRED(OBLIST);
      PS2MASK[DEBUG] := PILE[FL-I];  DEBUG  := PRED(DEBUG);
      PS2MASK[XREFL] := PILE[FL-I];  XREFL  := PRED(XREFL);
      PS1MASK[SOURCE] := PILE[FL-I]; SOURCE := PRED(SOURCE);
      PS1MASK[LISTING] := PILE[FL-I]; LISTING := PRED(LISTING)
    end;
    SEND.WAIT := 1;
    SEND.LENGTH := COUNT1;
    SEND.DATA := PS1MASK;
    VSEND(SEND,(COUNT1+1) DIV 2 + 2);
    WRITELN(TTY,'Pass1: ', PILE:FL+1); BREAK;
    WAIT(RESULT);
    SEND.WAIT := 1;
    SEND.LENGTH := COUNT2;
    SEND.DATA := PS2MASK;
    VSEND(SEND,(COUNT2+1) DIV 2 + 2);
    WRITELN(TTY,'Pass2: ', PILE:FL+1); BREAK;
    WAIT(RESULT)
  end
  else
    WRITELN(TTY, 'Improper command line input');
end.
