





        NOTES ON CHARACTER STRING FUNCTIONS AND SUBROUTINES

      
          By MARTY PORTNER 30-dec-77


     ----- ----- ----- ----- ----- ---
-- ----- ----- ----- -----



                The purpose of these notes  is
  to  acquaint  the
     user  with the various character string functions now 
avail-
     able in the FORTRAN library.

                String functions pe
rform operations upon  FORTRAN
     'BYTE'  arrays which will be referred to as
 'character vari-
     ables'.The only responsibility of  those  who  wish  to 
 use
     these functions and subroutines is that each character vari-
     ab
le be declared as a 'BYTE' array.  For example,  the  fol-
     lowing declarat
ion in a FORTRAN program will insure that the
     string functions and subrout
ines treat 'STRING' as  a  valid
     character variable:

                BY
TE    STRING(100) .  

                The following pages explain each of the
 functions
     and subroutines in detail.

                These functions a
nd subroutines reside in the li-
     brary  SY:[1,1]STRLIB.  Programs wishing 
use these functions
     should be linked something like this:


           
     MCR>TKB PROG,PROG=PROG,[1,1]STRLIB/LB .


Notes on String Functions      
                            PAGE 2



        I.      FUNCTION ISIZE(STRING)

 

          This function returns an integer which is equal to  the
     nu
mber of characters in the argument STRING.  For example if
     the value of ST
RING is 'ABCD' then ISIZE(STRING) returns the
     value 4.


Notes on String
 Functions                                  PAGE 3



        II.     FUNCTI
ON INDEX(STRA,STRB)

          This function searches STRA for the first occur
rance of
     STRB  and  returns  the  character position within STRA that
   
  marks the start of STRB.  For example, the value of I  after
     the FORTRAN
 statement

                I=INDEX('12345678','456')

     will be 4.

  
        If STRB is longer than STRA or STRB  is  not  found  in
     STRA the v
alue 0 (zero) is returned.


Notes on String Functions                        
          PAGE 4



        III.    FUNCTION LEQ(STRA,STRB)

          Thi
s function determines whether STRA and STRB are lex-
     ically  equal,  i.e.,
  have the same length and are equal in
     all character positions.  LEQ  ret
urns  the  logical  values
     .TRUE.   ,  .FALSE.  .  In the call invoked by 
the following
     FORTRAN statement, LEQ returns the value .TRUE.  :

      
          IF (LEQ('678','678')) GOTO 100 .

          This function will retur
n the value .FALSE.  for any of
     the following reasons:


        a) STR
A and STRB differ in some character position,
        b) STRA and STRB are of d
ifferent lengths , 
        c) fewer than 2 arguments were passed to it.

   
       Note  that  blanks  (spaces)  are   valid   characters.
     Therefore, 
a call such as

                        LEQ(' 65 ','65')

     will return t
he value .FALSE.  (for reason b) above).


Notes on String Functions          
                        PAGE 5



        IV.     SUBROUTINE STRING(STRA,STR
B)

          This subroutine is used mainly for assignment purposes.
     Th
e net effect after a call to STRING is that STRB will con-
     tain the same c
haracters as STRA.  For example the call

                CALL    STRING('BIMB
O',STR)

     will cause the value of STR to become the  character  string
  
   'BIMBO'.


Notes on String Functions                                  PAGE 
6



        V.      SUBROUTINE NULL(STR)

          This subroutine reass
igns STR to the value of the  null
     string (string of length zero).


Not
es on String Functions                                  PAGE 7



        VI
.     SUBROUTINE SUBSTR(STRA,START,LEN,STRB)

          This subroutine create
s a substring out of the variable
     STRA starting at character position STAR
T (an integer) going
     for length LEN and assigns this string to STRB.  For 
example

                CALL SUBSTR('7890',2,2,STRC)

     will cause the v
alue of STRC to become '89'.It is  important
     to  point  out here that STRA
 and STRB need not be different
     strings, and in general source and  destin
ation  strings  in
     all  of  the string subroutines need not be different. 
 This
     permits the programmer to make immediate assignments without
     a
 call to 'STRING'.

          If STRB is omitted, STRA is assumed to be the  d
estina-
     tion  string.   STRB  may be omitted as in either of the two
    
 following examples:

                CALL    SUBSTR(STR,2,2)

             
           or

                CALL    SUBSTR(STR,2,2,)

          If the va
lue of START exceeds the length  of  STRA,  no
     operation  is  performed  (
call is ignored).  If LEN exceeds
     the number of characters left in STRA (s
tarting  from  posi-
     tion  START),  only these remaining characters of the
 source
     string are assigned to the destination string.


Notes on String
 Functions                                  PAGE 8



        VII.    SUBROU
TINE CONCAT(STRA,STRB,STRC)

          This  subroutine  is  used  to  combine
  two  character
     strings  under  the  operation of concatenation.  The eff
ect
     here is to concatenate STRA to STRB and place the result  in
     STR
C.   Provided  STRC  is not one of STRA or STRB, STRA and
     STRB are unaffec
ted by 'CONCAT'.  As an example, let STRA  =
     'AFTER' and STRB = 'WORD'.  A
fter the call 

                CALL    CONCAT(STRA,STRB,STRC)

     the val
ue of STRC will be 'AFTERWORD'.  The values  of  STRA
     and STRB will be unc
hanged.

          As in SUBSTR, if STRC is omitted, STRA is assumed to be
  
   the destination string.


Notes on String Functions                        
          PAGE 9



        VIII.   SUBROUTINE DUPL(STRA,NTIMES,STRB)

   
       This  subroutine  will  duplicate  STRA  the  specified
     number  of 
 times  (  NTIMES ) and store the result in STRB.
     For example the call

                CALL    DUPL('HUBBA',2,STRB)

     results in the assignment o
f the value  of  'HUBBAHUBBA'  to
     STRB.








Notes on String Fu
nctions                                 PAGE 10



                IX.     S
UBROUTINE      TRUNC(STR,POS)



          This subroutine allows the user t
o truncate a string at
     a  specified position within that string.For exampl
e, if the
     value of STR is 'FORMAT', then after the call


             
   CALL    TRUNC(STR,5)


     the value of STR will be 'FORM'.

          
Care must be taken when using TRUNC, for  it  does  not
     check  to  see if 
POS is greater than the length of STR.  If
     POS is some value greater than 
the length of STR, a  special
     'string  terminater'  character  may placed 
outside the user
     program's data area and strange, eerie and  macabre  resu
lts
     may ensue.

          TRUNC may be used to properly initialize chara
cter var-
     iables.Consider this sequence :


        1)      READ(1,100)
 N,STR
        2) 100 FORMAT(Q,<N>A1)
        3)      CALL    TRUNC(STR,N+1)

          This sequence of FORTRAN statements will read a  record
     from  
LUN=1 and, using Q format, will return in N the number
     of characters read 
into STR.  Statement 3 then properly ini-
     tializes  STR  by  truncating ST
R at position N+1.  This in-
     sures that the proper termination character i
s placed  after
     the  last  character  read into STR, thus making STR a val
id
     character variable.

          If the argument POS is omitted, TRUNC 
assumes the value
     POS=1 and thus behaves identically to NULL.







Notes on String Functions                                 PAGE 11



     
   X.      SUBROUTINE      SDELET(STR,POS,LEN)

          This subroutine dele
tes the specified number  of  char-
     acters in STR starting at the specifie
d position within STR.
     For example, let STR = 'SATURDAY'.  Then after the 
call

                CALL    SDELET(STR,2,5)

     the value of STR will be
 'SAY' .

          If in any call POS is omitted, SDELET assumes the value
 
    POS=1.  If LEN is zero or omitted, no characters are deleted
     from STR.
  if LEN is present and the sum LEN+POS is  greater
     than  ISIZE(STR), SDEL
ET acts exactly like TRUNC, thus trun-
     cating STR at position POS.





Notes on String Functions                                 PAGE 12



    
    XI.     SUBROUTINE      SINSRT(STRA,POS,STRB)



          The duty of t
his subroutine is  to  insert  the  string
     STRB within STRA at position PO
S.  As an example, let STRA =
     'BULBS'.  Then after the call

           
     CALL    SINSRT(STRA,5,'OU')

     the value of STRA will be 'BULBOUS'.


          The only argument that is allowed to be omitted is POS.
     Should 
 POS be omitted, the value POS=1 is assumed.If POS is
     present and its valu
e is greater than the length of STRA, no
     insertion is performed.




N
otes on String Functions                                 PAGE 13



        
XII.    FUNCTION        IBREAK(STRA,SET)



          This function returns 
an integer that is equal  to  the
     position  in STRA where any one of the i
ndividual characters
     of SET is found.  For example, the following call  wi
ll  re-
     turn  the character position of the first vowel in the argu-
    
 ment WORD:

                I=IBREAK(WORD,'AEIOU')


          IBREAK assu
mes no defaults and will return 0 (zero)  if
     either  none of the individua
l characters of SET is found in
     WORD, or fewer than two arguments are pass
ed to it.


