	FUNCTION FINPUT(MODE,IERR)
C	TEST9 (IN COMMON)=COLUMN POINTER=COL
C	WHENEVER COL=-1, FINPUT WILL ECHO CURRENT RECORD TO THE TTY,
C	             AND READ A REPLACEMENT RECORD FROM THE TTY
C	             (THIS FACILITY IS FOR ERROR INDICATION TO THE USER)
C	WHENEVER COL=0, FINPUT WILL READ A NEW RECORD FROM THE TTY
C	AFTER COL HAS BEEN PROCESSED, THE MODE PARAMETER IS CHECKED-
C	   MODE=-1 TO CHECK IF THERE ARE ANY UNPROCESSED ELEMENTS
C	           REMAINING UN THE CURRENT RECORD.
C	           IF THERE ARE NO MORE ELEMENTS - FINPUT=0.0
C	           IF THERE ARE SOME ELEMENTS - FINPUT=1.0
C	           IN EITHER CASE - COL=0
C	   MODE=0 TO CHECK FOR A NUMERIC VALUE AS THE NEXT ELEMENT
C	   MODE=+1 TO CHECK FOR AN ALPHANUMERIC CHARACTER STRING AS THE
C	           NEXT ELEMENT (ONLY THE FIRST CHARACTER IS RETAINED)
C	      IN EITHER OF THE LATTER TWO CASES -
C	           IF THERE IS ANOTHER (OK) ELEMENT - IERR=0
C	                                              FINPUT=[VALUE]
C	           IF THERE ARE NO MORE ELEMENTS - IERR =-1
C	                                           COL=0
C	                                           FINPUT=0.0 (NUMERIC)
C	                                             OR BLANK (ALPHA)
C	           IF THERE IS ANOTHER ELEMENT OF
C	                           THE WRONG TYPE - IERR=+1
C	                                            COL=0
C	                                            FINPUT=0.0 (NUMERIC)
C	                                                OR BLANK (ALPHA)
C	NOTE THAT THE ABOVE SCHEME (WITH COL), IF PROPERLY UTILIZED,
C	   WILL RESULT IN COL=0 AND A NEW RECORD BEING READ AUTOMATICALLY,
C	   AT THE APPROPRIATE TIMES - IT IS ONLY NECESSARY TO INITIALIZE
C	   COL (TEST9) = 0.
C	NUMERIC ELEMENTS ARE DELIMITED BY BLANKS,COMMAS,$,OR MODE CHANGE
C	ALPHANUMERIC ELEMENTS ARE DELIMITED BY BLANKS, COMMAS, AND $
C	$ IS THE RECORD TERMINATOR
C	FINPUT OPERATES ON 72-CHARACTER INPUT RECORDS
C	NUMERIC ELEMENTS MAY BE INTEGER, FIXED POINT, OR FLOATING POINT
C	BE CAREFUL ABOUT E AND G (E FORMAT OR ALPHA CAN BE CONFUSING)
C
	INTEGER COL, TEST2
	LOGICAL DIGD,DIGE,ESW,NUMER,POINT
	DIMENSION DATUM(72),DIGIT(10)
	COMMON/FLAGS/IDUM(2),TEST2,IDUM2(5),COL
	DATA BLANK/1H /
	DATA COMMA/1H,/
	DATA DMINUS/1H-/
	DATA DOLLAR/1H$/
	DATA DPLUS/1H+/
	DATA DPOINT/1H./
	DATA E/1HE/
	DATA G/1HG/
	DATA DIGIT(1)/1H0/
	DATA DIGIT(2)/1H1/
	DATA DIGIT(3)/1H2/
	DATA DIGIT(4)/1H3/
	DATA DIGIT(5)/1H4/
	DATA DIGIT(6)/1H5/
	DATA DIGIT(7)/1H6/
	DATA DIGIT(8)/1H7/
	DATA DIGIT(9)/1H8/
	DATA DIGIT(10)/1H9/
C
C	BEGIN COL CHECK
	IF (COL) 10,30,60
C	ECHO CURRENT RECORD TO, AND READ NEW RECORD FROM, THE TELETYPE
10	IF (TEST2.NE.5) WRITE(5,20) (DATUM(I),I=1,40)
20	FORMAT(1H ,40A1,4H****)
	READ(5,40) DATUM
	GO TO 50
C	READ NEW RECORDS FROM TEST2
30	READ(TEST2,40,END=380) DATUM
40	FORMAT(72A1)
C	INITIALIZE COLUMN POINTER
50	COL=1
C	GENERAL INITIALIZATION
60	IF (MODE) 70,70,80
70	FINPUT=0.0
	GO TO 90
80	FINPUT=BLANK
C	CHECK IF ANY ELEMENTS
90	IF (COL.GT.72) GO TO 100
	IF (DATUM(COL).NE.DOLLAR) GO TO 110
C	NO ELEMENTS REMAINING
100	IERR=-1
	GO TO 400
C	THERE IS SOME ELEMENTS
110	IF (MODE) 120,130,130
C	CALLER DOES NOT WANT ANY MORE
120	FINPUT=1.0
	GO TO 400
C	IT IS OK TO HAVE AN ELEMENT
C	IGNORE LEADING BLANKS
130	DO 140 COL=COL,72
	IF (DATUM(COL).NE.BLANK) GO TO 150
140	CONTINUE
C	REACHED END-OF-RECORD - NULL ELEMENT
	GO TO 380
C	FOUND A NON-BLANK CHARACTER - CHECK IF NULL ELEMENT
150	CHAR=DATUM(COL)
	IF (CHAR.EQ.COMMA) GO TO 370
	IF (CHAR.EQ.DOLLAR) GO TO 380
C	THE ELEMENT IS NOT NULL
	IF (MODE) 230,200,160
C	TREAT IT AS AN ALPHANUMERIC CHARACTER STRING
160	DO 170 I=1,10
	IF (CHAR.EQ.DIGIT(I)) GO TO 230
170	CONTINUE
C	IT IS NOT A DIGIT - SAVE FIRST CHARACTER
	FINPUT=CHAR
C	MOVE PAST REMAINDER OF THE ALPHANUMERIC STRING
180	COL=COL+1
	IF (COL.GT.72) GO TO 380
	CHAR=DATUM(COL)
	IF (CHAR.EQ.DOLLAR) GO TO 380
	IF (CHAR.EQ.COMMA) GO TO 370
	IF (CHAR.EQ.BLANK) GO TO 360
	GO TO 180
C	TREAT IT AS NUMERIC
C	GENERAL NUMERIC INITIALIZATION
200	NUMER=.FALSE.
	ISIGND=0
	DIGD=.FALSE.
	POINT=.FALSE.
	DECIM=0.0
	ESW=.FALSE.
	IEXPO=0
C	CHARACTER SEARCH
210	DO 220 I=1,10
	IF (CHAR.EQ.DIGIT(I)) GO TO 240
220	CONTINUE
	IF (CHAR.EQ.DPLUS) GO TO 280
	IF (CHAR.EQ.DMINUS) GO TO 290
	IF (CHAR.EQ.DPOINT) GO TO 320
	IF (CHAR.EQ.E.OR.CHAR.EQ.G) GO TO 330
C	NON-NUMERIC TYPE CHARACTER
	IF (NUMER) GO TO 390
C	THIS ELEMENT IS OF THE WRONG TYPE - INDICATE ERROR
230	IERR=1
	GO TO 400
C	DIGIT
240	IF (ESW) GO TO 250
C	UPDATE FIXED POINT PART
	IF (POINT) IEXPO=IEXPO-1
	DIGD=.TRUE.
	R=FLOAT(I-1)
	IF (ISIGND.EQ.(-1)) R=-R
	DECIM=10.0*DECIM+R
	GO TO 350
C	UPDATE EXPONENT PART
250	I=I-1
	IF (ISIGNE.EQ.(-1)) I=-I
	IEXPO=10*IEXPO+I
	IF (DIGD) GO TO 350
C	FIXED POINT PART WAS AT MOST A SIGN - CAN TAKE CARE OF THAT NOW
	IF (ISIGND) 260,350,270
260	DECIM=-1.0
	GO TO 350
270	DECIM=1.0
	GO TO 350
C	PLUS SIGN
280	I=1
	GO TO 300
C	MINUS SIGN
290	I=-1
300	IF (ESW) GO TO 310
C	NUMERIC SIGN
	IF (ISIGND.NE.0) GO TO 390
	ISIGND=I
	GO TO 350
C	EXPONENT SIGN
310	IF (ISIGNE.NE.0) GO TO 390
	ISIGNE=I
	GO TO 350
C	DECIMAL POINT
320	IF (POINT.OR.ESW) GO TO 390
	POINT=.TRUE.
	GO TO 350
C	E
330	IF (ESW) GO TO 390
C	EXPONENT PART INITIALIZATION
	ESW=.TRUE.
	ISIGNE=0
	DECIM=DECIM*10.0**IEXPO
	IEXPO=0
C	GET NEXT CHARACTER
350	NUMER=.TRUE.
	COL=COL+1
	IF (COL.GT.72) GO TO 390
	CHAR=DATUM(COL)
	IF (CHAR.EQ.COMMA) GO TO 390
	IF (CHAR.EQ.DOLLAR) GO TO 390
	IF (CHAR.NE.BLANK) GO TO 210
C	BLANK IS THE DELIMITER
	FINPUT=DECIM*10.0**IEXPO
C	IGNORE TRAILING BLANKS
360	COL=COL+1
	IF (COL.GT.72) GO TO 380
	CHAR=DATUM(COL)
	IF (CHAR.EQ.BLANK) GO TO 360
C	MOVE TO COLUMN AFTER A COMMA
370	IF (CHAR.EQ.COMMA) COL=COL+1
C	END OF SCAN - INDICATE NO ERROR
380	IERR=0
	RETURN
C	DELIMITER - FINISH UP
390	FINPUT=DECIM*10.0**IEXPO
	GO TO 370
C	ERROR OR END OF RECORD - RESET COLUMN POINTER TO ZERO
400	COL=0
	RETURN
	END
	FUNCTION KINPUT(MODE,IERR)
C	KINPUT EQUALS FINPUT ROUNDED TO INTEGER
	R=FINPUT(MODE,IERR)
	IF (R) 10,20,30
10	K=R-0.5
	GO TO 40
20	K=0
	GO TO 40
30	K=R+0.5
40	KINPUT=K
	RETURN
	END
