


LPSCRIPT(1)         UNIX Programmer's Manual          LPSCRIPT(1)



NAME
     lpscript - convert text to postscript

SYNOPSIS
     lpscript [-b[bottommargin]] [-c[copies] [-f[font]] [-
     h[spacing]] [-i[indent]] [-m[topmargin] [-o[outfile] [-
     p[pitch]] [-r[rotation]] [-s[fontsize]] [-t[tabsize]] [file
     ...]

DESCRIPTION
     _L_p_s_c_r_i_p_t reads text from standard input (or files if speci-
     fied) and produces postscript output, suitable for sending
     to any postscript device (such as an Apple Laserwriter) or
     for using with any program that expects postscript input
     (such as a postscript interpreter used to drive some other
     raster device).

     Text is normally aligned at the top and left with the image-
     able region of the page (probably slightly smaller than the
     physical page size), and a new page is taken whenever text
     would fall below this imageable region.

     Backspace characters in the input file are interpreted as
     instructions to move backwards by the width of the last
     character printed on the page.  This will result in the
     desired effect with fixed-width fonts, but may not be as
     successful with proportional fonts.  Line-by line overstrik-
     ing will also be done, with the same caveat.

     The following options are understood, with all values able
     to be given as integer or real:

     -b[bottommargin]
          Set the bottom margin of the page to the given distance
          (in centimeters).  If -b is specified without a dis-
          tance, 1 cm is assumed.

     -c[copies]
          Print copies copies of each page. If -c is specified
          without a count, 2 is assumed.  If copies is less than
          1, one page copy is printed.

     -f[fontname]
          Set the font used to the name given.  The default font
          is `Courier'.  If this argument is given without a
          fontname, `Times-Roman' is used.  The list of available
          fonts (for the Apple Laser-Writer) is: `Times-Roman' ;
          `Times-Italic' ; `Times-Bold'; `Times-BoldItalic';
          `Courier'; `Courier-Oblique' ; `Courier-Bold';
          `Courier-BoldOblique'; `Helvetica'; `Helvetica-Bold' ;
          `Helvetica-Oblique'; `Helvetica-BoldOblique'.  Note
          that only the Courier family is a fixed-width font; all



Printed 4/14/86                                                 1






LPSCRIPT(1)         UNIX Programmer's Manual          LPSCRIPT(1)



          the others are variable width, and so program listings
          or columns of data will not line up.

     -h[space]
          Increase the horizontal spacing of characters by the
          given fraction of the current font size.  For example,
          using `-h0.25' with a font size of 12 points in effect,
          would cause an increase of horizontal spacing by 3
          points.  By default, the characters are placed next to
          each other, using the natural width of the characters.

     -i[distance]
          Indent the text from the left edge of the imageable
          region, by the given distance (in centimeters).  If -i
          is specified without a distance, 1 cm is assumed.

     -m[topmargin]
          Indent the text from the top edge of the imageable
          region, by the given distance (in centimeters).  If -m
          is specified without a distance, 1 cm is assumed.

     -o[file]
          Send output to the specified file.  If -o is specified
          without a file name, output is sent to standard output.

     -p[pitch]
          Set the line spacing of printed text to this value.
          Giving a value here will cause the line spacing to be
          set to that value, in points (72 points = 1 inch).  The
          default action is to set the line spacing to be 2
          points more than the font size.

     -r[angle]
          Rotate the page by the given angle, specified in
          degrees.  If no angle is specified, 90 degrees is
          assumed.  Normally, the page will be printed in por-
          trait mode, ie with the long axis vertical.  This
          option allows printing in landscape mode (with the long
          axis horizontal).  Note that specifying an angle other
          than 0 or 90 will almost certainly cause part of the
          text to fall outside the imageable region, which serves
          you right for trying to be silly.

     -s[size]
          Set the font size to the value given (in points) (72
          points = 1 inch).  If a size is omitted, 12 is assumed.
          The default point size without using this option is 10.
          Specifying point sizes greater than 200 is probably
          silly and certainly wastes toner.

     -t[tabsize]
          Set the distance between tab stops to tabsize.  This



Printed 4/14/86                                                 2






LPSCRIPT(1)         UNIX Programmer's Manual          LPSCRIPT(1)



          works best with fixed-width fonts.  If the -t option is
          not specified, tabs default to 8 spaces.  If the -t
          option is specified without a value, a tab spacing of 4
          is assumed.

AUTHOR
     Stephen Frede, UNSW, Australia
     Backspace handling, copies, output, and margin switches
     added by Mic Kaczmarczik, University of Texas Computation
     Center, USA













































Printed 4/14/86                                                 3



                                                                                                                                   
