@comment(
	WPSIM manual, August '85
	Please note that there are tildas in this file, and they will be
	removed if this file is edited with WPSIM.
     )
@make(WCCMAN)
@String(ManualTitle="WPSIM Editor Reference Manual")
@String(ManualDate="August 1985")
@String(Version="3.1")

@Style(Hyphenation On,WidestBlank 1.5 Char)
@Style(DoubleSided On)
@Define(Ls2=List,Above 1,Below 1,Spread .2,Numbered <@@Bul2(.) @,* @,- >)

@begin(titlepage)
@mast1()
@ManualTitle(@Majorheading(@Value(ManualTitle)))
@Begin(Credit)
@>@P(Version: )@\@Value(version)
@>@P(Author:  )@\Douglas Bigelow
@>@p(Date: )@\@value(ManualDate)
@End(Credit)
@copyrite()
@mast2()
@end(titlepage)
@Begin(Text,Spacing 1.3,Spread .4,EOFok)
@Section(Introduction)

     WPSIM is a basic text editor and word processor used on the DECSYSTEM-20.
It is designed for the person who wants to write a program or produce a
document quickly, easily and without fuss, while producing output that is neat
and well formatted.  WPSIM requires little knowledge of computers, text
editors or formatting programs -- you can just type, and the text will come
out on paper much the same as it looks on the screen.  You don't even have to
bother with carriage returns, since the program will automatically insert them
at the proper breaking point on each line.

	The primary design goal of WPSIM was a product that could quickly and
easily produce well formatted documents or files.  It does not handle complex
formatting such as footnotes or indexing.  Users who need such capabilities
will require a text post-processor such as RUNOFF or SCRIBE, which are
specialized document preparation programs.

     WPSIM is a very efficient editor which uses the hardware features of
display terminals to minimize the overhead to the computer's operating system.
It supports all of the standard video terminals on campus, including VT100
emulating types such as Adds DT80s, Intecolors, DEC Rainbows and DECmates.

@Section(Basic document creation)
@Subsection(Creating a document)

	Log in and type "WPSIM<cr>" in response to the "@@" prompt.  The
program will ask you to enter a file name.  To experiment with a test
file, type SAMPLE followed by a carriage
return.

	After a message from WPSIM saying that it is creating the new file
SAMPLE.WPS, you will be looking at a blank screen with the cursor in the upper
left-hand corner.  This is called the "home" position.	From now on anything
that you type is becoming part of your file, and what you see on the screen is
what your finished product will look like.  Use the cursor keys to move
anywhere you want, or push the home key to return to the home position.
Any existing text you type over is gone, replaced by the new text.

	If you try typing a sentence that is longer than one line, note what
happens as you approach the right margin -- the sentence is automatically
split at the most convenient space break.

	As you approach the bottom of the screen, the terminal will scroll in
the normal fashion.  Just keep typing.

	When you've finished your document, type a ^E (control-E).  In this
example, the
program will clear the screen and type out the name SAMPLE.WPS for your
approval.  Type a carriage return to use that name, or you could change the
name by typing in something else.  The program will now exit and you have a
new file in your area.

@Subsection(Editing a document)

	Suppose you'd like to make some changes to an existing document.  Just
run WPSIM again.  This time, when the program asks for the name of your file,
give the name of the file you wish to change.

	Now instead of looking at a blank screen, you're looking at the first
page of your document.	What you type changes the current text.  Note that the
screen behaves differently if you move the cursor down past the bottom of the
screen - if there is more text to be displayed you will see the next eight
lines scrolled in.

	Again, type the ^E when you've finished, and select a new name (or
use the old one) for the output text.  If you wish to maintain the same name
for the edited file, just type a carriage return and WPSIM will use the old
name, which was printed at the top of the screen for your information.

@Subsection(Creating program files)

     Most of the files you create will be computer programs rather than word
processing documents.  There is one important difference, namely that carriage
returns can be almost anywhere in a text
document but must be very carefully placed
in a program.

     When creating or editing a program file, use the /PROGRAM switch immediately after
typing the name of the file:

     >>PROG1.PAS/PROGRAM

     This sets the widest possible margins and prevents word wrap and
automatic text evening.  This is the way to make sure that each line stays
exactly as you typed it without ever being automatically reformatted.

@Subsection(Using WPSIM as your primary editor)

	If you wish to use WPSIM as your primary editor, you would put the
following line in your LOGIN.CMD or COMAND.CMD file, or issue the command
while in EXEC mode:

	DEFINE EDITOR: SYS:WPSIM.EXE

	Then you may use the standard EDIT command to create a new file or
edit an existing one.
Alternately, you may edit or create a file just by typing:

	WPSIM FILENAME.EXT

@Subsection(Using pre-defined forms)

	Pre-defined forms are useful for typing standard documents.  For
example, you could design a memo form which contains the standard heading for
your department and has "TO:", "FROM:" and "SUBJECT:" already in place.  Then
call in the standard form when you start your memo creation and just fill in
the blanks.

@Subsection(Control characters)

	All of the special commands are handled by control characters.	In
this document these are indicated by a "^" before a letter.  Most of the
special commands are described in the next section, but here are two you'll
always need.
@Begin(List)

^E -- Exit.  This command asks you to name a file to hold the text you've
created, and terminates the program.

^L -- This command refreshes the screen by clearing it and re-typing all
the current text.  This is very useful if a system message has appeared on
your screen somewhere (such as an "Operator off duty" message.) You should
type the
^L immediately to make sure you're looking only at text that you inserted.
@End(List)

@Subsection(Numeric command arguments)
@Label(num)

	A number of WPSIM commands will accept a numeric argument that
specifies how many times to repeat the command.  A numeric argument is given
by typing <escape> (the ESCAPE or ALTMODE key) followed by a number, right
before giving a WPSIM command.	The <escape> and the number will not show on
the screen.

	This feature is particularly useful with cursor movement -- if you
type <escape>15<up-arrow>, your cursor will move up 15 lines.

	If the command that follows the numeric argument does not use a repeat
count, the number you typed will be ignored and discarded.

@Section(Basic text manipulation commands)
@Subsection(String search and replacement commands)

	There are three commands for manipulating strings, one to search for a
string, one to replace a string, and one to repeat the last search or replace
command.  These are:
@Begin(List)

^W -- Search or Replace command.  WPSIM asks for a string at the bottom of
the screen.  If you type a character string followed by a carriage return,
WPSIM positions the cursor to the next available incidence of that string.  If
you type a character string, an escape ($), another string, and then a
carriage return, WPSIM will search for the first string and then replace it by
the second string.

	If you wish to search backwards in the file, you may precede the
^W
command by an $-1 (escape, minus one).	This will search backwards towards the
beginning of the file.

^X -- Repeat previous search or replace.  Re-executes the last ^W
command exactly as it was given.

	The ^X command is initialized upon startup to look for a "@@", so
this character is very useful in pre-defined memo forms.  You can put the
at-sign where you will want the date, names, etc and then move from field to
field with one keystroke.
@End(List)

@Subsection(Cursor positioning commands)

	A number of special commands are available to move the cursor more
quickly than is practical with the arrow keys.	These are the ^P
(Position) commands.  Each command takes two keystrokes, as follows: you
type the first character (in this case, the @B(P)) with the control key held,
then follow it with a second character without the control key.  These are
the choices:

@Begin(List)

^PL - Position to beginning of current Line.

^PA - Position to Append to current line.

^PW - Position to beginning of next Word.

^PB - Position to Beginning of file.

^PE - Position to End of file.

^PN - Position to Next page of file.

^PP - Position to Previous page of file.

^PC - Position to Center of screen.  This refreshes the screen and centers
it around the current line.  The cursor position stays the same.

^PT - Position current line at Top.  Moves the line the cursor is on to
the top of the screen.
@End(List)

Any other character besides these following a ^P will not echo
and will be ignored.

	A repeat count (see section @ref(num)) can be given before the
commands ^PN and ^PP to move multiple pages forward or backward.  If a
repeat count is given before the commands ^PC and ^PL, the behavior of
these commands is altered to mean change cursor position forward or backward
by some number of lines (L) or characters (C).	The repeat count given before
^PC and
^PL may
be negative or positive.

@Subsection(Text deletion commands)

	There exist several ways to delete text.  Ordinarily the typist
corrects a mistake by backspacing over the misspelling and re-typing it.

	The DELETE or RUBOUT key is also available but has a different effect.
This key deletes the character which is at the cursor, and shifts the
remainder of the line one place to the left.  If there is no character at or
following the cursor, it backs up one character and deletes that one.

	For more complex deletions, the ^D command is available.  Like the
positioning commands, two keystrokes are necessary.  The options are as
follows:
@Begin(List)

^DC - Delete Character.  This command functions the same as the rubout
key, removing the character the cursor is on and moving the remainder of the
line one space to the left.

^DW - Delete Word.	This moves to the beginning of the word currently
overlapping the cursor position or to the next word on the line if the cursor
is on a space, and deletes it and its trailing spaces.	The remainder of the
text on the line is shifted right the appropriate number of spaces.  If no
word follows the cursor, delete the previous word.

^DR - Delete Remainder.  This deletes the remainder of the text on the
current line, from the cursor position onward.	(On a Datamedia, there is a
special key marked DEL EOL for this function.)

^DB - Delete Beginning.  This deletes from the beginning of the current
line to the current cursor position.  The rest of the line is shifted over to
start in the first column.

^DL - Delete Line.	This deletes the line the cursor is on, and moves all
remaining lines in the file back by one.  In other words, the line is deleted
without leaving blanks in its place.

^DE - Delete to End of file.  This removes all text after the cursor.
Since this command can be dangerous if given accidentally, it always requires
confirmation -- the terminal bell beeps and @I(you must type a ^G) (a
bell) to carry out the action.

^DF - Delete File.	This deletes the whole file.  To prevent accidental
use, this command @I(must be confirmed by a ^G).
@End(List)

	A repeat count may be specified before the commands ^DC and
^DL, to
delete a number of lines or characters with one command.

	An alternate method of deleting text is to use the <escape> -
<angle-bracket> commands.  To delete a block of text that spans several lines
but does not start or end on line boundaries, you can use the $< ...  $>D
command, described in section @Ref(mov).

@Subsection(Insertion commands)
@label(ins)

	Ordinary insertion is done by simply typing, but adding new text in
the middle of old text without wiping out previous work is more involved.
There are several insertion commands, double keystroke commands that start
with a ^N:
@Begin(List)

^NL - iNsert Line.	This command creates a blank line in place of the line
where the cursor is, by moving that and all succeeding lines down by one.  The
cursor is then positioned at the beginning of the new line.

^NS - iNsert, Splitting line.  This command creates a blank line following
the line where the cursor is.  It then moves all text on the current line
following the cursor down into the new blank space.  The cursor is left on the
original line in its starting position, followed by the newly created gap.

^NI - enter Insert mode.  This command acts like the ^NS command,
except that whenever the cursor is advanced to the next line a blank line is
inserted in the text to write over.  This command is like a toggle switch -
typing ^NI again will end insert mode and even out the text in the current
paragraph.

^NC - iNsert Character.  This command inserts a blank at the cursor and
moves the remainder of the line one place to the right.  Characters shifted
past the right margin are lost -- they are @I(not) automatically
moved down to the next line.

^NF - iNsert Function.  This command asks for the function name and text
of the function.  Please see section 5.2 for a discussion of functions.
@End(List)

	A repeat count may be specified before the commands ^NL and
^NC, to
insert a number of lines or characters with one command.

@Subsection(Special tabs)

	There are three types of tabs available.  The ordinary tab is
generated by the TAB key or by a ^I.  This tab is destructive; if you tab
over existing text you replace it by spaces.  The other types of tabs are:
@Begin(List)

^T - Transparent tab.  This tab moves over text without affecting it, but
otherwise acts like an ordinary tab.

^R - Reverse tab.  This backs up the cursor to the previous tab stop
without affecting text passed over.
@End(List)

	All of the tabs can pass line boundaries -- tabbing past the last
column on a line will put the cursor on the next line, and reverse tabbing
past the first column will put the cursor on the previous line.

	The number of spaces per tab is variable -- by default it is eight
spaces, but you can use the /TABS:n switch to set "n" spaces per tab.  (See
section 5.0 for more information on switch settings.)

@Subsection(Moving text)
@Label(mov)

	It is sometimes useful to be able to move text from one place in the
file to another.  Two commands exist for doing this:
@Begin(List)

^G - Get text into buffer.	This command picks up some number of lines of
text and puts them into a text buffer for later use.  There are 99 lines of
storage available in the buffer.  The command can be preceeded by a repeat
count given by the <escape>number method unless you wish to pick up only one
line.  It should be followed by one of:
@Begin(LS2)
C - Copy text (don't delete it.)

M - Move text (delete from current location.)
@End(ls2)

^O - retrieve Old text.  Take the current contents of the storage buffer
and copy them into the file at the current line.  New lines are created and
the existing text is not overlaid.  The storage buffer is not affected and you
can use the ^O command repeatedly.
@End(List)

	An alternate method of moving text eliminates the need for line
boundaries - the <escape><angle-bracket> method.  By this method you can flag
the beginning and end of a string of text such as a sentence, a paragraph, or
more, and pick it up for later use.  The commands follow, with
a dollar sign ($) used to indicate the escape key:

@Begin(List)

$< - Mark beginning of text.  This command does not echo, and marks the
current line and column as being the start of a text string.

$> - Mark ending of text.  This command must be given at a cursor position
that is further along in the file than the place where the $< command was
given.	This command must be immediately followed by a code specifying what to
do with the text:
@Begin(Ls2)
C - Copy the text without deleting it.

M - Move the text into text buffer, delete it from current position.

D - Delete the text without affecting the current text buffer contents.

R - Return cursor to position of beginning marker.
@End(ls2)
@End(List)

	When you remove text from the file with the $< ...  $>M command, the
current paragraph is evened out.  (See section @Ref(eve).)

	The text is again retrieved with the ^O command, described above.
However, the text will be inserted at the current cursor position when the
^O
command is given, and the paragraph will be evened out after the insertion
takes place.

	Evening out the text will not take place if /PROGRAM mode has been
specified (see section @Ref(cha)).

@Subsection(Double spacing)

	Text may be entered double spaced by using the ^KD (Double
spacing) command.  When in double spaced mode, any movement up or down in the
file moves you by two lines instead of one.  Typing text automatically leaves
blank lines between lines of text.  This format is useful for most academic
papers.

	Double and single spacing mode may be mixed, as for example when you
wish to embed a single spaced indented quotation within double spaced text.
Just use ^KD to toggle between the two modes.

	Evening out your text needs special handling when you're dealing with
double spaced text.  See the next section for details.

@Subsection(Evening out the text lines)
@Label(eve)

	After several delete operations or some insertions, your file may not
have the nice evenly-spaced lines it started with.  The ^V (eVen) command
has several variations:
@Begin(List)

^VP - eVen Paragraph.  Starting at the current line, even out the text
lines by filling in each line up to the margin with words from succeeding
lines.	Stop the process when a paragraph break is reached.  (A paragraph
break is defined as a blank line, a line whose first word starts off the left
margin, or a line beginning with a special character in column one.@Foot(
The following set of characters in
the first column will stop paragraph evening: @B"!#*)]}>;=/\~."  This
prevents evening from interfering with text post-processors like RUNOFF and
SCRIBE.)

^VD - eVen Double-spaced paragraph.  Starting at the current line, even
out double spaced input text.  The paragraph is broken when a double spaced
line is blank, starts with the first word off the left margin, or begins with
a special character in column one.

^VF - eVen File.  Even out the whole file, and leave the cursor positioned
at the beginning.  Starts on the current line.	Works only with single spaced
text.

^VA - eVen All of double spaced file.  Like ^VF, but works with double
spaced files.
@End(List)

	These commands work only with neatly formatted lines.  If you need to
even lines that are mixed spacing modes or which start at different
indentations, you may preface the ^VP or ^VD command with a number of
lines to even.	(Using the escape-number convention.) This will define the
paragraph as exactly that number of lines and ignore any conventional
paragraph break indicators.

	The formatted lines are written out in the prevailing spacing mode --
i.e.  a paragraph may be changed from single to double spacing simply by using
^VP on it while the double spacing toggle (^KD) is set to double
spacing.

	All ^V commands are disabled if /PROGRAM mode has been specified.

@Subsection(Pagination)

	WPSIM has automatic pagination available, obtained by using the
/PAGINATE switch.  In this mode, (which is always turned off when you're in
/PROGRAM mode) your input text will have page markers set automatically every
PAGESIZE lines, which is set to 52 by default.	You will know a page break by
seeing a "P" in the last column of the screen, in reverse video on any
terminal but a DATAMEDIA.  The line the "P" appears on is the first line of
the next page.

	When the file is output to disk, each page break will be turned into a
formal page header with a page number at the top followed by three blank lines
before the text resumes.

	There are two styles of header: the default is a "- (number) -"
centered in the middle of the page.  The alternate style is a special header
string on the left hand side of the page and the words "Page (number)" on the
right hand side.

	The header string can be specified by using the ^KH command.  This
causes WPSIM to ask for a 1-50 character line to be output at the top of each
page.  If you don't use the ^KH command, the centered page number will be
used instead.  The header is retained between editing sessions.

	There are times when you wish to manually insert a page break.	You
may do this by typing the ^KB (pageBreak) command on the line where you
wish to insert a break.  This causes a permanent page marker to be inserted,
for example at a chapter start.  These permanent page breaks will remain even
across several editing sessions, leaving and re-entering WPSIM.

	The automatic page breaks, indicated by the highlighted "P", are
"soft" page markers and are automatically recalculated whenever you
edit a paginated file.  Once you've set paginate mode once, WPSIM
remembers that setting every time you use the file in the future.

	Hard (or "manual") page marks are indicated by a "~" symbol (a tilda)
in column one of an otherwise blank line.  These symbols are converted to a
^L
character (a hardware form feed) whenever you exit from WPSIM, then converted
back when you reenter.

	When in /PROGRAM mode, and in some other cases, you may need to leave
^L symbols alone and not convert them to page headers.	This would be
true of most cases where you aren't working on a document, but on some type of
program or data.  In this case the /NOPAGINATE switch will tell WPSIM to leave
page break symbols alone when either entering or exiting.

	The default is /NOPAGINATE when editing any normal file.  The
exception to this is a previously paginated file -- WPSIM can detect a file
paginated by WPSIM version 3.0 or later, and will automatically go into
pagination mode when reading such a file in.  For page headers created by
older versions of WPSIM, version 2.7 or earlier, you must specifically use the
/PAGINATE switch to strip off the old page headers.  (Note: you can tell what
version of WPSIM you're working with simply by typing WPSIM followed by a
carriage return in EXEC mode.  The first line of printing tells the version.
Version 3.0 was implemented September 1, 1983.)

	When reading in a previously paginated file, WPSIM will take note of
any page header that you created with the ^KH command.  This old header
will be stored for later use when you again exit from the program.

	If you are creating a new file and remember only after you entered
WPSIM that you wish to paginate it, you don't have to exit and re-enter using
the /PAGINATE switch.  Simply use the ^KP command (Paginate) while in
WPSIM and it will toggle the /PAGINATE switch on or off -- on if it was off
before, off if it was on.

@Subsection(Centering text)

	The ^KC command automatically centers text for you.  Type the text
to be centered on a blank line, starting at the normal left margin.  At the
end of the text, use the ^KC command.  The text will be centered between
the right and the left margins.  Type no spaces between the end of the text
and the command, or the centering will be incorrect.  Any text on the line
following the ^KC command will be lost.

@Subsection(Making text flush right)

	The ^KF command causes text to be placed flush against the right
margin.  It works like the center command -- type the text on a blank line
starting at the normal left margin, then type ^KF.	The text will then be
shifted on the line so that column where the cursor had been when you typed
the command is now against the right hand margin.  Any text that may have been
on the line beyond the cursor position where you typed ^KF is lost.

@Subsection(Joining two lines)

	The ^KJ command deletes from the current cursor position to the
end of the current line, and appends as much of the following line as will
fit, discarding the rest.@Foot(Therefore, this should only be used with two
short lines...)
Leading spaces on the second line are discarded.

@Subsection(Interactive program help)

	The ^K?  command will put page one of a two-page command summary
on the screen.	Typing a space will toggle between the two help pages, and a
carriage-return will return to your original text.  This provides a quick and
easy reference for any commands you may have forgotten.

@Subsection(Inserting a new input file)

	The ^KN command will load a new input file.  If you wish to
discard the contents of your current editing buffer without saving the work
you've done, you can replace your text with the contents of a new input file.
Type ^KN and the terminal will beep.  If you wish to confirm the command, type
a ^G.  The program will then ask you for the name of the new file.  You
cannot specify any switches and /TYPE checking will not be done.

@Section(Changing program parameter values)
@Subsection(Setting and removing tab positions)

	If you aren't happy with the default tab stops being set every "n"
spaces (where "n" defaults to eight unless you change it), you may manually
set tab stops wherever you wish them, and remove them where you don't.

	The ^KS command sets a tab stop, and the ^KR command removes
one.  Just position the cursor via the arrow keys to where you'd like a tab
and type
^KS.  Nothing will show up on the screen.  To remove one, tab or reverse
tab to the tab stop you wish to delete, then type ^KR.  Again, nothing
will show up on the screen.

@Subsection(Changing margin settings)

	You can dynamically adjust the current margins of your file without
exiting by using the ^KI and ^KM commands.  ^KI sets the default
indentation to be to the column where the cursor is currently located.
^KM sets the maximum right margin in the same way.  It's just like setting
tab stops.

	The ^KW (What) command is used to show the current tab and margin
settings at the bottom of the screen.  The display is cleared when you type a
space.	It also shows several other parameters.

@Subsection(Dynamically adjusting margin settings)

	The ^KA (Adjust) command is used to adjust margin settings in or
out on both sides of the page.	Typing ^KA will cause both margins to be
indented 15 spaces, suitable for indented notes or quotations.	Typing ^KA
again will return to the previous margins.

	Use the /SHRINK:n switch on entry to WPSIM to specify the amount to
shrink or expand the margins when ^KA is used.  The default is 15.

@Subsection(Changing scrolling value)

	When you switch display pages by using the arrow keys to move off the
screen, the screen moves eight lines up or down by default.  You can switch
the number of lines scrolled to any value between 1 and 24 by using the
^KV
command.  Just type <ESCAPE> followed by the number desired; then followed by
the ^KV command.

@Section(Customizing your editing environment)
@Subsection(Special functions)
@Label(spe)

     Several of the terminals on campus have special function keys that can
be defined to execute user-defined command sequences.  They are Viewpoints,
VT100s and Rainbows.

     You can either accept the default function definitions, or define your
own using your WPSIM.INI file.	You can also define them at startup by using
the /FUNCTION switch, or even define them in the middle of editing by using
the ^NF (insert function) command.	(See section @ref(ins).)

     A function is usually loaded by using the
/FUNCTION switch, specifying a function code of 1-6 or A-J, and giving a
string of quoted characters that represent some sequence of WPSIM commands.

	Function keys differ from terminal to terminal.  On the Viewpoint,
the special keys @B(F1), @B(F2) and @B(F3) give you functions 1-3, and shifted
they give functions 4-6.  Functions A-J are executed by using the ^B
command -- type ^B and follow it by a letter between A and J to execute
the corresponding function.

     On a VT100, you use the special function keypad at the right side of
the keyboard.  @B(PF1), @B(PF2) and @B(PF3) give you functions 1, 2 and 3.
The numeric keys @B(7), @B(8) and @B(9) give you functions 4, 5 and 6.
Functions A through J are invoked through keys @B(7, 8, 9,) "@B(-)", @B(4,
5, 6,) "@B(,)", @B(1, 2, 3, 0) and "@B(.)", respectively.

     Although you may set any function key to your own text, some of them
are pre-defined unless you change them:

@format[
@Tabclear()@Tabset(+1",+1.5",+1")
@\Function@\Command@\Action
@bar()
@blankspace(.5)
@\1@\^T@\Transparent tab
@\2@\^NL@\Insert line
@\3@\^W@\Search command
@\4@\^R@\Backwards tab
@\5@\^DL@\Delete line
@\6@\^PW@\Move to next word
]
@Newpage()

     In addition, DEC Rainbows have the following extra function keys defined:

@format[
@Tabclear()@Tabset(+1",+1.5",+1")
@\Function@\Command@\Action
@bar()
@blankspace(.5)
@\FIND@\^W@\Search command
@\INSERT HERE@\^NI@\Enter insert mode
@\REMOVE@\^DW@\Delete word
@\SELECT@\^$<@\Set position marker
@\PREV SCREEN@\^PP@\Move one screen back
@\NEXT SCREEN@\^PN@\Move one screen forward
@\CANCEL@\^C^G@\Abort editing immediately
@\MAIN SCREEN@\^PB@\Move to top of file
@\EXIT@\^E@\Exit editing session
@\HELP@\^KH@\Show help screens
]

	There are also three pre-defined functions available (which you can
re-define if desired), which give you job-style information.  Function U will
print your user name, function C will print your connected directory name, and
function D will print the date and time.

	Executing a function is exactly like typing in the characters that are
specified in the function string.  Control characters in function strings are
represented in the up-arrow--character format, and escapes are represented as
dollar signs.  Function strings can be up to 119 characters long.

	For an example, if you wished to use a function that jumped to the
beginning of the current line and then centered the word "MEMO", you could
give the following function definition in your WPSIM.INI file:

	/FUNCTION:A "^PLMEMO^KC"

	You would execute this function by typing ^BA on any terminal,
or you could use special keypad key "-" on a VT100.

	The command ^KL will list your custom functions while you are in
WPSIM.	The display will return to the original state when you type a space to
clear the function list, just as with the ^KW command.

@Subsection(WPSIM INI files)

	It is possible to customize your WPSIM parameters, if you always reset
the switch defaults to some standard value.  You can create a WPSIM.INI file
in your login directory which contains the switch settings you would normally
use, and these settings will become the default.

	The first line of the INI file will always be executed.  Subsequent
lines are optional, but must start with an option selection keyword if used.
This keyword is initially assumed to be the extension of the file that you are
editing, such as WPS, PAS, RNO, etc.  Alternately, you may specify the keyword
by using the
/TYPE: switch followed by the proper option selection code.

	If the option selection keyword is matched in the INI file, the
switches on that line will be executed.  This allows you to specify different
switches for editing different types of files.	An example WPSIM.INI file
might contain:

@ProgramExample[
	/INDENT:5/AUTOSAVE:300
	WPS/TABS:5/MAXIMUM:65
	RNO/TABS:8/MAXIMUM:78
	PAS/TABS:8/PROGRAM
]

	Thus, you would have five-space tabs when editing FILE.WPS, but have
eight-space tabs when editing FILE.RNO.

	The WPSIM.INI file is executed from the directory you are connected to
when you run WPSIM.  If the file is not found there, your login directory will
also be searched before the program decides that no INI file exists.

@Section(Special file switches)
@Subsection(Input file switches)
@Label(cha)

	Several special parameters which affect the appearance of the text can
be changed when starting up the program.  These parameters are changed by
switches on the input file command line when you first start the program.  If
the switch name is followed by ":N", it means that N is a number you specify
for the switch value.  These parameters are:
@Begin(List)

/AUTOSAVE:N -- This switch will cause your file to be automatically backed up
every n characters.  See section @ref(dis) for more information.

/BACKUP:N -- This value, currently set at 15, is the maximum number of
characters that the program will back up looking for a space.  If the
overlapping word is more than 15 characters long, it is broken at the right
margin, and will be hyphenated at that point.

/CIPHER:N -- Reads in a file previously encrypted by the use of the
/CIPHER:N switch on output.  N is any non-zero integer, and must be the same
cipher key as the one used to encrypt the output file.	Beware: if you forget
what the encryption key was for a particular ciphered file, you may as well
just throw the file away.

/[NO] EXPAND -- Allow current maximum margin setting to be expanded if you are
editing a document which was created with larger margins.  Without this
switch, WPSIM will automatically wrap any words beyond the margin onto the
following line.

/[NO] EXPERT -- Inhibits typing of most error messages.  Error messages in
WPSIM are displayed on the bottom two lines of the screen in reverse video,
and are displayed for 1.5 seconds.  This switch keeps such messages from
appearing, and errors are signaled by the failure of an expected action to
occur.

/[NO] FILETAB -- Converts multiple spaces to tabs on output.  (Default on.)

/FUNCTION:code "function text" -- Allows the use of special command
combinations as pre-defined functions.	Code is either 1-6 or A-J, and
"function text" is any string of characters or control characters that you can
legitimately type to WPSIM.  See section @ref(spe) for details.

/INDENT:N -- Lines can be automatically indented to any column you wish when
you type a carriage return or when your text is automatically split at end of
line.  Auto indentation does not affect the use of the arrow keys or any other
functions.  The default indentation is zero.

/LETTERHEAD:N -- When paginating a document, you usually want the first page
to contain less lines than the rest to allow room for a letterhead or just a
large top margin.  The letterhead:n switch allows you to specify how many
lines should be subtracted from the standard pagesize for the first page only.
The default is 0 lines.

/MAXIMUM:N -- If the text reaches column "n" without a space break, the program
searches back to the last space seen and re-writes the current word onto the
next line.  Starting four spaces before the maximum, WPSIM looks for a space
on which to break the line.

/MODEL2 -- Used only if you are on Viewpoint terminal model 2, and are using
the special function keys in the top right corner.  (Viewpoint model one
terminals have a white dot below the power light, model two terminals don't.)
See section @ref(spe).

/NOHYPHEN -- Prevents the hyphenation that takes place when a word at the end
of a line is too long to move.	(See /BACKUP).	The word gets split at the
margin with no continuation character.

/NUMBER:N -- Starts file page numbering at page N.

/PAGESIZE:N -- By default, the number of lines per page is 52.	This is only
used when you paginate the file.  You can set this value to whatever you wish.

/[NO] PAGINATE -- This switch causes your input file, should you have one, to
have soft page headings stripped.  It also puts WPSIM into auto pagination
mode and causes page headers to be created upon output.

/[NO] PROGRAM -- Sets WPSIM into programming mode, which tends to be different
from text preparation mode.  This sets the screen width to the maximum,
prevents word wrap, prevents automatic justification of text, and prevents
pagination.

/RECOVER -- This switch enables you to recover input lost due to a system
crash, if you used the /AUTOSAVE switch.  See section 6 for more information.

/SCROLL:N -- Specifies the number of lines that should scroll when you move
the cursor off the screen.  Normally set at 8 lines.

/SETTABS:n,n,n..  -- Sets tab stops at all the positions given in the list.
The list may contain column numbers from 1 to 78 and may be of any length.

/SHRINK:N -- Sets margin adjustment value to N characters, for use with the
^KA (Adjust) command.

/SCROLL:N -- Sets default scrolling size to N.	N must be between one and 24.

/TABS:N -- Tabs are set by default to every eight spaces.  You may reset that
to have tabs every "n" spaces.

/TYPE:filetype -- Specifies the type of file you are editing or creating.  The
significance of the file type is explained in the next section.

/VT102 -- Tells WPSIM that your VT100-style terminal has advanced insertion
and deletion features that can make screen manipulation more efficient.
@End(List)

	You can reset any of these parameters when starting the program by
appending switches after the file name you are asked for.

	Note that it is not necessary to type out the full name of the switch
as long as you have enough characters to make the switch unique.  Typing
/I:5/MA:60/BA:20 would be quite sufficient for WPSIM.

@Subsection(Output file switches)

	Special switches allow you to specify special options for your output
file.  When you type a ^E, the system shows you your default name but
allows you to select an alternate output file.	Either type in a name or use
escape to fill in the name above, then follow it by one or more of the
following switches:
@Begin(List)

/CIPHER:N - Encrypt the output using cipher key "n", where n is any non-zero
integer.  This renders the file unreadable except via WPSIM.  To read in a
ciphered file, use the /CIPHER:n switch on input with the same value of n.

/FILETAB - Convert multiple spaces to tabs on output.  This feature allows you
to save storage space by compressing the number of characters in your file on
disk.  However, tabs may interfere with the use of RUNOFF or some compilers.
On by default.

/NOFILETAB - Don't convert multiple spaces to tabs on output.

/NUMBER:N -- Start numbering pages at "n" rather than one.
@End(List)

@Section(Disaster recovery)
@Label(dis)

	WPSIM has an AUTOSAVE feature similar to the one in the EDIT program
which can protect you from losing data in the event of a system crash.	When
using the /AUTOSAVE:n switch, the state of your file will be automatically
stored every n characters you type.  The value n must be at least 100, and the
auto-store operation will occur no more then once per minute in any case.
This option causes the creation of a WPSIM-BACKUP.WPS file.

	The default value of /AUTOSAVE is 200, so autosaving is always set and
you need not specify the switch unless you wish to change the value.  To turn
off the autosaving feature, use the switch /AUTOSAVE:0.

	If the system crashes during an editing session, you can recover most
of your work.  Enter WPSIM and respond NEWFILE.WPS/RECOVER to the input
file prompt, where NEWFILE.WPS represents any filename you choose.
@I(It must be a new filename, not one currently used.)  Your recovered material
will be placed in this file.

	Recovery information is stored in the file WPSIM-BACKUP.WPS.
This file may be deleted except when you need to recover lost information from
it.  Note that this file is written in WPSIM internal format and won't make
sense unless you use the /RECOVER option.  @I(Don't ever try to edit it!)

	The recovery feature is of most use when a system crash causes you to
lose a file that you've been typing in.  However, it can also help if you've
made an editing mistake.  If you delete your file by mistake, for example, you
should immediately exit from WPSIM.  Then start WPSIM again and use the
/RECOVER switch when it prompts for a filename.  In most circumstances,
you will then get your original file back, minus the last line or two that you
typed.  Remember, you must type a non-existing filename before the switch.

	Note that there is only one backup copy available, the most recent.
It is important that you use the /RECOVER option as soon as possible after
you've lost something.	In the example above, if you delete your file, type
several more lines, and then exit and recover you'll probably have overwritten
your backup file with your last input.

@Section(Using WPFORMAT to format WPSIM text)

	The WPFormat program is a post-processor to the WPSIM editor.
WPFormat was designed to allow underlining and boldfacing in a document
created by WPSIM to be printed on the lineprinter or on an
Anderson Jacobsen (AJ) letter-quality printer.	WPFormat is simple to use, and
alleviates the problem of having to use RUNOFF commands in WPSIM to underline
and boldface.
Two special features are available:
underlining and boldfacing.

	Boldfacing portions of your text is done by preceding and ending
the text with an "`" (accent) character.
Underlining a phrase is done by preceding it with an "__"
(underline) character, and ending the phrase with the same character.
While you are are creating it, your text will look like this:

	`This is in bold characters` and __this is underlined__.

	After processing, it will come out like this:

	@B(This is in bold characters) and @UX(this is underlined.)

	Perform the following steps to prepare a document for the
post-processor:

@Begin(Enumerate,Spread .3)

Create your document with WPSIM, using the special characters above.

Run WPFormat by typing "wpformat" at the EXEC prompt (@@).

WPFormat will prompt you for an input file; enter the name of the document you
created using WPSIM.

WPFormat will prompt you for an output file; enter a filename different from
the document you created with WPSIM.  If you do not enter a different file
name, WPFormat will write over your original document.

WPFormat will prompt you for the number of spaces to indent the left margin.
Since the lineprinter has a default left margin of 1/2 inch, you should
enter "5" here to have a document properly centered.  Choose "0" for any other
type of printer.

@Multiple{
WPFormat will prompt you for the output format.  This can be one of WPSIM, AJ,
or GENERAL.  However, the program will only convert in the following ways:

@ProgramExample[
	WPSIM ==> AJ
	WPSIM ==> General
	AJ ==> WPSIM
]

	The "WPSIM" format is the
format of a file which can be edited with WPSIM; the underscore and accent
characters are in the file.  The "AJ" format consists of character strings
which are meaningful to the Anderson-Jacobsen letter-quality printer.  The
"general" format contains the control characters which force boldfacing and
underscoring on the lineprinter.
}

When you see the EXEC prompt, submit the OUTPUT file to be printed, using
whatever switches you want.
@End(Enumerate)

	This is a sample run using WPFormat:

@ProgramExample[
	@@WPFORMAT
	Input file: TEST.WPS
	Output file: TEST.LPT
	Indentation: 5
	Output format: GENERAL
	@@PRINT TEST.LPT/DELETE
]

	Caution:
@Begin(List)

If you use the WPFormat output format option "general", you cannot return the
new file to a WPSIM compatible file.

If you move the left margin of your document with the WPFormat
"indentation" option, WPSIM cannot move it back for you.
@End(List)

@Newpage()
@Pagefooting(Center="")
@Center[@Majorheading{Command Summary}]
@Tabclear()@Tabset(+.75",+1",+1.25")
@Format[


@\Primary@\Secondary
@\Command@\Command@\Function
@Bar()
@Tabclear()@Tabset(+1",+1",+1")
@Blankspace(.5)
@\^L@\@\Refresh the screen
@Blankspace(.5)
@\^E@\@\Exit from program, specifying output file.
     **@\^C@\@\Abort all editing, don't save file.
@Blankspace(.5)
@\^P@\B@\Position to Beginning of file.
@\@\E@\Position to End of file.
@\@\L@\Position to start of current Line.
@\@\A@\Position to Append to current line.
@\@\W@\Position to start of next Word.
     *@\@\N@\Position to Next page (screen).
     *@\@\P@\Position to Previous page (screen).
@\@\C@\Position to Center (alternate refresh).
@Blankspace(.5)
     *@\^D@\C@\Delete Character.
@\@\W@\Delete Word.
     *@\@\L@\Delete Line.
@\@\R@\Delete Remainder of line.
@\@\B@\Delete to Beginning of line.
     **@\@\E@\Delete to End of file.
     **@\@\F@\Delete File.
@Blankspace(.5)
     *@\^N@\C@\iNsert Character.
     *@\@\L@\iNsert Line.
@\@\S@\iNsert, Splitting line at cursor.
@\@\I@\Insert mode - toggle on or off.
@\@\F@\iNsert Function.
@Blankspace(.5)
     *@\^W@\@\Search for and optionally replace string.
@\^X@\@\Repeat last search or replace operation.
@Blankspace(.5)
     *@\^G@\C@\Copy lines into text buffer.
     *@\@\M@\Move lines into text buffer, deleting.
@Blankspace(.5)
@\$<@\@\Set beginning of text string.
@\$>@\C@\Set end of string, copy into buffer.
@\@\M@\Set end of string, move into buffer.
@\@\D@\Set end of string, delete string.
@\@\R@\Return to beginning of string.
@Blankspace(.5)
@\^O@\@\Retrieve contents of move buffer.
@Blankspace(3)
     *  Indicates that command can accept a numeric argument.
     ** Indicates that command must be confirmed by ^G.
@Newpage()
@Tabclear()@Tabset(+.75",+1",+1.25")
@Blankspace(2)
@\Primary@\Secondary
@\Command@\Command@\Function
@Bar()
@Tabclear()@Tabset(+1",+1",+1")
@Blankspace(.5)
@\^T ; ^R@\@\Tab and Reverse tab.
@Blankspace(.5)
@\^B@\code@\Execute function code, code is A-J.
@\@\U@\Insert user name into file at cursor.
@\@\C@\Insert connected directory at cursor.
@\@\D@\Insert date and time at cursor.
@Blankspace(.5)
     *@\^V@\P@\eVen out text lines in Paragraph.
     *@\@\D@\eVen out Double spaced lines.
@\@\F@\eVen out text lines in File.
@\@\A@\eVen out All double lines in file.
@Blankspace(.5)
@\^K@\A@\Adjust margins.
@\@\B@\set page Break.
@\@\C@\Center text.
@\@\D@\Double spacing mode toggle.
@\@\F@\make current line Flush right.
@\@\H@\specify a pagination Header.
@\@\I@\set new value for /INDENT.
@\@\J@\Join two lines together.
@\@\L@\List user-defined functions.
@\@\M@\set new value for /MAXIMUM.
     **@\@\N@\load New file into memory
@\@\P@\toggle Pagination mode.
@\@\R@\Remove a tab stop.
@\@\S@\Set a tab stop.
@\@\U@\Unpaginate - remove perm.  page markers.
     *@\@\V@\set new scrolling Value.
@\@\W@\show What tab and margin settings are.
@\@\?@\show a command summary.
@Blankspace(3)
     *  Indicates that command can accept a numeric argument.
     ** Indicates that command must be confirmed by ^G.
]
