      SUBROUTINE DATALL(LSTLIN,MRKLIN,MAXWID,IFLTTR,LETTER,
         1    IFCNCT,KONECT,XPOINT,MINSUB,MAXSUB, XLEFT,YVALUE,
         2    XRIGHT, IGRID, IEDGE,MARGIN,MSHWID,MSHHIH,LTROFF,
         3    LINPRT, IDISK,IRESET,LSTORE,XSTORE)
   C     RENBR(/TIME SERIES PLOT ROUTINE FOR PRINTER)
   C
  C     DONALD BARTH, HARVARD BUSINESS SCHOOL
C
  C     DATALL  IS  A  FORTRAN  SUBROUTINE  WHICH  CONSTRUCTS
    C     PRINTABLE  PLOTS  WITH  A  VERTICAL  TIME  (OR  OTHER
    C     CONSTANT INCREMENT UNIT) AXIS EXTENDING ONTO AS  MANY
    C     LINES  AND  PAGES  AS  ARE NECESSARY TO REPRESENT THE
                             C     DATA.  THE POINTS WHICH REPRESENT A  PARTICULAR  DATA
    C     ITEM  IN  CONSECUTIVE  TIME  PERIODS CAN BE CONNECTED
    C     WITH LINE SEGMENTS TO FORM A CURVE.  A CURVE DOES NOT
    C     NEED TO EXTEND ACROSS ALL TIME PERIODS.  THE SECTIONS
    C     OF A CURVE WHICH ARE OUTSIDE THE PLOT  AREA  ARE  NOT
    C     REPRESENTED.     A   MAXIMUM   OF   26   CURVES   ARE
    C     DISTINGUISHABLE  BY  BEING  PLOTTED  WITH   DIFFERENT
    C     CHARACTERS, BUT THERE IS NO LIMIT TO THE TOTAL NUMBER
    C     OF CURVES WHICH CAN BE INCLUDED  IN  THE  PLOT  OF  A
                                                           C     PARTICULAR  TIME  PERIOD  OR  IN THE PLOT OF ALL TIME
    C     PERIODS.  OVERLAPPING SECTIONS OF CURVES  REPRESENTED
    C     BY DIFFERENT CHARACTERS ARE INDICATED BY AMPERSANDS.
C
  C     DATALL IS CALLED ONCE FOR EACH TIME PERIOD TO  APPEND
    C     A  REPRESENTATION OF THE DATA FOR THAT TIME PERIOD TO
    C     THE PLOT OF THE DATA FOR THE  PREVIOUS  TIME  PERIOD.
    C     ARRAYS  INPUT  TO  DATALL  SPECIFY  THE HORIZONTAL OR
    C     NON-TIME  COORDINATE  OF  EACH  POINT  FOR  THE  TIME
    C     PERIOD, THE LETTERS WITH WHICH THESE POINTS ARE TO BE
                                                           C     PLOTTED, AND THE LETTERS WITH WHICH THE POINTS ARE TO
    C     BE  CONNECTED  WITH  THE POINTS FOR THE PREVIOUS TIME
    C     PERIOD.  THE  SEGMENT  OF  THE  PLOT  REPRESENTING  A
    C     SINGLE  TIME PERIOD CAN CONTAIN SEVERAL POINTS AND/OR
    C     LINES.  IT  IS  OPTIONAL  WHETHER  THE  PLOT  SEGMENT
    C     REPRESENTING  A TIME PERIOD IS RULED WITH A GRID LINE
    C     AND IS IDENTIFIED BY A SCALE NUMBER.
 C
  C     DATALL IS A RELATIVELY  SHORT  ROUTINE  WHICH  RELIES
    C     UPON  DAPLAT  FOR  ITS  PLOTTING  CAPABILITIES.   THE
    C     ROUTINES DARITE AND PLTCUT MUST  ALSO  BE  LOADED  AS
         C     THESE  ARE  CALLED  BY  DAPLAT.   DAPLAT  MUST NOT BE
    C     CALLED BY ANY OTHER PROGRAM UNTIL THE PLOTTING OF ALL
    C     TIME  PERIODS  HAS  BEEN  COMPLETED  SINCE DAPLAT HAS
    C     INTERNAL STORAGE WHICH IS USED  BY  DATALL.   IF  THE
    C     USER'S  PROGRAM  CALLS  DAPLAT  TO  DO OTHER PLOTTING
    C     AFTER THE PLOTTING OF THE DATA FOR ALL  TIME  PERIODS
    C     HAS  BEEN  COMPLETED,  THEN  THIS  SUBSEQUENT CALL TO
    C     DAPLAT MUST USE NON-ZERO  VALUES  FOR  THE  ARGUMENTS
    C     MAXWID,  MAXHIH,  MSHWID AND MSHHIH SINCE THE DEFAULT
                                                           C     VALUES OF  THESE  DAPLAT  ARGUMENTS  ARE  CHANGED  BY
    C     DATALL.  THE CHARACTER SET USED FOR PLOTS PRODUCED BY
    C     DATALL  CAN  BE  MANIPULATED  AS  DESCRIBED  IN   THE
    C     INSTRUCTION MANUAL FOR DAPLAT.  THE MAXIMUM PLOT SIZE
    C     LIMITATION FOR DAPLAT APPLIES TO  EACH  TIME  PERIOD,
    C     NOT  TO  THE  ENTIRE PLOT OF ALL TIME PERIODS, AND SO
    C     SHOULD BE OF NO CONCERN TO THE USER.
 C
  C     ARGUMENTS USED TO INPUT VALUES TO DATALL.
 C
  C     LSTLIN = 0, CURRENT TIME PERIOD IS FINAL TIME  PERIOD
    C              TO  BE  REPRESENTED  IN PLOT.  SCALE NUMBERS
                   C              RANGING IN VALUE FROM THAT OF XLEFT  THROUGH
    C              THAT  OF  XRIGHT  ARE  TO  BE  WRITTEN BELOW
    C              REPRESENTATION OF CURRENT TIME  PERIOD,  AND
    C              INTERNAL  STORAGE  IN  DATALL  AND DAPLAT IS
    C              THEN TO BE CLEARED.
    C            = GREATER THAN ZERO, CURRENT  TIME  PERIOD  IS
    C              NOT  FINAL  TIME PERIOD IN PLOT.  SUBSEQUENT
    C              CALLS TO DATALL WILL ADD ADDITIONAL SEGMENTS
    C              TO CURRENT PLOT.  VALUE OF LSTLIN IS IGNORED
    C              OTHER  THAN  TO  DETERIMINE  WHETHER  IT  IS
                   C              GREATER  THAN  ZERO.   IF MAIN PROGRAM KNOWS
    C              TOTAL NUMBER OF TIME PERIODS, IT  CAN  COUNT
    C              LSTLIN  DOWN  TO ZERO.  IF MAIN PROGRAM DOES
    C              NOT KNOW TOTAL NUMBER OF TIME PERIODS, IT IS
    C              SUFFICIENT  TO  SET  LSTLIN TO 1 UNTIL FINAL
    C              TIME PERIOD.
 C     MRKLIN = 0, CURRENT VALUE OF ARGUMENT YVALUE IS TO BE
    C              PRINTED   TO   LEFT   OF   BOTTOM   LINE  IN
    C              REPRESENTATION OF CURRENT  TIME  PERIOD  AND
    C              SCALE  LINE CAN BE DRAWN THROUGH THIS BOTTOM
    C              LINE.
   C            = GREATER THAN ZERO, SCALE NUMBER IS NOT BE BE
    C              PLACED  BESIDE BOTTOM LINE IN REPRESENTATION
    C              OF CURRENT TIME PERIOD AND THIS BOTTOM  LINE
    C              CANNOT  BE  RULED  AS  GRID  LINE.  VALUE OF
    C              MRKLIN IS IGNORED OTHER THAN  TO  DETERIMINE
    C              WHETHER  IT  IS GREATER THAN ZERO.  IF VALUE
    C              OF ARGUMENT YVALUE  IS  NOT  TO  BE  PRINTED
    C              BESIDE  EACH TIME PERIOD, THEN MRKLIN CAN BE
    C              COUNTED DOWN TO ZERO BY MAIN PROGRAM.
 C     MAXWID = WIDTH OF PLOT STATED AS NUMBER OF COLUMNS OF
    C              CHARACTERS  FORMING PLOTTING AREA UPON WHICH
    C              DATA CAN BE PLOTTED.  MAXWID IS  NORMALLY  1
    C              PLUS  MULTIPLE OF MSHWID.  MAXIMUM EFFECTIVE
    C              VALUE OF MAXWID IS 131.  IT SHOULD BE  NOTED
    C              THAT   PLOT  HAS  ADDITIONAL  MARGIN  OF  12
    C              CHARACTERS ALONG LEFT SIDE  IN  WHICH  SCALE
    C              NUMBERS AND CARRIAGE CONTROL ARE PRINTED.
  C            = 0, USE THE LAST NONZERO VALUE SPECIFIED  FOR
    C              MAXWID AS  THE WIDTH OF THE PLOT, OR USE THE
                                                                C              VALUE 101  IF A NONZERO  VALUE OF MAXWID HAS
    C              NOT BEEN SPECIFIED.
    C     IFLTTR = SELECTS WHETHER CHARACTERS TO BE PLOTTED  AT
    C              POINTS  ARE TO BE IDENTIFIED BY LETTER ARRAY
    C              OR  BY  LOCATION  OF  THEIR  COORDINATES  IN
    C              XPOINT ARRAY.
C            = 0, LETTER ARRAY IDENTIFIES CHARACTERS TO  BE
    C              PLOTTED AT POINTS.
C            = 1, POINTS ARE PLOTTED USING  LETTERS  HAVING
    C              SAME   SEQUENCE   NUMBER   IN   ALPHABET  AS
    C              SUBSCRIPTS  OF  LOCATION  IN  XPOINT   ARRAY
                   C              CONTAINING  COORDINATES.   POINT  HAVING ITS
    C              NON-TIME COORDINATE IN  XPOINT(3)  WOULD  BE
    C              REPRESENTED  BY  LETTER  C,  3RD  LETTER  IN
    C              ALPHABET.  POINTS HAVING SUBSCRIPTS EQUAL TO
    C              OR  GREATER  THAN  27   ARE  REPRESENTED  BY
    C              ASTERISKS.   CONTENTS  OF  LETTER  ARRAY ARE
    C              IGNORED.
C     LETTER = ARRAY IDENTIFYING CHARACTERS WITH  WHICH  TO
    C              REPRESENT  POINTS HAVING AS THEIR HORIZONTAL
    C              OR NON-TIME  COORDINATES  VALUES  IN  XPOINT
                                  C              ARRAY  WITH  SAME  SUBSCRIPTS.  LETTER ARRAY
    C              VALUES OF  -1  INDICATE  THAT  CORRESPONDING
    C              POINTS  ARE NOT TO BE PLOTTED.  LETTER ARRAY
    C              VALUES OF ZERO INDICATE  THAT  CORRESPONDING
    C              POINTS  ARE  TO  BE  PLOTTED WITH ASTERISKS.
    C              VALUES  GREATER  THAN  ZERO   ARE   SEQUENCE
    C              NUMBERS  WITHIN  ALPHABET  OF  LETTERS TO BE
    C              USED TO REPRESENT POINTS.  IF  ASTERISK  AND
    C              LETTER ARE TO OCCUPY SAME PRINTING CHARACTER
                                                           C              POSITION ON PLOT, THEN LETTER  APPEARS.   IF
    C              DIFFERENT   LETTERS   ARE   TO  OCCUPY  SAME
    C              PRINTING CHARACTER POSITION  ON  PLOT,  THEN
    C              AMPERSAND  APPEARS  INSTEAD.   IF  IFLTTR IS
    C              NON-ZERO, THEN LETTER ARRAY IS NOT USED  AND
    C              NEED NOT BE DIMENSIONED.
    C     IFCNCT = SELECTS WHETHER  CHARACTERS  TO  BE  PLOTTED
    C              ALONG LINE SEGMENTS CONNECTING POINTS ARE TO
    C              BE IDENTIFIED BY KONECT ARRAY OR ARE  TO  BE
    C              SAME AS THOSE USED TO REPRESENT POINTS.
                   C            = -1, POINTS IN CURRENT TIME PERIOD ARE NOT TO
    C              BE  CONNECTED  TO  POINTS  OF  PREVIOUS TIME
    C              PERIOD.   CONTENTS  OF  KONECT   ARRAY   ARE
    C              IGNORED.
C            = 0, KONECT ARRAY IDENTIFIES CHARACTERS TO  BE
    C              PLOTTED ALONG LINE SEGMENTS.
C            = 1, LINE SEGMENTS ARE TO BE  FORMED  OF  SAME
    C              CHARACTERS  AS  ARE  USED  TO PLOT POINTS IN
    C              CURRENT PERIOD.  CONTENTS  OF  KONECT  ARRAY
    C              ARE IGNORED.
 C     KONECT = ARRAY IDENTIFYING CHARACTERS WITH  WHICH  TO
                        C              CONNECT  POINTS  OF CURRENT TIME PERIOD WITH
    C              POINTS OF PREVIOUS  TIME  PERIOD  WHICH  HAD
    C              SAME  SUBSCRIPTS.   IF  POINTS  HAVING  SAME
    C              SUBSCRIPT WERE NOT PLOTTED IN  BOTH  CURRENT
    C              TIME  PERIOD  AND PREVIOUS TIME PERIOD, THEN
    C              VALUE IN KONECT ARRAY IS  IGNORED.   LETTERS
    C              ARE  SELECTED BY KONECT ARRAY IN SAME MANNER
    C              AS BY  LETTER  ARRAY,  WITH  EXCEPTION  THAT
    C              KONECT    ARRAY    VALUE    OF   -1   CAUSES
                                                           C              CORRESPONDING POINTS,  IF  ANY,  TO  NOT  BE
    C              CONNECTED.   IF  IFCNCT  IS  NON-ZERO,  THEN
    C              KONECT ARRAY IS NOT USED  AND  NEED  NOT  BE
    C              DIMENSIONED.
 C     XPOINT = ARRAY  CONTAINING  HORIZONTAL  OR   NON-TIME
    C              COORDINATES  OF  POINTS  TO  BE  PLOTTED FOR
    C              CURRENT TIME PERIOD.  COORDINATE SYSTEM USED
    C              FOR  XPOINT  ARRAY MUST BE SAME AS THAT USED
    C              FOR ARGUMENTS XLEFT AND XRIGHT WHICH  SELECT
    C              COORDINATES TO BE PLACED AT LEFT EDGE AND AT
                             C              RIGHT  EDGE  OF  PLOT  RESPECTIVELY.    ONLY
    C              VALUES  OF  LETTER, KONECT AND XPOINT HAVING
    C              SUBSCRIPTS IN RANGE STARTING WITH MINSUB AND
    C              EXTENDING THROUGH MAXSUB ARE USED.
    C     MINSUB = LOWEST VALUED SUBSCRIPT TO BE PLOTTED  USING
    C              INFORMATION  IN  LETTER,  KONECT  AND XPOINT
    C              ARRAYS.  SUBSCRIPT RANGE CAN VARY  FROM  ONE
    C              TIME PERIOD TO NEXT.
   C     MAXSUB = HIGHEST VALUED SUBSCRIPT TO BE PLOTTED USING
    C              INFORMATION  IN  LETTER,  KONECT  AND XPOINT
                             C              ARRAYS.  SUBSCRIPT RANGE CAN VARY  FROM  ONE
    C              TIME  PERIOD  TO  NEXT.  IF NO DATA IS TO BE
    C              PLOTTED FOR CURRENT TIME PERIOD, THEN MAXSUB
    C              CAN BE LESS THAN MINSUB.  IT SHOULD BE NOTED
    C              THAT EMPTY TIME PERIODS  AT  START  OF  TIME
    C              SERIES  PLOT  ARE  DISCARDED,  BUT THAT ONCE
    C              NON-EMPTY TIME PERIOD HAS BEEN  ENCOUNTERED,
    C              THEN  ALL REMAINING TIME PERIODS ARE PLOTTED
    C              WHETHER EMPTY OR  NOT.   ARRAYS  XSTORE  AND
                                                           C              LSTORE  MUST ALSO BE DIMENSIONED TO AT LEAST
    C              MAXIMUM VALUE OF MAXSUB.
    C     XLEFT  = HORIZONTAL OR NON-TIME DATA COORDINATE TO BE
    C              PLACED  AT  LEFT EDGE OF PLOT.  ONLY PORTION
    C              OF CURVES HAVING VALUES  BETWEEN  XLEFT  AND
    C              XRIGHT  WILL  BE  SHOWN  ON  PLOT.   IF LINE
    C              SEGMENT  CROSSES  PLOT,  PORTION   OF   LINE
    C              SEGMENT  WHICH IS OUTSIDE PLOT AREA WILL NOT
    C              BE REPRESENTED.  DATA COORDINATES CAN EITHER
    C              INCREASE OR DECREASE FROM LEFT TO RIGHT.
                  C     YVALUE = NUMBER  IDENTIFYING  CURRENT  TIME   PERIOD.
    C              THIS  VALUE  MUST  CHANGE  FROM  ONE CALL TO
    C              DATALL TO NEXT, BUT CAN EITHER  INCREASE  OR
    C              DECREASE.   IF  CURRENT  VALUE  OF MRKLIN IS
    C              ZERO, THEN VALUE OF YVALUE WILL  BE  PRINTED
    C              TO  LEFT  OF  LOWEST  LINE  OF  CURRENT PLOT
    C              SEGMENT.
C     XRIGHT = HORIZONTAL OR NON-TIME DATA COORDINATE TO BE
    C              PLACED AT RIGHT EDGE OF PLOT.
    C     IGRID  = 0,  PLOT  WILL  SHOW  INTERNAL  GRID.   THIS
                                                 C              INTERNAL GRID WILL BE RULED VERTICALLY EVERY
    C              MSHWID CHARACTERS AND, IF MRKLIN IS EQUAL TO
    C              ZERO, HORIZONTALLY EVERY MHSHIH LINES.
C            = 1, PLOT WILL SHOW INTERSECTIONS OF LINES  OF
    C              INTERNAL  GRID, BUT WILL NOT SHOW GRID LINES
    C              THEMSELVES.  INTERNAL GRID WOULD, IF  SHOWN,
    C              HAVE  VERTICAL LINES EVERY MSHWID CHARACTERS
    C              ACROSS WIDTH OF PLOT AND WOULD, IF MRKLIN IS
    C              EQUAL  TO  ZERO,  HAVE  HORIZONTAL  LINES ON
    C              BOTTOM LINE OF EACH PLOT SEGMENT.  EACH PLOT
    C              SEGMENT   CONSISTS   OF   MSHHIH  LINES,  SO
    C              HORIZONTAL LINES CAN BE RULED  EVERY  MSHHIH
    C              LINES IF MRKLIN IS ALWAYS ZERO.
  C            = 2, PLOT WILL NOT SHOW INTERNAL GRID.
  C     IEDGE  = 0, IF MRKLIN IS EQUAL  TO  ZERO  THEN  PLACE
    C              SCALE  NUMBER  TO  LEFT  OF  LINE DISPLAYING
    C              CURRENT POINTS.  IF LSTLIN IS EQUAL TO ZERO,
    C              THEN PLACE SCALE NUMBERS BELOW PLOT.
  C            = 1, IF MRKLIN IS EQUAL  TO  ZERO  THEN  PLACE
    C              SCALE  NUMBER  TO  LEFT  OF  LINE DISPLAYING
                             C              CURRENT POINTS.  DO NOT PLACE SCALE  NUMBERS
    C              BELOW PLOT.
  C            = 2, IF LSTLIN IS EQUAL TO  ZERO,  THEN  PLACE
    C              SCALE  NUMBERS  BELOW  PLOT.   DO  NOT PLACE
    C              SCALE NUMBERS TO LEFT OF PLOT.
   C            = 3, DO NOT PLACE SCALE NUMBERS EITHER TO LEFT
    C              OF OR BELOW PLOT.
 C     MARGIN = MINIMUM   NUMBER   OF   CHARACTERS   BETWEEN
    C              CARRIAGE  CONTROL  CHARACTER  IN COLUMN 1 OF
    C              OUTPUT AND LEFT EDGE OF PLOT.   THIS  MARGIN
    C              INCLUDES  LEFT  SCALE  NUMBERS AND SPACES TO
         C              THEIR LEFT.
  C     MSHWID = WIDTH OF GRID DIVISIONS STATED AS NUMBER  OF
    C              COLUMNS OF CHARACTERS.  MSHWID=10 WOULD GIVE
    C              VERTICAL  GRID  LINES  EVERY  10  CHARACTERS
    C              ACROSS WIDTH OF PLOT AREA.
  C            = 0, USE THE LAST NONZERO  VALUE SPECIFIED FOR
    C              MSHWID AS  THE GRID  DIVISION  WIDTH, OR USE
    C              THE VALUE  10 IF A  NONZERO VALUE  OF MSHWID
    C              HAS NOT BEEN SPECIFIED BY A PREVIOUS CALL TO
    C              THIS ROUTINE.
C     MSHHIH = NUMBER OF LINES OF PRINTING TO  BE  INCLUDED
                   C              IN  PLOT  SEGMENT  REPRESENTING CURRENT TIME
    C              PERIOD.   IF  POINTS  FOR  SUCCESSIVE   TIME
    C              PERIODS   ARE   BEING   CONNECTED   BY  LINE
    C              SEGMENTS,  THEN  THESE  LINE  SEGMENTS  WILL
    C              EXTEND   ACROSS  THESE  LINES  OF  PRINTING.
    C              POINTS THEMSELVES ARE REPRESENTED IN  BOTTOM
    C              LINE OF PLOT SEGMENT.
  C            = 0, ASSUME THAT MSHHIH=1 IS MEANT.  EACH TIME
    C              PERIOD WILL BE REPRESENTED BY SINGLE LINE OF
    C              TIME SERIES PLOT.
                                              C     LTROFF = DISTANCE  STATED  AS  NUMBER  OF  CHARACTERS
    C              BETWEEN  LEFT  EDGE  OF  PLOT AND LEFT SCALE
    C              LINE.  IF LTROFF=0,  THEN  LEFT  SCALE  LINE
    C              WILL BE AT LEFT EDGE OF PLOT.
    C     LINPRT = -1, THE PLOT IS NOT  TO INCLUDE ANY CARRIAGE
    C              CONTROL CHARACTER AT LEFT END OF EACH LINE.
C            = 0, PLOT WILL BE VIEWED BY USER ON  TERMINAL,
    C              EITHER TYPED DIRECTLY WITH IDISK BEING GIVEN
    C              TERMINAL UNIT NUMBER, OR TYPED BY USER AFTER
    C              THIS  ROUTINE  HAS WRITTEN PLOT INTO FILE ON
              C              UNIT NUMBER OF WHICH IS CONTAINED IN  IDISK.
    C              BLANK  OR  SPACE  WILL  BE  USED AS CARRIAGE
    C              CONTROL CHARACTER TO GIVE SINGLE SPACING.
  C            = 1, PLOT WILL BE PRINTED ON LINE  PRINTER  BY
    C              USER  AFTER  PROGRAM  HAS  WRITTEN PLOT INTO
    C              FILE.  ASTERISK WILL  BE  USED  AS  CARRIAGE
    C              CONTROL  CHARACTER  TO  GIVE  SINGLE SPACING
    C              WITH SUPPRESSION OF SKIPPING EXTRA LINES  AT
    C              PAGE  BOUNDARIES.   ON  PDP-10,  ASTERISK AS
                                                                C              CARRIAGE     CONTROL     CHARACTER     GIVES
    C              OVERPRINTING   ON  TERMINAL  AS  OPPOSED  TO
    C              SINGLE SPACING.
   C     IDISK  = UNIT NUMBER OF DEVICE ONTO WHICH  PLOTS  ARE
    C              TO  BE  WRITTEN.   THIS  ROUTINE  WILL  ONLY
    C              GENERATE  PLOT.   IT  IS  RESPONSIBLITY   OF
    C              CALLING  PROGRAM  TO OPEN OUTPUT FILE AND TO
    C              WRITE CAPTIONS, FORM FEEDS AND/OR SEPARATING
    C              LINES.
  C
  C     FOLLOWING ARGUMENT IS USED BOTH FOR INPUT AND OUTPUT.
    C
                                                    C     IRESET = 1 (OR GREATER), NEITHER  DATALL  NOR  DAPLAT
    C              HAVE  BEEN CALLED BEFORE.  INTERNAL STORAGES
    C              IN  BOTH  DATALL  AND  DAPLAT  ARE   TO   BE
    C              INITIALIZED.   IRESET  CAN  BE  GIVEN  VALUE
    C              GREATER THAN ONE TO  SELECTIVELY  INITIALIZE
    C              STORAGE    IN    DAPLAT.    CONSULT   DAPLAT
    C              DOCUMENTATION FOR  THESE VALUES.   IRESET IS
    C              RETURNED SET TO -1.
    C            = 0,  DAPLAT  HAS  ALREADY  BEEN  CALLED,  BUT
    C              DATALL  HAS  NOT  BEEN  CALLED.   IRESET  IS
                   C              RETURNED SET TO -1.
    C            = -1, DATALL HAS BEEN PREVIOUSLY CALLED.
C
  C     ARGUMENTS USED ONLY FOR INTERMEDIATE DATA STORAGE
   C
  C     VALUES INITIALLY IN ARRAY ARGUMENTS XSTORE AND LSTORE
    C     ARE IGNORED AND ARE DESTROYED.  THESE ARRAYS ARE USED
    C     BY DATALL TO STORE COORDINATES OF POINTS AND TO STORE
    C     LETTERS  USED TO PLOT THESE POINTS SO THAT SUBSEQUENT
    C     CALL TO DATALL CAN EXTEND LINE SEGMENTS  FROM  POINTS
    C     OF  TIME PERIOD PREVIOUS TO IT.  CALLING PROGRAM MUST
    C     NOT MODIFY CONTENTS OF THESE ARRAYS WHILE TIME SERIES
                        C     PLOT   IS  BEING  GENERATED.   BOTH  ARRAYS  MUST  BE
    C     DIMENSIONED TO AT  LEAST  MAXIMUM  VALUE  OF  MAXSUB.
    C     THIS  ARRAY  SPACE  CAN BE USED FOR OTHER PURPOSES BY
    C     CALLING PROGRAM AFTER DATALL  HAS  BEEN  CALLED  WITH
    C     LSTLIN EQUAL TO ZERO.
 C
  C     LSTORE = USED TO  STORE  CONTENTS  OF  LETTER  ARRAY.
    C              DIMENSION  OF  LSTORE  ARRAY MUST BE MAXIMUM
    C              VALUE OF MAXSUB ENCOUNTERED WHILE IFLTTR  IS
    C              ZERO.  IF IFLTTR IS ALWAYS 1, THEN LSTORE IS
    C              NEVER USED AND NEED NOT BE DIMENSIONED.
                             C     XSTORE = USED TO STORE CONTENTS OF XPOINT ARRAY.
    C
  C     THE ITEMS IN  COMMON/FASPF/  STORE  INFORMATION ABOUT
    C     PREVIOUS CALL TO DAHIST AND MUST BE PRESERVED BETWEEN
    C     CALLS
        COMMON/FASPF/KRESET,LINKNT,JRESET,MRKSTR,IFLSTR,
         1             MINSTR,MAXSTR,YVASTR,LTRERR,LINERR
C
        DIMENSION LETTER(MAXSUB),KONECT(MAXSUB),
       1XPOINT(MAXSUB),LSTORE(MAXSUB),XSTORE(MAXSUB)
         DIMENSION XDOUBL(2),YDOUBL(2)
   C
  C     DETERMINE WHETHER THIS IS FIRST PANEL OF PLOT
        IF(IRESET.GE.0)GO TO 23
          IF(KRESET.NE.999)GO TO 23
  C
  C     GET CURRENT HEIGHT
          JHIGH=2
      IF(MSHHIH.GT.0)JHIGH=MSHHIH+1
   C
  C     MASK OUT THE HUNDREDS DIGIT OF IGRID
       JGRID=IGRID
       IF(JGRID.LT.0)JGRID=0
       KGRID=JGRID/100
        JGRID=JGRID-(100*KGRID)
    C
  C     MASK OUT THE HUNDREDS DIGIT OF IEDGE
       JEDGE=IEDGE
       IF(JEDGE.LT.0)JEDGE=0
       KEDGE=JEDGE/100
        JEDGE=JEDGE-(100*KEDGE)+300
C
  C     DETERMINE PLACEMENT OF EDGE LINES
          IF(LINKNT.GT.1)GO TO 1
      IF(KEDGE.EQ.0)JEDGE=JEDGE-100
         IF(KEDGE.EQ.2)JEDGE=JEDGE-100
       1 IF(LSTLIN.GT.0)GO TO 2
      IF(KEDGE.LE.1)JEDGE=JEDGE-200
   C
                                C     DETERMINE PLACEMENT OF GRID LINES
        2 LINOFF=0
          IHIGH=JHIGH
       IF(MRKSTR.EQ.0)GO TO 3
      IF(MRKLIN.EQ.0)GO TO 5
      IHIGH=IHIGH+1
          GO TO 6
    3 IF(MRKLIN.EQ.0)GO TO 4
      LINOFF=-1
         IF(LINKNT.GT.1)GO TO 6
      IF(KGRID.EQ.1)GO TO 6
       IF(KGRID.GE.3)GO TO 6
       JGRID=JGRID+200
        GO TO 7
    4 IHIGH=IHIGH-1
          IF(LINKNT.GT.1)GO TO 5
      IF(KGRID.GT.3)GO TO 6
       JGRID=IGRID
       GO TO 7
    5 IF(LSTLIN.GT.0)GO TO 6
      IF(KGRID.GE.2)GO TO 6
       JGRID=JGRID+100
        GO TO 7
    6 JGRID=JGRID+300
  C
                           C     IF SECOND LINE, ADD FIRST SEQUENCE OF POINTS TO PLOT.
    C     SOME OF THESE  MIGHT NOT BE  INCLUDED IN SECOND LINE.
        7 IF(LSTLIN.GT.0)JGRID=-JGRID-1
         IPLOT=-1
          IF(LINKNT.GT.1)GO TO 12
          IPASS=1
      YDOUBL(1)=YVASTR
       INDEX=MINSTR
      KOUNT=1
    8 IF(INDEX.GT.MAXSTR)GO TO 12
      IF(IFLSTR.NE.0)GO TO 9
      IF(LSTORE(INDEX).LT.0)GO TO 11
        ILTTR=LSTORE(INDEX)
         GO TO 10
        9 ILTTR=INDEX
    10 XDOUBL(1)=XSTORE(INDEX)
          GO TO 19
       11 INDEX=INDEX+1
          GO TO 8
C
  C     ADD CURRENT LINE SEGMENT TO THE PLOT
                        12 YDOUBL(1)=YVALUE
       YDOUBL(2)=YVASTR
       IPASS=0
      INDEX=MINSUB
   13 IF(INDEX.GT.MAXSUB)GO TO 21
      IF(IFLTTR.NE.0)GO TO 14
          IF(LETTER(INDEX).LT.0)GO TO 20
        ILTTR=LETTER(INDEX)
         GO TO 15
       14 ILTTR=INDEX
    15 XDOUBL(1)=XPOINT(INDEX)
          KOUNT=1
      IF(IFCNCT.LT.0)GO TO 19
          IF(IFCNCT.GT.0)GO TO 16
          IF(KONECT(INDEX).LT.0)GO TO 19
     16 IF(INDEX.LT.MINSTR)GO TO 19
      IF(INDEX.GT.MAXSTR)GO TO 19
      IF(IFLSTR.NE.0)GO TO 17
          IF(LSTORE(INDEX).LT.0)GO TO 19
        IKNCT=KONECT(INDEX)
         GO TO 18
       17 IKNCT=ILTTR
    18 KOUNT=2
      XDOUBL(2)=XSTORE(INDEX)
       19 CALL DAPLAT(IPLOT,MAXWID,JHIGH,ILTTR,IKNCT,
         1XDOUBL,YDOUBL,1,KOUNT,XLEFT,YVALUE,XRIGHT,
     2YVASTR,JGRID,JEDGE,MARGIN,MSHWID,IHIGH,LTROFF,
      3LINOFF,LINPRT,IDISK,JRESET,LTRERR,LINERR)
       IF(IPLOT.EQ.0)GO TO 22
      IF(IPASS.NE.0)GO TO 11
      XSTORE(INDEX)=XPOINT(INDEX)
   20 IF(IFLTTR.EQ.0)LSTORE(INDEX)=LETTER(INDEX)
      INDEX=INDEX+1
          GO TO 13
    C
  C     CONSTRUCT THE PLOT
       21 KOUNT=0
      IPLOT=0
      GO TO 19
    C
  C     STORE INFORMATION NEEDED BY SUBSEQUENT CALL TO DATALL
       22 IF(LSTLIN.GT.0)GO TO 25
          KRESET=0
          GO TO 26
       23 KRESET=999
        LINKNT=0
          LTRERR=0
          LINERR=0
          JRESET=0
          IF(IRESET.GT.0)JRESET=IRESET
          IRESET=-1
         INDEX=MINSUB
   24 IF(INDEX.GT.MAXSUB)GO TO 25
      XSTORE(INDEX)=XPOINT(INDEX)
      IF(IFLTTR.EQ.0)LSTORE(INDEX)=LETTER(INDEX)
      INDEX=INDEX+1
          GO TO 24
       25 LINKNT=LINKNT+1
        MINSTR=MINSUB
          MAXSTR=MAXSUB
          YVASTR=YVALUE
          MRKSTR=MRKLIN
          IFLSTR=IFLTTR
       26 RETURN
 C922140683991
      END
    
