1976-03-01  LAST UPDATE: 1977-11-23

Swedish National Defense Research Institute        FOA Report
S-104 50 Stockholm 80                              D10007-M3(E5)
SWEDEN                                             March 1976


VISTA - FOR FULL CONTROL OF TEXT DISPLAY TERMINALS

BY JACOB PALME


ABSTRACT

     VISTA is a program package for controlling the input and output
     to an alphanumeric display terminal from a SIMULA program on
     the DECsystem-10 computer.  VISTA allows full program control
     over the contents of the display screen.  The package can for
     example be used to produce "moving pictures" on part or whole
     of the display screen, or to allow the terminal user to move
     around the screen inputting data in various screen fields.  A
     special subpackage FORM allows data input by letting the user
     fill in fields in a "form" displayed on the screen.  Full
     validity check is done immediately for each field input from
     the user.  VISTA recognizes terminals of type INFOTON VISTA and
     VISTAR SATTELITE, DEC Vt52, TANDBERG TDV 2000, MINITEC,
     TELETEC, DATAMEDIA ELITE 2500 and 1520, BEEHIVE B 100,
     CDC 713-10, but will work on most other alphanumeric display
     terminals.


SEARCH KEY:  Computer, Terminal, Display terminal, Alphanumeric
     terminal, Conversational program, Dialogue program, Input,
     Output, Man-computer interaction, SIMULA programming language,
     Picture, Video, Graphic.


SWEDISH ABSTRACT

     VISTA {r ett programpaket f`r styrning av inmatning och
     utmatning till en alfanumerisk sk{rm fr}n ett SIMULA-program
     som k`rs p} datorn DECsystem-10.  VISTA m`jligg`r full
     programkontroll `ver inneh}llet p} sk{rmen.  Man kan t.ex.
     anv{nda paketet f`r att producera "r`rliga bilder" p} hela
     eller delar av sk{rmen, eller f`r att till}ta terminal-
     anv{ndaren att flytta sig runt sk{rmen medan han matar in data
     i olika f{lt p} sk{rmen.  Ett speciellt underpaket FORM till-
     }ter datainmatning genom att en blankett visas p} sk{rmen och
     anv{ndaren fyller i f{lt i denna blankett. Fullst{ndig validi-
     tetskontroll kan d} g`ras omedelbart efter varje inmatat f{lt-
     v{rde fr}n anv{ndaren.  VISTA k{nner igen terminaler av typ
     INFOTON VISTA, DEC VT52, MINITEC och DATAMEDIA ELITE 2500 and
     1520, men kan anv{ndas {ven p} de flesta andra textsk{rms-
     terminaler.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 2


0. TABLE OF CONTENTS

     1.  INTRODUCTION
     2.  OUTPUT TO THE DISPLAY TERMINAL
     3.  INPUT FROM THE DISPLAY TERMINAL
     4.  DATA AVAILABLE TO THE USER
     5.  PREAMBLE FOR PROGRAMS USING THE VISTA PACKAGE
     6.  SWITCHING BETWEEN SEVERAL SCREEN CONTENTS
     7.  CAT AND SHIP - EXAMPLES OF USE OF THE VISTA PACKAGE
     8.  FORM - A SUBPACKAGE FOR FORM-FILL-IN DATA ENTRY
     9.  FORMT AND TABLE - EXAMPLES OF USE OF THE FORM
          PACKAGE
     10. DEBUGGING PROGRAMS USING THE VISTA PACKAGE
     11. MODIFYING VISTA FOR A NEW KIND OF TERMINAL
     Appendix A: NEW FEATURES IN VISTA RELEASE 1976-11
     Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED
     Appendix C: MOVING PICTURES SHOW SIMULATION TO USER


1. INTRODUCTION

     An alphanumeric display terminal allows the cursor to be moved
     freely around the screen, and information to be input and
     output at arbitrary positions on the screen.

     This can be used to produce pictures or tables on the screen,
     where objects or figure change or move during the execution of
     a program.  Data can also be input at arbitrary positions on
     the screen as guided by the terminal user.

     A special application of this is the "form fill-in" method of
     data entry into a program, where a form is displayed on the
     screen, and the terminal user fills in empty fields in this
     form.

     The VISTA package makes it simple to write such programs in the
     SIMULA programming language on a DECsystem-10 computer.

     The package is written for use with VISTA INFOTON alpha-numeric
     display terminals, but the package can be modified for use with
     other display terminals.  (The cursor control commands are
     unfortunately not yet standardized for display terminals.)
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 3


2. OUTPUT TO THE DISPLAY TERMINAL

     WARNING:  If you do any output to the terminal not
     using these procedures, the screen may be garbled.  You
     can then restore the screen by calling the procedure
     "restore_the_whole_screen".


PROCEDURE move_the_cursor_to(horiz, vertic);
     INTEGER horiz, vertic;
     COMMENT This procedure will move the cursor to the
     indicated position on the display screen.  The screen
     is indexed with [0,0] equal to the upper left corner of
     the screen, and with "horiz" increasing leftwards and
     "vertic" increasing downwards from this origin.


PROCEDURE home_the_cursor;
     COMMENT This procedure will move the cursor to position
     [0,0], that is the upper left corner of the screen.


PROCEDURE local_home_the_cursor;
     COMMENT will move the cursor to a terminal-dependent home
     position, usually [0,0] but the lower left corner on CDC 713-10
     in scroll mode.

PROCEDURE outchar(setchar);
     CHARACTER setchar;
     COMMENT This procedure will output the character
     "setchar" onto the cursor position on the screen.  The
     cursor is moved past the outputted character.


PROCEDURE set_char_on_screen(setchar,horiz,vertic);
     CHARACTER setchar;  INTEGER horiz, vertic;
     COMMENT This procedure will output the character
     "setchar" in the position [horiz,vertic] on the screen.
     The cursor is left referring to the [horiz,vertic]
     position (not the next position).


PROCEDURE breakoutimage;
     Breakoutimage should be called if the execution of your program
     is stopped or interrupted (e.g.  at end of execution, with the
     system procedure sleep, for conversation with another terminal,
     for a long timeconsuming task not including any terminal
     output) and you want to ensure that all text printed before the
     stop is output to the terminal.  It is  n o t necessary to call
     breakoutimage before inputting data from the terminal using the
     input procedures defined below, since all these input
     procedures will automatically commence with breakoutimage.
     This means that many programs never have to call breakoutimage.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 4
2. OUTPUT TO THE DISPLAY TERMINAL


PROCEDURE synchronize(horiz, vertic);
     INTEGER horiz, vertic;
     COMMENT This procedure is to be called if there is a
     risk that the correct cursor position on the screen,
     and the position where the program believes the cursor
     to be, is not the same.  The cursor is moved to the
     indicated position even if such was the case.  Such a
     risk is most often common after inputting data from the
     user terminal when "echoenabled" is TRUE.  In such
     cases, VISTA will usually automatically call
     synchronize.


PROCEDURE outtext(t);
     VALUE t;  TEXT t;
     COMMENT This procedure will output the text t on the
     terminal beginning at the cursor position on the
     screen.  The programmer must ensure that there is
     enough space left on the current line of the screen for
     the entire length of the TEXT "t".


PROCEDURE outfix(a,i,j);
     REAL a;  INTEGER i, j;
     COMMENT Almost same as standard SIMULA outfix on the
     screen.  The programmer must ensure that there is space
     for j more characters on the current line of the
     screen.


PROCEDURE outreal(a,i,j);
     REAL a;  INTEGER i, j;
     COMMENT Almost same as standard SIMULA outreal on the
     screen.  The programmer must ensure that there is space
     for j more characters on the current line of the
     screen.


PROCEDURE outfrac(k,i,j);
     INTEGER k, i, j;
     COMMENT Almost same as standard SIMULA outfrac on the
     screen.  The programmer must ensure that there is space
     for j more characters on the current line of the
     screen.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 5
2. OUTPUT TO THE DISPLAY TERMINAL


PROCEDURE outint(i,j);
     INTEGER i, j;
     COMMENT Almost the same as standard SIMULA outint on
     the screen.  The programmer must ensure that there is
     space for j more characters on the current line of the
     screen.


PROCEDURE outimage;
     COMMENT Will output any characters in the sysout.image
     and then move the cursor to the beginning of the next
     line on the screen.


PROCEDURE blank_line(vertic);
     INTEGER vertic;
     COMMENT Will make line "vertic" on the screen fully
     blank.  The cursor is left at the first position of the
     blanked line.


PROCEDURE make_blank(size);
     INTEGER size;
     COMMENT Will make size number of characters blank on
     the screen, starting at current position.  Trailing
     blanks in the screenfields are not reblanked, which
     means that the cursor is left at the first blank which
     need not be reblanked.  Cursor position after this
     procedure will thus depend on how much need be blanked
     on the screen.


PROCEDURE blank_the_screen;
     COMMENT Will make the entire screen blank.  This is
     done automatically when a new VISTA object is created.




PROCEDURE restore_the_whole_screen;
     COMMENT If there is any risk that the data on the
     screen does not agree with what the program belives to
     be there, this procedure will restore the screen to
     what the program belives to be there.  This risk can
     happen if you have input or output data with procedures
     not part of the VISTA package, or if "echoenabled" is
     TRUE and the terminal user has done "type ahead" on the
     terminal keyboard.  "restore_the_whole_screen" is
     called by the VISTA package if the terminal user pushes
     the FORMFEED (=CONTROL-L) key on his terminal keyboard.
     ALTMODE (ESCAPE) has the same effect as FORMFEED, but
     must be pushed twice on VT52 terminals.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 6
2. OUTPUT TO THE DISPLAY TERMINAL


PROCEDURE restore_one_char(horiz, vertic);
     INTEGER horiz, vertic;
     COMMENT Will restore the character in the position
     horiz, vertic on the terminal to what the program
     believes to be there.


PROCEDURE cause_real_time_delay(number_of_fillers);
     INTEGER number_of_fillers;
     COMMENT this procedure will transmit
     "number_of_fillers" fill characters to the screen.
     These characters are not output to the screen.  This
     procedure can be used to delay moving pictures from
     moving too fast on the screen.  The number of fillers
     transmitted depends on the speed of the terminal line -
     more characters for faster terminal lines.  Example:
     With a 2400 baude terminal line, 120 fillers will cause
     a half-second delay.  Warning:  This procedure, and not
     the SLEEP procedure, is recommended if you want
     smoothly moving pictures on the screen.  This procedure
     is however rather CPU-time-consuming.


PROCEDURE cancel_display;
     COMMENT The screen will be blanked.  Further calls on
     the output procedures in the VISTA package will only
     change the internal copy of the screen, nothing will be
     output to the terminal.

     This procedure can be used if you want to display
     another VISTA picture or if you want to talk to the
     terminal not using the VISTA package.

     WARNING:  The input procedures in the VISTA package may
     not be used on cancelled VISTA pictures.


PROCEDURE resume_display;
     COMMENT The screen is restored to the internal copy of
     the screen, and further output procedures in the VISTA
     package will affect both the terminal and the internal
     copy of the screen.

     Note that if you have used the VISTA output procedures
     on a cancelled picture, then the internal version of
     that picture is changed.  Thus, when you call
     resume_display, the modified picture is shown.

     WARNING:  If you are keeping several VISTA objects to
     switch between pictures, then  a l w a y s  cancel the
     previous display before resuming the next.  More than
     one VISTA object should never be resumed at the same
     time.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 7
2. OUTPUT TO THE DISPLAY TERMINAL


BOOLEAN PROCEDURE displaying;
     COMMENT Will return TRUE if this picture is displaying
     (not cancelled with the procedure cancel_display).


HOW TO CREATE BLINKING TEXT

     Blinking text is not available on all terminals.  The
     procedure for getting a terminal to blink is very
     different on terminals of different make.  If you want
     to write programs which create blinking text in a way
     which will work on most terminals, then follow this
     procedure:

   > Reserve a space immediately in front of and after the
     blinking text segment.

   > Move the cursor to the position after the blinking text
     segment and call the procedure stop_blink.

   > Move the cursor to the position in front of the
     blinking text segment and call the procedure
     start_blink.

   > Write the blinking text segment.

   > Call the procedure stop_blink again.

     If you want text on several lines to blink, then regard
     each continuous blinking text segment on each line as a
     separate text segment, and the procedure above must be
     followed for each such text segments.


HOW TO STOP BLINKING TEXT FROM BLINKING

     Rewrite the same or other text on top of each blinking
     text segment including the character immediately in
     front of and immediately after the blinking text
     segment.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 8
2. OUTPUT TO THE DISPLAY TERMINAL


PROCEDURE start_blink;
     COMMENT this procedure will start a section of blinking
     text on terminals where blinking text is allowed, and
     will sound the bell on terminals which have a bell.
     (Bell is optional on Infoton terminals, the VT52 does
     not allow blinking text.) The procedure will also
     output a space on the screen, since certain terminals
     require a space in front of blinking text.  Warning:
     On infoton terminals, start_blink need not be called
     when you are chanching the contents of the blinking
     text, but if you do not call start_blink in such cases,
     your programs will only work as intended on Infoton
     terminals.


PROCEDURE stop_blink;
     COMMENT this procedure will stop a section of blinking
     text on terminals where blinking text is allowed.  The
     procedure will also output a space on the screen, since
     certain terminals require a space after blinking text.
     Warning 1:  Call stop_blink after changes in blinking
     text if you want terminal-independent programs.  (The
     infoton does not require this.)
     Warning 2:  Call stop_blink before every command to
     move the cursor on the screen.  (This is not necessary
     on some terminals, but is necessary on Infoton
     terminals.)


3. INPUT FROM THE DISPLAY TERMINAL

     WARNING:  If you do any INPUT from the terminal not
     using these procedures, then the screen contents may be
     garbled.  In that case, the screen can be restored by
     calling the procedure "restore_the_whole_screen".

     If the terminal user pushes the ALTMODE (ESCAPE) or
     FORMFEED (=CONTROL-L) button on his terminal, then the
     procedure restore_the_whole_screen will be called from
     the program, the next time the program tries to make
     input from the terminal through the routines described
     below.  (On VT52 terminals, the ALTMODE must be pushed
     twice.)

     A note on the DATAMEDIA ELITE 1520 terminal:  If you
     have this terminal without the optional "numeric"
     keyboard, then your terminal does not have the special
     keys for moving the cursor up, down, left and right
     which are often used as input from the user terminal.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 9
3. INPUT FROM THE DISPLAY TERMINAL


     However, there are ways of inputting these codes from
     such ELITE 1520 terminals.  Use the following keys:

     UP     = CONTROL-
     DOWN   = LINE FEED
     LEFT   = BACKSPACE
     RIGHT  = CONTROL-@ or CONTROL- (test yourself)
     HOME   = CONTROL-Y
     ERASE SCREEN = CONTROL-L



PROCEDURE echon;
     COMMENT will make echoenabled TRUE, which means that
     characters input from the terminal are echoed by the
     terminal control handler of the computer and not by the
     vista package.
     Advantage:  Faster echoing when the computer is heavily
     loaded.
     Disadvantage:  Risk that the screen contents do not
     agree with what the program believes to be there,
     especially if the terminal user has done "type ahead".

     WARNING:  With monitor echoing, the inputting of CR
     from the user will erase the next line on the screen,
     and inputting LF will erase part of the next line on
     the screen.  You can avoid this problem by either a)
     using program echoing (echoff), or b) keeping the next
     line blank when inputting data from the user or c)
     restoring the erased line in your program.

     The combination of monitor echoing and a Tandberg TCD
     2000 terminal may also give problems if the "cursor up"
     key is pushed by a user on his terminal when the cursor
     is at the last line of the screen.


PROCEDURE echoff;
     COMMENT will make "echoenabled" FALSE.  See "echon"
     above.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 10
3. INPUT FROM THE DISPLAY TERMINAL


CHARACTER PROCEDURE insingle(echo);
     BOOLEAN echo;
     COMMENT will input one character directly from the
     terminal keyboard, bypassing sysin.image entirely.  The
     user need not push carriage return on his terminal, the
     program will get direct control every time the user
     pushes a terminal key.
     "echo" has effect only if "echoenabled" is FALSE.  In
     that case, if "echo" is FALSE, the input character is
     not echoed at all on the terminal screen.  The
     programmer must thus ensure that user input characters
     are echoed correctly.
     If "echo" is TRUE, but "echoenabled" FALSE, then the
     VISTA package will try to echo input characters.
     Terminal keys like the four keys for moving the cursor
     up, down, left and right, the carriage return, line
     feed, home and rub out(delete) keys are all echoed
     correctly.  (They are usually echoed correctly also
     when echoeanbled is TRUE.)
     Insingle will set the global BOOLEAN variable
     "controlchar" to TRUE if the character read was a
     terminal control character.  Thus, to test if the
     character read was the key with a downdirected arrow on
     the terminal, you can write "c:= insingle(TRUE);  IF
     controlchar AND c = down THEN".


PROCEDURE inimage;
     COMMENT inimage will input a line of text from the
     terminal into the buffer sysin.image.  IF "echoeanbled"
     is TRUE, inimage works just like the ordinary SIMULA
     inimage.  If "echoenabled" is FALSE, inimage is
     different in that every character with RANK less than
     32 will act as a "break" characters, that is signifying
     end of the data input with this call to the inimage
     procedure.


INTEGER PROCEDURE inint;
     COMMENT will search for and read an integer from the
     terminal.  If the data input from the terminal is not
     readable as an integer, then the input field is filled
     with question marks.

     Note:  Not identical to SIMULA inint, since only one
     integer can be read before the user pushes the RETURN
     key on his terminal.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS      Page 11
3. INPUT FROM THE DISPLAY TERMINAL


REAL PROCEDURE inreal;
     COMMENT will search for and read a real item from the
     terminal.  If the data input from the terminal is not
     readable as a real, the the input field is filled with
     question marks.

     Note:  Not identical to SIMULA inreal, since only one
     real can be read before the user pushes the RETURN key
     on his terminal.


TEXT PROCEDURE inword;
     COMMENT will search for and read a word from the
     terminal.  A word is any sequence of non-blank
     characters.


BOOLEAN PROCEDURE inyes;
     COMMENT will search for either "yes" or "no" from the
     terminal, and will return TRUE if "yes" is found.


4. DATA AVAILABLE TO THE USER

     WARNING:  Never change these variables directly.  Always use
     the procedures described above.


SCREEN CONTENTS:


INTEGER PROCEDURE horizontalpos;
     COMMENT Position of the cursor on the screen.


INTEGER PROCEDURE verticalpos;
     COMMENT Position of the cursor on the screen.


TEXT ARRAY screen[0:height-1];
     COMMENT contents of the display screen;
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 12
4. DATA AVAILABLE TO THE USER


CHARACTER PROCEDURE get_char_from_screen(horiz, vertic);
     INTEGER horiz, vertic;
     COMMENT will return the character in the indicated screen
     position.  Will return CHAR(0) if [horiz,vertic] is outside
     the available screen.


TERMINAL INTERFACE MODES:


BOOLEAN echoenabled;
     COMMENT if TRUE, input characters are echoed by the monitor,
     if FALSE by the VISTA package or by you.  See further the
     description of the procedure "echon" above.


USEFUL CHARACTER VARIABLES:

     up = what is input when user pushes the key with an upward
          pointing arrow (usually indicating wish to move the
          cursor upwards on the screen).
     down = same for downward pointing arrow.
     left = same for left-pointing arrow.
     right = same for right-pointing arrow.
     tab = same for tab key on terminal.  (On Tandberg TDV 2000,
          the blink key can be used instead of the tab key.)
     home = what is input when user pushes the home key on the
          terminal, (usually indicating wish to move the cursor to
          a "home" position on the screen. On most terminals, the
          home position is the upper left corner of the screen. On
          CDC 713-10 terminal in scroll mode, the home position is
          the lower left corner.)
     formfeed, carriagereturn, altmode, linefeed, verttab, null,
          fill, tab, startblink, stopblink = what is input when the
          user pushes these respective terminal keys.
     BOOLEAN controlchar = TRUE if the previous character input
          with INSINGLE was a terminal control character.  Thus, to
          check if the previous character was the key on the
          terminal to move the cursor down (with a downdirected
          arrow on it) you can write in your program:
          c:= insingle(TRUE);
          IF controlchar AND c = down THEN ...

     BOOLEAN scrollallow = TRUE stops the automatic inhibiting of
          screen scrolling when you push the CR och LF key at the
          bottom of the screen.  However, the internal screen copy
          is not scrolled properly.

     BOOLEAN addaltmode = TRUE if the type of terminal is of a kind
          where each special terminal control character is preceded
          by an altmode.  You need normally not trouble yourself
          with this, since the procedure "insingle" and the other
          input procedures in the vista package will remove this
          altmode (and make CONTROLCHAR = TRUE).
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 13
4. DATA AVAILABLE TO THE USER


DISPLAYING ON OTHER TERMINALS THAN THE CONTROLLING TTY

     It is possible to use the VISTA package to display pictures on
     other terminals than the controlling TTY.

     Important:  Ensure that you always make outimage on every
     picture displayed on different terminals, before any input
     break in your program.  Otherwise you may get half-finished
     pictures on some TTY:s.  Note that the procedure "outimage"
     built into the VISTA package should be used.

     Output to other TTY:s is no problem.

     Input from other TTY:s through the VISTA package causes some
     problems.  The echo parameter must be TRUE when creating VISTA
     objects, and insinglechar cannot be used.

     VISTA can be combined with the REALTIME package to allow
     simultaneous dialouge on more than one terminal.


5. PREAMBLE FOR PROGRAMS USING THE VISTA PACKAGE

     The following example of a very short complete program using
     the VISTA package shows what you have to do:

     BEGIN
       EXTERNAL CHARACTER PROCEDURE getch, fetchar;
       EXTERNAL PROCEDURE depchar, forceout, outstring;
       EXTERNAL INTEGER PROCEDURE trmop, gettab, checkreal,
       checkint;
       EXTERNAL PROCEDURE echo, abort, outchr;
       EXTERNAL CLASS vista;
       INSPECT NEW vista(78, 19, sysin, sysout, FALSE,
       0, NOTEXT, NOTEXT) DO
       BEGIN
         INTEGER h, v, sign;
         blank_the_screen;
         FOR sign:= rank('A') STEP 1 UNTIL rank('Z') DO
         FOR h:= 1 STEP 1 UNTIL 10 DO
         FOR v:= 1 STEP 1 UNTIL 10 DO
         set_char_on_screen(char(sign),h,v);
         breakoutimage;
       END;
     END;

     The parameters in the "NEW vista" statement are:

   > Width of the screen.  Subtract 1 or 2 from the real width.

   > Height of the screen.  Subtract 1 from the real height.

   > Sysin = the infile connected to the terminal.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 14
5. PREAMBLE FOR PROGRAMS USING THE VISTA PACKAGE


   > Sysout = the outfile connected to the terminal.  (The package
     will probably only work if sysout is the controlling
     terminal.)

   > TRUE if you want automatic echoing of characters by the
     monitor, FALSE if you want echoing by the VISTA package.
     FALSE is usually safer.  If you only use the VISTA package for
     output to the terminal, not for input from the terminal, then
     TRUE has certain advantages.  TRUE may give special problems
     on TANDBERG terminals, see the description of the procedure
     "echon" above.

   > The next parameter indicates terminal type.
     IMPORTANT:  If you want the same program to be runnable on
     different kinds of terminal, then you should either ask the
     user for a value for this parameter, or (usually easiest) let
     this parameter be 0, so that the VISTA package will ask the
     user for his terminal make.

     If this parameter is 0, the user at the terminal will be asked
     what kind of terminal he is using.  The other valid values for
     this parameter are 1 for INFOTON VISTA terminals, 2 for DEC
     VT52 terminals, 3 for Minitec terminals, 4 for ELITE 2500 with
     auto-lf, 5 for ELITE 2500 without auto-lf, 6 for ELITE 1520
     with auto-lf, 7 for ELITE 1520 without auto-lf, and a large
     value for your own special kind of terminal.  If you are
     buying a DATAMEDIA ELITE terminal, the version witout auto-lf
     is much better the VISTA package.) The parameter can also have
     the same negative values to enable Direct Cursor Addressing.

     DIRECT CURSOR ADDRESSING:

     NOTE:  The version of the VISTA package on November 11, 1976,
     can only handle direct cursor adressing on DEC VT52 terminals.

     Some terminals (e.g.  DEC VT52) allow the program to move the
     cursor directly to certain screen positions.  This is
     triggered by negative value on the terminal type number.
     Advantage:  A little faster and safer access to screen
     positions.  Disadvantage:  Does not work on some installations
     where special character conversion is done.  (The program is
     however able to cope correctly with the TTY QZ character
     conversion at the QZ computer centre in Stockholm.  However,
     with TTY QZ, your programs will be much faster if you are NOT
     using direct cursor adressing.)

     YOUR OWN SPECIAL KIND OF TERMINAL

     You can use the last two parameters to the VISTA package to
     specify the characteristics of another terminal than those
     which the package already knows about.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 15
5. PREAMBLE FOR PROGRAMS USING THE VISTA PACKAGE


     Necessary is that there are keys on your terminal to move the
     cursor down, up, right, left, to home the cursor(move it to
     the upper left corner of the screen, and to erase the screen).
     Pushing these keys should transmit to the computer either a
     single ASCII character or an altmode(escape) character
     followed by a single ASCII character.

     (On some terminals these special keys can be simulated using
     other keys, often in combination with the CONTROL key.)

   > The next to last parameters to the CLASS VISTA should in this
     case contain the name of your kind of terminal.

   > And the last character should contain a text with the
     character codes to move the cursor down, up, right, left, home
     and to erase the screen (in that order, no blanks between
     them).

     You can get the program to use your special kind of terminal
     in two ways.  Either let the third to last parameter to VISTA
     be 0, and the computer will ask the user at his terminal what
     kind of terminal he has.  Or let the third to last parameter
     to VISTA have a large value, and the computer will assume that
     the terminal is always of your special kind.

     All the source programs of the VISTA package are at the QZ
     data center available on the H97T86 and H40I48 DEC tape.
     VISTA.ATR, VISTA.REL, FORM.ATR and FORM.REL will at the QZ
     data center be available in LIBSIM on either SYS: or
     [106,346].


6. SWITCHING BETWEEN SEVERAL SCREEN CONTENTS

     It is easy with the VISTA package to have several pictures,
     and switch between them.  You just allocate one object of the
     CLASS vista for each picture.  You can then have a reference
     variable referring to each picture.  Suppose that you have

          REF (vista) first_picture, second_picture;

     You can then switch from displaying the first to displaying
     the second picture on the screen by simply executing the
     statements:

          first_picture.cancel_display;
          second_picture.resume_display;

     Note:  More than one picture may never be active at the same
     time.  Therefore always cancel the previous picture before
     resuming the next.  VISTA objects just generated with NEW are
     always active, and if you do not want them active you should
     cancel them before generating the next picture.

     It is however legal to have no picture active.  This is what
     you do if you want to talk to the terminal without using the
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 16
6. SWITCHING BETWEEN SEVERAL SCREEN CONTENTS


     It is legal to use all the procedures in the VISTA package
     except the input procedures even on a cancelled picture.  The
     VISTA output procedures on a cancelled picture will then
     change an internal copy of the terminal screen, and this
     internal copy will be shown to the user again when the program
     calls the procedure "resume_display" on that picture.

     Example of a complete, executable program using two pictures
     to switch between:

     BEGIN
       EXTERNAL CHARACTER PROCEDURE getch, fetchar;
       EXTERNAL PROCEDURE depchar, forceout, outstring;
       EXTERNAL INTEGER PROCEDURE trmop, gettab, checkreal,
       checkint;
       EXTERNAL PROCEDURE echo, abort, outchr;
       EXTERNAL CLASS vista;
       REF (vista) first_picture, second_picture;
       INTEGER h, v, sign, casedifference;
       casedifference:= rank('a') - rank('A');
       second_picture:- NEW vista
       (78, 19, sysin, sysout, FALSE, 0, NOTEXT, NOTEXT);
       second_picture.cancel_display;
       first_picture:- NEW vista
       (78, 19, sysin, sysout, FALSE, 0, NOTEXT, NOTEXT);
       first_picture.blank_the_screen;
       second_picture.blank_the_screen;
       FOR sign:= rank('A') STEP 1 UNTIL rank('Z') DO
       BEGIN
         IF mod(sign,3) = 0 THEN
         BEGIN
           IF mod(sign,2) = 0 THEN
           BEGIN
             second_picture.cancel_display;
             first_picture.resume_display;
           END ELSE
           BEGIN
             first_picture.cancel_display;
             second_picture.resume_display;
           END;
         END;
         FOR h:= 1 STEP 1 UNTIL 10 DO
         FOR v:= 1 STEP 1 UNTIL 10 DO
         BEGIN
           first_picture.set_char_on_screen
           (char(sign),h,v);
           second_picture.set_char_on_screen
           (char(sign+casedifference),h+20,v);
         END;
       END;
       first_picture.outimage;
       second_picture.outimage;
     END;
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 17
7. CAT, SHIP AND VIDED - EXAMPLES OF USE OF THE VISTA PACKAGE


7. CAT, SHIP AND VIDED - EXAMPLES OF USE OF THE VISTA PACKAGE

     CAT, SHIP and VIDED are three demonstration examples to
     illustrate how the VISTA package can be used.

     CAT is a program in which a cat tries to catch a number of
     rats in a square cage.  The cage and the two animals are shown
     in a map of the cage on the terminal screen, where the user
     can see how they move about the cage.  The user at the
     terminal can guide the movement of the cat with four keys for
     up, down, left and right.  (On certain terminal without these
     keys, they can be simulated with combinations of other keys.)
     The program makes the rat more intelligent if the terminal
     user catches many rats.  A score of escaped and caught rats is
     caught on the screen.

     SHIP is a simplified simulation program.  A number of ships
     try to move soldiers from one side of a lake to the other
     side.  A number of destroyers hunt the ships.  The user can
     see at the terminal how the ships move across the lake, how
     the destroyers move, how troups accumulate on the other side
     of the lake, how ships and destroyers fight.  A portion of the
     screen shows the number of ships in various states:  Loading,
     unloading, moving, killed etc.

     VIDED is a very simple text editor for display terminals.  The
     screen will always show exactly the contents of the text you
     are editing.

     NOTE:  VIDED works at present (November 5, 1976) only on
     INFOTON VISTA terminals).

     CAT, SHIP and VIDED are at the QZ computing center available
     on [106,346] and if you have a VISTA terminal, you can run the
     programs by the command

     .RUN CAT[106,346] or

     .RUN SHIP[106,346] or

     .RUN VIDED[106,346]

     The source programs CAT.SIM and SHIP.SIM are at the QZ
     computing center available on DEC-tape H40I48.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 18


8. FORM - A SUBPACKAGE FOR FORM-FILL-IN DATA ENTRY

     FORM is a subclass to VISTA to allow the writing of programs in
     which the terminal screen is made to look like a form with
     various empty fields.  The terminal user then inputs data by
     filling in the fields of the form.

     You define your form by generating an object of the CLASS FIELD
     for each field in the form.  For each field you indicate its
     position on the screen and the header in front of the input
     part of the field.  The order in which you generate the NEW
     FIELD objects is important.  They must be generated according
     to their position on the screen, left to right, top to bottom.

     You can also use any of the VISTA procedures on parts of the
     screen where you are not using the FORM package, e.g. you can
     use OUTTEXT to print a header on top of the form.

     When you have generated all the objects, you can call the
     procedure SHOW_PAGE which will display all the headers on the
     screen.  You can then call the procedure ASK_PAGE which will
     ask the terminal user input for each field in the form.

     If you want to allow the user a chance to change his form
     entries after completing the answer, you can write
     "RESUME(FIRST_FIELD);"

     If you want to put in extra data collection, reliability test
     etc. then you define subclasses to the class field.

     Four such useful subclasses are already available in the FORM
     package.  They are INTFIELD, REALFIELD, CHOICEFIELD, ALPHA-
     FIELD.  INTFIELD is for collecting integer input, REALFIELD for
     collection floating point input, CHOICEFIELD for inputting data
     which can only have a limited set of values, ALPHAFIELD for
     inputting alphabetic data.


CLASS field(h, v, header, length, stopchar, helptext);
     VALUE header;
     INTEGER h, v, length;  CHARACTER stopchar;  TEXT header;
     COMMENT H and V are the horizontal and vertical position on the
     screen for this field.  HEADER is the text to be displayed on
     the screen in front of the field.
     LENGTH is the maximum length of the accepted input text for
     this field, and STOPCHAR is a character which ends a message.
     By making STOPCHAR into CHAR(0), only terminal control
     characters or exceeded length can end a message.  By making
     STOPCHAR into ' ', a message is automatically ended with the
     first blank preceded by non-blanks.
     Helptext is a help message of maximum one line, which is
     displayed to the user if he types a questionmark (?) on his
     terminal.
     BEGIN TEXT answer; COMMENT what the user inputs comes here;
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 19
8. FORM - A SUBPACKAGE FOR FORM-FILL-IN DATA ENTRY


     PROCEDURE change_answer(new_answer);
          VALUE new_answer;  TEXT new_answer;
          COMMENT will change both the internal and
          screen-displayed answer.  Can be used for automatic
          correction of input values.


     PROCEDURE error(errmess);
          VALUE errmess;  TEXT errmess;
          COMMENT will write a blinking error message on line 18 of
          the screen;

     END of field;


field CLASS int_field(min, max, rangerror);
     VALUE rangeerror;
     INTEGER min, max;  TEXT rangeerror;
     COMMENT if the data input by the user is not an integer, then
     he is given an error message.  If the data is not between min
     and max, then the error message RANGERROR is given to him.
     BEGIN INTEGER intvalue;
     COMMENT INTVALUE will contain the data input by the user;
     END of intfield;


field CLASS realfield(min,max,rangerror);
     VALUE rangerror;
     REAL min, max;  TEXT rangerror;
     COMMENT same as INTFIELD for floating point input;
     BEGIN REAL realvalue;
     COMMENT realvalue will contain the data input by the user;
     END of realfield;


field CLASS choicefield(nonemessage);
     VALUE nonemessage;  TEXT nonemessage;
     COMMENT Will allow the user to chose between a limited number
     of alternatives;
     BEGIN
     CLASS choice(choicetext);
     VALUE choicetext;  TEXT choicetext;
     COMMENT you must yourself generate an object of the class
     choice for each alternative, e.g. "NEW choice("first
     alternative");  NEW choice("Second alternative");" etc.
     END of choicefield;
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 20
8. FORM - A SUBPACKAGE FOR FORM-FILL-IN DATA ENTRY


field CLASS alphafield;  COMMENT will only accept input containing
     nothing but letters and blanks;


PROCEDURE show_page;
     COMMENT All answers in all the fields will be erased and the
     form will be displayed on the terminal;


PROCEDURE ask_page;
     COMMENT the terminal user is asked to fill in the form on his
     terminal;


PROCEDURE stopasking;
     COMMENT this procedure causes the procedure ASK_PAGE to return
     from where it was called.  Can be used if you under certain
     conditions wish to allow partly filled-in forms;


     A complete example of a simple program using the FORM package:

     OPTIONS(/l);
     BEGIN
       EXTERNAL TEXT PROCEDURE frontstrip, upcase;
       EXTERNAL CHARACTER PROCEDURE getch, fetchar;
       EXTERNAL PROCEDURE depchar, forceout, outstring;
       EXTERNAL INTEGER PROCEDURE trmop, gettab, checkreal,
       checkint;
       EXTERNAL PROCEDURE echo, abort, outchr;
       EXTERNAL CLASS vista;
       EXTERNAL CLASS form;
       form(79,19,sysin,sysout,FALSE,0,NOTEXT,NOTEXT) BEGIN
         REF (field) givenname, surname, nationality,
         birthyear, eyes;
         REF (intfield) height;
         givenname:- NEW alphafield(0,6,"given names:",60,char(0),"");
         surname:- NEW alphafield(0,8,"surname:",22,char(0),"");
         nationality:- NEW alphafield(35,8,
         "nationality:",10,' ',"");
         birthyear:- NEW intfield(0,10,"birthyear:",20,' ',"",1800,
         1975, "Birthyear should be between 1800 and 1975.");
         INSPECT NEW choicefield(35,10,"eyecolour:",10,' ',"",
         "Accepted eyecolours: brown, blue and grey.") DO
         BEGIN
           eyes:- THIS choicefield;
           NEW choice("brown"); NEW choice("blue");
           NEW choice("grey");
         END;
         blank_the_screen;
         outtext("INPUT OF PERSONAL DATA:");
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 21
8. FORM - A SUBPACKAGE FOR FORM-FILL-IN DATA ENTRY


         outimage;
         show_page;
         ask_page;
       END;
     END;


WRITING YOUR OWN SUBCLASSES TO FIELD:

     If you want to do your own validity checking of data input
     from the user, or your own automatic correction of data input
     from the user, then you write your own subclasses to FIELD.
     Include in the body of the subclass the error corrections you
     want.  If you want to display an error message to the user,
     then call the procedure "ERROR".  If you want to change the
     data input from the user, then call the procedure
     "CHANGE_ANSWER".

     By writing your own version of the virtual procedure HELP in
     the class FIELD, you can determine yourself what shall happen
     when the user inputs a questionmark (?) on his terminal.


Example of how you can write your own subclass to field:

     intfield CLASS evenmod10;
     COMMENT will give errors for odd numbers and
     take any input number modulo 10;
     BEGIN
       IF mod(intvalue,
       2) NE 0 THEN error("Odd number illegal.");
       answer.setpos(1);
       answer.putint(mod(intvalue,2),1);
       change_answer(answer.sub(1,1));
     END;

     FORM is available at the QZ computing center on DEC-tape
     H97T86 in the packed file "FORM.PAK".  Unpac with

     .R UFLIP
     **.*/E=FORM.PAK
     ^C
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 22


9. FORMT AND TABLE - EXAMPLES OF USE OF THE FORM PACKAGE

     FORMT and TABLE are two simple demonstration programs.  FORMT
     shows the use of FORM for input of a simple form from a
     terminal.  TABLE shows how a table of values can be input from
     a terminal in a similar manner.

     FORMT.SAV and TABLE.SAV are available for running at the QZ
     computing center on [106,346] and you can test it by writing

     .RUN FORMT[106,346] or

     .RUN TABLE[106,346]

     FORMT.SIM and TABLE.SIM are available at the QZ computing
     center on DEC-tape H97T86 in the packed file FORM.PAC.  Unpac
     with:
     .R UFLIP
     **.*/E=FORM.PAK


10. DEBUGGING PROGRAMS USING THE VISTA PACKAGE

     VISTA programs are difficult to debug for two reasons:

   > DEBUG output will destroy the picture on the screen.

   > VISTA usually stops echoing characters from the terminal,
     which means that characters input to SIMDDT will not be
     echoed.

     Here are some ways to overcome these problems:

     You can direct the debugging output to another device than the
     terminal, for example to another terminal or to a disk file.

     A good way to DEBUG programs using the VISTA package is to use
     the controlling terminal for SIMDDT and a second terminal for
     the VISTA package.  Add the following code to your program:
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 23
10. DEBUGGING PROGRAMS USING THE VISTA PACKAGE


       REF (infile) newsysin;
       REF (printfile) newsysout);
       IF debug THEN
       BEGIN
         newsysin:- NEW infile("sysin *");
         newsysout:- NEW printfile("sysout *");
         newsysin.open(blanks(80));
         newsysout.open(blanks(80));
       END ELSE
       BEGIN
         newsysin:- sysin; newsysout:- sysout;
       END;
       INSPECT NEW vista(width,maxheight,
       newsysin,newsysout,
       NOT debug,terminaltype,NOTEXT,NOTEXT) DO

     After a debugging session, you can restore the screen by
     calling the procedure restore_the_whole_screen.  There are two
     ways to get the VISTA package to call this procedure.  One way
     is to write the SIMDDT statement "INPUT BADSCREEN:= TRUE".
     The next time a call is made on the procedure
     "MOVE_THE_CURSOR_TO" the screen will be restored.

     Another way is push the ALTMODE(ESCAPE) or FORMFEED (=^L)
     character on your terminal, the next time when your program
     tries to make input from the terminal using the input
     procedures within VISTA.  This will also cause the screen to
     be restored.  (On VT52 terminals, ALTMODE must be pushed
     twice.)

     The problem that SIMDDT does not echo its input can be
     overcome by changing the switch on your terminal to local
     echo.  Do not forget to set it back to no local echo before
     typing the SIMDDT "PROCEED" command.

     Another way to know what you have typed to SIMDDT is to push
     the CTRL-R combination on your terminal.

     COMMON CAUSES OF ERROR:

     The most common cause of bad picture on the screen is that
     your program tries to make some kind of input from or output
     to the terminal screen without using the input and output
     procedures which are part of the VISTA package.  Your program
     may for example contain statements like "INSPECT SYSOUT DO" or
     "SYSOUT.SETPOS(0)" or "SYSOUT.OUTIMAGE".

     Another common trouble is that you are accepting input from
     the user on the last line of the screen.  This may in certain
     cases cause the picture on the terminal screen to roll.

     If you are using a DEC VT52 terminal, then a common cause of
     error is that the monitor is doing some kind of character
     conversion when transferring characters from the your program
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 24
10. DEBUGGING PROGRAMS USING THE VISTA PACKAGE


     to the terminal.  Since ordinary characters are used as screen
     addresses, this will cause screen addressing to go wild.
     Example:  At the QZ computing center in Stockholm, the .TTY QZ
     setting will cause this kind of problem, but the VISTA package
     has been modified to handle the TTY QZ problem by TRMOP-ing
     away the conversion before direct cursor addressing is done.

     If you have this problem, use positive terminal numbers to
     disable direct cursor addressing or modify the VISTA program
     package in a way similar to the modification to cope with the
     TTY QZ problem which is already done in the program.

     11. MODIFYING THE VISTA PACKAGE FOR A NEW KIND OF TERMINAL

     The simplest way to make the VISTA package usable on a new
     kind of terminal is either

   > let the terminal type number in the NEW VISTA statement be 0,
     and let the user at his terminal input his terminal
     specifications, or

   > use the two last parameters in the NEW VISTA statement to give
     the terminal characteristics.  The next two last parameter
     should include a text with the name of the terminal.  The last
     parameter should include a text containing in sequence the
     character codes to move the cursor down, up, right, left, home
     and to erase (clear) the screen of the terminal.


     If, however, you want to change the VISTA source program to
     permanently include a new terminal, then read the following
     text.  This may be necessary to get VISTA working on certain
     terminals, and this is also the only way to be able to handle
     blinking text on new kinds of terminals.


     The VISTA package will not work on terminals on which there are
     no character codes to be sent from the computer to the terminal
     to move the cursor down, up, right, left, to home the
     cursor(move it to the upper or lower left corner of the screen)
     and to erase (clear) the screen (either the whole screen or the
     part of the screen following the cursor position will do, since
     the VISTA package always outputs the home character before the
     erasescreen character.)


     You should adjust the following sections of the source code in
     the SIMULA source code of the VISTA package:
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 25
11. MODIFYING THE VISTA PACKAGE FOR A NEW KIND OF TERMINAL


     In the NOT HIDDEN PROTECTED and INTEGER declarations of the
     variables "infoton, vt52, minitec, elite, kthelite, newelite,
     kthnewelite" in the preamble of the source code, add an
     INTEGER for your new kind of terminal.


     In the "PROCEDURE start_blink" you should adjust depending on
     how your terminal works.  INFOTON VISTA has a special
     character on the screen, and everything after this character
     is blinking upto a stopblink character on the screen.  Most
     other terminalsi (e.g.  MINITEC) have a special character sent
     from the computer before outputting blinking text and before
     outputting steady text again.  Follow the example in the code
     for these terminals.


     In the "PROCEDURE stop_blink", corresponding change to the
     change in "start_blink".


     In the "PROCEDURE move_the_cursor_to", insert special code for
     Direct Cursor Adressing if your terminal has this feature.
     Follow the examples of previously known terminals.


     Find the place in the source program with "maxterminals:=" and
     increase this figure (one more than number of known terminal
     types) by the number of new terminal kinds you want to add.
     Immediately afterwards, the INTEGER variables infoton, vt52,
     minitec, elite, kthelite, newelite, kthnewelite are given
     initial distinct values.  Assign new distinct values to your
     new kind of terminal.


     IF your terminal cannot handle ".TTY FILL 0", then change this
     "trmop" to the acceptable setting.  Warning:  Only .TTY FILL 0
     will work on terminals with a built-in "auto-lf" function for
     carriage returns from the computer.


     In the menu "1 = INFOTON" ...  "7 = ELITE 1520 WITHOUT
     AUTO-LF", add your new terminals.


     In the special code to initialize variables for different
     kinds of terminals (beginning with the text
     "COMMENT Infoton Vista Standard") initialize the variables
     down, up, right, left, home and erasescreen to the
     corresponding character codes on your terminal.  If any of
     these six character codes must be preceded by
     "altmodei=escape", then set the Boolean variable "addaltmode"
     to TRUE.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 26
11. MODIFYING THE VISTA PACKAGE FOR A NEW KIND OF TERMINAL


     Also initialize the variables startblink and stopblink if
     there are such character codes on your terminal.


     If your terminals has a built-in "auto-lf" function (that is
     that every carriage return from the computer causes an
     implicit line feed to be generated in the terminal, then you
     will have to set the Boolean variable "allow_cr" to FALSE.
     Otherwise, make this variable TRUE, since this gives much
     faster execution and less i/o.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 27
Appendix A: NEW FEATURES IN VISTA RELEASE 1976-11-05.

MINIMAL NECESSARY CHANGES TO GET OLD PROGRAM WORKING WITH THE NEW
     PACKAGE

  1) Change "EXTERNAL INTEGER PROCEDURE trmop" into "EXTERNAL INTEGER
     PROCEDURE trmop, gettab" in the preamble of your program.  Also
     change "EXTERNAL CHARACTER PROCEDURE getch" into "EXTERNAL CHAR-
     ACTER PROCEDURE getch, fetchar" and add "EXTERNAL PROCEDURE
     depchar, forceout, outstring;".

  2) There are two new TEXT parameters to the CLASS VISTA.  Thus, for
     every "NEW VISTA" or "NEW FORM" statement in your program, you
     must add ",NOTEXT,NOTEXT" immediately in front of the ")".

     If you have written your own subclasses to the classes VISTA or
     FORM, corresponding changes must be made in NEW statements
     generating your subclasses.

  3) Only for users of the class FORM:  There is one new TEXT
     parameter to the class FIELD (and its subclasses).  The new
     parameter can be given the value NOTEXT in "NEW field", "NEW
     alphafield" etc.  statements in your program.

  4) All program modules using the VISTA package must be recompiled.

NEW FEATURES IN THE VISTA PACKAGE

  1) The package is much more independent of terminal make.  It works
     on INFOTON VISTA, DEC VT52, MINITEC and DATAMEDIA ELITE 2500 and
     1520 terminals.  It will also work on many other kinds of display
     terminals, since the program can query the user about his
     terminal characteristics.  With the pushing of just 7 keys on the
     terminal, the user can tell the program how his terminal works,
     and the program can then work on almost any terminal having
     special functions for moving the cursor around the screen.

  2) The two new text parameters to the class VISTA can be used by a
     user programmer to describe the characteristics of his special
     kind of display terminal.

  3) The new parameter to objects of the class FIELD in the FORM
     package is a help text, which is displayed automatically to the
     user when he types in a questionmark on his terminal.  By writing
     your own version of the virtual procedure HELP in the FIELD
     class, you can handle help texts longer than one line or other
     special help facilities.

  4) To get machine-independent handling of blinking text on the
     screen, two new procedures start_blink and stop_blink have been
     added.  Always use these procedures to create blinking text.  See
     the manual for further explanations.  Whenever you call
     start_blink, the bell will also be sounded on terminals which
     have a bell function.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 28
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED

Swedish National Defense Research Institute        FOA Rapport
S-104 50 Stockholm 80                              C 10075-M3(E5, H9)
Sweden                                             September 1977


                                       (1)
HOW I FOUGHT WITH HARDWARE AND SOFTWARE    AND SUCCEEDED

By Jacob Palme


(1) DEC, INFOTON, TEC, TANDBERG, CDC, DATAMEDIA, BEEHIVE, SIMULA


ABSTRACT:

     This is the story of the development of a utility program to
     simplify the writing of programs using alphanumeric display
     terminals.

     The basic program is very simple, and most of the programming
     time was not spent on this, but in a cloak-and-dagger game with
     other hardware and software products involved, trying to induce
     or cheat these products into doing what was needed, and not
     perform various unwanted and disruptive "niceties".


SEARCH KEY:

     Computer, Program, Computer program, Programming, Computer
     Programming, Software, Software development, Software
     engineering, Terminal, Computer terminal, Conversational
     terminal, Display terminal, CRT terminal, Alpha-numeric
     terminal, Cursor control, Man-Computer interaction.


SWEDISH ABSTRACT:

     Detta {r historien om programmeringen av ett hj{lpprogram f`r
     att underl{tta skrivandet av program som anv{nder sig av
     textsk{rmsterminaler.

     Det grundl{ggande programmet {r mycket enkelt, och huvuddelen
     av programmeringsarbetet {gnades inte }t det, utan }t en
     gerillakamp med annan maskinvara och programvara som var
     inblandad, f`r att f`rm} eller lura dessa produkter att g`ra
     vad som beh`vdes, och inte utf`ra skilda icke `nskade och
     skadliga "v{nligheter".
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 29
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


0. TABLE OF CONTENTS.

     1.  WHAT IS THIS?
     2.  HOW IT ALL STARTED.
     3.  MYSTERY: SUDDEN UNEXPECTED CURSOR MOVEMENTS.
     4.  MYSTERY: SUDDEN SMALL SHIFTS IN THE PICTURE.
     5.  INPUTTING OF CONTROL CODES FROM THE TERMINAL.
     6.  TRYING OTHER TERMINAL MODELS.
     7.  BLINKING TEXT AND BELL FUNCTION.
     8.  THE HORIZONTAL TAB CHARACTER CODE.
     9.  AUTO LINE FEED FEATURE.
     10. BLOCK MODE TERMINALS.
     11. DIRECT CURSOR ADRESSING.
     12. THE TYPE AHEAD PROBLEM.
     13. PROGRAM OPTIMIZATION.
     14. CONCLUSION.
     15. BIBLIOGRAPHY.


1. WHAT IS THIS?

     This report is the story of the development of a computer
     program. The goal is not to tell you about technical details of
     the program or application. Rather, the goal is to tell you
     about the problems I met, and how I overcame them. Central to
     these problems were the interface between my program and
     hardware and software modules produced by various
     manufacturers.

     This is not a paper about the beautifully logical development
     of a program through perfect applications of structured
     programming techniques. But it is a true story. I made many
     mistakes through ignorance, and I intend to admit them candidly
     in this report.

     My hope is that many programmers will recognize that they have
     met similar problems. This recognition may help to give a
     better understanding of the role of existing hardware and
     software in program development.

     This report will name the manufacturers and software and
     hardware products involved. Problems associated with them will
     be mentioned. This should  n o t  be construed as meaning that
     these named manufacturers and products are especially bad. My
     experience is the opposite, that the named products are very
     good compared to some other similar products. The fact that I
     tested them indicates that they were common in my work
     environment.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 30
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


2. HOW IT ALL STARTED.

     In 1973, we got our DECsystem-10 computer together with a
     number of Infoton VISTA alphanumeric display screens. These
     screens had 20 lines of 80 characters per line.

     The terminal has a so-called "cursor", which indicates the
     position on the screen where forthcoming text will be placed.
     The terminal can receive control codes from the computer to
     move the cursor around the screen. When new text is inserted at
     the cursor position, previous text at that position will be
     erased.

     On the Infoton VISTA, the cursor can be moved through controls
     to move it up one line, down one line, left one character and
     right one character. There are also codes to move the cursor to
     the upper left corner of the screen (the "home" position on
     most terminals) with or without simultaneous blanking of the
     screen.

     This terminal is typical of many other terminals, with small
     technical differences. (See further Palme 1977B.)

     By moving the cursor around the screen, erasing and replacing
     existing portions of the screen, many nice applications are
     possible. You can have a table on the screen, where the user
     and the computer can continously update entries in the table.
     You can create a "moving picture" on the screen etc. This is
     further described in Palme 1977A.

     To simplify the writing of various application programs using
     this technique, a useful utility package would take commands
     from the application program to move the cursor to given
     positions on the screen, input or output data at that place
     etc. I began to write such a utility package.

     The basic principle of such a package is very simple. To move
     the cursor to a given position, the program generates the
     proper number of up, down, left, right or home codes to get
     there. The program need not be very long or complex.


3. MYSTERY: SUDDEN UNEXPECTED CURSOR MOVEMENTS.

     My first problem was that the cursor suddenly moved to the
     beginning of the next line on the screen. This happened now and
     then in the middle of the execution, with disastrous results to
     the screen picture.

     I simply could not understand why the cursor moved in this way.
     But after some time I found the cause. The DECsystem-10
     operating system has a built-in facility to protect users from
     outputting too long lines. Thus, the operating system keeps a
     count of on which horizontal position it believes the writing
     position to be. When this count becomes larger than the line
     length of the terminal, the operating system outputs a carriage
     return and a line feed to the terminal.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 31
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     Thus, the operating system just tries to be nice to you. It
     tries to help you out of trouble, if your program by mistake
     outputs too long lines. But of course the operating system does
     not know about the cursor controls on display terminals. So its
     cursor position count will be wrong, and the carriage return-
     line feed produced by it will occur at unpredictable times
     destroying the picture.

     My solution to this problem was simple, but not very neat. I
     counted the number of characters being output to the terminal.
     Before this count exceeded 80, I output a carriage return
     myself, and then moved the cursor back again to where my
     program knew it to be.

     In this way I cheated the operating system into believing that
     the cursor never was more than 80 characters from the beginning
     of a line.

     When I had written and tested the code for this solution,
     someone told me "Why don't you just make a TTY NO CRLF". TTY NO
     CRLF is a command which can be given from a user or program to
     switch off the monitor facility which caused my trouble. A
     simple addition of a monitor call to the program, and all the
     newly written code for my ingenious solution could be removed
     from my program!


4. MYSTERY: SUDDEN SMALL SHIFTS IN THE PICTURE.

     My next problem was that suddenly, now and then, the text I
     output was shifted just a little on the screen, one or two
     screen positions, but enough to cause double images, ghost
     pictures and other problems.

     After some time I found the solution. The SIMULA procedures for
     outputting text, "outimage" and "breakoutimage" were programmed
     in such a way that blanks at the end of output lines were never
     output. The SIMULA system thus omitted blanks when these
     happended to be at the end of what SIMULA believed to be output
     lines. (In fact, my applications were based on the idea of not
     outputting whole lines of text at a time. But the SIMULA system
     did not know this.)

     Another case, where a software product, in this case SIMULA,
     tried to be nice to me, with disastrous results.

     I solved the problem, again by cheating the system I was using.
     Before outputting a line, the program always checked if the
     last position to be written was a blank. If so, the program
     changed the output so that the last character to be output was
     a "NULL" character code (this is ignored by the terminal).
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 32
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     Sometime later, other users complained of the same problem, and
     the definition of the "breakoutimage" procedure in SIMULA was
     changed so that the program could indicate if ending blanks
     were to be output (with the "image.pos" setting). This was a
     much neater solution, and again I could remove some code which
     I had inserted to cheat the system. How happy I felt when, for
     the second time, I removed code which I had spent a lot of time
     inventing.


5. INPUTTING OF CONTROL CODES FROM THE TERMINAL.

     All 128 codes in the ISO-ASCII character set are not printable.
     Therefore, when you push a terminal key which causes the
     terminal to send a non-printable code, this cannot be directly
     printed on the terminal. However, the DECsystem-10 operating
     system again tries to be nice to you. To enable you to see
     these characters, the operating system outputs the character "^"
     followed by another character, so that you can see on your
     screen what has been input. For example, the character with
     numerical value 1 is output as ^A, 2 as ^B etc.

     Exceptions from this are the control codes "carriage return",
     "line feed" and "form feed". But the special terminal control
     codes, such as "up" or "home" are not known to the monitor.

     A similar problem was caused by the DELETE (RUB OUT) and NAK
     (Control-U) characters. To help people correct small typing
     errors, the monitor interpreted these as to take back the last
     character (DELETE) or the last line (NAK). These were thus
     never transmitted to my program, so the program did not know
     that the cursor was not where it believed it to be.

     My first crude solution to this problem was to reserve certain
     lines in the application programs for input from the terminal,
     and to always synchronize the cursor after terminal input. (By
     synchronizing the cursor I mean ensuring that the cursor is
     where the program believes it to be. This is done by moving the
     cursor first to the home position, and then to the desired
     position. On some terminals, direct-cursor-addressing can be
     used instead.)

     However, I was now aware that many times, when the monitor
     caused trouble by being too "nice", the niceties could be
     switched off through various monitor switches. So I went
     through the list of terminal control monitor switches to see if
     there was one I could use. All these switches are set by the
     TRMOP supervisory call, I believed. So I looked through the
     list of options to the TRMOP supervisory call.

     There was one switch which looked nice. TTY NO ECHO it was
     called. Just my problem - switch off echoing of characters.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 33
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     Happily, I tried TTY NO ECHO. It nicely suppressed monitor
     echoing of all printable characters. But - the echoing of
     non-printable characters, which I wanted to suppress, was not
     suppressed.

     The complete information on all the options in the operating
     system can be found in the "DECsystem-10 Software Notebook",
     consisting of eleven very thick volumes and costing about a
     thousand dollars a year to keep.

     Sometime later, I learned that there was an obscure table in
     quite another part of the notebook, indicating a different
     setting, which did just what I wanted. It could either cause
     all input characters to be echoed unchanged by the monitor,
     without any "nice" modifications, or it could suppress all
     echoing even of non-printable characters, so that my program
     could do the echoing instead.

     Why this setting was not part of the TRMOP supervisory call,
     which handles other switches controlling terminal handling, is
     a mystery to me.


6. TRYING OTHER TERMINAL MODELS.

     Now came the time when I wanted to run my programs on terminals
     of other makes than the INFOTON VISTA terminal. I happily ran
     my programs, and a curious mixture of jumbled characters
     appeared on the screen.

     Apparently, the control codes to move the cursor up, down,
     left, right and to the home position, and to erase the screen,
     are not standardized. I found out that even two different
     models from the same manufacturer often have different control
     codes! (This is true for example for some DEC, TEC and ELITE
     terminals.)

     This means that every program must be different for each
     terminal model. A way to alleviate this problem would be if all
     terminal differences could be collected into my utility
     package, so that no modifications would be necessary in the
     application packages.

     I have tried to achieve this goal, but the terminal differences
     are so cleverly devious that I have not always succeded. As
     one of many examples of curious terminal behaviour, the line
     feed character on the TANDBERG TDV 2000 terminal blanks the
     rest of the next line on the screen.

     There are other subtle differences between terminal types. For
     example, what should happen if you send an "up" character on
     the first line of the screen, a "down" character on the last
     line, a "left" character at the beginning of a line or a
     "right" or any printable character at the end of a line.

     Some terminals do nothing in these cases, other terminals "wrap
     around" to the other end of the screen.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 34
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     On some terminals, the control codes to move the cursor are
     one-character codes. On other terminals, they are two character
     codes, first the ESCAPE character, and then a second character.
     (The latter practice is more in accordance with the standard
     for those controls which do not have single character
     representations in the standard.)

     This is mostly a problem when inputting these codes from the
     terminal. To get the application programs totally independent
     of terminal type, these programs cannot themselves check if the
     input character was e.g. an "up". This checking must be done
     indirectly through the utility package, which requires a change
     in all existing application programs. (And you know how happy
     application programmers are when changes in utility packages
     they use force them to change their application programs. I
     have not yet dared to make this change!) But application
     programs that wish to be terminal independent can achieve this
     by writing the checking code in this way:
     "IF controlchar AND c = up" instead of just "IF c = up".

     To get terminal independence, I invented what I thought was a
     very clever solution. I let the characters go through a
     conversion table, so that only the conversion table need be
     different for different terminal models.

     Later I skipped the conversion table, since I found during
     optimization that direct code was much faster.


7. BLINKING TEXT AND BELL FUNCTION.

     Some terminals allow you to mark special sections on the screen
     by blinking text. Many terminals allow you to send the bell
     character, which causes a beep at the terminal to catch the
     attention of the terminal user.

     Since the purposes of both are similar, and some terminals have
     one of these features, some the other, I made a single "alarm"
     procedure which sent both the bell character and the blink
     control depending on terminal model. In this way most
     application programs will be more terminal independent.

     However, the logic of the blink control was different in a
     devious way. On some terminals, all characters  s e n t  to the
     terminal between "start blink" and "stop blink" are blinking.
     On other terminals, all characters  p o s i t i o n e d
     between "start blink" and "stop blink" on the screen are
     blinking.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 35
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     My package does not yet enforce complete terminal independence
     here. Application programmers who desire terminal independence
     can get it by ensuring that they call "start blink" before each
     element of text to blink, and "stop blink" after each such
     element.


8. THE HORIZONTAL TAB CHARACTER CODE.

     One character code causing much trouble is the HT or
     "horizontal tab" code. On some terminals, this character code
     is ignored. On other terminals, the cursor moves to fixed tab
     positions. On still other terminals, the cursor moves to
     settable tab positions. The worst terminal is MINITEC, where
     the cursor moves to the next settable tab position on the whole
     screen, and scrolls the screen if there is no such position.

     Thus, on MINITEC, I had two possibilities. One was to let my
     program set 240 tab positions all over the screen, the other
     was a monitor switch to control the echoing of the HT character
     code (TTY NO TAB).

     This monitor switch causes the monitor not to send or echo any
     HT characters to the terminal. Unfortunately, the monitor
     instead moves to where it believes the next tab position to be,
     using blanks to get there and thus erasing part of the screen.
     Therefore, after each HT I have to let my program correct the
     wounds which the monitor has caused on the screen.


9. AUTO LINE FEED FEATURE.

     The standardized character set does not include any character
     to do what the RETURN key does on type-writers: move to the
     first position of the next line. The carriage return code only
     moves to the first position of the current line.

     Thus, an extra line feed has to added. Sometimes this line feed
     is added by the computer, sometimes by the terminal, just to
     make things more difficult.

     A connected problem is that some terminals (mostly printing
     terminals) cannot perform carriage return and line feed as fast
     as other functions. The DECsystem-10 operating system solves
     this problem by repeating a received carriage return character
     several times.

     If the terminal adds a line feed to each such extra carriage
     return character, then the screen will begin to scroll because
     of all the line feeds, and the picture is destroyed. Happily,
     there is a supervisory call to set off also this nicety of the
     operating system.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 36
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


     For my application, it is better if the computer does this
     adding of a line feed, since then the action is easier
     controlled by the program than if the addition is done by the
     terminal.


10. BLOCK MODE TERMINALS.

     Some terminals are mainly constructed for block mode
     transmission, where text is edited locally on the terminal and
     then sent as a block to the computer. Some such terminals are
     also marketed for character mode transmission. Beware of such
     terminals. (Example: INFOTON VISTAR II, some models of STANSAAB
     ALFASKOP.)

     On such terminals, cursor control wholly or partially acts only
     locally on the terminal. This is the only problem I have not
     been able to overcome at all. My package cannot be made to work
     on such terminals at all.


11. DIRECT CURSOR ADDRESSING.

     Some terminals have a so-called "direct-cursor-addressing"
     feature. By this is meant that the computer can send a special
     control code, which tells the terminal that the two next
     characters are not to be printed. Instead, the two next
     characters are to be interpreted as horizontal and vertical
     screen adresses, to move the cursor directly to this position.

     This feature has two advantages. The first is that you are
     always sure where your cursor is after this terminal command.
     The second is that fewer codes have to be sent to the terminal.
     The second advantage is only important for lines slower than
     120 characters/second.

     However, the algoritm to decide which character means which
     screen adress is of course different for each terminal model,
     although BEEHIVE B 100 and DEC VT52 by a curious circumstance
     have happended to chance on the same algorithm.

     Another problem with direct cursor addressing is that some of
     the characters used for screen addressing are characters which
     are reserved for national use in the ISO character set. And
     often, these characters are converted in different ways by
     networks and transmission system, causing jumbled screens
     again.

     This is again a case where the systems try to be nice to you -
     helping to convert between different national character sets -
     but instead causing trouble when the characters are used as
     screen addresses.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 37
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


12. THE TYPE AHEAD PROBLEM.

     The DECsystem-10 computer has a nice feature allowing
     "type-ahead". By this is meant that the terminal user can type
     input before the program has asked for it. This allows advanced
     users to save time by typing while the program is doing things
     for them.

     Unfortunately, this nicety again causes problems for my
     program. The problem is that when the user types characters
     ahead, these are not received by my program when they are
     needed. Thus, the program does not know when and where on the
     screen they will appear.

     One solution to this is to let all characters go through my
     program before echoing them to the screen. This solution has
     the disadvantage that echoing will be rather slow, since at
     rush hour time, the program may only get swapped in every five
     seconds or so.

     In the most advanced of my application programs, this problem
     is circumvented by switching back and forward between program
     and monitor echoing of characters. When the package smells
     trouble, it switches to program echoing. When the package
     smells really bad trouble, it has to restore the whole screen.
     In some cases, the program has to skip existing type ahead to
     avoid this problem.


13. PROGRAM OPTIMIZATION.

     Finally, I found that the CPU time for some of the application
     programs which I and other people had written using the utility
     package was rather long. By performance measurement tools the
     critical sections were identified. It was found that the SIMULA
     procedures for terminal input and output were rather slow.

     For example, the output procedure always blanks the text which
     is output. In this way, the text is cleared for the next line
     to be output. Unfortunately, I want to keep a copy of the
     screen in memory, so I do not want the text to be cleared. To
     avoid unnecessary copying, special output procedures in
     assembly language were written. The CPU time was lowered 25% by
     this single change!
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 38
Appendix B: HOW I FOUGHT WITH HARDWARE AND SOFTWARE AND SUCCEEDED


14. CONCLUSION.

     The conclusion to this story might be: Beware of niceties! My
     story can be seen as a series of cases where I banged my head
     into walls put up by hardware and system designers who just
     wanted to be nice to me. My first problem was to recognize that
     I had banged my head into such a wall. The second problem was
     to find a way to remove or get around the wall. In most cases I
     succeeded.

     The execution of a program on a computer will usually involve
     many different modules. There may be a network, a terminal
     control system, a file handling system, compilers and prog-
     ramming language systems, other operating systems, the app-
     lication program itself, utility software used by it etc. All
     these modules are programmed to perform their own tasks, but
     without full knowledge of the other tasks. And most of the
     modules have various checks to prevent misuse.

     Very often, a module will, because of its lack of knowledge of
     the actual usage, not do what is required. Other modules using
     it can then in various ways correct or circumvent this. In the
     worst case, we will have a series of modules not helping each
     other, but doing and undoing and circumventing and cheating the
     actions of each other. In my case, the mayor task of the prog-
     rammer was not to solve the basic programming task, which was
     rather simple, but rather to be successful in this new kind of
     cloak-and-dagger game. Programming has then become quite a new
     kind of art!


15. BIBLIOGRAPHY

Digital Equipment Corporation: DECsystem-10 Software Notebook.
     (eleven volumes.)

DECsystem-10 SIMULA Language Handbook, part I, II and III.

Palme, Jacob 1976: VISTA - For Full Control of Text Display
     Terminals. To be submitted to the DECUS program library.

Palme, Jacob 1977A: Moving Pictures Show Simulation to User. FOA 1
     Report C 10068, April 1977. (A presentation of the uses of the
     program, the development of which you have just read about.)

Palme, Jacob 1977B: Conversational Computer Terminals. FOA 1 Report
     C 10074, August 1977.

Technical user's manuals for the following terminal models: Infoton
     Vista, Infoton Vistar II, Infoton Vistar Sattelite, Tandberg
     TDV 2000, Minitec, Teletec, Elite 1520, Elite 2520, Beehive
     B100, CDC 713-10 (published by the terminal manufacturers).
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 39
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER



ABSTRACT

     One of the most difficult problems with a simulation program is
     to gain confidence in the accurateness and reliability of the
     model. If the program is to be used for important decisions,
     the decision makers must feel sure that they can depend on the
     model. To do this, they have to understand what is happening in
     the program.

     One way of making the users of the simulation more sure about
     what is happening in the program is to show what is happening
     during a simulation as a "moving picture" on a terminal. This
     can easily be done on a simple standard alphanumeric display
     terminal.

     Our experience is that the extra programming effort is small
     and that the gain in understanding of the model is high both
     for the programmer himself and for other users.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 40
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

METHODOLOGY

     An ordinary simple alphanumeric terminal is used. There must be
     codes which can be sent from the computer to the terminal to
     move the cursor (writing position) around the screen. Most
     terminals have such codes.

     A picture is designed for the terminal which shows what is
     happening during the simulation. The terminal screen can be
     divided into several areas, containing tables, written text and
     simplified pictorial information.

     During the simulation, all information on the screen is
     continually kept updated, so that the screen at each instant
     shows the status of the simulation at that time.

     The user can start and stop the simulation instantly by
     inputting CONTROL-S (=STOP) and CONTROL-Q (=CONTINUE) from his
     terminal.

     Some application programs also allow the user to take part in
     the simulation from his terminal. Sometimes, a special area on
     the terminal screen is reserved for interaction with the user.


PROGRAMMING

     A package of utility routines is included in a separately
     compiled CLASS, itself almost entirely written in the
     programming language SIMULA on a DECsystem-10/20 computer. This
     package will simplify the addition of moving-picture output
     to a simulation program.

     Unfortunately, the codes to move the cursor are not the same
     for all kinds of terminals. However, the package recognizes
     eight wellknown terminal types, and will work for most other
     terminals after inputting a simple input sequence from the
     user. The package can easily be modified for new terminal
     makes.

     The programmer writes on the screen by using a few simple
     procedures. Examples of these are "move_the_cursor_to(i,j)"
     which moves the cursor to a certain position on the screen, and
     commands to output a character, a number or a text beginning at
     the current cursor position on the screen.

     To cause an object on the screen to "move" geographically, you
     erase it in its previous position and write it anew at the new
     position. This is done so fast that the terminal user percieves
     it as fluid motion.

     A value which changes with time moves by rewriting it with new
     values at the same place of the screen whenever the value is
     changed or at constant time intervals.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 41
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

     The program also allows switching between several pictures
     (controlled by the program or the user) on the same terminal or
     outputting pictures on several terminal screens simultaneously.

     Our experience is that to add "moving picture" output to an
     existing simulation program does not have to require more than
     about 5 days of work.


APPLICATIONS

     The package has been used for several simulation programs.

     These include:

   - A simulation of ships transporting troups across a lake, with
     enemy destroyers combatting the troup transport ships

   - A simulation of a military aerodrome, showing the position of
     the aircraft and the effect of bombing on the aerodrome

   - A simulation of icebreaker operations in the northern part of
     the Baltic. The positions of icebreakers and ships requiring
     assistance is shown on a simplified map on the screen

   - Several game programs in which the user interacts with the
     simulation. One cat-and-mouse game, one football-type game with
     two simultaneously used terminals, one for each side, and one
     chess game.

   - Nonsimulation applications, for example a budgeting
     application in which the budget table is shown on the screen, the
     user being able to change and to input data to the table, and all
     the sums in the table are updated every time the user changes a
     number on the screen.

   - A text editor based on the idea that the terminal screen always
     shows exactly the text being updated. The effect of each
     editing operation directly changes the text shown on the
     screen.

EXPERIENCE

     Our experience is that this is a very powerful way of making it
     easier for people to understand what is happening in a
     simulation model.

     In a very short time, users understand enough to ask question
     they could not ask before, like:

     Why is that aeroplane so seldom attacked?

     That ice-breaker seems to get hung at that port. Why?

     Faults in the simulation models show up very clearly as curious
     or inconsistent events on the "moving picture screen".
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 42
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

EXAMPLES

     This example shows part of the screen for the ship-and-
     destroyer simulation. To the left is a list of the ships, to
     the right a map of the lake, simplified to a rectangle.

     ----------------------------------------------------------------
     ! SHIP NO 1, SPEED  2.0  !           1                         !
     ! SHIP NO 2, SPEED  4.0  !                 ***   2&            !
     ! SHIP NO 3, KILLED      !                 ***                 !
     ! SHIP NO 4, UNLOADING   !                 ***                4!
     ! SHIP NO 5, UNLOADING   !                                    5!
     ! SHIP NO 6, UNLOADING   !                &                   6!
     ! SHIP NO 7, KILLED      !                                     !
     ! SHIP NO 8, KILLED      !                                     !
     ! SHIP NO 9, SPEED-18.0  !                     9               !
     !---------------------------------------------------------------
          Table of ships                   Map of the lake

     Each digit in the map is the position of a ship. Each "&" is
     the position of a destroyer. The square of asterisks is shown
     for one second each time a ship is sunk by a destroyer.

     The screen also includes (not shown above) an area for
     inputting commands, a clock for simulated time, and areas
     showing troup transport results and a summary table of ship
     states.

     Below is an excerpt from the picture for the icebreaker
     simulation. The arrow indicates a convoy of three ships moving
     upwards on a simplifed map of the Baltic. Ship no. 37 is
     destined for the port of Lule}, ships no. 36 and 38 for the
     port of Pite}.

        '!|   37
         !    36  38
         !

     Below is an excerpt of the airport simulation. The airport is
     divided into several areas where airplanes can be placed, the
     front area, the forest area, the underground shelter area.

     In each area, there are several airplane platforms, and on each
     platform a code indicates the status of the plane. During the
     simulation, the user can see the airplanes move from shelter to
     shelter, see them being bombed and repaired.

     Front:          VU         VU = Sheltered platform under repair
          -       -             VB = Blocked sheltered platform
     Forest:                    A1 = Atack plane no. 1
          -       -             R48 = Will be repaired in 48 hours
          -       -             AJ5, AJ2 = Hunter aircrafts no. 5
          VB      VU            and 2
     Rock:
          V A1 R48   V
     Flying:  AJ5  AJ2
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 43
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

COMPLETE SCREEN SAMPLES

THE TROUP TRANSPORT APPLICATION

                          Here is a pictorial description
                          of the lake, with freighters.          Here you
                          1 = position of ship no 1              can see
Here is     These data    & = position of destroyer              a ^ for each
a table     show the      ***   when a ship is killed,           unloaded
of the      status of     *** = this is shown for one            shipload of
ships.      each ship.    ***   second on the screen             troops
-----------------------------------------------------------------------------
SHIP NO 1, SPEED  2.0  !           1                         !   Troops moved
SHIP NO 2, SPEED  4.0  !                 ***   2&            !   ^
SHIP NO 3, KILLED      !                 ***                 !
SHIP NO 4, UNLOADING   !                 ***                4!
SHIP NO 5, UNLOADING   !                                    5!
SHIP NO 6, UNLOADING   !                &                   6!
SHIP NO 7, KILLED      !                                     !
SHIP NO 8, KILLED      !                                     !
SHIP NO 9, SPEED-18.0  !                     9               !   TIME:  0:05

                 Commands: START new ship                 NO OF SHIPS:
GIVE COMMAND:              DESTROYER start                 9 STARTED
START                      KILL old ship                   0 LOADING
Speed of new ship?         HOLD ship                       2 FORWARD
20                         RANDOM ship speed               3 UNLOADING
                           WAIT delay time                 1 BACKING
                           BEGIN new run                   0 HOLDING
                           <CR> for intetrupt              3 KILLED
                           <FF>(=CONTROL-L) for bad picture
                           CONTROL-S and CONTROL-Q for stop-start
-----------------------------------------------------------------------------
The area above is used to input commands from the       This table (above)
terminal and give error messages for unacceptable       shows the number of
input data.                                             ships each of various
                                                        states.

In this example, the user can input commands in the lower left
part of the screen, and a short list of the available commands is
shown on the screen. <CR> is short for the carriage-return key,
<FF> for the form-feed key, CONTROL for the CONTROL key on the
user terminal.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 44
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

THE ICEBREAKER SIMULATION

(Programmed by @rjan Leringe)

Har-     Each number represents a freighter
bours    * indicates a freighter ready-to-go                 Clock
-------------------------------------------------------------------
Lule}    30*                                                 12 23

Pite}    31* 34

Skell    26* 32*

        '!|   33  35
         !
         !

                                       !    28
                                       !    29  27
                                      |!'

        '!|   37
         !    36  38
         !
Holm`
Gadd     39  40
--------------------------------------------------------------------

Freighters arrive at Holm` Gadd and wait for asistance in
entering one of the northern harbours. After loading or
unloading they need assistance back to Holm` Gadd, where they
vanish from the screen.

The large arrows represent convoys of freighters, assisted by
an icebreaker, moving through the ice. To the left in the
screen are two icebreakers with convoys moving to the north,
and to the right in the picture is a southbound icebreaker with
convoy.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 45
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

THE MILITARY AERODROME

(Programmed by Lars-$ke Larsson)

                                      Clock and day
---------------------------------------------------------------------
Front:                                          Day      15:45  OP  4
   _              _              _              VU             VBA6
Forest:
   _              _              _ A4   Cl      _ A3   Cl      _
   _              _              _              _              _
   VB             VU             VB             VB             V
Rock:
   V A1   R48     V              V              V
Flying:    AJ5   AJ2
---------------------------------------------------------------------

Planes on front platforms can start immediately after an
alarm.

_ is an unsheltered platform.
V is a sheltered platform.
B is a platform blocked after an attack.
  Example: VBAC is attack-plane number 6 which is blocked in a
  shelter after bombing.
U identifies a platform under repair at time shown (15:45).
A4Cl says that attack plane 4 is cleared from obstructions and
  can be used for attack missions.
R48 is a plane under repair, to be ready in 48 hours.
OP 4 says that there are 4 operative planes on the base at
  time shown.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 46
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

A CHESS GAME

(Programmed by Mats Wallin)

         -----------------------------------------
      8  ! :: !    ! :: !    ! :: !    ! :: !    !
         -----------------------------------------
      7  !    ! :: !    ! :: !    ! :: !    ! :: !
         -----------------------------------------
      6  ! :: !    ! :: !    ! :: !    ! :: !    !   Ra6-a4
         -----------------------------------------   Your move:  b3
      5  !    ! :: !    ! BK !    ! :: !    ! :: !
         -----------------------------------------
      4  ! WR !    ! :: !    ! :: !    ! :: !    !
         -----------------------------------------
      3  !    ! :: !    ! :: !    ! :: !    ! :: !
         -----------------------------------------
      2  ! :: !    ! :: !    ! :: !    ! :: !    !
         -----------------------------------------
      1  ! WK ! :: !    ! :: !    ! :: !    ! :: !
         -----------------------------------------
            a    b    c    d    e    f    g    h

Many chess programs have been written. The TORN program can at
present only handle a special kind of end game. The interesting
part is that the program illustrates
a) How a user can play a part in the simulation,
b) How the chess board can be displayed on the screen and
updated with each move.

BK = Black king
WK = White king
WR = White rook

Ra6-a4 = Computer move, rook from square a6 to square a4.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 47
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

A SIMPLIFIED FOOTBALL GAME


         HSPEED:  1   VSPEED:  1
             -------------
             !           !
   GOAL 1    !           !    GOAL 2
                  1 o
                       2

             !           !
             !           !
             -------------
                0 -  1

This very simple program will just illustrate a combination of
the DECsystem-10 SIMULA Real Time package with the display
package. The simulation contains three processes, one for the
ball and one for each of two players.

Codes in the picture: 1 and 2 are the two players, o is the
ball.

Two users can run the program simultaneously, at two different
terminals. Each terminal shows the same picture. Each user can,
whenever he wants, input commands on his terminal to move the
player controlled by him. There are keys on the terminal for
moving the player up, down, left and right.

Note that there is no requirement that every second move should
be made by one and every other second move by the other player.
Both can make moves as fast as they wish. The program handles
the commands in the order in which they are typed by the users.

This is only a test program to show that it works. No real
application has yet used this combination of the real time
package and the display package.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 48
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

TABLE FILL-IN BUDGETING

The screen shows a table. The user can input data to the fields in
the table in arbitrary order, and change previous data at wish. The
totals are updated for every new or changed field value. The user
can thus adjust the table to a desired total by succesively
modifying the individual field values.

------------------------------------------------------------------
 TABLE FILL-IN DEMONSTRATION EXAMPLE:            (Type ? for HELP)

 Type of        Number of   Price per       Total
 unit           units       unit            price

 Chairs            35       123.00 Kr      4305.00 Kr
 Tables             4       789.00 Kr      3156.00 Kr
 Lamps              7       134.00 Kr       938.00 Kr
 Curtains           6       five
 Beds              35       456.00 Kr     15960.00 Kr

 ----------------------------------------------------
 Sum               87                     24359.00 Kr

 -> Integer input was expected.
------------------------------------------------------------------

When the user wrote "five" in a field where a number was expected,
the error message above was automatically displayed.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 49
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

A DISPLAY ORIENTED TEXT EDITOR

     The great advantage with a display terminal for text editing is
     that the computer can so easily change and erase the
     information on the screen. This means that after each edit
     operation, the user can immediately see on the screen the text
     as it will appear after this edit operation.

     VIDED is such a text editor based on the same basic package as
     the other programs described in this report.

     Example; The screen contains the text:

     Jack and Jill went up the hill. Jack fell down, and Jill
     came tumbling after.

     Now, you might want to change the second phrase to "Jack fell
     down from the hill". You move the cursor to the position of the
     insertion and make an insertion command, and you get:

     Jack and Jill went up the hill. Jack fell down from the hill, and Jill
     came tumbling after.

     But now, the first line is too long, so you make a "justify"
     command to adjust the line lengths of the paragraph, and get:

     Jack and Jill went up the hill. Jack fell down from the
     hill, and Jill came tumbling after.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 50
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

     VIDED simplifies the production of character drawings, which
     are almost impossible to produce with many other text editors.

     Examples:

     (1)  ^          (2)                    __________
         ' |                                !        !
        ' o |            --------<---NO-<---! READY? !--->-YES---
       ' o o |           !                  !________!          !
      ' o o o |          V                      !               V
     '_________|    _________      ________     !           ________
     ! O O O O !    !       !      !      !     !           !      !
     ! O O O O !    ! START !----->! EDIT !-->---           ! STOP !
     ! O O O O !    !_______!      !______!                 !______!
     ! O O O O !        ^                                       !
     ! O O O O !        !                                       V

     (3)
             !
       1.00 -!- - - - - - oooooo  - - - - - - - - - - - - - - - - - -
             !          oo      oo
             !        oo          oo
             !       o              o
             !     oo                oo
             !    o                    o
             !   o                      o
       0.00 -!-------------------------------------------------------
             !                           ^o                      o
             !  The curve intersects     ! o                    o
             !  zero at this point ---->--  oo                oo
             !                                o              o
             !                                 oo          oo
             !                                   oo      oo
      -1.00 -!- - - - - - - - - - - - - - - - - -  oooooo - - - - - -
             !


     The curve above was originally produced by a plotting program,
     but without axes or explanations. The axes and the explaining
     text was thereafter added to the plot using the VIDED text
     editor.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 51
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

EXAMPLES OF HOW TO USE THE PROGRAM

     The program is controlled from the application by simple
     procedure calls. Examples:

     MOVE_THE_CURSOR_TO(h,v) will move the cursor to the screen
     position with the address (h,v), as counted from the upper left
     corner of the screen.

     OUTCHAR, OUTTEXT, OUTINT, OUTREAL etc. will work as standard
     SIMULA output procedures, but the text is output at the place
     of the screen where the cursor is. Thereafter, the cursor will
     be at the screen position following the output text.

     OUTIMAGE will move the cursor to the first position of the next
     line of the screen.

     At first, we found debugging of application programs using this
     facility difficult, since the debugging output mixed up the
     picture. The solution was to use two terminals, one for the
     picture and another for the debugging output.

TERMINAL CHARACTERISTICS

     Unfortunately, there is no standardization at all of the codes
     to control a conversational display terminal. Each terminal has
     its own set of control codes.

     The VISTA program package has (in november 1977) built-in
     knowledge of the following terminals:

     INFOTON VISTA
     INFOTON VISTAR SATTELITE
     MINITEC AND TELETEC
     DEC VT52
     DATAMEDIA ELITE 2500 AND ELITE 1520
     TANDBERG TDV 2000
     BEEHIVE B 100
     CDC 713-10

     In addition to this, the program is easy to adjust to other
     terminals, since on most terminals there are keys for trans-
     mitting to the computer the codes to move the cursor around the
     screen. By pushing these keys you can from an unknown terminal
     tell the computer program which codes to send to move around
     the screen.
PALME: VISTA - FULL CONTROL OF TEXT DISPLAY TERMINALS       Page 52
Appendix C: MOVING PICTURES SHOW SIMULATION TO USER

BIBLIOGRAPHY

Dahl, Myhrhaug and Nygaard 1970: SIMULA information Common Base
          Language. Norsk Regnesentral, Forskningsveien 1b, Olso
          3, Norway, Publication no. S-22.

Birtwistle and Palme 1974, 1975: DECsystem-10 SIMULA Language
          Handbook Part I. Swedish National Defense Research
          Institute, S-104 50 Stockholm 80, Sweden, Report no.
          C8398-M3(E5).

Arnborg, Bj`rner, Enderin, Engstr`m, Karlsson, Ohlin, Palme,
          Wennestr`m and Wihlborg 1974, 1976: DECsystem-10 SIMULA
          Language Handbook Part II. Swedish National Defense
          Research Institute, Report no. C8399-M3(E5).

Arnborg, Enderin, Ohlin, Oldgren and Palme 1976: DECsystem-10
          SIMULA Language Handbook Part III. Swedish National
          Defense Research Institute, Report no. C10045-M3(E5).

Palme 1975: Interactive Software for Humans. Swedish National
          Defense Research Institute, Report no. C10029-M3(E5).

Ohlin 1976: Safe Conversational SIMULA Programs Using Class
          SAFEIO. Swedish National Defense Research Institute,
          Report no. C10044-M3(E5).

Palme 1976: VISTA - For Full Control of Text Display Terminals.
          Swedish National Defense Research Institute, Report no.
          D10007-M3(E5). (Contains a programmers manual to the
          program described in this report.)

Jennergren, Lundh and Wandel 1976: Icebreaking operations in the
          Northern Baltic - A Simulation Study. FOA 1 report
          88-8246:1/1976.

Palme 1977: VIDED - A Display-oriented Text Editor.
 
