	SUBROUTINE MOVFIL(DISNUM, X, Y)
C************************************************************
C
C  THIS ROUTINE IS USED TO MOVE A DISPLAY FILE (ALREADY
C  RESIDENT IN THE GT40) TO USER (X, Y).
C
C  POSSIBLE ERRORS:
C	%TRYING TO MOVE A NON-EXISTENT DISPLAY FILE (RETURNS DISNUM = 0)
C	%TRYING TO MOVE A NON-RELOCATABLE DISPLAY FILE
C	?INVALID REPLY TO A MOVE COMMAND (RETURNS DISNUM = 0)
C
C  ROUTINES CALLED:
C	IPHYSX - CONVERTS USER X TO RASTER IX
C	IPHYSY - CONVERTS USER Y TO RASTER IY
C	SEND   - SENDS A COMMAND TO THE GT40
C	GET    - RECEIVES A STATUS TRANSMISSION FROM THE GT40
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	INTEGER DISNUM, DNUM, STATUS

	IX = IPHYSX(X)
	IY = IPHYSY(Y)
100	CALL SEND(3, DISNUM, IX, IY)
	CALL GET(STATUS, IDX, IDY, DNUM)
	IF(STATUS .EQ. "66) GO TO 100
	IF(STATUS .EQ. 0) RETURN

	IF(STATUS .NE. 1) GO TO 200
	CALL ERROR('%TRYING TO MOVE A NON-EXISTENT DISPLAY =',DISNUM)
	DISNUM = 0
	RETURN

200	IF(STATUS .NE. 4) GO TO 300
	CALL ERROR('%TRYING TO MOVE A NON-RELOCATABLE DISPLAY =',DISNUM)
	RETURN

300	CALL ERROR('?INVALID REPLY TO A MOVE COMMAND, STATUS=',STATUS)
	DISNUM = 0
	RETURN
	END
