	SUBROUTINE LPHIT(DISNUM, X, Y)
C************************************************************
C
C  THIS ROUTINE IS USED TO RETURN THE DISPLAY NUMBER
C  AND USER (X, Y) OF THE NEXT L.P. HIT (I.E. A WAIT
C  IS PERFORMED UNTIL A HIT IS DETECTED)
C
C  POSSIBLE ERRORS:
C	%LIGHT PEN IS NOT ENABLED
C	?INVALID REPLY TO LPHIT (RETURNS DISNUM = 0)
C
C  WARNING:
C	IF LPHIT IS PRECEDED BY A CALL TO LPOFF
C	THE ROUTINE WILL ALWAYS RETURN WITH AN ERROR
C	MESSAGE. (THIS COULD ALSO BE AVOIDED BY THE
C	GIDUS COMMAND "LE")
C
C  ROUTINES CALLED:
C	SEND   - SENDS A COMMAND TO THE GT40
C	GET    - RECEIVES A STATUS TRANSMISSION FROM THE GT40
C	USERX  - RETURNS USER X OF RASTER IX
C	USERY  - RETURNS USER Y OF RASTER IY
C	ERROR  - ERROR LOGGING ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	REAL USERX, USERY

	ICMD = 9
	IF(DISNUM .EQ. -1) ICMD = 16
100	CALL SEND(ICMD, 0, 0, 0)
	CALL GET(STATUS, IX, IY, DISNUM)
	IF(STATUS .EQ. "66) GO TO 100
	IF(STATUS .NE. 0) GO TO 200
	X = USERX(IX)
	Y = USERY(IY)
	RETURN

200	IF(STATUS .NE. 5) GO TO 300
	CALL ERROR('%LIGHT PEN NOT ENABLED',0)
	GO TO 400

300	CALL ERROR('%INVALID REPLY TO LPHIT, STATUS =',STATUS)
400	DISNUM = 0
	X = 0.
	Y = 0.
	RETURN
	END
