	SUBROUTINE LOGON
C************************************************************
C
C  THIS ROUTINE IS USED TO ENABLE THE LOG-FILE. ON THE
C  FIRST CALL THE LOG FILE IS OPENED, ON SUBSEQUENT CALLS
C  THE FILE IS APPENDED. THE LOG FILE IS "DSK:DISLIB.LOG".
C
C  EACH TIME THE LOG IS RE-ENABLED A TIME STAMP IS WRITTEN
C
C  POSSIBLE ERRORS:
C	NONE
C
C  WARNINGS:
C	THE LOG FEATURE SHOULD NORMALLY BE LEFT OFF IN
C	ORDER TO SPEED UP PROCESSING, AND SAVE ON DISK
C	SPACE. IT IS QUITE EASY TO EXCEED YOUR LOGGED-IN
C	QUOTA WHEN LOGGING, SO THIS SUBROUTINE SHOULD BE
C	USED CAREFULLY.
C
C  ROUTINES CALLED:
C	SFIELD - BYTE STORAGE ROUTINE
C
C************************************************************
	IMPLICIT INTEGER (A - Z)
	LOGICAL LOG
	INTEGER TODAY(2)
	COMMON /LOGBLK/ LOG, GTLOG, FATAL, ERROR

1	FORMAT('LOG FILE CREATED - ',A5,A4,' AT ',A5,A5///)
2	FORMAT('LOG FILE RE-OPENED - ',A5,A4,' AT ',A5,A5///)

	IF(LOG) RETURN
	LOG = .TRUE.
	COUNT = COUNT + 1
	CALL DATE(TODAY)
	CALL TIME(TIME1, TIME2)
	CALL SFIELD(TIME2, 0, 7, 58)
	IF(COUNT .GT. 1) GO TO 100

	OPEN(UNIT=GTLOG,DEVICE='DSK',FILE='DISLIB.LOG',
	1    ACCESS='SEQOUT',MODE='ASCII')
	WRITE(GTLOG, 1) TODAY, TIME1, TIME2
	RETURN

100	OPEN(UNIT=GTLOG,DEVICE='DSK',FILE='DISLIB.LOG',
	1    ACCESS='APPEND',MODE='ASCII')
	WRITE(GTLOG, 2) TODAY, TIME1, TIME2
	RETURN
	END
