C  THIS PROGRAM IS USED TO PERFORM A DOWNLINE
C  LOAD TO THE GT40. INPUT TO THE PROGRAM IS
C  A PDP/11 ABSOLUTE PROGRAM AS OUTPUT
C  BY THE ASSEMBLER "MACDLX"

C	SUBPROGRAMS

C	SNDCHR - SEND IMAGE CHARACTER TO THE GT40
C	GTBLK6 - GET A BLOCK FROM DSK
C	SDBLK6 - SEND BLOCK TO THE GT40

	IMPLICIT INTEGER (A-Z)
	INTEGER BLOCK(2000)
	DATA DSK, LOG, BLCK /20, 21, 0/

1	FORMAT(' FILENAME DIALOG:')
3	FORMAT(' START OF GT40 LOADER LOG FILE (SIX BIT)')
4	FORMAT(' TRANSMITTING BLOCK',I3)
5	FORMAT(' %CHECKSUM ERROR IN BLOCK',I3)
6	FORMAT(' LAST BLOCK, TRANSFER ADDRESS = LOAD ADDRESS')

	TYPE 1
	OPEN(UNIT=DSK,ACCESS='SEQIN',MODE='IMAGE',DIALOG)
	OPEN(UNIT=LOG,FILE='LOADER.LOG',ACCESS='SEQOUT')
	WRITE(LOG, 3)

C  RESET GT40 AND PREPARE FOR LOAD

	CALL SNDCHR("175)
	CALL SNDCHR("122)
	CALL SNDCHR("175)
	CALL SNDCHR("114)
	DO 10 I = 1, 8
		CALL SNDCHR("100)
10	CONTINUE

20	BLCK = BLCK + 1
	WRITE(LOG, 4) BLCK
	CALL GTBLK6(BLOCK, COUNT)

30	CALL SDBLK6(BLOCK, COUNT, ERROR)

C  IF CHECKSUM ERROR THEN RETRANSMIT BLOCK

	IF(ERROR .EQ. 0) GO TO 40
	WRITE(LOG, 5) BLCK
	GO TO 30
40	IF(COUNT .GT. 6) GO TO 20
	WRITE(LOG, 6)
	CLOSE(UNIT=DSK)
	CLOSE(UNIT=LOG)
	STOP
	END
