	SUBROUTINE INIT(N, FILE, BOUNDS, X, Y)
C************************************************************
C
C  THIS ROUTINE IS USED TO INITIALZE A DISPLAY FILE
C
C  A DISPLAY FILE IS INITIALZED WITH THE FIRST FOUR WORDS
C  AS FOLLOWS:
C
C	POINT		; (OTHER CHARACTERISTICS AS SET BY SETMOD)
C	  X		; USER SUPPLIED X POSITION
C	  Y		; USER SUPPLIED Y POSITION
C	STATUS-A	; (CHARACTERISTICS SET BY SETA)
C
C  POSSIBLE ERRORS:
C	NONE
C
C  ROUTINES CALLED:
C	SETGM  - RETURNS AN S.G.M. INSTRUCTION
C	ADWORD - ADDS A WORD TO THE DISPLAY FILE
C	SETSTA - RETURNS A STATUS-A INSTRUCTION
C	IPHYSX - RETURNS RASTER POSITION OF USER X
C	IPHYSY - RETURNS RASTER POSITION OF USER Y
C
C************************************************************
	IMPLICIT INTEGER (A - W, Z)
	INTEGER FILE(N)
	LOGICAL LP,BLINK,ITALA,LPA
	COMMON /SCLBLK/ XMIN, YMIN, XMAX, YMAX, BEAMX, BEAMY
	COMMON /MODBLK/ MODE, INT, LP, BLINK, LINE, OLDSGM
	COMMON /STABLK/ ITALA, LPA, OLDSTA


	FILE(1) = BOUNDS
	IF(BOUNDS .LE. 0) FILE(1) = "377777777777
	N = 21
	MODE = "3
	OLDSGM = SETGM(MODE, INT, LP, BLINK, LINE)
	CALL ADWORD(N, FILE, OLDSGM)
	IX = IPHYSX(X)
	IY = IPHYSY(Y)
	CALL ADWORD(N, FILE, IX)
	CALL ADWORD(N, FILE, IY)
	OLDSTA = SETSTA(ITALA, LPA)
	CALL ADWORD(N, FILE, OLDSTA)
	BEAMX = IX
	BEAMY = IY
	FILE(2) = BEAMX
	FILE(3) = BEAMY
	FILE(4) = OLDSGM
	FILE(5) = OLDSTA
	RETURN
	END
