


Swedish National Defense Research Institute     FOA 1 Report
Department of Planning and Operations Research  D10009-M3(E5)
S-104 50 Stockholm 80                           March 1976


ADRES - A PROGRAM FOR HANDLING ADDRESS FILES

BY JACOB PALME

ABSTRACT:

     The ADRES program is suitable for handling small address
     registers with between 10 and 2000 addresses.  The program
     runs on a DECsystem-10 computer.

     The program contains facilities for reformatting the
     addresses to fit any kind of adhesive labels, with any
     number of labels across the width of the form.  Labels can
     be printed on a line printer or on a typewriter terminal.

     There are also facilities for selecting certain labels from
     an address file using Boolean search conditions like
     "SWEDEN+DENMARK&COPENHAGEN".  There is a field in each
     address for storing information which is not to be printed
     on the labels, e.g. an interest profile to be used in the
     selection.

     Addresses can be sorted on any line in the address.

     The program can easily, without reprogramming, be made to
     fit a new task, e.g. a new way of selecting addresses for
     distributions.

     As an appendix is included an example of how you write to
     the swedish DATAINSPEKTIONEN to apply for the right to use
     an address register.

SEARCH KEY:

     Computer, Digital Equipment, DECsystem-10, Address, Search,
     Selection, Mailing, Label.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 2


SWEDISH ABSTRACT:

     ADRES-programmet {r l{mpligt f`r hantering av sm}
     adressregister p} mellan 10 och 2000 adresser.  Programmet
     k`rs p, en DEC-system-10 dator, men {r skrivet i SIMULA och
     konverterbart till annan dator.

     Programmet kan formattera om adresserna f`r att passa varje
     typ av adressetiketter med en eller flera etiketter i bredd
     p} etikettarken.  Etiketterna kan skrivas ut p} radskrivare
     eller skrivmaskinsterminal.

     Programmet g`r det m`jligt att med Booleska s`kformler av
     typen "SVERIGE+DANMARK&K@PENHAMN" v{lja vissa adresser.
     Varje adress har ett f{lt av variabel l{ngd som inte skrivs
     ut vid utskrift, och d{r t.ex.  en intresseprofil kan
     lagras.

     Adresserna kan sorteras.

     Programmet kan l{tt, utan omprogrammering, f}s att passa en
     ny uppgift, t.ex. en ny metod att v{lja ut adresser.

     Som appendix bifogas ett exempel p} hur man skriver till
     datainspektionen om tillst}nd till ett adressregister.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 3


SUMMARY OF INPUT COMMAND FORMAT AND SWITCHES

outfil=infil/switch1/switch2...
SWITCH   DEFAULT IN  OUT-EXTENSIONS  /MEANING
/NOLABEL LABEL .ADR .LAB  Output for adhesive labels
/LIST       NO .ADR .LST  Output for TTY or LPT-listing
/FILE       NO .ADR .ADR  Output for .ADR file
/PRESORT    NO .ADR .USR  Output for sorting
/ASORT      NO .SRT .ADR  After sorting to .ADR file
/OUT1       NO .ADR  ?    Output line 1 as part of label
/SELECT     NO .ADR  ?    Select only certain addresses
/NOCASESHIFT CASESHIFT    Upper and lower case equal when
                          selecting
/LINES:N     5            Number of lines per label
/LABELS:N    3            Number of labels horizontally
/LEFT:N      0            Left margin
/WIDTH:N    36            Max number of chars in a line on one
                          label
/TAB:N      41            Horizontal spacing between labels
/LINE1:N   300            Max length of first line in input
                          address
/LINE2:N    80            Max length of other lines in input
                          address
/NOTABS   TABS            Set and use built-in tabs on GNT
                          terminal
/SINGLE     NO            LABELS:1/LEFT:1/WIDTH:48

FORMAT OF ADDRESS FILE

     The input file to ADRES is normally an address file
     consisting of one record for each address.  The records are
     separated by FORM FEED characters.  Each address can contain
     up to 16 lines, separated by CARRIAGE RETURN + LINE FEED.
     IMPORTANT:  The input records should not contain any TAB
     characters.

     The number of lines in an input record need  n o t  be the
     same as the number of lines on the adhesive labels.  The
     ADRES program will automatically reformat the input
     addresses to fit any kind of adhesive label.

     The first line (immediately after the FORM FEED) in each
     address can contain special information which you do not
     want to print on the adhesive labels, e.g. an interest
     profile or internal information.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 4


INSERTION, REMOVAL AND UPDATING OF ADDRESSES

     The ADRES package contains no program to correct individual
     addresses or to insert or delete addresses, since this kind
     of updating is easy to do with a text editor such as TECO or
     SOS or EDITS.

     Example:  You first find the adresses to be updated with a
     search command across pages (such as the N command of TECO)
     and then correct it or remove it (e.g. with the Y command of
     TECO).

     Do not forget to insert a FORM FEED in front of new
     addresses added to the file.

     At the QZ computing center in Stockholm, you can order forms
     with adhesive labels in a format suitable for GNT, Terminet
     and similar terminals, from the computer centre.

     Example of a simple address file (<FF> means FORM FEED):

     <FF>government research
     F`rsvarets Forskningsanstalt
     FACK
     104 50 Stockholm 80
     <FF>government computer centre IBM CDC DEC Digital
     Stockholms Datamaskincentral
     f`r h`gre utbildning och forskning
     FACK
     104 50 Stockholm 80

OUTPUT ON ADHESIVE LABELS

     Unless you specify otherwise, the output from ADRES is
     prepared in a format suitable for direct printing on
     adhesive labels.

     Each address is reformatted to fit into a given label size,
     with given number of lines and given number of characters
     per line.

     You can choose the number of labels from left to right in
     the output, and the spacing between the labels.

     The algorithm for fitting an address into a label accepts
     addresses with too many lines, too few lines, too long lines
     or too short lines, and tries to get a neat label.  This
     works better if the input file has many short lines than few
     long lines.

     The input address is never shortened.  If it is too large,
     an error message is given on the terminal, and this address
     is not output.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 5


INSERTING LABEL FORMS INTO A TERMINAL

     When you have processed your address file with ADRES to get
     a .LAB file, you can insert a form with adhesive labels into
     a terminal (e.g.  a GNT terminal).  First type "TTY NO CRLF"
     on the terminal and then move the paper so that you are on
     the first line of a label.  Then type "COPY TTY:= FILE.LAB"
     where "FILE.LAB" is your label file, and push the RETURN key
     on your terminal.

     The labels will now be printed on your terminal.

     You can also insert the label form into the GNT terminal
     directly when running the ADRES program, and type the input
     command "TTY:=filename" where filename is your address file,
     to get the addresses printed directly from the ADRES program
     to the label form.

COMMAND SWITCH:  /LIST

     Exactly the same output is produced as with ordinary label
     output, except that:

     1) The default extension of the output file is .LST instead
     of .LAB.

     2) The output file is divided into pages of suitable size.

COMMAND SWITCH:  /FILE

     The output file has the same format, with formfeed
     characters between each address, as the input file.  Usually
     used in combination with /SELECT.

     The default extension of the output file with /FILE is .ADR.

COMMAND SWITCH:  /PRESORT

     The output file is produced in a suitable format for
     sorting.  Each address becomes one long record, with
     <CR><LF> instead of <FF> between records, and each line in
     the input file is expanded with blanks to its maximum length
     within this record.  This means that the same input line
     always gets the same position in the presort record.

     You may often want to modify the input file slightly with
     TECO or a simple program before and after sorting, to get
     the sort field first in a line.

     If you want to reduce the length of the sort records, then
     carefully choose values for the input switches /LINE1:n and
     /LINE2:n.  The default values for these switches may often
     give unneccesary long sort records.

     The output file with /PRESORT has the default extension
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 6


     .USR.

COMMAND SWITCH:  /ASORT

     The input file is in the format produced as output with the
     switch /PRESORT.

     The default extension of the input file with the switch
     /ASORT is .SRT.

     A typical sort operation involves:

     1) Run ADRES with /PRESORT to convert a .ADR file to a .USR
     file suitable for sorting.

     2) Run SORT to produce a sorted file with extension .SRT
     from the unsorted file with extension .USR.

     3) Run ADRES again to convert the sorted file with extension
     .SRT to a .ADR, .LAB or .LST file.

     The switch /ASORT is useful to simplify input of files
     produced in other programs, written in, e.g. COBOL, FORTRAN
     or SIMULA.  In the same way /PRESORT may simplify output of
     data to programs in other languages.

COMMAND SWITCH:  /OUT1

     Normally the first line of each input address is not output
     on labels or listings.  This line is assumed to contain a
     selection key or other internal information not to be
     printed.  With this switch however, you can get the whole
     input record output on labels and listings.

     When this switch is set, the maximum length of all lines is
     set to the largest of the switch values /LINE1:n and
     /LINE2:n.

COMMAND SWITCH:  /SELECT

     When this switch is set, you can use a Boolean condition to
     select only certain addresses for output.

     A typical such Boolean condition might be:
              SWEDEN+(DENMARK+NORWAY)&-UNIVERSITY
     meaning that you want to select all addresses containing the
     word "SWEDEN" and also all addresses containing the words
     "DENMARK" or "NORWAY" except those containing the word
     "UNIVERSITY".

     Priority of operator characters:
     1) "(" and ")"
     2) -
     3) &
     4) +
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 7


     You will be asked for two Boolean conditions, one for the
     first line in the address, one for the other lines.  If you
     input both conditions, only those lines will be output which
     satisfy both conditions.

     Selection is faster if you only input a Boolean condition
     for the first line.  You can also make selection faster with
     the /NOCASESHIFT switch.

COMMAND SWITCH:  /NOCASESHIFT

     This switch is only meaningful combined with the /SELECT
     switch.  If this switch is not given, the word e.g. "SWEDEN"
     or "sweden" in a Boolean condition are identical in meaning,
     and will recognize any address containing "SWEDEN" or
     "sweden" or "Sweden".

     When the /NOCASESHIFT switch is set, the word "SWEDEN" in a
     Boolean condition will only recognize exactly this text
     without case shifts.  This will make selection somewhat
     faster.

COMMAND SWITCH:  /LINES:N

     This switch is used to tell the system the size of your
     adhesive labels.  Substitute for N the number of lines on a
     label.

     COMMAND SWITCH:  /WIDTH:N

     This switch inputs the number of characters on one line on
     an adhesive label.

COMMAND SWITCH:  /LABELS:N

     Forms with adhesive labels often contain several labels in
     the breadth.  This switch input the number of labels in the
     breadth.

COMMAND SWITCH:  /LEFT:N

     The number of characters in left margin before the first
     label in the breadth.

COMMAND SWITCH:  /TAB:N

     The horizontal spacing between labels in the breadth
     (including the label width).
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 8


COMMAND SWITCH:  /LINE1:N

     The maximum length of the first line in the input address.
     If you try to input a larger address, an error will occur.
     If such an error occurs, you can type proceed to continue
     execution.  You will then be allowed to conversationally
     input a shorter line instead of the too long line.

COMMAND SWITCH:  /LINE2:N

     The maximum length for all input address lines except the
     first line.  See above.

COMMAND SWITCH:  /NOTABS

     If you have more than one label in the breadth of the output
     form, the program will normally output one tab to skip from
     one label to the next.  With /NOTABS, a number of blanks
     will be used instead.

     Note that since only one tab is used to space between
     labels, the tab settings on the terminal must be set to the
     start of each label.  Standard tab settings every eight
     characters will not do.  If your terminal has no tabs which
     can easily be set, you can avoid this problem by using the
     switch /NOTAB.

     If you do not write /NOTABS, the output will also include
     device control characters to set the tab settings according
     to the standard used on GNT, Terminet etc. terminals.

COMMAND SWITCH:  /SINGLE

     This is just a shorter way of writing
     /LABELS:1/LEFT:1/WIDTH:48, which is suitable for certain
     forms with just one adhesive label across the breadth of the
     form.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES               Page 9


FILES ON THE ADRES DISTRIBUTION TAPE

     ADRES   SIM  42  Main source program
     ADRES   RNM  32  Runoff file for ADRES.MAN and
                      ADRES.HLP(with /variant:help)
     ADRES   HLP  16  Help file, also used by the selective help
                      facility within the ADRES program
     ADRES   MAN  31  This manual
     ADRES   OVH  29  Overhead picture texts on ADRES, type with
                      /p
     ADRES   SAV  89  Executable core image of ADRES
     SQHELP  SIM  11  Source program of help facility module
     SQHELP  RNH   5  Runoff description of help facility module
     DECOM   SIM   9  Source program of command interpreter
     DECOM   HLP  13  Description of command interpreter
     SELECT  SIM  13  Source program of Boolean selection
                      facility (/SELECT)
     SELECT  RNH  13  Runoff description of SELECT
     SIMR21  SHR  47  Simula run time system part 1.  Must be
                      stored on SYS:
     SIMR22  SHR  37  Simula run time system part 2.  Must be
                      stored on SYS:
     SIMDDT  ABS  44  Simula debugging system.  Must be stored on
                      SYS:

     In addition to the files listed above, you need the SIMULA
     compiler (DECUS ORDER NO 10-223A), if you want to recompile
     modules within ADRES.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES              Page 10
APPENDIX A: AN EXAMPLE OF HOW TO WRITE TO DATAINSPEKTIONEN


APPENDIX A:  AN EXAMPLE OF HOW TO WRITE TO DATAINSPEKTIONEN

     Datainspektionen
     Fack
     103 60 Stockholm 3





     ANS@KAN OM TILLST$ND

     Registret avses tas i drift den 1.7.76.

     Tidigare tillst}nd har ej meddelats.

     Registeransvarig:  Kungliga Myndigheten, Avdelning D,
     111 11 Stockholm 11, tel 08-11 11 11.

     Kontaktman:  Sven Svensson.

     Registrets ben{mning:  KONTKT.ADR.

     #ndam}let med registret:  F`rteckning `ver vetenskapliga
     kontakter vid Kungliga Myndigheten, Avdelning D.  Uts{ndning
     av forskningsrapporter.  Personliga kontakter.  Information
     om myndighetens verksamhet.  Adressering av brev.

     Forts{ttning se bilaga 1.

     Kungliga Myndigheten Avdelning D


     Sven Svensson

     Bilagor:  1-11
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES              Page 11
APPENDIX A: AN EXAMPLE OF HOW TO WRITE TO DATAINSPEKTIONEN


BILAGA 1

#NDAM$L

     Registret upptar s}dana personer, f`retag och institutioner
     som Kungliga Myndigheten, Avdelning D, har utbyte av
     erfarenheter med.

     Avdelning D handhar datorverksamheten inom Kungliga
     Myndigheten.

     Registret anv{nds i s}dana fall, d} avdelningen beh`ver
     kontakt med personer med intresse f`r dess verksamhet.
     Exempel:

     1) Uts{ndning av vetenskapliga rapporter.

     2) Kallelse till kurser och konferenser.

     3) Meddelande om nya resultat eller f`rfr}gan om synpunkter.

     4) F`rfr}gan om den kontaktade `nskar kvarst} i registret.

     Man kan s{ga att registret p} m}nga s{tt anv{nds p} samma
     s{tt som en s}dan adressbok, som m}nga m{nniskor har `ver
     v{nner och bekanta.


UTBYTE AV INFORMATION MED UTLANDET

     Delar av inneh}llet i adressregistret rapporteras till
     Kungliga Myndighetens motsvarighet Kongelige Institutt i
     Danmark.  D{r anv{nds adresserna p} ett likartat s{tt som
     hos oss i ett likartat datorregister.


UPPGIFTER SOM ING$R I DEN AUTOMATISKA DATABEHANDLINGEN

     Varje post best}r av namn, adress och intresseprofil.

     Intresseprofilen grundas p} uppgifter fr}n den registrerade
     personen, och anger vilken del av Kungliga Myndighetens
     verksamhet som personen {r intresserad av.  Vid
     datork`rningar kan vi d{rigenom selektera vilka som skall f}
     viss information p} grundval av mottagarens intresseprofil.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES              Page 12
APPENDIX A: AN EXAMPLE OF HOW TO WRITE TO DATAINSPEKTIONEN


VEM SOM L#MNAR UPPGIFTERNA

     Uppgifter till registret inf`res n{r en person tar kontakt
     med Kungliga Myndigheten, vilket kan ske per telefon, per
     brev eller via den blankett som bifogas som bilaga 1b.


SAMK@RNING MED ANDRA REGISTER

     Ut`ver det informationsutbyte med Danmark som beskrivs ovan
     sker ingen samk`rning med andra personregister.


BILAGA 2:  BEARBETNING

     Uts`kning av personer genom s`km`nster i form av Booleskt
     uttryck.

     Halvmanuellt urval av personer i dialog vid terminal.

     Utskrift av namn och adress p} etiketter.

     Utskrift av registret eller delar d{rav p} magnethband,
     skivminne, h}lremsa, h}lkort eller lista.


BILAGA 3:  UTDATA

     a) Namn och adress.

     b) Hela postens inneh}ll.

     Eftersom registret utg`r offentlig handling, har varje
     svensk medborgare r{tt att ta del av registrets inneh}ll.


BILAGA 4:  TEKNISK UTRUSTNING

     Dialogdator DECsystem-10 Vid Stockholms Datamaskincentral
     f`r h`gre utbildning och forskning.  Datorn har ett v{l
     fungerande skyddssystem f`r att f`rebygga att obeh`riga tar
     del av eller {ndrar register.  Skyddsystemet {r godk{nt av
     FOA f`r bearbetning av milit{rt hemliga data.  Backup tas
     varje dag som registrens inneh}ll har {ndrats.
ADRES - A PROGRAM FOR HANDLING ADDRESS FILES              Page 13
APPENDIX A: AN EXAMPLE OF HOW TO WRITE TO DATAINSPEKTIONEN


BILAGA 5:  UTTAG P$ BEG#RAN AV DEN REGISTRERADE

     Om en s}dan f`rfr}gan inkommer, s} kommer den att besvaras
     inom tv} veckor (undantag:  semestertider).


BILAGA 6:  R#TTELSE AV ORIKTIG UPPGIFT

     S} fort meddelande inkommit om oriktig uppgifter, kommer
     denna att r{ttas f`re n{sta datork`rning med registret.


BILAGA 7:  GALLRING AV REGISTRET

     Sm{rre gallring g`rs fortl`pande.  St`rre gallring sker
     genom brev till alla registrerade med f`rfr}gan om de vill
     vara kvar i registret.  I vissa fall sparas en backup av
     registret f`re gallringen p} magnetband.


BILAGA 9:  REKONSTRUKTIONSM@JLIGHETER

     Backup tas p} s}dant s{tt, att registret alltid kan
     }terst{llas till sitt utseende p} kv{llen n{rmast f`reg}ende
     arbetsdag.


BILAGA 10:  ANDRA S#KERHETS$TG#RDER

     Vi tror att datainspektionen {r v{l medveten om de
     datas{kerhets}tg{rder som vidtas vid Stockholms
     Datamaskincentral f`r h`gre utbildning och forskning.


BILAGA 11:  LOGGNING

     Varje k`rning p} s}dant projektnummer, inom vilket datorns
     operativsystem till}ter access till registret, loggas.
     Varje montering av magnetband loggas.
