      SUBROUTINE WRDPLT (INDIC ,INDEX ,LINE ,LWORD,LTRBGN,LTREND,HEIGHT,
     1XCORNR,YCORNR,LASTX,LASTY)
C                                                               10/17/67
C     WORD PLOTTING SUBROUTINE FOR GENERAL PLOTTING PACKAGE GENPLT-II
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE WRDPLT ARGUMENT LIST DEFINITIONS.
C
C     INDIC  = ANGLE OF LETTERING BASELINE IN DEGREES FROM HORIZONTAL.
C     INDIC CAN ONLY HAVE VALUES 0 AND 90 IF FONT1 IS USED.
C     INDEX  = 0 PLOTS LEFT END OF LETTERING BASELINE AT XCORNR YCORNR.
C     INDEX  = 1 CENTERS LETTERING BASELINE AT XCORNR, YCORNR.
C     INDEX  = 2 PLOTS RIGHT END OF LETTERING BASELINE AT XCORNR YCORNR.
C     LINE   = LINE UPON WHICH NUMBER IS TO BE PLOTTED.
C     LINE STARTING AT INPUT VALUES OF XCORNR AND YCORNR IS LINE = 1.
C     HIGHER VALUED LINES ARE OFFSET TO BE PLOTTED BELOW LINE NUMBER 1.
C     SPACING BETWEEN LINES IS 1.5 HEIGHT OF WORDS PLOTTED.
C     LWORD  = WORD ARRAY TO BE PLOTTED, READ BY 12A6 FORMAT.
C     LTRBGN = FIRST LETTER IN WORD ARRAY TO BE PLOTTED.
C     LTREND = FINAL LETTER IN WORD ARRAY TO BE PLOTTED.
C     HEIGHT = HEIGHT OF LETTERS TO BE PLOTTED.
C     XCORNR = HORIZONTAL COORDINATE OF LETTERING BASELINE.  SEE INDEX.
C     YCORNR = VERTICAL COORDINATE OF LETTERING BASELINE.  SEE INDEX.
C     LASTX  = LAST X GRID COORDINATE PLOTTED.
C     LASTY  = LAST Y GRID COORDINATE PLOTTED.
C
      DIMENSION LWORD(12)
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
C
      KSCALE=HEIGHT*FACTOR/6.0
      KONTRL=INDIC-360*(INDIC/360)
      IF(KONTRL)5,2,1
    1 IF(KONTRL-90)4,3,4
    2 KONTRL=1
      ACOS=1.0
      ASIN=0.0
      GO TO 6
    3 KONTRL=2
      ACOS=0.0
      ASIN=1.0
      GO TO 6
    4 KONTRL=-360+KONTRL
    5 ANGLE=0.0174532925*FLOAT(KONTRL)
      ASIN=SIN(ANGLE)
      ACOS=COS(ANGLE)
    6 IF(INDEX)12,9,7
    7 IF(INDEX-2)8,8,12
    8 LENGTH=0
      CALL LTRPLT(LWORD,LTRBGN,LTREND,0,KSCALE,LASTX,LASTY,LENGTH,LY7)
      IF(LENGTH-(2*KSCALE))9,9,10
    9 SHIFT=0.0
      GO TO 11
   10 SHIFT=(INDEX*(LENGTH-(2*KSCALE)))/2
   11 LX7=(FACTOR*(XCORNR+(1.5*ASIN*HEIGHT*FLOAT(LINE-1))))-(ACOS*SHIFT)
     1+OFSETX
      LY7=(FACTOR*(YCORNR-(1.5*ACOS*HEIGHT*FLOAT(LINE-1))))-(ASIN*SHIFT)
     1+OFSETY
      CALL LTRPLT(LWORD,LTRBGN,LTREND,KONTRL,KSCALE,LASTX,LASTY,LX7,LY7)
   12 RETURN
      END
