C     PROGRAM TO TEST GENPLT-II PLOTTER INTERFACE (PEN- PREFIX) ROUTINES
C                                                               02/12/68
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINES PENBGN, PENDWN, PENEND, PENHLT AND PENUP ARE CALLED.
C     OUTPUT CONSISTS OF 3 CENTERED PLOTS, EACH IS VERSION OF YALE SEAL.
C     SEAL DIMENSIONS ARE 0.7*WIDTH AND 0.7*HEIGHT OF PLOTTER TABLE.
C
      DIMENSION KRDBGN(3),N(630)
      DIMENSION  N001(63), N064(63), N127(63), N190(63), N253(63),
     1           N316(63), N379(63), N442(63), N505(63), N568(63)
      COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      EQUIVALENCE (N(  1),N001(1)), (N( 64),N064(1)), (N(127),N127(1)),
     1            (N(190),N190(1)), (N(253),N253(1)), (N(316),N316(1)),
     1            (N(379),N379(1)), (N(442),N442(1)), (N(505),N505(1)),
     1            (N(568),N568(1))
C
      DATA N001/
     1  30004908,51095411,55125715,58175920,60266060,  600026, 1200217,
     2   3150512, 6110909,11083000,62621353, 9530751, 7400539, 4390242,
     3   2430346, 3480447, 5480546, 4430441,62620242, 3410441, 6420743,
     4  62620740, 7260525, 4250228, 2290332, 3340433, 5340532, 4290427,
     5  62620228, 3270427, 6280729,62620726, 7182718,28162915,31153216,
     6  33185318,53295428,56275727,58286262,56275629,55325534,56335734,
     7  57325829,58285625,55255326,62625329,53435442,56415741,58426262,
     8  56415643,55465548,56475748,57465843,58425639,55395340,62625343,
     9  53515153,47536262,51535120,53186262,51203320,62623322,33203218/
      DATA N064/
     1  31172917,28182720,27226262,27200920,62620718, 9200953,62623050,
     2  29522853,26542454,20531853,15541455,14261525,18242024,24252625,
     3  28242923,30213123,32243425,36254024,42244525,46264655,45544253,
     4  40533654,34543253,31523050,30216262,14551353,11511122,13241426,
     5  62621122,27222820,29193119,32203322,49226262,46264724,49224951,
     6  47534655,62621648,16471944,19421742,15401940,20442045,18471848,
     7  17471745,16441743,15411542,16431544,16451546,15471648,62622248,
     8  22472447,25462540,24402441,25442445,23452244,23412240,20402141,
     9  22412144,22452146,21472248,62622748,27472847,29462845,28402740/
      DATA N127/
     1  27412845,27452646,26472748,62623248,32473447,35463540,34403441,
     2  35443445,32453146,31473248,62623748,37473847,39463845,38403740,
     3  37413845,37453646,36473748,62624148,41474344,44454346,43474448,
     4  44474546,45454344,45424541,44404441,42444143,42424241,40404141,
     5  40424043,42444046,40474148,62621836,18352235,23342332,22281728,
     6  17291833,18302230,22322133,18331734,17351836,62622636,26352735,
     7  28342833,27322733,26332534,25352636,62623436,34353835,39343932,
     8  38283328,33293433,34303830,38323733,34333334,33353436,62624236,
     9  42354335,44344433,43324333,42334134,41354236,63630000,19342033/
      DATA N190/
     1  20321931,18311532,14321331,12201219,13181517,19162515,35154116,
     2  45174718,48194820,47314632,45324231,41314032,40334134,62624027,
     3  39323934,40354336,48385140,55435441,53385234,53325431,56306029,
     4  55285127,48266262,45314630,46294428,40273426,26262027,16281429,
     5  14301531,62622027,21322134,20351736,12380940, 5430641, 7380834,
     6   7320631, 4300029, 5280927,12266262,15261821,22256262,18211818,
     7  62622217,24242624,28176262,23202720,62623124,31173717,62624526,
     8  39253918,45196262,39224523,63630000,21051806,16061808,20091911,
     9  19132012,23112310,22092208,24072906,31063607,38083809,37103711/
      DATA N253/
     1  40124113,41114009,42084406,42063905,62623808,38063903,38023601,
     2  31002900,24012202,21032206,22086262,23102308,62623710,37086262,
     3  23062504,25026262,25042706,62622701,28052905,30016262,28032903,
     4  62623105,31013401,62623706,34063402,37026262,34043604,62621809,
     5  17111712,18141815,16171515,15131611,18091511,13111010,11091308,
     6  14081609,18096262,14121314,13151417,14201322,12211119,11171214,
     7  14121214,10160817, 5170615, 7141113,14126262,10171019,11221224,
     8  12251127, 9250823, 8220919,10170919, 7220623, 3240224, 2230321,
     9   4200619, 9181017,62620723, 7251028,11311133, 9320730, 6270723/
      DATA N316/
     1   6270529, 4300132, 1300228, 4260625, 7236262, 6290732, 8331034,
     2  11351238,11380937, 7350633, 6290633, 5360438, 3390237, 2360334,
     3   5310629,62620636, 7380939,12401341,14431243,10420739, 6360739,
     4   7420645, 5460444, 4420540, 6366262, 8421144,12451347,13491148,
     5  10470945, 8426262, 8426262,42094311,43124214,42154417,45154513,
     6  44114209,45114711,50104909,47084608,44094209,62624612,47144715,
     7  46174620,47224821,49194917,48144612,48145016,52175517,54155314,
     8  49134612,62625017,50194922,48244825,49275125,52235222,51195017,
     9  51195322,54235724,58245823,57215620,54195118,50176262,53235325/
      DATA N379/
     1  50284931,49335132,53305427,53235427,55295630,59325930,58285626,
     2  54255323,62625429,53325233,50344935,48384938,51375335,54335429,
     3  54335536,56385739,58375836,57345531,54296262,54365338,51394840,
     4  47414643,48435042,53395436,53395342,54455546,56445642,55405436,
     5  62625242,49444845,47474749,49485047,51455242,62624553,47524851,
     6  47514550,46474645,45464347,38473748,37493850,39504248,43484449,
     7  44504351,40533554,25542053,17511650,16491748,18482150,22502349,
     8  23482247,17471546,14451447,15501351,12511352,15536262,22532349,
     9  62623853,37496262,44494555,45564457,40593560,25602059,16571556/
      DATA N442/
     1  15551649,62621656,16521753,62621857,18531954,19586262,20582255,
     2  62622054,22596262,25592459,24552555,62622457,25576262,26592859,
     3  62622759,27556262,30593155,32596262,34593359,33553455,62623357,
     4  34576262,35553559,36593657,35573655,62623759,37556262,38594058,
     5  62623958,39546262,41544158,42574253,62624156,42556262,44564357,
     6  43564453,44524353,62623010,28112414,22161920,18221725,16301645,
     7  44454430,43254222,41203816,36143211,30106262,22402041,20232921,
     8  29203120,31214023,40413840,62623741,39393924,31223121,29212922,
     9  21242139,23412440,29393038,31393640,37413726,36253124,30233022/
      DATA N505/
     1  30232924,24252326,23416262,23262124,62623726,39246262,30233038,
     2  62624038,41374237,43384236,41364037,62624237,41394140,43414240,
     3  42394338,62624028,41274227,43284226,41264027,62624227,41294130,
     4  43314230,42294328,62622028,19271827,17281826,19262027,62621827,
     5  19291930,17311830,18291728,62622038,19371837,17381836,19362037,
     6  62621837,19391940,17411840,18391738,62623636,35373637,36363434,
     7  34333533,34346262,34363437,36343633,34366262,33363237,33373333,
     8  62623236,31363037,31373236,32336262,29362837,29372933,62622836,
     9  27362637,27372836,28336262,27362733,26332734,62622635,25362436/
      DATA N568/
     1  25372636,26342533,24332534,26346262,24342437,23372436,62622431,
     2  26312730,27272527,25302431,62622530,27306262,25282728,62622831,
     3  29312930,28316262,31313331,34303427,32273230,31316262,32303430,
     4  62623228,34286262,35313631,36303531,63630000,       0,       0,
     5         0,       0,       0,       0,       0,       0,       0,
     6         0,       0,       0,       0,       0,       0,       0,
     7         0,       0,       0,       0,       0,       0,       0,
     8         0,       0,       0,       0,       0,       0,       0,
     9         0,       0,       0,       0,       0,       0,       0/
      DATA  KRDBGN          /001,189,243/
C
      CALL PENBGN(LASTX,LASTY,NEWX,NEWY)
      KSCALE=0.7*FACTOR/60.0
      MINX=OFSETX+(0.5*FACTOR)-(30.0*FLOAT(KSCALE))
      MINY=OFSETY+(0.5*FACTOR)-(30.0*FLOAT(KSCALE))
      DO 7 KODE=1,3
      INDEX=KRDBGN(KODE)
    1 NEWX=MINX+((N(INDEX)/1000000)*KSCALE)
      NEWY=MINY+(((N(INDEX)/10000)-((N(INDEX)/1000000)*100))*KSCALE)
      CALL PENUP(LASTX,LASTY,NEWX,NEWY)
      GO TO 6
    2 NEWX=MINX+(((N(INDEX)/100)-((N(INDEX)/10000)*100))*KSCALE)
      NEWY=MINY+((N(INDEX)-((N(INDEX)/100)*100))*KSCALE)
      INDEX=INDEX+1
      CALL PENUP(LASTX,LASTY,NEWX,NEWY)
      GO TO 4
    3 CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
    4 KOMPAR=N(INDEX)/1000000
      NEWX=MINX+(KSCALE*KOMPAR)
      NEWY=MINY+(((N(INDEX)/10000)-((N(INDEX)/1000000)*100))*KSCALE)
      IF(KOMPAR-62)5,2,7
    5 CALL PENDWN(LASTX,LASTY,NEWX,NEWY)
    6 KOMPAR=(N(INDEX)/100)-((N(INDEX)/10000)*100)
      NEWX=MINX+(KSCALE*KOMPAR)
      NEWY=MINY+((N(INDEX)-((N(INDEX)/100)*100))*KSCALE)
      INDEX=INDEX+1
      IF(KOMPAR-62)3,1,7
    7 CALL PENHLT(LASTX,LASTY,NEWX,NEWY)
      CALL PENEND(LASTX,LASTY,NEWX,NEWY)
      STOP
      END
