      SUBROUTINE NMBPLT(INDIC ,INDEX ,LINE ,FIGURE,KDECML,HEIGHT,XCORNR,
     1YCORNR,LASTX ,LASTY )
C                                                               10/17/67
C     NUMBER PLOTTING SUBROUTINE FOR GENERAL PLOTTING PACKAGE GENPLT-II
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE NMBPLT ARGUMENT LIST DEFINITIONS.
C
C     INDIC  = ANGLE OF BASELINE OF NUMBER IN DEGREES FROM HORIZONTAL.
C     INDIC CAN ONLY HAVE VALUES 0 AND 90 IF FONT1 IS USED.
C     INDEX  = 0 PLOTS LEFT END OF BASELINE OF NUMBER AT XCORNR YCORNR.
C     INDEX  = 1 CENTERS BASELINE OF NUMBER AT XCORNR, YCORNR.
C     INDEX  = 2 PLOTS RIGHT END OF BASELINE OF NUMBER AT XCORNR YCORNR.
C     LINE   = LINE UPON WHICH NUMBER IS TO BE PLOTTED.
C     LINE STARTING AT INPUT VALUES OF XCORNR AND YCORNR IS LINE = 1.
C     HIGHER VALUED LINES ARE OFFSET TO BE PLOTTED BELOW LINE NUMBER 1.
C     SPACING BETWEEN LINES IS 1.5 HEIGHT OF NUMBERS PLOTTED.
C     FIGURE = FLOATING POINT NUMBER TO BE PLOTTED.
C     KDECML = NUMBER OF DECIMAL PLACES TO BE PLOTTED.
C     KDECML = 0 GIVES FIGURE PLOTTED AS INTEGER.
C     HEIGHT = HEIGHT OF NUMBERS TO BE PLOTTED.
C     XCORNR = HORIZONTAL COORDINATE OF LETTERING BASELINE.  SEE INDEX.
C     YCORNR = VERTICAL COORDINATE OF LETTERING BASELINE.  SEE INDEX.
C     LASTX  = LAST X GRID COORDINATE PLOTTED.
C     LASTY  = LAST Y GRID COORDINATE PLOTTED.
C
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      DIMENSION NUM(12),NUMERL(12)
      DATA (NUMERL(I),I= 1,10) /1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
      DATA (NUMERL(I),I=11,12) /1H.,1H-/
C
C     **ROUND NUMBER TO BE PLOTTED TO DESIRED NUMBER OF DECIMAL PLACES**
      NUMBER=((ABS(FIGURE))+(5.0*(10.0**(-KDECML-1))))*(10.0**KDECML)
C
C     *************DETERMINE NUMBER OF DIGITS TO BE PLOTTED*************
      IF(NUMBER-10)2,1,1
    1 KLOG=ALOG10((FLOAT(NUMBER))+0.1)
      IF(KLOG-KDECML)2,2,3
    2 KOUNT=KDECML+1
      GO TO 4
    3 KOUNT=KLOG+1
C
C     *************DIVIDE NUMBER TO BE PLOTTED INTO DIGITS**************
    4 DO 5 J=1,KOUNT
    5 NUM(J)=(NUMBER/(10**(KOUNT-J)))-((NUMBER/(10**(KOUNT-J+1)))*10)+1
      IF(FIGURE)6,8,8
C
C     *********PLACE MINUS SIGN INTO ARRAY FOR NEGATIVE NUMBER**********
    6 DO 7 J=1,KOUNT
      N=KOUNT-J+1
    7 NUM(N+1)=NUM(N)
      KOUNT=KOUNT+1
      NUM(1)=12
    8 IF(KDECML)11,11,9
C
C     ******************PLACE DECIMAL POINT INTO ARRAY******************
    9 KOUNT=KOUNT+1
      DO 10 J=1,KDECML
      N=KOUNT-J
   10 NUM(N+1)=NUM(N)
      NUM(N)=11
C
C     **************CALCULATE GRID POSITION OF FIRST DIGIT**************
   11 KSCALE=HEIGHT*FACTOR/6.0
      KONTRL=INDIC-360*(INDIC/360)
      IF(KONTRL)16,13,12
   12 IF(KONTRL-90)15,14,15
   13 KONTRL=1
      ACOS=1.0
      ASIN=0.0
      GO TO 17
   14 KONTRL=2
      ACOS=0.0
      ASIN=1.0
      GO TO 17
   15 KONTRL=-360+KONTRL
   16 ANGLE=0.0174532925*FLOAT(KONTRL)
      ASIN=SIN(ANGLE)
      ACOS=COS(ANGLE)
   17 IF(INDEX)21,19,18
   18 IF(INDEX-2)19,19,21
   19 SHIFT=INDEX*((3*KSCALE*KOUNT)-KSCALE)
      LX7=(FACTOR*(XCORNR+(1.5*ASIN*HEIGHT*FLOAT(LINE-1))))-(ACOS*SHIFT)
     1+OFSETX
      LY7=(FACTOR*(YCORNR-(1.5*ACOS*HEIGHT*FLOAT(LINE-1))))-(ASIN*SHIFT)
     1+OFSETY
C
C     ***************************PLOT NUMBER****************************
      DO 20 J=1,KOUNT
      N=NUM(J)
      NUM(1)=NUMERL(N)
   20 CALL LTRPLT (NUM,1,1,KONTRL,KSCALE,LASTX,LASTY,LX7,LY7)
   21 RETURN
      END
