      SUBROUTINE  GRDPLT  (LINESX,LINESY,XFIRST,YFIRST,XFINAL,YFINAL,
     1XWIDTH,YWIDTH,XCORNR,YCORNR,LASTX ,LASTY )
C                                                               08/27/66
C     GRID PLOTTING SUBROUTINE FOR GENERAL PLOTTING PACKAGE GENPLT-II
C     SPACING OF THIS GRID MATCHES THAT OF SCALE MARKING DRAWN BY SCLPLT
C
C     DONALD BARTH, C/O K.B. WIBERG, DEPT. OF CHEMISTRY, YALE UNIVERSITY
C
C     SUBROUTINE GRDPLT ARGUMENT LIST DEFINITIONS
C
C     LINESX = NUMBER OF GRID DIVISIONS ALONG HORIZONTAL SCALE BETWEEN
C              CONSECUTIVE HORIZONTAL SCALE NUMBERS PLOTTED BY SCLPLT.
C     LINESY = NUMBER OF GRID DIVISIONS ALONG VERTICAL SCALE BETWEEN
C              CONSECUTIVE VERTICAL SCALE NUMBERS PLOTTED BY SCLPLT.
C              BORDER IS PLOTTED IF BOTH LINESX = 0 AND LINESY = 0.
C     XFIRST = LEFT LIMITING COORDINATE OF HORIZONTAL (X) SCALE.
C     YFIRST = LOWER LIMITING COORDINATE OF VERTICAL (Y) SCALE.
C     XFINAL = RIGHT LIMITING COORDINATE OF HORIZONTAL (X) SCALE.
C     YFINAL = UPPER LIMITING COORDINATE OF VERTICAL (Y) SCALE.
C     XWIDTH = HORIZONTAL PLOT WIDTH.
C     YWIDTH = VERTICAL PLOT WIDTH.
C     XCORNR = DISTANCE FROM PLOTTING TABLE ORIGIN TO LEFT PLOT EDGE.
C     YCORNR = DISTANCE FROM PLOTTING TABLE ORIGIN TO LOWER PLOT EDGE.
C     LASTX  = HORIZONTAL (X) GRID COORDINATE OF LAST POINT PLOTTED.
C     LASTY  = VERTICAL (Y) GRID COORDINATE OF LAST POINT PLOTTED.
      DIMENSION ADJUST(10)
      DATA (ADJUST(I),I=1,10)/1.,2.,2.,2.,4.,4.,4.,4.,4.,10./
       COMMON/PPARM/FACTOR,OFSETX,OFSETY,IERR,IPEN,NTAPE,MODE,IPOINT,
     1IFREER,ILINE
      MODE = IFREER
C
C     ************************INITIAL OPERATIONS************************
      XSCALE=FACTOR*XWIDTH/(XFINAL-XFIRST)
      YSCALE=FACTOR*YWIDTH/(YFINAL-YFIRST)
      MINX=XCORNR*FACTOR + OFSETX
      MAXX=(XWIDTH+XCORNR)*FACTOR+OFSETX
      MINY=YCORNR*FACTOR + OFSETY
      MAXY=(YWIDTH+YCORNR)*FACTOR+OFSETY
      IF(XFIRST-XFINAL)1,1,2
    1 SMALLX=MINX
      FIRSTX=XFIRST
      FINALX=XFINAL
      GO TO 3
    2 SMALLX=MAXX
      FIRSTX=XFINAL
      FINALX=XFIRST
    3 IF(YFIRST-YFINAL)4,4,5
    4 SMALLY=MINY
      FIRSTY=YFIRST
      FINALY=YFINAL
      GO TO 6
    5 SMALLY=MAXY
      FIRSTY=YFINAL
      FINALY=YFIRST
C
C     *************************PLOT SCALE LINES*************************
    6 IF(LINESX+LINESY)7,7,8
    7 CALL PENUP (LASTX,LASTY,MINX,MINY)
      CALL PENDWN(LASTX,LASTY,MAXX,MINY)
      CALL PENDWN(LASTX,LASTY,MAXX,MAXY)
      CALL PENDWN(LASTX,LASTY,MINX,MAXY)
      CALL PENDWN(LASTX,LASTY,MINX,MINY)
      RETURN
C
C     **********PLOT GRID LINES INTERSECTING HORIZONTAL SCALE***********
    8 IF(LINESX)25,25,9
    9 IF(FINALX-FIRSTX-2.0)11,10,10
   10 KDECML=0
      GO TO 15
   11 DO 13 J=1,11
      IF((10.0**J)*(FINALX-FIRSTX)- 2.0)13,12,12
   12 KDECML=J
      GO TO 14
   13 CONTINUE
      GO TO 25
   14 FIRSTX=FIRSTX*(10.0**KDECML)
      FINALX=FINALX*(10.0**KDECML)
      XSCALE=XSCALE/(10.0**KDECML)
   15 TENEXP=10.0**(AINT(ALOG10(FINALX-FIRSTX)))
      LFTDIG=(FINALX-FIRSTX)/TENEXP
      IF(LFTDIG)16,16,17
   16 LFTDIG=1
   17 STEP= 0.5*TENEXP*ADJUST(LFTDIG)
      JUMP=STEP+0.1
      STEP=STEP/FLOAT(LINESX)
      LFIRST=FIRSTX-1.0
      LFMULT=LFIRST/JUMP
      MULT=0
      IF(LFIRST)19,19,18
   18 KSTART=JUMP*LFMULT
      GO TO 20
   19 KSTART=JUMP*LFMULT-JUMP
   20 MULT=MULT+1
      XPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(XPOSN-(FIRSTX+.001*STEP))21,23,22
   21 IF(MULT-10*LINESX)20,20,25
   22 IF(XPOSN-(FINALX-.001*STEP))23,23,25
   23 LX=SMALLX+((XPOSN-FIRSTX)*XSCALE)
      CALL PENUP (LASTX,LASTY,LX,MINY)
      CALL PENDWN(LASTX,LASTY,LX,MAXY)
      MULT=MULT+1
      XPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(XPOSN-(FINALX-.001*STEP))24,24,25
   24 LX=SMALLX+((XPOSN-FIRSTX)*XSCALE)
      CALL PENUP (LASTX,LASTY,LX,MAXY)
      CALL PENDWN(LASTX,LASTY,LX,MINY)
      MULT=MULT+1
      XPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(MULT-10*LINESX)22,22,25
C
C     ***********PLOT GRID LINES INTERSECTING VERTICAL SCALE************
   25 IF(LINESY)42,42,26
   26 IF(FINALY-FIRSTY-2.0)28,27,27
   27 KDECML=0
      GO TO 32
   28 DO 30 J=1,11
      IF((10.0**J)*(FINALY-FIRSTY)- 2.0)30,29,29
   29 KDECML=J
      GO TO 31
   30 CONTINUE
      GO TO 42
   31 FIRSTY=FIRSTY*(10.0**KDECML)
      FINALY=FINALY*(10.0**KDECML)
      YSCALE=YSCALE/(10.0**KDECML)
   32 TENEXP=10.0**(AINT(ALOG10(FINALY-FIRSTY)))
      LFTDIG=(FINALY-FIRSTY)/TENEXP
      IF(LFTDIG)33,33,34
   33 LFTDIG=1
   34 STEP= 0.5*TENEXP*ADJUST(LFTDIG)
      JUMP=STEP+0.1
      STEP=STEP/FLOAT(LINESY)
      LFIRST=FIRSTY-1.0
      LFMULT=LFIRST/JUMP
      MULT=0
      IF(LFIRST)36,36,35
   35 KSTART=JUMP*LFMULT
      GO TO 37
   36 KSTART=JUMP*LFMULT-JUMP
   37 MULT=MULT+1
      YPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(YPOSN-(FIRSTY+.001*STEP))38,40,39
   38 IF(MULT-10*LINESY)37,37,42
   39 IF(YPOSN-(FINALY-.001*STEP))40,40,42
   40 LY=SMALLY+((YPOSN-FIRSTY)*YSCALE)
      CALL PENUP (LASTX,LASTY,MINX,LY)
      CALL PENDWN(LASTX,LASTY,MAXX,LY)
      MULT=MULT+1
      YPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(YPOSN-(FINALY-.001*STEP))41,41,42
   41 LY=SMALLY+((YPOSN-FIRSTY)*YSCALE)
      CALL PENUP (LASTX,LASTY,MAXX,LY)
      CALL PENDWN(LASTX,LASTY,MINX,LY)
      MULT=MULT+1
      YPOSN=(FLOAT(KSTART))+STEP*(FLOAT(MULT))
      IF(MULT-10*LINESY)39,39,42
C
C     ***************************GRID COMPLETED*************************
   42 RETURN
      END
