      BLOCK DATA
C     RENBR(RENBR/RENBR SYNTAX AND OPERATOR TABLES)
C
C     RRRRRRRRR  EEEEEEEEE  NNN   NNN  BBBBBBBBB  RRRRRRRRR
C     RRR   RRR  EEE        NNNN  NNN  BBB   BBB  RRR   RRR
C     RRRRRRR    EEEEEE     NNN N NNN  BBBBBBB    RRRRRRR
C     RRR  RRR   EEE        NNN  NNNN  BBB   BBB  RRR  RRR
C     RRR   RRR  EEEEEEEEE  NNN   NNN  BBBBBBBBB  RRR   RRR
C
C     THE FORTRAN RENUMBERING PROGRAM RENBR, JAN 1979
C
C     SEQUENTIALLY STATEMENT  NUMBERS  AND/OR  FORMS  CROSS
C     REFERENCE LISTINGS  OF FORTRAN PROGRAMS  READ AS DATA
C
C     THIS PROGRAM IS BASED UPON A  418  STATEMENT  PROGRAM
C     WHICH  WAS  IN  USE  AT  YALE  UNIVERSITY  IN 1965 OR
C     SHORTLY THEREAFTER.  THE ORIGINAL AUTHOR IS  UNKNOWN.
C     THE   CURRENT   VERSION  WAS  WRITTEN  AT  THE  AIKEN
C     COMPUTATION LABORATORY OF HARVARD UNIVERSITY, AND  AT
C     THE  HARVARD  BUSINESS SCHOOL BY DONALD E. BARTH, WHO
C     CAN BE REACHED AT THE FOLLOWING ADDRESS
C
C          BAKER LIBRARY 21
C          GRADUATE SCHOOL OF BUSINESS ADMINISTRATION
C          HARVARD UNIVERSITY
C          SOLDIERS FIELD
C          BOSTON, MASSACHUSETTS  02163
C
C     THE FOLLOWING FEATURES ARE SUPPORTED BY  THE  CURRENT
C     VERSION  OF  RENBR  BUT  WERE  NOT  SUPPORTED  BY THE
C     ORIGINAL VERSION.
C
C     A)  THE TREATMENT OF LOGICAL OPERATORS  AS  SEPARATOR
C         CHARACTERS
C     B)  THE TREATMENT  OF  ALPHAMERIC  STRINGS  AS  UNITS
C         WHICH CANNOT CONTAIN SEPARATOR CHARACTERS
C     C)  THE ABILITY TO HANDLE  TEXT  CONTAINING  THE  TAB
C         CHARACTER
C     D)  THE ABILITY TO ALLOW  STATEMENTS  TO BE SEPARATED
C         BY SEMICOLONS  AND TO  ALLOW  LEADING EXCLAMATION
C         POINTS TO MARK COMMENTS WITHIN THE STATEMENT TEXT
C     E)  ALL OF THE LISTING FEATURES
C
C     THE SUBROUTINE NAMED  REUSER  COMMUNICATES  WITH  THE
C     USER TO ESTABLISH OPTIONS AND FILE NAMES.  THE REUSER
C     ROUTINE  IS  MACHINE  DEPENDENT  AS  ARE  THE  RETEMP
C     ROUTINE  WHICH  OPENS AND CLOSES THE SCRATCH FILE AND
C     THE RECLOS ROUTINE WHICH  CLOSES  THE  OUTPUT  FILES.
C     THESE  ROUTINES  WILL HAVE TO BE REWRITTEN FOR USE ON
C     OTHER COMPUTER SYSTEMS.  SEVERAL VERSIONS  OF  REUSER
C     ARE  SUPPLIED  FOR  THE  DECSYSTEM-10.   THE  LONGEST
C     VERSION  ACCEPTS  A  TYPICAL   DECSYSTEM-10   COMMAND
C     CONSISTING  OF  THE  NAMES  OF  THE OUTPUT FILES WITH
C     ASSOCIATED SWITCHES, FOLLOWED BY AN  EQUAL  SIGN  AND
C     THEN  BY  THE  NAMES  OF  THE INPUT FILES.  A SHORTER
C     VERSION ACCEPTS A SINGLE LINE LIST OF  SWITCHES,  AND
C     ASKS  FOR  OUTPUT  AND INPUT FILE NAMES ON SUBSEQUENT
C     LINES.  FOR BATCH OPERATION, THE CALL TO  REUSER  CAN
C     BE REMOVED IF THE STATEMENTS WHICH DEFINE THE DEFAULT
C     SWITCHES PRIOR TO THE CALL TO REUSER ARE MODIFIED  TO
C     GIVE THE DESIRED RESULTS.
C
C     THE ONE READ  STATEMENT IN THE  RE1ST ROUTINE AND THE
C     FIRST TWO  READ STATEMENTS  IN THE  RE2ND ROUTINE USE
C     END-OF-FILE TESTS TO FORCE THE PRINTING OF A TABLE OF
C     CONTENTS AT THE END OF THE  LISTING.   THE  STATEMENT
C     NUMBER  AFTER  THE LETTERS ,END= IS TRANSFERRED TO IF
C     AN END-OF-FILE IS READ.  THE END OF  THE  INPUT  FILE
C     CAN  ALSO  BE  INDICATED  BY  AN  EXTRA  TERMINAL END
C     STATEMENT.
C
C     THIS PROGRAM IGNORES COLUMNS  73 THROUGH 80 WHICH ARE
C     SOMETIMES USED FOR CARD OR LINE SEQUENCE NUMBERS.
C
C     THE CRENBR COMMENT CONTROL LINE
C     SOME PROGRAMMERS SELECT STATEMENT NUMBERS USED WITHIN
C     A  LOGICAL  DIVISION  OF  A  PROGRAM FROM A DIFFERENT
C     RANGE THAN  THOSE  USED  ELSEWHERE  WITHIN  THE  SAME
C     PROGRAM.   RENBR  CAN  MAINTAIN  THESE  REGIONS  WHEN
C     RENUMBERING.   HOWEVER,   SINCE   A   SINGLE   NORMAL
C     RENUMBERING  WOULD  DESTROY  SUCH  REGIONS, A COMMAND
C     LINE WITHIN THE PROGRAM IS USED TO SPECIFY  THE  STEP
C     SIZE   RATHER   THAN   QUERYING  THE  USER  FOR  THIS
C     INFORMATION.  THIS COMMAND LINE  IS  A  COMMENT  LINE
C     WITH  C  IN  COLUMN  1 FOLLOWED BY THE WORD RENBR AND
C     THOSE SWITCHES FOR WHICH VALUES ARE BEING  SPECIFIED.
C     A TYPICAL COMMAND LINE WOULD BE
C     CRENBR I-10 B 10 O 200 N 400
C
C     THE SWITCHES ON THE CRENBR CONTROL LINE ARE
C     B = THE  BASE  NUMBER.   THE  NUMBER  FOLLOWING  THIS
C         SWITCH  WILL  BE THE SMALLEST GENERATED STATEMENT
C         NUMBER WHICH WILL APPEAR  WITHIN  THE  RENUMBERED
C         PROGRAM  OR  ROUTINE.  NORMALLY THIS WOULD BE THE
C         FIRST STATEMENT NUMBER IN THE RENUMBERED PROGRAM,
C         BUT  IF THE INCREMENT BETWEEN GENERATED STATEMENT
C         NUMBERS IS SPECIFIED TO  BE  NEGATIVE,  THEN  THE
C         BASE  NUMBER  WILL  BE  THE  NUMBER  OF THE FINAL
C         NUMBERED STATEMENT WITHIN THE PROGRAM.  IF THE  B
C         SWITCH  DOES  NOT APPEAR ON THE CRENBR LINE, THEN
C         THE VALUE USED AS THE BASE NUMBER  WILL  BE  THAT
C         SPECIFIED  BY THE USER WHEN RENBR WAS STARTED, OR
C         WILL BE  THE  ABSOLUTE  VALUE  OF  THE  STATEMENT
C         NUMBER  INCREMENT  IF  THE USER DID NOT SPECIFY A
C         BASE NUMBER WHEN RENBR WAS STARTED.
C     C = FOLLOWED BY NUMBER OF  CHARACTERS  IN  EXCESS  OF
C         USUAL  72  WHICH  ARE  TO  BE RETAINED IN FORTRAN
C         COMMENT  LINES.   /C:8  WOULD  ALLOW  80   COLUMN
C         COMMENT LINES.  THE /C SWITCH APPLIES ONLY TO THE
C         SUBSEQUENT COMMENT LINES, NOT THOSE ALREADY READ.
C     I = THE  STATEMENT  NUMBER  INCREMENT.   THE   NUMBER
C         FOLLOWING  THIS  SWITCH  WILL  BE  THE  INCREMENT
C         BETWEEN GENERATED STATEMENT NUMBERS.   IF  THE  I
C         SWITCH  DOES  NOT APPEAR ON THE CRENBR LINE, THEN
C         THE VALUE USED AS  THE  INCREMENT  WILL  BE  THAT
C         SPECIFIED  BY THE USER WHEN RENBR WAS STARTED, OR
C         WILL BE 1 IF THE USER DID NOT SPECIFY A STATEMENT
C         NUMBER INCREMENT WHEN RENBR WAS STARTED.
C     M = IF THE M SWITCH IS NOT FOLLOWED BY A NUMBER, THEN
C         STATEMENT  NUMBER PLATEAUS, AS INDICATED BY THE O
C         AND N SWITCHES, ARE MIXED.  THE M SWITCH WOULD BE
C         ISSUED  WITHOUT A FOLLOWING NUMBER IF THE SIZE OF
C         A  STATEMENT  NUMBER  INDICATES   THE   TYPE   OF
C         STATEMENT  RATHER THAN A LOGICAL SEGMENT.  IF THE
C         M SWITCH IS FOLLOWED BY EITHER 1  OR  2  NUMBERS,
C         THEN  THE O AND N SWITCHES ARE IGNORED IF ISSUED.
C         IF THE M SWITCH IS FOLLOWED BY A  SINGLE  NUMBER,
C         THEN ONLY STATEMENT NUMBERS GREATER THAN OR EQUAL
C         TO THE SPECIFIED NUMBER ARE RENUMBERED.  IF THE M
C         SWITCH  IS  FOLLOWED  BY  2  NUMBERS,  THEN  ONLY
C         STATEMENT NUMBERS  WHICH  ARE  IN  THE  SPECIFIED
C         RANGE ARE RENUMBERED.
C     N = THE NEW REGION SIZE.  THE NUMBER  FOLLOWING  THIS
C         SWITCH  SPECIFIES THE JUMP IN GENERATED STATEMENT
C         NUMBERS FROM THE START OF ONE REGION TO THE  NEXT
C         IN  THE RENUMBERED PROGRAM.  IF THE N SWITCH DOES
C         NOT APPEAR ON  THE  CRENBR  LINE,  THEN  THE  OLD
C         REGION  SIZE AS SPECIFIED BY THE O SWITCH IS ALSO
C         USED AS THE NEW REGION SIZE.
C     O = THE OLD REGION SIZE.  THE NUMBER  FOLLOWING  THIS
C         SWITCH   SPECIFIES   THE  JUMP  IN  THE  ORIGINAL
C         STATEMENT NUMBERS FROM THE START OF ONE REGION TO
C         THE   NEXT   IN   THE   PROGRAM  WHICH  IS  BEING
C         RENUMBERED.  IF THE O SWITCH DOES NOT  APPEAR  ON
C         THE  CRENBR  LINE,  THEN  THE  NEW REGION SIZE AS
C         SPECIFIED BY THE N SWITCH IS ALSO USED AS THE OLD
C         REGION SIZE.
C     R = THE  CHARACTER  WHICH  FOLLOWS  WILL BE  USED  IN
C         COMMENT LINES TO PRECEDE  NUMBERS WHICH ARE TO BE
C         KEPT PARALLEL  TO STATEMENT  NUMBERS  IN ORDINARY
C         FORTRAN  STATEMENTS  IN THE PROGRAM.   ANY NUMBER
C         MARKED BY THIS  CHARACTER ON A  COMMENT LINE WILL
C         BE REPLACED  BY THE  NEW VALUE  OF THE  STATEMENT
C         NUMBER HAVING THE SAME VALUE.
C     ( = THE CHARACTERS  WHICH FOLLOW,  THROUGH THE END OF
C         THE LINE,  OR TO THE  NEXT APPEARANCE  OF A RIGHT
C         PARENTHESIS  OR A SLASH,  ARE TO  BE USED  AS THE
C         ROUTINE NAME IN THE LISTING PAGE TITLES AND TABLE
C         OF CONTENTS.  THE FIRST 6 CHARACTERS WILL BE USED
C         IF MORE  THAN 6 CHARACTERS  ARE SPECIFIED  IN THE
C         NAME.   THE ( SWITCH  CAN BE  USED TO  LABEL MAIN
C         PROGRAMS  AND BLOCK  DATA  ROUTINES  EVEN  THOUGH
C         THESE WOULD  NOT NORMALLY  HAVE NAMES.   IF THE (
C         SWITCH IS NOT USED, THEN THE ROUTINE NAME WILL BE
C         THAT READ FROM THE  SUBROUTINE OR FUNCTION STATE-
C         MENT.  IF A SLASH APPEARS WITHIN THE PARENTHESES,
C         THEN THE  CHARACTERS  WHICH  FOLLOW,  THROUGH THE
C         MATCHING RIGHT  PARENTHESIS IF ANY,  WILL BE USED
C         AS THE SUBTITLE IN THE LISTING.   SUCH A SUBTITLE
C         CAN ITSELF CONTAIN PARENTHESES.
C     THE SWITCHES CAN APPEAR IN ANY ORDER  ON  THE  CRENBR
C     LINE.   ONLY  THE  I  SWITCH  WILL  ACCEPT A NEGATIVE
C     VALUE.  BLANKS OR TABS CAN APPEAR ANYWHERE AFTER  THE
C     INITIAL C OF THE CRENBR LINE, EXCEPT WITHIN NUMBERS.
C
C     THE VALUES SPECIFIED BY THE CRENBR LINE APPLY TO  ALL
C     THE  STATEMENT  NUMBERS  WITHIN A SINGLE PROGRAM, BUT
C     THE CRENBR LINE CAN APPEAR ANYWHERE  IN  THE  PROGRAM
C     BEFORE  THE  TERMINAL  END  STATEMENT.   IF  MULTIPLE
C     CRENBR  LINES  APPEAR  WITHIN  A  SINGLE  PROGRAM  OR
C     ROUTINE,   THE  VALUES  USED  ARE  THE  FINAL  VALUES
C     SPECIFIED FOR EACH SWITCH.  THE CRENBR  LINE  APPLIES
C     ONLY  TO  THE PROGRAM OR ROUTINE IN WHICH IT APPEARS.
C     THE DEFAULT VALUES OF THE SWITCHES (SET BY  THE  USER
C     WHEN  RENBR  WAS  STARTED)  ARE RESTORED FOR THE NEXT
C     PROGRAM OR ROUTINE READ.  IN THE CASE OF THE N AND  O
C     SWITCHES, THESE DEFAULTS ARE TO NOT PRESERVE REGIONS.
C
C     THE SAMPLE CRENBR LINE SHOWN ABOVE WOULD SPECIFY THAT
C     ORIGINAL  REGIONS 1-199, 200-399, 400-599 ETC.  WOULD
C     BE TRANSLATED TO REGIONS SUCH AS 1-399,  400-799  AND
C     800-1199.  THE ACTUAL TRANSLATION WOULD DEPEND ON THE
C     RELATIVE PLACEMENT  OF  THE  ORIGINAL  REGIONS.   FOR
C     EXAMPLE, USING THE ABOVE SAMPLE CRENBR SPECIFICATION,
C     THE STATEMENT NUMBER SEQUENCE
C     270  350  260  351   15    2    6  150   99 1600 1622
C     WOULD BE TRANSLATED TO THE FOLLOWING SEQUENCE
C     830  820  810  800  440  430  420  410  400   20   10
C     TO ALLOW ADDITION OF  NEW  STATEMENTS  TO  A  REGION,
C     STATEMENT NUMBERS WHICH WOULD NORMALLY BE OUTSIDE THE
C     REGION ARE TAKEN AS PART OF THE SURROUNDING REGION IF
C     STATEMENT  NUMBERS BOTH BEFORE AND AFTER THE ADDITION
C     ARE WITHIN  THE  REGION.   THEREFORE,  THE  STATEMENT
C     NUMBER SEQUENCE
C     270 8350 4260  351   15    2    6  150   99 1600 1622
C     WOULD BE RENUMBERED TO THE  SAME  SEQUENCE  AS  GIVEN
C     BEFORE.
C
C     THE RENBRSTART COMMAND LINE
C     THE FIRST   LINE  READ  AS  INPUT  AND THE FIRST LINE
C     FOLLOWING EACH FORTRAN END STATEMENT, ARE SCANNED FOR
C     THE APPEARANCE OF THE LETTERS RENBRSTART ANYWHERE  ON
C     THE  LINE.  THE LETTERS RENBRSTART CAN BE PRECEDED BY
C     ANY OTHER CHARACTERS AND CAN BE SEPARATED  BY  BLANKS
C     OR  TABS.   IF  THE LETTERS RENBRSTART ARE FOUND, THE
C     CURRENT LINE AND ALL FOLLOWING LINES THROUGH THE  END
C     OF THE FINAL INPUT FILE OR TO THE NEXT CRENBR COMMAND
C     LINE WILL BE TREATED AS COMMENT LINES.   THE NAME  TO
C     BE ASSOCIATED WITH THE CURRENT COMMENT SECTION, AND A
C     SUBTITLE FOR THE LISTING, CAN APPEAR TO THE RIGHT  OF
C     THE  LETTERS  RENBRSTART  IN THE FORMAT IN WHICH THIS
C     INFORMATION COULD APPEAR ON A  CRENBR  COMMAND  LINE.
C     ADDITIONAL RENBRSTART COMMAND LINES CAN APPEAR WITHIN
C     THE COMMENT SECTION TO FORCE THE PRINTING  OF  A  NEW
C     PAGE  WITH NEW NAME AND NEW SUBTITLE.  IF THE COMMENT
C     SECTION IS TERMINATED BY A CRENBR COMMAND LINE,  THEN
C     THIS  CRENBR COMMAND LINE IS CONSIDERED TO BE PART OF
C     THE FOLLOWING FORTRAN PROGRAM.
C
C     A RENBRTITLE  COMMAND LINE  CAN BE USED  FOR MUCH THE
C     SAME PURPOSE AS A  RENBRSTART COMMAND LINE.  THE ONLY
C     DIFFERENCE  BETWEEN  THESE TWO  COMMANDS  IS THAT THE
C     COMMAND RENBRTITLE  DOES NOT FORCE  A PAGE BREAK WHEN
C     IT IS ENCOUNTERED AND DOES NOT NECESSARILY CHANGE THE
C     SUBTITLE.
C
C     ************************************************
C     *                                              *
C     *  TO INCREASE INTERNAL STORAGE USED BY RENBR  *
C     *                                              *
C     ************************************************
C
C     TO INCREASE MAXIMUM NUMBER OF LINES IN 1 STATEMENT
C     1. INCREASE DIMENSION OF LTRBIG(2211) BY 110 FOR EACH
C        EXTRA LINE.  THIS IS 1 2/3 OF THE INCREASED NUMBER
C        OF CHARACTERS.   THE  2/3  PREVENTS  OVERLAP  WHEN
C        1 DIGIT NUMBERS IN  LIST ARE  CONVERTED TO 5 DIGIT
C        NUMBERS.
C     2. INCREASE VALUE OF  MID=891  BY  44  FOR EACH EXTRA
C        LINE.  THIS IS THE AMOUNT  A LINE OF SHORT NUMBERS
C        CAN  INCREASE  IN  LENGTH  WHEN  CHANGING  TO LONG
C        NUMBERS.
C     3. INCREASE DIMENSION OF INRSTR(21)  BY  1  FOR  EACH
C        EXTRA LINE
C     4. INCREASE VALUE OF MAXLIN=20 TO NEW NUMBER OF LINES
C
C     TO INCREASE MAXIMUM NUMBER OF STATEMENT NUMBERS
C     1. INCREASE  DIMENSION  OF  NOLD(1000) BY 1  FOR EACH
C        EXTRA NUMBER
C     2. INCREASE  DIMENSION  OF  NNEW(1000) BY 1  FOR EACH
C        EXTRA NUMBER
C     3. INCREASE VALUE OF IHIHDO=1000 TO NEW DIMENSION  OF
C        NOLD AND NNEW
C
C     TO INCREASE NUMBER OF ROUTINES IN 1 TABLE OF CONTENTS
C     1. INCREASE DIMENSION OF LTRTOC(168) BY  6  FOR  EACH
C        EXTRA ITEM
C     2. INCREASE DIMENSION OF NUMTOC(112) BY  4  FOR  EACH
C        EXTRA ITEM
C     3. INCREASE VALUE OF INITOC=28 TO NEW NUMBER OF ITEMS
C
C     TO INCREASE NUMBER OF CHARACTERS IN WORDS IN 1 INDEX
C     1. INCREASE DIMENSION OF LTRSPL(2000) BY 1  FOR  EACH
C        EXTRA CHARACTER
C     2. INCREASE VALUE OF MAXSPL=2000 TO NEW DIMENSION  OF
C        LTRSPL
C
C     TO INCREASE NUMBER OF WORDS IN 1 INDEX
C     1. INCREASE DIMENSION OF NUMPNT(5000).   5  LOCATIONS
C        ARE  NEEDED  FOR  EACH INITIAL APPEARANCE OF WORD,
C        AND 2 FOR EACH SUBSEQUENT APPEARANCE
C     2. INCREASE VALUE OF MAXPNT=5000 TO NEW DIMENSION  OF
C        NUMPNT
C
C     THE KEY PHRASES WHICH ARE TO BE CHANGED  TO  INCREASE
C     THE  STORAGE  USED  BY RENBR ARE LISTED BELOW.  THESE
C     LINES SHOULD BE CHECKED AFTER THE GLOBAL REPLACEMENTS
C     HAVE BEEN COMPLETED.
C
C     TO INCREASE MAXIMUM NUMBER OF LINES IN 1 STATEMENT
C         LTRBIG(2211)    INRSTR(21)    MAXLIN=20   MID=891
C     TO INCREASE MAXIMUM NUMBER OF STATEMENT NUMBERS
C         NOLD(1000)      NNEW(1000)    IHIHDO=1000
C     TO INCREASE NUMBER OF ROUTINES IN 1 TABLE OF CONTENTS
C         LTRTOC(168)     NUMTOC(112)   INITOC=28
C     TO INCREASE NUMBER OF CHARACTERS IN WORDS IN 1 INDEX
C         LTRSPL(2000)    MAXSPL=2000
C     TO INCREASE NUMBER OF WORDS IN 1 INDEX
C         NUMPNT(5000)    MAXPNT=5000
C
C     *****************************************************
C     *                                                   *
C     *                                                   *
C     *     CCCC   AAA   U   U  TTTTT  I   OOO   N   N    *
C     *    C      A   A  U   U    T    I  O   O  NN  N    *
C     *    C      AAAAA  U   U    T    I  O   O  N N N    *
C     *    C      A   A  U   U    T    I  O   O  N  NN    *
C     *     CCCC  A   A   UUU     T    I   OOO   N   N    *
C     *                                                   *
C     *                                                   *
C     *  THIS BLOCK DATA ROUTINE DEFINES SOME LOWER CASE  *
C     *  LETTERS  AND  SOME PUNCTUATION CHARACTERS WHICH  *
C     *  ARE NOT AVAILABLE ON ALL COMPUTER SYSTEMS.  THE  *
C     *  LOWER  CASE  LETTERS  CAN,  IN  ALL  CASES,  BE  *
C     *  REPLACED  BY  THE  CORRESPONDING   UPPER   CASE  *
C     *  LETTERS.  THE TAB CHARACTER AND ANY PUNCTUATION  *
C     *  MARKS WHICH ARE UNAVAILABLE  AND  WHICH  SELECT  *
C     *  OPTIONS  WHICH  ARE  NOT  SIMILARLY SELECTED BY  *
C     *  SOME OTHER CHARACTER  ON  THE  TARGET  COMPUTER  *
C     *  SYSTEM  CAN,  IN  GENERAL,  BE  REPLACED BY THE  *
C     *  SPACE (BLANK) CHARACTER, BUT IF THIS  DOES  NOT  *
C     *  WORK  THEN  THESE  SHOULD  BE  REPLACED BY SOME  *
C     *  OTHER CHARACTER WHICH HAS NO PREDEFINED MEANING  *
C     *  IN FORTRAN.                                      *
C     *                                                   *
C     *****************************************************
C
C     RESTRICTION
C     CONTINUATION LINES FOLLOWING A COMMENT LINE ARE TAKEN
C     AS A CONTINUATION OF THE COMMENT AND ARE WRITTEN INTO
C     THE OUTPUT UNCHANGED.  FOR THIS REASON, COMMENT LINES
C     CAN  SEPARATE  STATEMENTS, BUT CANNOT APPEAR WITHIN A
C     SINGLE STATEMENT.
C
C     RESTRICTION
C     A LINE WITH A NON-BLANK NON-TAB  NON-DIGIT  CHARACTER
C     OTHER  THAN  C  (WHICH  WOULD  INDICATE A COMMENT) IN
C     COLUMN 1 FOLLOWED BY A TAB, OR BY A NUMBER (FORMED OF
C     NO  MORE THAN 4 DIGITS) AND A TAB, OR BY 4 CHARACTERS
C     FORMED OF ANY COMBINATION  OF  BLANKS  AND/OR  DIGITS
C     WILL  BE  TAKEN AS A LEGAL FORTRAN STATEMENT.  IF THE
C     LINE  BEGINS  A  NEW  STATEMENT,  THEN  THE   INITIAL
C     CHARACTER  WILL  APPEAR IN THE OUTPUT AT THE START OF
C     EACH LINE OF THE STATEMENT INCLUDING ALL CONTINUATION
C     LINES   (WHETHER  OR  NOT  THE  CHARACTER  ORIGINALLY
C     APPEARED AT THE START OF THESE  CONTINUATION  LINES).
C     SOME  COMPILERS  REQUIRE  B,  D  OR  I IN COLUMN 1 TO
C     SPECIFY VARIABLE  TYPE.   ALSO,  DEC  PDP-10  FORTRAN
C     ALLOWS D IN COLUMN 1 TO INDICATE A DEBUGGING LINE THE
C     COMPILATION OF WHICH IS OPTIONAL.   IN  DEC  FORTRAN,
C     THE USE OF THE D AT THE START OF LINES WHICH CONTINUE
C     A DEBUGGING LINE IS ACCEPTABLE BUT NOT NECESSARY.
C
C     RESTRICTION
C     BLANKS ARE TRIMMED FROM THE RIGHT END OF LINES  PRIOR
C     TO   OUTPUT  REGARDLESS  OF  SYNTAX.   IF  ALPHAMERIC
C     STRINGS ARE SPECIFIED AS  THE  NUMBER  OF  CHARACTERS
C     FOLLOWED  BY  THE  LETTER H AND THE CHARACTERS OF THE
C     STRING, THEN LINES WHICH END  IN  ALPHAMERIC  STRINGS
C     CONTAINING  TERMINAL  BLANKS  WILL  HAVE THESE BLANKS
C     REMOVED.  THEREFORE, UNLESS  THE  OUTPUT  IS  WRITTEN
C     ONTO LINES, A STATEMENT SUCH AS
C         A=1H
C     SHOULD INSTEAD BE WRITTEN AS
C         A=' '
C
C     RESTRICTION
C     A SINGLE STATEMENT CAN BE CONTINUED ON NO  MORE  THAN
C     19  LINES.  UNLESS THE DIMENSIONS OF NOLD AND OF NNEW
C     AND THE VALUE  OF IHIHDO  (SEE  LATER  COMMENTS)  ARE
C     INCREASED,  A SINGLE PROGRAM CAN CONTAIN AT MOST 1000
C     NUMBERED STATEMENTS  (OR  25  LESS  THAN  THIS  IF  A
C     LISTING IS BEING MADE).
C
C     RESTRICTION
C     THE END STATEMENT AT THE END OF A PROGRAM MUST APPEAR
C     ON  A  SINGLE  LINE (ALTHOUGH THE LETTERS OF THE WORD
C     END CAN BE PRECEDED BY OR BE SEPARATED BY  BLANKS  OR
C     TABS).  THE INPUT CAN CONTAIN ANY NUMBER OF PROGRAMS,
C     EACH WITH ITS OWN END STATEMENT.  IF THE  END-OF-FILE
C     TEST  IN  A  READ  STATEMENT  IS  NOT  AVAILABLE,  AN
C     ADDITIONAL END STATEMENT, AFTER THE FINAL PROGRAM  IN
C     THE  INPUT,  CAN BE USED TO FORCE A NORMAL EXIT WHICH
C     INCLUDES PRINTING OF THE TABLE OF CONTENTS.
C
C     RESTRICTION
C     A LINE BEGINNING A NEW STATEMENT MUST HAVE ONE OF THE
C     FOLLOWING FORMATS.   IN THESE EXAMPLES,  COMMENTS CAN
C     ALSO BE INDICATED  BY AN INITIAL  ASTERISK AS WELL AS
C     BY AN INITIAL LETTER C.
C     A)  A LINE BEGINNING WITH A NON-TAB  CHARACTER  OTHER
C         THAN   C  FOLLOWED  BY  4  BLANKS  AND/OR  DIGITS
C         FOLLOWED IN COLUMN 6 BY A BLANK OR BY A ZERO.  IT
C         IS POSSIBLE FOR THE CHARACTER IN COLUMN 1 TO BE A
C         BLANK OR A DIGIT OF THE STATEMENT NUMBER.
C     B)  A LINE BEGINNING WITH A TAB FOLLOWED BY THE FIRST
C         CHARACTER  OF  THE  STATEMENT  WHICH  CANNOT BE A
C         DIGIT.
C     C)  A  LINE  BEGINNING  WITH  A   NON-TAB   NON-BLANK
C         NON-DIGIT  CHARACTER  OTHER  THAN C FOLLOWED BY A
C         TAB  FOLLOWED  BY  THE  FIRST  CHARACTER  OF  THE
C         STATEMENT.
C     D)  A LINE BEGINNING WITH A DIGIT OR  DIGITS  OF  THE
C         STATEMENT  NUMBER  FOLLOWED  BY A TAB FOLLOWED BY
C         THE FIRST CHARACTER OF THE STATEMENT.
C     E)  A  LINE  BEGINNING  WITH  A   NON-TAB   NON-BLANK
C         NON-DIGIT  CHARACTER OTHER THAN C FOLLOWED BY THE
C         DIGIT OR DIGITS OF THE STATEMENT NUMBER  FOLLOWED
C         BY  A  TAB FOLLOWED BY THE FIRST CHARACTER OF THE
C         STATEMENT.
C     IF (BLANK) REPRESENTS A BLANK, (TAB) REPRESENTS A TAB
C     AND (TEXT) REPRESENTS THE TEXT OF THE STATEMENT, THEN
C     THE FOLLOWING  ARE  TYPICAL  LINES  WHICH  START  NEW
C     STATEMENTS.
C         (BLANK)(BLANK)(BLANK)(BLANK)(BLANK)(BLANK)(TEXT)
C         (BLANK)(BLANK)(BLANK)(BLANK)(BLANK)0(TEXT)
C         D(BLANK)(BLANK)(BLANK)(BLANK)(BLANK)(TEXT)
C         D(BLANK)(BLANK)(BLANK)(BLANK)0(TEXT)
C         (BLANK)(BLANK)(BLANK)22(BLANK)(TEXT)
C         (BLANK)(BLANK)(BLANK)220(TEXT)
C         D(BLANK)(BLANK)22(BLANK)(TEXT)
C         D(BLANK)(BLANK)220(TEXT)
C         22(BLANK)(BLANK)(BLANK)(BLANK)(TEXT)
C         22(BLANK)(BLANK)(BLANK)0(TEXT)
C         D22(BLANK)(BLANK)(BLANK)(TEXT)
C         D22(BLANK)(BLANK)0(TEXT)
C         (TAB)(TEXT)
C         D(TAB)(TEXT)
C         22(TAB)(TEXT)
C         D22(TAB)(TEXT)
C
C     RESTRICTION
C     A CONTINUATION LINE MUST HAVE ONE  OF  THE  FOLLOWING
C     FORMATS.
C     A)  A  LINE  BEGINNING  WITH  A   NON-TAB   NON-DIGIT
C         CHARACTER  OTHER  THAN  C  FOLLOWED  BY  4 BLANKS
C         FOLLOWED  BY   A   NON-BLANK   NON-TAB   NON-ZERO
C         CHARACTER   WHICH   IS   IGNORED.    THE  INITIAL
C         CHARACTER CAN, OF COURSE, BE A BLANK.
C     B)  A  LINE  BEGINNING  WITH  A  TAB  FOLLOWED  BY  A
C         NON-ZERO DIGIT.
C     C)  A  LINE  BEGINNING  WITH  A   NON-TAB   NON-BLANK
C         NON-DIGIT  CHARACTER  OTHER  THAN C FOLLOWED BY A
C         TAB FOLLOWED BY A NON-ZERO DIGIT.
C     THE FOLLOWING ARE TYPICAL CONTINUATION LINES.
C         (BLANK)(BLANK)(BLANK)(BLANK)(BLANK)2(TEXT)
C         (BLANK)(BLANK)(BLANK)(BLANK)(BLANK)A(TEXT)
C         D(BLANK)(BLANK)(BLANK)(BLANK)2(TEXT)
C         D(BLANK)(BLANK)(BLANK)(BLANK)A(TEXT)
C         (TAB)2(TEXT)
C         D(TAB)2(TEXT)
C
C
C               MINIMUM LENGTH OF STORAGE ARRAYS.
C               ------- ------ -- ------- -------
C
C     EACH 72 CHARACTER LINE OF A FORTRAN STATEMENT (1-5 IN
C     NUMBER  FIELD,  6  IN CONTINUATION FIELD, AND 7-72 IN
C     STATEMENT FIELD) IS INITIALLY READ  INTO  THE  LTR120
C     ARRAY.  120 CHARACTERS ARE READ INTO THE LTR120 ARRAY
C     IF A COMMENT SECTION IS BEING PROCESSED.
C
C     CHARACTERS 7-72 OF THE LTR120 ARRAY ARE  COPIED  INTO
C     THE  UPPER END OF LTRBIG ARRAY FOR PROCESSING IF THIS
C     UPPER SECTION IS EMPTY OR IF CHARACTER 6  IS  NEITHER
C     BLANK  NOR ZERO.  TO ALLOW 19 CONTINUATION LINES, THE
C     UPPER SECTION OF THE LTRBIG ARRAY MUST HAVE A  LENGTH
C     OF  AT  LEAST  1+20*66  =  1321 LOCATIONS (COUNTING A
C     FINAL  LOCATION  WHICH  IS  INCLUDED  FOR  HISTORICAL
C     REASONS BUT WHICH SHOULD NO LONGER BE NECESSARY, PLUS
C     20 LINES OF 66 CHARACTERS).
C
C     THE  STATEMENT  IS  FINALLY  COPIED  INTO  THE  LOWER
C     SECTION  OF  THE  LTRBIG ARRAY WITH STATEMENT NUMBERS
C     BEING REPLACED WHEN FOUND.  THE  RESULTING  STATEMENT
C     CAN  BE  LONGER THAN THAT STORED IN THE UPPER SECTION
C     OF THE ARRAY.  AS THE MOST EXTREME EXAMPLE  OF  THIS,
C     GO  TO(1,2,3,  COULD  BECOME GO TO(99997,99998,99999,
C     HERE,  6  CHARACTERS  (5  DIGITS  AND  A  COMMA)  ARE
C     PRODUCED FOR EVERY 2 IN THE ORIGINAL STATEMENT.  1320
C     CHARACTERS (20 LINES) WILL HAVE  BEEN  PRODUCED  WHEN
C     440  CHARACTERS HAVE BEEN PROCESSED.  A LOWER SECTION
C     OF  880  LOCATIONS  (1320-440)  WOULD   PROTECT   THE
C     CHARACTERS  IN  THE UPPER SECTION UNTIL THEY HAD BEEN
C     PROCESSED.
C
C     6 ADDITIONAL LOCATIONS AT THE LOWER END OF THE  LOWER
C     SECTION  STORE  THE  NEW  STATEMENT NUMBER FIELD.  AN
C     ADDITIONAL 4 STORE THE LINE SEQUENCE NUMBER.
C
C     IN THE  RESET ROUTINE,  THE STATEMENT  LEFT=1 DEFINES
C     THE STARTING LOCATION OF THE LOWER  SECTION  AND  THE
C     STATEMENT  MID=891  DEFINES  THE  STARTING   LOCATION
C     (1+4+6+880) OF THE UPPER SECTION OF THE LTRBIG ARRAY.
C     THE  TOTAL  LENGTH  OF  THE  LTRBIG  ARRAY  IS   2211
C     LOCATIONS  (890  IN  LOWER  SECTION AND 1321 IN UPPER
C     SECTION).
C
C     STATEMENT NUMBERS ARE STORED IN  THE  NOLD  AND  NNEW
C     ARRAYS.  THE MINIMUM NUMBER OF LOCATIONS IN EITHER OF
C     THESE ARRAYS  IS  THE  MAXIMUM  NUMBER  OF  STATEMENT
C     NUMBERS  WHICH  CAN BE PRESENT IN A SINGLE PROGRAM OR
C     SUBPROGRAM.  THESE ARRAYS ALSO STORE STATEMENT NUMBER
C     REFERENCES FOR PRODUCTION OF LIST OF THESE.
C
C     IHIHDO VARIABLE SET AT START  OF  RESET ROUTINE  MUST
C     HAVE  SAME VALUE AS DIMENSION OF NOLD OR NNEW ARRAYS.
C     IHIHDO AND THE DIMENSIONS OF NOLD AND NNEW ARE SET TO
C     1000.   PROGRAMS WITH MORE STATEMENT NUMBERS THAN THE
C     VALUE OF IHIHDO ARE REJECTED.  HOWEVER, IF THE NUMBER
C     OF  STATEMENT  NUMBERS APPROACHES IHIHDO, THE LISTING
C     PROCESS WILL DUMP THE  CROSS-REFERENCE  TABLE  OFTEN.
C     IT  IS  SUGGESTED  THAT  IHIHDO AND THE NOLD AND NNEW
C     DIMENSIONS BE AT LEAST 50 LARGER THAN THE  NUMBER  OF
C     STATEMENT  NUMBERS  PRESENT  IN  A  SINGLE PROGRAM OR
C     SUBPROGRAM.
C
C     THE NUMPNT ARRAY  AND  THE  LTRSPL  ARRAY  STORE  ALL
C     INFORMATION  NECESSARY  FOR  GENERATION OF THE SYMBOL
C     INDEX.  THE DIMENSIONS OF  THESE  ARRAYS  (WHICH  ARE
C     ALSO  STORED  AS MAXPNT AND MAXSPL) ARE SUFFICIENT TO
C     ALLOW LISTING OF OVER 15  PAGES  OF  FORTRAN  PROGRAM
C     BETWEEN  GENERATION  OF  SECTIONS  OF  THE INDEX.  IF
C     LONGER  UNINTERRUPTED  LISTINGS  ARE  DESIRED,  THESE
C     DIMENSIONS  SHOULD  BE  INCREASED.   SINCE  THE  SAME
C     SYMBOL NAMES ARE USUALLY USED THROUGHOUT A PARTICULAR
C     PROGRAM, THE NUMBER OF PAGES OF UNINTERRUPTED LISTING
C     IS  MORE  THAN  PROPORTIONAL  TO THE  LENGTH OF THESE
C     ARRAYS.   THE TABLE OF STATEMENT REFERENCES AND INDEX
C     ARE  PRINTED  AT  END  OF  EACH  PROGRAM,   OR   WHEN
C     APPROPRIATE STORAGE FILLS.  NOTHING IS LOST EVEN WHEN
C     THE LISTING OF A SINGLE PROGRAM MUST  BE  INTERRUPTED
C     SEVERAL  TIMES FOR GENERATION OF SEPARATE PORTIONS OF
C     TABLE OR INDEX.  NUMBER OF PAGES WHICH CAN BE  LISTED
C     BEFORE   TABLE   OF   STATEMENT  REFERENCES  MUST  BE
C     GENERATED  WILL  DEPEND  ON  WHETHER  ARITHMETIC   OR
C     LOGICAL  IF  STATEMENTS  ARE  USED.  WITH THE LATTER,
C     THIS LIMIT IS ABOUT 25 PAGES.
C
C     THE NUMTOC ARRAY AND THE LTRTOC ARRAY ARE DIMENSIONED
C     LARGE  ENOUGH TO ALLOW LISTING OF 28 ROUTINES BETWEEN
C     THE GENERATION OF THE TABLE OF CONTENTS.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     START OF PARSING TABLE
C     DIMENSION NUMPRS(655)
      DIMENSION NUMPR1(100),NUM101(100),NUM201(100),
     1          NUM301(100),NUM401(100),NUM501(100),
     2          NUM601( 55)
      EQUIVALENCE (NUMPR1(1),NUMPRS(  1)),
     1            (NUM101(1),NUMPRS(101)),
     2            (NUM201(1),NUMPRS(201)),
     3            (NUM301(1),NUMPRS(301)),
     4            (NUM401(1),NUMPRS(401)),
     5            (NUM501(1),NUMPRS(501)),
     6            (NUM601(1),NUMPRS(601))
C     DIMENSION LTRPRS(331)
      DIMENSION LTRPR1(100),LTR101(100),LTR201(100),
     1          LTR301( 31)
      EQUIVALENCE (LTRPR1(1),LTRPRS(  1)),
     1            (LTR101(1),LTRPRS(101)),
     2            (LTR201(1),LTRPRS(201)),
     3            (LTR301(1),LTRPRS(301))
C     DIMENSION LWRPRS(331)
      DIMENSION LWRPR1(100),LWR101(100),LWR201(100),
     1          LWR301( 31)
      EQUIVALENCE (LWRPR1(1),LWRPRS(  1)),
     1            (LWR101(1),LWRPRS(101)),
     2            (LWR201(1),LWRPRS(201)),
     3            (LWR301(1),LWRPRS(301))
      DATA NUMPR1/  1,  1,  2, 51,  6,  1,  3,  4, 11,111,
     1              6,259,259, 16,476, 30,  0,  0, 21,  0,
     2              6,260,260,646, 26, 15,  0,  0, 31,  0,
     3              5,  0,  0, 36,  0,  2,  0,  0,501, 41,
     4              1,222,225, 46,106, 31,  0,  0,101,646,
     5              2,  0,  0, 56, 86, 10,258,258, 61, 71,
     6             26,  0,  0, 66,  0,  4,  0,  0,646,  0,
     7              2,  0,  0, 76,646, 29,236,240, 81,646,
     8             10,260,260,646, 61,  1,236,240, 91,406,
     9             10,260,260,646, 96, 11,  0,  0,101,  0/
      DATA NUM101/ 27,  0,  0,646,  0, 11,  0,  0,  1,  0,
     1             10,260,260,646,116,  6,  5, 19,136,146,
     2            156,166,176,211,226,231,236,241,251,266,
     3            276,281,286,406,  0,  1, 20, 25,391,141,
     4              1, 26, 31,396,406,  1, 32, 39,371,151,
     5              1, 40, 48,371,406,  1, 58, 61,601,161,
     6              1, 62, 66,401,406,  1, 67, 70,566,171,
     7              1, 71, 76,296,406,  1, 87, 92,296,181,
     8             29, 93, 97,546,186,  1, 98,104,371,191,
     9              1,110,114,561,196, 29,105,109,546,201/
      DATA NUM201/ 29, 81, 86,536,206, 29, 77, 80,531,406,
     1              1,115,118,296,216,  1,119,124,526,221,
     2              1,125,133,511,406,  1,142,145,456,406,
     3              1,146,152,296,406,  1,153,156,401,406,
     4              1,157,161,296,246,  1,169,173,391,406,
     5              1,174,177,376,256,  1,178,183,296,261,
     6              1,184,189,371,406,  1,190,197,371,271,
     7              1,198,207,371,406,  1,226,229,296,406,
     8              1,230,235,371,406,  1,241,245,291,406,
     9              1,306,315,381,296,  1,259,259,301,386/
      DATA NUM301/ 13,262,258,311,306, 13,266,258,311,321,
     1              7,  0,  0,316,  0, 12,  0,  0,321,  0,
     2             10,258,258,326,336,  2,  0,  0,331,336,
     3              4,  0,  0,336,  0,  1,250,253,351,341,
     4              1,246,249,351,346,  1,254,257,351,361,
     5              2,  0,  0,356,361,  4,  0,  0,361,  0,
     6             10,258,258,366,646,  7,  0,  0,336,  0,
     7              1,259,259,301,646,  1,297,305,381,296,
     8             10,258,258,386,646,  2,  0,  0, 66,646,
     9              1,218,221,396,296,  2,  0,  0, 66,646/
      DATA NUM401/  1,259,259,336,406, 25,  0,  0,411,646,
     1             10,260,260,646,416,  1, 49, 57,446,421,
     2              1,208,217,441,426, 19,134,141,451,431,
     3              1,162,168,436,646, 16,  0,  0,646,  2,
     4             16,  0,  0,646,  3, 16,  0,  0,646,  5,
     5             16,  0,  0,646,  4, 15,  0,  0,461,  0,
     6              2,  0,  0, 66,466,  3,259,259,471,646,
     7              2,  0,  0,501,646, 10,260,260,646,481,
     8              1,267,285,496,486,  1,286,296,496,491,
     9              1,316,331,496,646,  2,  0,  0,501,646/
      DATA NUM501/  4,  0,  0,506,  0,  1,258,258,496,646,
     1              2,  0,  0,516,646,  4,  0,  0,521,  0,
     2             10,258,258,511,646, 11,  0,  0,651,  0,
     3             28,  0,  0,101,  0, 28,  0,  0,541,  0,
     4              7,  0,  0, 96,  0, 28,  0,  0,551,  0,
     5              7,  0,  0,556,  0, 11,  0,  0,646,  0,
     6             16,  0,  0,646,  6, 11,  0,  0,571,  0,
     7             10,261,261,576,646,  7,  0,  0,581,  0,
     8             11,  0,  0,586,  0, 10,261,261,591,651,
     9              7,  0,  0,596,  0, 15,  0,  0,571,  0/
      DATA NUM601/ 11,  0,  0,606,  0,  3,259,259,611,646,
     1              7,  0,  0,616,  0,  1,263,263,631,621,
     2              1,265,265,631,626,  1,264,264,631,641,
     3              2,  0,  0,636,641,  4,  0,  0,641,  0,
     4             10,258,258,611,646,  9,  0,  0,  0,  0,
     5              8,  0,  0,  0,  0/
      DATA LTRPR1/1HD,1HO,1HI,1HF,1HA,1HB,1HC,1HD,1HE,1HF,
     1            1HG,1HI,1HO,1HP,1HR,1HS,1HT,1HU,1HW,1HA,
     2            1HC,1HC,1HE,1HP,1HT,1HA,1HS,1HS,1HI,1HG,
     3            1HN,1HB,1HA,1HC,1HK,1HF,1HI,1HL,1HE,1HB,
     4            1HA,1HC,1HK,1HS,1HP,1HA,1HC,1HE,1HB,1HL,
     5            1HO,1HC,1HK,1HD,1HA,1HT,1HA,1HC,1HA,1HL,
     6            1HL,1HC,1HL,1HO,1HS,1HE,1HD,1HA,1HT,1HA,
     7            1HD,1HE,1HC,1HO,1HD,1HE,1HE,1HL,1HS,1HE,
     8            1HE,1HL,1HS,1HE,1HI,1HF,1HE,1HN,1HC,1HO,
     9            1HD,1HE,1HE,1HN,1HD,1HD,1HO,1HE,1HN,1HD/
      DATA LTR101/1HF,1HI,1HL,1HE,1HE,1HN,1HD,1HI,1HF,1HE,
     1            1HN,1HT,1HR,1HY,1HF,1HI,1HN,1HD,1HF,1HO,
     2            1HR,1HM,1HA,1HT,1HF,1HR,1HE,1HQ,1HU,1HE,
     3            1HN,1HC,1HY,1HF,1HU,1HN,1HC,1HT,1HI,1HO,
     4            1HN,1HG,1HO,1HT,1HO,1HI,1HN,1HQ,1HU,1HI,
     5            1HR,1HE,1HO,1HP,1HE,1HN,1HP,1HR,1HI,1HN,
     6            1HT,1HP,1HR,1HO,1HG,1HR,1HA,1HM,1HP,1HU,
     7            1HN,1HC,1HH,1HR,1HE,1HA,1HD,1HR,1HE,1HR,
     8            1HE,1HA,1HD,1HR,1HE,1HW,1HI,1HN,1HD,1HS,
     9            1HK,1HI,1HP,1HF,1HI,1HL,1HE,1HS,1HK,1HI/
      DATA LTR201/1HP,1HR,1HE,1HC,1HO,1HR,1HD,1HS,1HU,1HB,
     1            1HR,1HO,1HU,1HT,1HI,1HN,1HE,1HT,1HA,1HP,
     2            1HE,1HT,1HH,1HE,1HN,1HT,1HY,1HP,1HE,1HU,
     3            1HN,1HL,1HO,1HA,1HD,1HW,1HH,1HI,1HL,1HE,
     4            1HW,1HR,1HI,1HT,1HE,1HE,1HN,1HD,1H=,1HE,
     5            1HR,1HR,1H=,1HF,1HM,1HT,1H=,1H,,1H(,1H=,
     6            1H/,1H',1H*,1H$,1H&,1H#,1HA,1HC,1HC,1HU,
     7            1HM,1HU,1HL,1HA,1HT,1HO,1HR,1HO,1HV,1HE,
     8            1HR,1HF,1HL,1HO,1HW,1HD,1HI,1HV,1HI,1HD,
     9            1HE,1HC,1HH,1HE,1HC,1HK,1HI,1HN,1HP,1HU/
      DATA LTR301/1HT,1HT,1HA,1HP,1HE,1HO,1HU,1HT,1HP,1HU,
     1            1HT,1HT,1HA,1HP,1HE,1HQ,1HU,1HO,1HT,1HI,
     2            1HE,1HN,1HT,1HO,1HV,1HE,1HR,1HF,1HL,1HO,
     3            1HW/
      DATA LWRPR1/1Hd,1Ho,1Hi,1Hf,1Ha,1Hb,1Hc,1Hd,1He,1Hf,
     1            1Hg,1Hi,1Ho,1Hp,1Hr,1Hs,1Ht,1Hu,1Hw,1Ha,
     2            1Hc,1Hc,1He,1Hp,1Ht,1Ha,1Hs,1Hs,1Hi,1Hg,
     3            1Hn,1Hb,1Ha,1Hc,1Hk,1Hf,1Hi,1Hl,1He,1Hb,
     4            1Ha,1Hc,1Hk,1Hs,1Hp,1Ha,1Hc,1He,1Hb,1Hl,
     5            1Ho,1Hc,1Hk,1Hd,1Ha,1Ht,1Ha,1Hc,1Ha,1Hl,
     6            1Hl,1Hc,1Hl,1Ho,1Hs,1He,1Hd,1Ha,1Ht,1Ha,
     7            1Hd,1He,1Hc,1Ho,1Hd,1He,1He,1Hl,1Hs,1He,
     8            1He,1Hl,1Hs,1He,1Hi,1Hf,1He,1Hn,1Hc,1Ho,
     9            1Hd,1He,1He,1Hn,1Hd,1Hd,1Ho,1He,1Hn,1Hd/
      DATA LWR101/1Hf,1Hi,1Hl,1He,1He,1Hn,1Hd,1Hi,1Hf,1He,
     1            1Hn,1Ht,1Hr,1Hy,1Hf,1Hi,1Hn,1Hd,1Hf,1Ho,
     2            1Hr,1Hm,1Ha,1Ht,1Hf,1Hr,1He,1Hq,1Hu,1He,
     3            1Hn,1Hc,1Hy,1Hf,1Hu,1Hn,1Hc,1Ht,1Hi,1Ho,
     4            1Hn,1Hg,1Ho,1Ht,1Ho,1Hi,1Hn,1Hq,1Hu,1Hi,
     5            1Hr,1He,1Ho,1Hp,1He,1Hn,1Hp,1Hr,1Hi,1Hn,
     6            1Ht,1Hp,1Hr,1Ho,1Hg,1Hr,1Ha,1Hm,1Hp,1Hu,
     7            1Hn,1Hc,1Hh,1Hr,1He,1Ha,1Hd,1Hr,1He,1Hr,
     8            1He,1Ha,1Hd,1Hr,1He,1Hw,1Hi,1Hn,1Hd,1Hs,
     9            1Hk,1Hi,1Hp,1Hf,1Hi,1Hl,1He,1Hs,1Hk,1Hi/
      DATA LWR201/1Hp,1Hr,1He,1Hc,1Ho,1Hr,1Hd,1Hs,1Hu,1Hb,
     1            1Hr,1Ho,1Hu,1Ht,1Hi,1Hn,1He,1Ht,1Ha,1Hp,
     2            1He,1Ht,1Hh,1He,1Hn,1Ht,1Hy,1Hp,1He,1Hu,
     3            1Hn,1Hl,1Ho,1Ha,1Hd,1Hw,1Hh,1Hi,1Hl,1He,
     4            1Hw,1Hr,1Hi,1Ht,1He,1He,1Hn,1Hd,1H=,1He,
     5            1Hr,1Hr,1H=,1Hf,1Hm,1Ht,1H=,1H,,1H(,1H=,
     6            1H/,1H',1H*,1H$,1H&,1H#,1Ha,1Hc,1Hc,1Hu,
     7            1Hm,1Hu,1Hl,1Ha,1Ht,1Ho,1Hr,1Ho,1Hv,1He,
     8            1Hr,1Hf,1Hl,1Ho,1Hw,1Hd,1Hi,1Hv,1Hi,1Hd,
     9            1He,1Hc,1Hh,1He,1Hc,1Hk,1Hi,1Hn,1Hp,1Hu/
      DATA LWR301/1Ht,1Ht,1Ha,1Hp,1He,1Ho,1Hu,1Ht,1Hp,1Hu,
     1            1Ht,1Ht,1Ha,1Hp,1He,1Hq,1Hu,1Ho,1Ht,1Hi,
     2            1He,1Hn,1Ht,1Ho,1Hv,1He,1Hr,1Hf,1Hl,1Ho,
     3            1Hw/
C     END OF PARSING TABLE
C
      DATA
     1LTRLFT/1H(/,LTRRIT/1H)/,LTREXC/1H!/,LTRSEM/1H;/,
     2LTRQOT/1H'/,LTRMNS/1H-/,LTRSLA/1H//,LTREQL/1H=/,
     3LTRPLS/1H+/,LTRCLN/1H:/,LTRDOT/1H./
      DATA LTRSPC/1H /,LTRTAB/1H	/
      DATA LTREND/1HE,1HN,1HD/,
     1     LWREND/1He,1Hn,1Hd/
      DATA LTRKEY/1HR,1HE,1HN,1HB,1HR/,
     1     LWRKEY/1Hr,1He,1Hn,1Hb,1Hr/
      DATA LTRBGN/1HS,1HT,1HA,1HR,1HT/,
     1     LWRBGN/1Hs,1Ht,1Ha,1Hr,1Ht/
      DATA LTRTTL/1HT,1HI,1HT,1HL,1HE/,
     1     LWRTTL/1Ht,1Hi,1Ht,1Hl,1He/
      DATA LTRFLG/1HR,1HC,1HA,1HB,1HI,1HN,1HO,1HM/,
     1     LWRFLG/1Hr,1Hc,1Ha,1Hb,1Hi,1Hn,1Ho,1Hm/
      DATA LTRABC/1HA,1HB,1HC,1HD,1HE,1HF,1HG,1HH,1HI,1HJ,
     1            1HK,1HL,1HM,1HN,1HO,1HP,1HQ,1HR,1HS,1HT,
     2            1HU,1HV,1HW,1HX,1HY,1HZ/
      DATA LWRABC/1Ha,1Hb,1Hc,1Hd,1He,1Hf,1Hg,1Hh,1Hi,1Hj,
     1            1Hk,1Hl,1Hm,1Hn,1Ho,1Hp,1Hq,1Hr,1Hs,1Ht,
     2            1Hu,1Hv,1Hw,1Hx,1Hy,1Hz/
      DATA LTRDGT/1H0,1H1,1H2,1H3,1H4,1H5,1H6,1H7,1H8,1H9/
      DATA LTRDDD/1HD/,LWRDDD/1Hd/
      DATA LTREEE/1HE/,LWREEE/1He/
      DATA LTRHHH/1HH/,LWRHHH/1Hh/
      DATA LTRTYP/1HN,1HO,1HN,1HF,1HO,1HR,1HT,1HR,1HA,1HN,
     11HM,1HA,1HI,1HN,1H ,1HP,1HR,1HO,1HG,1HR,1HA,1HM,
     21HS,1HU,1HB,1HR,1HO,1HU,1HT,1HI,1HN,1HE,
     31HF,1HU,1HN,1HC,1HT,1HI,1HO,1HN,
     41HB,1HL,1HO,1HC,1HK,1H ,1HD,1HA,1HT,1HA,
     51HE,1HN,1HT,1HR,1HY/
      DATA NUMTYP/1,11,23,33,41,51,56/
C
C     CHARACTERS WHICH IN COLUMN 1 INDICATE COMMENT LINE
      DATA LTRCOM/1HC,1Hc,1H*,1H!,1H$,1H//
      DATA MAXCOM/6/
C
C     NUMPRS AND LTRPRS ARE  THE ARRAYS WHICH DRIVE  SYNTAX
C     RECOGNITION PROCESS.   EACH ENTRY IN THE NUMPRS ARRAY
C     CONSISTS OF 5 LOCATIONS.  THE FIRST OF THESE  SELECTS
C     THE  OPERATION TO BE PERFORMED.  THE FOURTH AND FIFTH
C     LOCATIONS CONTAIN THE SUBSCRIPT OF THE FIRST LOCATION
C     OF  THE ENTRY TO BE PERFORMED NEXT IN CASE OF SUCCESS
C     OR,  IF  THE   OPERATION   WAS   A   TEST,   FAILURE,
C     RESPECTIVELY.  THE SECOND AND THIRD LOCATIONS CONTAIN
C     THE FIRST AND FINAL SUBSCRIPTS OF THE CHARACTERS OF A
C     WORD  TO BE MATCHED  IN THE LTRPRS  ARRAY, OR CONTAIN
C     THE  SUBSCRIPTS OF 2 CHARACTERS, EITHER ONE OF  WHICH
C     CAN BE MATCHED.
C
C     FOUR POINTERS ARE CONTROLLED  BY  THE  SYNTAX  TABLE.
C     JIN  IS  MOVED IRREVERSIBLY THROUGH THE STATEMENT AND
C     POINTS TO THE FIRST CHARACTER NOT YET  COPIED.   JSTN
C     POINTS  TO THE FIRST CHARACTER FOLLOWING A SUCCESSFUL
C     MATCH AND IS RETURNED  TO  JIN  IF  THE  MATCH  IS  A
C     FAILURE (EXCEPT FOR OPERATION 6 WHICH DOES NOT CHANGE
C     THE VALUE OF JSTN).  KSTN AND ISTN ARE SET ONLY BY  A
C     SUCCESSFUL  TEST FOR A NUMBER STARTING AT JSTN.  KSTN
C     IS LEFT POINTING TO THE FIRST DIGIT OF THE NUMBER AND
C     ISTN  AT  THE  NEXT  CHARACTER  FOLLOWING THE NUMBER.
C     ISTN AND JSTN ARE THEN EQUAL UNTIL THE NEXT TEST.  IT
C     IS POSSIBLE TO TEST THE CHARACTERS FOLLOWING A NUMBER
C     AND THEN RETURN TO THAT NUMBER TO REPLACE IT IF IT IS
C     VERIFIED TO BE A STATEMENT NUMBER.
C
C     IT SHOULD BE NOTED  THAT ONLY  FUNCTIONS 1, 6, 29 AND
C     RANGE 17 THRU 24 CAN MATCH  BOTH UPPER CASE AND LOWER
C     CASE  LETTERS.   FUNCTION 13  COULD TEST  FOR A FIRST
C     CHARACTER WHICH IS A LETTER, BUT IS NOT USED FOR THIS
C     PURPOSE AND  SO HAS  NOT BEEN  CONVERTED  TO TEST FOR
C     BOTH UPPER AND LOWER CASES.
C
C     THE FUNCTIONS PROVIDED ARE AS FOLLOW
C     1)  TEST IF NON-BLANK  CHARACTERS  STARTING  AT  JSTN
C         MATCH WORD CONTAINED IN LTRPRS ARRAY. IF SUCCESS,
C         COPY MATCHED WORD AND LEAVE JIN AND JSTN POINTING
C         TO FIRST CHARACTER BEYOND MATCHED WORD.
C     2)  TEST IF CHARACTERS STARTING AT JSTN ARE A NUMBER.
C         IF SO, PLACE THE VALUE OF NUMBER INTO NUM.
C     3)  TEST WHICH  OF THE  2 CHARACTERS IN  LTRPRS ARRAY
C         IS ENCOUNTERED FIRST AS A FORTRAN OPERATOR AT  OR
C         FOLLOWING THE CHARACTER POINTED TO BY JSTN.  TEST
C         IS CONSIDERED SUCCESSFUL  ONLY IF FIRST CHARACTER
C         IS ENCOUNTERED FIRST.   THE FORTRAN OPERATORS + -
C         * / = , ( AND ) CAN BE TESTED FOR.
C     4)  REPLACE OLD  STATEMENT  NUMBER  WITH  NEW,  FIRST
C         COPYING  ALL  LOCATIONS UP TO KSTN.  JIN AND JSTN
C         ARE LEFT AT ISTN.
C     5)  COPY CHARACTERS STARTING  AT  JIN  UNTIL  END  OF
C         EXPRESSION (AS INDICATED BY PARENTHESES COUNTING)
C         HAS BEEN COPIED.  JIN AND JSTN ARE LEFT  POINTING
C         TO NEXT CHARACTER BEYOND EXPRESSION.
C     6)  TEST IF NEXT NON-BLANK CHARACTER IS ANY OF  THOSE
C         IN  WORD IN  LTRPRS ARRAY.   VALUE OF JSTN IS NOT
C         CHANGED.  THIS FUNCTION HAS A SUCCESS DESTINATION
C         FOR EACH POSSIBLE CHARACTER, AND A SINGLE FAILURE
C         DESTINATION.  NUMBER OF LOCATIONS IN NUMPRS ARRAY
C         NEEDED TO STORE  THIS FUNCTION  IS WHOLE MULTIPLE
C         OF 5  WHICH IS  EQUAL TO  OR GREATER  THAN 4 PLUS
C         NUMBER OF CHARACTERS TO BE TESTED.
C     7)  COPY CHARACTERS FROM JIN TO (BUT  NOT  INCLUDING)
C         JSTN.  JIN IS LEFT POINTING AT JSTN.
C     8)  TURN OFF STORAGE IN SYMBOL DICTIONARY AND  OUTPUT
C         (COPY) REST OF STATEMENT.
C     9)  OUTPUT (COPY) REST OF STATEMENT.
C     10) TEST WHICH OF 2 CHARACTERS IN THE LTRPRS ARRAY IS
C         ENCOUNTERED  FIRST AS  A FORTRAN  OPERATOR  AT OR
C         FOLLOWING THE CHARACTER  POINTED TO BY JSTN WHILE
C         THE PARENTHESIS  COUNT IS BALANCED.   THE TEST IS
C         CONSIDERED SUCCESSFUL ONLY IF THE FIRST CHARACTER
C         IS ENCOUNTERED FIRST  WHILE THE PARENTHESIS COUNT
C         IS BALANCED  (MEANING THAT EACH  LEFT PARENTHESIS
C         WHICH HAS BEEN ENCOUNTERED HAS BEEN BALANCED BY A
C         FOLLOWING RIGHT PARENTHESIS).  TEST IS TERMINATED
C         AS FAILURE IF THE PARENTHESIS COUNT GOES NEGATIVE
C         (MORE RIGHT  THAN LEFT PARENTHESES  ENCOUNTERED).
C         ONLY THE SEPARATOR CHARACTERS +  - * / = , CAN BE
C         SEARCHED FOR AS FORTRAN OPERATORS.  TYPE 3 SEARCH
C         MUST BE USED TO TEST  FOR PARENTHESES THEMSELVES.
C     11) STORE  PRESENTLY   COPIED   SYMBOLS   IN   SYMBOL
C         DICTIONARY.  BLANKS ARE COMPRESSED OUT OF SYMBOLS
C         EXCEPT WITHIN ALPHAMERIC STRINGS.
C     12) STORE IN  SYMBOL DICTIONARY THE  PRESENTLY COPIED
C         SYMBOLS LESS THE LAST CHARACTER,  AND PREVENT THE
C         INDEXING OF THE EXCLUDED CHARACTER.
C     13) SAME AS OPERATION 10,  EXCEPT THAT  FOR A SUCCESS
C         THE  FIRST  CHARACTER  MUST  APPEAR  IN A  SYMBOL
C         WHICH IS NEITHER  FORTRAN OPERATOR NOR ALPHAMERIC
C         STRING BEFORE THE END OF THE EXPRESSION OR BEFORE
C         THE SECOND CHARACTER APPEARS AS FORTRAN OPERATOR.
C     14) RETURN JSTN  TO JIN AS  THOUGH  THERE HAD  BEEN A
C         FAILURE.  USED WHEN A SEARCH HAS BEEN SUCCESSFUL,
C         BUT THE NEXT SEARCH IS TO LOOK AT ENTIRE UNCOPIED
C         PORTION OF STATEMENT.
C     15) INDICATE THAT ALL COPIED CHARACTERS HAVE BEEN PUT
C         INTO DICTIONARY WHETHER THEY HAVE OR NOT.
C     16) INSERT UNCOPIED CHARACTERS STARTING AT JIN TO THE
C         FOLLOWING LEFT PARENTHESIS OR TO END OF LINE INTO
C         TABLE OF CONTENTS WITH  PROGRAM TYPE INDICATED BY
C         NUMBER IN  UNSUCCESSFUL  FIELD (NOT  NEEDED FOR A
C         DESTINATION SINCE THIS OPERATION CANNOT FAIL).
C     17-24) TEST IF WORD  APPEARS ANYWHERE WHILE THE COUNT
C         OF PARENTHESES IS ZERO, BUT IN NEITHER ALPHAMERIC
C         STRING NOR OPERATOR.  IF SUCCESSFUL, JSTN IS LEFT
C         POINTING TO NEXT CHARACTER.  THOSE ITEMS ALLOWING
C         A PREFIX CAN  BE EMBEDDED  IN OTHER  NON-OPERATOR
C         CHARACTERS.
C
C         NUMPRS(IBR)   STOP AT              PREFIX ALLOWED
C         17     END OF LINE                            YES
C         18     1ST NON-PARENTHESIS OPERATOR           YES
C         19     LEFT PARENTHESIS                       YES
C         20     1ST OPERATOR                           YES
C         21     END OF LINE                             NO
C         22     1ST NON-PARENTHESIS OPERATOR            NO
C         23     LEFT PARENTHESIS                        NO
C         24     1ST OPERATOR                            NO
C
C     25) TEST IF CURRENT  STATEMENT  IS FIRST  IN PROGRAM.
C         VALUE OF JSTN  IS NOT  CHANGED  EVEN FOR FAILURE.
C     26) INSERT  CURRENT  STATEMENT  NUMBER  STORED AS NUM
C         INTO THE LIST OF DO LOOP TERMINATORS.  SUBSEQUENT
C         STATEMENTS WILL BE INDENTED AN EXTRA LEVEL.
C     27) ADD AN EXTRA LEVEL  OF  INDENTATION  TO  LEFT  OF
C         SUBSEQUENT  STATEMENTS.  INDENTATION INCREMENT IS
C         THAT SPECIFIED BY USER TO RIGHT OF /A SWITCH.
C     28) REMOVE  A  LEVEL  OF  INDENTATION  TO   LEFT   OF
C         SUBSEQUENT   STATEMENTS.   IF  NOTHING  HAS  BEEN
C         COPIED IN CURRENT  STATEMENT,  THEN  A  LEVEL  OF
C         INDENTATION  IS  REMOVED  FROM  LEFT  OF  CURRENT
C         STATEMENT ALSO.  INDENTATION  INCREMENT  IS  THAT
C         SPECIFIED BY USER TO RIGHT OF /A SWITCH.
C     29) TEST IF NON-BLANK  CHARACTERS  STARTING  AT  JSTN
C         MATCH   WORD   CONTAINED  IN  LTRPRS  ARRAY.   IF
C         SUCCESS, JSTN IS LEFT POINTING  TO  CHARACTER  TO
C         RIGHT  OF  MATCHED  WORD.   THIS  IS  SIMILAR  TO
C         OPERATION 1 EXCEPT THAT NOTHING IS COPIED EVEN IF
C         THE  MATCH  IS  A  SUCCESS,  SO  THAT  JIN IS NOT
C         ADVANCED.  THIS TYPE OF  TEST  MUST  BE  USED  IF
C         INDENTATION ON CURRENT LINE IS TO BE REMOVED.
C     30) MOVE JSTN TO POINT TO NEXT CHARACTER  JUST BEYOND
C         THE  EXPRESSION  (AS  INDICATED  BY   PARENTHESES
C         COUNTING)  WHICH  STARTS  AT  JIN.   JIN  IS  NOT
C         CHANGED.  THIS ALLOWS  TESTING CHARACTERS  BEYOND
C         THE EXPRESSION WITHOUT NEEDING TO COPY IT.
C     31) TEST IF  CHARACTER POINTED  TO BY JSTN  IS AT END
C         OF STATEMENT. VALUE OF JSTN IS NOT ALTERED EXCEPT
C         TO STEP IT ACROSS  LEADING BLANKS.  JSTN IS RESET
C         TO JIN IN CASE OF A FAILURE.
C
C     THE NAMES OF  VARIABLES  IN  FORTRAN  STATEMENTS  ARE
C     SEPARATED  BY OPERATORS SUCH AS .AND., .EQV. AND .EQ.
C     AMONG OTHERS.  THE LTROPR, MCHOPR AND  NOTOPR  ARRAYS
C     CONTROL   THE   RECOGNITION  OF  SUCH  OPERATORS.   A
C     PARTICULAR NONBLANK CHARACTER  WITHIN  THE  STATEMENT
C     BEING  PARSED  IS FIRST TESTED AGAINST LTROPR(1).  IF
C     THE MATCH  IS  A  SUCCESS,  THEN  THE  NEXT  NONBLANK
C     CHARACTER  IS  TESTED  AGAINST  THE  CHARACTER IN THE
C     LTROPR ARRAY LOCATION HAVING  AS  ITS  SUBSCRIPT  THE
C     VALUE  IN  THE  MCHOPR ARRAY LOCATION HAVING THE SAME
C     SUBSCRIPT AS THE CHARACTER WHICH WAS MATCHED  IN  THE
C     LTROPR  ARRAY.   IF THE MATCH FAILS, THEN THE CURRENT
C     NONBLANK CHARACTER IS TESTED AGAINST THE CHARACTER IN
C     THE LTROPR ARRAY LOCATION HAVING AS ITS SUBSCRIPT THE
C     VALUE IN THE NOTOPR ARRAY HAVING THE  SAME  SUBSCRIPT
C     AS  THE  CHARACTER  WHICH DID NOT MATCH IN THE LTROPR
C     ARRAY.  AN OPERATOR HAS BEEN LOCATED  IF  A  ZERO  IS
C     FOUND  IN THE MCHOPR ARRAY LOCATION WHERE A SUBSCRIPT
C     IS EXPECTED.  THE MATCH HAS FAILED FOR  ALL  POSSIBLE
C     OPERATORS  IF  A  ZERO  IS  FOUND IN THE NOTOPR ARRAY
C     LOCATION WHERE A SUBSCRIPT IS EXPECTED.
C
C     FOR EXAMPLE, IF THE STATEMENT BEING  PARSED  CONTAINS
C     .EQ.  IN WHICH THE E AND THE Q ARE IN UPPER CASE, AND
C     IF THE LTROPR, MCHOPR AND NOTOPR ARRAYS  CONTAIN  THE
C     FOLLOWING CHARACTERS AND VALUES,
C
C         LTROPR( 1)=1H.  MCHOPR( 1)= 2  NOTOPR( 1)=35
C         LTROPR( 2)=1HA  MCHOPR( 2)= 4  NOTOPR( 2)= 3
C         LTROPR( 3)=1Ha  MCHOPR( 3)= 4  NOTOPR( 3)= 8
C         LTROPR( 8)=1HE  MCHOPR( 8)=10  NOTOPR( 8)= 9
C         LTROPR(10)=1HQ  MCHOPR(10)=12  NOTOPR(10)=11
C         LTROPR(12)=1HV  MCHOPR(12)=34  NOTOPR(12)=13
C         LTROPR(13)=1Hv  MCHOPR(13)=34  NOTOPR(13)=34
C         LTROPR(34)=1H.  MCHOPR(34)= 0  NOTOPR(34)= 0
C
C     THEN THE FOLLOWING TESTS WOULD BE PERFORMED.
C
C     1H. IN THE STATEMENT WOULD BE TESTED AGAINST  1H.  IN
C     LTROPR(1).
C
C     THIS MATCH SUCCEEDS AND MCHOPR(1) CONTAINS 2, SO  THE
C     1HE  WHICH  IS THE NEXT CHARACTER IN THE STATEMENT IS
C     TESTED AGAINST THE UPPER CASE 1HA IN LTROPR(2).
C
C     THIS MATCH FAILS AND NOTOPR(2) CONTAINS 3, SO THE 1HE
C     IN  THE STATEMENT IS TESTED AGAINT THE LOWER CASE 1Ha
C     IN LTROPR(3).
C
C     THIS MATCH ALSO FAILS AND NOTOPR(3)  CONTAINS  8,  SO
C     THE  1HE IN THE STATEMENT IS TESTED AGAINST THE UPPER
C     CASE 1HE IN LTROPR(8).
C
C     THIS MATCH SUCCEEDS AND MCHOPR(8) CONTAINS 10, SO THE
C     1HQ  WHICH  IS THE NEXT CHARACTER IN THE STATEMENT IS
C     TESTED AGAINST THE UPPER CASE 1HQ IN LTROPR(10).
C
C     THIS MATCH SUCCEEDS AND MCHOPR(10)  CONTAINS  12,  SO
C     THE  1H. WHICH IS THE NEXT CHARACTER IN THE STATEMENT
C     IS TESTED AGAINST THE UPPER CASE 1HV IN LTROPR(12).
C
C     THIS MATCH FAILS AND NOTOPR(12) CONTAINS 13,  SO  THE
C     1H.   IS   TESTED  AGAINST  THE  LOWER  CASE  1Hv  IN
C     LTROPR(13).
C
C     THIS MATCH ALSO FAILS AND NOTOPR(13) CONTAINS 34,  SO
C     THE 1H. IS TESTED AGAINST THE 1H. IN LTROPR(34).
C
C     THIS MATCH SUCCEEDS AND MCHOPR(34) CONTAINS  A  ZERO,
C     SO AN ENTIRE OPERATOR HAS BEEN LOCATED.
C
C
C    LOOKING FOR     NEXT IF FOUND    NEXT IF NOT FOUND
C
C  1. 2A 4N 6D  .    2A 4N 6D38.      39( 8E 0  0
C   . 8E10Q12V  .      10Q12V38.         14G 0 38.
C   .  E  Q  .
C   .14G  E  .         18E               16L
C   .  G  T  .
C   .16L18E  .         18E38.            20N30T
C   .  L  T  .
C   .20N22E24Q26V  .   22E24Q26V38.      32X28O38. 0
C   .  N  E  .
C   .  N28O30T  .         30T38.             0  0
C   .32X  O  R  .      34O               34O
C   .34O36R38.         36R38. 0           0  0  0
C 39(                0                40)
C 40)                0                41=
C 41=                0                42+
C 42+                0                43-
C 43-                0                44*
C 44*                0                45/
C 45/                0                46,
C 46,                0                47<
C 47<                0                48>
C 48>                0                49#
C 49#                0                50:
C 50:                0                51^
C 51^                0                 0
C
      DATA LTROPR/1H.,1HA,1Ha,1HN,1Hn,1HD,1Hd,1HE,1He,1HQ,
     1            1Hq,1HV,1Hv,1HG,1Hg,1HL,1Hl,1HE,1He,1HN,
     2            1Hn,1HE,1He,1HQ,1Hq,1HV,1Hv,1HO,1Ho,1HT,
     3            1Ht,1HX,1Hx,1HO,1Ho,1HR,1Hr,1H.,1H(,1H),
     4            1H=,1H+,1H-,1H*,1H/,1H,,1H<,1H>,1H#,1H:,
     5            1H^/
      DATA MCHOPR/  2,  4,  4,  6,  6, 38, 38, 10, 10, 12,
     1             12, 38, 38, 18, 18, 18, 18, 38, 38, 22,
     2             22, 24, 24, 26, 26, 38, 38, 30, 30, 38,
     3             38, 34, 34, 36, 36, 38, 38,  0,  0,  0,
     4              0,  0,  0,  0,  0,  0,  0,  0,  0,  0,
     5              0/
      DATA NOTOPR/ 39,  3,  8,  5,  0,  7,  0,  9, 14, 11,
     1              0, 13, 38, 15, 16, 17, 20, 19, 30, 21,
     2             32, 23, 28, 25, 38, 27,  0, 29,  0, 31,
     3              0, 33, 34, 35,  0, 37,  0,  0, 40, 41,
     4             42, 43, 44, 45, 46, 47, 48, 49, 50, 51,
     5              0/
C
C     THE SUBROUTINE STRUCTURE OF RENBR  IS  SHOWN  IN  THE
C     DIAGRAM  BELOW.   IN THIS DIAGRAM, EACH ROUTINE CALLS
C     THOSE ITEMS WHICH APPEAR IN THE NEXT  COLUMN  TO  THE
C     RIGHT EITHER ON THE CURRENT LINE OR ON THE SUBSEQUENT
C     LINES WHICH CONTAIN A PERIOD IN THE  CURRENT  COLUMN.
C     FOR  EXAMPLE,  THE MAIN  PROGRAM CALLS RE1ST,  RE2ND,
C     RECHCK,  REDONE,  REOUT,  REPLAC,  RESET AND  REUSER.
C     RE1ST CALLS DASORT, RECMND AND RETEMP.
C
C     MAIN     RE1ST    DASORT
C     .        .        RECMND
C     .        .        RETEMP
C     .        RE2ND    RECMND
C     .        .        RENUMB   REINDX   DASORT
C     .        .        .        .        RETOP
C     .        .        RETEMP
C     .        .        RETITL
C     .        RECHCK   REINDX   DASORT
C     .        .        .        RETOP
C     .        .        RETITL
C     .        REDONE   RECLOS
C     .        .        REINDX   DASORT
C     .        .        .        RETOP
C     .        .        RETITL
C     .        REOUT    REINDX   DASORT
C     .        .        .        RETOP
C     .        .        RENUMB   REINDX   DASORT
C     .        .        .        .        RETOP
C     .        .        RETITL
C     .        .        RETOP
C     .        REPLAC   REINDX   DASORT
C     .        .        .        RETOP
C     .        .        RENEXT
C     .        .        RENUMB   REINDX   DASORT
C     .        .        .        .        RETOP
C     .        .        RETITL
C     .        RESET    RETEMP
C     .        REUSER
C
C     THE FOLLOWING DIAGRAM PRESENTS THIS INFORMATION  WITH
C     THE  MOST  DEEPLY NESTED SUBROUTINES AT THE LEFT.  IN
C     THIS DIAGRAM, EACH ROUTINE IS CALLED BY  THOSE  ITEMS
C     WHICH  APPEAR  IN THE NEXT COLUMN TO THE RIGHT EITHER
C     ON THE CURRENT LINE OR ON THE SUBSEQUENT LINES  WHICH
C     CONTAIN A PERIOD IN THE CURRENT COLUMN.  FOR EXAMPLE,
C     DASORT  IS  CALLED  BY  RE1ST  AND REINDX.  REINDX IS
C     CALLED BY RECHCK, REDONE, REPLAC, REOUT AND RENUMB.
C
C     DASORT   RE1ST    MAIN
C     .        REINDX   RECHCK   MAIN
C     .        .        REDONE   MAIN
C     .        .        REPLAC   MAIN
C     .        .        REOUT    MAIN
C     .        .        RENUMB   RE2ND    MAIN
C     .        .        .        REPLAC   MAIN
C     .        .        .        REOUT    MAIN
C     RECLOS   REDONE   MAIN
C     RECMND   RE1ST    MAIN
C     .        RE2ND    MAIN
C     RENEXT   REPLAC   MAIN
C     RETITL   RECHCK   MAIN
C     .        RE2ND    MAIN
C     .        REDONE   MAIN
C     .        REPLAC   MAIN
C     .        REOUT    MAIN
C     RETOP    REOUT    MAIN
C     .        REINDX   RECHCK   MAIN
C     .        .        REDONE   MAIN
C     .        .        REPLAC   MAIN
C     .        .        REOUT    MAIN
C     .        .        RENUMB   RE2ND    MAIN
C     .        .        .        REPLAC   MAIN
C     .        .        .        REOUT    MAIN
C     REUSER   MAIN
C     RETEMP   RESET    MAIN
C     .        RE1ST    MAIN
C     .        RE2ND    MAIN
C
C     *****************************************************
C     *                                                   *
C     *   GGGG L      OOO   SSSS  SSSS   A   RRRR  Y   Y  *
C     *  G     L     O   O S     S      A A  R   R  Y Y   *
C     *  G     L     O   O S     S     A   A R   R   Y    *
C     *  G     L     O   O  SSS   SSS  A   A RRRR    Y    *
C     *  G GGG L     O   O     S     S AAAAA R  R    Y    *
C     *  G   G L     O   O     S     S A   A R   R   Y    *
C     *   GGGG LLLLL  OOO  SSSS  SSSS  A   A R   R   Y    *
C     *                                                   *
C     *****************************************************
C
C     IALPHA = INDICATES WHETHER CHARACTERS PRECEDING  NEXT
C              FORTRAN  OPERATOR  IN  LTRBIG ARRAY FOUND BY
C              ROUTINE  RENEXT  ARE  PART   OF   ALPHAMERIC
C              STRING.   IALPHA  IS  TESTED  BY PORTIONS OF
C              REPLAC ROUTINE WHICH  MUST  NOT  FIND  MATCH
C              WITHIN ALPHAMERIC STRING.
C            = 0,  NO  ALPHAMERIC  STRING   PRECEDES   NEXT
C              FORTRAN OPERATOR.
C            = 1, ALPHAMERIC  STRING  (EITHER  ENCLOSED  IN
C              APOSTROPHES    OR   FOLLOWING   NUMBER   AND
C              CHARACTER H) PRECEDES NEXT FORTRAN OPERATOR.
C     IBASE  = LOWEST STATEMENT NUMBER TO BE  GENERATED  IN
C              RENUMBERED  OUTPUT FOR PROGRAMS AND ROUTINES
C              WHICH DO NOT  CONTAIN  B  OPTION  ON  CRENBR
C              COMMAND  LINES.   IF  IBASE=0,  AND B SWITCH
C              DOES  NOT  APPEAR  ON  CRENBR  COMMAND  LINE
C              WITHIN ROUTINE, THEN LOWEST STATEMENT NUMBER
C              IS TAKEN  AS  ABSOLUTE  VALUE  OF  STATEMENT
C              NUMBER INCREMENT.
C     IBR    = SUBSCRIPT IN NUMPRS  ARRAY  OF  START  OF  5
C              WORDS  DIRECTING  TEST  TO  BE  PERFORMED IN
C              SNTAX SCAN.  IBR  IS  USED  ONLY  IN  REPLAC
C              ROUTINE.   AT  END  OF  REPLAC  ROUTINE,  IF
C              STATEMENT NUMBER IS FIRST IN PROGRAM BUT HAS
C              NOT  CONTAINED  ROUTINE TYPE, THEN RETITL IS
C              CALLED  TO  SPECIFY  THAT  ROUTINE  IS  MAIN
C              PROGRAM  AND IBR SERVES TO FORWARD TO RETITL
C              LOCATION IN IWHERE ARRAY OF POINTER TO  NAME
C              "MAIN PROGRAM".
C     IBREAK = TOTAL  NUMBER  OF   TIMES   DURING   CURRENT
C              EXECUTION  OF  RENBR  THAT  LISTING  OF  ANY
C              ROUTINE OR PROGRAM WAS INTERRUPTED TO  PRINT
C              TABLE  OF STATEMENT NUMBER REFERENCES DUE TO
C              NOLD AND NNEW ARRAYS FILLING.
C     IEND   = SUBSCRIPT WITHIN  UPPER  SECTION  OF  LTRBIG
C              BUFFER  ARRAY  OF  CHARACTER  STARTING  NEXT
C              CONTINUATION LINE OF STATEMENT.   IT  IS  AT
C              SUCH LINE BREAKS THAT EXTRA BLANKS ARE ADDED
C              IF  RENUMBERING  HAS   REDUCED   NUMBER   OF
C              CHARACTERS   IN  PRECEDING  LINES,  OR  THAT
C              BLANKS AT END OF PRECEDING LINE ARE  REMOVED
C              IF   RENUMBERING  HAS  INCREASED  NUMBER  OF
C              CHARACTERS IN PRECEDING  LINES.   NUMBER  OF
C              BLANKS  TO  BE ADDED OR REMOVED IS STORED AS
C              VARIABLE LIKE.
C     IENTER = USED BY PARSER IN REPLAC ROUTINE TO  SPECIFY
C              WHETHER  REST  OF  STATEMENT IS TO BE PLACED
C              INTO  INDEX  WHEN  COPYING  THROUGH  END  OF
C              STATEMENT PRIOR TO OUTPUT.
C            = 0, DO NOT PLACE REST OF STATMENT IN INDEX
C            = 1, PLACE REST OF STATEMENT IN INDEX
C     IEOF   = IF RENUMBERING AND IN SECOND PASS, IEOF IS 1
C              PLUS  NUMBER  OF  LINES  YET TO BE READ FROM
C              SCRATCH FILE.
C            = IF  NOT  RENUMBERING  AND  IN  SECOND  PASS,
C              IEOF=2  INDICATES THAT END STATEMENT HAS NOT
C              YET BEEN READ FROM PRIMARY INPUT  FILE.   IF
C              RE2ND   RETURNS  TO MAIN PROGRAM WITH IEOF=2
C              WHILE NOT RENUMBERING, IT  MEANS  THAT  ONLY
C              END  STATEMENT  WAS  READ IN CURRENT ROUTINE
C              IMPLYING  THAT   RENBR   IS   TO   TERMINATE
C              EXECUTION.  IEOF=2 IS NOT NORMAL RETURN FROM
C              RE2ND.
C            = 0, IF IN SECOND PASS,  END  OF  ROUTINE  HAS
C              BEEN   READ  EITHER  FROM  SCRATCH  FILE  IF
C              RENUMBERING OR FROM PRIMARY  INPUT  FILE  IF
C              NOT RENUMBERING.
C     IERR   = NUMBER OF ERRORS DETECTED DURING THIS ENTIRE
C              EXECTUION OF RENBR.
C     IFILL  = 0, MEANS THAT DEVICE ON WHICH  LISTING  WILL
C              BE  PRINTED HAS HARDWARE FORM FEED ACTIVATED
C              BY CHARACTER 1 IN COLUMN 1.
C            = 1, MEANS THAT DEVICE ON WHICH  LISTING  WILL
C              BE  PRINTED DOES NOT HAVE HARDWARE FORM FEED
C              SO TOP OF EACH  PAGE  MUST  BE  PRECEDED  BY
C              CAREFULLY  COUNTED  BLANK  LINES  AND  BLANK
C              CHARACTER MUST BE USED IN COLUMN 1.
C     IFORM  = IF IFILL IS NOT  EQUAL  TO  ZERO  INDICATING
C              THAT  OUTPUT  DEVICE  DOES NOT HAVE HARDWARE
C              FORM FEED, IFORM IS TOTAL  NUMBER  OF  LINES
C              PER  PAGE  IN LISTING, INCLUDING BLANK LINES
C              TO BE GENERATED AT PAGE BOUNDARIES.  IGNORED
C              IF  IFILL  IS  EQUAL TO ZERO INDICATING THAT
C              OUTPUT  DEVICE  HAS   HARDWARE   FORM   FEED
C              ACTIVATED BY CHARACTER 1 IN COLUMN 1.  IFORM
C              IS SET BY NUMBER FOLLOWING SLASH FOLLOWING L
C              OPTION TYPED BY USER.
C     IFREAR = 0, IF AND ONLY IF FORTRAN OPERATOR TO  RIGHT
C              OF   ITEM   TO  BE  PLACED  INTO  DICTIONARY
C              CONSISTS OF SINGLE CHARACTER.  THIS OPERATOR
C              DOES  NOT  NEED TO BE TESTED TO SEE IF IT IS
C              PARENTHESIS OR EQUAL SIGN IF IFREAR  IS  NOT
C              EQUAL TO ZERO.
C     IHIHDO = DIMENSION OF NOLD AND  NEW  ARRAYS.   REGION
C              FROM LOWDO+1 THROUGH IHIHDO IS USED TO STORE
C              OPEN DO LOOP TERMINAL STATEMENT NUMBERS.
C     IIN    = UNIT NUMBER FROM WHICH ORIGINAL  PROGRAM  IS
C              READ.
C     ILEVEL = PARENTHESIS COUNT DURING ADDITION  OF  WORDS
C              TO  DICTIONARY.   ILEVEL  IS  SET TO ZERO AT
C              START OF PROCESSING OF EACH STATEMENT,  THEN
C              IS  INCREASED BY 1 FOR EACH LEFT PARENTHESIS
C              AND  DECREASED   BY   1   FOR   EACH   RIGHT
C              PARENTHESIS ENCOUNTERED WHILE ENTERING ITEMS
C              INTO DECTIONARY.  ILEVEL IS USED WITH JLEVEL
C              WHICH  CONTAINS  SUBSCRIPT  OF  NUMPNT ARRAY
C              LOCATION AT WHICH CAN  BE  FOUND  LAST  LINE
C              NUMBER  STORED  FOR  THIS  STATEMENT AT ZERO
C              PARENTHESIS  LEVEL  AND  WITH  KLEVEL  WHICH
C              CONTAINS  SUBSCRIPT OF NUMPNT ARRAY LOCATION
C              AT WHICH  CAN  BE  FOUND  LAST  LINE  NUMBER
C              STORED  FOR  THIS  STATEMENT  PROVIDING THAT
C              PARENTHESIS  COUNT  HAS  NOT  CHANGED  SINCE
C              THEN.    JLEVEL   AND  KLEVEL  ARE  USED  TO
C              IDENTIFY, AND THEN MARK WITH  NEGATIVE  LINE
C              NUMBERS,  VARIABLES  WHICH  ARE  DEFINED  BY
C              EQUALS SIGN OPERATOR IN  CURRENT  STATEMENT.
C              JLEVEL  AND  KLEVEL ARE ZEROED IF INDEX MUST
C              BE  WRITTEN  IN  MIDDLE  OF  PROCESSING   OF
C              STATEMENT,  THOUGH, OF COURSE, ILEVEL IS NOT
C              ZEROED BY SUCH GENERATION OF INDEX.
C     ILPT   = UNIT NUMBER ONTO WHICH LISTING IS WRITTEN.
C     INCR   = 0, NO RENUMBRING IS TO BE PERFORMED.
C            = NOT EQUAL TO ZERO, ABSOLUTE VALUE OF INCR IS
C              STATEMENT  NUMBER  INCREMENT  IN  RENUMBERED
C              OUTPUT FOR PROGRAMS AND  ROUTINES  WHICH  DO
C              NOT  CONTAIN  I  OPTION ON CRENBR LINES.  IF
C              INCREMENT (EITHER INCR OR VALUE SPECIFIED ON
C              CRENBR   COMMAND   LINE   BY  I  SWITCH)  IS
C              NEGATIVE,  THEN  SMALLEST  STATEMENT  NUMBER
C              (IBASE  OR  VALUE  SPECIFIED  BY B SWITCH ON
C              CRENBR COMMAND LINE OR ELSE  ABSOLUTE  VALUE
C              OF INCREMENT IF BASE IS SPECIFIED NEITHER BY
C              USER NOR BY CRENBR COMMAND LINE)  IS  PLACED
C              AT   END  OF  PROGRAM  NEAREST  FORTRAN  END
C              STATEMENT.  IF INCREMENT IS  POSITIVE,  THEN
C              SMALLEST  STATEMENT  NUMBER  IS  AT START OF
C              PROGRAM.
C     INCSAV = TEMPORARY  STORAGE   OF   STATEMENT   NUMBER
C              INCREMENT  (OTHERWISE  KEPT  IN  INCR)  WHEN
C              COMMENT SECTION INDICATED BY  RENBRSTART  OR
C              BY RENBRTITLE  COMMAND  IS ENCOUNTERED WHILE
C              RENUMBERING.  INCR IS SET TO ZERO TO  SWITCH
C              TO   SINGLE   PASS  OPERATION  FOR  REST  OF
C              PROCESSING OF COMMENT SECTION.
C     INDENT = NUMBER OF EXTRA BLANKS  TO  BE  INSERTED  TO
C              LEFT  OF  EACH  LEVEL  OF  STATEMENTS WITHIN
C              RANGE  OF  DO  LOOPS.   ACTUAL  INDENTATION,
C              MULTIPLE  OF  INDENT, IS STORED AS MOVE.  IF
C              INDENT IS ZERO, NO INDENTATION IS  PERFORMED
C              IN RANGE OF DO LOOPS.  VALUE OF INDENT WHICH
C              IS SET BY USER IS STORED AS INDSAV.   INDENT
C              CAN THEN BE CHANGED BY CRENBR COMMAND LINE.
C     INDSAV = VALUE OF BLOCK  INDENTATION SPECIFIED BY THE
C              USER.  INDENT IS RESET TO INDSAV AT START OF
C              EACH NEW  ROUTINE,  BUT MAY  BE CHANGED BY A
C              CRENBR COMMAND LINE WITHIN THAT ROUTINE.
C     ININAM = LOCATION AT WHICH ROUTINE NAME FIELD  STARTS
C              IN LTRTOP ARRAY WHICH IS USED TO STORE TOP 2
C              LINES OF EACH PAGE OF LISTING.
C     INIOPR = RETURNED BY ROUTINE  RENEXT  (WHICH  LOCATES
C              NEXT  FORTRAN  OPERATOR  WITHIN  PORTION  OF
C              STATEMENT)   CONTAINING   SUBSCRIPT   WITHIN
C              LTRBIG   ARRAY   OF  FIRST  LETTER  OF  NEXT
C              OPERATOR,  OR  CONTAINING   NEXT   SUBSCRIPT
C              BEYOND  END  OF  PORTION  TO  BE SEARCHED IF
C              OPERATOR  IS  NOT  FOUND.   RENEXT  SEARCHES
C              LTRBIG  ARRAY  FROM  SUBSCRIPT  JSTN THROUGH
C              CHARACTER PRECEDING JEND.
C     INIPRT = LOCATION  IN  LTRBIG   ARRAY   OF   LEFTMOST
C              PRINTING CHARACTER AFTER INITIAL INDENTATION
C              IF ANY.  USED WHEN  INDENTATION  IS  REMOVED
C              FROM START OF CURRENT LINE.
C     INITOC = MAXIMUM NUMBER OF ROUTINE DESCRIPTIONS WHICH
C              CAN  BE  STORED  FOR  TABLE OF CONTENTS.  IF
C              THIS WOULD GIVE  PARTIAL  FINAL  PAGE,  THEN
C              EFFECTIVE  NUMBER  OF DESCRIPTIONS STORED AS
C              MAXTOC IS REDUCED TO EXCLUDE PARTIAL PAGE.
C     INRCPY = LOCATION IN INRSTR ARRAY CONTAINING LOCATION
C              IN  UPPER  SECTION  OF LTRBIG ARRAY OF FINAL
C              EXCLAMATION   POINT   WITHIN   PORTION    OF
C              STATEMENT ALREADY COPIED INTO LOWER SECTION.
C     INRFND = 1  PLUS   NUMBER   OF   EXCLAMATION   POINTS
C              ENCOUNTERED     IN    STATEMENT.     INITIAL
C              EXCLAMATION   POINT   IS   SIMULATED   BELOW
C              STATEMENT IN ADDITION TO THOSE FOUND.
C     INRSTR = ARRAY STORING IN LOCATIONS HAVING SUBSCRIPTS
C              2  THROUGH INRFND LOCATIONS IN UPPER SECTION
C              OF LTRBIG  ARRAY  CONTAINING  EXCLAM-  ATION
C              POINTS.     INRSTR(1)   CONTAINS   SIMULATED
C              EXCLAMATION POINT BELOW STATEMENT SO  IT  IS
C              NOT  NECESSARY  TO  CHECK IF ANY EXCLAMATION
C              POINT HAS BEEN FOUND BEFORE TESTING  IF  NEW
C              EXCLAMATION  POINT  HAS BEEN ALREADY STORED.
C              INRSTR MUST BE DIMENSIONED TO  2  MORE  THAN
C              NUMBER OF CONTINUATION LINES ALLOWED.
C     IOUT   = UNIT NUMBER ONTO WHICH RENUMBERED VERSION OF
C              PROGRAM IS WRITTEN.
C     IPAGE  = 0, NO LISTING IS TO BE GENERATED.
C            = GREATER THAN ZERO, IPAGE IS PAGE  NUMBER  OF
C              NEXT PAGE TO BE WRITTEN IN LISTING.
C     IPASS  = 0, IN FIRST  PASS  WHEN  RENUMBERING.   THIS
C              PASS  FINDS  STATEMENT  NUMBERS TO CONSTRUCT
C              LOOK-UP TABLE OF NEW NUMBERS SORTED ON  OLD.
C              ZERO VERSUS NON-ZERO IPASS IS USED BY CRENBR
C              COMMAND SCANNER TO DETERMINE ACTIVE COMMANDS
C            = .NE.0, IN SECOND PASS WHEN RENUMBERING OR IN
C              ONLY PASS IF NOT RENUMBERING.
C            = -1, STATEMENT NUMBERS LOOKED  UP  BY  RENUMB
C              ARE NOT TO BE PLACED INTO INDEX
C            = 1, STATEMENT NUMBERS LOOKED UP BY RENUMB ARE
C              TO  BE  PLACED INTO INDEX WITH POSITIVE LINE
C              NUMBERS
C            = 2, STATEMENT NUMBERS LOOKED UP BY RENUMB ARE
C              TO  BE  PLACED INTO INDEX WITH NEGATIVE LINE
C              NUMBERS
C     IPOINT = LOCAL VARIABLE WHICH, LIKE I THROUGH  N  AND
C              JPOINT, HAS NO SPECIAL MEANING.
C     ISPACE = ABSOLUTE VALUE IS NUMBER OF BLANK  LINES  TO
C              BE  GENERATED  IN  LISTING  BETWEEN  FORTRAN
C              STATEMENTS.   ISPACE   IS   POSITIVE   AFTER
C              FORTRAN  STATEMENT  HAS BEEN LISTED.  ISPACE
C              IS NEGATIVE  AFTER  COMMENT  LINE  HAS  BEEN
C              LISTED.   SIGN  DOES  NOT MATTER AT START OF
C              LISTING SINCE NO EXTRA BLANKS ARE EVER ADDED
C              AT TOP OF PAGE.  EXTRA BLANK LINES ARE ADDED
C              TO LISTING PRECEDING EACH FORTRAN  STATEMENT
C              WHICH  DOES  NOT  START  AT TOP OF PAGE.  IF
C              ISPACE IS POSITIVE AND COMMENT LINE IS TO BE
C              LISTED  AT  LOCATION OTHER THAN TOP OF PAGE,
C              THEN NUMBER  OF  BLANK  LINES  INDICATED  BY
C              ISPACE  IS  WRITTEN  BEFORE  COMMENT LINE IS
C              ITSELF WRITTEN,  AND  THEN  ISPACE  IS  MADE
C              NEGATIVE.
C     ISPLIT = 0, LONG FORTRAN STATEMENTS  ARE  NOT  TO  BE
C              SPLIT  IN LISTING EVEN IF THEY EXTEND BEYOND
C              RIGHT BORDER OF PAGES.
C            = NOT EQUAL TO 0, ABSOLUTE VALUE OF ISPLIT  IS
C              ONE  GREATER THAN NUMBER OF CHARACTERS WHICH
C              CAN  BE  PRINTED  IN  COMMENT  LINES  BEYOND
C              NORMAL   RIGHT  HAND  BORDERS.   IN  EFFECT,
C              ISPLIT=14 IS EQUAL TO ISPLIT=0  FOR  FORTRAN
C              STATEMENTS.  IF NEGATIVE, THEN ROUTINE REOUT
C              HAS JUST PRINTED FIRST PART OF STATEMENT AND
C              IS GENERATING TOP OF NEXT PAGE IF NECESSARY.
C              JSPLIT,  CORRESPONDING  VALUE  FOR   COMMENT
C              LINES, IS SET EQUAL TO ISPLIT INITIALLY, BUT
C              IS GIVEN VALUE 65 IF SPLIT=0  SINCE  COMMENT
C              LINES  CAN  EXPAND DUE TO CONVERSION OF TABS
C              TO BLANKS AND SINCE FORMAT  STATEMENTS  ONLY
C              PROVIDE  FOR  THIS  NUMBER  OF CHARACTERS TO
C              RIGHT OF BORDER OF PAGE.  IF USER  SPECIFIES
C              SPLIT AFTER 69 OR MORE CHARACTERS, THEN THIS
C              NUMBER IS ASSUMED  TO  INSTEAD  BE  TERMINAL
C              PAGE WIDTH, AND SO IS REDUCED BY 69.
C     ISPR   = UNIT  ONTO  WHICH  SCRATCH  FILE  IS  TO  BE
C              WRITTEN IF RENUMBERING IS PERFORMED.
C     ISTART = LOCATION WITHIN SMALL INPUT BUFFER OF  FIRST
C              NONBLANK  CHARACTER  OF  STATEMENT  TEXT  IN
C              CURRENTLY READ LINE.
C     ISTN   = POINTS  TO  CHARACTER  FOLLOWING   STATEMENT
C              NUMBER  IN  UPPER  SECTION  OF LTRBIG BUFFER
C              ARRAY FOUND DURING SYNTAX ANALYSIS.  POINTER
C              STRUCTURE  IS  DESCRIBED IN COMMENT LINES IN
C              BLOCK  DATA  ROUTINE  WHICH  DESCRIBE NUMPRS
C              AND LTRPRS ARRAYS.
C     ITAB   = -1, RENUMBERED OUTPUT IS TO BE  PRODUCED  IN
C              COLUMN  (CARD)  FORMAT WITH STATEMENT NUMBER
C              STARTING  IN  COLUMN  1.    TEXT   OF   EACH
C              STATEMENT WILL START IN COLUMN 6.
C            = 0, RENUMBERED OUTPUT IS TO  BE  PRODUCED  IN
C              COLUMN  (CARD)  FORMAT WITH STATEMENT NUMBER
C              ENDING IN COLUMN 5.  TEXT OF EACH  STATEMENT
C              WILL START IN COLUMN 6.
C            = 1, RENUMBERED OUTPUT IS TO  BE  PRODUCED  IN
C              TAB FORMAT SUCH THAT TAB CHARACTER SEPARATES
C              STATEMENT NUMBER FROM STATEMENT TEXT.
C     ITBL   = NUMBER OF COPIES OF TABLE OF CONTENTS TO  BE
C              PRINTED.   ITBL  CANNOT  BE  LESS  THAN 1 IF
C              RENUMBERING  IS  BEING  PERFORMED,  BUT   IS
C              IGNORED   IF   RENUMBERING   IS   NOT  BEING
C              PERFORMED.
C     ITITLE = 0,  PROGRAM  NAME  AND  TYPE  HAS  NOT  BEEN
C              ESTABLISHED.
C            = .LT.0, AT LEAST ROUTINE TYPE (MAIN  PROGRAM,
C              SUBROUTINE,    FUNCTION   ETC.)   HAS   BEEN
C              ESTABLISHED AND HAS BEEN REPRESENTED  WITHIN
C              LTRTOP ARRAY WHICH HOLDS TITLE AND SUBTITLE.
C              ABSOLUTE VALUE OF ITITLE IS SUBSCRIPT WITHIN
C              LTRTOP   ARRAY  OF  RIGHTMOST  CHARACTER  OF
C              ROUTINE NAME, OR IF NO ROUTINE NAME HAS BEEN
C              ESTABLISHED,   BUT  ROUTINE  TYPE  HAS  BEEN
C              PLACED  INTO  LTRTOP  ARRAY,  OF   RIGHTMOST
C              SUBSCRIPT INTO WHICH NAME WOULD BE PLACED IF
C              LATER ESTABLISHED BY CRENBR COMMAND LINE.
C            = .GT.0, ITITLE IS NUMBER OF CHARACTERS (UP TO
C              MAXIMUM  OF  6)  WITHIN  NAME ESTABLISHED BY
C              CRENBR COMMAND LINE AND STORED WITHIN LTRUSE
C              ARRAY,  BUT  NOT  YET  TRANSFERRED TO LTRTOP
C              ARRAY.  THIS SITUATION ARISES  DURING  FIRST
C              PASS  WHEN  CRENBR  COMMAND  LINE  IS  FOUND
C              CONTAINING TITLE SINCE ROUTINE TYPE AND NAME
C              ARE ONLY PLACED INTO LTRUSE ARRAY WHEN FIRST
C              NONCOMMENT  STATEMENT  IS  FOUND  IN  SECOND
C              PASS.
C     ITRACE = 0, DO NOT TYPE STORAGE SUMMARY UNLESS  TABLE
C              WAS DUMPED IN MIDDLE OF ROUTINE LISTING.
C            = 1, ALWAYS TYPE STORAGE SUMMARY.  THIS IS SET
C              BY /Z SWITCH ISSUED BY USER.
C     ITTY   = UNIT NUMBER ONTO WHICH  QUESTIONS  REQUIRING
C              ANSWERING  BY  USER,  AND ERROR MESSAGES ARE
C              WRITTEN.  ANSWERS TYPED IN RESPONSE BY  USER
C              ARE READ FROM UNIT JTTY.
C     JBGN   = POINTER INTO LOWER SECTION OF LTRBIG  BUFFER
C              ARRAY   TO  FIRST  CHARACTER  WHICH  CAN  BE
C              SCANNED FOR INCLUSION  OF  WORDS  IN  INDEX.
C              JBGN  IS  ADVANCED  TO JOUT IF ALL PRESENTLY
C              COPIED WORDS HAVE BEEN PLACED INTO INDEX.
C     JBREAK = TOTAL  NUMBER  OF   TIMES   DURING   CURRENT
C              EXECUTION  OF  RENBR  THAT  LISTING  OF  ANY
C              ROUTINE OR PROGRAM WAS INTERRUPTED TO  PRINT
C              INDEX DUE TO NUMPNT ARRAY FILLING.
C     JEND   = POINTER INTO UPPER SECTION OF LTRBIG  BUFFER
C              ARRAY  TO  FIRST  CHARACTER BEYOND STATEMENT
C              (INCLUDING ALL CONTINUATION  LINES  IF  ANY)
C              STORED  INTO UPPER SECTION.  JIN IS ADVANCED
C              UNTIL  IT  REACHES  JEND.   JEND  ORIGINALLY
C              EQUALS  MAXEND  WHICH  POINTS  TO  CHARACTER
C              RIGHT OF FINAL PRINTING CHARACTER IN BUFFER.
C              IF  SEMICOLON  IS  FOUND WHILE SEARCHING FOR
C              FORTRAN OPERATORS DURING PARSING, THEN  JEND
C              IS  RETURNED  POINTING TO SEMICOLON AND TEXT
C              RIGHT OF SEMICOLON IS  TREATED  AS  SEPARATE
C              STATEMENT.
C     JEOF   = 0,  REAL  END-OF-FILE  WAS  READ  FROM  FROM
C              PRIMARY  INPUT  EITHER  IN RE1ST  ROUTINE IF
C              RENUMBERING, OR IN   RE2ND  ROUTINE  IF  NOT
C              RENUMBERING.   IF RENUMBERING THEN BOTH IEOF
C              AND JEOF ARE NECESSARY SINCE IF THERE IS  NO
C              END  STATEMENT AT END OF ROUTINE OR PROGRAM,
C              THEN WHAT HAS BEEN READ IN MUST BE PROCESSED
C              BEFORE  END-OF-FILE CONDITION CAN BE USED TO
C              INDICATE TERMINATION OF EXECUTION.   IF  NOT
C              RENUMBERING,  THEN  JEOF  MUST BE SET ANYWAY
C              SINCE RENBR MIGHT BE READING COMMENT SECTION
C              IN  SINGLE PASS  SO THAT RE1ST ROUTINE WOULD
C              REVERT TO RENUMBERING MODE UPON RETURN  FROM
C              RE2ND  ROUTINE.
C            = 1, END-OF-FILE HAS NOT BEEN READ.
C     JFORM  = NUMBER OF LINES ON WHCIH PRINTING CAN APPEAR
C              ON PAGE IN LISTING.  SET BY NUMBER FOLLOWING
C              EITHER F OR L OPTIONS TYPED BY USER.
C     JIN    = POINTS TO FIRST CHARACTER IN  UPPER  SECTION
C              OF  LTRBIG  BUFFER  ARRAY  WHICH HAS NOT YET
C              BEEN COPIED INTO  LOWER  SECTION  OF  LTRBIG
C              ARRAY.
C     JIN1   = WHEN HUNTING FOR STATEMENT NUMBER IN FORTRAN
C              STATEMENT  TEXT,  JIN1  POINTS  TO RIGHTHAND
C              DIGIT OF STATEMENT NUMBER  AND  IS  USED  TO
C              RESET  POINTER JSTN IF BLANKS OR TABS (WHICH
C              CAN  SEPARATE  DIGITS  OF   NUMBER)   FOLLOW
C              NUMBER.
C     JLEVEL = POINTER TO LAST  NUMPNT  ARRAY  LOCATION  AT
C              WHICH  LINE  NUMBER WAS STORED WHILE AT ZERO
C              PARENTHESIS  LEVEL.    SEE   DEFINITION   OF
C              ILEVEL.
C            = 0, NO LINE NUMBER WAS STORED IN NUMPNT ARRAY
C              AT   ZERO   PARENTHESIS  COUNT  FOR  PRESENT
C              STATEMENT.
C     JMPBGN = NUMBER OF BLANK LINES TO GENERATE AT TOP  OF
C              1ST,  3RD, 5TH ETC.  PAGES, AND AT BOTTOM OF
C              2ND, 4TH,  6TH  ETC.   PAGES.   CONTENTS  OF
C              JMPBGN  AND JMPEND ARE INTERCHANGED AT START
C              OF EACH PAGE.
C     JMPEND = NUMBER OF BLANK LINES TO GENERATE AT TOP  OF
C              2ND,  4TH, 6TH ETC.  PAGES, AND AT BOTTOM OF
C              1ST, 3RD,  5TH  ETC.   PAGES.   CONTENTS  OF
C              JMPBGN  AND JMPEND ARE INTERCHANGED AT START
C              OF EACH PAGE.
C     JOBNUM = NUMBER  WHICH   IS   USED   BY   RETEMP   IN
C              CONSTRUCTION  OF  NAME  OF SCRATCH FILE WHEN
C              RETEMP IS CALLED  WITH  ITS  FIRST  ARGUMENT
C              GREATER THAN 0.  JOBNUM IS DEFINED BY RETEMP
C              WHEN  RETEMP  IS  CALLED  WITH   ITS   FIRST
C              ARGUMENT  SET TO 0.  JOBNUM SHOULD ITSELF BE
C              BASED UPON  SOME  UNIQUE  CHARACTERISTIC  OF
C              CURRENT  JOB.  JOB NUMBER WOULD BE BEST, BUT
C              DEC PDP10 VERSION USES TIME OF DAY WHEN  JOB
C              WAS  STARTED SINCE DEC PDP10 FORTRAN LIBRARY
C              DOES NOT INCLUDE ROUTINE WHICH  RETURNS  JOB
C              NUMBER.
C     JOUT   = POINTS TO FIRST CHARACTER IN  LOWER  SECTION
C              OF  LTRBIG  BUFFER  ARRAY INTO WHICH NOTHING
C              HAS YET  BEEN  COPIED  FROM  UPPER  SECTION.
C              JOUT   IS  TESTED  AGAINST  JIN  TO  PREVENT
C              OVERLAP WITH CHARACTER ABOUT TO BE COPIED.
C     JPASS  = 0, RETURNED BY REUSER IF NO MORE INPUT FILES
C              ARE TO BE READ.
C            = 1, RETURNED BY REUSER IF  ANOTHER INPUT FILE
C              IS TO BE READ.
C     JPNT   = ARRAY CONTAINING SUBSCRIPTS IN NUMPNT  ARRAY
C              (WHICH  STORES  WORDS  AND  REFERENCES TO BE
C              PLACED INTO INDEX) OF  ALPHABETICALLY  FIRST
C              (A  BEFORE  B  BEFORE C ETC.) WORD FORMED OF
C              NUMBER OF CHARACTERS EQUAL TO  SUBSCRIPT  OF
C              JPNT ARRAY.  ALL WORDS OF OVER 10 CHARACTERS
C              ARE STORED IN LIST POINTED  TO  BY  JPNT(10)
C              AND  ONLY  FIRST  19  CHARACTERS OF WORD ARE
C              STORED IN INDEX.  IF ITEM IN JPNT  ARRAY  IS
C              ZERO,  NO  WORDS OF CORRESPONDING LENGTH ARE
C              IN INDEX STORAGE.
C     JPOINT = LOCAL VARIABLE WHICH, LIKE I THROUGH  N  AND
C              IPOINT, HAS NO SPECIAL MEANING.
C     JSPLIT = ABSOLUTE VALUE OF JSPLIT IS ONE GREATER THAN
C              NUMBER OF CHARACTERS WHICH CAN BE PRINTED IN
C              COMMENT  LINES  BEYOND  NORMAL  RIGHT   HAND
C              BORDERS.   IF  NEGATIVE, THEN REOUT HAS JUST
C              PRINTED FIRST PART  OF  COMMENT  LINE  WHICH
C              MUST  BE SPLIT IN LISTING, AND IS GENERATING
C              TOP OF NEXT PAGE IF NECESSARY.   SINCE  TABS
C              IN COMMENT LINES CAN EXPAND COMMENT LINE FAR
C              BEYOND NUMBER  OF  CHARACTERS  PRINTABLE  IN
C              FORMAT  STATEMENTS  IN  REOUT,  SUCH COMMENT
C              LINES CAN NEVER BE TREATED  AS  THOUGH  THEY
C              ARE  TO  BE  KEPT INTACT, BUT RATHER MUST BE
C              SPLIT IF THEY EXPAND BEYOND 119  CHARACTERS.
C              HOWEVER,  NO TAB TO BLANK CONVERSION IS DONE
C              INSIDE  TEXT  OF   FORTRAN   STATEMENTS   SO
C              ISPLIT=0  (ISPLIT  IS CORRESPONDING ITEM FOR
C              FORTRAN STATEMENTS) IS TAKEN  TO  MEAN  THAT
C              LONG  FORTRAN STATEMENTS ARE NOT TO BE SPLIT
C              IN LISTING.
C     JSTN   = POINTS   TO   FIRST   CHARACTER    FOLLOWING
C              SUCCESSFUL SEARCH IN UPPER SECTION OF LTRBIG
C              BUFFER   ARRAY   DURING   SYNTAX   ANALYSIS.
C              POINTER  STRUCTURE  IS  DESCRIBED IN COMMENT
C              LINES IN  RENBR  BLOCK  DATA  ROUTINE  WHICH
C              DESCRIBE NUMPRS AND LTRPRS ARRAYS.
C     JTAB   = TAB STOP INTERVAL FOR USE IN  CONVERSION  OF
C              TAB  CHARACTERS  TO BLANKS IN COMMENT LINES.
C              SET BY W OPTION  TYPED  BY  USER.   TABS  IN
C              COMMENT LINES ARE ALWAYS CONVERTED TO BLANKS
C              IN LISTING, BUT ARE ONLY CONVERTED TO BLANKS
C              IN RENUMBERED OUTPUT IF LTAB IS NONZERO.
C     JTBL   = DO LOOP INDEX USED BY RETITL WHEN GENERATING
C              MULTIPLE TABLES OF CONTENTS.
C     JTTY   = UNIT NUMBER FROM WHICH  USERS  SELECTION  OF
C              OPTIONS  AND  OTHER ANSWERS TO QUESTIONS ARE
C              READ.  QUESTIONS THEMSELVES ARE WRITTEN ONTO
C              UNIT ITTY.
C     KBGN   = LEFT POINTING  IN  LTRBIG  ARRAY  BY  REINDX
C              ROUTINE  TO  FIRST  CHARACTER OF OPERATOR TO
C              RIGHT OF ITEM WHICH IS  TO  BE  PLACED  INTO
C              INDEX.
C     KEND   = USED BY ROUTINES CALLED BY REPLAC ROUTINE TO
C              STORE  LTRBIG  ARRAY SUBSCRIPT CORRESPONDING
C              TO START  OF  NEXT  CONTINUATION  LINE  WHEN
C              SCANNING  THROUGH LINE.  KEND IS ADVANCED 66
C              CHARACTERS EACH TIME  EXCLAMATION  POINT  IS
C              FOUND.     REPLAC    ROUTINE   USES   NXTEND
C              SIMILARLY.
C     KLEVEL = POINTER TO LAST  NUMPNT  ARRAY  LOCATION  AT
C              WHICH  LINE NUMBER WAS STORED IF PARENTHESIS
C              COUNT  HAS  NOT  CHANGED  SINCE  THEN.   SEE
C              DEFINITION OF ILEVEL.
C            = 0, PARENTHESIS COUNT HAS CHANGED SINCE  LINE
C              NUMBER WAS STORED IN NUMPNT ARRAY.
C     KMDMAX = 0 WHEN KMDMIN=0, NORMAL RENUMBERING.
C            = .GT.0 OR KMDMIN.GT.0, KMDMIN AND KMDMAX  ARE
C              LOWER AND UPPER LIMITS OF RANGE OF STATEMENT
C              NUMBERS TO BE PRESERVED IN ALL  FILES  BEING
C              RENUMBERED.
C     KMDMIN = -1,  OLD  STATEMENT  NUMBERS   ARE   TO   BE
C              MAINTAINED.
C            = 0 WHEN KMDMAX=0, NORMAL RENUMBERING.
C            = .GT.0 OR KMDMAX.GT.0, KMDMIN AND KMDMAX  ARE
C              LOWER AND UPPER LIMITS OF RANGE OF STATEMENT
C              NUMBERS TO BE PRESERVED IN ALL  FILES  BEING
C              RENUMBERED.
C     KNDGRP = IDENTIFIES  WHETHER  PERFORMING  OUTPUT   OF
C              GROUP OF STATEMENTS OR OF COMMENTS.
C            = -1, OUTPUT COMMENTS
C            = 0, NOTHING YET OUTPUT IN PROGRAM
C            = 1, OUTPUT STATEMENTS
C     KNT    = NUMBER OF LINES ALREADY PRINTED  ON  CURRENT
C              PAGE.
C     KNTONE = NUMBER OF GROUPS OF STATEMENTS OUTPUT.
C     KNTPNT = NUMBER OF  LOCATIONS  CURRENTLY  IN  USE  IN
C              NUMPNT   ARRAY  TO  CONTAIN  LIST  OF  LINES
C              CONTAINING PARTICULAR WORDS.
C     KNTSPL = TOTAL  NUMBER   OF   CHARACTERS   IN   WORDS
C              CURRENTLY  BEING  STORED IN LTRSPL ARRAY FOR
C              USE IN CONSTRUCTING INDEX.
C     KNTTOC = NUMBER  OF  ROUTINE  DESCRIPTIONS  CURRENTLY
C              STORED FOR TABLE OF CONTENTS.
C     KNTTWO = NUMBER OF GROUPS OF COMMENTS OUTPUT.
C     KOMENT = 0, INPUT BEING READ IS NORMAL FORTRAN.
C            = 1, INPUT BEING READ IS COMMENT SECTION.
C            = -1, INPUT BUFFER CONTAINS EITHER  CRENBR  OR
C              ELSE RENBRSTART  COMMAND LINE TO BE INCLUDED
C              WITH NEXT TEXT READ FROM INPUT FILE.
C     KOMKNT = TOTAL NUMBER OF FORTRAN COMMENT  LINES  READ
C              DURING CURRENT EXECUTION OF RENBR.
C     KOMNUM = 0, NO SCAN FOR STATEMENT NUMBERS IN COMMENTS
C            = 1, SCAN FOR STATEMENT NUMBERS IN COMMENTS
C     KONTRL = USED BY  HIGHER  LEVEL  ROUTINES  TO  SELECT
C              OPTIONS  FROM  ROUTINES  REINDX,  RETITL AND
C              RECMDN.  OBVIOUSLY, NONE OF LATTER  ROUTINES
C              CAN CALL EACH OTHER.  MEANINGS OF KONTRL FOR
C              EACH OF THESE ROUTINES IS DESCRIBED AT START
C              OF ROUTINE.
C     KOUNT  = IF  IN  SECOND  PASS  AND  READING   FORTRAN
C              ROUTINE,  KOUNT  IS LINE NUMBER OF STATEMENT
C              HELD IN UPPER AND LOWER SECTIONS  OF  LTRBIG
C              BUFFER ARRAY.
C            = IF IN SECOND  PASS  AND  READING  NONFORTRAN
C              COMMENT  SECTION,  KOUNT  IS  LINE NUMBER OF
C              LINE ABOUT TO BE OUTPUT.
C     KPAGE  = STORES PAGE NUMBER  OF  FIRST  PAGE  OF  THE
C              LISTING.   THIS  IS COMPARED WITH FINAL PAGE
C              NUMBER AT END OF LISTING TO CALCULATE  TOTAL
C              NUMBER   OF  PAGES  IN  LISTING.   KPAGE  IS
C              REDUCED BY 1 FOR  EVERY  PAGE  OF  TABLE  OF
C              CONTENTS (WHICH CAN BE PRODUCED IN MIDDLE OF
C              LISTING IF TABLE OF CONTENTS STORAGE  FILLS,
C              AS  FOR  EXAMPLE  AFTER  FINDING  MANY ENTRY
C              STATEMENTS) SINCE TABLE OF CONTENTS  IS  NOT
C              ITSELF PAGE NUMBERED.
C     KPASS  = VALUE TO BE ASSIGNED TO  IPASS  WHEN  RENUMB
C              ROUTINE  IS  CALLED  TO  FIND  NEW STATEMENT
C              NUMBER CORRESPONDING TO  OLD  AND  TO  STORE
C              REFERENCE FOR LISTING.
C            = -1,  RENUMBERING  IS  BEING  PERFORMED.   IF
C              LISTING  IS  BEING CREATED, THEN IT WILL NOT
C              INCLUDE IN CROSS REFERENCE  TABLE  ANY  LINE
C              NUMBERS  HAVING  NUMBERS  AS THEIR STATEMENT
C              NUMBERS.
C            = 2, EITHER RENUMBERING IS NOT BEING PERFORMED
C              OR  ELSE  OLD  STATEMENT  NUMBERS  ARE BEING
C              RETAINED  AS  WHEN  THERE   ARE   TOO   MANY
C              STATEMENT  NUMBERS  TO  BE CONTAINED IN NOLD
C              AND NNEW ARRAYS OR WHEN /M SWITCH IS  ISSUED
C              BY USER WITHOUT ANY FOLLOWING ARGUMENTS.  IF
C              LISTING  IS  BEING  CREATED,  THEN  IT  WILL
C              INCLUDE   IN   CROSS   REFERENCE  TABLE  AND
C              INDICATED BY MINUS SIGNS  ALL  LINE  NUMBERS
C              HAVING NUMBERS AS THEIR STATEMENT NUMBERS.
C     KPOINT = LOCAL    VARIABLE    HAVING    NO    SPECIAL
C              SIGNIFICANCE
C     KPYEND = SUBSCRIPT WITHIN  LOWER  SECTION  OF  LTRBIG
C              ARRAY    OF    CHARACTER    STARTING    NEXT
C              CONTINUATION LINE OF COPIED  STATEMENT.   IT
C              IS  TO  SUCH  LINE  BREAKS THAT SCANNING FOR
C              ENDS OF WORDS TO BE PLACED  INTO  DICTIONARY
C              ADVANCES IF EXCLAMATION POINT IS FOUND.
C     KSTN   = POINTS TO FIRST DIGIT OF STATEMENT NUMBER IN
C              UPPER  SECTION  OF LTRBIG BUFFER ARRAY FOUND
C              DURING SYNTAX ANALYSIS.   POINTER  STRUCTURE
C              IS DESCRIBED IN COMMENT LINES IN RENBR BLOCK
C              DATA  ROUTINE  WHICH  DESCRIBE  NUMPRS   AND
C              LTRPRS ARRAYS.
C     KTAB   = MAXIMUM VALUE OF SUBSCRIPT OF UPPER  END  OF
C              BUFFER  AREA  IN  LTRBIG ARRAY USED TO STORE
C              COMMENTS AFTER  TAB  CONVERSION  TO  BLANKS.
C              ACTUALLY KTAB EQUALS SIZE OF LTRBIG ARRAY.
C     KUTNUM = MINIMUM  NUMBER OF  LOCATIONS WHICH  MUST BE
C              UNUSED IN NOLD  AND  NNEW ARRAYS WHEN TOP OF
C              NEW PAGE  IS PRINTED  IN  LISTING.   IF LESS
C              LOCATIONS ARE AVAILABLE, THEN THE LISTING OF
C              THE STATEMENT  NUMBER REFERENCES  IS PRINTED
C              BEFORE THE LISTING IS CONTINUED.
C     KUTPAG = TOTAL NUMBER OF LINES WHICH CAN  BE  PRINTED
C              ON  CURRENT  PAGE.  KNT (THE NUMBER OF LINES
C              ACTUALLY PRINTED) IS COMPARED AGAINST KUTPAG
C              TO  DETERMINE  WHETHER  TOP  OF PAGE MUST BE
C              ISSUED.  KUTPAG IS SET TO ZERO WHENEVER  ONE
C              PART  OF  PROGRAM  WISHES TO FORCE FOLLOWING
C              PRINTING  TO  BEGIN  NEW  PAGE.   KUTPAG  IS
C              ALWAYS  RESET  TO JFORM WHENEVER NEW PAGE IS
C              STARTED.
C     KUTPNT = MINIMUM NUMBER OF LOCATIONS  WHICH  MUST  BE
C              UNUSED  IN NUMPNT ARRAY WHEN TOP OF NEW PAGE
C              IS PRINTED IN LISTING.   IF  LESS  LOCATIONS
C              ARE  AVAILABLE,  THEN  CURRENT  CONTENTS  OF
C              INDEX  ARE  GENERATED  BEFORE   LISTING   IS
C              CONTINUED.
C     KUTSPL = MINIMUM NUMBER OF LOCATIONS  WHICH  MUST  BE
C              UNUSED  IN LTRSPL ARRAY WHEN TOP OF NEW PAGE
C              IS PRINTED IN LISTING.   IF  LESS  LOCATIONS
C              ARE  AVAILABLE,  THEN  CURRENT  CONTENTS  OF
C              INDEX  ARE  GENERATED  BEFORE   LISTING   IS
C              CONTINUED.
C     LCLNUM = NUMBER OF LOCATIONS IN EITHER NOLD  OR  NNEW
C              ARRAYS  USED  DURING  PROCESSING  OF CURRENT
C              ROUTINE TO STORE STATEMENT NUMBERS.
C     LCLPNT = NUMBER OF LOCATIONS  IN  NUMPNT  ARRAY  USED
C              DURING  PROCESSING  OF  CURRENT  ROUTINE  TO
C              STORE NUMERIC INFORMATION TO BE INCLUDED  IN
C              INDEX.   IF  INDEX  IS  PRINTED IN MIDDLE OF
C              LISTING OF ROUTINE,  THEN  SOME  OF  NUMERIC
C              INFORMATION CONCERNING WORDS WHICH APPEAR IN
C              BOTH SECTIONS  WILL  BE  COUNTED  MORE  THAN
C              ONCE.
C     LCLSPL = NUMBER OF LOCATIONS  IN  LTRSPL  ARRAY  USED
C              DURING  PROCESSING  OF  CURRENT  ROUTINE  TO
C              STORE CHARACTERS TO BE  INCLUDED  IN  INDEX.
C              IF  INDEX IS PRINTED IN MIDDLE OF LISTING OF
C              ROUTINE,  THEN  CHARACTERS  OF  WORDS  WHICH
C              APPEAR  IN  BOTH  SECTIONS  WILL BE INCLUDED
C              MORE THAN ONCE.
C     LEFT   = LOCATION  WITHIN  LOWER  SECTION  OF  LTRBIG
C              ARRAY  AT  WHICH  STARTS  LINE  NUMBER FIELD
C              ASSOCIATED  WITH  FORTRAN  STATEMENT.   LINE
C              NUMBER  FIELD  EXTENDS THROUGH LOW1 AND IS 4
C              CHARACTERS WIDE.  NOTE THAT  WITHIN  COMMENT
C              SECTION,  LINE NUMBER FIELD BEGINS AT MTAB-3
C              AND EXTENDS THROUGH MTAB.
C     LEND   = USED BY REINDX ROUTINE TO STORE LOCATION  IN
C              LTRBIG  ARRAY  OF  START  OF NUMBER AS IT IS
C              BEING SEARCHED FOR FOLLOWING H.
C            = USED BY RENEXT ROUTINE  TO  STORE  START  OF
C              NEXT LINE AS ARE LOOKING FOR END OF MULTIPLE
C              CHARACTER  OPERATOR  WHICH   COULD   CONTAIN
C              COMMENTS MARKED BY EXCLAMATION POINTS.
C     LIKE   = NUMBER OF BLANKS WHICH SHOULD BE ADDED TO OR
C              REMOVED   FROM   END   OF  CURRENT  LINE  OF
C              MULTILINE STATEMENT WHEN COPIED  FROM  UPPER
C              TO  LOWER  SECTION  OF  LTRBIG  ARRAY.  IEND
C              MARKS START OF  NEXT  CONTINUATION  LINE  IN
C              UPPER SECTION, AND WHEN JIN REACHES IEND, IF
C              LIKE IS POSITIVE THEN EXTRA BLANKS ARE ADDED
C              PROVIDING  LOWER  SECTION  DOES  NOT OVERLAP
C              UPPER SECTION, OR IF LIKE IS  NEGATIVE  THEN
C              BLANKS  IF  PRESENT  ON LINE JUST COPIED ARE
C              REMOVED.
C     LINREF = ARRAY USED BY REINDX ROUTINE  TO  ACCUMULATE
C              LINE  NUMBERS  WHICH  ARE  TO  BE PRINTED ON
C              SINGLE LINE IN INDEX.  THESE NUMBER ARE  NOT
C              CONTIGUOUS  IN  NUMPNT ARRAY SO THAT PORTION
C              OF NUMPNT ARRAY  CANNOT  SIMPLY  BE  PRINTED
C              DIRECTLY.
C     LMTTOC = NUMBER OF ROUTINE DESCRIPTIONS WHICH CAN  BE
C              WRITTEN ON SINGLE PAGE OF TABLE OF CONTENTS.
C     LNGCOM = MAXIMUM NUMBER OF CHARACTERS TO BE  KEPT  IN
C              COMMENT  LINE IN FORTRAN PROGRAM OR ROUTINE.
C     LNGNAM = NUMBER OF CHARACTERS STORED IN LTRNAM  ARRAY
C              BY  REINDX  ROUTINE WHILE SEARCHING FOR NEXT
C              ITEM  TO  BE  PLACED  INTO  INDEX.
C     LNGNXT = NUMBER OF CHARACTERS  TO BE RETAINED IN NEXT
C              COMMENT LINE.  LNGCOM IS ASSIGNED THIS VALUE
C              AFTER CURRENT COMMENT LINE IS WRITTEN OUT.
C     LOCALA = THROUGH  LOCALM  USED  IN  RETITL ROUTINE TO
C              STORE STARTING AND ENDING LOCATIONS IN  EACH
C              ARRAY  WHICH  IS TO BE WRITTEN OUT AS SINGLE
C              LINE IN TABLE OF  CONTENTS.   THESE  DO  NOT
C              APPEAR IN COMMON BLOCK.
C     LOWDO  = NUMBER OF LOCATIONS IN NOLD AND NNEW  ARRAYS
C              AVAILABLE  TO  STORE  STATEMENT  NUMBERS FOR
C              MAPPING FROM OLD  TO  NEW  STATEMENT  NUMBER
C              AND/OR  TO APPEAR IN CROSS REFERENCE TABLES.
C              LOWDO IS EQUAL TO IHIHDO EXCEPT WHEN OPEN DO
C              LOOPS  ARE  BEING  PROCESSED  IN  WHICH CASE
C              LOWDO POINTS TO LOCATION  BELOW  STORAGE  IN
C              NOLD AND NNEW OF STATEMENT NUMBER REFERENCED
C              BY MOST RECENTLY PROCESSED DO STATEMENT.
C     LOWER  = LOCATION IN LOWER SECTION OF LTRBIG ARRAY AT
C              WHICH  STORAGE  OF  FINAL  FORM OF STATEMENT
C              STARTS.  LTRBIG(LOWER) IS START OF STATEMENT
C              NUMBER   FIELD  UNLESS  FIRST  CHARACTER  IN
C              STATEMENT  IS  NONBLANK,  NONTAB,   NONDIGIT
C              CHARACTER   OTHER  THAN  C,  IN  WHICH  CASE
C              LTRBIG(LOWER)    CONTAINS    THIS    LEADING
C              CHARACTER  AND STATEMENT NUMBER FIELD STARTS
C              AT LOWER+1.  NEWSTN IS LOCATION OF START  OF
C              STATEMENT NUMBER FIELD.
C     LOWSHO = LOCATION IN NNEW ARRAY OR IN LTRSPL ARRAY AT
C              WHICH IS TO BE FOUND NEXT ITEM TO BE PRINTED
C              IN CROSS REFERENCE TABLE OR INDEX WHEN  THIS
C              IS BEING GENERATED BY REINDX ROUTINE.
C     LOWTOC = SEQUENCE NUMBER OF DESCRIPTION IN NUMTOC AND
C              LTRTOC   ARRAYS   OF   ROUTINE   WHICH   HAS
C              ALPHABETICALLY LOWEST  NAME.   IF  LOWTOC=4,
C              THEN  ROUTINE  WHICH  WAS ENCOUNTERED FOURTH
C              HAS ALPHABETICALLY LOWEST NAME.
C     LOW1   = LOCATION  WITHIN  LOWER  SECTION  OF  LTRBIG
C              ARRAY   AT  WHICH  ENDS  LINE  NUMBER  FIELD
C              ASSOCIATED  WITH  FORTRAN  STATEMENT.   LINE
C              NUMBER   FIELD  STARTS  AT  LEFT  AND  IS  4
C              CHARACTERS WIDE.  NOTE THAT  WITHIN  COMMENT
C              SECTION,  LINE NUMBER FIELD BEGINS AT MTAB-3
C              AND EXTENDS THROUGH MTAB.
C     LOW2   = LOCATION AT WHICH STORAGE  OF  COMMENT  LINE
C              BEGINS  AFTER  CONVERSION OF TABS TO BLANKS.
C              LOW2 IS 1 LOCATION BEYOND MTAB.
C     LPTTTY = -1, LISTING DEVICE IS LINE  PRINTER.   WRITE
C              DIRECTORY OF FILES TO TERMINAL.
C            = 0,  LISTING  DEVICE  IS  DISK  FILE.   WRITE
C              DIRECTORY OF FILES TO TERMINAL.
C            = 1, LISTING DEVICE IS COMMAND  TERMINAL.   DO
C              NOT WRITE DIRECTORY OF FILES TO TERMINAL.
C     LRGNUM = MAXIMUM NUMBER OF LOCATIONS USED  IN  EITHER
C              NOLD  OR  NNEW ARRAYS ANYTIME DURING CURRENT
C              EXECUTION OF RENBR.
C     LRGPNT = MAXIMUM NUMBER OF LOCATIONS WHICH HAVE  BEEN
C              USED  IN  NUMPNT  ARRAY (WHICH STORES INDEX)
C              ANYTIME DURING CURRENT EXECUTION OF RENBR
C     LRGSPL = MAXIMUM NUMBER OF LOCATIONS WHICH HAVE  BEEN
C              USED  IN LTRSPL ARRAY (WHICH STORES WORDS IN
C              INDEX) ANYTIME DURING CURRENT PROCESSING.
C     LRGTOC = TOTAL NUMBER OF ENTRIES IN TABLE OF  CONTENT
C              STORAGE  WHICH HAVE BEEN USED DURING CURRENT
C              EXECUTION OF  RENBR.   THIS  INCLUDES  SPACE
C              WHICH HAS BEEN REUSED.
C     LSTKNT = LINE NUMBER OF LAST FORTRAN ENTRY  STATEMENT
C              OR  OF LAST RENBRTITLE COMMAND LINE.  LSTKNT
C              IS USED TO CALCULATE  NUMBER  OF  STATEMENTS
C              ASSOCIATED  WITH  EACH  PORTION  OF  PROGRAM
C              DIVIDED BY ENTRY STATEMENTS OR EACH  PORTION
C              OF  COMMENT  SECTION  DIVIDED  BY RENBRTITLE
C              COMMAOD LIOES.  LSTKOT WOULD BE 1  (POINTING
C              TO  START OF ROUTINE) IF FIRST STATEMENT HAS
C              ALREADY  BEEN  PROCESSED   IN   PROGRAM   OR
C              ROUTINE,  BUT  ENTRY  STATEMENT  HAS NOT YET
C              BEEN FOUND.  LSTKNT WOULD SIMILARLY BE 1  IN
C              COMMENT  SECTION UNTIL RENBRTITLE COMMAND IS
C              FOUND AFTER FIRST LINE OF COMMENT SECTION.
C     LSTN   = POINTS TO LEFT DIGIT OF STATEMENT NUMBER  IF
C              ANY,  OR TO CHARACTER PRECEDING STATEMENT IF
C              THERE IS NO  STATEMENT  NUMBER.   RENUMBERED
C              OUTPUT  CAN  BE  GENERATED  IN TAB FORMAT BY
C              WRITING LTRBIG ARRAY  STARTING  AT  LOCATION
C              LSTN,  POSSIBLY  PRECEDED  BY  CHARACTER  IN
C              LOCATION LOWER  IF  STATEMENT  STARTED  WITH
C              NONBLANK,  NONTAB,  NONDIGIT CHARACTER OTHER
C              THAN C WHICH  MUST  BE  COPIED  INTO  OUTPUT
C              UNCHANGED.
C     LSTSTN = LOCATION IN LOWER PROTION  OF  LTRBIG  ARRAY
C              INTO   WHICH   FIRST  CHARACTER  OF  CURRENT
C              STATEMENT  HAS  BEEN  INSERTED.    THIS   IS
C              PREVIOUS  VALUE  OF NEWSTN.  THIS WILL EQUAL
C              LOWER  UNLESS  NONDIGIT  PRINTING  CHARACTER
C              OTHER  THAN  C WAS FOUND AT START OF LINE IN
C              WHICH CASE LSTSTN=LOWER+1.
C     LTAB   = 0, NO CONVERSION OF TABS TO BLANKS IS TO  BE
C              PERFORMED  IN  COMMENT  LINES  IN RENUMBERED
C              OUTPUT.
C            = 1, CONVERT TABS IN COMMENT LINES  TO  BLANKS
C              TO   GIVE   TAB   STOPS  OF  WIDTH  JTAB  IN
C              RENUMBERED OUTPUT.
C     LTRABC = (AND LOWER CASE IN LWRABC)  LETTERS  THROUGH
C              Z.
C     LTRBGN = (AND LOWER CASE IN LWRBGN) LETTERS  OF  WORD
C              START WHICH CAN APPEAR IN RENBRSTART COMMAOD
C              LIOE.
C     LTRBIG = BUFFER  INTO  WHICH  CURRENT  STATEMENT   IS
C              ACCUMULATED AND IN WHICH STATEMENT IS COPIED
C              REPLACING STATEMENT NUMBERS.  UPPER  PORTION
C              ACCUMULATES STATEMENT UNTIL END OF STATEMENT
C              IS SIGNALLED BY  NEW  STATEMENT  BEING  READ
C              INTO LTR120 ARRAY.  STATEMENT IS THEN COPIED
C              INTO LOWER SECTION  WITH  STATEMENT  NUMBERS
C              BEING  REPLACED  AS NECESSARY.  EACH WORD IN
C              LTRBIG ARRAY CONTAINS SINGLE CHARACTER  READ
C              BY   A1   FORMAT  FIELD.   LTRBIG  ARRAY  IS
C              DESCRIBED IN MORE DETAIL IN RENBR BLOCK DATA
C              ROUTINE.
C     LTRCLN = COLON CHARACTER  WHICH  CAN  APPEAR  BETWEEN
C              SWITCH LETTER AND FOLLOWING NUMBER ON CRENBR
C              COMMAND LINE
C     LTRCOM = CHARACTERS  WHICH  INDICATE  A COMMENT  LINE
C              WHEN THEY APPEAR IN COLUMN 1.  MAXCOM IS THE
C              NUMBER OF CHARACTERS IN THIS ARRAY.
C     LTRDDD = (AND LOWER CASE IN LWRDDD)  LETTER  D  WHICH
C              CAN   APPEAR  LEFT  OF  EXPONENT  IN  DOUBLE
C              PRECISION NUMBERS.
C     LTRDGT = DIGITS 0 THROUGH 9.
C     LTRDOT = PERIOD CHARACTER WHICH CAN  APPEAR  IN  REAL
C              AND DOUBLE PRECISION NUMBERS.
C     LTREEE = (AND LOWER CASE IN LWREEE)  LETTER  E  WHICH
C              CAN APPEAR LEFT OF EXPONENT IN REAL NUMBERS.
C     LTREND = (AND LOWER CASE IN LWREND) LETTERS  OF  WORD
C              END WHICH MARKS END OF PROGRAM OR ROUTINE.
C     LTREQL = EQUAL SIGN.   USED  WHEN  MARKING  ITEMS  IN
C              INDEX   WHICH  ARE  DEFINED  BY  EQUAL  SIGN
C              OPERATOR.
C     LTREXC = EXCLAMATION POINT USED TO MARK  COMMENTS  IN
C              STATEMENT TEXT FIELD.
C     LTRFLG = (AND LOWER CASE IN LWRFLG) LETTERS WHICH CAN
C              APPEAR AS SWITCHES ON CRENBR COMMAND LINE.
C     LTRHHH = (AND LOWER CASE IN LWRHHH) LETTER H WHICH IS
C              USED  TO  SEPARATE  NUMBER  OF CHARACTERS IN
C              TEXT STRING FROM CHARACTERS OF TEXT STRING.
C     LTRKEY = (AND LOWER CASE IN LWRKEY) LETTERS OF  RENBR
C              NAME WHICH  APPEAR IN  CRENBR, RENBSTART AND
C              ALSO RENBRTITLE COMMAND LINES.
C     LTRLFT = LEFT  PARENTHESIS.   USED   IN   PARENTHESIS
C              COUNTING  AND  AT  START  OF  TITLE/SUBTITLE
C              SECTION OF CRENBR OR OTHER COMMAND LINES.
C     LTRMNS = MINUS SIGN.  USED WHEN  EVALUATING  NEGATIVE
C              NUMBERS IN CRENBR COMMAND LINE.
C     LTRNAM = ARRAY USED BY REINDX ROUTINE  TO  ACCUMULATE
C              UP  TO  10  CHARACTERS WHICH FORM ITEM TO BE
C              INDEXED.  THESE CHARACTERS DO NOT NEED TO BE
C              CONTIGUOUS   IN   ORIGINAL  STATEMENT  SINCE
C              SEVERAL COMMENTS INTRODUCED  BY  EXCLAMATION
C              POINTS COULD APPEAR WITHIN ITEM.
C     LTRNOW = USED LOCALLY WITHIN MANY  ROUTINES  WHENEVER
C              SINGLE  LETTER  IN  STRING  MUST  BE  TESTED
C              AGAINST  LIST  OF  OTHER  CHARACTERS.   THIS
C              PREVENTS  NEED  FOR CALCULATION OF SUBSCRIPT
C              OF  STRING  EACH  TIME  CHARACTER  MUST   BE
C              TESTED.
C     LTROPR = ARRAY CONTAINING CHARACTERS WHICH  CAN  FORM
C              FORTRAN  OPERATORS.   RECOGNITION  OF  THESE
C              OPERATORS  IS  CONTROLLED  BY  MCHOPR  ARRAY
C              WHICH  POINTS TO NEXT CHARACTER TO BE TESTED
C              IF CURRENT TEST IS SUCCESSFUL, AND BY NOTOPR
C              WHICH  POINTS TO NEXT CHARACTER TO BE TESTED
C              IF CURRENT TEST IS NOT SUCCESSFUL.
C     LTRPLS = PLUS SIGN.  ALLOWED BEFORE POSITIVE  NUMBERS
C              IN CRENBR COMMAND LINE.
C     LTRPRS = (AND LOWER CASE IN LWRPRS) ARRAY  CONTAINING
C              ALL   PUNCTUATION   MARKS   AND   KEY  WORDS
C              REFERENCED  BY  SYNTAX   RECOGNITION   TABLE
C              CONTAINED IN ARRAY NUMPRS.
C     LTRQOT = APOSTROPHE.   USED  TO  MARK  ENDS  OF  TEXT
C              STRINGS.
C     LTRREF = IF KOMNUM=1,  IS  LETTER  MARKING  STATEMENT
C              NUMBERS TO BE REPLACED IN COMMENTS
C     LTRRIT = RIGHT  PARENTHESIS.   USED  IN   PARENTHESIS
C              COUNTING   AND   AT  END  OF  TITLE/SUBTITLE
C              SECTION OF CRENBR AND OTHER COMMAND LINES.
C     LTRSEM = SEMICOLON.   USED  TO  SEPARATE   STATEMENTS
C              WHICH APPEAR ON SAME LINE.
C     LTRSLA = SLASH.  USED TO SEPARATE TITLE FROM SUBTITLE
C              ON  CRENBR AND OTHER COMMAND LINES.  ALLOWED
C              BEFORE SWITCH ON CRENBR COMMAND LINE.
C     LTRSPC = SPACE CHARACTER.
C     LTRSPL = ARRAY USED TO STORE  CHARACTERS  WHICH  FORM
C              WORDS  TO  BE  INCLUDED  IN INDEX.  THIS HAS
C              DIMENSION MAXSPL  AND  NUMBER  OF  LOCATIONS
C              CURRENTLY   IN  USE  IS  STORED  IN  KNTSPL.
C              LTRSPL STORES SINGLE CHARACTER  READ  BY  A1
C              FORMAT IN EACH ARRAY LOCATION.
C     LTRSRT = UPPER CASE LETTERS THROUGH Z SORTED ON LOWER
C              CASE  LETTERS  IN  LWRSRT.   THIS SORTING IS
C              DONE AT START OF EXECUTION TO  ALLOW  FASTER
C              CONVERSION OF LOWER CASE LETTERS IN INDEX TO
C              UPPER CASE.
C     LTRTAB = TAB CHARACTER.  USED TO  SEPARATE  STATEMENT
C              NUMBER  FIELD  FROM  STATEMENT  TEXT  FIELD.
C              WITHIN  STATEMENT  TEXT  IS  EQUIVALENT   TO
C              SPACE.
C     LTRTOC = ARRAY USED TO STORE NAMES OF ROUTINES TO  BE
C              INCLUDED  IN  TABLE  OF CONTENTS.  THESE ARE
C              EACH LEFT JUSTIFIED  IN  6  CHARACTERS  WITH
C              BLANK FILL.
C     LTRTOP = ARRAY  CONTAINING  TITLE  AND  SUBTITLE  FOR
C              LISTING.   TITLE  IS  IN  FIRST 68 LOCATIONS
C              WHICH TOGETHER WITH  9  CHARACTERS  OF  WORD
C              PAGE  AND  PAGE NUMBER (NEITHER OF WHICH ARE
C              STORED IN LTRTOP  ARRAY)  GIVE  67  PRINTING
C              CHARACTERS  ON  FIRST  LINE  OF  EACH  PAGE.
C              SUBTITLE IS IN  LOCATIONS  55  THRU  98  (44
C              CHARACTERS)  WHICH  TOGETHER  WITH  6 LETTER
C              ROUTINE NAME AND  UP  TO  13  CHARACTERS  OF
C              ROUTINE TYPE (COUNTING BLANK TO LEFT OF TYPE
C              MAIN PROGRAM, BOTH NAME AND TYPE BEING RIGHT
C              JUSTIFED  WITH  LEFT BLANK FILL IN LOCATIONS
C              99 THROUGH 117) SIMILARY GIVE 67  CHARACTERS
C              ON  SECOND LINE.  MAIN TITLE IS SPECIFIED BY
C              USER AT START OF  EXECUTION.   SUBTITLE,  IF
C              ANY,  IS  SPECIFIED  BY  CRENBR COMMAND LINE
C              WITHIN  ROUTINE,   OR   BY   RENBRTITLE   OR
C              BY RENBRSTART  COMMAND  LINE WITHIN  COMMENT
C              SECTION.
C     LTRTTL = (AND LOWER CASE IN LWRTTL) LETTERS  OF  WORD
C              TITLE USED IN RENBRTITLE COMMAND LINE.
C     LTRTYP = ARRAY CONTAINING CHARACTERS FORMING EACH  OF
C              ROUTINE  TYPES  WHICH CAN APPEAR IN TABLE OF
C              CONTENTS ONCE  PARCER  HAS  IDENTIFIED  THAT
C              TYPE.   START  OF  EACH  NAME  IS  STORED IN
C              NUMTYP ARRAY.
C     LTRUSE = ARRAY INTO WHICH NAME ESTABLISHED BY  CRENBR
C              COMMAND  LINE  DURING  FIRST  PASS IS STORED
C              UNTIL SECOND PASS.   IF  ITITLE  IS  GREATER
C              THAN   ZERO,   THEN   ITITLE  IS  NUMBER  OF
C              CHARACTERS IN NAME STORED IN  LTRUSE  ARRAY.
C              IF  ITITLE  IS  LESS  THAN OR EQUAL TO ZERO,
C              NOTHING IS STORED IN LTRUSE ARRAY.
C     LTR1ST = FIRST CHARACTER AGAINST WHICH NEXT CHARACTER
C              IN STATEMENT IS TESTED BY REPLAC ROUTINE.
C     LTR120 = ARRAY INTO WHICH STATEMENTS ARE  FIRST  READ
C              AND  IN WHICH FIRST LINE OF NEW STATEMENT IS
C              HELD  WHILE  PREVIOUS  STATEMENT  IN  LTRBIG
C              ARRAY  IS PROCESSED.  ALL 120 CHARACTERS ARE
C              READ FOR ALL LINES OF COMMENT SECTION EXCEPT
C              FOR  FIRST LINE.  80 CHARACTERS ARE READ FOR
C              LINES IN FOTRAN ROUTINES, BUT ONLY FIRST  72
C              ARE USED UNLESS LINE IS COMMENT LINE.
C     LTR2ND = FINAL CHARACTER AGAINST WHICH NEXT CHARACTER
C              IN STATEMENT IS TESTED BY REPLAC ROUTINE.
C     MANY   = SUBSCRIPT  USED  BY  REINDX  ROUTINE   WHILE
C              THREADING  10 ALPHABETIZED LISTS INTO SINGLE
C              INDEX.
C     MASTER = USED TO INDICATE WHY PROCESSING  OF  CURRENT
C              INPUT  FILE  WAS  TERMINATED  WHEN REUSER IS
C              ASKED FOR NEXT FILE SPECIFIED BY USER.
C            = 0, ALL PROCESSING COMPLETED.  USER IS  BEING
C              ASKED  IF  ANOTHER  SET  OF  FILES  IS TO BE
C              PROCESSED.
C            = 1, FIRST CALL TO REUSER COMMAND PARSER.   NO
C              FILES HAVE YET BEEN READ.
C            = 2, END OF FILE  READ  IN  FIRST  PASS  WHILE
C              RENUMBERING.
C            = 3, EXTRA END STATEMENT FOUND IN  FIRST  PASS
C              WHILE RENUMBERING.
C            = 4, EXTRA END STATEMENT FOUND IN  FINAL  PASS
C              WHILE LISTING ONLY.
C            = 5, END OF FILE  READ  IN  FINAL  PASS  WHILE
C              LISTING ONLY.
C            = ALSO  USED IN  RENBR MAIN  PROGRAM  TO ALLOW
C              EACH SUBROUTINE TO  CONTROL WHICH SUBROUTINE
C              IS CALLED NEXT.   THIS USE  IS DOCUMENTED IN
C              COMMENT LINES IN MAIN PROGRAM.
C     MAXCOM = NUMBER OF CHARACTERS  IN  LTRCOM ARRAY WHICH
C              CONTAINS THE CHARACTERS  WHICH CAN APPEAR IN
C              COLUMN 1 OF A COMMENT LINE.
C     MAXEND = SUBSCRIPT WITHIN  UPPER  SECTION  OF  LTRBIG
C              ARRAY  OF  LOCATION  CONTAINING CHARACTER TO
C              RIGHT OF RIGHTMOST PRINTING CHARACTER.  JEND
C              POINTS  TO  CHARACTER  TO RIGHT OF STATEMENT
C              AND IS ORIGINALLY EQUAL TO  MAXEND,  BUT  IS
C              RESET  TO POINT TO FIRST SEMICOLON IF ANY IS
C              ENCOUNTERED.  CONTENTS OF LTRBIG ARRAY  HAVE
C              BEEN  COMPLETELY  PROCESSED  IF  JEND  STILL
C              EQUALS MAXEND AFTER REMAINDER  OF  STATEMENT
C              HAS BEEN COPIED.
C     MAXLIN = MAXIMUM NUMBER OF LINES THAT CAN FORM SINGLE
C              STATEMENT PACKED IN LTRBIG ARRAY
C     MAXPNT = DIMENSION OF NUMPNT ARRAY WHICH STORES  LIST
C              OF LINES WHICH CONTAIN PARTICULAR WORDS.
C     MAXPRT = LOCATION WITHIN SMALL INPUT BUFFER OF  FINAL
C              NON-BLANK  CHARACTER  IN CURRENTLY READ LINE
C              OF STATEMENT TEXT.   IF  MAXPRT  IS  GREATER
C              THAN ISTART+65 (AS COULD HAPPEN IF STATEMENT
C              IS PRECEDED BY SINGLE TAB  AND  FOLLOWED  BY
C              SOMETHING IN LINE IDENTIFICATION FIELD) THEN
C              MAXPRT IS RESET TO ISTART+65.
C     MAXSPL = DIMENSION  OF  LTRSPL  ARRAY  WHICH   STORES
C              CHARACTERS OF WORDS WHICH ARE TO BE INCLUDED
C              IN INDEX.
C     MAXTOC = NUMBER OF ROUTINE DESCRIPTIONS WHICH CAN  BE
C              INCLUDED  IN  TABLE  OF  CONTENTS  EXCLUDING
C              PARTIAL FINAL PAGE PROVIDING  AT  LEAST  ONE
C              PAGE CAN BE STORED.
C     MCHOPR = ARRAY  CONTAINING  SUBSCRIPT  WITHIN  LTROPR
C              ARRAY OF NEXT CHARACTER TO BE MATCHED DURING
C              RECOGNITION OF FORTRAN OPERATORS IF  CURRENT
C              MATCH   IS   SUCCESSFUL.    NOTOPR  CONTAINS
C              SUBSCRIPT   IF   CURRENT   MATCH   IS    NOT
C              SUCCESSFUL.   ZERO  ENTRY  IN  MCHOPR  ARRAY
C              INDICATES  THAT  CURRENT   MATCH   COMPLETES
C              OPERATOR.
C     MID    = LOCATION WITHIN LTRBIG  ARRAY  OF  START  OF
C              UPPER SECTION INTO WHICH STATEMENT IS COPIED
C              UNTIL NO MORE CONTINUATION LINES ARE  FOUND.
C              ONLY  STATEMENT  TEXT  IS  COPIED INTO UPPER
C              SECTION  STARTING  AT  MID.   NEW  STATEMENT
C              NUMBER,   IF   ANY,  AND  LEADING  NONBLANK,
C              NONTAB, NONDIGIT CHARACTER OTHER THAN C,  IF
C              ANY,  ARE  BOTH  PLACED  DIRECTLY INTO LOWER
C              SECTION.  UPPER SECTION IS  LONG  ENOUGH  TO
C              CONTAIN  TWENTY  66  CHARACTER  LINES PLUS 1
C              ADDITIONAL   CHARACTER,   SO    NUMBER    OF
C              CONTINUATION  LINES  IS  TESTED  TO  PREVENT
C              OVERFLOW,  RATHER  THAN  TESTING  NUMBER  OF
C              CHARACTERS   ACTUALLY   PLACED   INTO  UPPER
C              SECTION.    ADDITIONAL   CHARACTER   ALLOWED
C              BEYOND   THOSE  NEEDED  FOR  20  FULL  LINES
C              CONTAINS NONDIGIT CHARACTER TO PREVENT  LOSS
C              OF  CONTROL  WHEN  SEARCHING  FOR  STATEMENT
C              NUMBER.
C     MODBAS = DURING FIRST PASS,  MODBAS  CONTAINS  LOWEST
C              STATEMENT  NUMBER  TO  BE  GENERATED IN THIS
C              ROUTINE.  MODBAS WILL EQUAL IBASE  UNLESS  B
C              OPTION  APPEARS  ON  CRENBR  COMMAND LINE IN
C              ROUTINE.  IF MODBAS=0, THEN LOWEST GENERATED
C              STATEMENT  NUMBER  WILL EQUAL ABSOLUTE VALUE
C              OF INCREMENT (STORED AS MODINC DURING  FIRST
C              PASS  AND  EQUAL  TO  INCR  UNLESS  I OPTION
C              APPEARS ON CRENBR COMMAND LINE).
C     MODINC = IF IN FIRST PASS,  MODINC  IS  INCREMENT  TO
C              ACTUALLY BE USED IN GENERATING NEW STATEMENT
C              NUMBERS.  THIS WILL BE EQUAL TO VALUE  TYPED
C              BY  USER  FOLLOWING  I  SWITCH UNLESS CRENBR
C              COMMAND LINE HAS ITSELF SPECIFIED  I  SWITCH
C              WITHIN CURRENT ROUTINE.
C     MODMAX = IN FIRST PASS,  MODMAX  IS  GIVEN  VALUE  OF
C              SECOND  NUMBER  WHICH FOLLOWS CHARACTER M ON
C              CRENBR COMMAND LINE, OR IS ZERO IF NO SECOND
C              NUMBER IS FOUND.
C     MODMIN = IN FIRST PASS, MODMIN IS  GIVEN  VALUE  ZERO
C              UNTIL   CHARACTER   M  APPEARING  ON  CRENBR
C              COMMAND LINE INDICATES THAT STATEMENT NUMBER
C              REGIONS CAN BE MIXED IN WHICH LATTER CASE IT
C              IS GIVEN VALUE FOLLOWING M OR ELSE -1 IF  NO
C              VALUE FOLLOWS M.
C     MODNEW = DURING FIRST PASS, MODNEW CONTAINS  SIZE  OF
C              LOGICAL   REGIONS,   IF  ANY,  IN  GENERATED
C              STATEMENT NUMBER SEQUENCE.  SET BY N  OPTION
C              ON  CRENBR COMMAND LINE.  IF BOTH MODOLD AND
C              MODNEW  ARE  ZERO,  NO  LOGICAL  REGIONS  OF
C              STATEMENT NUMBERS ARE TO BE PRESERVED.
C     MODOLD = DURING FIRST PASS, MODOLD CONTAINS  SIZE  OF
C              LOGICAL   REGIONS,   IF   ANY,  IN  ORIGINAL
C              STATEMENT NUMBER SEQUENCE.  SET BY O  OPTION
C              ON  CRENBR COMMAND LINE.  IF BOTH MODOLD AND
C              MODNEW  RE  ZERO,  NO  LOGICAL  REGIONS   OF
C              STATEMENT NUMBERS ARE TO BE PRESERVED.
C     MOST   = TOTAL NUMBER OF LOCATIONS IN NOLD  AND  NNEW
C              ARRAYS  CURRENTLY  IN  USE.   THIS  INCLUDES
C              STATEMENT NUMBER REFERENCES IN UPPER SECTION
C              IF  PRODUCING  LISTING  AND STATEMENT NUMBER
C              CORRESPONDENCE   FROM   ORIGINAL   STATEMENT
C              NUMBERS   TO   NEW   STATEMENT   NUMBERS  IF
C              RENUMBERING.  MOST WILL EQUAL  MSTN,  NUMBER
C              OF  STATEMENTS  BEARING STATEMENT NUMBERS IF
C              NO LISTING IS BEING PRODUCED.
C     MOVE   = NUMBER OF BLANKS WHICH STATEMENTS ARE TO  BE
C              INDENTED.    MOVE  IS  MULTIPLE  OF  INDENT,
C              INDENTATION PER DO LOOP LEVEL.
C     MSTN   = IF RENUMBERING, NUMBER OF STATEMENTS BEARING
C              STATEMENT  NUMBERS  IN  CURRENT  PROGRAM  OR
C              ROUTINE.   THIS  IS  NUMBER   OF   STATEMENT
C              NUMBERS  STORED IN LOWER SECTION OF NOLD AND
C              NNEW ARRAYS.  IF NOT RENUMBERING, THEN  MSTN
C              EQUALS  ZERO.   MSTN IS  ALSO SET TO ZERO IF
C              OLD STATEMENT NUMBERS ARE BEING RETAINED.
C     MTAB   = LOCATION  WITHIN  LOWER  SECTION  OF  LTRBIG
C              BUFFER  ARRAY OF UPPER END OF LINE NUMBER OF
C              COMMENT LINE WITHIN  COMMENT  SECTION  AFTER
C              CONVERSION  OF  TABS  TO  BLANKS.  MTAB IS 1
C              LESS  THAN  LOW2,  LOCATION  OF   START   OF
C              EXPANDED COMMENT LINE ITSELF.
C     NCD    = DURING SECOND PASS,  NUMBER  OF  LINES  READ
C              CONTAINING CURRENT STATEMENT.  NCD IS THUS 1
C              PLUS NUMBER OF CONTINUATION LINES.
C            = DURING FIRST PASS, USED DURING ASSIGNMENT OF
C              NEW  STATEMENT  NUMBERS TO CONTAIN SUBSCRIPT
C              OF NOLD AND NNEW ARRAYS AT  WHICH  TO  START
C              RENUMBERING  (1 UNLESS INCREMENT IS NEGATIVE
C              INDICATING  NCD  IS  EQUAL  TO   NUMBER   OF
C              STATEMENT NUMBERS).
C     NEED   = DURING SECOND PASS, NEED IS NUMBER OF BLANKS
C              TO  BE  INSERTED  AFTER  NONBLANK PORTION OF
C              CURRENT STATEMENT IN UPPER PORTION OF LTRBIG
C              BUFFER  IF  STATEMENT  IS  CONTINUED BY NEXT
C              LINE READ INTO LTR120 ARRAY.
C            = DURING FIRST PASS, USED DURING ASSIGNMENT OF
C              NEW  STATEMENT  NUMBERS TO CONTAIN SUBSCRIPT
C              OF  NOLD  AND  NNEW  ARRAYS  AT   WHICH   TO
C              TERMINATE  RENUMBERING  (EQUAL  TO NUMBER OF
C              STATEMENT  NUMBERS   UNLESS   INCREMENT   IS
C              NEGATIVE INDICATING NEED IS EQUAL TO 1).
C     NEWNUM = USED IN SECOND PASS TO ACCUMULATE  VALUE  OF
C              ORIGINAL   STATEMENT   NUMBER  IN  STATEMENT
C              NUMBER  FIELD   OF   NONCOMMENT   STATEMENT.
C              NEWNUM  HAS  VALUE  0  IF STATEMENT DOES NOT
C              HAVE  STATEMENT  NUMBER,  OR  VALUE  -1   IN
C              COMMENT LINE.
C     NEWSTN = LOCATION IN LOWER PORTION  OF  LTRBIG  ARRAY
C              INTO  WHICH  FIRST  CHARACTER  OF  STATEMENT
C              NUMBER  FIELD  IS  TO  BE  INSERTED.    THIS
C              LOCATION  CAN BE EQUAL TO EITHER LOWER OR TO
C              LOWER+1  DEPENDING  ON  WHETHER   NON-DIGIT,
C              NON-BLANK,  NON-TAB  CHARACTER  OTHER THAN C
C              APPEARED  AT  START   OF   FIRST   LINE   OF
C              STATEMENT.   IF  SUCH CHARACTER IS FOUND, IT
C              IS COPIED INTO LTRBIG(LOWER) AND NEWSTN  HAS
C              VALUE  LOWER+1.  THIS VALUE IS FOR STATEMENT
C              ABOUT  TO  BE  COPIED  INTO  LOWER  SECTION.
C              LSTSTN  IS  VALUE  FOR STATEMENT CURRENTY IN
C              LOWER SECTION.
C     NNEW   = ARRAY CONTAINING  VALUES  KEPT  PARALLEL  TO
C              STATEMENT   NUMBERS   IN   NOLD  ARRAY.   IF
C              RENUMBERING, THEN LOCATIONS 1  THROUGH  MSTN
C              CONTAIN  NEW STATEMENT NUMBERS CORRESPONDING
C              TO OLD STATEMENT NUMBERS IN NOLD ARRAY.   IF
C              MAKING   LISTING,   THEN   LOCATIONS  MSTN+1
C              THROUGH MOST CONTAIN LINE NUMBERS  IN  WHICH
C              STATEMENT  NUMBERS  ARE  REFERENCED.  IF NOT
C              RENUMBERING,  THEN  STATEMENT   NUMBERS   IN
C              STATEMENT  NUMBER  FIELD  ARE STORED IN NOLD
C              ARRAY SIMILARLY TO NUMBERS REFERENCED WITHIN
C              STATEMENTS  EXCEPT THAT LINE NUMBERS IN NNEW
C              ARRAY ARE  NEGATIVE  FOR  NUMBERS  FOUND  IN
C              STATEMENT  NUMBER  FIELD.   IF  THERE ARE DO
C              LOOPS  IN  PROGRAM  BEING  PROCESSED,   THEN
C              LOCATIONS   LOWDO+1   THROUGH   IHIHDO  (THE
C              DIMENSION OF NOLD AND NNEW)  CONTAIN  NUMBER
C              OF  DO  STATEMENTS WHICH REFERENCE STATEMENT
C              NUMBERS KEPT PARALLEL IN NOLD ARRAY.
C     NOLD   = ARRAY  CONTAINING,   IF   RENUMBERING,   OLD
C              STATEMENT  NUMBERS  IN  LOCATIONS  1 THROUGH
C              MSTN.  THESE STATEMENT NUMBERS ARE SORTED IN
C              INCREASING   ORDER.    IF   MAKING  LISTING,
C              LOCATIONS  MSTN+1   THROUGH   MOST   CONTAIN
C              STATEMENT  NUMBERS  FOUND  WITHIN STATEMENTS
C              DURING SECOND  PASS.   IF  NOT  RENUMBERING,
C              THEN MSTN WILL BE ZERO AND STATEMENT NUMBERS
C              FOUND IN STATEMENT NUMBER FIELD ARE INCLUDED
C              IN  ORDER  FOUND  WITHIN  SUBSCRIPT  RANGE 1
C              THROUGH MOST.  IF PROGRAM  BEING  RENUMBERED
C              CONTAINS  DO  LOOPS,  THEN LOCATIONS LOWDO+1
C              THROUGH  IHIHDO  CONTAIN  STATEMENT  NUMBERS
C              WHICH TERMINATE CURRENTLY OPEN DO LOOPS.  IF
C              NOT MAKING LISTING,  THEN  MOST  WILL  EQUAL
C              MSTN.
C     NONFOR = TOTAL NUMBER OF NON-FORTRAN STATEMENTS  READ
C              FOR   ALL   COMMENT   SECTIONS  DURING  THIS
C              EXECTUION OF RENBR
C     NOTOPR = ARRAY  CONTAINING  SUBSCRIPT  WITHIN  LTROPR
C              ARRAY OF NEXT CHARACTER TO BE MATCHED DURING
C              RECOGNITION OF FORTRAN OPERATORS IF  CURRENT
C              MATCH  IS  NOT  SUCCESSFUL.  MCHOPR CONTAINS
C              SUBSCRIPT IF CURRENT  MATCH  IS  SUCCESSFUL.
C              ZERO  ENTRY  IN  NOTOPR ARRAY INDICATES THAT
C              SEARCH  FOR  OPERATOR  FROM  PRESENT  ORIGIN
C              CANNOT SUCCEED AND SHOULD BE ABANDONED.
C     NOWTOC = USED BY RETITL WHEN  TABLE  OF  CONTENTS  IS
C              BEING  GENERATED  TO  FOLLOW  ALPHABETICALLY
C              ORDERED LIST OF ROUTINE NAMES  THROUGH  LIST
C              WHICH  HAS  BEEN  BUILT UP IN ORDER IN WHICH
C              ROUTINES WERE INSTEAD  ENCOUNTERED.   NOWTOC
C              IS  FIRST  SET TO LOWTOC, SERIAL LOCATION OF
C              ROUTINE NAME LOWEST  IN  ALPHABET,  THEN  IS
C              REPEATEDLY  RESET  TO  NUMTOC(NOWTOC)  UNTIL
C              ZERO VALUE IS ENCOUNTERED.
C     NSTN   = TOTAL NUMBER OF FORTRAN STATEMENTS READ  FOR
C              ALL   PROGRAMS   AND  ROUTINES  DURING  THIS
C              EXECUTION OF RENBR
C     NTAB   = USED BY REOUT ROUTINE TO STORE SUBSCRIPT  OF
C              LTRBIG  ARRAY  AT  WHICH  CURRENT PORTION OF
C              COMMENT LINE IS  TO  BE  SPLIT  IN  LISTING.
C              COMMENT LINE IN COMMENT SECTION CAN BE SPLIT
C              SEVERAL  TIMES  IF  IT  CONTAINS  MANY   TAB
C              CHARACTERS.
C     NUM    = USED IN SECOND PASS TO SEND STATEMENT NUMBER
C              TO  RENUMB  WHICH FINDS NEW STATEMENT NUMBER
C              CORRESPONDING TO OLD NUMBER AND RETURNS THIS
C              NEW  NUMBER IN NUM.  CALLING PROGRAM (EITHER
C              RE2ND  FOR NUMBER IN STATEMENT NUMBER FIELD,
C              REPLAC  FOR  NUMBER  IN  STATEMENT  TEXT, OR
C              REOUT FOR NUMBER IN  COMMENT  LINE)  DIVIDES
C              NUM  BY 10 UNTIL IT GETS ZERO VALUE IN ORDER
C              TO SPLIT OFF DIGITS.
C            = USED  IN  FIRST  PASS  TO  STORE   STATEMENT
C              NUMBERS IN STATEMENT NUMBER FIELD, AND AFTER
C              ALL OF ROUTINE HAS BEEN READ, NUM IS USED TO
C              STORE INCREMENT OF SUBSCRIPTS TO BE SEARCHED
C              FOR NEXT  STATEMENT  NUMBER  WITHIN  CURRENT
C              LOGICAL REGION OF STATEMENT NUMBERS.
C     NUMPNT = ARRAY USED TO STORE INFORMATION ABOUT  WORDS
C              WHICH  ARE  TO BE INCLUDED IN INDEX.  NUMPNT
C              ARRAY IS LINKED LIST CONTAINING 2  TYPES  OF
C              ITEMS.   WHEN  PREVIOUSLY  UNKNOWN  WORD  IS
C              ENCOUNTERED, 5 LOCATIONS  ARE  ALLOCATED  IN
C              NUMPNT.   FIRST OF THESE LOCATIONS POINTS TO
C              FIRST LOCATION IN DESCRIPTION OF NEXT HIGHER
C              ALPHABETICALLY  ORDERED WORD OF SAME LENGTH,
C              AND IS ITSELF POINTED TO BY  FIRST  LOCATION
C              IN  DESCRIPTION OF NEXT LOWER ALPHABETICALLY
C              ORDERED  WORD  OF   SAME   LENGTH.    SECOND
C              LOCATION  POINTS  TO FIRST CHARACTER OF WORD
C              IN LTRSPL ARRAY.  THIRD LOCATION  POINTS  TO
C              FOURTH  LOCATION AND WILL ALWAYS POINTING TO
C              MOST RECENT PAIR OF LOCATIONS  STORING  LINE
C              NUMBERS   IN  WHICH  WORD  WAS  ENCOUNTERED.
C              FOURTH LOCATION INITIALLY CONTAINS ZERO, BUT
C              WILL  POINT  TO  SECOND  PAIR  OF  LOCATIONS
C              STORING LINE NUMBERS ONCE  SECOND  LINE  HAS
C              BEEN  FOUND  TO  CONTAIN  SAME  WORD.  FIFTH
C              LOCATION CONTAINS LINE NUMBER ITSELF.  FIRST
C              LOCATION  IN  GROUP  OF  5  LOCATIONS  WHICH
C              DESCRIBE LOWEST ALPHABETICALLY ORDERED  WORD
C              OF   EACH   POSSIBLE   LENGTH   (THROUGH  10
C              CHARACTERS, LONGER WORDS BEING TRUNCATED  AT
C              19  CHARACTERS)  IS  POINTED  TO BY ENTRY IN
C              JPNT ARRAY HAVING AS ITS SUBSCRIPT NUMBER OF
C              CHARACTERS IN WORD.
C
C              IF WORD HAS ALREADY BEEN  ENCOUNTERED,  THEN
C              ONLY   PAIR  OF  LOCATIONS  IS  APPENDED  TO
C              CONTENTS OF NUMPNT ARRAY.   FIRST  OF  THESE
C              INITIALLY  CONTAINS  ZERO  BUT WILL POINT TO
C              NEXT PAIR OF LOCATIONS ONCE ANOTHER LINE HAS
C              BEEN  FOUND  TO  CONTAIN  SAME WORD.  SECOND
C              LOCATION CONTAINS LINE NUMBER.  LINE NUMBERS
C              ARE  NEGATIVE  IF  WORD  IS NAME OF VARIABLE
C              ASSIGNED VALUE BY EQUALS  SIGN  OPERATOR  IN
C              THAT LINE.
C
C              MAXPNT CONTAINS DIMENSION  OF  NUMPNT  ARRAY
C              AND  KNTPNT  CONTAINS  NUMBER  OF  LOCATIONS
C              CURRENTLY IN USE IN NUMPNT ARRAY.
C
C              AS EXAMPLE OF  STRUCTURE  OF  NUMPNT  ARRAY,
C              FOLLOWING  ILLUSTRATION  SHOWS  HOW 3 TRIPLE
C              LETTER WORDS MIGHT BE STORED IF  ENCOUNTERED
C              IN  ORDER DEF, ABC, DEF, GHI, DEF.  LEFT AND
C              RIGHT  PARENTHESES   HAVE   BEEN   USED   IN
C              ILLUSTRATION   INSTEAD  OF  LEFT  AND  RIGHT
C              ARROWS SINCE NOT ALL COMPUTERS  HAVE  LATTER
C              CHARACTERS.  PLUS SIGNS ARE USED WHERE LINES
C              TURN OR INTERSECT.
C
C                    NUMPNT(KNTPNT)          LTRSPL(KNTSPL)
C                          *                       *
C                          *                       *
C                 LINE CONTAINING DEF              *
C         +--------------) 0 (---------+           *
C         I                *           I           *
C         I                *           I           *
C         I       LINE CONTAINING GHI  I           *
C         I           +--) 0           I          1HI
C         I           +--(             I          1HH
C         I                  )-----------------)  1HG
C      +-----------------) 0           I           *
C      I  I                *           I           *
C      I  I                *           I           *
C      I  I       LINE CONTAINING DEF  I           *
C      I  I  +-----------)   )---------+           *
C      I  I  I             *                       *
C      I  I  I             *                       *
C      I  I  I    LINE CONTAINING ABC              *
C      I  I  I        +--) 0                      1HC
C      I  I  I        +--(                        1HB
C      I  I  I               )-----------------)  2HA
C      I  I  I  JPNT(3)--)   )---------+           *
C      I  I  I             *           I           *
C      I  I  I             *           I           *
C      I  I  I    LINE CONTAINING DEF  I           *
C      I  I  +-----------(             I          1HF
C      I  I--------------(             I          1HE
C      I                     )-----------------)  1HD
C      +-----------------(   (---------+           *
C                          *                       *
C                          *                       *
C                      NUMPNT(1)               LTRSPL(1)
C
C     NUMPRS = TABLE WHICH DRIVES SYNTAX RECOGNITION.  THIS
C              IS  DESCRIBED  IN DETAIL IN COMMENT LINES IN
C              BLOCK DATA ROUTINE.
C     NUMTOC = ARRAY USED TO STORE DESCRIPTIONS OF ROUTINES
C              TO  BE  INCLUDED  IN  TABLE  OF CONTENTS.  4
C              NUMBERS NEEDED  FOR  EACH  ROUTINE  ARE,  IN
C              ORDER  FROM  LOWEST  SUBSCRIPT  TO  HIGHEST,
C              NUMBER IDENTIFYING ROUTINE TYPE,  NUMBER  OF
C              PAGE  IN  LISTING  AT  WHICH ROUTINE BEGINS,
C              NUMBER  OF  STATEMENTS   IN   ROUTINE,   AND
C              SEQUENCE  NUMBER  OF  ROUTINE WHICH HAS NEXT
C              HIGHER   NAME   WHEN   NAMES   ARE    SORTED
C              ALPHABETICALLY.   LOWTOC  CONTAINS  SEQUENCE
C              NUMBER OF LOWEST NAME WHEN NAMES ARE  SORTED
C              ALPHABETICALLY.   FOURTH  NUMBER IS ZERO FOR
C              HIGHEST NAME.   KNTTOC  CONTAINS  NUMBER  OF
C              ROUTINE   DESCRIPTIONS   CURRENTLY   STORED.
C              MAXTOC  IS  MAXIMUM   NUMBER   OF   ROUTINES
C              DESCRIPTIONS  WHICH  CAN  BE  STORED WITHOUT
C              GIVING PARTIAL FINAL PAGE.
C     NUMTYP = ARRAY CONTAINING POINTERS  TO  EACH  ROUTINE
C              TYPE  NAME  IN LTRTYP ARRAY.  FINAL ENTRY IN
C              NUMTYP ARRAY POINTS TO NEXT CHARACTER BEYOND
C              FINAL NAME IN LTRTYP ARRAY.
C     NXTEND = USED BY REPLAC ROUTINE TO STORE LTRBIG ARRAY
C              SUBSCRIPT  CORRESPONDING  TO  START  OF NEXT
C              CONTINUATION  LINE  WHEN  SCANNING   THROUGH
C              LINE.   KEND  IS  USED SIMILARLY BY ROUTINES
C              CALLED BY REPLAC ROUTINE.
C     NXTLST = SUBSCRIPT  USED  BY  REINDX  ROUTINE   WHILE
C              THREADING  10 ALPHABETIZED LISTS INTO SINGLE
C              INDEX.  ALSO USED  BY  REINDX  ROUTINE  WHEN
C              DECIDING  WHERE  IN  SINGLE  LIST  NEW  WORD
C              SHOULD BE PLACED WHEN IT IS BEING  ADDED  TO
C              INDEX  STORAGE.  ALSO USED BY REINDX ROUTINE
C              TO  CONTAIN  SUBSCRIPT  OF  LOCATION  WITHIN
C              SORTED  LOWER  CASE  LETTERS  WHICH  MATCHES
C              LOWER CASE LETTER WHICH MUST BE CONVERTED TO
C              UPPER CASE BEFORE BEING PLACED INTO INDEX.
      END
C     RENBR(RENBR/FORTRAN RENUMBERING PROGRAM, MAR 1985)
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     SEQUENTIALLY STATEMENT  NUMBERS  AND/OR  FORMS  CROSS
C     REFERENCE LISTINGS  OF FORTRAN PROGRAMS  READ AS DATA
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     INDICATE THAT ARE ABOUT TO PROCESS FIRST USER COMMAND
      MASTER=1
C
C     INITIALIZE COMMON
    1 CALL RESET
C
C     SIMULATE A SINGLE INPUT FILE IF REUSER NOT CALLED
    2 JPASS=0
      IF(MASTER.EQ.1)JPASS=1
C
C     *****************************************************
C     *                                                   *
C     *  THE REUSER ROUTINE INTERACTS WITH THE  USER  TO  *
C     *  DEFINE  WHAT  IS TO BE DONE BY THIS PROGRAM AND  *
C     *  TO OPEN THE INPUT FILES.  THE  CALL  TO  REUSER  *
C     *  CAN  BE  REMOVED  IF  ONLY  A SINGLE INPUT FILE  *
C     *  HAVING THE DEFAULT NAME FOR THE SYSTEM (SUCH AS  *
C     *  FOR01.DAT  ON  THE PDP-10) IS TO BE READ AND IF  *
C     *  THE CONDITIONS DEFINED BY CALL TO RESET ROUTINE  *
C     *  ARE  TO  BE  USED.   THESE  CONDITIONS  ARE  TO  *
C     *  PERFORM BOTH RENUMBERING AND LISTING,  AND  FOR  *
C     *  THE  RENUMBERED  OUTPUT  TO BE IN COLUMN FORMAT  *
C     *  WITHOUT INDENTATION OF DO LOOPS AND IF  BLOCKS,  *
C     *  AND  FOR THE FIRST STATEMENT NUMBER TO BE 1 AND  *
C     *  FOR THE INCREMENT TO BE 1.                       *
C     *                                                   *
C     *****************************************************
C
C     FIND OUT WHAT USER WANTS TO DO NEXT
C
C     MASTER = 0,  THE  PREVIOUSLY  REQUESTED   RENUMBERING
C              AND/OR LISTING TASK HAS BEEN COMPLETED.  ASK
C              USER   FOR    ANOTHER    GROUP    OF    FILE
C              SPECIFICATIONS  AND OPTIONS.  SET JPASS TO 0
C              IF USER DOES NOT REQUEST THE  PROCESSING  OF
C              ANOTHER  GROUP  OF FILES.  OPEN OUTPUT FILES
C              AND FIRST INPUT FILE AND SET JPASS TO  1  IF
C              USER  REQUESTS  THE  PROCESSING  OF  ANOTHER
C              GROUP OF FILES.
C            = 1, USER HAS NOT YET BEEN  ASKED  TO  SPECIFY
C              ANY  FILES  OR  OPTIONS.   ASK  USER FOR THE
C              FIRST  GROUP  OF  FILE  SPECIFICATIONS   AND
C              OPTIONS.   OPEN OUTPUT FILES AND FIRST INPUT
C              FILE AND SET JPASS TO 1.
C            = 2 OR GREATER, AN END OF FILE OR AN EXTRA END
C              STATEMENT  HAS  BEEN READ DURING PROCESSING.
C              CHECK IF USER  HAS  SPECIFIED  THAT  ANOTHER
C              FILE  IS   TO   BE   PROCESSED   AFTER   THE
C              CURRENT FILE.  SET JPASS TO 0 IF THE CURRENT
C              FILE  IS  THE  FINAL  FILE  WHICH  IS  TO BE
C              PROCESSED IN THE  CURRENT  GROUP  OF  FILES.
C              OPEN  NEXT  INPUT FILE AND SET JPASS TO 1 IF
C              USER HAS SPECIFIED AN ADDITIONAL INPUT FILE.
C              ALL  VALUES OF MASTER WHICH ARE 2 OR GREATER
C              ARE TREATED IN THE SAME  MANNER  BY  REUSER,
C              BUT SPECIFY THE LOCATION TO WHICH CONTROL IS
C              TO BE RETURNED BY THE MAIN PROGRAM.
      CALL REUSER
C
C     CHECK IF USER ISSUES ANOTHER COMMAND
      IF(MASTER.LE.0)GO TO 3
      GO TO(4,6,6,7,7),MASTER
    3 IF(JPASS.EQ.0)GO TO 11
      MASTER=1
C
C     VERIFY OPTIONS RETURNED BY REUSER ROUTINE
    4 CALL RECHCK
C
C     FIRST PASS TO FIND NUMBER MAPPING
    5 IF(INCR.EQ.0)GO TO 7
    6 CALL RE1ST
C     MASTER = 1, SCRATCH FILE HOLDS COMPLETE ROUTINE
C            = 2, END-OF-FILE FOUND BEFORE END STATEMENT
C            = 3, EXTRA END STATEMENT FOUND
C            = 4, NO ROUTINE IS READY TO BE  PROCESSED  AND
C              NO FURTHER FILE HAS BEEN SPECIFIED
      GO TO(7,2,2,10),MASTER
C
C     SECOND PASS TO REPLACE NUMBERS AND/OR MAKE LISTING
    7 CALL RE2ND
C     MASTER = 1, END OF FILE NOT YET FOUND
C            = 2, SINGLE STATEMENT IS READY TO PROCESS
C            = 3, COMMENT IS READY FOR OUTPUT
C            = 4, EXTRA END STATEMENT WHEN LISTING ONLY
C            = 5, END-OF-FILE WHILE LISTING ONLY
      GO TO(10,8,9,2,2),MASTER
    8 CALL REPLAC
    9 CALL REOUT
      GO TO 7
C
C     PRINT TABLE OF CONTENTS AND TERMINAL SUMMARY
   10 CALL REDONE
C     MASTER = 0, ALL PROCESSING DONE,  SEE IF USER WANTS A
C              NEW SET OF ROUTINES TO BE PROCESSED.
C            = 1, PROCESS NEXT ROUTINE IN FILE
      IF(MASTER.EQ.0)GO TO 1
      GO TO 5
C
C     USER TYPES EMPTY COMMAND WHEN ALL PROCESSING DONE
   11 STOP
      END
      SUBROUTINE RESET
C     RENBR(/RENBR INITIALIZE VARIABLES IN COMMON)
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     TEST IF THIS IS FIRST TIME THIS ROUTINE IS CALLED
      IF(MASTER.EQ.0)GO TO 4
C
C     FIND BASIS OF NAME OF SCRATCH FILE
      CALL RETEMP(0,JOBNUM,ISPR)
C
C     SORT LOWER CASE  LETTERS  INTO  INCREASING  NUMERICAL
C     ORDER,   KEEPING   UPPER   CASE   LETTERS   PARALLEL.
C     RESULTING SORTED ARRAYS ARE USED IN A TERNARY  SEARCH
C     BY  THE  REINDX  ROUTINE  TO CONVERT LOWER CASE ITEMS
C     INTO UPPER  CASE BEFORE THESE  ARE PLACED INTO INDEX.
C     THESE ARRAYS ARE ALSO USED IN A LINEAR SEARCH BY  THE
C     RETITL ROUTINE TO CONVERT ROUTINE NAMES TO UPPER CASE
      DO 1 I=1,26
      LTRSRT(I)=LTRABC(I)
    1 LWRSRT(I)=LWRABC(I)
      DO 3 I=1,25
      J=I
      LTRNOW=LWRSRT(I)
      DO 2 K=I,26
      IF(LTRNOW.LE.LWRSRT(K))GO TO 2
      J=K
      LTRNOW=LWRSRT(K)
    2 CONTINUE
      LWRSRT(J)=LWRSRT(I)
      LWRSRT(I)=LTRNOW
      LTRNOW=LTRSRT(J)
      LTRSRT(J)=LTRSRT(I)
    3 LTRSRT(I)=LTRNOW
C
C     DEFINE MAXIMUM NUMBER OF LINES IN SINGLE STATEMENT
    4 MAXLIN=20
C
C     DEFINE LENGTH OF STATEMENT NUMBER STORAGE ARRAYS.
      KUTNUM=60
      IHIHDO=1000
      LOWDO=IHIHDO
C
C     DEFINE LENGTH OF SYMBOL DICTIONARY STORAGE
      KUTPNT=400
      KUTSPL=200
      MAXPNT=5000
      MAXSPL=2000
C
C     DEFINE LENGTH OF TABLE OF CONTENTS STORAGE.
C     NOTE THAT THIS WILL BE REDUCED AFTER PAGE
C     SIZE IS SET IF PAGE SIZE COULD PRODUCE PARTIAL
C     TRAILING PAGE IN TABLE OF CONTENTS.
      INITOC=28
C
C     DEFINE STARTING LOCATIONS OF LTRBIG ARRAY SECTIONS.
      LEFT=1
      LOWER=5
      MID=891
      LOW1=LOWER-1
      MTAB=4
      KTAB=2211
      LOW2=MTAB+1
C
C     DEFINE SECTIONS OF LISTING TITLE ARRAY
      ININAM=99
C
C     DEFINE UNIT NUMBERS FOR INPUT AND OUTPUT
      ITTY=5
      JTTY=5
      IIN=1
      ILPT=20
      IOUT=21
      ISPR=22
C
C     DEFINE DEFAULT CONDITIONS IF REUSER IS NOT CALLED
      IBASE=0
      ISPACE=0
      INCR=1
      IPAGE=1
      ITAB=0
      IFILL=0
      ISPLIT=0
      IFORM=66
      JFORM=60
      JTAB=8
      LTAB=0
      ITBL=1
      INDENT=0
      JMPEND=0
      JMPBGN=0
      LPTTTY=0
      KMDMIN=0
      KMDMAX=0
      ITRACE=0
      DO 5 I=1,54
    5 LTRTOP(I)=LTRSPC
C
C     INITIALIZE ERROR COUNT
      IERR=0
C
C     INITIALIZE RECORD OF ARRAY USAGE.
      LRGNUM=0
      LRGPNT=0
      LRGSPL=0
      LCLNUM=0
      LCLPNT=0
      LCLSPL=0
C
C     INITIALIZE STATISTICS
      MSTN=0
      NSTN=0
      KNTONE=0
      KNTTWO=0
      NONFOR=0
      IBREAK=0
      JBREAK=0
      KOMENT=0
      INCSAV=0
      INDSAV=0
      KOMKNT=0
C
C     MARK THAT END OF FILE NOT YET FOUND IN 1ST PASS
      JEOF=1
C
C     CROSS REFERENCE TABLES  IN  LISTINGS  CONTAIN NUMBERS
C     OF LINES BEARING STATEMENT NUMBERS,  AS WELL AS THOSE
C     REFERENCING STATEMENT NUMBERS
      KPASS=2
      RETURN
      END
      SUBROUTINE RECHCK
C     RENBR(/RENBR CHECK OPTIONS RETURNED BY REUSER)
C
C     DONALD BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     CHECK IF IPAGE, INCR AND ITAB ARE LEGAL
      IF(IPAGE.GT.0)GO TO 1
      IPAGE=0
      IF(INCR.EQ.0)INCR=1
    1 IF(ITAB.LE.0)GO TO 2
      IF(INCR.EQ.0)ITAB=0
      IF(LTRSPC.EQ.LTRTAB)ITAB=0
    2 IF(ISPLIT.LT.0)ISPLIT=1
      IF(ISPLIT.GT.69)ISPLIT=ISPLIT-69
      IF(ISPLIT.GT.61)ISPLIT=61
      IF(IFORM.LE.10)IFORM=66
      IF(JFORM.LE.10)JFORM=60
      IF(JTAB.LE.0)JTAB=8
      JSPLIT=ISPLIT
      IF(JSPLIT.EQ.0)JSPLIT=61
      IF(ITBL.LE.0)ITBL=1
C
C     CALL REINDX TO INITIALIZE ITS POINTERS
      KONTRL=-4
      IF(IPAGE.GT.0)CALL REINDX
C
C     CALL RETITL TO INITIALIZE ITS POINTER
      KONTRL=6
      CALL RETITL
C
C     STORE FIRST PAGE NUMBER
      KPAGE=IPAGE
      RETURN
      END
      SUBROUTINE RE1ST
C     RENBR(/RENBR 1ST PASS TO FIND STATEMENT NUMBERS)
C
C     DONALD BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      DIMENSION LTR072(72)
      EQUIVALENCE (LTR120(1),LTR072(1))
C
      GO TO(1,4,31),MASTER
    1 KPASS=-1
      IPASS=0
      ITITLE=0
      IEOF=2
      MODOLD=0
      MODNEW=0
      MODBAS=IBASE
      MODINC=INCR
      MSTN=0
      MODMIN=0
      MODMAX=0
      KOMNUM=0
      LNGCOM=72
      LNGNXT=LNGCOM
      INDSAV=INDENT
      DO 2 I=55,117
    2 LTRTOP(I)=LTRSPC
      IF(KOMENT.EQ.0)GO TO 11
      KOMENT=0
      GO TO 13
C     CHECK IF ANYTHING READ BEFORE END-OF-FILE
    3 MASTER=2
      GO TO 81
    4 MASTER=1
      IF(JPASS.NE.0)GO TO 11
      IF(IEOF.EQ.2)GO TO 80
      IEOF=IEOF-1
      JEOF=0
      GO TO 33
C
C     TEST IF COMMENT LINE IS LONGER THAN 72 CHARACTERS
    5 LNGCOM=LNGCOM-1
    6 IF(LNGCOM.LE.72)GO TO 7
      IF(LTR120(LNGCOM).EQ.LTRSPC)GO TO 5
      MAXPRT=LNGCOM
    7 LNGCOM=LNGNXT
C
C     WRITE LINE ON SCRATCH STORAGE
    8 IF(IEOF.EQ.2)CALL RETEMP(1,JOBNUM,ISPR)
C     IF(IEOF.EQ.2)OPEN(UNIT=ISPR,FILE='RENBR .TMP',
C    1ACCESS='SEQOUT')
      IEOF=IEOF+1
      WRITE(ISPR,9)MAXPRT
      WRITE(ISPR,10)(LTR120(I),I=1,MAXPRT)
    9 FORMAT(1I3)
   10 FORMAT(120A1)
C
C     READ IN NEXT LINE
   11 IF(LNGCOM.LE.72)GO TO 12
      READ(IIN,10,END=3)LTR120
      GO TO 13
   12 READ(IIN,10,END=3)LTR072
C
C     REMOVE TERMINAL BLANKS TO REDUCE SCRATCH STORAGE
   13 MAXPRT=73
   14 MAXPRT=MAXPRT-1
      IF(MAXPRT.EQ.0)GO TO 11
      IF(LTR120(MAXPRT).EQ.LTRSPC)GO TO 14
C
C     TEST IF CRENBR LINE CONTAINING RENUMBERING PARAMETERS
      KONTRL=1
      IF(IEOF.EQ.2)KONTRL=3
      CALL RECMND
      IF(KONTRL.GE.0)GO TO 15
      KOMENT=-1
      INCSAV=INCR
      INCR=0
      GO TO 81
   15 LTRNOW=LTR120(1)
      DO 16 I=1,MAXCOM
      IF(LTRNOW.EQ.LTRCOM(I))GO TO 6
   16 CONTINUE
C
C     TEST FOR CONTINUATION OR STATEMENT NUMBERS
      NUM=0
      I=0
      ISTART=0
   17 ISTART=ISTART+1
      IF(ISTART.GT.MAXPRT)GO TO 21
      LTRNOW=LTR120(ISTART)
      IF(LTRNOW.EQ.LTRSPC)GO TO 17
      IF(LTRNOW.NE.LTRTAB)GO TO 18
      I=-1
      GO TO 17
   18 J=0
   19 IF(J.EQ.10)GO TO 22
      J=J+1
      IF(LTRNOW.NE.LTRDGT(J))GO TO 19
      IF(ISTART.GT.5)GO TO 20
      IF(I.LT.0)GO TO 20
      I=ISTART
      L=J
      NUM=(10*NUM)+J-1
      GO TO 17
   20 IF(J.EQ.1)GO TO 23
      GO TO 8
   21 IF(NUM.GT.0)GO TO 25
      GO TO 8
   22 IF(ISTART.EQ.1)GO TO 17
      IF(I.LT.0)GO TO 24
      IF(ISTART.LE.6)GO TO 8
      IF(I.NE.(ISTART-1))GO TO 24
      IF(L.NE.1)GO TO 8
      LTR120(I)=LTRSPC
      NUM=NUM/10
      GO TO 24
   23 ISTART=ISTART+1
   24 IF(NUM.LE.0)GO TO 26
C
C     PLACE STATEMENT NUMBER IN STORAGE ARRAY
   25 MSTN=MSTN+1
      IF(MSTN.LE.LOWDO)NOLD(MSTN)=NUM
C
C     TEST FOR END LINE (MUST BE ON SINGLE LINE)
   26 I=ISTART
      J=1
      IF(MAXPRT.GT.(ISTART+65))MAXPRT=ISTART+65
   27 IF(I.GT.MAXPRT)GO TO 30
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 29
      IF(LTRNOW.EQ.LTRTAB)GO TO 29
      IF(LTRNOW.EQ.LTREXC)GO TO 30
      IF(J.GT.3)GO TO 8
      IF(LTRNOW.EQ.LTREND(J))GO TO 28
      IF(LTRNOW.NE.LWREND(J))GO TO 8
   28 J=J+1
   29 I=I+1
      GO TO 27
   30 IF(J.LE.3)GO TO 8
      IF(IEOF.NE.2)GO TO 32
      MASTER=3
      GO TO 81
   31 MASTER=1
      IF(JPASS.EQ.0)GO TO 80
      GO TO 11
   32 WRITE(ISPR,9)MAXPRT
      WRITE(ISPR,10)(LTR120(I),I=1,MAXPRT)
   33 ENDFILE ISPR
      CALL RETEMP(2,JOBNUM,ISPR)
C     CLOSE(UNIT=ISPR)
      LCLNUM=MSTN
      IF(MSTN.GT.LOWDO)GO TO 78
      IF(IPAGE.EQ.0)GO TO 34
      IF(MSTN.GT.(LOWDO-25))GO TO 78
   34 IF(MSTN.EQ.0)GO TO 81
      IF(KMDMIN.NE.0)GO TO 35
      IF(KMDMAX.LE.0)GO TO 36
   35 MODINC=INCR
      MODBAS=IBASE
      MODMIN=KMDMIN
      MODMAX=KMDMAX
   36 IF(MODINC.LT.0)GO TO 37
      IF(MODINC.EQ.0)MODINC=1
      NEED=MSTN
      NCD=1
      NUM=1
      GO TO 38
   37 MODINC=-MODINC
      NEED=1
      NCD=MSTN
      NUM=-1
   38 IF(MODBAS.LE.0)MODBAS=MODINC
      I=NCD
      IF(KMDMIN.LT.0)GO TO 79
      IF(MODMAX.GT.0)GO TO 66
      IF(MODMIN.GT.0)GO TO 65
      IF(MODOLD.LE.1)MODOLD=MODNEW
      IF(MODOLD.LE.1)GO TO 73
C
C     LOOK FOR PLATEAUS IN OLD STATEMENT NUMBERS
      IF(MODNEW.LE.1)MODNEW=MODOLD
      K=0
      L=MODOLD
      N=MODBAS
   39 IF(N.LT.MODNEW)GO TO 40
      N=N-MODNEW
      GO TO 39
   40 IF(N.LT.MODINC)GO TO 41
      N=N-MODINC
      GO TO 40
   41 IF(MODMIN.NE.0)GO TO 53
      GO TO 45
   42 I=I+NUM
   43 J=J+NUM
      IF(NOLD(J).LT.K)GO TO 44
      IF(NOLD(J).LT.L)GO TO 51
   44 IF(J.NE.NEED)GO TO 43
   45 J=NOLD(I)
      IF(J.LT.K)GO TO 48
   46 IF(J.LT.L)GO TO 47
      L=L+MODOLD
      GO TO 46
   47 K=L-MODOLD
      GO TO 49
   48 K=K-MODOLD
      IF(J.LT.K)GO TO 48
      L=K+MODOLD
   49 J=I
      IF(I.EQ.NCD)GO TO 51
   50 N=N+MODNEW
      IF(N.LT.MODBAS)GO TO 50
      MODBAS=N
   51 NNEW(I)=MODBAS
      MODBAS=MODBAS+MODINC
      IF(I.EQ.J)GO TO 52
      I=I+NUM
      GO TO 51
   52 IF(I.NE.NEED)GO TO 42
      GO TO 74
C
C     LOOK FOR DISCONTINUOUS REGIONS IN NUMBERS
   53 NCD=0
   54 J=I
      M=0
   55 IF(NOLD(J).GE.L)GO TO 56
      IF(NOLD(J).LT.K)GO TO 58
      NNEW(J)=MODBAS
      MODBAS=MODBAS+MODINC
      GO TO 58
   56 IF(M.EQ.0)GO TO 57
      IF(M.LT.NOLD(J))GO TO 58
   57 M=NOLD(J)
   58 IF(J.EQ.NEED)GO TO 59
      J=J+NUM
      GO TO 55
   59 IF(M.EQ.0)GO TO 74
      K=L
   60 L=L+MODOLD
      IF(NCD.LE.0)GO TO 61
      NCD=NCD-1
      GO TO 62
   61 N=N+MODNEW
   62 IF(L.LE.M)GO TO 60
   63 IF(N.GE.MODBAS)GO TO 64
      N=N+MODNEW
      NCD=NCD+1
      GO TO 63
   64 MODBAS=N
      GO TO 54
C
C     RETAIN OLD STATEMENT NUMBERS OUTSIDE RANGE
   65 MODMAX=99999
   66 NNEW(NCD)=NOLD(NCD)
      IF(NOLD(NCD).LT.MODMIN)GO TO 72
      IF(NOLD(NCD).GT.MODMAX)GO TO 72
   67 J=I
   68 IF(J.EQ.NCD)GO TO 69
      IF(NNEW(J).EQ.MODBAS)GO TO 70
      J=J+NUM
      GO TO 68
   69 IF(J.EQ.NEED)GO TO 71
      J=J+NUM
      IF(NOLD(J).NE.MODBAS)GO TO 69
      IF(MODBAS.LT.MODMIN)GO TO 70
      IF(MODBAS.LE.MODMAX)GO TO 69
   70 MODBAS=MODBAS+MODINC
      GO TO 67
   71 NNEW(NCD)=MODBAS
      MODBAS=MODBAS+MODINC
   72 IF(NCD.EQ.NEED)GO TO 74
      NCD=NCD+NUM
      GO TO 66
C
C     NORMAL RENUMBERING
   73 NNEW(NCD)=MODBAS
      MODBAS=MODBAS+MODINC
      IF(NCD.EQ.NEED)GO TO 74
      NCD=NCD+NUM
      GO TO 73
C
C     SORT THE STATEMENT NUMBERS FOR FASTER LOOKUP
   74 CALL DASORT(NOLD,1,MSTN,NNEW)
C
C     CHECK FOR DUPLICATE STATEMENT NUMBERS
      J=0
      K=0
      L=0
      DO 76 I=1,MSTN
      IF(J.NE.NOLD(I))GO TO 75
      IF(K.NE.0)GO TO 76
      IERR=IERR+1
      WRITE(ITTY,83)J
      K=1
      L=1
      GO TO 76
   75 J=NOLD(I)
      K=0
   76 CONTINUE
      IF(L.EQ.0)GO TO 77
      WRITE(ITTY,85)
      GO TO 79
C
C     TEST IF NEW NUMBERS ARE LARGER THAN 99999
   77 IF(MODBAS.LE.(99999+MODINC))GO TO 81
      WRITE(ITTY,84)
      GO TO 79
C
C     *******************
C     *  END OF PASS 1  *
C     *******************
C
C     ERROR MESSAGE IF TOO MANY NUMBERED STATEMENTS
   78 IERR=IERR+1
      WRITE(ITTY,82)
C
C     PRESERVE OLD NUMBERS
   79 MSTN=0
      KPASS=2
      GO TO 81
C
C     FINAL ROUTINE IN FINAL INPUT FILE ALREADY PROCESSED
   80 MASTER=4
C
C     RETURN TO CALLING PROGRAM
   81 RETURN
C
C     FORMAT STATEMENTS
   82 FORMAT(31H Too many numbers, old retained)
   83 FORMAT(17H Duplicate number,1I6)
   84 FORMAT(36H New numbers too large, old retained)
   85 FORMAT(21H Old numbers retained)
      END
      SUBROUTINE RE2ND
C     RENBR(/RENBR 2ND PASS TO PACK SINGLE STATEMENT)
C
C     THE FORTRAN RENUMBERING PROGRAM RENBR, JAN 1979
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     THIS ROUTINE IS THE SECOND PASS IF RENUMBERING
C     IS BEING PERFORMED.  IT PACKS SINGLE STATEMENT INTO
C     WORKING ARRAY.  IF ONLY A LISTING IS BEING GENERATED,
C     THEN THIS ROUTINE WOULD BE THE FIRST AND ONLY PASS.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      DIMENSION LTR072(72)
      EQUIVALENCE (LTR072(1),LTR120(1))
C
      GO TO(3,1,1,2,21),MASTER
    1 MASTER=1
      IF(NCD.EQ.0)GO TO 5
      IF(IEOF.GT.0)GO TO 54
      GO TO 78
    2 MASTER=1
      IF(JPASS.NE.0)GO TO 3
      KOUNT=0
      GO TO 78
    3 MOVE=0
      LSTKNT=0
      KNDGRP=0
      IPASS=1
      MOST=MSTN
      KOUNT=0
      NCD=0
      KUTPAG=0
      MAXEND=MID
      DO 4 I=LEFT,LOW1
    4 LTRBIG(I)=LTRSPC
      IF(INCR.EQ.0)GO TO 11
      KONTRL=4
      CALL RETITL
      CALL RETEMP(3,JOBNUM,ISPR)
C     OPEN(UNIT=ISPR,FILE='RENBR .TMP',ACCESS='SEQIN')
      GO TO 31
    5 NEED=65+ISTART-MAXPRT
      IF(INCR.NE.0)GO TO 31
      IF(NCD.NE.1)GO TO 13
C
C     TEST FOR END LINE FROM PRIMARY INPUT
      I=ISTART
      J=1
    6 IF(I.GT.MAXPRT)GO TO 9
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 8
      IF(LTRNOW.EQ.LTRTAB)GO TO 8
      IF(LTRNOW.EQ.LTREXC)GO TO 9
      IF(J.GT.3)GO TO 13
      IF(LTRNOW.EQ.LTREND(J))GO TO 7
      IF(LTRNOW.NE.LWREND(J))GO TO 13
    7 J=J+1
    8 I=I+1
      GO TO 6
    9 IF(J.LE.3)GO TO 13
      IF(IEOF.EQ.2)GO TO 10
      IEOF=0
      GO TO 76
   10 MASTER=4
      GO TO 78
   11 IEOF=1
      ITITLE=0
      KOMNUM=0
      LNGCOM=72
      LNGNXT=LNGCOM
      INDSAV=INDENT
      DO 12 I=55,117
   12 LTRTOP(I)=LTRSPC
C
C     READ LINE FROM PRIMARY INPUT UNIT
   13 IEOF=IEOF+1
   14 IF(KOMENT.EQ.0)GO TO 16
      IF(KOMENT.GT.0)GO TO 15
      KOMENT=0
      GO TO 18
   15 READ(IIN,33,END=20)LTR120
      MAXPRT=120
      GO TO 19
   16 IF(LNGCOM.LE.72)GO TO 17
      READ(IIN,33,END=20)LTR120
      GO TO 18
   17 READ(IIN,33,END=20)LTR072
   18 MAXPRT=72
   19 IF(LTR120(MAXPRT).NE.LTRSPC)GO TO 22
      MAXPRT=MAXPRT-1
      IF(MAXPRT.GT.0)GO TO 19
      IF(KOMENT.EQ.0)GO TO 16
      MAXPRT=1
      GO TO 77
   20 MASTER=5
      GO TO 78
   21 MASTER=1
      IF(JPASS.NE.0)GO TO 14
      IEOF=-1
      JEOF=0
      GO TO 51
   22 IF(IEOF.NE.2)GO TO 23
      KONTRL=4
      CALL RETITL
      KONTRL=3
      GO TO 24
   23 KONTRL=1
   24 IF(KOMENT.NE.0)KONTRL=4
      CALL RECMND
      IF(KONTRL.GT.0)GO TO 28
      IF(KOMENT.EQ.0)GO TO 25
      IF(KONTRL.EQ.-2)GO TO 26
      KOMENT=-1
      IEOF=0
      GO TO 78
   25 IF(KONTRL.EQ.0)GO TO 29
      KOMENT=1
      GO TO 27
   26 KONTRL=7
      CALL RETITL
      ITITLE=0
      KONTRL=5
      CALL RECMND
   27 LSTKNT=KOUNT+1
      KONTRL=3
      IBR=1
      CALL RETITL
   28 IF(KOMENT.NE.0)GO TO 77
   29 LTRNOW=LTR120(1)
      DO 30 I=1,MAXCOM
      IF(LTRNOW.EQ.LTRCOM(I))GO TO 47
   30 CONTINUE
      GO TO 35
C
C     READ LINE FROM SCRATCH UNIT
   31 IEOF=IEOF-1
      IF(IEOF.EQ.0)GO TO 50
      READ(ISPR,32)MAXPRT
      READ(ISPR,33)(LTR120(I),I=1,MAXPRT)
   32 FORMAT(1I3)
   33 FORMAT(120A1)
      LTRNOW=LTR120(1)
      DO 34 I=1,MAXCOM
      IF(LTRNOW.EQ.LTRCOM(I))GO TO 49
   34 CONTINUE
C
C     DETERMINE TYPE OF STATEMENT
C
C     COMMENT
C     (A) C IN COLUMN 1
C     (B) NON-DIGIT IN COLUMNS 2 THRU 5
C     (C) NON-DIGIT IN COLUMN 1 AND NOTHING BEYOND
C
C     CONTINUATION
C     (A) TAB FOLLOWED BY NON-ZERO DIGIT
C     (B) NO TABS FOLLOWED BY NON-ZERO NON-BLANK IN
C         COLUMN 6
C     (C) NO TABS FOLLOWED BY NON-ZERO DIGIT IN FIRST
C         NON-BLANK COLUMN AT OR BEYOND COLUMN 6
C
C     START OF NEW STATEMENT
C     (A) TAB FOLLOWED BY NON-DIGIT OR ZERO
C     (B) NUMBER FOLLOWED BY TAB FOLLOWED BY NON-DIGIT
C         OR ZERO
C     (C) NO TABS FOLLOWED BY ZERO OR BLANK IN COLUMN 6
C     (D) NON-C IN COLUMN 1 FOLLOWED BY ANY OF ABOVE
C
   35 NEWNUM=0
      I=0
      ISTART=0
      NEWSTN=LOWER
      M=0
   36 ISTART=ISTART+1
      IF(ISTART.GT.MAXPRT)GO TO 40
      LTRNOW=LTR120(ISTART)
      IF(LTRNOW.EQ.LTRSPC)GO TO 36
      IF(LTRNOW.EQ.LTRTAB)GO TO 38
      J=0
   37 IF(J.EQ.10)GO TO 42
      J=J+1
      IF(LTRNOW.NE.LTRDGT(J))GO TO 37
      IF(ISTART.GT.5)GO TO 39
      IF(I.LT.0)GO TO 39
      I=ISTART
      L=J
      NEWNUM=(10*NEWNUM)+J-1
      GO TO 36
   38 I=-1
      GO TO 36
   39 IF(J.NE.1)GO TO 44
      IF(M.NE.0)GO TO 49
      M=ISTART
      GO TO 36
   40 IF(NEWNUM.GT.0)GO TO 52
      IF(LTR120(1).EQ.LTRSPC)GO TO 41
      IF(LTR120(1).NE.LTRTAB)GO TO 49
   41 IF(INCR.NE.0)GO TO 31
      GO TO 14
   42 IF(ISTART.GT.1)GO TO 43
      NEWSTN=LOWER+1
      GO TO 36
   43 IF(I.LT.0)GO TO 52
      IF(ISTART.LT.6)GO TO 49
      IF(ISTART.EQ.6)GO TO 44
      IF(I.NE.(ISTART-1))GO TO 52
      IF(L.NE.1)GO TO 45
      NEWNUM=NEWNUM/10
      GO TO 52
C
C     IF NCD IS 0 NOTHING IS WAITING IN UPPER SECTION.
C     IF NCD IS NON-ZERO, PROCESS STATEMENT IN UPPER
C     SECTION BEFORE COPYING LOWER SECTION INTO UPPER.
C
C     CONTINUATION LINE READ
   44 ISTART=ISTART+1
   45 IF(NCD.LE.0)GO TO 74
      GO TO 68
C     COMMENT LINE READ
   46 LNGCOM=LNGCOM-1
   47 IF(LNGCOM.LE.72)GO TO 48
      IF(LTR120(LNGCOM).EQ.LTRSPC)GO TO 46
      MAXPRT=LNGCOM
   48 LNGCOM=LNGNXT
   49 IF(NCD.LE.0)GO TO 77
      NEWNUM=-1
      GO TO 76
C     END OF PROGRAM READ
   50 CALL RETEMP(4,JOBNUM,ISPR)
C     CLOSE(UNIT=ISPR,DISPOSE='DELETE')
   51 IF(NCD.GT.0)GO TO 76
      GO TO 78
C     START OF NEW STATEMENT (NON-CONTINUATION) READ
   52 LTR120(ISTART-1)=LTRSPC
      IF(M.EQ.0)GO TO 53
      LTR120(M)=LTRSPC
      LTR120(ISTART-1)=LTRDGT(1)
   53 IF(NCD.GT.0)GO TO 76
C
C     TRANSFER HERE TO BEGIN PROCESSING OF STATEMENT.
C     IF NCD IS NONZERO, THE ABOVE TESTS WILL HAVE
C     FIRST CAUSED PROCESSING OF THE PREVIOUS STATEMENT.
C
C     INITIALIZE THE INPUT POINTERS.
   54 NCD=0
      ILEVEL=0
      JLEVEL=0
      KLEVEL=0
      IEND=MID+66
      LIKE=0
      MAXEND=MID
      JIN=MID
      JOUT=LOWER+6
      KPYEND=JOUT+66
      IF(NEWNUM.LT.0)GO TO 77
      NUM=NEWNUM
      LSTSTN=NEWSTN
      JSTN=NEWSTN
      IF(JSTN.NE.LOWER)LTRBIG(LOWER)=LTR120(1)
      LTRBIG(LOWER+5)=LTR120(ISTART-1)
C
C     INSERT LINE COUNT
      I=LEFT
      KOUNT=KOUNT+1
      L=KOUNT
   55 J=L
      L=L/10
      J=J+1-(10*L)
      LTRBIG(LEFT)=LTRDGT(J)
      IF(L.LE.0)GO TO 57
      I=I+1
      J=I
   56 J=J-1
      LTRBIG(J+1)=LTRBIG(J)
      IF(J.LE.LEFT)GO TO 55
      GO TO 56
   57 ISTN=LOWER+4
      LSTN=LOWER+5
      IF(NUM.LE.0)GO TO 66
C
C     CHECK IF STATEMENT ENDS A DO LOOP
      I=LOWDO
   58 I=I+1
      IF(I.GT.IHIHDO)GO TO 60
      IF(NUM.NE.NOLD(I))GO TO 58
      IF(MOVE.GT.0)MOVE=MOVE-NNEW(I)
      LOWDO=LOWDO+1
   59 IF(I.EQ.LOWDO)GO TO 60
      NOLD(I)=NOLD(I-1)
      NNEW(I)=NNEW(I-1)
      I=I-1
      GO TO 59
C
C     INSERT STATEMENT NUMBER
   60 IPASS=KPASS
      CALL RENUMB
      IF(INCR.EQ.0)GO TO 62
   61 J=NUM
      NUM=NUM/10
      J=J+1-(10*NUM)
      LTRBIG(ISTN)=LTRDGT(J)
      IF(ISTN.EQ.LOWER)LSTSTN=LOWER
      LSTN=ISTN
      ISTN=ISTN-1
      IF(NUM.LE.0)GO TO 67
      GO TO 61
   62 J=5
      I=ISTART-1
   63 IF(J.GE.I)GO TO 65
      IF(LTR120(J).EQ.LTRTAB)GO TO 65
      LTRBIG(ISTN)=LTR120(J)
   64 ISTN=ISTN-1
      J=J-1
      IF(ISTN.GE.JSTN)GO TO 63
      GO TO 68
   65 LTRBIG(ISTN)=LTRSPC
      GO TO 64
   66 LTRBIG(ISTN)=LTRSPC
      ISTN=ISTN-1
   67 IF(ISTN.GE.JSTN)GO TO 66
C
C     COPY LINE FROM LOWER SECTION TO UPPER SECTION.
C     FIRST COPY BLANKS INTO ALREADY COPIED TEXT
C     TO FILL OUT THE PROPER CHARACTER COUNT
   68 IF(NCD.EQ.0)GO TO 70
      IF(NCD.EQ.MAXLIN)GO TO 72
      IF(NEED.EQ.0)GO TO 70
      DO 69 I=1,NEED
      LTRBIG(MAXEND)=LTRSPC
   69 MAXEND=MAXEND+1
   70 NCD=NCD+1
      IF(MAXPRT.LT.ISTART)GO TO 5
      IF(MAXPRT.GT.(ISTART+65))MAXPRT=ISTART+65
      DO 71 I=ISTART,MAXPRT
      LTRBIG(MAXEND)=LTR120(I)
   71 MAXEND=MAXEND+1
      GO TO 5
   72 IERR=IERR+1
      WRITE(ITTY,73)KOUNT
   73 FORMAT(1X,4HLine,1I5,12H is too long)
      GO TO 5
C
C     ERROR MESSAGE IF NO FIRST LINE OF STATEMENT
   74 WRITE(ITTY,75)KOUNT
   75 FORMAT(30H Continuation not tied to line,1I5)
      IERR=IERR+1
      GO TO 77
C
C     SCAN THE STATEMENT FOR NUMBERS AND REPLACE
   76 MASTER=2
      GO TO 78
C
C     OUTPUT THE STATEMENT
   77 MASTER=3
   78 RETURN
      END
      SUBROUTINE REPLAC
C     RENBR(/RENBR ROUTINE TO REPLACE STATEMENT NUMBERS)
C
C     THE FORTRAN RENUMBERING PROGRAM RENBR, JAN 1979
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     THIS ROUTINE IDENTIFIES ALL OCCURRENCES OF STATEMENT
C     NUMBERS AND REPLACES THEM.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     INSERT INDENTATION IN RANGE OF DO LOOP
      I=MOVE*INDENT
      IF(I.GE.66)GO TO 2
    1 IF(I.LE.0)GO TO 2
      I=I-1
      IF(JOUT.GE.JIN)GO TO 2
      LIKE=LIKE-1
      LTRBIG(JOUT)=LTRSPC
      JOUT=JOUT+1
      GO TO 1
C
C     REMOVE TERMINAL SPACES, SIMULATE INITIAL COMMENT
C     BELOW START OF LINE
    2 IF(MAXEND.LE.MID)GO TO 3
      IF(LTRBIG(MAXEND-1).NE.LTRSPC)GO TO 3
      MAXEND=MAXEND-1
      GO TO 2
    3 INRCPY=2
      INRFND=1
      INRSTR(1)=JIN-1
      INIPRT=JOUT
C
C     INITIALIZE OUTPUT POINTERS
C
C     JSTN AND JIN ARE KEPT EQUAL EXCEPT AFTER A
C     STATEMENT NUMBER IS FOUND, THEN JSTN IS SET TO 1
C     POSN BEYOND THE LAST DIGIT (OR 5TH),
C     THEN JSTN IS SET AT THE SEEK CHARACTER OR
C     AFTER FIRST FINDS ITS SEEK CHARACTER.
    4 JSTN=JIN
      JBGN=JOUT
      IENTER=1
      IBR=1
      JEND=MAXEND
    5 CALL RENEXT
      IF(JSTN.GE.JEND)GO TO 6
      JSTN=JSTN+1
      GO TO 5
    6 JSTN=JIN
      GO TO 11
C
C     THE FOLLOWING IS AN INTERPRETIVE ROUTINE
C     WHICH IS DRIVEN BY THE ENTRIES IN NUMPRS,
C     THE SYNTAX DESCRIPTION.
    7 JSTN=JIN
    8 IBR=NUMPRS(IBR+3)
      GO TO 11
    9 JSTN=JIN
   10 IBR=NUMPRS(IBR+4)
   11 I=NUMPRS(IBR)
      GO TO (22,43,50,78,94,98,107,125,126,53,
     1116,117,58,7,21,19,28,28,28,28,
     228,28,28,28,12,13,17,18,22,94,
     3118),I
C
C     TEST IF THIS IS FIRST LINE IN PROGRAM
   12 IF(KOUNT.NE.1)GO TO 10
      GO TO 8
C
C     INSERT STATEMENT NUMBER INTO LIST OF DO LOOPS
   13 I=IHIHDO+1
   14 I=I-1
      IF(I.LE.LOWDO)GO TO 15
      IF(NOLD(I).NE.NUM)GO TO 14
      GO TO 16
   15 LCLNUM=LCLNUM+1
      IF(MOST.GE.LOWDO)GO TO 8
      LOWDO=LOWDO-1
      NOLD(I)=NUM
      NNEW(I)=0
   16 NNEW(I)=NNEW(I)+1
      MOVE=MOVE+1
      GO TO 8
C
C     INCREASE INDENTATION OF FOLLOWING STATEMENTS
   17 MOVE=MOVE+1
      GO TO 8
C
C     DECREASE INDENTATION OF FOLLOWING STATEMENTS
C     AND OF CURRENT STATEMENT IF KEYWORD IS AT LEFT.
C     KEYWORK MUST HAVE BEEN MATCHED WITHOUT BEING COPIED.
   18 IF(MOVE.LE.0)GO TO 8
      MOVE=MOVE-1
      IF(JOUT.GT.INIPRT)GO TO 8
      IF(JOUT.LT.(LOWER+6+INDENT))GO TO 8
      JOUT=JOUT-INDENT
      LIKE=LIKE+INDENT
      JBGN=JOUT
      INIPRT=JOUT
      GO TO 8
C
C     INSERT PROGRAM NAME AND TYPE INTO TABLE OF CONTENTS
   19 IF(LSTKNT.EQ.0)GO TO 20
      LSTKNT=LSTKNT+1
      KONTRL=7
      CALL RETITL
   20 KONTRL=1
      CALL RETITL
      LSTKNT=KOUNT
      GO TO 8
C
C     INDICATE ENTIRE COPIED PORTION OF STATEMENT HAS
C     BEEN PUT INTO DICTIONARY WHETHER IT HAS OR NOT.
   21 JBGN=JOUT
      GO TO 8
C
C     SCAN FOR A PARTICULAR CHARACTER SEQUENCE STARTING
C     AT JSTN.  COPY THE SEQUENCE IF IT IS FOUND.
   22 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      K=IEND
   23 IF(JSTN.GE.JEND)GO TO 9
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 25
      IF(LTRNOW.EQ.LTRTAB)GO TO 25
      IF(LTRNOW.EQ.LTREXC)GO TO 26
      IF(LTRNOW.EQ.LTRPRS(I))GO TO 24
      IF(LTRNOW.NE.LWRPRS(I))GO TO 9
   24 I=I+1
   25 JSTN=JSTN+1
      IF(I.LE.J)GO TO 23
      IF(NUMPRS(IBR).EQ.1)GO TO 107
      GO TO 8
   26 IF(JSTN.LT.K)GO TO 27
      K=K+66
      GO TO 26
   27 JSTN=K
      GO TO 23
C
C     TEST IF WORD APPEARS ANYWHERE AT ZERO PARENTHESIS
C     COUNT OTHER THAN IN AN ALPHAMERIC STRING OR OPERATOR.
C     JSTN IS LEFT AT NEXT CHARACTER FOLLOWING SUCCESSFUL
C     MATCH.  NOTHING IS COPIED.
C
C     NUMPRS(IBR)   STOP AT       PREFIX ALLOWED
C     17     END OF LINE                    YES
C     18     1ST NON-PARENTHESIS OPERATOR   YES
C     19     LEFT PARENTHESIS               YES
C     20     1ST OPERATOR                   YES
C     21     END OF LINE                    NO
C     22     1ST NON-PARENTHESIS OPERATOR   NO
C     23     LEFT PARENTHESIS               NO
C     24     1ST OPERATOR                   NO
C
   28 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      K=0
      IPOINT=NUMPRS(IBR)
      JPOINT=IPOINT
      IF(JPOINT.GT.20)JPOINT=JPOINT-4
   29 L=JSTN
      CALL RENEXT
      IF(K.NE.0)GO TO 41
      IF(IALPHA.NE.0)GO TO 37
      GO TO 31
   30 LTRNOW=LTRBIG(M)
      IF(LTRNOW.EQ.LTRSPC)GO TO 35
      IF(LTRNOW.EQ.LTRTAB)GO TO 35
      IF(LTRNOW.EQ.LTREXC)GO TO 32
      IF(LTRNOW.EQ.LTRPRS(N))GO TO 34
      IF(LTRNOW.EQ.LWRPRS(N))GO TO 34
      IF(IPOINT.GT.20)GO TO 37
      L=L+1
   31 M=L
      N=I
      NXTEND=IEND
      GO TO 36
   32 IF(M.LT.NXTEND)GO TO 33
      NXTEND=NXTEND+66
      GO TO 32
   33 M=NXTEND
      GO TO 36
   34 N=N+1
      IF(N.GT.J)GO TO 42
   35 M=M+1
   36 IF(M.LT.INIOPR)GO TO 30
   37 IF(JPOINT.EQ.20)GO TO 9
      IF(JSTN.GE.JEND)GO TO 9
      IF(LTRBIG(JSTN).EQ.LTRLFT)GO TO 39
      IF(LTRBIG(JSTN).EQ.LTRRIT)GO TO 9
      IF(JPOINT.EQ.18)GO TO 9
   38 JSTN=JSTN+1
      GO TO 29
   39 IF(JPOINT.EQ.19)GO TO 9
   40 K=K+1
      GO TO 38
   41 IF(JSTN.GE.JEND)GO TO 9
      IF(LTRBIG(JSTN).EQ.LTRLFT)GO TO 40
      IF(LTRBIG(JSTN).EQ.LTRRIT)K=K-1
      GO TO 38
   42 JSTN=M+1
      GO TO 8
C
C     TEST FOR A NUMBER (INTEGER).
C     IF A NUMBER IS FOUND, NUM IS RETURNED WITH VALUE
C     OF NUMBER, KSTN POINTS TO FIRST CHARACTER IN THE
C     NUMBER (AFTER SPACING OVER LEADING BLANKS, AND BOTH
C     JSTN AND ISTN POINT TO NEXT CHARACTER AFTER LAST
C     DIGIT OF NUMBER.
C     IF A NUMBER IS NOT FOUND, JSTN IS SET TO JIN, BUT
C     NUM, ISTN AND KSTN ARE NOT CHANGED.
   43 J=0
      K=0
      NXTEND=IEND
      GO TO 45
   44 JSTN=JSTN+1
   45 IF(JSTN.GE.JEND)GO TO 47
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 44
      IF(LTRNOW.EQ.LTRTAB)GO TO 44
      IF(LTRNOW.EQ.LTREXC)GO TO 48
      DO 46 I=1,10
      IF(LTRNOW.NE.LTRDGT(I))GO TO 46
      J=(J*10)+I-1
      IF(K.EQ.0)K=JSTN
      JIN1=JSTN
      GO TO 44
   46 CONTINUE
   47 IF(J.LE.0)GO TO 9
      IF(J.GT.99999)GO TO 9
      NUM=J
      JSTN=JIN1+1
      ISTN=JSTN
      KSTN=K
      GO TO 8
   48 IF(JSTN.LT.NXTEND)GO TO 49
      NXTEND=NXTEND+66
      GO TO 48
   49 JSTN=NXTEND
      GO TO 45
C
C     TEST IF CHARACTER IN LTRPRS(I) APPEARS BEFORE THE
C     CHARACTER IN LTRPRS(J) (OR BEFORE END OF STATEMENT).
C     BOTH ARE ONLY TESTED FOR AS SEPARATOR CHARACTERS.
C     IF FIRST CHARACTER IS FOUND, JSTN IS SET AT 1
C     POSITION BEYOND THIS CHARACTER.  IF SECOND CHARACTER
C     IF FOUND OR THE FIRST IS NOT FOUND (FAILURE), JSTN
C     IS SET BACK TO START OF TEXT YET TO BE PROCESSED.
   50 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      LTR1ST=LTRPRS(I)
      LTR2ND=LTRPRS(J)
   51 CALL RENEXT
      IF(JSTN.GE.JEND)GO TO 9
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTR1ST)GO TO 52
      IF(LTRNOW.EQ.LTR2ND)GO TO 9
      JSTN=JSTN+1
      GO TO 51
   52 JSTN=JSTN+1
      GO TO 8
C
C     TEST IF CHARACTER IN LTRPRS(I) APPEARS AS A
C     SEPARATOR CHARACTER BEFORE THE CHARACTER IN
C     LTRPRS(J) APPEARS AS A SEPARATOR CHARACTER,
C     EXCEPT WITHIN A PARENTHETICAL EXPRESSION.
C     FOR EXAMPLE, THIS SECTION IS USED TO
C     TEST IF COMMA APPEARS OUTSIDE OF PARENTHESES
C     (WHERE IT COULD SEPARATE SUBSCRIPTS) IN A
C     DO STATEMENT SUCH AS DO 20 I=J(K,L),J(M,N)
C     IF FIRST CHARACTER IS FOUND, JSTN IS SET AT 1
C     POSITION BEYOND THIS CHARACTER.  IF SECOND CHARACTER
C     IF FOUND OR THE FIRST IS NOT FOUND (FAILURE), JSTN
C     IS SET BACK TO START OF TEXT YET TO BE PROCESSED.
   53 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      LTR1ST=LTRPRS(I)
      LTR2ND=LTRPRS(J)
      K=0
   54 CALL RENEXT
      IF(JSTN.GE.JEND)GO TO 9
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRLFT)GO TO 56
      IF(LTRNOW.EQ.LTRRIT)GO TO 57
      IF(K.NE.0)GO TO 55
      IF(LTRNOW.EQ.LTR1ST)GO TO 52
      IF(LTRNOW.EQ.LTR2ND)GO TO 9
   55 JSTN=JSTN+1
      GO TO 54
   56 K=K+1
      GO TO 55
   57 IF(K.EQ.0)GO TO 9
      K=K-1
      GO TO 55
C
C     TEST IF THE CHARACTER IN LTRPRS(I) APPEARS IN A NON-
C     SEPARATOR SYMBOL BEFORE THAT IN LTRPRS(J) APPEARS AS
C     A SEPARATOR SYMBOL.  IF FIRST CHARACTER IS FOUND,
C     JSTN IS SET AT 1 POSITION BEYOND THIS CHARACTER.
C     IF SECOND CHARACTER IS FOUND OR FIRST IS NOT
C     FOUND (FAILURE), JSTN IS SET BACK TO START OF
C     TEXT NOT YET PROCESSED.
C     USED TO TEST FOR NON-STANDARD SEPARATOR CHARACTERS
C     SUCH AS NUMBER SIGN OR APOSTROPHE IN RANDOM ACCESS
C     READ, WRITE AND FIND STATEMENTS.  THE CHARACTER
C     WILL NOT BE FOUND IN AN ALPHAMERIC STRING.
   58 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      LTR1ST=LTRPRS(I)
      LTR2ND=LTRPRS(J)
      K=0
      NXTEND=IEND
   59 L=JSTN
      CALL RENEXT
      IF(K.NE.0)GO TO 65
      IF(IALPHA.NE.0)GO TO 65
   60 IF(L.GE.INIOPR)GO TO 65
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 61
      IF(LTRNOW.EQ.LTRTAB)GO TO 61
      IF(LTRNOW.EQ.LTREXC)GO TO 62
      IF(LTRNOW.EQ.LTR1ST)GO TO 64
   61 L=L+1
      GO TO 60
   62 IF(L.LT.NXTEND)GO TO 63
      NXTEND=NXTEND+66
      GO TO 62
   63 L=NXTEND
      GO TO 60
   64 JSTN=L+1
      GO TO 8
   65 IF(JSTN.GE.JEND)GO TO 9
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRLFT)GO TO 67
      IF(LTRNOW.EQ.LTRRIT)GO TO 68
      IF(K.NE.0)GO TO 66
      IF(LTRNOW.EQ.LTR2ND)GO TO 9
   66 JSTN=JSTN+1
      GO TO 59
   67 K=K+1
      GO TO 66
   68 IF(K.EQ.0)GO TO 9
      K=K-1
      GO TO 66
C
C     SKIP OVER NUMBER IN UPPER SECTION AND COPY NEW
C     NUMBER INTO MIDDLE SECTION.  AFTER NUMBER HAS
C     BEEN COPIED, JSTN IS SET TO NEXT POSITION AFTER
C     NUMBER IN THE INPUT ARRAY.
   69 IF(LIKE.GE.0)GO TO 74
      IF(JIN.GE.IEND)GO TO 72
      IF(JIN.LT.(IEND+LIKE))GO TO 77
   70 IF(INRCPY.GT.INRFND)GO TO 77
      IF(JIN.LT.INRSTR(INRCPY))GO TO 77
      I=INRSTR(INRCPY)-IEND
      IF(I.GE.-66)GO TO 71
      INRCPY=INRCPY+1
      GO TO 70
   71 LIKE=LIKE-JIN+IEND
      JIN=IEND
   72 IEND=IEND+66
   73 IF(LIKE.EQ.0)GO TO 78
      IF(LTRBIG(JOUT-1).NE.LTRSPC)GO TO 78
      JOUT=JOUT-1
      LIKE=LIKE+1
      GO TO 73
   74 IF(JIN.LT.IEND)GO TO 77
      IF(LIKE.EQ.0)GO TO 76
   75 IF(JOUT.GE.JIN)GO TO 76
      LTRBIG(JOUT)=LTRSPC
      JOUT=JOUT+1
      LIKE=LIKE-1
      IF(LIKE.GT.0)GO TO 75
   76 IEND=IEND+66
   77 LTRBIG(JOUT)=LTRBIG(JIN)
      JIN=JIN+1
      JOUT=JOUT+1
   78 IF(JIN.LT.KSTN)GO TO 69
      IPASS=1
      CALL RENUMB
      IF(IPAGE.EQ.0)GO TO 79
      JOUT=JOUT-1
      KONTRL=0
      CALL REINDX
      JOUT=JOUT+1
   79 IF(INCR.EQ.0)GO TO 93
   80 IF(LIKE.GE.0)GO TO 85
      IF(JIN.GE.IEND)GO TO 83
      IF(JIN.LT.(IEND+LIKE))GO TO 88
   81 IF(INRCPY.GT.INRFND)GO TO 88
      IF(JIN.LT.INRSTR(INRCPY))GO TO 88
      I=INRSTR(INRCPY)-IEND
      IF(I.GE.-66)GO TO 82
      INRCPY=INRCPY+1
      GO TO 81
   82 LIKE=LIKE-JIN+IEND
      JIN=IEND
   83 IEND=IEND+66
   84 IF(LIKE.EQ.0)GO TO 80
      IF(LTRBIG(JOUT-1).NE.LTRSPC)GO TO 80
      JOUT=JOUT-1
      LIKE=LIKE+1
      GO TO 84
   85 IF(JIN.LT.IEND)GO TO 88
      IF(LIKE.EQ.0)GO TO 87
   86 IF(JOUT.GE.JIN)GO TO 87
      LTRBIG(JOUT)=LTRSPC
      JOUT=JOUT+1
      LIKE=LIKE-1
      IF(LIKE.GT.0)GO TO 86
   87 IEND=IEND+66
      GO TO 80
   88 LIKE=LIKE+ISTN-KSTN
      JIN=ISTN
      I=JOUT
   89 LIKE=LIKE-1
      J=NUM
      NUM=NUM/10
      J=J+1-(10*NUM)
      LTRBIG(I)=LTRDGT(J)
      JOUT=JOUT+1
      JBGN=JOUT
C     FOLLOWING STATEMENT TESTS FOR OVERLAP OF MIDDLE
C     AND UPPER SECTIONS.  SUCH OVERLAP COULD ONLY TAKE
C     PLACE IN THIS SECTION.
      IF(JOUT.GT.JIN)GO TO 126
      IF(NUM.LE.0)GO TO 91
      J=JOUT
   90 J=J-1
      LTRBIG(J+1)=LTRBIG(J)
      IF(J.LE.I)GO TO 89
      GO TO 90
   91 IF(LIKE.LT.-65)GO TO 92
      IF(LIKE.LT.66)GO TO 7
      LIKE=LIKE-66
      GO TO 91
   92 LIKE=LIKE+66
      GO TO 91
C
C     COPY STATEMENT NUMBER IF NOT RENUMBERING
   93 LTRBIG(JOUT)=LTRBIG(JIN)
      JIN=JIN+1
      JOUT=JOUT+1
      IF(JIN.LT.ISTN)GO TO 93
      JBGN=JOUT
      GO TO 7
C
C     COPY STATEMENT THROUGH END OF CURRENT EXPRESSION.
C     TEST FOR LEFT PARENTHESIS.  IF FOUND, USE
C     PARENTHESES COUNTING TO GET TO END OF EXPRESSION.
C     JSTN IS LEFT POINTING TO NEXT CHARACTER BEYOND
C     SECTION COPIED.
   94 K=0
      JSTN=JIN
      IPOINT=NUMPRS(IBR)
      GO TO 97
   95 K=K+1
   96 JSTN=JSTN+1
   97 CALL RENEXT
      IF(JSTN.GE.JEND)GO TO 126
      IF(LTRBIG(JSTN).EQ.LTRLFT)GO TO 95
      IF(LTRBIG(JSTN).NE.LTRRIT)GO TO 96
      K=K-1
      IF(K.GT.0)GO TO 96
      JSTN=JSTN+1
      IF(IPOINT.EQ.30)GO TO 8
      GO TO 107
C
C     TEST FIRST NON-BLANK CHARACTER POINTED TO BY
C     JSTN TO SEE IF IT IS IN DATA LIST.  VALUE OF
C     JSTN IS NOT ALTERED EXCEPT TO STEP IT ACROSS
C     LEADING BLANKS.  TRANSFER IS MADE TO DIFFERENT
C     FUNCTION FOR EACH POSSIBLE CHARACTER.
   98 I=NUMPRS(IBR+1)
      J=NUMPRS(IBR+2)
      NXTEND=IEND
   99 LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 102
      IF(LTRNOW.EQ.LTRTAB)GO TO 102
      IF(LTRNOW.NE.LTREXC)GO TO 104
  100 IF(JSTN.LT.NXTEND)GO TO 101
      NXTEND=NXTEND+66
      GO TO 100
  101 JSTN=NXTEND
      GO TO 103
  102 JSTN=JSTN+1
  103 IF(JSTN.LT.JEND)GO TO 99
      IBR=IBR+J-I+4
      GO TO 106
  104 IBR=IBR+3
  105 IF(LTRNOW.EQ.LTRPRS(I))GO TO 106
      IF(LTRNOW.EQ.LWRPRS(I))GO TO 106
      IBR=IBR+1
      I=I+1
      IF(I.LE.J)GO TO 105
  106 IBR=NUMPRS(IBR)
      GO TO 11
C
C     COPY CHARACTERS OF STATEMENT FROM JIN THRU JSTN-1.
C     ADVANCE JIN AND JOUT TO 1 + LAST POSITION COPIED.
  107 IF(JIN.GE.JSTN)GO TO 8
      IF(LIKE.GE.0)GO TO 112
      IF(JIN.GE.IEND)GO TO 110
      IF(JIN.LT.(IEND+LIKE))GO TO 115
  108 IF(INRCPY.GT.INRFND)GO TO 115
      IF(JIN.LT.INRSTR(INRCPY))GO TO 115
      I=INRSTR(INRCPY)-IEND
      IF(I.GE.-66)GO TO 109
      INRCPY=INRCPY+1
      GO TO 108
  109 LIKE=LIKE-JIN+IEND
      JIN=IEND
  110 IEND=IEND+66
  111 IF(LIKE.EQ.0)GO TO 107
      IF(LTRBIG(JOUT-1).NE.LTRSPC)GO TO 107
      JOUT=JOUT-1
      LIKE=LIKE+1
      GO TO 111
  112 IF(JIN.LT.IEND)GO TO 115
      IF(LIKE.EQ.0)GO TO 114
  113 IF(JOUT.GE.JIN)GO TO 114
      LTRBIG(JOUT)=LTRSPC
      JOUT=JOUT+1
      LIKE=LIKE-1
      IF(LIKE.GT.0)GO TO 113
  114 IEND=IEND+66
  115 LTRBIG(JOUT)=LTRBIG(JIN)
      JOUT=JOUT+1
      JIN=JIN+1
      GO TO 107
C
C     CALL DICTIONARY PROGRAM TO ENTER PORTION OF
C     STATEMENT INTO DICTIONARY (USED TO ENTER THE
C     WORDS ''DATA'' AND ''FORMAT'' INTO DICTIONARY
C     BEFORE SCANNING FURTHER INTO STATEMENTS).
  116 IF(IPAGE.EQ.0)GO TO 8
      JOUT=JOUT-1
      KONTRL=0
      CALL REINDX
      JOUT=JOUT+1
      GO TO 8
C
C     ENTER COPIED PORTION LESS LAST CHARACTER INTO
C     SYMBOL DICTIONARY, AND PREVENT ENTRY OF THAT
C     EXCLUDED CHARACTER
  117 IF(IPAGE.EQ.0)GO TO 8
      JOUT=JOUT-2
      KONTRL=0
      CALL REINDX
      JOUT=JOUT+2
      JBGN=JOUT
      GO TO 8
C
C     TEST IF CHARACTER POINTED TO BY JSTN IS AT END
C     OF STATEMENT.  VALUE OF JSTN IS NOT ALTERED EXCEPT
C     TO STEP IT ACROSS LEADING BLANKS.  JSTN IS RESET
C     TO JIN IN CASE OF A FAILURE.
  118 NXTEND=IEND
  119 IF(JSTN.GE.JEND)GO TO 123
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 122
      IF(LTRNOW.EQ.LTRTAB)GO TO 122
      IF(LTRNOW.NE.LTREXC)GO TO 124
  120 IF(JSTN.LT.NXTEND)GO TO 121
      NXTEND=NXTEND+66
      GO TO 120
  121 JSTN=NXTEND
      GO TO 119
  122 JSTN=JSTN+1
      GO TO 119
  123 GO TO 8
  124 GO TO 9
C
C     TURN OFF ENTRY OF VARIABLES INTO DICTIONARY
C     AND OUTPUT REMAINDER OF LINE (USED TO PREVENT
C     INCLUDING GARBAGE IN DATA AND FORMAT STATEMENTS
C     IN THE DICTIONARY LISTING).
  125 IENTER=0
      GO TO 126
C
C     COPY REMAINDER OF STATEMENT FROM UPPER TO MIDDLE
C     SECTION.  EXIT IS MADE WITH JOUT POINTING TO LAST
C     CHARACTER OF MIDDLE SECTION.
  126 IF(JIN.GE.JEND)GO TO 135
      IF(LIKE.GE.0)GO TO 131
      IF(JIN.GE.IEND)GO TO 129
      IF(JIN.LT.(IEND+LIKE))GO TO 134
  127 IF(INRCPY.GT.INRFND)GO TO 134
      IF(JIN.LT.INRSTR(INRCPY))GO TO 134
      I=INRSTR(INRCPY)-IEND
      IF(I.GE.-66)GO TO 128
      INRCPY=INRCPY+1
      GO TO 127
  128 LIKE=LIKE-JIN+IEND
      JIN=IEND
  129 IEND=IEND+66
  130 IF(LIKE.EQ.0)GO TO 126
      IF(LTRBIG(JOUT-1).NE.LTRSPC)GO TO 126
      JOUT=JOUT-1
      LIKE=LIKE+1
      GO TO 130
  131 IF(JIN.LT.IEND)GO TO 134
      IF(LIKE.EQ.0)GO TO 133
  132 IF(JOUT.GE.JIN)GO TO 133
      LTRBIG(JOUT)=LTRSPC
      JOUT=JOUT+1
      LIKE=LIKE-1
      IF(LIKE.GT.0)GO TO 132
  133 IEND=IEND+66
  134 LTRBIG(JOUT)=LTRBIG(JIN)
      JIN=JIN+1
      JOUT=JOUT+1
      GO TO 126
C
C     INSERT NAME IN TABLE OF CONTENTS IF START OF ROUTINE
  135 IF(LSTKNT.NE.0)GO TO 136
      LSTKNT=1
      KONTRL=2
      IBR=2
      CALL RETITL
C
C     ENTER LINE INTO INDEX USING BLANKS AS SEPARATORS
  136 IF(IPAGE.EQ.0)GO TO 137
      JOUT=JOUT-1
      KONTRL=1
      IF(IENTER.GT.0)CALL REINDX
      JOUT=JOUT+1
C
C     PROCESS REMAINING STATEMENTS IN LINE IF ANY
  137 IF(JEND.GE.MAXEND)GO TO 138
      IF(LTRBIG(JEND).NE.LTRSEM)GO TO 4
      JEND=JEND+1
      IENTER=0
      GO TO 126
C
C     RETURN TO CALLING PROGRAM
  138 RETURN
      END
      SUBROUTINE REOUT
C     RENBR(/RENBR ROUTINE TO GENERATE OUTPUT AND LISTING)
C
C     THE FORTRAN RENUMBERING PROGRAM RENBR, JAN 1979
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     THIS ROUTINE LISTS STATEMENTS AND COMMENT
C     LINES IF LISTING IS REQUESTED, AND OUTPUTS
C     NEW COPY OF PROGRAM IF RENUMBERING.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      IF(NCD.NE.0)GO TO 46
C
C     *************************
C     *                       *
C     *  OUTPUT COMMENT LINE  *
C     *                       *
C     *************************
C
      IF(KOMENT.EQ.0)GO TO 1
      KOUNT=KOUNT+1
      GO TO 15
C
C     SCAN FOR AND REPLACE STATEMENT NUMBERS IN COMMENTS
    1 KOMKNT=KOMKNT+1
      IF(KNDGRP.GE.0)KNTTWO=KNTTWO+1
      KNDGRP=-1
      IF(KOMNUM.EQ.0)GO TO 15
      LTRNOW=LTR120(1)
      DO 2 I=1,MAXCOM
      IF(LTRNOW.EQ.LTRCOM(I))GO TO 3
    2 CONTINUE
      GO TO 15
    3 M=0
    4 M=M+1
      IF(M.GE.MAXPRT)GO TO 15
      IF(LTR120(M).NE.LTRREF)GO TO 4
    5 IF(LTR120(M+1).EQ.LTRSPC)GO TO 6
      IF(LTR120(M+1).NE.LTRTAB)GO TO 7
    6 M=M+1
      IF(M.LT.MAXPRT)GO TO 5
    7 NUM=0
      N=M
    8 N=N+1
      IF(N.GT.MAXPRT)GO TO 10
      IF(NUM.GT.9999)GO TO 10
      K=0
    9 K=K+1
      IF(K.GT.10)GO TO 10
      IF(LTRDGT(K).NE.LTR120(N))GO TO 9
      NUM=(10*NUM)+K-1
      GO TO 8
   10 IF(NUM.EQ.0)GO TO 4
      IPASS=1
      CALL RENUMB
      L=MTAB+5
      K=L
   11 IF(N.GT.MAXPRT)GO TO 12
      K=K+1
      LTRBIG(K)=LTR120(N)
      N=N+1
      GO TO 11
   12 MAXPRT=M
   13 N=NUM
      NUM=NUM/10
      N=N-(10*NUM)+1
      LTRBIG(L)=LTRDGT(N)
      M=M+1
      L=L-1
      IF(NUM.GT.0)GO TO 13
   14 L=L+1
      IF(L.GT.K)GO TO 4
      IF(MAXPRT.GE.LNGCOM)GO TO 4
      MAXPRT=MAXPRT+1
      LTR120(MAXPRT)=LTRBIG(L)
      GO TO 14
C
C     COPY COMMENT LINE EXPANDING TABS
C     JTAB IS TAB STOP INTERVAL
   15 IF(IPAGE.NE.0)GO TO 16
      IF(LTAB.EQ.0)GO TO 44
   16 N=MTAB
      I=0
      J=0
   17 IF(J.NE.0)GO TO 18
      J=JTAB
      IF(J.GT.(KTAB-N))J=KTAB-N
   18 I=I+1
      J=J-1
      N=N+1
      IF(LTR120(I).EQ.LTRSPC)GO TO 20
      IF(LTR120(I).NE.LTRTAB)GO TO 20
   19 LTRBIG(N)=LTRSPC
      IF(J.EQ.0)GO TO 21
      N=N+1
      J=J-1
      GO TO 19
   20 LTRBIG(N)=LTR120(I)
   21 IF(N.EQ.KTAB)GO TO 22
      IF(I.LT.MAXPRT)GO TO 17
C
C     OUTPUT COMMENT LINE
   22 IF(IPAGE.EQ.0)GO TO 42
   23 IF(KNT.LT.KUTPAG)GO TO 25
   24 KONTRL=-3
      CALL REINDX
      CALL RETOP
      IF(ISPACE.GT.0)GO TO 27
      GO TO 28
   25 IF(ISPACE.LE.0)GO TO 28
      IF((KNT+ISPACE).GE.KUTPAG)GO TO 24
      KNT=KNT+ISPACE
      DO 26 L=1,ISPACE
   26 WRITE(ILPT,85)
   27 ISPACE=-ISPACE
   28 KNT=KNT+1
      IF(JSPLIT.GT.0)GO TO 34
      JSPLIT=-JSPLIT
      L=NTAB+1
      NTAB=NTAB+58+JSPLIT
      K=N
      IF(K.GT.NTAB)K=NTAB
      M=0
      I=L
   29 IF(LTRBIG(I).NE.LTRSPC)GO TO 30
      M=M+1
      I=I+1
      IF(I.LE.K)GO TO 29
   30 J=57+JSPLIT-K+L
      IF(J.EQ.0)GO TO 32
      IF(M.NE.0)GO TO 31
      WRITE(ILPT,92)(LTRSPC,I=1,J),(LTRBIG(I),I=L,K)
      GO TO 42
   31 WRITE(ILPT,93)M,(LTRSPC,I=1,J),(LTRBIG(I),I=L,K)
      GO TO 42
   32 IF(M.NE.0)GO TO 33
      WRITE(ILPT,92)(LTRBIG(I),I=L,K)
      GO TO 41
   33 WRITE(ILPT,93)M,(LTRBIG(I),I=L,K)
      GO TO 41
   34 NTAB=MTAB+58+JSPLIT
      IF(N.LE.NTAB)GO TO 35
      K=NTAB
      GO TO 36
   35 K=N
   36 IF(KOMENT.EQ.0)GO TO 40
      I=LOW2
      J=KOUNT
   37 L=J
      J=J/10
      M=L-(10*J)
      I=I-1
      LTRBIG(I)=LTRDGT(M+1)
      IF(I.LE.(MTAB-3))GO TO 38
      IF(J.GT.0)GO TO 37
   38 J=MTAB-3
   39 IF(I.LE.MTAB)LTRBIG(J)=LTRBIG(I)
      IF(I.GT.MTAB)LTRBIG(J)=LTRSPC
      I=I+1
      J=J+1
      IF(J.LE.MTAB)GO TO 39
      J=MTAB-3
      WRITE(ILPT,86)(LTRBIG(I),I=J,K)
      GO TO 41
   40 WRITE(ILPT,87)(LTRBIG(I),I=LOW2,K)
   41 IF(K.GE.N)GO TO 42
      JSPLIT=-JSPLIT
      GO TO 23
   42 IF(INCSAV.NE.0)GO TO 43
      IF(INCR.EQ.0)GO TO 45
   43 IF(LTAB.EQ.0)GO TO 44
      WRITE(IOUT,84)(LTRBIG(I),I=LOW2,N)
      GO TO 45
   44 WRITE(IOUT,84)(LTR120(I),I=1,MAXPRT)
   45 IF(KOMENT.NE.0)GO TO 94
      GO TO 97
C
C     ******************************
C     *                            *
C     *  OUTPUT FORTRAN STATEMENT  *
C     *                            *
C     ******************************
C
   46 IF(KNDGRP.LE.0)KNTONE=KNTONE+1
      KNDGRP=1
      JOUT=JOUT-1
      ISTN=LOWER+6
      JSTN=1
      IF(IPAGE.EQ.0)GO TO 47
      IF(ISPACE.LT.0)ISPACE=-ISPACE
C
C     PREPARE TO OUTPUT NEXT LINE OF STATEMENT
   47 KSTN=ISTN+65
      IF(KSTN.LE.JOUT)GO TO 49
      IF(ISTN.GT.JOUT)GO TO 94
      KSTN=JOUT
      GO TO 49
   48 KSTN=KSTN-1
   49 IF(KSTN.LE.ISTN)GO TO 50
      IF(LTRBIG(KSTN).EQ.LTRSPC)GO TO 48
   50 IF(IPAGE.GT.0)GO TO 51
      IF(JSTN.GT.1)GO TO 78
      GO TO 67
C
C     PREPARE TO OUTPUT NEXT LINE OR PART THEREOF
   51 IF(KNT.LT.KUTPAG)GO TO 53
   52 KONTRL=-3
      CALL REINDX
      CALL RETOP
      GO TO 55
   53 IF(ISPACE.EQ.0)GO TO 55
      IF(JSTN.NE.1)GO TO 55
      IF((KNT+ISPACE).GE.KUTPAG)GO TO 52
      KNT=KNT+ISPACE
      DO 54 L=1,ISPACE
   54 WRITE(ILPT,85)
   55 KNT=KNT+1
      IF(ISPLIT.LT.0)GO TO 61
C
C     WRITE LEFT PART OF FIRST LINE OF STATEMENT TO LISTING
      IF(JSTN.GT.1)GO TO 72
      IF(ISPLIT.EQ.0)GO TO 56
      IF((KSTN-LEFT).LE.(61+ISPLIT))GO TO 56
      N=61+LEFT+ISPLIT
      ISPLIT=-ISPLIT
      GO TO 57
   56 N=KSTN
   57 IF(ITAB.EQ.0)GO TO 59
      IF(LSTN.GT.(LOWER+4))GO TO 59
      M=LOWER+5
      K=LOWER+4
      J=LOWER
      I=LSTN-LOWER-1
      IF(LSTSTN.GT.LOWER)GO TO 58
      J=J-1
      I=I+1
   58 IF(I.LE.0)GO TO 59
      WRITE(ILPT,86)(LTRBIG(L),L=LEFT,J),
     1(LTRBIG(L),L=LSTN,K),(LTRSPC,L=1,I),(LTRBIG(L),L=M,N)
      GO TO 60
   59 WRITE(ILPT,86)(LTRBIG(L),L=LEFT,N)
   60 IF(ISPLIT.LT.0)GO TO 51
      GO TO 66
C
C     WRITE EXCESS CHARACTERS OF ANY LONG LINE TO LISTING
   61 ISPLIT=-ISPLIT
      N=N+1
      I=12+N-KSTN+ISPLIT
      J=0
      K=N
   62 IF(LTRBIG(K).NE.LTRSPC)GO TO 63
      J=J+1
      K=K+1
      IF(K.LE.KSTN)GO TO 62
   63 IF(J.NE.0)GO TO 64
      WRITE(ILPT,90)(LTRSPC,L=1,I),
     1(LTRBIG(L),L=N,KSTN)
      GO TO 65
   64 WRITE(ILPT,91)J,(LTRSPC,L=1,I),
     1(LTRBIG(L),L=N,KSTN)
   65 IF(JSTN.GT.1)GO TO 77
C
C     WRITE INITIAL LINE TO RENUMBERED OUTPUT FILE
   66 IF(INCR.EQ.0)GO TO 83
   67 IF(ITAB.GT.0)GO TO 69
      IF(ITAB.EQ.0)GO TO 71
      IF(LSTN.GT.(LOWER+4))GO TO 71
      M=LOWER+5
      K=LOWER+4
      I=LSTN-LOWER-1
      IF(LSTSTN.GT.LOWER)GO TO 68
      I=I+1
      IF(I.LE.0)GO TO 71
      WRITE(IOUT,84)(LTRBIG(L),L=LSTN,K),(LTRSPC,L=1,I),
     1(LTRBIG(L),L=M,KSTN)
      GO TO 83
   68 IF(I.LE.0)GO TO 71
      WRITE(IOUT,84)LTRBIG(LOWER),(LTRBIG(L),L=LSTN,K),
     1(LTRSPC,L=1,I),(LTRBIG(L),L=M,KSTN)
      GO TO 83
   69 LTRBIG(LOWER+5)=LTRTAB
      IF(LSTSTN.GT.LOWER)GO TO 70
      WRITE(IOUT,84)(LTRBIG(L),L=LSTN,KSTN)
      GO TO 83
   70 WRITE(IOUT,84)LTRBIG(LOWER),(LTRBIG(L),L=LSTN,KSTN)
      GO TO 83
   71 WRITE(IOUT,84)(LTRBIG(L),L=LOWER,KSTN)
      GO TO 83
C
C     WRITE CONTINUATION LINE TO LISTING FILE
   72 IF(ISPLIT.EQ.0)GO TO 73
      IF((KSTN-ISTN).LE.(51+ISPLIT))GO TO 73
      N=51+ISTN+ISPLIT
      ISPLIT=-ISPLIT
      GO TO 74
   73 N=KSTN
   74 IF(LSTSTN.GT.LOWER)GO TO 75
      WRITE(ILPT,88)(LTRBIG(L),L=LEFT,LOW1),
     1LTRDGT(JSTN),(LTRBIG(L),L=ISTN,N)
      GO TO 76
   75 WRITE(ILPT,89)(LTRBIG(L),L=LEFT,LOW1),LTRBIG(LOWER),
     1LTRDGT(JSTN),(LTRBIG(L),L=ISTN,N)
   76 IF(ISPLIT.LT.0)GO TO 51
C
C     WRITE CONTINUATION TO RENUMBERED OUTPUT FILE
   77 IF(INCR.EQ.0)GO TO 82
   78 IF(ITAB.GT.0)GO TO 80
      IF(LSTSTN.GT.LOWER)GO TO 79
      WRITE(IOUT,84)(LTRSPC,L=1,5),
     1LTRDGT(JSTN),(LTRBIG(L),L=ISTN,KSTN)
      GO TO 82
   79 WRITE(IOUT,84)LTRBIG(LOWER),(LTRSPC,L=1,4),
     1LTRDGT(JSTN),(LTRBIG(L),L=ISTN,KSTN)
      GO TO 82
   80 IF(LSTSTN.GT.LOWER)GO TO 81
      WRITE(IOUT,84)LTRTAB,LTRDGT(JSTN),
     1(LTRBIG(L),L=ISTN,KSTN)
      GO TO 82
   81 WRITE(IOUT,84)LTRBIG(LOWER),LTRTAB,LTRDGT(JSTN),
     1(LTRBIG(L),L=ISTN,KSTN)
   82 IF(JSTN.EQ.10)JSTN=1
   83 JSTN=JSTN+1
      ISTN=ISTN+66
      GO TO 47
C
C     FORMAT STATEMENTS FOR LISTING
   84 FORMAT(120A1)
   85 FORMAT(1X)
   86 FORMAT(7X,123A1)
   87 FORMAT(11X,119A1)
   88 FORMAT(7X,4A1,5X,67A1)
   89 FORMAT(7X,5A1,4X,67A1)
   90 FORMAT(7X,4H----,45X,26A1)
   91 FORMAT(7X,1H(,1I2,1H),45X,26A1)
   92 FORMAT(7X,4H----,119A1)
   93 FORMAT(7X,1H(,1I2,1H),119A1)
C
C     RETURN TO MAIN PROGRAM
   94 IF(LSTKNT.NE.KOUNT)GO TO 97
      IF(IPAGE.EQ.0)GO TO 95
      KONTRL=8
      CALL RETITL
      I=IPAGE-1
      IF(LPTTTY.LE.0)WRITE(ITTY,96)(LTRTOP(J),J=99,117),I
      GO TO 97
   95 WRITE(ITTY,96)(LTRTOP(J),J=99,117)
   96 FORMAT(1X,19A1,1I5)
   97 RETURN
      END
      SUBROUTINE REDONE
C     RENBR(/RENBR PRINT TABLE OF CONTENTS AND SUMMARY)
C
C     DONALD BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      IF(MASTER.EQ.4)GO TO 3
C
C     FINISHED WITH THIS PROGRAM
      J=LOWDO+1
      IF(J.LE.IHIHDO)WRITE(ITTY,12)(NOLD(I),I=J,IHIHDO)
      IERR=IERR+IHIHDO-LOWDO
      LOWDO=IHIHDO
      IF(INCSAV.NE.0)INCR=INCSAV
      INCSAV=0
      INDENT=INDSAV
      IF(KOMENT.EQ.0)NSTN=NSTN+KOUNT
      IF(KOMENT.NE.0)NONFOR=NONFOR+KOUNT
      IF(IPAGE.EQ.0)GO TO 2
      IF(KOUNT.EQ.0)GO TO 1
      KONTRL=-1
      CALL REINDX
      KONTRL=7
      CALL RETITL
      IF(LRGNUM.LT.LCLNUM)LRGNUM=LCLNUM
      IF(LRGPNT.LT.LCLPNT)LRGPNT=LCLPNT
      IF(LRGSPL.LT.LCLSPL)LRGSPL=LCLSPL
      LCLNUM=0
      LCLPNT=0
      LCLSPL=0
    1 IF(INCR.NE.0)GO TO 2
      IF(IEOF.EQ.0)GO TO 9
      GO TO 3
    2 IF(KOUNT.EQ.0)GO TO 3
      IF(JEOF.NE.0)GO TO 9
C
C     DUMP REST OF TABLE OF CONTENTS AND STOP
    3 IF(IPAGE.EQ.0)GO TO 7
      IF(KNTONE.GT.0)KNTONE=NSTN/KNTONE
      IF(KNTTWO.GT.0)KNTTWO=KOMKNT/KNTTWO
      KONTRL=5
      CALL RETITL
      IF(IFILL.EQ.0)GO TO 5
    4 IF(KNT.GE.IFORM)GO TO 6
      WRITE(ILPT,11)
      KNT=KNT+1
      GO TO 4
    5 WRITE(ILPT,10)
    6 IF(LPTTTY.GT.0)GO TO 8
      KPAGE=IPAGE-KPAGE
      IPAGE=IPAGE-1
      WRITE(ITTY,13)IPAGE,KPAGE
      IF(IBREAK.NE.0)WRITE(ITTY,14)IBREAK
      IF(JBREAK.NE.0)WRITE(ITTY,15)JBREAK
    7 WRITE(ITTY,16)NSTN,KOMKNT
      IF(NONFOR.NE.0)WRITE(ITTY,17)NONFOR
      IF(IERR.NE.0)WRITE(ITTY,19)IERR
      IF(IPAGE.EQ.0)GO TO 8
      IF((IBREAK+JBREAK+ITRACE).NE.0)WRITE(ITTY,18)
     1LRGNUM,IHIHDO,KUTNUM,LRGPNT,MAXPNT,KUTPNT,
     2LRGSPL,MAXSPL,KUTSPL,LRGTOC,MAXTOC
    8 CALL RECLOS(INCR,IOUT,IPAGE,ILPT,LPTTTY)
C     IF(INCR.NE.0)CLOSE(UNIT=IOUT)
C     IF(IPAGE.NE.0)CLOSE(UNIT=ILPT)
      MASTER=0
    9 RETURN
C
C     FORMAT STATEMENTS FOR TELETYPE OUTPUT
   10 FORMAT(1H1)
   11 FORMAT(1X)
   12 FORMAT(7X,13HOpen DO loops,1I5,4I6)
   13 FORMAT(8X,12HThrough Page,1I5/
     110X,10HPage Total,1I5)
   14 FORMAT(1X,19HExtra Number Tables,1I5)
   15 FORMAT(3X,17HExtra Word Tables,1I5)
   16 FORMAT(5X,15HStatement Total,1I5/
     17X,13HComment Total,1I5)
   17 FORMAT(4X,16HNonFORTRAN Total,1I5)
   18 FORMAT(16H Storage Summary/
     18H Num    ,1I5,1H/,1I5,2H(-,I3,1H)/
     28H Wrd Loc,1I5,1H/,1I5,2H(-,I3,1H)/
     38H Wrd Spl,1I5,1H/,1I5,2H(-,I3,1H)/
     48H Tbl    ,1I5,1H/,1I5)
   19 FORMAT(4X,16HNumber of Errors,1I5)
      END
      SUBROUTINE RENUMB
C     RENBR(/RENBR ROUTINE TO FIND REPLACEMENT NUMBERS)
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      IF(INCR.EQ.0)GO TO 11
      IF(MSTN.LE.0)GO TO 4
      I=MSTN
      J=1
      K=J
      GO TO 2
    1 I=K
    2 L=(I-J)/2
      K=I-L
      IF(NUM.EQ.NOLD(K))GO TO 10
      IF(NUM.GT.NOLD(K))GO TO 3
C     THIS IS FINAL TEST IF I-J=1
      IF(L.GT.0)GO TO 1
C     ONE TEST TO GO IF I=J+1.
      IF(I.LE.J)GO TO 5
      K=J
      GO TO 1
C     THIS WAS FINAL TEST IF I=J
C     OR I=J+1.
    3 IF(L.LE.0)GO TO 5
      J=K
      GO TO 2
    4 IF(KPASS.GT.0)GO TO 11
    5 IERR=IERR+1
      IF(NCD.NE.0)GO TO 7
      WRITE(ITTY,6)KOUNT,NUM
    6 FORMAT(19H Comment after line,1I5,
     129H references unknown statement,1I5)
      GO TO 9
    7 WRITE(ITTY,8)KOUNT,NUM
    8 FORMAT(1X,4HLine,1I5,
     129H references unknown statement,1I5)
    9 NUM=0
      GO TO 11
   10 NUM=NNEW(K)
C
C     STORE STATEMENT NUMBER REFERENCE
   11 IF(IPAGE.EQ.0)GO TO 15
      IF(IPASS.LE.0)GO TO 15
      K=MOST
   12 IF(K.LE.MSTN)GO TO 13
      IF(NOLD(K).NE.KOUNT)GO TO 13
      IF(NNEW(K).EQ.NUM)GO TO 15
      K=K-1
      GO TO 12
   13 IF(MOST.LT.LOWDO)GO TO 14
      IF(MSTN.EQ.LOWDO)GO TO 15
      KONTRL=-2
      CALL REINDX
   14 MOST=MOST+1
      LCLNUM=LCLNUM+1
      NNEW(MOST)=NUM
      NOLD(MOST)=KOUNT
      IF(IPASS.EQ.2)NOLD(MOST)=-KOUNT
   15 RETURN
      END
      SUBROUTINE REINDX
C     RENBR(/RENBR ROUTINE TO STORE AND PRINT INDEX)
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     FORTRAN RENUMBERING MAIN PROGRAM CONTAINS CALLS TO
C     THIS ROUTINE WHICH SHOULD BE REMOVED ALONG WITH
C     THE PORTION OF RENUMB WHICH STORES STATEMENT
C     NUMBER REFERENCES IF THE CROSS REFERENCE TABLE
C     AND INDEX ARE NOT WANTED OR IF MORE SPACE IS
C     NEEDED.  THE REST OF THE FORTRAN RENUMBERING
C     PROGRAM DOES NOT REQUIRE THE REINDX ROUTINE.
C
C     THE MAXPNT VARIABLE DEFINED IN THIS ROUTINE MUST BE
C     THE DIMENSION OF THE NUMPNT ARRAY (OR LESS).
C
C     KONTRL = -4, INITIATES NEEDED POINTERS AND ARRAYS
C              -3, PRINTS DICTIONARY AND NUMBER LIST IF
C              IT IS LIKELY THESE WILL FILL IN NEXT PAGE.
C            = -2, STATEMENT NUMBER REFERENCES ONLY.
C            = -1, PRINTS DICTIONARY AND NUMBER REFERENCES.
C            = 0, ENTERS WORDS IN STORAGE IGNORING BLANKS
C            = 1, ENTERS WORDS IN STORAGE USING BLANKS AS
C                 VALID WORD SEPARATORS
C
C     ILEVEL = PARENTHESIS COUNT DURING ADDITION OF WORDS
C              TO THE DICTIONARY.
C
C     JLEVEL = POINTER TO THE LAST NUMPNT ARRAY LOCATION
C              AT WHICH A LINE NUMBER WAS STORED WHILE
C              AT ZERO PARENTHESIS LEVEL.
C
C     KLEVEL = POINTER TO THE LAST NUMPNT ARRAY LOCATION
C              AT WHICH A LINE NUMBER WAS STORED IF THE
C              PARENTHESIS COUNT HAS NOT CHANGED SINCE THEN
C
C     ILPT   = UNIT NUMBER ON WHICH OUTPUT IS TO BE PRINTED
C
C     LTRBIG   = ARRAY CONTAINING IN POSITIONS JBGN THRU
C              JOUT WORDS TO BE ADDED TO THE INDEX.
C
C     KOUNT  = 0, REFERENCE LISTS ARE TO BE PRINTED.
C            = 1 OR GREATER IS LINE SEQUENCE NUMBER.
C
C     LTRTOP = TITLE TO BE PRINTED AT TOP OF PAGE.
C
C     LOWDO  = UPPER END OF NOLD AND NNEW AVAILABLE
C              (SET IN MAIN PROGRAM)
C
C     KUTPAG    = NUMBER OF LINES PER PAGE OF OUTPUT.
C
C     NUMPNT = ARRAY CONTAINING IN POSITIONS MANY THRU MAXPNT
C              POINTERS AND THE LETTERS OF WORDS TO BE
C              INDEXED AND CONTAINING IN POSITIONS 1 THRU
C              KNTPNT POINTERS AND THE SEQUENCE NUMBERS
C              OF THE LINES IN WHICH THESE WORDS APPEAR.
C
C     MAXPNT    = DIMENSION OF NUMPNT ARRAY.
C              (SET INITIALLY WHEN KOUNT = 0 AND IPAGE = 0)
C
C     NNEW   = ARRAY CONTAINING THE NEW STATEMENT NUMBERS
C              CORRESPONDING TO ENTRIES IN NOLD ARRAY.
C
C     NOLD   = ARRAY CONTAINING IN POSITIONS 1 THRU MSTN
C              THE OLD STATEMENT NUMBERS AND CONTAINING IN
C              POSITONS MSTN+1 THRU MOST THE SEQUENCE
C              NUMBERS OF THE LINES IN WHICH THESE APPEAR.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      IF(KONTRL.GE.0)GO TO 37
      IF(KONTRL.EQ.-1)GO TO 1
      IF(KONTRL.EQ.-2)GO TO 2
      IF(KONTRL.EQ.-4)GO TO 33
      IF((LOWDO-MOST).GT.KUTNUM)GO TO 13
      GO TO 2
C
C     ORDER STATEMENT NUMBER REFERENCE STORAGE
    1 IF(MSTN.LE.0)GO TO 2
      LOWSHO=1
      KPOINT=1
      GO TO 3
    2 IF(MSTN.GE.MOST)GO TO 12
      LOWSHO=MSTN+1
      KPOINT=0
    3 CALL DASORT(NNEW,LOWSHO,MOST,NOLD)
      I=LOWSHO-1
      KUTPAG=0
      IF(KONTRL.NE.-1)IBREAK=IBREAK+1
      IF(NNEW(LOWSHO).EQ.0)LOWSHO=LOWSHO-KPOINT
C
C     PRINT STATEMENT NUMBER WITH LINE NUMBER LIST
    4 K=0
      LOWSHO=LOWSHO+KPOINT
    5 I=I+1
      IF(I.EQ.MOST)GO TO 6
      IF(NNEW(I).GE.NNEW(I+1))GO TO 5
    6 L=I
      IF(L.GT.(LOWSHO+8))L=LOWSHO+8
      IF(KNT.GE.KUTPAG)GO TO 7
      IF(K.LE.0)GO TO 8
      GO TO 10
    7 CALL RETOP
      KNT=KNT+3
      WRITE(ILPT,117)
    8 K=1
      IF(LOWSHO.LE.L)GO TO 9
      WRITE(ILPT,119)NNEW(LOWSHO-1)
      GO TO 11
    9 WRITE(ILPT,119)NNEW(LOWSHO),(NOLD(J),J=LOWSHO,L)
      GO TO 11
   10 WRITE(ILPT,121)(NOLD(J),J=LOWSHO,L)
   11 KNT=KNT+1
      LOWSHO=L+1
      IF(LOWSHO.LE.I)GO TO 6
      IF(I.LT.MOST)GO TO 4
C
C     SEARCH FOR LOWEST WORD TO BE PRINTED
   12 MOST=MSTN
      KUTPAG=0
      IF(KONTRL.EQ.-1)GO TO 14
      IF(KONTRL.EQ.-2)GO TO 116
   13 IF((MAXPNT-KNTPNT).LE.KUTPNT)GO TO 14
      IF((MAXSPL-KNTSPL).GT.KUTSPL)GO TO 116
   14 LCLPNT=LCLPNT+KNTPNT
      LCLSPL=LCLSPL+KNTSPL
      KUTPAG=0
      IF(KONTRL.NE.-1)JBREAK=JBREAK+1
      MANY=10
      KNTPNT=1
   15 IF(JPNT(MANY).NE.0)GO TO 16
      MANY=MANY-1
      IF(MANY.GT.0)GO TO 15
      GO TO 35
   16 IF(JPNT(KNTPNT).NE.0)GO TO 17
      KNTPNT=KNTPNT+1
      GO TO 16
   17 NXTLST=KNTPNT
   18 M=NXTLST
      KNTSPL=JPNT(M)
      LOWSHO=NUMPNT(KNTSPL+1)
      KPOINT=M+LOWSHO
   19 IF(NXTLST.EQ.MANY)GO TO 21
      NXTLST=NXTLST+1
      IF(JPNT(NXTLST).EQ.0)GO TO 19
      I=LOWSHO
      J=JPNT(NXTLST)
      J=NUMPNT(J+1)
   20 IF(LTRSPL(I).LT.LTRSPL(J))GO TO 19
      IF(LTRSPL(I).GT.LTRSPL(J))GO TO 18
      I=I+1
      J=J+1
      IF(I.LT.KPOINT)GO TO 20
      GO TO 19
C
C     PRINT WORD WITH LINE NUMBER LIST
   21 J=KNTSPL+3
      L=-1
      KPOINT=KPOINT-1
      K=1
      GO TO 24
   22 K=0
      IF(J.LE.0)GO TO 32
   23 J=NUMPNT(J)
      IF(J.LE.0)GO TO 25
      K=K+1
   24 LINREF(K)=NUMPNT(J+1)
      IF(K.GE.9)GO TO 26
      GO TO 23
   25 IF(K.LE.0)GO TO 32
   26 IF(KNT.GE.KUTPAG)GO TO 27
      IF(L.GE.0)GO TO 30
      GO TO 28
   27 CALL RETOP
      KNT=KNT+2
      WRITE(ILPT,118)
   28 L=9-KPOINT+LOWSHO
      IF(L.GT.0)GO TO 29
      WRITE(ILPT,120)(LTRSPL(I),I=LOWSHO,KPOINT),
     1(LINREF(I),I=1,K)
      GO TO 31
   29 WRITE(ILPT,120)(LTRSPL(I),I=LOWSHO,KPOINT),
     1(LTRSPC,I=1,L),(LINREF(I),I=1,K)
      GO TO 31
   30 WRITE(ILPT,121)(LINREF(I),I=1,K)
   31 KNT=KNT+1
      GO TO 22
   32 JPNT(M)=NUMPNT(KNTSPL)
      GO TO 15
C
C     INITIALIZE NECESSARY CONSTANTS
   33 DO 34 I=1,10
   34 JPNT(I)=0
      KNT=IFORM
   35 KNTPNT=0
      KNTSPL=0
      KUTPAG=0
      JLEVEL=0
      KLEVEL=0
      IF(KONTRL.LT.0)GO TO 116
      GO TO 37
C
C     FIND FIRST NON-SEPARATOR CHARACTER
   36 JBGN=KBGN+1
   37 KBGN=JBGN
      IF(KBGN.GT.JOUT)GO TO 116
      I=1
      L=KBGN
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 36
      IF(LTRNOW.EQ.LTRTAB)GO TO 36
      IF(LTRNOW.NE.LTREXC)GO TO 44
   38 IF(KBGN.LT.KPYEND)GO TO 39
      KPYEND=KPYEND+66
      GO TO 38
   39 JBGN=KPYEND
      GO TO 37
   40 L=L+1
   41 IF(L.GT.JOUT)GO TO 46
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 40
      IF(LTRNOW.EQ.LTRTAB)GO TO 40
      IF(LTRNOW.NE.LTREXC)GO TO 44
   42 IF(L.LT.KPYEND)GO TO 43
      KPYEND=KPYEND+66
      GO TO 42
   43 L=KPYEND
      GO TO 41
   44 IF(LTRNOW.NE.LTROPR(I))GO TO 45
      I=MCHOPR(I)
      IF(I.NE.0)GO TO 40
      IF(L.EQ.KBGN)GO TO 111
      KBGN=L
      GO TO 36
   45 I=NOTOPR(I)
      IF(I.GT.0)GO TO 44
C
C     TEST FOR ALPHAMERIC DATA BETWEEN APOSTROPHES
   46 IFREAR=1
      KEND=KPYEND
      LTRNOW=LTRBIG(KBGN)
      IF(LTRNOW.NE.LTRQOT)GO TO 50
      LNGNAM=0
   47 IF(LNGNAM.GE.10)GO TO 48
      LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRNOW
   48 IF(KBGN.GE.JOUT)GO TO 62
      KBGN=KBGN+1
      LTRNOW=LTRBIG(KBGN)
      IF(LTRNOW.NE.LTRQOT)GO TO 47
      IF(LNGNAM.GE.10)GO TO 49
      LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRNOW
   49 IF(KBGN.GE.JOUT)GO TO 62
      KBGN=KBGN+1
      LTRNOW=LTRBIG(KBGN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 49
      IF(LTRNOW.EQ.LTRTAB)GO TO 49
      IF(LTRNOW.EQ.LTRQOT)GO TO 47
      KBGN=KBGN-1
      GO TO 62
C
C     TEST FOR ALPHAMERIC DATA AFTER NUMBER AND H
   50 LNGNAM=0
      L=KBGN
      LEND=KEND
      DO 51 I=1,10
      IF(LTRNOW.NE.LTRDGT(I))GO TO 51
      M=I-1
      GO TO 52
   51 CONTINUE
      GO TO 71
   52 LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRNOW
   53 L=L+1
   54 IF(L.GT.JOUT)GO TO 79
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 53
      IF(LTRNOW.EQ.LTRTAB)GO TO 53
      IF(LTRNOW.NE.LTREXC)GO TO 57
   55 IF(L.LT.KEND)GO TO 56
      KEND=KEND+66
      GO TO 55
   56 L=KEND
      GO TO 54
   57 DO 58 I=1,10
      IF(LTRNOW.NE.LTRDGT(I))GO TO 58
      IF(M.GT.9999)GO TO 72
      M=10*M+I-1
      IF(LNGNAM.GE.10)GO TO 53
      GO TO 52
   58 CONTINUE
      IF(LTRNOW.EQ.LTRHHH)GO TO 59
      IF(LTRNOW.NE.LWRHHH)GO TO 67
   59 KBGN=L
      IF(LNGNAM.GE.10)GO TO 61
      LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRHHH
      GO TO 61
   60 IF(LNGNAM.GE.10)GO TO 61
      LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRBIG(KBGN)
   61 IF(M.LE.0)GO TO 62
      IF(KBGN.GE.JOUT)GO TO 62
      M=M-1
      KBGN=KBGN+1
      GO TO 60
C
C     REMOVE TERMINAL BLANKS FROM ALPHAMERIC STRINGS
   62 LTRNOW=LTRNAM(LNGNAM)
      IF(LTRNOW.EQ.LTRSPC)GO TO 63
      IF(LTRNOW.NE.LTRTAB)GO TO 99
   63 LNGNAM=LNGNAM-1
      GO TO 62
C
C     TEST FOR NUMBER WITH D OR E EXPONENT
C     M      = .GE.0, ONLY DIGITS FOUND SO FAR.
C              SET BY SECTION LOOKING FOR NUMBER AND H
C            = -1, DECIMAL POINT FOUND
C            = -2, E OR D FOUND AFTER DIGITS OR DECIMAL.
C              THIS COULD BE PRODUCED BY IF(10.EQ.I)GOTO1
C            = -3, SIGN OR DIGIT AFTER E OR D
   64 DO 65 I=1,10
      IF(LTRNOW.EQ.LTRDGT(I))GO TO 66
   65 CONTINUE
      IF(M.GE.-1)GO TO 67
      IF(M.NE.-2)GO TO 78
      IF(LTRNOW.EQ.LTRMNS)GO TO 66
      IF(LTRNOW.NE.LTRPLS)GO TO 79
   66 IF(M.LT.-1)M=-3
      GO TO 72
   67 IF(LTRNOW.EQ.LTREEE)GO TO 69
      IF(LTRNOW.NE.LWREEE)GO TO 68
      LTRNOW=LTREEE
      GO TO 69
   68 IF(LTRNOW.EQ.LTRDDD)GO TO 69
      IF(LTRNOW.NE.LWRDDD)GO TO 70
      LTRNOW=LTRDDD
   69 M=-2
      GO TO 72
   70 IF(M.LT.0)GO TO 79
   71 IF(LTRNOW.NE.LTRDOT)GO TO 79
      M=-1
   72 IF(LNGNAM.GE.10)GO TO 73
      LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRNOW
   73 L=L+1
   74 IF(L.GT.JOUT)GO TO 77
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 73
      IF(LTRNOW.EQ.LTRTAB)GO TO 73
      IF(LTRNOW.NE.LTREXC)GO TO 64
   75 IF(L.LT.KEND)GO TO 76
      KEND=KEND+66
      GO TO 75
   76 L=KEND
      GO TO 74
   77 IF(M.GE.-2)GO TO 79
   78 KBGN=L-1
      GO TO 99
C
C     FIND FINAL NON-SEPARATOR CHARACTER IN WORD
   79 KEND=LEND
      LNGNAM=0
      GO TO 81
   80 IF(KBGN.GE.JOUT)GO TO 99
      KBGN=KBGN+1
   81 I=1
      L=KBGN
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 84
      IF(LTRNOW.EQ.LTRTAB)GO TO 84
      IF(LTRNOW.NE.LTREXC)GO TO 89
   82 IF(L.LT.KEND)GO TO 83
      KEND=KEND+66
      GO TO 82
   83 KBGN=KEND-1
      GO TO 80
   84 IF(KONTRL.NE.0)GO TO 99
      GO TO 80
   85 IF(L.GE.JOUT)GO TO 80
   86 L=L+1
      LTRNOW=LTRBIG(L)
      IF(LTRNOW.EQ.LTRSPC)GO TO 85
      IF(LTRNOW.EQ.LTRTAB)GO TO 85
      IF(LTRNOW.NE.LTREXC)GO TO 89
   87 IF(L.LT.KEND)GO TO 88
      KEND=KEND+66
      GO TO 87
   88 L=KEND-1
      GO TO 85
   89 IF(LTRNOW.NE.LTROPR(I))GO TO 90
      I=MCHOPR(I)
      IF(I.LE.0)GO TO 98
      IF(L.GE.JOUT)GO TO 91
      GO TO 86
   90 I=NOTOPR(I)
      IF(I.GT.0)GO TO 89
   91 IF(LNGNAM.GE.10)GO TO 80
C
C     PLACE UPPER CASE FORM OF LETTER INTO LTRNAM ARRAY.
C     THIS IS A TERNARY SEARCH TAKING ADVANTAGE OF THE SIZE
C     OF  ALPHABET BEING NEARLY 3**3.  THE 3RD OF THE ARRAY
C     CONTAINING THE DESIRED LETTER IS FIRST LOCATED,  THEN
C     THE  3RD  OF  THIS  3RD,  AND  FINALLY  EACH  OF  THE
C     REMAINING 3  LETTERS  ARE  TESTED  INDIVIDUALLY.   TO
C     PREVENT  TESTING  AGAINST  THE 27TH LETTER WHICH DOES
C     NOT EXIST, UPPER 3RD  IS  TAKEN  AS  UPPER  9  SORTED
C     LETTERS,  RATHER THAN FROM 19TH THROUGH 27TH LETTERS,
C     SO THAT LOWER(18) IS TESTED AGAINST IN UPPER 3RD EVEN
C     THOUGH LETTER BEING MATCHED HAS ALREADY BEEN FOUND TO
C     BE LARGER THAN THIS.
      LTRNOW=LTRBIG(KBGN)
      IF(LTRNOW.GT.LWRSRT(18))GO TO 93
      IF(LTRNOW.GT.LWRSRT(9))GO TO 92
      IF(LTRNOW.LT.LWRSRT(1))GO TO 97
      NXTLST=3
      GO TO 94
   92 NXTLST=12
      GO TO 94
   93 IF(LTRNOW.GT.LWRSRT(26))GO TO 97
      NXTLST=20
   94 IF(LTRNOW.LE.LWRSRT(NXTLST))GO TO 95
      NXTLST=NXTLST+3
      IF(LTRNOW.GT.LWRSRT(NXTLST))NXTLST=NXTLST+3
   95 IF(LTRNOW.EQ.LWRSRT(NXTLST))GO TO 96
      NXTLST=NXTLST-1
      IF(LTRNOW.EQ.LWRSRT(NXTLST))GO TO 96
      NXTLST=NXTLST-1
      IF(LTRNOW.NE.LWRSRT(NXTLST))GO TO 97
   96 LTRNOW=LTRSRT(NXTLST)
   97 LNGNAM=LNGNAM+1
      LTRNAM(LNGNAM)=LTRNOW
      GO TO 80
C
C     TEST IF WORD IS IN DICTIONARY
   98 IFREAR=L-KBGN
      KBGN=L
   99 NXTLST=JPNT(LNGNAM)
      M=0
      GO TO 101
  100 M=NXTLST
      NXTLST=NUMPNT(NXTLST)
  101 IF(NXTLST.EQ.0)GO TO 103
      KPOINT=NUMPNT(NXTLST+1)
      DO 102 I=1,LNGNAM
      LTRNOW=LTRNAM(I)
      IF(LTRNOW.GT.LTRSPL(KPOINT))GO TO 100
      IF(LTRNOW.NE.LTRSPL(KPOINT))GO TO 103
  102 KPOINT=KPOINT+1
      GO TO 107
C
C     ADD WORD TO DICTIONARY
  103 IF((KNTPNT+5).GT.MAXPNT)GO TO 14
      IF((KNTSPL+LNGNAM).GT.MAXSPL)GO TO 14
      IF(M.NE.0)GO TO 104
      JPNT(LNGNAM)=KNTPNT+1
      GO TO 105
  104 NUMPNT(M)=KNTPNT+1
  105 NUMPNT(KNTPNT+1)=NXTLST
      NUMPNT(KNTPNT+2)=KNTSPL+1
      NUMPNT(KNTPNT+3)=KNTPNT+4
      NUMPNT(KNTPNT+4)=0
      NUMPNT(KNTPNT+5)=KOUNT
      KNTPNT=KNTPNT+5
      DO 106 I=1,LNGNAM
      KNTSPL=KNTSPL+1
      LTRSPL(KNTSPL)=LTRNAM(I)
  106 CONTINUE
      GO TO 108
C
C     STORE LINE SEQUENCE NUMBER
  107 I=NUMPNT(NXTLST+2)
      M=NUMPNT(I+1)
      IF(M.LT.0)M=-M
      IF(M.EQ.KOUNT)GO TO 109
      IF((KNTPNT+2).GT.MAXPNT)GO TO 14
      KNTPNT=KNTPNT+2
      NUMPNT(KNTPNT)=KOUNT
      NUMPNT(KNTPNT-1)=0
      NUMPNT(I)=KNTPNT-1
      NUMPNT(NXTLST+2)=KNTPNT-1
  108 KLEVEL=KNTPNT
      GO TO 110
  109 KLEVEL=I+1
  110 IF(ILEVEL.EQ.0)JLEVEL=KLEVEL
      IF(IFREAR.NE.0)GO TO 36
      LTRNOW=LTRBIG(KBGN)
C
C     ADJUST PARENTHESIS COUNT OR MARK FOR EQUALS
  111 IF(LTRNOW.NE.LTREQL)GO TO 113
      IF(ILEVEL.NE.0)GO TO 112
C     INDICATE EQUALS AT ZERO PARENTHESIS LEVEL
      IF(JLEVEL.NE.0)NUMPNT(JLEVEL)=-KOUNT
      GO TO 36
C     INDICATE EQUALS AT NON-ZERO PARENTHESIS LEVEL
  112 IF(KLEVEL.NE.0)NUMPNT(KLEVEL)=-KOUNT
      GO TO 36
C     ADJUST PARENTHESIS COUNT FOR ( OR )
  113 IF(LTRNOW.EQ.LTRLFT)GO TO 114
      IF(LTRNOW.NE.LTRRIT)GO TO 36
      ILEVEL=ILEVEL-1
      GO TO 115
  114 ILEVEL=ILEVEL+1
  115 KLEVEL=0
      GO TO 36
C
C     RETURN TO CALLING PROGRAM
  116 RETURN
  117 FORMAT(7X,9HStatement/
     17X,6HNumber,8X,13HReferenced by/)
  118 FORMAT(7X,4HWord,10X,12HContained in/)
  119 FORMAT(7X,1I6,1I9,8I6)
  120 FORMAT(7X,10A1,1I5,8I6)
  121 FORMAT(16X,9I6)
  122 FORMAT(1X)
      END
      SUBROUTINE RECMND
C     RENBR(/RENBR ROUTINE TO INTERPRET CRENBR COMMAND)
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     KONTRL = 1, LOOK FOR CRENBR AND SWITCHES
C            = 2, LOOK FOR CRENBR, IGNORE SWITCHES
C            = 3, LOOK FOR EITHER CRENBR OR RENBRSTART
C              OR RENBRTITLE AND GET SWITCHES
C            = 4, LOOK FOR EITHER CRENBR OR RENBRSTART
C              OR RENBRTITLE AND IGNORE SWITCHES
C            = 5, LOOK FOR RENBRSTART OR RENBRTITLE
C              AND GET SWITCHES
C            = 6, LOOK FOR RENBRSTART OR RENBRTITLE
C              AND IGNORE SWITCHES
C            = -1, RETURNED IF RENBRSTART FOUND
C            = -2, RETURNED IF RENBRTITLE IS FOUND
C            = 0, RETURNED IF CRENBR FOUND
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     LOOK FOR WORD RENBRSTART ANYWHERE ON LINE
      IF(KONTRL.LE.2)GO TO 12
      L=MAXPRT
      IF(L.GT.72)L=72
      K=0
    1 IF(K.GE.(L-9))GO TO 11
      I=K
      K=K+1
      J=1
C     LOOK FOR RENBR BEFORE LOOKING FOR TITLE OR START
    2 I=I+1
      IF(I.GT.L)GO TO 11
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 2
      IF(LTRNOW.EQ.LTRTAB)GO TO 2
      IF(LTRNOW.EQ.LTRKEY(J))GO TO 3
      IF(LTRNOW.NE.LWRKEY(J))GO TO 1
    3 J=J+1
      IF(J.LE.5)GO TO 2
C     LOOK FOR WORD TITLE FOLLOWING RENBR
      J=1
    4 I=I+1
      IF(I.GT.L)GO TO 11
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 4
      IF(LTRNOW.EQ.LTRTAB)GO TO 4
      IF(LTRNOW.EQ.LTRTTL(J))GO TO 5
      IF(LTRNOW.NE.LWRTTL(J))GO TO 6
    5 J=J+1
      IF(J.LE.5)GO TO 4
      J=KONTRL
      KONTRL=-2
      GO TO 10
C     LOOK FOR WORD START FOLLOWING RENBR
    6 IF(J.NE.1)GO TO 1
      GO TO 8
    7 I=I+1
      IF(I.GT.L)GO TO 11
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 7
      IF(LTRNOW.EQ.LTRTAB)GO TO 7
    8 IF(LTRNOW.EQ.LTRBGN(J))GO TO 9
      IF(LTRNOW.NE.LWRBGN(J))GO TO 1
    9 J=J+1
      IF(J.LE.5)GO TO 7
      J=KONTRL
      KONTRL=-1
   10 IF(J.EQ.6)GO TO 58
      GO TO 17
   11 IF(KONTRL.GT.4)GO TO 58
C
C     LOOK FOR THE WORD RENBR FOLLOWING INITIAL C
   12 LTRNOW=LTR120(1)
      DO 13 I=1,MAXCOM
      IF(LTRNOW.EQ.LTRCOM(I))GO TO 14
   13 CONTINUE
      GO TO 58
   14 I=1
      J=1
   15 IF(I.EQ.MAXPRT)GO TO 58
      I=I+1
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 15
      IF(LTRNOW.EQ.LTRTAB)GO TO 15
      IF(LTRNOW.EQ.LTRKEY(J))GO TO 16
      IF(LTRNOW.NE.LWRKEY(J))GO TO 58
   16 J=J+1
      IF(J.LE.5)GO TO 15
      J=KONTRL
      KONTRL=0
      IF(J.EQ.2)GO TO 58
   17 IF(J.EQ.4)GO TO 58
C
C     LOOK FOR ONE OF THE LETTERS B I M N O
   18 IF(I.EQ.MAXPRT)GO TO 58
      I=I+1
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRLFT)GO TO 22
      IF(LTRNOW.EQ.LTRSPC)GO TO 18
      IF(LTRNOW.EQ.LTRTAB)GO TO 18
      J=1
   19 IF(LTRNOW.EQ.LTRFLG(J))GO TO 20
      IF(LTRNOW.EQ.LWRFLG(J))GO TO 20
      J=J+1
      IF(J.LE.3)GO TO 19
      IF(IPASS.NE.0)GO TO 18
      IF(J.LE.8)GO TO 19
      GO TO 18
   20 J=J-1
      IF(J.NE.0)GO TO 40
C
C     LETTER R IS FOLLOWED BY CHARACTER TO INDICATE
C     STATEMENT NUMBER REFERENCE IN COMMENT LINES
   21 IF(I.EQ.MAXPRT)GO TO 58
      I=I+1
      IF(LTR120(I).EQ.LTRSPC)GO TO 21
      IF(LTR120(I).EQ.LTRTAB)GO TO 21
      KOMNUM=1
      LTRREF=LTR120(I)
      GO TO 18
C
C     LETTER ( INDICATES CHANGED PROGRAM NAME
   22 L=0
      J=0
   23 IF(I.EQ.MAXPRT)GO TO 25
      I=I+1
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRRIT)GO TO 25
      IF(LTRNOW.EQ.LTRSLA)GO TO 24
      IF(LTRNOW.EQ.LTRSPC)GO TO 23
      IF(LTRNOW.EQ.LTRTAB)GO TO 23
      IF(L.EQ.6)GO TO 23
      L=L+1
      LTRUSE(L)=LTRNOW
      GO TO 23
   24 J=1
   25 IF(L.EQ.0)GO TO 33
      IF(ITITLE.LT.0)GO TO 27
      ITITLE=L
      M=117
   26 LTRTOP(M)=LTRSPC
      IF(L.GT.0)LTRTOP(M)=LTRUSE(L)
      M=M-1
      L=L-1
      IF(M.GT.111)GO TO 26
      GO TO 33
   27 M=-ITITLE
      K=6-L
      N=L
   28 LTRTOP(M)=LTRUSE(L)
      L=L-1
      M=M-1
      IF(L.GT.0)GO TO 28
   29 IF(K.LE.0)GO TO 30
      LTRTOP(M)=LTRSPC
      M=M-1
      K=K-1
      GO TO 29
   30 IF(IPAGE.LE.0)GO TO 32
      K=6*KNTTOC-6
      DO 31 M=1,6
      K=K+1
      LTRTOC(K)=LTRSPC
      IF(M.LE.N)LTRTOC(K)=LTRUSE(M)
   31 CONTINUE
   32 CONTINUE
C
C     / IN PARENTHESES INDICATES NEW SUBTITLE
   33 IF(J.EQ.0)GO TO 18
      K=54
      L=0
   34 IF(I.GE.MAXPRT)GO TO 38
      I=I+1
      IF(LTR120(I).EQ.LTRSPC)GO TO 34
      IF(LTR120(I).EQ.LTRTAB)GO TO 34
      GO TO 36
   35 IF(I.GE.MAXPRT)GO TO 38
      I=I+1
   36 LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRLFT)J=J+1
      IF(LTRNOW.NE.LTRRIT)GO TO 37
      J=J-1
      IF(J.EQ.0)GO TO 38
   37 IF(L.GE.44)GO TO 35
      IF(IPAGE.EQ.0)GO TO 35
      L=L+1
      K=K+1
      LTRTOP(K)=LTRNOW
      IF(LTRNOW.EQ.LTRSPC)GO TO 35
      IF(LTRNOW.EQ.LTRTAB)LTRTOP(K)=LTRSPC
      GO TO 35
   38 IF(L.EQ.0)GO TO 18
   39 IF(L.GE.44)GO TO 18
      L=L+1
      K=K+1
      LTRTOP(K)=LTRSPC
      GO TO 39
C
C     LOOK FOR NUMBER FOLLOWING ONE OF LETTERS B I N OR O.
C     N SWITCH (J=5, 6TH ITEM IN LTRFLG OR LWRFLG ARRAY) IS
C       ALWAYS CONVERTED TO O SWITCH OF SAME CASE.
C     O SWITCH (J=6) IS REMOVED IF N SWITCH HAS ALREADY
C       BEEN FOUND (MODNEW.NE.0).
C     O SWITCH IS LEFT INTACT IF N SWITCH HAS NOT BEEN
C       FOUND (MODNEW=0).
   40 IF(KMDMIN.NE.0)GO TO 18
      IF(KMDMAX.GT.0)GO TO 18
      L=0
      NUM=0
      IF(J.EQ.5)GO TO 41
      IF(J.NE.6)GO TO 42
      IF(MODNEW.NE.0)LTR120(I)=LTRSPC
      GO TO 42
   41 LTR120(I)=LTRFLG(7)
      IF(LTRNOW.NE.LTRFLG(6))LTR120(I)=LWRFLG(7)
   42 I=I+1
      IF(I.GT.MAXPRT)GO TO 48
      LTRNOW=LTR120(I)
      IF(LTRNOW.EQ.LTRSPC)GO TO 43
      IF(LTRNOW.NE.LTRTAB)GO TO 44
   43 IF(L.LE.0)GO TO 42
      GO TO 48
   44 DO 46 K=1,10
      IF(LTRNOW.NE.LTRDGT(K))GO TO 46
      IF(L.GT.1)GO TO 45
      NUM=(10*NUM)+K-1
      L=1
      GO TO 47
   45 NUM=(10*NUM)-K+1
      GO TO 47
   46 CONTINUE
      IF(L.GT.0)GO TO 48
      IF(LTRNOW.EQ.LTRPLS)L=1
      IF(LTRNOW.EQ.LTRMNS)L=2
      IF(L.GT.0)GO TO 47
      IF(L.NE.0)GO TO 48
      IF(LTRNOW.EQ.LTRCLN)L=-1
      IF(L.EQ.0)GO TO 48
   47 IF(J.NE.6)GO TO 42
      IF(MODNEW.NE.0)LTR120(I)=LTRSPC
      GO TO 42
C
C     NUMBER FOUND
   48 I=I-1
      IF(J.EQ.4)GO TO 50
      IF(NUM.LT.0)NUM=0
      GO TO (54,55,49,50,51,52,53,56)J
   49 MODBAS=NUM
      GO TO 18
   50 MODINC=NUM
      GO TO 18
   51 MODNEW=NUM
      GO TO 18
   52 MODOLD=NUM
      GO TO 18
   53 MODMIN=NUM
      J=8
      GO TO 40
   54 LNGNXT=NUM
      IF(LNGNXT.LT.72)LNGNXT=LNGNXT+72
      IF(LNGNXT.GT.120)LNGNXT=120
      GO TO 18
   55 INDENT=NUM
      GO TO 18
   56 IF(NUM.GT.0)GO TO 57
      IF(MODMIN.GT.0)NUM=99999
      IF(MODMIN.EQ.0)MODMIN=-1
   57 IF(MODMIN.EQ.0)MODMIN=1
      MODMAX=NUM
      GO TO 18
C
C     RETURN TO CALLING PROGRAM
   58 RETURN
      END
      SUBROUTINE RETITL
C     RENBR(/RENBR ROUTINE TO FIND ROUTINE NAMES)
C
C     ROUTINE TO TEST FOR APPEARANCE OF WORDS
C     FUNCTION, BLOCK DATA OR SUBROUTINE IN
C     LINE OF TEXT STARTING AT ISTART THROUGH MAXPRT
C     AND COPY MATCHED WORD AND NEXT 6 NON-BLANK
C     CHARACTERS (UP TO LEFT PARENTHESIS OR EQUAL
C     SIGN) INTO LTRTOP ARRAY.
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     LTRBIG   = ARRAY CONTAINING ALPHAMERIC DATA TO BE
C              SEARCHED FOR MATCH AGAINST WORDS IN
C              LTRTYP ARRAY.
C     MAXPRT = SUBSCRIPT OF FINAL CHARACTER IN LTRBIG
C              ARRAY.
C     KONTRL = 1, DUMP TABLE IF FULL, AND INSERT NEW TITLE
C              INTO TABLE, SEARCH STATEMENT STARTING AT
C              JSTN OR USE NAME IN LTRUSE IF ANY.
C              NUMPRS(IBR+4) CONTAINS LOCATION IN NUMTYP
C              ARRAY CONTAINING START OF ROUTINE TYPE.
C            = 2, DUMP TABLE IF FULL, AND INSERT NEW TITLE
C              INTO TABLE.  IBR IS LOCATION IN NUMTYP
C              ARRAY CONTAINING START OF ROUTINE TYPE.
C            = 3, SAME AS 2 EXCEPT ROUTINE TYPE ISN'T TO
C              BE INSERTED INTO LTRTOP.
C            = 4, DUMP TABLE IF FULL, INSERT NOTHING.
C            = 5, DUMP TABLE IF IT CONTAINS ANYTHING,
C              INSERT NOTHING.  USED FOR FINAL TABLE.
C            = 6, INITIALIZE TABLE STORAGE.
C            = 7, INSERT LINE COUNT INTO CURRENT ITEM.
C            = 8, INSERT PAGE NUMBER INTO CURRENT ITEM.
C     LTRTOP = ARRAY INTO WHICH MATCH AND NEXT 6
C              NON-BLANK CHARACTERS ARE TO BE PACKED.
C     IPAGE  = CURRENT PAGE NUMBER IN LISTING
C     ILPT   = UNIT ON WHICH TABLE OF CONTENTS IS WRITTEN.
C     KNT    = NUMBER OF LINES ALREADY ON PRESENT PAGE.
C     KUTPAG    = NUMBER OF LINES PER LISTER PAGE.
C     KNTTOC  = NUMBER OF LOCATIONS IN NUMTOC ARRAY
C              IN USE.
C     MAXTOC  = EFFECTIVE DIMENSION OF NUMTOC ARRAY.
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C
C
      GO TO(6,6,6,6,5,1,4,3),KONTRL
C
C     INITIALIZE
    1 KNTTOC=0
C
C     LOWER EFFECTIVE SIZE OF NUMTOC ARRAY IF PAGE SIZE
C     COULD GIVE PARTIAL TRAILING PAGE IN TABLE OF CONTENTS
      LMTTOC=(JFORM-JMPBGN-JMPEND-4)/2
      MAXTOC=INITOC
      LRGTOC=0
      IF(MAXTOC.LE.LMTTOC)GO TO 51
      I=0
    2 I=I+LMTTOC
      IF(I.LE.MAXTOC)GO TO 2
      MAXTOC=I-LMTTOC
      GO TO 51
C
C     INSERT PAGE NUMBER INTO CURRENT ITEM
    3 IF(KNTTOC.NE.0)NUMTOC(4*KNTTOC-2)=IPAGE-1
      GO TO 51
C
C     INSERT LINE COUNT FOR CURRENT ITEM
    4 IF(KNTTOC.GT.0)NUMTOC(4*KNTTOC-1)=KOUNT-LSTKNT+1
      GO TO 51
C
C     CHECK IF TABLE OF CONTENTS MUST BE PRINTED NOW
    5 IF(IPAGE.EQ.0)GO TO 51
      IF(KNTTOC.EQ.0)GO TO 51
      GO TO 7
    6 IF(IPAGE.EQ.0)GO TO 36
      IF(KNTTOC.LT.MAXTOC)GO TO 36
    7 CONTINUE
C
C     CONVERT LOWER CASE ROUTINE NAMES TO UPPER CASE
      LOCALB=0
      LOCALC=6*KNTTOC
    8 LOCALB=LOCALB+1
      IF(LOCALB.GT.LOCALC)GO TO 15
      LTRNOW=LTRTOC(LOCALB)
      IF(LTRNOW.EQ.LTRSPC)GO TO 8
      IF(LTRNOW.GT.LWRSRT(26))GO TO 8
      LOCALA=0
    9 LOCALA=LOCALA+1
      IF(LTRNOW.GT.LWRSRT(LOCALA))GO TO 9
      IF(LTRNOW.EQ.LWRSRT(LOCALA))LTRTOC(LOCALB)=LTRSRT(LOCALA)
      GO TO 8
C
C     DETERMINE ALPHABETICAL ORDERING OF ROUTINES
   10 LOCALA=LOWTOC
      LOCALF=0
   11 LOCALB=(6*LOCALA)-5
      LOCALE=(6*NOWTOC)+1
      DO 12 LOCALC=1,6
      IF(LTRTOC(LOCALB).EQ.LTRSPC)GO TO 13
      IF(LTRTOC(LOCALE).EQ.LTRSPC)GO TO 14
      IF(LTRTOC(LOCALB).LT.LTRTOC(LOCALE))GO TO 13
      IF(LTRTOC(LOCALB).GT.LTRTOC(LOCALE))GO TO 14
      LOCALB=LOCALB+1
   12 LOCALE=LOCALE+1
   13 LOCALF=4*LOCALA
      LOCALA=NUMTOC(LOCALF)
      IF(LOCALA.NE.0)GO TO 11
   14 IF(LOCALF.EQ.0)GO TO 16
      NUMTOC(LOCALF)=NOWTOC+1
      NUMTOC(4*NOWTOC+4)=LOCALA
      GO TO 17
   15 LOWTOC=0
      NOWTOC=0
   16 NUMTOC(4*NOWTOC+4)=LOWTOC
      LOWTOC=NOWTOC+1
   17 NOWTOC=NOWTOC+1
      IF(NOWTOC.LT.KNTTOC)GO TO 10
C
C     PRINT THE TABLE OF CONTENTS
      LRGTOC=LRGTOC+KNTTOC
      DO 35 JTBL=1,ITBL
      IPOINT=1
      KUTPAG=0
      NOWTOC=LOWTOC
   18 IF(KNT.LT.(KUTPAG-1))GO TO 31
      KPAGE=KPAGE-1
      KUTPAG=JMPEND
      JMPEND=JMPBGN
      JMPBGN=KUTPAG
      KUTPAG=JFORM-KUTPAG
      IF(IFILL.NE.0)GO TO 21
      IF(JMPEND.GT.0)GO TO 20
      WRITE(ILPT,19)(LTRTOP(I),I=1,54)
   19 FORMAT(1H1,6X,54A1,9H Table of)
      KNT=1
      GO TO 27
   20 WRITE(ILPT,19)
      KNT=1
      GO TO 24
   21 IF(KNT.GE.IFORM)GO TO 23
      KNT=KNT+1
      WRITE(ILPT,22)
   22 FORMAT(1X)
      GO TO 21
   23 KNT=KNT-IFORM
   24 IF(KNT.GE.JMPEND)GO TO 25
      WRITE(ILPT,22)
      KNT=KNT+1
      GO TO 24
   25 WRITE(ILPT,26)(LTRTOP(I),I=1,54)
   26 FORMAT(7X,54A1,9H Table of)
      KNT=KNT+1
   27 KNT=KNT+3
      IF(KONTRL.NE.5)GO TO 29
      IF((IPOINT+LMTTOC).LE.KNTTOC)GO TO 29
      WRITE(ILPT,28)NSTN,KOMKNT,NONFOR,KNTONE,KNTTWO
   28 FORMAT(7X,10HStatements,1I6,
     110H, Comments,1I6,12H, NonFORTRAN,1I6,5X,8HContents/
     27X,11H(Avg Group),1I5,1H,1I15/
     330X,4HPage,23X,6HLength,3X,4HPage)
      GO TO 31
   29 WRITE(ILPT,30)
   30 FORMAT(62X,8HContents/
     11X/30X,4HPage,23X,6HLength,3X,4HPage)
   31 KNT=KNT+2
C     FIND NEXT ITEM ALPHABETICALLY
      LOCALB=6*NOWTOC
      LOCALA=LOCALB-5
      NOWTOC=4*NOWTOC
      LOCALD=NUMTOC(NOWTOC-3)
      LOCALC=NUMTYP(LOCALD)
      LOCALD=NUMTYP(LOCALD+1)-1
      LOCALE=12-LOCALD+LOCALC
      LOCALF=NOWTOC-2
C     GET ITEM BY ORDER OF APPEARANCE
      LOCALK=NUMTOC(4*IPOINT-3)
      LOCALJ=NUMTYP(LOCALK)
      LOCALK=NUMTYP(LOCALK+1)-1
      LOCALI=(6*IPOINT)
      LOCALH=LOCALI-5
   32 IF(LTRTOC(LOCALI).NE.LTRSPC)GO TO 33
      LOCALI=LOCALI-1
      IF(LOCALI.GT.LOCALH)GO TO 32
   33 LOCALG=17-LOCALK+LOCALJ-LOCALI+LOCALH
      LOCALL=4*IPOINT-1
      LOCALM=LOCALL-1
      WRITE(ILPT,34)
     1(LTRTOC(I),I=LOCALA,LOCALB),
     2(LTRTYP(I),I=LOCALC,LOCALD),
     3(LTRSPC,I=1,LOCALE),
     4NUMTOC(LOCALF),
     5(LTRSPC,I=1,LOCALG),
     6(LTRTOC(I),I=LOCALH,LOCALI),LTRSPC,
     7(LTRTYP(I),I=LOCALJ,LOCALK),
     8NUMTOC(LOCALL),NUMTOC(LOCALM)
   34 FORMAT(1X/7X,6A1,1X,13A1,1I7,4X,20A1,1I5,1I7)
      IPOINT=IPOINT+1
      NOWTOC=NUMTOC(NOWTOC)
      IF(NOWTOC.GT.0)GO TO 18
   35 CONTINUE
      KNTTOC=0
      KUTPAG=0
C
C     SEARCH FOR PROGRAM TYPE
   36 IF(KONTRL.GE.4)GO TO 51
      L=IBR
      IF(KONTRL.EQ.3)GO TO 44
      IF(KONTRL.EQ.1)L=NUMPRS(L+4)
      I=NUMTYP(L)
      J=NUMTYP(L+1)
C
C     INSERT PROGRAM TYPE NAME INTO LTRTOP
   37 K=ININAM+18
   38 J=J-1
      LTRTOP(K)=LTRTYP(J)
      K=K-1
      IF(J.GT.I)GO TO 38
      LTRTOP(K)=LTRSPC
      K=K-1
      I=ITITLE
      ITITLE=-K
C
C     INSERT NEXT 6 LETTERS INTO LTRTOP
      M=6*KNTTOC
      IF(I.GT.0)GO TO 45
      IF(KONTRL.EQ.2)GO TO 48
      I=K-5
      J=I
      IPOINT=JSTN
      KEND=IEND
   39 IF(IPOINT.GE.JEND)GO TO 43
      LTRNOW=LTRBIG(IPOINT)
      IF(LTRNOW.EQ.LTRSPC)GO TO 40
      IF(LTRNOW.EQ.LTRTAB)GO TO 40
      IF(LTRNOW.EQ.LTRLFT)GO TO 43
      IF(LTRNOW.EQ.LTREXC)GO TO 41
      LTRTOP(I)=LTRBIG(IPOINT)
      M=M+1
      IF(IPAGE.GT.0)LTRTOC(M)=LTRBIG(IPOINT)
      I=I+1
      IF(I.GT.K)GO TO 43
   40 IPOINT=IPOINT+1
      GO TO 39
   41 IF(IPOINT.LT.KEND)GO TO 42
      KEND=KEND+66
      GO TO 41
   42 IPOINT=KEND
      GO TO 39
C
C     SHIFT LETTERS OF 6 (OR LESS) LETTERS RIGHT
   43 IF(I.EQ.J)GO TO 48
      I=I-1
      LTRTOP(K)=LTRTOP(I)
      K=K-1
      GO TO 43
C
C     KONTRL=6, DON'T SEARCH INPUT LINE
   44 IF(ITITLE.LT.0)GO TO 51
      I=ITITLE
      K=ININAM+18
      M=6*KNTTOC
      ITITLE=-K
C
C     FILL IN NAME SPECIFIED BY CRENBR LINE
   45 J=0
   46 IF(I.EQ.0)GO TO 48
      LTRTOP(K)=LTRUSE(I)
      I=I-1
      J=J+1
      K=K-1
      M=M+1
      IF(IPAGE.GT.0)LTRTOC(M)=LTRUSE(J)
      GO TO 46
C
C     FILL IN REST OF LTRTOP WITH BLANKS
   47 LTRTOP(K)=LTRSPC
      K=K-1
   48 IF(K.GE.ININAM)GO TO 47
C
C     FILL REST OF ROUTINE NAME WITH SPACES
      IF(IPAGE.EQ.0)GO TO 51
      J=(6*KNTTOC)+6
   49 IF(M.GE.J)GO TO 50
      M=M+1
      LTRTOC(M)=LTRSPC
      GO TO 49
   50 NUMTOC(4*KNTTOC+1)=L
      NUMTOC(4*KNTTOC+2)=IPAGE
      KNTTOC=KNTTOC+1
C
C     RETURN TO CALLING PROGRAM
   51 RETURN
      END
      SUBROUTINE RENEXT
C     RENBR(/RENBR ROUTINE TO FIND SEPARATOR CHARACTERS)
C
C     ROUTINE TO LOCATE THE NEXT SEPARATOR CHARACTER
C     GROUPING IN LINE OF TEXT.
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     THE NECESSARY INFORMATION IS AS FOLLOWS
C
C     LTRBIG   = ARRAY CONTAINING TEXT TO BE SEARCHED
C     JEND   = SUBSCRIPT OF LETTER FOLLOWING FINAL LETTER
C              TO BE TESTED
C     INIOPR = RETURNED WITH SUBSCRIPT OF FIRST CHARACTER
C              OF THE SEPARATOR
C     JSTN   = RETURNED WITH SUBSCRIPT OF FINAL CHARACTER
C              OF THE THE SEPARATOR
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
C     TEST FOR ALPHAMERIC DATA BETWEEN APOSTROPHES
      KEND=IEND
      INIOPR=JSTN
      IALPHA=0
    1 IF(INIOPR.GE.JEND)GO TO 27
      LTRNOW=LTRBIG(INIOPR)
      IF(LTRNOW.EQ.LTRSPC)GO TO 4
      IF(LTRNOW.EQ.LTRTAB)GO TO 4
      IF(LTRNOW.NE.LTREXC)GO TO 5
      IF(INIOPR.LE.INRSTR(INRFND))GO TO 2
      INRFND=INRFND+1
      INRSTR(INRFND)=INIOPR
    2 IF(INIOPR.LT.KEND)GO TO 3
      KEND=KEND+66
      GO TO 2
    3 INIOPR=KEND-1
    4 INIOPR=INIOPR+1
      GO TO 1
    5 IF(LTRNOW.NE.LTRQOT)GO TO 8
      IALPHA=1
    6 INIOPR=INIOPR+1
      IF(INIOPR.GE.JEND)GO TO 27
      IF(LTRBIG(INIOPR).NE.LTRQOT)GO TO 6
    7 INIOPR=INIOPR+1
      IF(INIOPR.GE.JEND)GO TO 27
      IF(LTRBIG(INIOPR).EQ.LTRSPC)GO TO 7
      IF(LTRBIG(INIOPR).EQ.LTRTAB)GO TO 7
      IF(LTRBIG(INIOPR).NE.LTRQOT)GO TO 17
      GO TO 6
C
C     TEST FOR ALPHAMERIC DATA AFTER NUMBER AND H
    8 DO 9 M=1,10
      IF(LTRNOW.NE.LTRDGT(M))GO TO 9
      JSTN=M-1
      GO TO 10
    9 CONTINUE
      GO TO 17
   10 INIOPR=INIOPR+1
      IF(INIOPR.GE.JEND)GO TO 27
      LTRNOW=LTRBIG(INIOPR)
      IF(LTRNOW.EQ.LTRSPC)GO TO 10
      IF(LTRNOW.EQ.LTRTAB)GO TO 10
      IF(LTRNOW.NE.LTREXC)GO TO 13
      IF(INIOPR.LE.INRSTR(INRFND))GO TO 11
      INRFND=INRFND+1
      INRSTR(INRFND)=INIOPR
   11 IF(INIOPR.LT.KEND)GO TO 12
      KEND=KEND+66
      GO TO 11
   12 INIOPR=KEND-1
      GO TO 10
   13 DO 14 M=1,10
      IF(LTRNOW.NE.LTRDGT(M))GO TO 14
      IF(JSTN.GT.9999)GO TO 14
      JSTN=10*JSTN+M-1
      GO TO 10
   14 CONTINUE
      IF(LTRNOW.EQ.LTRHHH)GO TO 15
      IF(LTRNOW.NE.LWRHHH)GO TO 17
   15 IALPHA=1
      INIOPR=INIOPR+JSTN+1
      IF(INIOPR.GE.JEND)GO TO 26
      GO TO 17
C
C     TEST FOR SEPARATOR CHARACTERS
   16 INIOPR=INIOPR+1
      IF(INIOPR.GE.JEND)GO TO 27
   17 M=1
      LEND=KEND
      JSTN=INIOPR
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 16
      IF(LTRNOW.EQ.LTRTAB)GO TO 16
      IF(LTRNOW.EQ.LTRSEM)GO TO 25
      IF(LTRNOW.NE.LTREXC)GO TO 23
      IF(JSTN.LE.INRSTR(INRFND))GO TO 18
      INRFND=INRFND+1
      INRSTR(INRFND)=JSTN
   18 IF(INIOPR.LT.KEND)GO TO 19
      KEND=KEND+66
      GO TO 18
   19 INIOPR=KEND-1
      GO TO 16
   20 JSTN=JSTN+1
      IF(JSTN.GE.JEND)GO TO 16
      LTRNOW=LTRBIG(JSTN)
      IF(LTRNOW.EQ.LTRSPC)GO TO 20
      IF(LTRNOW.EQ.LTRTAB)GO TO 20
      IF(LTRNOW.NE.LTREXC)GO TO 23
      IF(JSTN.LE.INRSTR(INRFND))GO TO 21
      INRFND=INRFND+1
      INRSTR(INRFND)=JSTN
   21 IF(JSTN.LT.LEND)GO TO 22
      LEND=LEND+66
      GO TO 21
   22 JSTN=LEND-1
      GO TO 20
   23 IF(LTRNOW.NE.LTROPR(M))GO TO 24
      M=MCHOPR(M)
      IF(M.LE.0)GO TO 28
      GO TO 20
   24 M=NOTOPR(M)
      IF(M.LE.0)GO TO 16
      GO TO 23
   25 JEND=INIOPR
   26 INIOPR=JEND
   27 JSTN=JEND
   28 RETURN
      END
      SUBROUTINE RETOP
C     RENBR(/RENBR ROUTINE TO GENERATE PAGE HEADINGS)
C
C     THE FORTRAN RENUMBERING PROGRAM RENBR, JAN 1979
C
C     DONALD E. BARTH, DIVISION OF COMPUTER SERVICES
C     HARVARD BUSINESS SCHOOL, BOSTON, MASS. 02163
C
C     THIS ROUTINE GENERATES PAGE HEADERS FOR ALL BUT
C     THE TABLE OF CONTENTS
C
      COMMON/RNBONE/I     ,IALPHA,IBASE ,IBR   ,IBREAK,
     1IEND  ,IENTER,IEOF  ,IERR  ,IFILL ,IFORM ,IFREAR,
     2IHIHDO,IIN   ,ILEVEL,ILPT  ,INCR  ,INCSAV,INDENT,
     3INDSAV,ININAM,INIOPR,INIPRT,INITOC,INRCPY,INRFND,
     4IOUT  ,IPAGE ,IPASS ,IPOINT,ISPACE,ISPLIT,ISPR  ,
     5ISTART,ISTN  ,ITAB  ,ITBL  ,ITITLE,ITRACE,ITTY  ,
     6J     ,JBGN  ,JBREAK,JEND  ,JEOF  ,JFORM ,JIN   ,
     7JIN1  ,JLEVEL,JMPBGN,JMPEND,JOBNUM,JOUT  ,JPASS ,
     8JPOINT,JSPLIT,JSTN  ,JTAB  ,JTBL  ,JTTY  ,K     ,
     9KBGN  ,KEND  ,KLEVEL,KMDMAX,KMDMIN,KNDGRP,KNT
C
      COMMON/RNBTWO/KNTONE,KNTPNT,KNTSPL,KNTTOC,KNTTWO,
     1KOMENT,KOMKNT,KOMNUM,KONTRL,KOUNT ,KPAGE ,KPASS ,
     2KPOINT,KPYEND,KSTN  ,KTAB  ,KUTNUM,KUTPAG,KUTPNT,
     3KUTSPL,L     ,LCLNUM,LCLPNT,LCLSPL,LEFT  ,LEND  ,
     4LIKE  ,LMTTOC,LNGCOM,LNGNAM,LNGNXT,LOWDO ,LOWER ,
     5LOWSHO,LOWTOC,LOW1  ,LOW2  ,LPOINT,LPTTTY,LRGNUM,
     6LRGPNT,LRGSPL,LRGTOC,LSTKNT,LSTN  ,LSTSTN,LTAB  ,
     7M     ,MANY  ,MASTER,MAXCOM,MAXEND,MAXLIN,MAXPNT,
     8MAXPRT,MAXSPL,MAXTOC,MID   ,MODBAS,MODINC,MODMAX,
     9MODMIN,MODNEW,MODOLD,MOST  ,MOVE  ,MSTN  ,MTAB
C
      COMMON/RNBTHR/N     ,NCD   ,NEED  ,NEWNUM,NEWSTN,
     1NONFOR,NOWTOC,NSTN  ,NTAB  ,NUM   ,NXTEND,NXTLST
C
      COMMON/RNBFOU/INRSTR(21)  ,JPNT(10)    ,LINREF(9)   ,
     1 MCHOPR(51)  ,NNEW(1000)  ,NOLD(1000)  ,NOTOPR(51)  ,
     2 NUMPNT(5000),NUMPRS(655) ,NUMTOC(112) ,NUMTYP(7)
C
      COMMON/RNBFIV/LTRCLN,LTRDDD,LTRDOT,LTREEE,LTREQL,
     1LTREXC,LTRHHH,LTRLFT,LTRMNS,LTRNOW,LTRPLS,LTRQOT,
     2LTRREF,LTRRIT,LTRSEM,LTRSLA,LTRSPC,LTRTAB,LTR1ST,
     3LTR2ND,LWRDDD,LWREEE,LWRHHH
C
      COMMON/RNBSIX/LTRABC(26)  ,LTRBGN(5)   ,LTRBIG(2211),
     1 LTRCOM(6)   ,LTRDGT(10)  ,LTREND(3)   ,LTRFLG(8)   ,
     2 LTRKEY(5)   ,LTRNAM(10)  ,LTROPR(51)  ,LTRPRS(331) ,
     3 LTRSPL(2000),LTRSRT(26)  ,LTRTOC(168) ,LTRTOP(117) ,
     4 LTRTTL(5)   ,LTRTYP(55)  ,LTRUSE(6)   ,LTR120(120) ,
     5 LWRABC(26)  ,LWRBGN(5)   ,LWREND(3)   ,LWRFLG(8)   ,
     6 LWRKEY(5)   ,LWRPRS(331) ,LWRSRT(26)  ,LWRTTL(5)
C
      KUTPAG=JMPEND
      JMPEND=JMPBGN
      JMPBGN=KUTPAG
      KUTPAG=JFORM-KUTPAG
      IF(IFILL.NE.0)GO TO 2
      IF(JMPEND.GT.0)GO TO 1
      WRITE(ILPT,8)(LTRTOP(LPOINT),LPOINT=1,54),IPAGE,
     1 (LTRTOP(LPOINT),LPOINT=55,117)
      KNT=3
      GO TO 6
    1 WRITE(ILPT,8)
      KNT=1
      GO TO 4
    2 IF(KNT.GE.IFORM)GO TO 3
      KNT=KNT+1
      WRITE(ILPT,7)
      GO TO 2
    3 KNT=KNT-IFORM
    4 IF(KNT.GE.JMPEND)GO TO 5
      WRITE(ILPT,7)
      KNT=KNT+1
      GO TO 4
    5 WRITE(ILPT,9)(LTRTOP(LPOINT),LPOINT=1,54),IPAGE,
     1 (LTRTOP(LPOINT),LPOINT=55,117)
      KNT=KNT+3
    6 IPAGE=IPAGE+1
      RETURN
    7 FORMAT(1X)
    8 FORMAT(1H1,6X,54A1,4HPage,1I5/7X,63A1/1X)
    9 FORMAT(7X,54A1,4HPage,1I5/7X,63A1/1X)
      END
      SUBROUTINE DASORT(IARRAY,ILOWER,IUPPER,JARRAY)
C     RENBR(/BUBBLE SORT ROUTINE)
C
C     DONALD BARTH, CHEMISTRY DEPT., HARVARD UNIVERSITY
C
C     REGIONS CONTAINING INITIAL ORDERING ARE SWAPPED BY
C     THREADING ITEMS BEING MOVED INTO THEIR NEW LOCATIONS.
C
C     IARRAY = THE ARRAY TO BE SORTED.
C     ILOWER = LOWEST SUBSCRIPT OF REGION TO BE SORTED.
C     IUPPER = HIGHEST SUBSCRIPT OF REGION TO BE SORTED.
C     JARRAY = ARRAY TO BE HELD PARALLEL TO IARRAY.
C
      DIMENSION IARRAY(1),JARRAY(1)
C
C     FIND UPPER END OF LOWER REGION TO BE SWAPPED
      IPNTR=ILOWER
    1 MID=IPNTR
      IPNTR=IPNTR+1
    2 IF(IPNTR.GT.IUPPER)GO TO 12
      IF(IARRAY(IPNTR).GE.IARRAY(MID))GO TO 1
C
C     FIND LOWER END OF LOWER REGION TO BE SWAPPED
      ITEST=IARRAY(IPNTR)
      LOW=ILOWER
    3 IF(ITEST.LT.IARRAY(LOW))GO TO 4
      LOW=LOW+1
      GO TO 3
C
C     FIND UPPER END OF UPPER REGION TO BE SWAPPED
    4 JTEST=IARRAY(LOW)
    5 MAX=IPNTR
      IPNTR=IPNTR+1
      IF(IPNTR.GT.IUPPER)GO TO 6
      ITEST=IARRAY(IPNTR)
      IF(ITEST.LT.IARRAY(MAX))GO TO 6
      IF(ITEST.LT.JTEST)GO TO 5
C
C     PERFORM THE THREADED SWAP OF ORDERED REGIONS
C
C     IF THERE WERE SEVERAL PARALLEL ARRAYS, IT MIGHT
C     BE CONVENIENT TO REPLACE THE FOLLOWING SECTION BY
C     CALLS TO THE SWAPPING ROUTINE DASWAP SIMILAR TO
C
C     CALL DASWAP(IARRAY,LOW,MID,MAX)
C     CALL DASWAP(JARRAY,LOW,MID,MAX)
C
    6 ITEST=LOW-MAX-1
      LAST=MAX
      LOW=LOW-MID-1
      JTEST=MAX-MID
    7 INDEX=LAST+LOW
      IKEEP=IARRAY(LAST)
      JKEEP=JARRAY(LAST)
    8 ITEST=ITEST+1
      INEW=IARRAY(INDEX)
      JNEW=JARRAY(INDEX)
      IARRAY(INDEX)=IKEEP
      JARRAY(INDEX)=JKEEP
      IKEEP=INEW
      JKEEP=JNEW
      IF(INDEX.GT.MID)GO TO 9
      INDEX=INDEX+JTEST
      GO TO 8
    9 IF(INDEX.EQ.LAST)GO TO 10
      INDEX=INDEX+LOW
      GO TO 8
   10 IF(ITEST.EQ.0)GO TO 11
      LAST=LAST-1
      GO TO 7
C
C     PREPARE TO FIND NEXT ORDERED REGION
   11 MID=MAX
      GO TO 2
   12 RETURN
      END
 
