@Device(PagedFile)
@Make(Report)
@Style(	Spacing 1,PaperLength 60, BottomMargin .5 Inches,
	Indent 0,Date "March 8th, 1952")
@Modify(Itemize,Spread 0)
@Modify(HD1,Below 1,Above 1)
@Modify(HD2,Below 1,Above 1)
@Modify(HD3,Below 1,Above 1)
@PageHeading(Left "@Value[SectionTitle]", Right"Page @Value[Page]")
@Begin(TitlePage)
@Begin(TitleBox)
MACPS

A MacPaint to PostScript
Conversion Utility
@End(TitleBox)
Michael P. Kaczmarczik
@Value(Date)
The University of Texas at Austin
Computation Center
Austin, Texas
@End(TitlePage)
@Chapter(Introduction)
@Section(Overview)

MacPs is a utility to convert Macintosh MacPaint
files into a format suitable for printing on the Apple LaserWriter, and
other printers which use the PostScript language.  It is written in
Rutgers Pascal and is the product of inspiration from many sources.

An important feature of MacPs is its ability to produce files
which may be included in a Scribe document with the @@Picture command.
The image bitmap may be centered and sized to fit exactly in the
specified space on the page, giving a fine degree of control over
the final picture.

@Section(Credits)
MacPs is based on EXTRACT_TOP.C, by J.W. Peterson of the University of
Utah, and MACQMS.PAS by E. Lavitsky at Rutgers.  EXTRACT_TOP, written
in C, would not work on our system (the C I/O package we have uses
7-bit bytes, and 8 are necessary), so I recoded the extraction code
from EXTRACT_TOP and added TOPS-20 argument parsing in the same style
as MACQMS.  This documentation also owes a large debt to E. Lavitsky's
excellent documentation for MACQMS.


@Section(System Requirements)
You will need the following to use MacPs:
@Begin(Itemize)
Macintosh Computer

Macintosh diskette with MacKermit and System Folder

Macintosh diskette with MacPaint documents

Connection (modem, Micom line) to the DEC-20

User account and access to the KERMIT-20 program on the DEC-20

Access to an Apple LaserWriter printer
@End(Itemize)

@Section(Disclaimer)

MacPS is supplied as unsupported software, so you take your own risks
when you use it.  However, please feel free to send comments,
suggestions, and so forth to Mic Kaczmarczik
(cc.kaczmarczik@@a20.cc.utexas.edu).  Especially useful would be
suggestions for improving the dialogue and defaults that are
currently used.

@Chapter(Getting files to the DEC-20)
@Section(On the Macintosh)

NOTE:This section describes file transfer using MacKermit V0.8 or later.

When you prepare MacPaint images for transmission to the DEC-20, be
aware that if you want to extract an image smaller than the entire
MacPaint page the image must be in the top left corner of the MacPaint
document.  If the image is not there already, select "Show Page" from
the "Goodies" menu, drag the image to the top left corner, then save
the document.

When printed on the LaserWriter, areas of black will tend to be faded
in the center.  If this is undesireable, use patterns with less black
in them.

If you have a two-drive system, a convenient way to perform the file
transfer is to have Kermit on the system diskette (in the internal
drive) and the diskette with MacPaint files on the external drive.)
That way, you do not have to switch diskettes while transferring
files.

Start Kermit and
choose "File Defaults" from the File menu. Select "Binary" transfer
mode and "Data" as the default file fork, and click "OK". Selecting
the data fork assures that the MacKermit will offer MacPaint files
when you try to send them.  (This is a bug in this version of MacKermit.)

Select "Communications" from the File menu and make the following
settings:
@Begin(Itemize)
Set the baud rate to the appropriate value for your connection to 
the DEC-20 (the faster the better).
XON/XOFF flow control
1 stop bit
NO parity
@End(Itemize)

You should now be able to connect to the DEC-20.  Dial up, select
class codes, hit carriage returns, and do whatever is necessary to get
the attention of the DEC-20.

@Section(Transferring the files)
Log in to the DEC-20. Once you are at the "@@" prompt, start up DEC-20
Kermit by typing @Example(KERMIT:KERMIT)The 20 will respond with the
KERMIT-20> prompt.

The Macintosh, along with many other computer systems, stores
information in 8-bit bytes.  The DEC-20, however, usually stores them
in 7-bit bytes.  Since all the bits of information from the MacPaint
document are necessary, type in
@Begin(Example)
KERMIT-20>SET FILE BYTESIZE 8
@End(Example)
to tell the DEC-20 to use 8-bit bytes for the file transfer.

Now you are ready to send files.  Type in
@Begin(Example)
KERMIT-20>RECEIVE
or
KERMIT-20>RECIEVE filename
@End(Example)
to tell KERMIT-20 to wait for a file from the Macintosh.
On the Macintosh,
select "Send" from the File menu, select the MacPaint file
you wish to send from the dialogue box, then click on "Send" to start
the transfer.  MacKermit will inform you of the progress of
the file transfer until it is complete.  When complete, click the mouse
button once to remove the dialogue box.  You may then send another MacPaint
file, or type
@Example(KERMIT-20>EXIT)
to return to the TOPS-20 prompt.

@Chapter(MacPs Parameters)

Now that the MacPaint file has been transferred to the DEC-20, you may
convert it into one ready for insertion into a Scribe document.

@Section(Scribe Image Parameters)
MacPs has a number of settable parameters which control the height,
color, horizontal centering, and vertical positioning of the image:

@SubSection(Image Height)
The height parameter is the height you want the image to be.  This
value should exactly match the "Size" attribute you plan to use
in the Scribe @@Picture command.

@SubSection(Column Width)
The Scribe column width should match the column width of your Scribe
document.  This will assure that the rectangular area extracted from the
MacPaint document is centered on the output page.

@SubSection(Upward Translation)
The upward translation parameter allows you to move the image
vertically.  Its main usefulness is for centering images vertically as
well as horizontally.

For example, if you desire a 3 inch tall image and also want at least
.5 binches of space around it, specify a picture size of 4 (= 3 + 1)
inches in the @@Picture command, then specify an upward translation
of .5 inches. This will center the image in the 4 inch tall area.

@SubSection(Inverted Image)
Inverting the image means making white dots black and black dots
white.  This is useful for special effects.  Remember that inverting
an image with a lot of blank area may case the center of the area to
wash out somewhat.

@Section(Document Parameters)

The nature of the encoding of the MacPaint image requires MacPs to
always extract a rectangular area from a MacPaint document.  By
default, the entire MacPaint page, starting from the top left corner,
is extracted, but the number of scan lines and the width of the scan
lines may changed:

@SubSection(Vertical Scan Lines)
The number of vertical scan lines determines the relative height of
the picture.  The maximum number is 720 (the height of the MacPaint
page) and the minimum is 1 (the top scan line of the image).  The
MacPaint window has a height of 240 scan lines.

@SubSection(Horizontal Line Width)
The horizontal line width determines the relative width of the
picture.  The maximum is 72 bytes (576 bits), while the MacPaint
window has a width of 52 bytes (420 bits).

The image is always taken from the top left corner of the MacPaint
document.  Thus if you wish to extract an image smaller than the
entire MacPaint page, you must select Show Page from the Goodies menu
of MacPaint and move the desired image to an appropriate spot at the
top left of the page before transferring it to the DEC-20.

@Chapter(Running MacPs)
Here is an example run of MacPs, using the file PIC.MPT as the input file.
@Begin(Example)
	@@UNS:MACPS
	MacPs -- MacPaint to Postscript converter
	Mac filename: PIC.MPT
	Output filename: PIC.PS
	Change Scribe page parameters? YES
	Image height: 5
	Scribe column width: 6.5
	Upward translation: 0
	Change MacPaint image parameters? Yes
	Vertical scan lines: 240
	Horizontal Line Width: 52
	Inverted image? NO
	Processing file PIC.PS [OK]
	@@
@End(Example)

In this example, a rectangular bitmap with the dimensions of a
MacPaint window (240 bits high by 52*8 bits wide), located at the top
left corner of the MacPaint page, was extracted.  The rectangular area
this represents will be centered in a column 6.5 inches wide, and is
to be 5 inches tall. The width of the image will be adjusted so
that it has the proper proportions.)

@Chapter(Running Scribe)
After processing by MacPs, your MacPaint image is finally ready for
insertion in a Scribe document.

At the beginning of your document, use the @T(@@Device(PostScript))
command to inform Scribe that you wish to generate output for the
Apple LaserWriter.

At the point you want the image to appear in the Scribe document,
enter the @@Figure, @@FullPageFigure, or @@Equation environment and
use the @@Picture command to insert the MacPaint image:
@Begin(Example)
@@Comment[Must use device type "PostScript"]
@@Device(PostScript)
...... Scribe commands and text ......
@@Begin(Figure)
@@Picture(Size = 5 inches, ScaleAbleLaser = "PIC.PS")
@@Caption(<Whatever may be appropriate>)
@@End(Figure)
...... more Scribe commands and text ......
@End(Example)

The @@Picture command may only be used inside the @@Figure,
@@FullPageFigure, and @@Equation environments.  However, these
environnments are available in any Scribe document type that has a
Table Of Contents (e.g. Report, Article, Thesis, etc.).

Now run Scribe and print the output file (for example, PICTURE.MSS
would generate PICTURE.PS as the output file) on the Apple
LaserWriter.  Consult your local guru on how to print the resulting
file on the LaserWriter.

