C     RENBR(JOBS/JOBS - STUDENT REQUEST PROGRAM)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS PROGRAM IS PART OF THE JOB INTERVIEW REQUEST SYSTEM
C
      COMMON/JOBONE/LOADED
C
C     UPPER CASE A-Z, LOWER CASE A-Z AND DIGITS 0-9
      COMMON/RSMFIV/LTRABC(26),LWRABC(26),LTRDGT(10)
C
C     ********************************************************
C     *                                                      *
C     *  ARRAYS LIMITING NUMBER OF FIRMS HANDLED BY PROGRAM  *
C     *                                                      *
C     ********************************************************
C
C     ARRAYS WHICH STORE INFORMATION ABOUT ALL FIRMS RECRUITING
C
C     FOLLOWING ARRAYS STORE ALPHABETIC INFORMATION FOR EACH FIRM
C     LTRINC = THE NAME OF THE FIRM
C     LTRDPT = THE DIVISION NAMES
C     LTRADR = THE LOCATION OF THE FIRM
C
      DIMENSION LTRINC(40,200),LTRDPT(30,200),LTRADR(30,200)
C
C     FOLLOWING ARRAYS STORE 1 NUMBER FOR EACH FIRM
C     KNTOPN = NUMBER OF INTERVIEW SLOTS BOTH ALLOCATED AND
C              UNALLOCATED
C     INTRVW = NUMBER OF OPEN SCHEDULES OR RECRUITERS
C     IUSDUP = NUMBER OF INTERVIEW SLOTS ALLOCATED ALREADY
C     NUMBER = THE IDENTIFICATION CODE FOR FIRM
C     LENGTH = NUMBER OF MINUTES IN 1 INTERVIEW 30, 45 OR 60
C     INCLSD = NUMBER STUDENTS ON CLOSED LIST
C     JNCLSD = NUMBER STUDENTS ON CLOSED LIST ABOVE CUT OFF LINE
C     KFIRST = LOCATION IN SCHEDULE STORAGE OF FIRST SCHEDULE
C
      DIMENSION LENGTH(200),KNTOPN(200),NUMBER(200),
     1 INTRVW(200),IUSDUP(200),INCLSD(200),JNCLSD(200),
     2 KFIRST(200)
C
C     ARRAYS CONTAINING 1 NUMBER FOR EACH RECRUITER
C     JFIRST = TIME OF FIRST INTERVIEW IN SCHEDULE
C     JFINAL = TIME OF FINAL INTERVIEW IN SCHEDULE
C     JDATE  = DATE OF INTERVIEWS
C     JSCHDL = SCHEDULE NUMBER AMONG ALL OF SAME LENGTH
C
      DIMENSION JFIRST(1000),JFINAL(1000),JDATE(1000),
     1 JSCHDL(1000)
C
C     ********************************************************
C     *                                                      *
C     *  ARRAYS WHICH STORE FIRMS REQUESTED BY THIS STUDENT  *
C     *                                                      *
C     ********************************************************
C
C     NUMVOT = THE IDENTIFICATION CODE OF THE FIRM
C     KNDVOT = PRIORITY ASSIGNED TO THE REQUEST BY USER
C     IRANK  = RANKING OF STUDENTS APPLICATION FOR INTERVIEW
C            = 0, NO RANKING YET DONE
C            = GREATER THAN 1, RANKING. LOWEST GET INTERVIEWS,
C              REST ARE ON WAIT LIST.
C     IPREFR = DESIRED STARTING TIMES SPECIFIED BY USER.
C              DIMENSION 13 IS MAXIMUM NUMBER OF SLOTS IN 1 DAY
C     KNTPRF = NUMBER OF PREFERRED TIMES SPECIFIED
C     KLOCK  = LENGTH OF INTERVIEW IF INTERVIEW ALREADY SCHEDULED
C            = 0, NO REAL INTERVIEW YET SCHEDULED
C     KLOSED = IF ON OPEN OR CLOSED LIST.
C            = 0, SCHEDULE ON OPEN (UNINVITED) SCHEDULE
C            = 1, SCHEDULE ON CLOSED (INVITED) SCHEDULE
C            = 2, REJECTED BY FIRM AS UNQUALIFIED
C            = 3, CANCELLED BY STUDENT
C     ISOURC = 0, REQUESTED BY STUDENT ONLY
C            = 1, REQUESTED BY BOTH STUDENT AND FIRM
C            = 2, REQUESTED BY FIRM ONLY
C     JRANK  = NUMBER STUDENTS ABOVE ON RANKED LIST WHO
C              ARE ELIGIBLE FOR OPEN INTERVIEWS
C              (NOT REJECTED, NOT CANCELLED, NOT ON CLOSED)
C     MTIME  = TIME OF SCHEDULED INTERVIEW
C     MDATE  = DATE OF SCHEDULED INTERVIEW
C     MRECRT = SCHEDULE NUMBER IF INTERVIEW SCHEDULED
C            = 0, NO INTERVIEW SCHEDULED
C            = IF KLOCK NONZERO, BUT MRECRT ZERO, THEN THE STUDENT
C              SHOULD GET AN INTERVIEW IF A HUMAN CAN RESOLVE SOME
C              SCHEDULING CONFLICT WHICH TIME ASSIGNMENT PROGRAM
C              COULD NOT RESOLVE
C
      DIMENSION NUMVOT(100),KNDVOT(100),IRANK(100),IPREFR(13,100),
     1KNTPRF(100),KLOCK(100),KLOSED(100),JRANK(100),MTIME(100),
     2MDATE(100),MRECRT(100),IDATE(100),ISOURC(100)
C
C     *******************************************
C     *                                         *
C     *  ARRAYS INDEPENDENT OF NUMBER OF FIRMS  *
C     *                                         *
C     *******************************************
C
C     MENU CONTAINING TERMINAL TYPES
      DIMENSION LTRYNT(19),LNGYNT(5)
C
C     ARRAYS WHICH STORE THE BASIC COMMANDS
C     LTRCMD = THE NAMES OF THE COMMANDS
C     LNGCMD = THE NUMBERS OF CHARACTERS IN EACH COMMAND
C     KNDARG = 0 IF NO ARGUMENT, 1 IF FIRM NUMBER REQUIRED
C     IALIAS = KOMMAND IDENTIFICATION IF SYNONYMS
C     LTRPSW = PASSWORD REQUIRED FOR GROUP ACCOUNTS
C     LTRCHK = ARRAY USED TO HOLD PASSWORD READ FROM OLD
C              DECISION FILE OR LOWER CASE FORM OF PASSWORD
C     LTRWEK = NAMES OF THE DAYS OF THE WEEK
C
      DIMENSION LTRCMD(78),LNGCMD(15),KNDARG(15),IALIAS(15),
     1LTRPSW(20),LTRCHK(20),LTRWEK(21)
C
C     IDENTIFICATION OF THIS USER
C     LTRWHO = THE NAME OF THE ACCOUNT
C     LWRWHO = USED TO STORE LOWER CASE VERSION OF NAME
C     LTRNAM = THE PERSON'S NAME
      DIMENSION LTRWHO(40),LWRWHO(40),LTRNAM(30)
C
C     LTRBFR = INPUT/OUTPUT BUFFER
      DIMENSION LTRBFR(80)
C
C     ARRAYS CONTAINING 1 NUMBER FOR EACH TIME PROFILE
      DIMENSION KNTSLT(50),NUMSLT(50),LNGSLT(50)
C
C     ARRAY CONTAINING 1 NUMBER FOR EACH TIME IN ALL PROFILES
      DIMENSION INI060(500)
C
C     ARRAY CONTAINING LETTERS OF CURRENT DATE AND TIME
      DIMENSION LTRTIM(15)
C
C     LTRYNT = MENU CONTAINING YES, NO AND TERMINAL TYPES
      DATA LTRYNT/
     11HY,1HE,1HS,
     21HN,1HO,
     31HS,1HL,1HO,1HW,
     41HF,1HA,1HS,1HT,
     51HP,1HA,1HG,1HI,1HN,1HG/
      DATA LNGYNT/3,2,4,4,6/
      DATA LMTYNT,KNTYNT/19,5/
C
C     COMMANDS WHICH CAN BE TYPED BY USER IN RESPONSE TO WHAT NEXT
      DATA LTRCMD/
     11HL,1HI,1HS,1HT,           1HS,1HI,1HG,1HN,1HU,1HP,
     21HC,1HA,1HN,1HC,1HE,1HL,   1HP,1HR,1HI,1HO,1HR,1HI,1HT,1HY,
     31HS,1HA,1HV,1HE,           1HE,1HX,1HI,1HT,
     41HS,1HU,1HB,1HM,1HI,1HT,   1HR,1HE,1HP,1HO,1HR,1HT,
     51HT,1HI,1HM,1HE,           1HR,1HE,1HQ,1HU,1HE,1HS,1HT,
     61HN,1HA,1HM,1HE,           1HS,1HL,1HO,1HW,
     71HF,1HA,1HS,1HT,           1HP,1HA,1HG,1HI,1HN,1HG,
     81HP,1HA,1HP,1HE,1HR/
      DATA LNGCMD/4,6,6,8,4,4,6,6,4,7,4,4,4,6,5/
      DATA KNDARG/0,1,1,1,0,0,0,0,1,1,0,0,0,0,0/
      DATA IALIAS/1,2,3,4,5,6,7,8,9,2,10,11,12,13,14/
      DATA KNTSPL,KNTCMD/78,15/
C
C     NAMES OF DAYS OF WEEK
      DATA LTRWEK/
     1 1HS,1Hu,1Hn,
     2 1HM,1Ho,1Hn,
     3 1HT,1Hu,1He,
     4 1HW,1He,1Hd,
     5 1HT,1Hh,1Hu,
     6 1HF,1Hr,1Hi,
     7 1HS,1Ha,1Ht/
C
C     ODD LETTERS
      DATA LTRSPA,LTRCOM,LTRQUE/1H ,1H,,1H?/
C
C     UNIT NUMBERS FOR TERMINAL AND FILES
      DATA ITTY,IDISK/5,1/
C
C     NUMBER OF LINES ON SINGLE CRT SCREEN MINUS THE BOTTOM
C     TWO WHICH ARE USED FOR COMMUNICATIONS
      DATA LNGCRT/22/
C
C     DIMENSIONS OF ARRAYS CONTAINING CHARACTER INFORMATION
      DATA LMTINC,LMTDPT,LMTADR,LMTBFR,LMTNAM,LMTWHO,LMTPSW/
     1 40,30,30,80,30,40,20/
C
C     DIMENSIONS OF ARRAYS LIMITING SIZE OF CASE HANDLED
C     LMTSIN = MAXIMUM NUMBER OF SIGNUPS FOR SINGLE ROUND
C     LMTPRF = MAXIMUM NUMBER OF TIME PREFERENCES FOR EACH REQUEST
C     LMTSCH = MAXIMUM NUMBER OF PEOPLE ANY ONE RECRUITER CAN
C              TALK TO IN 1 DAY.  MAXIMUM NUMBER OF TIMES IN 1
C              SCHEDULE.
C     LMTSLT = MAXIMUM NUMBER OF DIFFERENT PROFILES OF INTERVIEW
C              SCHEDULES.
C     LMTTIM = MAXIMUM NUMBER OF DIFFERENT TIMES FOR ALL DIFFERENT
C              PROFILES OF INTERVIEW SCHEDULES.
C     LMTRCT = MAXIMUM NUMBER OF RECRUITERS ACROSS ALL FIRMS
C     LMTFRM = MAXIMUM NUMBER OF FIRMS
      DATA LMTSIN,LMTPRF,LMTSCH,LMTSLT,LMTTIM,LMTRCT,LMTFRM/
     1 100,13,16,50,500,1000,200/
C
C     NUMBER OF CHARACTERS LEFT OF REQUESTED TIMES IN REPORTS
      DATA LEDTIM/17/
C
C     MULTIPLICATION FACTOR FOR PRIORITY 1 THRU N VALUES
      DATA INTRVL/10/
C
C     INFORM USER OF WHAT PROGRAM THIS IS
      WRITE(ITTY,1)
    1 FORMAT(' JOBS'/' Job Interview Sign Up Program'/1X)
C
C     TEST IF COMMON BLOCK IS LOADED
      IF(LOADED.NE.1234)GO TO 609
C
C     INDICATE THAT VIDEO TERMINAL IS BEING USED
      JVIDEO=1
      IVIDEO=0
C
C     TURN OFF STOPPING EVERY 24 LINES OF SCREEN DISPLAY
      CALL TTYSET
C
C     IDENTIFY CURRENT USER
      CALL RSMWHO(LTRWHO,IPRJCT,IPRGRM,NUMWHO)
C
C     DETERMINE CLASS NUMBER OF STUDENT
C
C     ICHECK = 0, DO NOT ASK FOR PASSWORD
C            = 1, USER SELECTED PASSWORD
C            = 2, ASSIGNED NUMBER AND PASSWORD
C     IPRINT = 0, DO NOT LET USER ON IF STUDENT PROGRAM CLOSED
C            = 1, LET USER ON EVEN IF STUDENT PROGRAM CLOSED
C     JVIDEO = 0, HARDCOPY TERMINAL
C            = 1, VIDEO W/O SCREEN CLEAR
C            = 2, VIDEO WITH SCREEN CLEAR
C     KURENT = 0, COMPLETELY CLOSED
C              1, ALLOW REPORT ONLY
C              2, OPEN
C
      CALL RSMCHK(LTRWHO,LWRWHO,LMTWHO,IPRJCT,IPRGRM, IDISK,
     1 KLASS,ICHECK,IPRINT,JVIDEO,LTRBFR,LMTBFR,ITTY,NUMWHO)
C
C     CONVERT JVIDEO VALUES 0, 1, 2 TO -1, 0, 1
      JVIDEO=JVIDEO-1
      IF(JVIDEO.LT.0)JVIDEO=-1
      IF(JVIDEO.GT.0)JVIDEO=1
C
C     CHECK IF ACCOUNT IS AUTHORIZED TO RUN THIS PROGRAM
      IF(KLASS.LT.0)GO TO 612
      IF(KLASS.GE.1000)GO TO 612
C
C     ***************************************
C     *                                     *
C     *  DETERMINE CURRENT ROUND AND STAGE  *
C     *                                     *
C     ***************************************
C
      CALL JOBNOW(NUMWHO,KLASS,ITTY,IDISK,LTRBFR,LMTBFR,
     1 IERROR,JMOVE,JPASS,MANNER,KANRUN)
      IF(IERROR.LT.0)GO TO 620
      IF(IERROR.GT.0)GO TO 614
C
C     CHECK IF JOBS PROGRAM IS ALLOWED TO BE RUN
      IF(KANRUN.LE.0)GO TO 616
C
C     INITIAL INSTRUCTIONS
      CALL JOBHLP(ITTY,9,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
C
C     ************************************
C     *                                  *
C     *  GET PROFILES OF STARTING TIMES  *
C     *                                  *
C     ************************************
C
      CALL RSMOPN(9,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 622
      CALL JOBPRO(NUMWHO,KLASS,ITTY,IDISK,
     1 LMTSCH,KNTSLT,LNGSLT,NUMSLT,LMTSLT,MAXSLT,
     2 INI060,LMTTIM,MAXTIM,LTRBFR,LMTBFR)
      CALL RSMCLS(9,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(MAXSLT.LE.0)GO TO 624
C
C     **************************************
C     *                                    *
C     *  READ THE ADMINISTRATOR FIRM FILE  *
C     *                                    *
C     **************************************
C
      KNTRCT=0
      CALL RSMOPN(4,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 632
      READ(IDISK,2)IAUTHR,ICLASS,IMOVE,IPASS
    2 FORMAT(5I)
      READ(IDISK,3)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
    3 FORMAT(8I)
      IF(KNTINC.LE.0)GO TO 632
      IF(KNTINC.GT.LMTFRM)GO TO 636
      DO 8 NOWINC=1,KNTINC
      READ(IDISK,4)
     1(LTRINC(I,NOWINC),I=1,LMTINC),
     2(LTRDPT(I,NOWINC),I=1,LMTDPT),
     3(LTRADR(I,NOWINC),I=1,LMTADR),
     4NUMBER(NOWINC),
     5LENGTH(NOWINC),KNTOPN(NOWINC),INTRVW(NOWINC),
     6IUSDUP(NOWINC),INCLSD(NOWINC),JNCLSD(NOWINC)
    4 FORMAT(40A1/30A1/30A1/7I)
      LIMIT=INTRVW(NOWINC)
      KFIRST(NOWINC)=KNTRCT+1
      IF(LIMIT.LE.0)GO TO 7
      IF((KNTRCT+LIMIT).GT.LMTRCT)GO TO 634
      DO 6 IPERSN=1,LIMIT
      KNTRCT=KNTRCT+1
      READ(IDISK,5)JDATE(KNTRCT),JFIRST(KNTRCT),
     1 JFINAL(KNTRCT),JSCHDL(KNTRCT)
    5 FORMAT(4I)
    6 CONTINUE
    7 CONTINUE
    8 CONTINUE
      CALL RSMCLS(4,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
C
C     CONVERT TIMES OF INTERVIEWS TO SUBSCRIPTS
      IF(KNTINC.EQ.0)GO TO 17
      DO 16 NOWINC=1,KNTINC
      LIMIT=INTRVW(NOWINC)
      IF(LIMIT.EQ.0)GO TO 16
      IPERSN=KFIRST(NOWINC)
      DO 15 JPERSN=1,LIMIT
      IF(JFIRST(IPERSN).LT.0)GO TO 14
      I=0
      J3045=0
    9 IF(I.GE.MAXSLT)GO TO 638
      I=I+1
      I3045=J3045+1
      J3045=J3045+KNTSLT(I)
      IF(LNGSLT(I).NE.LENGTH(NOWINC))GO TO 9
      IF(NUMSLT(I).NE.JSCHDL(IPERSN))GO TO 9
   10 IF(I3045.GT.J3045)GO TO 640
      IF(INI060(I3045).EQ.JFIRST(IPERSN))GO TO 11
      I3045=I3045+1
      GO TO 10
   11 JFIRST(IPERSN)=I3045
   12 IF(I3045.GT.J3045)GO TO 640
      IF(INI060(I3045).EQ.JFINAL(IPERSN))GO TO 13
      I3045=I3045+1
      GO TO 12
   13 JFINAL(IPERSN)=I3045
   14 IPERSN=IPERSN+1
   15 CONTINUE
   16 CONTINUE
   17 CONTINUE
C
C     MAKE SURE THE FIRM FILE IS UP TO DATE
      IF(IAUTHR.LT.1)GO TO 626
      IF(IAUTHR.GT.2)GO TO 626
      IF(KLASS.NE.ICLASS)GO TO 628
      IF(IMOVE.NE.JMOVE)GO TO 630
C
C     ******************************
C     *                            *
C     *  ASK STUDENT FOR PASSWORD  *
C     *                            *
C     ******************************
C
C     IF RUNNING FROM AN ACCOUNT WHICH CAN BE USED BY SEVERAL,
C     OBTAIN THE PASSWORD AND MAP THIS TO A PROBABLY
C     UNIQUE NUMBER
      IF(ICHECK.EQ.0)GO TO 22
   18 IF(ICHECK.EQ.2)GO TO 21
      CALL PASWRD(LTRPSW,LMTPSW,ITTY,LNGPSW,NUMWHO,
     1LTRBFR,LMTBFR)
      IF(NUMWHO.GE.0)GO TO 24
      CALL JOBHLP(ITTY,29,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 18
C     FILE CONTAINS DIFFERENT USER SELECTED PASSWORD
   19 CALL JOBHLP(ITTY,14,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 18
C     USE OF PASSWORD IS BLOCKED (PROBABLY LOGIN PASSWORD)
   20 CALL JOBHLP(ITTY,37,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 18
   21 IVIDEO=0
      CALL PASLST(IVIDEO,JVIDEO,KLASS,IDISK,ITTY,
     1LMTPSW,LTRPSW,LTRCHK,LNGPSW,NUMWHO,LTRBFR,LMTBFR)
      IF(LNGPSW.EQ.0)GO TO 646
      GO TO 24
C
C     FILL PASSWORD WITH SPACES IF NOT ASKING FOR PASSWORD
   22 DO 23 I=1,LMTPSW
      LTRPSW(I)=LTRSPA
   23 CONTINUE
   24 CONTINUE
C
C     ***********************************
C     *                                 *
C     *  READ THE STUDENT REQUEST FILE  *
C     *                                 *
C     ***********************************
C
C     OPEN THE INDIVIDUAL DECISION FILE FOR READING
      CALL RSMOPN(3,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 35
C
C     READ THE STUDENTS DECISION FILE
      READ(IDISK,25)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMPSW,
     1(LTRBFR(I),I=1,LMTPSW)
      READ(IDISK,26)ISUBMT,IUSED,KNTSIN,LOCKUP,IDUMMY,
     1 KNTALL,IGVBAK
   25 FORMAT(6I,20A1)
   26 FORMAT(7I)
      READ(IDISK,27)LTRNOW
      READ(IDISK,27)LTRNAM
   27 FORMAT(60A1)
      IF(KNTSIN.LE.0)GO TO 31
      DO 30 KOMPNY=1,KNTSIN
C     NUMVOT = COMPANY NUMBER
C     KNDVOT = PRIORITY ASSIGNED BY STUDENT
C     KNTPRF = NUMBER OF DESIRED TIMES
C     IDATE  = DESIRED DATE
C     KLOSED = IF ON CLOSED SCHEDULE
C     IRANK  = OVERALL RANKING
C     JRANK  = NUMBER ON CLOSED SCEDULE ABOVE
C     KLOCK  = LENGTH OF INTERVIEW
C     MTIME  = TIME INTERVIEW SCHEDULED
C     MDATE  = DATE INTERVIEW SCHEDULED
C     MRECRT = RECRUITER NUMBER
C     ISOURC = WHETHER REQUESTED BY STUDENT OR FIRM OR BOTH
      READ(IDISK,28)NUMVOT(KOMPNY),KNDVOT(KOMPNY),KNTPRF(KOMPNY),
     1IDATE(KOMPNY),KLOSED(KOMPNY),IRANK(KOMPNY),JRANK(KOMPNY),
     2KLOCK(KOMPNY),MTIME(KOMPNY),MDATE(KOMPNY),MRECRT(KOMPNY),
     3ISOURC(KOMPNY)
   28 FORMAT(12I)
      LIMIT=KNTPRF(KOMPNY)
      IF(LIMIT.GT.0)READ(IDISK,29)(IPREFR(I,KOMPNY),I=1,LIMIT)
   29 FORMAT(13I)
   30 CONTINUE
   31 CALL RSMCLS(3,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
C
C     VERIFY THAT CORRECT FILE WAS READ
      IF(ICHECK.EQ.0)GO TO 33
      DO 32 I=1,LMTPSW
      IF(LTRPSW(I).EQ.LTRBFR(I))GO TO 32
      IF(ICHECK.EQ.2)GO TO 611
      GO TO 19
   32 CONTINUE
   33 IF(IAUTHR.LT.11)GO TO 642
      IF(IAUTHR.GT.15)GO TO 642
      IF(KLASS.NE.ICLASS)GO TO 644
      IF(ISUBMT.LT.3)GO TO 34
C
C     USE OF PASSWORD IS BLOCKED
      IF(ICHECK.NE.1)GO TO 618
      GO TO 20
C
C     ATTEMPT TO DETECT REQUESTS MADE PREVIOUS YEAR
C     IMOVE  = LAST MOVE FOR WHICH STUDENT MADE REQUESTS
C     JMOVE  = MOVE IN ADMINISTRATOR FILE
   34 IF(IMOVE.GT.JMOVE)GO TO 40
      IF(IMOVE.LT.JMOVE)GO TO 41
      IF(IPASS.GT.JPASS)GO TO 40
      GO TO 41
C
C     NO PREVIOUS FILE, ASK IF PASSWORD TYPED WAS ONE MEANT
   35 IF(ICHECK.NE.1)GO TO 40
      WRITE(ITTY,36)
   36 FORMAT(
     1' No requests for interviews have been made using this password.')
   37 WRITE(ITTY,38)
   38 FORMAT(' Do you want to start a new set of requests? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(37,37,40,18,39),KNDYES
   39 CALL JOBHLP(ITTY,15,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 37
C
C     INDICATE THAT THIS IS FIRST MOVE
   40 IMOVE=-1
      IUSED=0
      KNTALL=0
      KNTSIN=0
      LOCKUP=0
      IVERSN=0
      IGVBAK=0
   41 CONTINUE
C
C     CHECK IF USER IS ONLY ALLOWED TO GET REPORT
      IF(KANRUN.EQ.1)GO TO 574
C
C     **********************
C     *                    *
C     *  GET STUDENT NAME  *
C     *                    *
C     **********************
C
C     CHECK IF DECISIONS HAVE BEEN SUBMITTED
      KOMAND=0
      IF(IMOVE.LT.0)GO TO 43
      IF(IMOVE.NE.JMOVE)GO TO 42
      IF(IPASS.NE.JPASS)GO TO 42
      IF(ISUBMT.EQ.1)GO TO 570
      IF(ISUBMT.EQ.2)GO TO 572
   42 GO TO 59
C
C     IF FIRST TIME STUDENT HAS RUN PROGRAM, GET NAME
   43 WRITE(ITTY,44)
   44 FORMAT(' What is your name? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 46
      IF(MAXBFR.GT.0)GO TO 47
      IF(IMOVE.GE.0)GO TO 59
      WRITE(ITTY,45)
   45 FORMAT(' You must type your name')
      GO TO 43
   46 CALL JOBHLP(ITTY,1,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 43
   47 DO 48 I=1,LMTNAM
      LTRNAM(I)=LTRSPA
      IF(I.LE.MAXBFR)LTRNAM(I)=LTRBFR(I)
   48 CONTINUE
C
C     CHECK IF NAME IS GIVEN IN MIXED CASES
      KNTUPR=0
      KNTLWR=0
      DO 51 I=1,LMTNAM
      LTRNOW=LTRNAM(I)
      IF(LTRNOW.EQ.LTRSPA)GO TO 51
      DO 50 J=1,26
      IF(LTRNOW.NE.LTRABC(J))GO TO 49
      KNTUPR=KNTUPR+1
      GO TO 51
   49 IF(LTRNOW.NE.LWRABC(J))GO TO 50
      KNTLWR=KNTLWR+1
      GO TO 51
   50 CONTINUE
   51 CONTINUE
C
C     IF NAME IS ENTIRELY LOWER CASE, CONVERT TO
C     UPPER SO THAT NEXT TEXT CAN GIVE MIXED CASES
      IF(KNTUPR.GT.0)GO TO 54
      DO 53 KOLUMN=1,LMTNAM
      LTRNOW=LTRNAM(KOLUMN)
      DO 52 LETTER=1,26
      IF(LTRNOW.NE.LWRABC(LETTER))GO TO 52
      LTRNAM(KOLUMN)=LTRABC(LETTER)
      GO TO 53
   52 CONTINUE
   53 CONTINUE
      KNTUPR=KNTLWR
      KNTLWR=0
C
C     IF NAME IS PRIMARILY GIVEN IN UPPER CASE, THEN
C     CONVERT ALL UPPER CASE WORDS TO MIXED CASES
   54 IF(KNTUPR.LE.KNTLWR)GO TO 59
      IBLANK=0
      DO 58 KOLUMN=1,LMTNAM
      LTRNOW=LTRNAM(KOLUMN)
      IF(LTRNOW.EQ.LTRSPA)GO TO 57
      DO 55 LETTER=1,26
      IF(LTRNOW.EQ.LWRABC(LETTER))GO TO 57
   55 CONTINUE
      IBLANK=IBLANK+1
      DO 56 LETTER=1,26
      IF(LTRNOW.NE.LTRABC(LETTER))GO TO 56
      IF(IBLANK.EQ.1)GO TO 58
      LTRNAM(KOLUMN)=LWRABC(LETTER)
      GO TO 58
   56 CONTINUE
      GO TO 57
   57 IBLANK=0
      GO TO 58
   58 CONTINUE
C
C     ASK IF THIS IS THE DESIRED NAME
   59 WRITE(ITTY,60)
   60 FORMAT(' You have specified your name as follows:')
      LNGNAM=LMTNAM
   61 IF(LTRNAM(LNGNAM).NE.LTRSPA)GO TO 62
      LNGNAM=LNGNAM-1
      IF(LNGNAM.GT.1)GO TO 61
   62 WRITE(ITTY,63)(LTRNAM(I),I=1,LNGNAM)
   63 FORMAT(1X,60A1)
   64 WRITE(ITTY,65)
   65 FORMAT(
     1' Is this how you want your name to be shown to the recruiters? ',
     2$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 66
      IF(MAXBFR.EQ.0)GO TO 67
      LOWBFR=1
      CALL DAVERB(1,LMTYNT,LTRYNT,1,KNTYNT,
     1LNGYNT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(67,67,69,69,67),KIND
   66 CALL JOBHLP(ITTY,12,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      KNDMSG=31+JVIDEO
      CALL JOBHLP(ITTY,KNDMSG,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      CALL JOBHLP(ITTY,33,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 64
   67 WRITE(ITTY,68)
   68 FORMAT(' Type ? for instructions')
      GO TO 64
   69 IF(LOWBFR.GT.MAXBFR)GO TO 70
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 67
   70 IF(MATCH.EQ.1)GO TO 71
      IF(MATCH.EQ.2)GO TO 43
      IF(MATCH.EQ.3)JVIDEO=-1
      IF(MATCH.EQ.4)JVIDEO=0
      IF(MATCH.EQ.5)JVIDEO=1
      IF(JVIDEO.LT.0)WRITE(ITTY,154)
      IF(JVIDEO.EQ.0)WRITE(ITTY,156)
      IF(JVIDEO.GT.0)WRITE(ITTY,158)
      GO TO 64
C
C     INSTRUCTIONS GIVEN ONLY FIRST TIME THIS PROGRAM IS RUN
   71 IF(KOMAND.NE.0)GO TO 78
      IF(IMOVE.GE.0)GO TO 72
      CALL JOBHLP(ITTY,22,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 72
C
C     **************************************************************
C     *                                                            *
C     *  DETERMINE IF THE STUDENT'S OWN FILE WAS FOR CURRENT MOVE  *
C     *                                                            *
C     **************************************************************
C
   72 IF(IMOVE.NE.JMOVE)GO TO 76
      IF(IPASS.NE.JPASS)GO TO 74
      WRITE(ITTY,73)IPASS,IMOVE
   73 FORMAT(
     1' Continuing selection of interviews in stage',1I2,' of round',
     21I3)
      GO TO 78
C
C     NEW PASS OF CURRENT MOVE
   74 ISUBMT=0
      IPASS=JPASS
      IF(MANNER.EQ.13)IUSED=0
      IF(MANNER.EQ.23)IUSED=0
      WRITE(ITTY,75)IPASS,IMOVE
   75 FORMAT(
     1' Beginning selection of interviews in stage',1I2,
     2' in continuation of round',1I3)
      GO TO 78
C
C     NEW MOVE
   76 KNTALL=KNTALL+KNTSIN
      LOCKUP=0
      KNTSIN=0
      ISUBMT=0
      IMOVE=JMOVE
      IPASS=JPASS
      IF(MANNER.EQ.11)IUSED=IUSED-IGVBAK
      IF(MANNER.EQ.12)IUSED=0
      IF(MANNER.EQ.13)IUSED=0
      IF(MANNER.EQ.21)IUSED=IUSED-IGVBAK
      IF(MANNER.EQ.22)IUSED=0
      IF(MANNER.EQ.23)IUSED=0
      IGVBAK=0
      WRITE(ITTY,77)IPASS,IMOVE
   77 FORMAT(
     1' Beginning selection of interviews in stage',1I2,
     2' in new round',1I3)
   78 CONTINUE
C
C     *********************
C     *                   *
C     *  GET NEXT OPTION  *
C     *                   *
C     *********************
C
   79 WRITE(ITTY,80)
   80 FORMAT(' What next? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
   81 IF(MAXBFR.LT.0)GO TO 83
   82 LOWBFR=1
      CALL DAVERB(1,KNTSPL,LTRCMD,1,KNTCMD,
     1LNGCMD,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(89,87,85,85,87),KIND
   83 IVIDEO=JVIDEO
      CALL JOBHLP(ITTY,2,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IVIDEO=0
      IF(MAXBFR.GT.0)GO TO 82
      GO TO 79
C
C     VERIFY THAT NOTHING OTHER THAN NUMBER FOLLOWS COMMAND
   84 LOWBFR=LOWBFR+1
   85 IF(LOWBFR.GT.MAXBFR)GO TO 91
      IF(LTRBFR(LOWBFR).EQ.LTRSPA)GO TO 84
      LTRNOW=LTRBFR(LOWBFR)
      DO 86 I=1,10
      IF(LTRNOW.EQ.LTRDGT(I))GO TO 91
   86 CONTINUE
   87 WRITE(ITTY,88)
   88 FORMAT(' Unknown command')
   89 WRITE(ITTY,90)
   90 FORMAT(' Type ? for help')
      GO TO 79
C
C     BRANCH TO CODE FOR COMMAND
   91 KOMAND=IALIAS(MATCH)
      IF(KNDARG(MATCH).EQ.0)GO TO 152
C
C     ************************
C     *                      *
C     *  GET NUMBER OF FIRM  *
C     *                      *
C     ************************
C
C     CHECK IF USER TYPED ANYTHING TO RIGHT OF COMMAND
      IF(LOWBFR.LE.MAXBFR)GO TO 97
C
C     ASK ADMINISTRATOR WHAT RESUME IS TO BE EDITED
   92 IF(KOMAND.EQ.2)WRITE(ITTY,93)
      IF(KOMAND.EQ.3)WRITE(ITTY,94)
      IF(KOMAND.EQ.4)WRITE(ITTY,95)
      IF(KOMAND.EQ.9)WRITE(ITTY,96)
   93 FORMAT(' Request interview with which firm? ',$)
   94 FORMAT(' Cancel interview with which firm? ',$)
   95 FORMAT(' Change priority of interview with which firm? ',$)
   96 FORMAT(' Change times of interview with which firm? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 102
      IF(MAXBFR.LE.0)GO TO 109
      LOWBFR=1
   97 CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(109,98,101),KIND
   98 IF(LTRBFR(LOWBFR).NE.LTRQUE)GO TO 103
      GO TO 100
   99 IF(LOWBFR.GT.MAXBFR)GO TO 102
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 103
  100 LOWBFR=LOWBFR+1
      GO TO 99
  101 IF(LOWBFR.GT.MAXBFR)GO TO 105
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 103
      LOWBFR=LOWBFR+1
      GO TO 101
  102 IF(KOMAND.EQ.2)CALL JOBHLP(ITTY,3,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IF(KOMAND.EQ.3)CALL JOBHLP(ITTY,10,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IF(KOMAND.EQ.4)CALL JOBHLP(ITTY,11,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      IF(KOMAND.EQ.9)CALL JOBHLP(ITTY,18,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 92
  103 WRITE(ITTY,104)
  104 FORMAT(' Type ? for help')
      GO TO 92
  105 KOMPNY=0
  106 KOMPNY=KOMPNY+1
      IF(KOMPNY.GT.KNTINC)GO TO 107
      IF(NUMBER(KOMPNY).NE.IVALUE)GO TO 106
      GO TO 111
  107 WRITE(ITTY,108)
  108 FORMAT(' This number is not assigned to any firm')
      GO TO 79
  109 WRITE(ITTY,110)
  110 FORMAT(' Command will not be acted upon')
      GO TO 79
C
C     GET LENGTHS OF NAME, DIVISION AND ADDRESS
  111 LNGINC=LMTINC
  112 IF(LTRINC(LNGINC,KOMPNY).NE.LTRSPA)GO TO 113
      LNGINC=LNGINC-1
      IF(LNGINC.GT.0)GO TO 112
  113 LNGDPT=LMTDPT
  114 IF(LTRDPT(LNGDPT,KOMPNY).NE.LTRSPA)GO TO 115
      LNGDPT=LNGDPT-1
      IF(LNGDPT.GT.0)GO TO 114
  115 LNGADR=LMTADR
  116 IF(LTRADR(LNGADR,KOMPNY).NE.LTRSPA)GO TO 117
      LNGADR=LNGADR-1
      IF(LNGADR.GT.0)GO TO 116
  117 CONTINUE
C
C     REPORT FIRM NAME, DIVISION, ADDRESS
      IF(LNGINC.EQ.0)LNGINC=1
      IF(LNGADR.GT.0)GO TO 119
      IF(LNGDPT.GT.0)GO TO 118
      WRITE(ITTY,121)(LTRINC(I,KOMPNY),I=1,LNGINC)
      GO TO 122
  118 WRITE(ITTY,121)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT)
      GO TO 122
  119 IF(LNGDPT.GT.0)GO TO 120
      WRITE(ITTY,121)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
      GO TO 122
  120 WRITE(ITTY,121)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT),
     2LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
  121 FORMAT(1X,80A1)
  122 CONTINUE
C
C     CHECK IF HAVE ALREADY ASKED FOR THIS FIRM
C     CHECK FROM TOP DOWN IN LIST SINCE COULD HAVE REQUESTED
C     INTERVIEW AFTER CANCELLING IT SO COULD APPEAR TWICE WITH
C     THE TOP ENTRY BEING THE LATEST ONE
      LOCATN=KNTSIN
  123 IF(LOCATN.LE.0)GO TO 141
      IF(IVALUE.EQ.NUMVOT(LOCATN))GO TO 124
      LOCATN=LOCATN-1
      GO TO 123
  124 IF(KOMAND.EQ.2)GO TO 125
      IF(KOMAND.EQ.3)GO TO 135
      GO TO 136
C
C     REQUEST OPTION FOR PREVIOUSLY REQUESTED FIRM
  125 IF(KLOSED(LOCATN).NE.0)GO TO 128
      IF(LOCATN.LE.LOCKUP)WRITE(ITTY,126)
      IF(LOCATN.GT.LOCKUP)WRITE(ITTY,127)
  126 FORMAT(' You have already requested an interview w',
     1'ith this firm in an earlier stage')
  127 FORMAT(' You have already requested an interview w',
     1'ith this firm in the current stage')
      GO TO 79
  128 IF(KLOSED(LOCATN).EQ.1)GO TO 129
      IF(KLOSED(LOCATN).EQ.2)GO TO 131
      IF(KLOSED(LOCATN).EQ.3)GO TO 133
  129 WRITE(ITTY,130)
  130 FORMAT(' You already have a closed interview with this firm')
      GO TO 79
  131 WRITE(ITTY,132)
  132 FORMAT(' This firm has already rejected your earlier request')
      GO TO 79
  133 WRITE(ITTY,134)
CYou requested an interview with this firm in an earlier stage, and then
Ccancelled your request.  You are allowed to request it again, however.
  134 FORMAT(' You requested an interview with this firm',
     1' in an earlier stage, and then'/' cancelled your ',
     2'request.  You are allowed to request it again, ho',
     3'wever.')
      GO TO 143
C
C     CANCEL COMMAND ALLOWED FOR CLOSED INTERVIEW
  135 IF(KLOSED(LOCATN).EQ.0)GO TO 146
      IF(KLOSED(LOCATN).EQ.1)GO TO 146
      GO TO 137
C
C     OTHER OPTIONS FOR PREVIOUSLY REQUESTED FIRM
C     CANNOT CHANGE REJECTED OR CANCELLED INTERVIEWS
  136 IF(KLOSED(LOCATN).EQ.0)GO TO 146
  137 IF(KLOSED(LOCATN).EQ.1)WRITE(ITTY,138)
      IF(KLOSED(LOCATN).EQ.2)WRITE(ITTY,139)
      IF(KLOSED(LOCATN).EQ.3)WRITE(ITTY,140)
  138 FORMAT(' You have been invited to a closed intervi',
     1'ew with this firm.'/' Please contact the placemen',
     2't office staff to schedule or change this interview.')
  139 FORMAT(' This firm has rejected your earlier reque',
     1'st for an interview')
  140 FORMAT(' You previously cancelled your request for',
     1' an interview with this firm')
      GO TO 79
C
C     FIRM WHICH HAS NOT BEEN REQUESTED
  141 IF(KOMAND.EQ.2)GO TO 143
      WRITE(ITTY,142)
  142 FORMAT(' You have not requested an interview with this firm')
      GO TO 79
C     NUMBER OPEN SLOTS + NUMBER MOVED TO CLOSED - NUMBER REQUESTING
  143 ISLOTS=KNTOPN(KOMPNY)+INCLSD(KOMPNY)-IUSDUP(KOMPNY)
      IF(ISLOTS.LE.0)JSLOTS=-ISLOTS
      IF(ISLOTS.GE.0)WRITE(ITTY,144)ISLOTS
      IF(ISLOTS.LE.0)WRITE(ITTY,145)JSLOTS
  144 FORMAT(' There are',1I4,
     1' unallocated interview slots available for this firm')
  145 FORMAT(' There are',1I4,
     1' people already on the waiting list for this firm')
C
C     ASK IF THIS IS THE DESIRED FIRM
  146 IF(KOMAND.EQ.2)WRITE(ITTY,147)
      IF(KOMAND.EQ.3)WRITE(ITTY,148)
      IF(KOMAND.EQ.4)WRITE(ITTY,149)
      IF(KOMAND.EQ.9)WRITE(ITTY,150)
  147 FORMAT(
     1' Is this the firm with which you want to request interview? ',$)
  148 FORMAT(
     1' Is this the firm with which you want to cancel interview? ',$)
  149 FORMAT(
     1' Is this the firm with which you want to change priority? ',$)
  150 FORMAT(
     1' Is this the firm with which you want to change times? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(146,146,152,79,151),KNDYES
  151 CALL JOBHLP(ITTY,4,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 146
C
C     BRANCH TO COMMAND NEEDING THE ARGUMENT
C
C     GO TO(LIS,REQ,CAN,PRI,SAV,EXI,SUB,REP,TIM,NAM,
C    1      SLO,FAS,PAG,PAP),KOMAND
C
  152 GO TO(392,159,364,344,595,595,588,434,352, 59,
     1      153,155,157,593),KOMAND
C
C     *****************************
C     *                           *
C     *  CHANGE TYPE OF TERMINAL  *
C     *                           *
C     *****************************
C
C     HARDCOPY TERMINAL ON WHICH FORM FEEDS ARE NOT WANTED
  153 IF(JVIDEO.NE.-1)WRITE(ITTY,154)
  154 FORMAT(' Output will be formatted for a slow terminal')
      JVIDEO=-1
      GO TO 79
C
C     SCROLLING TERMINAL ON WHICH FORM FEEDS ARE NOT WANTED
  155 IF(JVIDEO.NE.0)WRITE(ITTY,156)
  156 FORMAT(' Output will be formatted for fast video ',
     1'terminal which cannot clear screen')
      JVIDEO=0
      GO TO 79
C
C     VIDEO TERMINAL ON WHICH FORM FEEDS CLEAR SCREEN
  157 IF(JVIDEO.NE.1)WRITE(ITTY,158)
  158 FORMAT(' Output will be formatted for video ',
     1'terminal which can clear screen')
      JVIDEO=1
      GO TO 79
C
C     ********************
C     *                  *
C     *  REQUEST OPTION  *
C     *                  *
C     ********************
C
C     CHECK IF STUDENT HAS REQUESTED TOO MANY FIRMS
  159 IF(KNTSIN.GE.LMTSIN)GO TO 166
      IF((KNTALL+KNTSIN).GE.MAXALL)GO TO 167
      IF(KNTSIN.GE.MAXRND)GO TO 168
      IF((KNTSIN-LOCKUP).GE.MAXSTG)GO TO 169
C
C     CONSTRUCT THE NEW REQUEST
      KNTSIN=KNTSIN+1
      LOCATN=LOCKUP
  160 LOCATN=LOCATN+1
      IF(LOCATN.GE.KNTSIN)GO TO 164
      IF(NUMBER(KOMPNY).GE.NUMVOT(LOCATN))GO TO 160
      I=KNTSIN
  161 IF(I.LE.LOCATN)GO TO 164
      NUMVOT(I)=NUMVOT(I-1)
      KNDVOT(I)=KNDVOT(I-1)
      KNTPRF(I)=KNTPRF(I-1)
      IDATE(I)=IDATE(I-1)
      KLOSED(I)=KLOSED(I-1)
      ISOURC(I)=ISOURC(I-1)
      IRANK(I)=IRANK(I-1)
      JRANK(I)=JRANK(I-1)
      KLOCK(I)=KLOCK(I-1)
      MTIME(I)=MTIME(I-1)
      MDATE(I)=MDATE(I-1)
      MRECRT(I)=MRECRT(I-1)
      LIMIT=KNTPRF(I)
      IF(LIMIT.LE.0)GO TO 163
      DO 162 J=1,LIMIT
      IPREFR(J,I)=IPREFR(J,I-1)
  162 CONTINUE
  163 I=I-1
      GO TO 161
  164 NUMVOT(LOCATN)=NUMBER(KOMPNY)
      KNDVOT(LOCATN)=0
      IF(MANNER.GT.20)GO TO 165
      IF(MANNER.GT.10)KNDVOT(LOCATN)=2
  165 CONTINUE
      KNTPRF(LOCATN)=0
      IDATE(LOCATN)=0
      KLOSED(LOCATN)=0
      ISOURC(LOCATN)=0
      IRANK(LOCATN)=0
      JRANK(LOCATN)=0
      KLOCK(LOCATN)=0
      MTIME(LOCATN)=0
      MDATE(LOCATN)=0
      MRECRT(LOCATN)=0
      GO TO 170
C
C     VARIOUS WARNINGS
  166 CALL JOBHLP(ITTY,13,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 79
  167 CALL JOBHLP(ITTY,19,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 79
  168 CALL JOBHLP(ITTY,34,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 79
  169 CALL JOBHLP(ITTY,35,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 79
C
C     PRIORITY TYPE BRANCH
  170 IF(MANNER.GT.20)GO TO 204
      IF(MANNER.GT.10)GO TO 192
C
C     *********************
C     *                   *
C     *  PRIORITY TYPE 1  *
C     *                   *
C     *********************
C
C     EACH STUDENT IS ALLOWED TO ASSIGN A DIFFERENT PRIORITY
C     TO EACH REQUEST.  PRIORITY 1 HAS THE HIGHEST PRIORITY.
C     LARGER VALUES HAVE LOWER PRIORITY.
C
      ISUM=MAXSTG
      IF(ISUM.GT.(MAXRND-LOCKUP))ISUM=MAXRND-LOCKUP
      IF(ISUM.GT.(MAXALL-KNTALL-LOCKUP))ISUM=MAXALL-KNTALL-LOCKUP
  171 WRITE(ITTY,172)ISUM
  172 FORMAT(' You can assign priority numbers from 1 (m',
     1'ost desired) to',1I4,' (least desired)'/
     2' Priority number for this request? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 177
      IF(MAXBFR.LE.0)GO TO 190
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(190,173,176),KIND
  173 IF(LTRBFR(LOWBFR).NE.LTRQUE)GO TO 178
      GO TO 175
  174 IF(LOWBFR.GT.MAXBFR)GO TO 177
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 178
  175 LOWBFR=LOWBFR+1
      GO TO 174
  176 IF(LOWBFR.GT.MAXBFR)GO TO 180
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 178
      LOWBFR=LOWBFR+1
      GO TO 176
  177 CALL JOBHLP(ITTY,21,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 171
  178 WRITE(ITTY,179)
  179 FORMAT(' Type ? for help')
      GO TO 171
  180 IF(IVALUE.LE.0)GO TO 181
      IF(IVALUE.GT.ISUM)GO TO 181
      IVALUE=INTRVL*IVALUE
      KNDVOT(LOCATN)=IVALUE
      GO TO 183
  181 WRITE(ITTY,182)ISUM
  182 FORMAT(' Priority must be in range 1 through',1I4)
      GO TO 171
C
C     CHECK FOR DUPLICATE VALUES
  183 I=LOCKUP
  184 I=I+1
      IF(I.GT.KNTSIN)GO TO 189
      IF(KNDVOT(I).NE.IVALUE)GO TO 184
      IF(I.EQ.LOCATN)GO TO 184
C
C     REPLACE THE DUPLICATE VALUE
      J=0
  185 J=J+INTRVL
      K=LOCKUP
  186 K=K+1
      IF(K.GT.KNTSIN)GO TO 187
      IF(KNDVOT(K).EQ.J)GO TO 185
      GO TO 186
  187 L=KNDVOT(I)/INTRVL
      M=J/INTRVL
      WRITE(ITTY,188)NUMVOT(I),L,M
  188 FORMAT(' Changing priority for firm',1I4,' from',1I4,' to',1I4)
      KNDVOT(I)=J
  189 CONTINUE
      IF(KOMAND.NE.4)GO TO 233
      GO TO 79
  190 IF(KOMAND.NE.4)GO TO 178
      I=KNDVOT(LOCATN)/INTRVL
      WRITE(ITTY,191)I
  191 FORMAT(' Previously assigned priority number',1I4,' retained')
      GO TO 79
C
C     *********************
C     *                   *
C     *  PRIORITY TYPE 2  *
C     *                   *
C     *********************
C
C     EACH STUDENT IS ALLOWED TO INDICATE THAT SOME OF HIS/HER
C     REQUESTS ARE TO BE GIVEN HIGHER PRIORITY THAN REQUESTS
C     MADE BY OTHER STUDENTS WITHOUT THIS PRIORITY.  THE STUDENT
C     CAN ONLY MAKE MAXPAY OF THESE REQUESTS DURING
C     THE ENTIRE INTERVIEW SEASON.
C
  192 I=MAXPAY-IUSED
      IF(KNDVOT(LOCATN).EQ.1)I=I+1
      IF(I.LE.0)GO TO 201
      IF(MANNER.EQ.11)WRITE(ITTY,193)I
      IF(MANNER.EQ.12)WRITE(ITTY,194)I
      IF(MANNER.EQ.13)WRITE(ITTY,195)I
  193 FORMAT(' You can still make',1I4,
     1' high (A) priority requests during the interview season')
  194 FORMAT(' You can still make',1I4,
     1' high (A) priority requests in this round')
  195 FORMAT(' You can still make',1I4,
     1' high (A) priority requests in this stage of this round')
  196 WRITE(ITTY,197)
  197 FORMAT(
     1' Do you want to assign a high (A)',
     2' priority to this request? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(196,196,199,200,198),KNDYES
  198 CALL JOBHLP(ITTY,6,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 196
  199 IF(KNDVOT(LOCATN).EQ.1)IUSED=IUSED-1
      KNDVOT(LOCATN)=1
      IUSED=IUSED+1
      GO TO 203
  200 IF(KNDVOT(LOCATN).EQ.1)IUSED=IUSED-1
      KNDVOT(LOCATN)=2
      GO TO 203
C
C     ONLY LOW PRIORITY REQUESTS AVAILABLE
  201 WRITE(ITTY,202)
  202 FORMAT(
     1' You have used all your high (A) priority requests,',
     2' so this is assumed to be a'/
     3' low (B) priority request')
      KNDVOT(LOCATN)=2
      GO TO 203
C
C     ANSWER SUPPLIED
  203 IF(KOMAND.NE.4)GO TO 233
      GO TO 79
C
C     *********************
C     *                   *
C     *  PRIORITY TYPE 3  *
C     *                   *
C     *********************
C
  204 IF(MAXPAY.LE.0)GO TO 228
C
C     GET LIMITS OF CURRENT BID
      ISUM=MAXPAY-IUSED
      JSUM=ISUM
      I=LOCKUP
  205 I=I+1
      IF(I.GT.KNTSIN)GO TO 206
      ISUM=ISUM+KNDVOT(I)
      GO TO 205
  206 CONTINUE
      IF(ISUM.LE.0)GO TO 228
      JSUM=JSUM+KNDVOT(LOCATN)
      IF(JSUM.GT.MAXBID)JSUM=MAXBID
      KSUM=ISUM
      IF(KSUM.GT.MAXBID)KSUM=MAXBID
C
C     DESCRIBE CURRENT LIMITS
  207 IF(JSUM.LT.KSUM)WRITE(ITTY,208)JSUM
  208 FORMAT(' The maximum bid which you can make',
     1' without changing any other bid is',1I8)
      WRITE(ITTY,209)KSUM
  209 FORMAT(' The maximum bid which you are allowed to make is',1I8)
      IF(JSUM.LT.KSUM)WRITE(ITTY,210)JSUM,KSUM
  210 FORMAT(' If you bid between',1I8,' and',1I8,
     1' then your other bids will be reduced')
      IF(MANNER.EQ.21)WRITE(ITTY,211)ISUM
      IF(MANNER.EQ.22)WRITE(ITTY,212)ISUM
      IF(MANNER.EQ.23)WRITE(ITTY,213)ISUM
  211 FORMAT(' Total of current bids and all made',
     1' later in the season cannot exceed',1I8)
  212 FORMAT(' Total of current bids and all made',
     1' later in this round cannot exceed',1I8)
  213 FORMAT(' Total of current bids and all made',
     1' later in this stage cannot exceed',1I8)
C
C     GET THE NEW BID
      WRITE(ITTY,214)
  214 FORMAT(' Bid to be made for this request? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 219
      IF(MAXBFR.LE.0)GO TO 231
      LOWBFR=1
      CALL DAHEFT(0,0,0,LTRBFR,LMTBFR,
     1LOWBFR,KIND,ISHIFT,JSHIFT,KSHIFT,LSHIFT,IVALUE,
     2VALUE)
      GO TO(231,215,218),KIND
  215 IF(LTRBFR(LOWBFR).NE.LTRQUE)GO TO 220
      GO TO 217
  216 IF(LOWBFR.GT.MAXBFR)GO TO 219
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 220
  217 LOWBFR=LOWBFR+1
      GO TO 216
  218 IF(LOWBFR.GT.MAXBFR)GO TO 222
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 220
      LOWBFR=LOWBFR+1
      GO TO 218
  219 CALL JOBHLP(ITTY,24,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 207
  220 WRITE(ITTY,221)
  221 FORMAT(' Type ? for help')
      GO TO 207
  222 IF(IVALUE.LT.0)GO TO 226
      IF(IVALUE.GT.KSUM)GO TO 226
      IUSED=IUSED-KNDVOT(LOCATN)
      KNDVOT(LOCATN)=IVALUE
      IUSED=IUSED+IVALUE
      GO TO 223
C
C     REDUCE OTHER BIDS IF TOTAL IS TOO LARGE
  223 IF(IUSED.LE.MAXPAY)GO TO 230
      MINMUM=MAXPAY
      DO 224 I=1,KNTSIN
      IF(I.EQ.LOCATN)GO TO 224
      IF(KNDVOT(I).EQ.0)GO TO 224
      IF(MINMUM.LT.KNDVOT(I))GO TO 224
      MINMUM=KNDVOT(I)
      MINLOC=I
  224 CONTINUE
      IUSED=IUSED-MINMUM
      MINMUM=MAXPAY-IUSED
      IF(MINMUM.LT.0)MINMUM=0
      WRITE(ITTY,225)NUMVOT(MINLOC),KNDVOT(MINLOC),MINMUM
  225 FORMAT(' Reducing bid for firm',1I4,' from',1I8,' to',1I8)
      KNDVOT(MINLOC)=MINMUM
      IUSED=IUSED+MINMUM
      GO TO 223
C
C     MESSAGES
  226 WRITE(ITTY,227)KSUM
  227 FORMAT(' Bid must be in range 0 through',1I8)
      GO TO 207
  228 KNDVOT(LOCATN)=0
      WRITE(ITTY,229)
  229 FORMAT(' You used your entire bidding',
     1' allocation earlier so this bid is assumed to be zero.')
      GO TO 230
C
C     DONE WITH BIDDING
  230 CONTINUE
      IF(KOMAND.NE.4)GO TO 233
      GO TO 79
  231 IF(KOMAND.NE.4)GO TO 220
      WRITE(ITTY,232)KNDVOT(LOCATN)
  232 FORMAT(' Previously assigned bid',1I8,' retained')
      GO TO 79
C
C     ********************
C     *                  *
C     *  PREFERRED DATE  *
C     *                  *
C     ********************
C
C     DETERMINE WHETHER FIRM INTERVIEWS ON MORE THAN 1 DATE
  233 IF(KNTOPN(KOMPNY).EQ.0)GO TO 341
      LIMIT=INTRVW(KOMPNY)
      ISMITH=0
      JSMITH=0
      IPERSN=KFIRST(KOMPNY)
      DO 236 JPERSN=1,LIMIT
      IF(JDATE(IPERSN).LT.0)GO TO 235
      IF(JFIRST(IPERSN).LT.0)GO TO 235
      IF(ISMITH.NE.0)GO TO 234
      ISMITH=JDATE(IPERSN)
      JSMITH=ISMITH
      GO TO 235
  234 IF(ISMITH.GT.JDATE(IPERSN))ISMITH=JDATE(IPERSN)
      IF(JSMITH.LT.JDATE(IPERSN))JSMITH=JDATE(IPERSN)
  235 IPERSN=IPERSN+1
  236 CONTINUE
      IF(ISMITH.EQ.JSMITH)GO TO 273
C
C     FIND NEXT DATE FIRM IS INTERVIEWING
  237 WRITE(ITTY,238)
  238 FORMAT(' This firm will interview at the following',
     1' dates and times:'/1X)
      ISMITH=0
  239 JSMITH=ISMITH
      IPERSN=KFIRST(KOMPNY)
      LIMIT=INTRVW(KOMPNY)
      DO 242 JPERSN=1,LIMIT
      IF(JDATE(IPERSN).LT.0)GO TO 241
      IF(JFIRST(IPERSN).LT.0)GO TO 241
      IF(JSMITH.GE.JDATE(IPERSN))GO TO 241
      IF(ISMITH.EQ.JSMITH)GO TO 240
      IF(ISMITH.LE.JDATE(IPERSN))GO TO 241
  240 ISMITH=JDATE(IPERSN)
  241 IPERSN=IPERSN+1
  242 CONTINUE
      IF(ISMITH.EQ.JSMITH)GO TO 257
C
C     GENERATE LIST OF TIMES ON THE NEXT DATE
      LOWBFR=0
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWEEK(-1,ISMITH,JDAY,JMONTH,JYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      DO 243 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  243 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(ISMITH,JDAY,JMONTH,JYEAR,LTRBFR,LOWBFR,LMTBFR)
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
C     ITIME  = NEXT TIME TO BE SHOWN
C     JTIME  = TIME LAST SHOWN
      ITIME=-1
      JTIME=-1
      LIMIT=KFIRST(KOMPNY)+INTRVW(KOMPNY)-1
  244 IPERSN=KFIRST(KOMPNY)
  245 IF(JFIRST(IPERSN).LT.0)GO TO 249
      IF(ISMITH.NE.JDATE(IPERSN))GO TO 249
  246 LPERSN=JFIRST(IPERSN)
      MPERSN=JFINAL(IPERSN)
      DO 248 KPERSN=LPERSN,MPERSN
      IF(JTIME.GE.INI060(KPERSN))GO TO 248
      IF(ITIME.EQ.JTIME)GO TO 247
      IF(ITIME.LE.INI060(KPERSN))GO TO 249
  247 ITIME=INI060(KPERSN)
      GO TO 249
  248 CONTINUE
      IF(IPERSN.GE.LIMIT)GO TO 250
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 246
      GO TO 245
  249 IF(IPERSN.GE.LIMIT)GO TO 250
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 249
      GO TO 245
  250 IF(ITIME.EQ.JTIME)GO TO 255
      JTIME=ITIME
      ITIME=40*(ITIME/60) + ITIME
      IF(LOWBFR.EQ.0)GO TO 251
      IF(LOWBFR.GE.LMTBFR)GO TO 252
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
  251 CALL DAHOUR(ITIME,0,0,1,LTRBFR,LMTBFR,
     1LOWBFR,IERROR)
      IF(IERROR.NE.1)GO TO 254
  252 WRITE(ITTY,253)(LTRBFR(I),I=1,LOWBFR)
  253 FORMAT(1X,80A1)
      LOWBFR=0
      GO TO 251
  254 ITIME=JTIME
      GO TO 244
  255 IF(LOWBFR.GT.0)WRITE(ITTY,253)(LTRBFR(I),I=1,LOWBFR)
      WRITE(ITTY,256)
  256 FORMAT(1X)
      GO TO 239
  257 CONTINUE
C
C     ASK USER WHAT IS PREFERRED DATE
  258 WRITE(ITTY,259)
  259 FORMAT(' Desired date of interview? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 269
      IF(MAXBFR.EQ.0)GO TO 270
      LOWBFR=1
      CALL DADATE(1,LTRBFR,LMTBFR,LOWBFR,KIND  ,
     1   JDAY  ,JMONTH,JYEAR ,LCNBFR)
  260 IF(LOWBFR.GT.MAXBFR)GO TO 261
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 267
      LOWBFR=LOWBFR+1
      GO TO 260
  261 IF(KIND.LT.11)GO TO 265
      IF(KIND.GT.17)GO TO 265
      IF(JYEAR.LE.80)JYEAR=JYEAR+2000
      IF(JYEAR.LT.100)JYEAR=JYEAR+1900
      CALL DAWEEK(0,ISMITH,JDAY,JMONTH,JYEAR,IWEEK)
C
C     CHECK IF FIRM IS INTERVIEWING ON THIS DATE
      LIMIT=INTRVW(KOMPNY)
      IPERSN=KFIRST(KOMPNY)
      DO 263 JPERSN=1,LIMIT
      IF(JDATE(IPERSN).LT.0)GO TO 262
      IF(JFIRST(IPERSN).LT.0)GO TO 262
      IF(ISMITH.EQ.JDATE(IPERSN))GO TO 272
  262 IPERSN=IPERSN+1
  263 CONTINUE
      WRITE(ITTY,264)
  264 FORMAT(
     1' The firm is not interviewing on the date you specified')
      GO TO 237
C
C     VARIOUS DATE ERROR MESSAGES
  265 WRITE(ITTY,266)
  266 FORMAT(' Date must consist of day, month and year in any',
     1' conventional notation')
      GO TO 258
  267 WRITE(ITTY,268)
  268 FORMAT(' Type ? for help')
      GO TO 258
  269 CALL JOBHLP(ITTY,23,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 237
  270 WRITE(ITTY,271)
  271 FORMAT(' All dates will be given equal preference')
      LSMITH=0
      GO TO 274
  272 IDATE(LOCATN)=ISMITH
  273 LSMITH=ISMITH
  274 CONTINUE
C
C     *********************
C     *                   *
C     *  PREFERRED TIMES  *
C     *                   *
C     *********************
C
C     TELL USER WHEN INTERVIEWS WILL BE HELD
      CALL JOBHLP(ITTY,20,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  275 CONTINUE
      WRITE(ITTY,276)LENGTH(KOMPNY)
  276 FORMAT(
     1' Interviews are',1I3,
     2' minutes long and will be held at the',
     3' following times:'/1X)
      LOWBFR=0
      IF(LSMITH.EQ.0)GO TO 278
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWEEK(-1,LSMITH,JDAY,JMONTH,JYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      DO 277 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  277 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(LSMITH,JDAY,JMONTH,JYEAR,LTRBFR,LOWBFR,LMTBFR)
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
C     KNTDIF = NUMBER OF DIFFERENT STARTING TIMES
C     ITIME  = NEXT TIME TO BE SHOWN
C     JTIME  = TIME LAST SHOWN
  278 KNTDIF=0
      ITIME=-1
      JTIME=-1
      LIMIT=KFIRST(KOMPNY)+INTRVW(KOMPNY)-1
  279 IPERSN=KFIRST(KOMPNY)
  280 IF(JFIRST(IPERSN).LT.0)GO TO 284
      IF(IDATE(LOCATN).EQ.0)GO TO 281
      IF(IDATE(LOCATN).NE.JDATE(IPERSN))GO TO 284
  281 LPERSN=JFIRST(IPERSN)
      MPERSN=JFINAL(IPERSN)
      DO 283 KPERSN=LPERSN,MPERSN
      IF(JTIME.GE.INI060(KPERSN))GO TO 283
      IF(ITIME.EQ.JTIME)GO TO 282
      IF(ITIME.LE.INI060(KPERSN))GO TO 284
  282 ITIME=INI060(KPERSN)
      GO TO 284
  283 CONTINUE
      IF(IPERSN.GE.LIMIT)GO TO 285
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 281
      GO TO 280
  284 IF(IPERSN.GE.LIMIT)GO TO 285
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 284
      GO TO 280
  285 IF(ITIME.EQ.JTIME)GO TO 290
      JTIME=ITIME
      KNTDIF=KNTDIF+1
      ITIME=40*(ITIME/60) + ITIME
      IF(LOWBFR.EQ.0)GO TO 286
      IF(LOWBFR.GE.LMTBFR)GO TO 287
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
  286 CALL DAHOUR(ITIME,0,0,1,LTRBFR,LMTBFR,
     1LOWBFR,IERROR)
      IF(IERROR.NE.1)GO TO 289
  287 WRITE(ITTY,288)(LTRBFR(I),I=1,LOWBFR)
  288 FORMAT(1X,80A1)
      LOWBFR=0
      GO TO 286
  289 ITIME=JTIME
      GO TO 279
  290 IF(LOWBFR.GT.0)WRITE(ITTY,288)(LTRBFR(I),I=1,LOWBFR)
      WRITE(ITTY,291)
  291 FORMAT(1X)
      IF(KNTDIF.EQ.1)GO TO 337
      IF(KNTDIF.GT.LMTPRF)KNTDIF=LMTPRF
      GO TO 294
C
C     AFTER GETTING GOOD TIME, CHECK IF ANYTHING ELSE TYPED
  292 LOWBFR=LOWBFR+1
  293 IF(LOWBFR.GT.MAXBFR)GO TO 294
      IF(LTRBFR(LOWBFR).EQ.LTRSPA)GO TO 292
      IF(LTRBFR(LOWBFR).EQ.LTRCOM)GO TO 292
      IF(LTRBFR(LOWBFR).EQ.LTRQUE)GO TO 320
      GO TO 302
C
C     ASK WHEN USER WILL WANT INTERVIEW
  294 I=KNTPRF(LOCATN)+1
      IF(I.GT.KNTDIF)GO TO 339
      IF(I.EQ.1)GO TO 296
      IF(I.LT.KNTDIF)GO TO 296
      WRITE(ITTY,295)
  295 FORMAT(' Least desired interview time? ',$)
      GO TO 301
  296 IF(I.EQ.1)WRITE(ITTY,297)
  297 FORMAT(' Most desired interview time? ',$)
      IF(I.EQ.2)WRITE(ITTY,298)
  298 FORMAT(' Second most desired interview time? ',$)
      IF(I.EQ.3)WRITE(ITTY,299)
  299 FORMAT(' Third most desired interview time? ',$)
      IF(I.GT.3)WRITE(ITTY,300)I
  300 FORMAT(' ',1I2,'th most desired interview time? ',$)
  301 CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 320
      IF(MAXBFR.EQ.0)GO TO 333
      LOWBFR=1
  302 CALL DADATE(2,LTRBFR,LMTBFR,LOWBFR,KIND  ,
     1   IHOUR ,IMINUT,IAMPM ,LCNBFR)
      IF(KIND.EQ.1)GO TO 318
      IF(KIND.EQ.3)GO TO 303
      IF(KIND.LT.18)GO TO 318
      IF(KIND.GT.21)GO TO 318
      IF(IHOUR.LT.0)GO TO 318
C
C     CHECK FOR DIRECT TIME MATCH
  303 IF(IMINUT.LT.0)IMINUT=0
C     ADUST TIMES SUCH AS 12AM AND 12PM
      IF(IHOUR.NE.12)GO TO 306
      IF(IAMPM.EQ.3)GO TO 305
      IF(IAMPM.EQ.2)GO TO 304
      IF(IAMPM.EQ.1)IHOUR=0
      GO TO 307
  304 IF(IMINUT.EQ.0)IHOUR=24
      GO TO 307
  305 IF(IMINUT.NE.0)GO TO 318
      GO TO 307
  306 IF(IAMPM.EQ.2)IHOUR=IHOUR+12
      IF(IAMPM.EQ.3)GO TO 318
  307 IF(IHOUR.GT.24)GO TO 318
      ITIME=(60*IHOUR)+IMINUT
  308 LIMIT=KFIRST(KOMPNY)+INTRVW(KOMPNY)-1
      IPERSN=KFIRST(KOMPNY)
  309 IF(JFIRST(IPERSN).LT.0)GO TO 312
      IF(IDATE(LOCATN).EQ.0)GO TO 310
      IF(IDATE(LOCATN).NE.JDATE(IPERSN))GO TO 312
  310 LPERSN=JFIRST(IPERSN)
      MPERSN=JFINAL(IPERSN)
      DO 311 KPERSN=LPERSN,MPERSN
      IF(ITIME.EQ.INI060(KPERSN))GO TO 328
  311 CONTINUE
      IF(IPERSN.GE.LIMIT)GO TO 313
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 310
      GO TO 309
  312 IF(IPERSN.GE.LIMIT)GO TO 313
      IPERSN=IPERSN+1
      IF(JDATE(IPERSN).LT.0)GO TO 312
      GO TO 309
  313 CONTINUE
C
C     IF NO MATCH IN MORNING, CHECK FOR MATCH IN AFTERNOON
      IF(ITIME.GT.(12*60))GO TO 315
      IF(KIND.EQ.3)GO TO 314
      IF(KIND.EQ.18)GO TO 314
      GO TO 315
  314 ITIME=ITIME+(12*60)
      GO TO 308
  315 GO TO 316
C
C     NO MATCH FOUND
  316 IF(KNTPRF(LOCATN).GE.KNTDIF)GO TO 339
      WRITE(ITTY,317)
  317 FORMAT(' No interview starts at this time.')
      GO TO 294
  318 IF(KNTPRF(LOCATN).GE.KNTDIF)GO TO 339
      WRITE(ITTY,319)
  319 FORMAT(' Type ? for help')
      GO TO 294
C
C     HELP MESSAGE INCLUDING LIST OF TIMES SELECTED SO FAR
  320 IF(KNTPRF(LOCATN).GE.KNTDIF)GO TO 339
      CALL JOBHLP(ITTY,16,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      LIMIT=KNTPRF(LOCATN)
      IF(LIMIT.LE.0)GO TO 327
      WRITE(ITTY,321)
  321 FORMAT(
     1' You requested the following times (most desired first):'/1X)
      LOWBFR=0
      DO 325 INDEX=1,LIMIT
      ITIME=IPREFR(INDEX,LOCATN)
      ITIME=40*(ITIME/60) + ITIME
      IF(LOWBFR.EQ.0)GO TO 322
      IF(LOWBFR.GE.LMTBFR)GO TO 323
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
  322 CALL DAHOUR(ITIME,0,0,1,LTRBFR,LMTBFR,
     1LOWBFR,IERROR)
      IF(IERROR.NE.1)GO TO 325
  323 WRITE(ITTY,324)(LTRBFR(I),I=1,LOWBFR)
  324 FORMAT(1X,80A1)
      LOWBFR=0
      GO TO 322
  325 CONTINUE
      IF(LOWBFR.GT.0)WRITE(ITTY,324)(LTRBFR(I),I=1,LOWBFR)
      WRITE(ITTY,326)
  326 FORMAT(1X)
  327 CONTINUE
      GO TO 275
C
C     USER HAS SELECTED A KNOWN TIME
  328 LIMIT=KNTPRF(LOCATN)
      IF(LIMIT.LE.0)GO TO 330
      DO 329 I=1,LIMIT
      INDEX=I
      IF(ITIME.EQ.IPREFR(I,LOCATN))GO TO 331
  329 CONTINUE
  330 IF(LIMIT.GE.KNTDIF)GO TO 332
      KNTPRF(LOCATN)=KNTPRF(LOCATN)+1
      I=KNTPRF(LOCATN)
      IPREFR(I,LOCATN)=ITIME
      GO TO 293
  331 IF(INDEX.GE.LIMIT)GO TO 332
      IPREFR(INDEX,LOCATN)=IPREFR(INDEX+1,LOCATN)
      INDEX=INDEX+1
      GO TO 331
  332 IPREFR(LIMIT,LOCATN)=ITIME
      GO TO 293
C
C     ASK IF ARE DONE SPECIFYING THE DESIRED TIMES
  333 IF(KNTPRF(LOCATN).EQ.0)WRITE(ITTY,334)
  334 FORMAT(' Do you really want all times to be given ',
     1'equal preference? ',$)
      IF(KNTPRF(LOCATN).GT.0)WRITE(ITTY,335)
  335 FORMAT(' Have you finished specifying the desired times? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(333,333,337,294,336),KNDYES
  336 CALL JOBHLP(ITTY,17,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 333
  337 CONTINUE
      IF(KNTPRF(LOCATN).EQ.0)WRITE(ITTY,338)
  338 FORMAT(' All times will be given equal preference')
      GO TO 343
  339 WRITE(ITTY,340)
  340 FORMAT(' You have specified as many times as allowed')
      GO TO 343
  341 WRITE(ITTY,342)
  342 FORMAT(' This firm has cancelled so no date or tim',
     1'e preferences are being accepted')
  343 GO TO 79
C
C     *********************
C     *                   *
C     *  PRIORITY OPTION  *
C     *                   *
C     *********************
C
  344 IF(KNTSIN.LE.0)GO TO 349
      LOCATN=KNTSIN
      DO 345 I=1,KNTSIN
      IF(NUMVOT(LOCATN).EQ.NUMBER(KOMPNY))GO TO 346
      LOCATN=LOCATN-1
  345 CONTINUE
      GO TO 349
  346 IF(LOCATN.LE.LOCKUP)GO TO 347
      GO TO 170
C
C     ERROR MESSAGES
  347 WRITE(ITTY,348)
  348 FORMAT(
     1' You cannot change priority for a request made',
     2' in an earlier stage of this round')
      GO TO 351
  349 WRITE(ITTY,350)
  350 FORMAT(' You have not requested an interview with this firm')
      GO TO 351
  351 GO TO 79
C
C     *****************
C     *               *
C     *  TIME OPTION  *
C     *               *
C     *****************
C
  352 IF(KNTSIN.LE.0)GO TO 361
      LOCATN=KNTSIN
      DO 353 I=1,KNTSIN
      IF(NUMVOT(LOCATN).EQ.NUMBER(KOMPNY))GO TO 354
      LOCATN=LOCATN-1
  353 CONTINUE
      GO TO 361
  354 IF(KLOCK(LOCATN).NE.0)GO TO 359
      IF(KNTOPN(KOMPNY).EQ.0)GO TO 357
      IF(IDATE(LOCATN).GT.0)WRITE(ITTY,355)
  355 FORMAT(' Discarding previously specified date')
      IF(KNTPRF(LOCATN).GT.0)WRITE(ITTY,356)
  356 FORMAT(' Discarding previously specified times')
      IDATE(LOCATN)=0
      KNTPRF(LOCATN)=0
      GO TO 233
  357 WRITE(ITTY,358)
  358 FORMAT(' This firm has cancelled so no date or tim',
     1'e preferences are being accepted')
      GO TO 363
  359 WRITE(ITTY,360)
  360 FORMAT(' You cannot change an interview request on',
     1'ce this has been assigned a time slot')
      GO TO 363
  361 WRITE(ITTY,362)
  362 FORMAT(' You have not requested an interview with this firm')
  363 GO TO 79
C
C     *******************
C     *                 *
C     *  CANCEL OPTION  *
C     *                 *
C     *******************
C
  364 IF(KNTSIN.LE.0)GO TO 389
      LOCATN=KNTSIN
      DO 365 I=1,KNTSIN
      IF(NUMVOT(LOCATN).EQ.NUMBER(KOMPNY))GO TO 366
      LOCATN=LOCATN-1
  365 CONTINUE
      GO TO 389
C
C     CHECK IF REQUEST MUST BE KEPT IN FILE
  366 IF(KLOSED(LOCATN).NE.0)GO TO 378
      IF(LOCATN.LE.LOCKUP)GO TO 367
      IF(ISOURC(LOCATN).NE.0)GO TO 378
      GO TO 379
C
C     CHECK IF REALLY WANT TO CANCEL REQUEST MADE EARLIER
  367 IPOSTN=JRANK(LOCATN)-KNTOPN(KOMPNY)
      IF(KLOCK(LOCATN).NE.0)IPOSTN=0
      WRITE(ITTY,368)
  368 FORMAT(' You requested this interview prior to the',
     1' current stage.'/' Cancelling this request will n',
     2'ot let you make new request or reuse priority bid.')
      IF(IPOSTN.LE.0)WRITE(ITTY,369)
      IF(IPOSTN.GT.0)WRITE(ITTY,370)IPOSTN
  369 FORMAT(' An interview with this firm has already b',
     1'een allocated to you.')
  370 FORMAT(' Your request is at position',1I5,
     1' on the waiting list.')
  371 IF(IPOSTN.LE.0)WRITE(ITTY,372)
      IF(IPOSTN.GT.0)WRITE(ITTY,373)
  372 FORMAT(' Do you really want to cancel this interview? ',$)
  373 FORMAT(' Do you really want to remove your request',
     1' from the waiting list? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(371,371,377,375,374),KNDYES
  374 CALL JOBHLP(ITTY,38,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 371
  375 WRITE(ITTY,376)
  376 FORMAT(' Your request for this interview has not been changed.')
      GO TO 391
  377 CONTINUE
C
C     CANCEL THE REQUEST BUT KEEP IT IN FILE
  378 IF(KLOSED(LOCATN).EQ.2)GO TO 385
      KLOSED(LOCATN)=3
      GO TO 387
C
C     REQUEST MADE THIS STAGE
  379 KNTSIN=KNTSIN-1
      IF(MANNER.GT.20)GO TO 381
      IF(MANNER.GT.10)GO TO 380
C     TYPE 1 PRIORITY ADJUSTMENT
      GO TO 382
C     TYPE 2 PRIORITY ADJUSTMENT
  380 IF(KNDVOT(LOCATN).EQ.1)IUSED=IUSED-1
      GO TO 382
C     TYPE 3 PRIORITY ADJUSTMENT
  381 IUSED=IUSED-KNDVOT(LOCATN)
      GO TO 382
  382 IF(LOCATN.GT.KNTSIN)GO TO 387
      NUMVOT(LOCATN)=NUMVOT(LOCATN+1)
      KNDVOT(LOCATN)=KNDVOT(LOCATN+1)
      KNTPRF(LOCATN)=KNTPRF(LOCATN+1)
      IDATE(LOCATN)=IDATE(LOCATN+1)
      KLOSED(LOCATN)=KLOSED(LOCATN+1)
      ISOURC(LOCATN)=ISOURC(LOCATN+1)
      IRANK(LOCATN)=IRANK(LOCATN+1)
      JRANK(LOCATN)=JRANK(LOCATN+1)
      KLOCK(LOCATN)=KLOCK(LOCATN+1)
      MTIME(LOCATN)=MTIME(LOCATN+1)
      MDATE(LOCATN)=MDATE(LOCATN+1)
      MRECRT(LOCATN)=MRECRT(LOCATN+1)
      LIMIT=KNTPRF(LOCATN)
      IF(LIMIT.LE.0)GO TO 384
      DO 383 J=1,LIMIT
      IPREFR(J,LOCATN)=IPREFR(J,LOCATN+1)
  383 CONTINUE
  384 LOCATN=LOCATN+1
      GO TO 382
  385 WRITE(ITTY,386)
  386 FORMAT(
     1' This request for an interview was already rejected by firm.')
      GO TO 391
  387 WRITE(ITTY,388)
  388 FORMAT(' This request for an interview is now cancelled.')
      GO TO 391
  389 WRITE(ITTY,390)
  390 FORMAT(' You have not requested an interview with this firm.')
  391 GO TO 79
C
C     *****************
C     *               *
C     *  LIST OPTION  *
C     *               *
C     *****************
C
  392 IF(KNTINC.LE.0)GO TO 424
      KNTLIN=0
      NEWCRT=0
      DO 423 KOMPNY=1,KNTINC
C
C     GET LENGTHS OF NAME, DIVISION AND ADDRESS
      LNGINC=LMTINC
  393 IF(LTRINC(LNGINC,KOMPNY).NE.LTRSPA)GO TO 394
      LNGINC=LNGINC-1
      IF(LNGINC.GT.0)GO TO 393
  394 LNGDPT=LMTDPT
  395 IF(LTRDPT(LNGDPT,KOMPNY).NE.LTRSPA)GO TO 396
      LNGDPT=LNGDPT-1
      IF(LNGDPT.GT.0)GO TO 395
  396 LNGADR=LMTADR
  397 IF(LTRADR(LNGADR,KOMPNY).NE.LTRSPA)GO TO 398
      LNGADR=LNGADR-1
      IF(LNGADR.GT.0)GO TO 397
  398 CONTINUE
      IF(LNGINC.EQ.0)LNGINC=1
      LNGLIN=LNGINC
      IF(LNGDPT.GT.0)LNGLIN=LNGLIN+LNGDPT+2
      IF(LNGADR.GT.0)LNGLIN=LNGLIN+LNGADR+2
C
C     CHECK IF SCREEN IS FULL
      KNTLIN=KNTLIN+3
      IF(LNGLIN.GT.80)KNTLIN=KNTLIN+1
      IF(JVIDEO.LT.0)GO TO 401
      IF(NEWCRT.EQ.0)GO TO 400
      IF(KNTLIN.LE.LNGCRT)GO TO 401
      WRITE(ITTY,399)
  399 FORMAT(1X/' (Press RETURN to continue) ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.NE.0)GO TO 427
  400 KNTLIN=3
      IF(LNGLIN.GT.80)KNTLIN=KNTLIN+1
      IF(JVIDEO.GT.0)CALL RSMWIP(ITTY)
      NEWCRT=1
C
C     CONSTRUCT DATE IN FORM DD-MMM-YY
  401 LOWBFR=0
      ISMITH=0
      JSMITH=0
      IF(INTRVW(KOMPNY).LE.0)GO TO 407
      LIMIT=INTRVW(KOMPNY)
      IPERSN=KFIRST(KOMPNY)
      DO 404 I=1,LIMIT
      IF(JDATE(IPERSN).LT.0)GO TO 403
      IF(JFIRST(IPERSN).LT.0)GO TO 403
      IF(ISMITH.EQ.0)GO TO 402
      IF(ISMITH.GT.JDATE(IPERSN))ISMITH=JDATE(IPERSN)
      IF(JSMITH.LT.JDATE(IPERSN))JSMITH=JDATE(IPERSN)
      GO TO 403
  402 ISMITH=JDATE(IPERSN)
      JSMITH=JDATE(IPERSN)
  403 IPERSN=IPERSN+1
  404 CONTINUE
      KSMITH=ISMITH
  405 CALL DAWEEK(-1,KSMITH,NDAY,NMONTH,NYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      DO 406 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  406 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(KSMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
      IF(KSMITH.EQ.JSMITH)GO TO 407
      KSMITH=JSMITH
      GO TO 405
  407 CONTINUE
C
C     WRITE STATUS LINE
C     NUMBER OPEN SLOTS + NUMBER MOVED TO CLOSED - NUMBER REQUESTING
      ISLOTS=KNTOPN(KOMPNY)+INCLSD(KOMPNY)-IUSDUP(KOMPNY)
      IF(ISLOTS.LT.0)JSLOTS=-ISLOTS
      IF(ISMITH.NE.JSMITH)GO TO 413
      IF(ISMITH.NE.0)GO TO 410
C
C     CANCELLED
      IF(ISLOTS.GE.0)WRITE(ITTY,408)NUMBER(KOMPNY)
  408 FORMAT(' Firm:',1I3,', Cancelled')
      IF(ISLOTS.LT.0)WRITE(ITTY,409)NUMBER(KOMPNY),JSLOTS
  409 FORMAT(' Firm:',1I3,', Cancelled',
     1', Length of waiting list:',1I5)
      GO TO 416
C
C     SINGLE DATE
  410 IF(ISLOTS.GE.0)WRITE(ITTY,411)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),ISLOTS
  411 FORMAT(' Firm:',1I3,', Date: ',13A1,
     1', Unallocated interviews:',1I5)
      IF(ISLOTS.LT.0)WRITE(ITTY,412)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),JSLOTS
  412 FORMAT(' Firm:',1I3,', Date: ',13A1,
     1', Length of waiting list:',1I5)
      GO TO 416
C
C     RANGE OF DATES
  413 IF(ISLOTS.GE.0)WRITE(ITTY,414)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),ISLOTS
  414 FORMAT(' Firm:',1I3,', Dates: ',13A1,' to ',13A1,
     1', Unallocated interviews:',1I5)
      IF(ISLOTS.LT.0)WRITE(ITTY,415)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),JSLOTS
  415 FORMAT(' Firm:',1I3,', Dates: ',13A1,' to ',13A1,
     1', Length of waiting list:',1I5)
  416 CONTINUE
C
C     TYPE SECOND LINE WITH NAME, DIVISION, ADDRESS
      IF(LNGADR.GT.0)GO TO 418
      IF(LNGDPT.GT.0)GO TO 417
      WRITE(ITTY,420)(LTRINC(I,KOMPNY),I=1,LNGINC)
      GO TO 421
  417 WRITE(ITTY,420)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT)
      GO TO 421
  418 IF(LNGDPT.GT.0)GO TO 419
      WRITE(ITTY,420)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
      GO TO 421
  419 WRITE(ITTY,420)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT),
     2LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
  420 FORMAT(1X,80A1)
  421 WRITE(ITTY,422)
  422 FORMAT(1X)
  423 CONTINUE
      GO TO 426
  424 WRITE(ITTY,425)
  425 FORMAT(' No firms have scheduled interviews')
      GO TO 426
C
C     WHAT TO DO AFTER REPORT OR LIST COMMANDS
  426 MAXBFR=0
  427 IF(MAXBFR.NE.0)GO TO 81
      GO TO 79
C
C     *******************
C     *                 *
C     *  REPORT OPTION  *
C     *                 *
C     *******************
C
C     KOMAND = 0, FINAL REPORT ONLY, JOBS PROGRAM IS CLOSED
C            = 8, REPORT OPTION, TYPE TO TERMINAL
C            = 14, PRINT OPTION, WRITE TO FILE
C
C     ENTRY FOR PRINT COMMAND
  428 IF(ICHECK.EQ.0)CALL RSMOPN(11,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(ICHECK.NE.0)CALL RSMOPN(10,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.NE.0)GO TO 430
      WRITE(ITTY,429)
  429 FORMAT(' Cannot write report file')
      IF(KOMAND.EQ.0)GO TO 646
      GO TO 79
C
C     INITIAL LINES IN REPORT FILE
  430 WRITE(IDISK,431)LTRNAM
  431 FORMAT(' Name: ',100A1)
      CALL TSTAMP(LTRTIM)
      WRITE(IDISK,432)LTRTIM
  432 FORMAT(' Date: ',100A1)
      WRITE(IDISK,433)IMOVE,IPASS,IVERSN
  433 FORMAT(' Round:',1I3,', Stage:',1I3,', Version:',1I7)
      KNTLIN=0
      JPRINT=1
      GO TO 471
C
C     ENTRY FOR REPORT COMMAND
  434 KNTLIN=0
      JPRINT=0
      IF(JVIDEO.GT.0)CALL RSMWIP(ITTY)
C
C     DECIDE TYPE OF PRIORITY SCHEME USED
      IF(MANNER.GT.20)GO TO 447
      IF(MANNER.GT.10)GO TO 435
C
C     TYPE 1 PRIORITY
      GO TO 459
C
C     TYPE 2 PRIORITY
  435 CONTINUE
      I=0
      J=0
      K=0
  436 I=I+1
      IF(I.GT.KNTSIN)GO TO 437
      IF(KNDVOT(I).NE.1)GO TO 436
      IF(I.LE.LOCKUP)J=J+1
      K=K+1
      GO TO 436
  437 KNTLIN=KNTLIN+1
      IF(J.EQ.0)WRITE(ITTY,438)K
  438 FORMAT(' You have made',1I8,' high priority reques',
     1'ts in this round')
      IF(J.GT.0)WRITE(ITTY,439)J,K
  439 FORMAT(' You made',1I3,' high priority requests in',
     1' early stages of this round and',1I3,' in round')
      ISUM=MAXPAY-IUSED
      IF(ISUM.GT.0)GO TO 443
      KNTLIN=KNTLIN+1
      IF(MANNER.EQ.11)WRITE(ITTY,440)
      IF(MANNER.EQ.12)WRITE(ITTY,441)
      IF(MANNER.EQ.13)WRITE(ITTY,442)
CYou cannot make any more high priority requests during the season
  440 FORMAT(' You cannot make any more high priority req',
     1'uests during the season')
  441 FORMAT(' You cannot make any more high priority req',
     1'uests during this round')
  442 FORMAT(' You cannot make any more high priority req',
     1'uests during this stage')
      GO TO 459
  443 KNTLIN=KNTLIN+1
      IF(MANNER.EQ.11)WRITE(ITTY,444)ISUM
      IF(MANNER.EQ.12)WRITE(ITTY,445)ISUM
      IF(MANNER.EQ.13)WRITE(ITTY,446)ISUM
CYou can still make 123456 high priority (A) requests during the season
  444 FORMAT(' You can still make',1I4,' high priority (A) requests',
     1' during the season')
  445 FORMAT(' You can still make',1I4,' high priority (A) requests',
     1' during this round')
  446 FORMAT(' You can still make',1I4,' high priority (A) requests',
     1' during this stage')
      GO TO 459
C
C     TYPE 3 PRIORITY
  447 CONTINUE
      I=0
      J=0
      K=0
  448 I=I+1
      IF(I.GT.KNTSIN)GO TO 449
      IF(I.LE.LOCKUP)J=J+KNDVOT(I)
      K=K+KNDVOT(I)
      GO TO 448
  449 KNTLIN=KNTLIN+1
      IF(J.EQ.0)WRITE(ITTY,450)K
  450 FORMAT(' You have bid',1I8,' total in this round')
      IF(J.GT.0)WRITE(ITTY,451)J,K
  451 FORMAT(' You bid',1I8,' in earlier stages of this r',
     1'ound and',1I8,' total in this round')
      ISUM=MAXPAY-IUSED
      IF(ISUM.GT.0)GO TO 455
      KNTLIN=KNTLIN+1
      IF(MANNER.EQ.21)WRITE(ITTY,452)
      IF(MANNER.EQ.22)WRITE(ITTY,453)
      IF(MANNER.EQ.23)WRITE(ITTY,454)
  452 FORMAT(' You cannot bid any more during the season')
  453 FORMAT(' You cannot bid any more during this round')
  454 FORMAT(' You cannot bid any more during this stage')
      GO TO 459
  455 KNTLIN=KNTLIN+1
      IF(MANNER.EQ.21)WRITE(ITTY,456)MAXBID,ISUM
      IF(MANNER.EQ.22)WRITE(ITTY,457)MAXBID,ISUM
      IF(MANNER.EQ.23)WRITE(ITTY,458)MAXBID,ISUM
CYou can bid 123456 for 1 firm and up to 123456 more during the season
  456 FORMAT(' You can bid',1I8,' for 1 firm and up to',
     1 1I8,' more during the season')
  457 FORMAT(' You can bid',1I8,' for 1 firm and up to',
     1 1I8,' more during this round')
  458 FORMAT(' You can bid',1I8,' for 1 firm and up to',
     1 1I8,' more during this stage')
      GO TO 459
C
C     LIMIT OF NUMBER OF REQUESTS
  459 I=MAXSTG-KNTSIN+LOCKUP
      J=MAXRND-KNTSIN
      K=MAXALL-KNTSIN-KNTALL
      IF(I.GT.J)I=J
      IF(I.GT.K)I=K
      IF(J.GT.K)J=K
      KNTLIN=KNTLIN+1
      WRITE(ITTY,462)I
      IF(J.LE.I)GO TO 460
      KNTLIN=KNTLIN+1
      WRITE(ITTY,463)J
  460 IF(K.LE.J)GO TO 461
      KNTLIN=KNTLIN+1
      WRITE(ITTY,464)K
  461 CONTINUE
  462 FORMAT(' You can still make',1I4,' more requests d',
     1'uring this stage')
  463 FORMAT(' You can still make',1I4,' more requests d',
     1'uring this round')
  464 FORMAT(' You can still make',1I4,' more requests d',
     1'uring the season')
C
C     NUMBER OF REQUESTS MADE IN PREVIOUS STAGE
      IF(KNTALL.EQ.0)GO TO 466
      KNTLIN=KNTLIN+1
      WRITE(ITTY,465)KNTALL
  465 FORMAT(' You made',1I4,' requests in earlier rounds')
  466 IF(LOCKUP.EQ.0)GO TO 468
      KNTLIN=KNTLIN+1
      WRITE(ITTY,467)LOCKUP
  467 FORMAT(' You made',1I4,' requests in earlier stage',
     1's of the current round')
  468 IF(KNTSIN.EQ.LOCKUP)GO TO 470
      I=KNTSIN-LOCKUP
      KNTLIN=KNTLIN+1
      WRITE(ITTY,469)I
  469 FORMAT(' You made',1I4,' requests in the current s',
     1'tage of this round')
  470 CONTINUE
C
C     BLANK LINE BETWEEN HEADER AND FIRST FIRM
  471 KNTLIN=KNTLIN+1
      IF(JPRINT.EQ.0)WRITE(ITTY,472)
      IF(JPRINT.NE.0)WRITE(IDISK,472)
  472 FORMAT(1X)
      IF(KNTSIN.LE.0)GO TO 564
C
C     START OF LOOP THROUGH ALL SIGN UPS
      DO 563 NOWSIN=1,KNTSIN
      DO 473 I=1,KNTINC
      IF(NUMVOT(NOWSIN).NE.NUMBER(I))GO TO 473
      KOMPNY=I
      GO TO 474
  473 CONTINUE
      GO TO 563
  474 CONTINUE
C
C     DETERMINE IF INTERVIEW TIME HAS BEEN CANCELLED
C     KANCEL = 0, NOT ASSIGNED TIME, OR TIME OK
C            = 1, TIME ASSIGNED NO LONGER AVAILABLE
      KANCEL=0
      IF(KLOSED(NOWSIN).NE.0)GO TO 481
      IF(IRANK(NOWSIN).EQ.0)GO TO 481
      IF(KLOCK(NOWSIN).EQ.0)GO TO 481
      IF(MRECRT(NOWSIN).LT.0)GO TO 480
      IF(MRECRT(NOWSIN).EQ.0)GO TO 481
      IF(KLOCK(NOWSIN).NE.LENGTH(KOMPNY))GO TO 480
      IPERSN=KFIRST(KOMPNY)
      KPERSN=0
      LIMIT=IPERSN+INTRVW(KOMPNY)-1
  475 IF(IPERSN.GT.LIMIT)GO TO 480
      IF(JDATE(IPERSN).LT.0)GO TO 479
      KPERSN=KPERSN+1
      IF(KPERSN.NE.MRECRT(NOWSIN))GO TO 479
      IF(JDATE(IPERSN).NE.MDATE(NOWSIN))GO TO 480
  476 IF(JFIRST(IPERSN).LT.0)GO TO 478
      IF(JFINAL(IPERSN).LT.0)GO TO 478
      LPERSN=JFIRST(IPERSN)
      MPERSN=JFINAL(IPERSN)
      DO 477 NPERSN=LPERSN,MPERSN
      IF(INI060(NPERSN).EQ.MTIME(NOWSIN))GO TO 481
  477 CONTINUE
  478 IPERSN=IPERSN+1
      IF(IPERSN.GT.LIMIT)GO TO 480
      IF(JDATE(IPERSN).LT.0)GO TO 476
      GO TO 480
  479 IPERSN=IPERSN+1
      GO TO 475
  480 KANCEL=1
  481 CONTINUE
C
C     GET LENGTHS OF NAME, DIVISION AND ADDRESS
      LNGINC=LMTINC
  482 IF(LTRINC(LNGINC,KOMPNY).NE.LTRSPA)GO TO 483
      LNGINC=LNGINC-1
      IF(LNGINC.GT.0)GO TO 482
  483 LNGDPT=LMTDPT
  484 IF(LTRDPT(LNGDPT,KOMPNY).NE.LTRSPA)GO TO 485
      LNGDPT=LNGDPT-1
      IF(LNGDPT.GT.0)GO TO 484
  485 LNGADR=LMTADR
  486 IF(LTRADR(LNGADR,KOMPNY).NE.LTRSPA)GO TO 487
      LNGADR=LNGADR-1
      IF(LNGADR.GT.0)GO TO 486
  487 CONTINUE
C
C     LINE 1: FIRM NUMBER, DATE, SIZE OF LIST
C     LINE 2: FIRM NAME, DEPARTMENT, CITY
C     LINE 3: STATUS OF REQUEST
C     LINE 4: (OPTIONAL) REQUESTED TIMES OR ACTUAL TIMES
C     LINE 5: BLANK
C
C     CALCULATE IF NAME AND ADDRESS LINE REQUIRES 2 LINES
      INILIN=KNTLIN
      KNTLIN=KNTLIN+4
      IF(LNGINC.EQ.0)LNGINC=1
      LNGLIN=LNGINC
      IF(LNGDPT.GT.0)LNGLIN=LNGLIN+LNGDPT+2
      IF(LNGADR.GT.0)LNGLIN=LNGLIN+LNGADR+2
      IF(LNGLIN.GT.80)KNTLIN=KNTLIN+1
C
C     DETERMINE IF NEED 1 OR 2 LINES FOR TIMES
      IF(KLOSED(NOWSIN).NE.0)GO TO 492
      IF(KLOCK(NOWSIN).NE.0)GO TO 491
      LNGLIN=0
      IF(IDATE(NOWSIN).EQ.0)GO TO 488
      LNGLIN=LNGLIN+14
      IF(KNTPRF(NOWSIN).EQ.0)GO TO 490
      LNGLIN=LNGLIN+1
      GO TO 489
  488 IF(KNTPRF(NOWSIN).EQ.0)GO TO 492
  489 LNGLIN=LNGLIN+8*KNTPRF(NOWSIN)
  490 KNTLIN=KNTLIN+1
      IF((LNGLIN+LEDTIM).GT.80)KNTLIN=KNTLIN+1
      GO TO 492
  491 KNTLIN=KNTLIN+1
  492 CONTINUE
C
C     CHECK IF SCREEN IS FULL
      IF(JPRINT.NE.0)GO TO 494
      IF(JVIDEO.LT.0)GO TO 494
      IF(KNTLIN.LE.LNGCRT)GO TO 494
      WRITE(ITTY,493)
  493 FORMAT(1X/' (Press RETURN to continue) ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.NE.0)GO TO 567
      KNTLIN=KNTLIN-INILIN
      IF(JVIDEO.GT.0)CALL RSMWIP(ITTY)
C
C     CONSTRUCT DATE IN FORM DD-MMM-YY
  494 LOWBFR=0
      ISMITH=0
      JSMITH=0
      IF(KNTOPN(KOMPNY).LE.0)GO TO 500
      LIMIT=INTRVW(KOMPNY)
      IPERSN=KFIRST(KOMPNY)
      DO 497 JPERSN=1,LIMIT
      IF(JDATE(IPERSN).LT.0)GO TO 496
      IF(JFIRST(IPERSN).LT.0)GO TO 496
      IF(ISMITH.NE.0)GO TO 495
      ISMITH=JDATE(IPERSN)
      JSMITH=ISMITH
      GO TO 496
  495 IF(ISMITH.GT.JDATE(IPERSN))ISMITH=JDATE(IPERSN)
      IF(JSMITH.LT.JDATE(IPERSN))JSMITH=JDATE(IPERSN)
  496 IPERSN=IPERSN+1
  497 CONTINUE
      KSMITH=ISMITH
  498 CALL DAWEEK(-1,KSMITH,NDAY,NMONTH,NYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      DO 499 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  499 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(KSMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
      IF(KSMITH.EQ.JSMITH)GO TO 500
      KSMITH=JSMITH
      GO TO 498
  500 CONTINUE
C
C     NUMBER OPEN SLOTS OR LENGTH OF LIST
      ISLOTS=KNTOPN(KOMPNY)+INCLSD(KOMPNY)-IUSDUP(KOMPNY)
      IF(ISLOTS.LT.0)JSLOTS=-ISLOTS
C
C     WRITE TOP LINE OF STATUS
      IF(ISLOTS.GE.0)GO TO 506
      IF(ISMITH.LT.JSMITH)GO TO 502
      IF(ISMITH.NE.0)GO TO 501
      IF(JPRINT.EQ.0)WRITE(ITTY,503)NUMBER(KOMPNY),JSLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,503)NUMBER(KOMPNY),JSLOTS
      GO TO 512
  501 IF(JPRINT.EQ.0)WRITE(ITTY,504)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),JSLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,504)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),JSLOTS
      GO TO 512
  502 IF(JPRINT.EQ.0)WRITE(ITTY,505)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),JSLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,505)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),JSLOTS
      GO TO 512
  503 FORMAT(' Firm:',1I4,', Length of waiting list:',1I4)
  504 FORMAT(' Firm:',1I4,
     1', Date: ',13A1,', Length of waiting list:',1I4)
  505 FORMAT(' Firm:',1I4,
     1', Dates: ',13A1,' to ',13A1,', Length of waiting list:',1I4)
  506 IF(ISMITH.LT.JSMITH)GO TO 508
      IF(ISMITH.NE.0)GO TO 507
      IF(JPRINT.EQ.0)WRITE(ITTY,509)NUMBER(KOMPNY),ISLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,509)NUMBER(KOMPNY),ISLOTS
      GO TO 512
  507 IF(JPRINT.EQ.0)WRITE(ITTY,510)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),ISLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,510)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,13),ISLOTS
      GO TO 512
  508 IF(JPRINT.EQ.0)WRITE(ITTY,511)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),ISLOTS
      IF(JPRINT.NE.0)WRITE(IDISK,511)NUMBER(KOMPNY),
     1(LTRBFR(I),I=1,26),ISLOTS
      GO TO 512
  509 FORMAT(' Firm:',1I4,', Unallocated interviews:',1I4)
  510 FORMAT(' Firm:',1I4,
     1', Date: ',13A1,', Unallocated interviews:',1I4)
  511 FORMAT(' Firm:',1I4,
     1', Dates: ',13A1,' to ',13A1,', Unallocated interviews:',1I4)
  512 CONTINUE
C
C     REPORT FIRM NAME, DIVISION, ADDRESS
      IF(LNGADR.GT.0)GO TO 514
      IF(LNGDPT.GT.0)GO TO 513
      IF(JPRINT.EQ.0)WRITE(ITTY,516)(LTRINC(I,KOMPNY),I=1,LNGINC)
      IF(JPRINT.NE.0)WRITE(IDISK,516)(LTRINC(I,KOMPNY),I=1,LNGINC)
      GO TO 517
  513 IF(JPRINT.EQ.0)WRITE(ITTY,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT)
      IF(JPRINT.NE.0)WRITE(IDISK,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT)
      GO TO 517
  514 IF(LNGDPT.GT.0)GO TO 515
      IF(JPRINT.EQ.0)WRITE(ITTY,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
      IF(JPRINT.NE.0)WRITE(IDISK,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
      GO TO 517
  515 IF(JPRINT.EQ.0)WRITE(ITTY,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT),
     2LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
      IF(JPRINT.NE.0)WRITE(IDISK,516)(LTRINC(I,KOMPNY),I=1,LNGINC),
     1LTRCOM,LTRSPA,(LTRDPT(I,KOMPNY),I=1,LNGDPT),
     2LTRCOM,LTRSPA,(LTRADR(I,KOMPNY),I=1,LNGADR)
  516 FORMAT(1X,80A1)
  517 CONTINUE
C
C     WRITE STATUS LINE
      IF(KLOSED(NOWSIN).NE.0)GO TO 554
      IF(IRANK(NOWSIN).EQ.0)GO TO 524
      IF(KLOCK(NOWSIN).NE.0)GO TO 518
      IPOSTN=JRANK(NOWSIN)-KNTOPN(KOMPNY)
      IF(IPOSTN.GT.0)GO TO 522
  518 IF(KANCEL.NE.0)GO TO 520
      IF(JPRINT.EQ.0)WRITE(ITTY,519)
      IF(JPRINT.NE.0)WRITE(IDISK,519)
  519 FORMAT(' Status: interview confirmed')
      GO TO 538
  520 IF(JPRINT.EQ.0)WRITE(ITTY,521)
      IF(JPRINT.NE.0)WRITE(IDISK,521)
  521 FORMAT(' Status: No interview will be held at prev',
     1'iously scheduled time')
      GO TO 538
  522 IF(JPRINT.EQ.0)WRITE(ITTY,523)IPOSTN
      IF(JPRINT.NE.0)WRITE(IDISK,523)IPOSTN
  523 FORMAT(' Status: position',1I3,' on waiting list')
      GO TO 538
  524 IF(MANNER.GT.20)GO TO 536
      IF(MANNER.GT.10)GO TO 532
      J=KNDVOT(NOWSIN)/INTRVL
      IF(NOWSIN.LE.LOCKUP)GO TO 528
      IF(J.EQ.1)GO TO 530
      I=LOCKUP
  525 I=I+1
      IF(I.GT.KNTSIN)GO TO 526
      IF(KNDVOT(NOWSIN).GE.KNDVOT(I))GO TO 525
      GO TO 528
  526 IF(JPRINT.EQ.0)WRITE(ITTY,527)J
      IF(JPRINT.NE.0)WRITE(IDISK,527)J
  527 FORMAT(' Status: priority',1I4,' request (least desired)')
      GO TO 538
  528 IF(JPRINT.EQ.0)WRITE(ITTY,529)J
      IF(JPRINT.NE.0)WRITE(IDISK,529)J
  529 FORMAT(' Status: priority',1I4,' request')
      GO TO 538
  530 IF(JPRINT.EQ.0)WRITE(ITTY,531)J
      IF(JPRINT.NE.0)WRITE(IDISK,531)J
  531 FORMAT(' Status: priority',1I4,' request (most desired)')
      GO TO 538
  532 IF(KNDVOT(NOWSIN).EQ.2)GO TO 533
      IF(JPRINT.EQ.0)WRITE(ITTY,534)
      IF(JPRINT.NE.0)WRITE(IDISK,534)
      GO TO 538
  533 IF(JPRINT.EQ.0)WRITE(ITTY,535)
      IF(JPRINT.NE.0)WRITE(IDISK,535)
  534 FORMAT(' Status: high (A) priority request')
  535 FORMAT(' Status: low (B) priority request')
      GO TO 538
  536 IF(JPRINT.EQ.0)WRITE(ITTY,537)KNDVOT(NOWSIN)
      IF(JPRINT.NE.0)WRITE(IDISK,537)KNDVOT(NOWSIN)
  537 FORMAT(' Status: bid of',1I8)
      GO TO 538
  538 IF(KLOCK(NOWSIN).NE.0)GO TO 547
C
C     REPORT  REQUESTED TIMES
      LIMIT=KNTPRF(NOWSIN)
      IF(LIMIT.GT.0)GO TO 539
      IF(IDATE(NOWSIN).EQ.0)GO TO 561
  539 LOWBFR=0
      IF(IDATE(NOWSIN).EQ.0)GO TO 541
      ISMITH=IDATE(NOWSIN)
      CALL DAWEEK(-1,ISMITH,NDAY,NMONTH,NYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      DO 540 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  540 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(ISMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
      IF(LIMIT.EQ.0)GO TO 546
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
  541 LMTSHO=LMTBFR-LEDTIM
      DO 545 INDEX=1,LIMIT
      ITIME=IPREFR(INDEX,NOWSIN)
      ITIME=40*(ITIME/60) + ITIME
      IF(LOWBFR.EQ.0)GO TO 542
      IF(LOWBFR.GE.LMTSHO)GO TO 543
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
  542 CALL DAHOUR(ITIME,0,0,1,LTRBFR,LMTSHO,
     1LOWBFR,IERROR)
      IF(IERROR.NE.1)GO TO 545
C     NOTE, CHANGE LEDTIM IF CHANGE CHARACTERS AT START OF FORMAT
  543 IF(JPRINT.EQ.0)WRITE(ITTY,544)(LTRBFR(I),I=1,LOWBFR)
      IF(JPRINT.NE.0)WRITE(IDISK,544)(LTRBFR(I),I=1,LOWBFR)
  544 FORMAT(1X,'Requested time: ',80A1)
      LOWBFR=0
      GO TO 542
  545 CONTINUE
  546 IF(LOWBFR.EQ.0)GO TO 561
      IF(JPRINT.EQ.0)WRITE(ITTY,544)(LTRBFR(I),I=1,LOWBFR)
      IF(JPRINT.NE.0)WRITE(IDISK,544)(LTRBFR(I),I=1,LOWBFR)
      GO TO 561
C
C     REPORT SCHEDULED INTERVIEW TIME
  547 IF(MTIME(NOWSIN).EQ.0)GO TO 550
      IF(KANCEL.NE.0)GO TO 550
      LOWBFR=0
      ISMITH=MDATE(NOWSIN)
      CALL DAWEEK(-1,ISMITH,NDAY,NMONTH,NYEAR,IWEEK)
      JWEEK=3*IWEEK
      IWEEK=JWEEK-2
      DO 548 I=IWEEK,JWEEK
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRWEK(I)
  548 CONTINUE
      LOWBFR=LOWBFR+1
      LTRBFR(LOWBFR)=LTRSPA
      CALL DAWHEN(ISMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
      ITIME=MTIME(NOWSIN)
      ITIME=40*(ITIME/60) + ITIME
      CALL DAHOUR(ITIME,1,0,1,LTRBFR,LMTBFR,LOWBFR,IERROR)
      ITIME=MTIME(NOWSIN)+KLOCK(NOWSIN)
      ITIME=40*(ITIME/60) + ITIME
      CALL DAHOUR(ITIME,1,0,1,LTRBFR,LMTBFR,LOWBFR,IERROR)
      IF(JPRINT.EQ.0)WRITE(ITTY,549)(LTRBFR(I),I=1,LOWBFR),
     1 MRECRT(NOWSIN)
      IF(JPRINT.NE.0)WRITE(IDISK,549)(LTRBFR(I),I=1,LOWBFR),
     1 MRECRT(NOWSIN)
CInterview scheduled Fri 11-May-84 from 10:30am to 11:00am on schedule
  549 FORMAT(' Interview scheduled ',13A1,' from ',8A1,
     1' to ',8A1,' on schedule',1I4)
      GO TO 561
  550 IF(KANCEL.NE.0)GO TO 552
      IF(JPRINT.EQ.0)WRITE(ITTY,551)
      IF(JPRINT.NE.0)WRITE(IDISK,551)
  551 FORMAT(
     1' Contact placement office to resolve scheduling c',
     2'onflict for this interview')
      GO TO 561
  552 IF(JPRINT.EQ.0)WRITE(ITTY,553)
      IF(JPRINT.NE.0)WRITE(IDISK,553)
  553 FORMAT(
     1' Contact placement office if additional informati',
     2'on is needed')
      GO TO 561
C
C     REPORT CLOSED STATUS
  554 IF(KLOSED(NOWSIN).EQ.1)GO TO 555
      IF(KLOSED(NOWSIN).EQ.2)GO TO 557
      IF(KLOSED(NOWSIN).EQ.3)GO TO 559
      GO TO 561
  555 IF(JPRINT.EQ.0)WRITE(ITTY,556)
      IF(JPRINT.NE.0)WRITE(IDISK,556)
  556 FORMAT(' Status: moved to closed list,',
     1' contact placement office to schedule')
      GO TO 561
  557 IF(JPRINT.EQ.0)WRITE(ITTY,558)
      IF(JPRINT.NE.0)WRITE(IDISK,558)
  558 FORMAT(' Status: request cancelled by firm')
      GO TO 561
  559 IF(JPRINT.EQ.0)WRITE(ITTY,560)
      IF(JPRINT.NE.0)WRITE(IDISK,560)
  560 FORMAT(' Status: request cancelled by student')
      GO TO 561
  561 CONTINUE
C
C     END OF DESCRIPTION OF THIS FIRM
      IF(JPRINT.EQ.0)WRITE(ITTY,562)
      IF(JPRINT.NE.0)WRITE(IDISK,562)
  562 FORMAT(1X)
  563 CONTINUE
      GO TO 566
  564 IF(JPRINT.EQ.0)WRITE(ITTY,565)
      IF(JPRINT.NE.0)WRITE(IDISK,565)
  565 FORMAT(' You have not requested any interviews in ',
     1'this round')
      GO TO 566
C
C     REPORT COMPLETED
  566 MAXBFR=0
  567 IF(KOMAND.EQ.0)GO TO 568
      IF(KOMAND.EQ.14)GO TO 569
      IF(MAXBFR.NE.0)GO TO 81
      GO TO 79
C
C     CLOSE OUTPUT FILES
  568 IF(JPRINT.EQ.0)GO TO 585
  569 IF(ICHECK.EQ.0)CALL RSMCLS(11,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(ICHECK.NE.0)CALL RSMCLS(10,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      GO TO 646
C
C     *************************
C     *                       *
C     *  NO SIGN UPS ALLOWED  *
C     *                       *
C     *************************
C
C     TELL USER THAT SIGN UPS NOT ALLOWED NOW
  570 WRITE(ITTY,571)
  571 FORMAT(
     1' You submitted the final version of your requests')
      GO TO 577
CRequests for round 12, stage 1 have been processed.  However,
Cthe administrator has not opened the program for the next stage.
  572 WRITE(ITTY,573)IMOVE,IPASS
  573 FORMAT(' Requests for round',1I3,', stage',1I2,' h',
     1'ave been processed.  However,'/' the administrato',
     2'r has not opened the program for the next stage.')
      GO TO 577
C
C     ALLOW ONLY REPORT IF KANRUN = 1
  574 WRITE(ITTY,575)
  575 FORMAT(' Your class cannot run this program at this time')
      IF(IMOVE.NE.JMOVE)GO TO 646
      IF(IPASS.EQ.JPASS)GO TO 576
      LOCKUP=KNTSIN
      IPASS=JPASS
  576 GO TO 577
C
C     USER CANNOT RUN PROGRAM BUT CAN GET REPORT
  577 WRITE(ITTY,578)
  578 FORMAT(' Do you want to review your requests? ',$)
      CALL GETLIN(ITTY,LTRBFR,LMTBFR,MAXBFR)
      IF(MAXBFR.LT.0)GO TO 579
      IF(MAXBFR.EQ.0)GO TO 580
      LOWBFR=1
      CALL DAVERB(1,LMTYNT,LTRYNT,1,KNTYNT,
     1LNGYNT,LTRBFR,MAXBFR,LOWBFR,KIND,MATCH,LCNWRD,
     2LCNKNT,LCNBFR)
      GO TO(580,580,582,582,580),KIND
  579 CALL JOBHLP(ITTY,5,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      KNDMSG=31+JVIDEO
      CALL JOBHLP(ITTY,KNDMSG,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      CALL JOBHLP(ITTY,33,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 577
  580 WRITE(ITTY,581)
  581 FORMAT(' Type ? for instructions')
      GO TO 577
  582 IF(LOWBFR.GT.MAXBFR)GO TO 583
      IF(LTRBFR(LOWBFR).NE.LTRSPA)GO TO 580
  583 IF(MATCH.EQ.1)GO TO 584
      IF(MATCH.EQ.2)GO TO 646
      IF(MATCH.EQ.3)JVIDEO=-1
      IF(MATCH.EQ.4)JVIDEO=0
      IF(MATCH.EQ.5)JVIDEO=1
      IF(JVIDEO.LT.0)WRITE(ITTY,154)
      IF(JVIDEO.EQ.0)WRITE(ITTY,156)
      IF(JVIDEO.GT.0)WRITE(ITTY,158)
      GO TO 577
  584 KOMAND=0
      GO TO 434
C
C     AFTER REVIEWING REQUESTS, ASK IF WANT PAPER COPY
  585 WRITE(ITTY,586)
  586 FORMAT(
     1' Do you want to get a paper copy of your requests? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(585,585,428,646,587),KNDYES
  587 CALL JOBHLP(ITTY,36,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 585
C
C     *******************************************
C     *                                         *
C     *  ASK IF STUDENT REALLY READY TO SUBMIT  *
C     *                                         *
C     *******************************************
C
  588 CALL JOBHLP(ITTY,7,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
  589 WRITE(ITTY,590)
  590 FORMAT(
     1' Have you really indicated all the interviews you want? ',$)
      CALL YESNO(1,KNDYES,ITTY)
      GO TO(589,589,592,79,591),KNDYES
  591 CALL JOBHLP(ITTY,8,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 589
  592 ISUBMT=1
      GO TO 595
C
C     ******************************************
C     *                                        *
C     *  WRITE DECISION FILE FOR THIS STUDENT  *
C     *                                        *
C     ******************************************
C
C     PRINT OPTION
  593 IF(KNTSIN.GT.0)GO TO 595
      WRITE(ITTY,594)
  594 FORMAT(' You have not requested any interviews so far')
      GO TO 79
C
C     OPEN THE INDIVIDUAL DECISION FILE FOR WRITING
  595 CALL RSMOPN(6,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      IF(IFOPEN.EQ.0)GO TO 604
C
C     WRITE THE STUDENTS DECISION FILE
      IVERSN=IVERSN+1
      IF(IVERSN.GT.99999)IVERSN=1
      IAUTHR=11
      WRITE(IDISK,596)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,
     1LTRPSW
      WRITE(IDISK,597)ISUBMT,IUSED,KNTSIN,LOCKUP,MANNER,
     1 KNTALL,IGVBAK
  596 FORMAT(5I6,1I7,1X,20A1)
  597 FORMAT(1I6,1I10,4I6,1I10)
      WRITE(IDISK,598)LTRWHO
      WRITE(IDISK,598)LTRNAM
  598 FORMAT(60A1)
      IF(KNTSIN.LE.0)GO TO 602
      DO 601 KOMPNY=1,KNTSIN
      WRITE(IDISK,599)NUMVOT(KOMPNY),KNDVOT(KOMPNY),KNTPRF(KOMPNY),
     1IDATE(KOMPNY),KLOSED(KOMPNY),IRANK(KOMPNY),JRANK(KOMPNY),
     2KLOCK(KOMPNY),MTIME(KOMPNY),MDATE(KOMPNY),MRECRT(KOMPNY),
     3ISOURC(KOMPNY)
  599 FORMAT(1I6,1I10,10I6)
      LIMIT=KNTPRF(KOMPNY)
      IF(LIMIT.GT.0)WRITE(IDISK,600)(IPREFR(I,KOMPNY),I=1,LIMIT)
  600 FORMAT(13I6)
  601 CONTINUE
  602 WRITE(IDISK,603)
  603 FORMAT('-')
      CALL RSMCLS(6,NUMWHO,KLASS,ITTY,IDISK,IFOPEN)
      GO TO 606
  604 WRITE(ITTY,605)
  605 FORMAT(' Cannot write request file')
      ISUBMT=0
      GO TO 79
  606 IF(KOMAND.EQ.5)WRITE(ITTY,607)
      IF(KOMAND.EQ.6)WRITE(ITTY,607)
      IF(KOMAND.EQ.14)WRITE(ITTY,607)
  607 FORMAT(' Current set of requests saved')
      IF(KOMAND.EQ.7)WRITE(ITTY,608)
  608 FORMAT(' Requests have been submitted')
      IF(KOMAND.EQ.14)GO TO 428
      IF(KOMAND.EQ.5)GO TO 79
      GO TO 646
C
C     ******************
C     *                *
C     *  FATAL ERRORS  *
C     *                *
C     ******************
C
C     LOADING ERROR
  609 WRITE(ITTY,610)
  610 FORMAT(' BLOCK DATA routine not loaded')
      GO TO 646
C
C     NUMBER ASSOCIATED WITH MORE THAN 1 PASSWORD
  611 CALL JOBHLP(ITTY,26,LTRBFR,LMTBFR,MAXBFR,IVIDEO)
      GO TO 646
C
C     WRONG CLASS OR NOT ALLOWED TO RUN
  612 WRITE(ITTY,613)
  613 FORMAT(
     1' Your computer account has not been assigned a class number')
      GO TO 646
  614 WRITE(ITTY,615)
  615 FORMAT(' Your class number not in in file setting current move')
      GO TO 646
  616 WRITE(ITTY,617)
  617 FORMAT(' Your class cannot run this program at this time')
      GO TO 646
  618 WRITE(ITTY,619)
  619 FORMAT(' Your use of the JOBS program has been blocked.'/
     1' Please contact the JOBS program administrator.')
      GO TO 646
C
C     ERROR WITH CURRENT MOVE FILE
  620 WRITE(ITTY,621)
  621 FORMAT(' Input file specifying current stage and round not found')
      GO TO 646
C
C     ERROR WITH PROFILE FILE
  622 WRITE(ITTY,623)
  623 FORMAT(' Cannot read file specifying profiles of starting times')
      GO TO 646
  624 WRITE(ITTY,625)
  625 FORMAT(' Error in contents of schedule profile file')
      GO TO 646
C
C     PROBLEMS WITH FIRM SCHEDULE FILE
  626 WRITE(ITTY,627)
  627 FORMAT(' Input file is not firm schedule file')
      GO TO 646
  628 WRITE(ITTY,629)
  629 FORMAT(' Firm schedule file is for wrong class')
      GO TO 646
  630 WRITE(ITTY,631)
  631 FORMAT(
     1' Administrator has not entered interview schedules yet')
      GO TO 646
  632 WRITE(ITTY,633)
  633 FORMAT(
     1' No firms have scheduled interviews'/1X)
      GO TO 646
  634 WRITE(ITTY,635)LMTRCT
  635 FORMAT(' More than',1I5,' recruiter schedules given earlier')
      GO TO 646
  636 WRITE(ITTY,637)LMTFRM
  637 FORMAT(' More than',1I5,' firms given earlier')
      GO TO 646
  638 WRITE(ITTY,639)
  639 FORMAT(' Firm file references unknown schedule profile')
      GO TO 646
  640 WRITE(ITTY,641)
  641 FORMAT(' Firm file contains time not in profile')
      GO TO 646
C
C     ERROR WITH STUDENT REQUEST FILE
  642 WRITE(ITTY,643)
  643 FORMAT(' Input file is not student request file')
      GO TO 646
  644 WRITE(ITTY,645)
  645 FORMAT(' Student request file is for wrong class')
      GO TO 646
C
C     STOP WITHOUT FORTRAN'S USUAL TIMESTAMP
  646 CALL LEAVE
      STOP
      END
