C     RENBR(JOBBIG/JOBS - FAST BIG RANKING PROGRAM)
C
C     DONALD BARTH, YALE SCHOOL OF MANAGEMENT
C
C     THIS PROGRAM IS PART OF THE JOB INTERVIEW REQUEST SYSTEM
C
C     *****************************************************
C     *                                                   *
C     *  ARRAYS LIMITING SIZE OF CASE HANDLED BY PROGRAM  *
C     *                                                   *
C     *****************************************************
C
C     ARRAYS WHICH STORE INFORMATION ABOUT ALL FIRMS RECRUITING
C
C     LTRINC = THE NAME OF THE FIRM
C     LTRDPT = THE DIVISION NAMES
C     LTRADR = THE LOCATION OF THE FIRM
C     LENGTH = NUMBER OF MINUTES IN 1 INTERVIEW 30, 45 OR 60
C     KNTOPN = NUMBER OF INTERVIEW SLOTS BOTH ALLOCATED AND
C              UNALLOCATED
C     IUSDUP = NUMBER OF INTERVIEW SLOTS ALLOCATED ALREADY
C     NUMBER = THE IDENTIFICATION CODE FOR FIRM
C     IFIRST = INTERVIEW STARTING TIMES FOR EACH INTERVIEWER
C     IFINAL = INTERVIEW ENDING TIMES FOR EACH INTERVIEWER
      DIMENSION LTRINC(40,200),LTRDPT(30,200),LTRADR(30,200),
     1KNTOPN(200),INTRVW(200),IUSDUP(200),NUMBER(200),
     2LENGTH(200),INCLSD(200),JNCLSD(200)
C
C     ARRAYS CONTAINING 1 NUMBER FOR EACH RECRUITER
      DIMENSION JFIRST(1000),JFINAL(1000),JDATE(1000),
     1 JSCHDL(1000)
C
C     ARRAYS WHICH STORE INFORMATION ABOUT ALL INTERVIEW REQUESTS
C     LMTMJR=5000 IS MAXIMUN NUMBER OF INTERVIEW REQUESTS
C
C     MJRPNT = LOCATION IN LTRSTR ARRAY OF STUDENT NAME
C     MJRFRM = FIRM NUMBER
C     MJRPRI = PRIORITY OR BID
C     MJRRNK = RANKING ON LIST
C     MJRCLS = IF ON CLOSED LIST
C     MJRSRC = IF REQUESTED BY STUDENT OR FIRM OR BOTH
C     MJRKLK = IF ASSIGNED INTERVIEW IN PREVIOUS STAGE
      DIMENSION MJRPNT(5000),MJRFRM(5000),MJRPRI(5000),
     1MJRRNK(5000),MJRCLS(5000),MJRSRC(5000),MJRKLK(5000)
C
C     ARRAYS WHICH STORE INFORMATION ABOUT EACH STUDENT
C     LMTSTD=500 IS MAXIMUM NUMBER OF STUDENTS
C
C     LTRSTR = NAMES OF STUDENTS
C
      DIMENSION LTRSTR(30,500)
C
C     ************************************************************
C     *                                                          *
C     *  ARRAYS INDENPENDENT OF NUMBER OF STUDENTS OR SCHEDULES  *
C     *                                                          *
C     ************************************************************
C
C     IPREFR = DESIRED STARTING TIMES SPECIFIED BY USER.  ONLY
C              USED TO SKIP OVER THIS INFORMATION IN FILE
C     LTRTIM = CURRENT DATE AND TIME PRINTABLE BY 15A1 FORMAT
C     LTRPRI = NAMES OF PRIORITIES A AND B
      DIMENSION IPREFR(13)
      DIMENSION LTRTIM(15),LTRPRI(2)
C
C     IDENTIFICATION OF EACH USER
C     LTRWHO = THE NAME OF THE ACCOUNT
C     LTRNAM = THE NAME OF THE STUDENT
C     LTRPSW = THE PASSWORD USED BY THE STUDENT
      DIMENSION LTRWHO(40),LTRNAM(30),LTRPSW(20)
C
C     LTRBFR = INPUT/OUTPUT BUFFER
      DIMENSION LTRBFR(80)
C
C     PRIORITY NAMES
      DATA LTRPRI/1HA,1HB/
C
C     ODD LETTERS
      DATA LTRSPA,LTRCOM,LTRQUE,LTRMIN,LTRSTA/1H ,1H,,1H?,1H-,1H*/
C
C     UNIT NUMBERS FOR TERMINAL AND FILES
      DATA ITTY,IDISK,JDISK,KDISK,LDISK/5,1,20,21,22/
C
C     DIMENSIONS OF ARRAYS CONTAINING CHARACTER INFORMATION
      DATA LMTINC,LMTDPT,LMTADR,LMTBFR,LMTNAM/
     1 40,30,30,80,30/
C
C     DIMENSIONS OF ARRAYS LIMITING SIZE OF CASE HANDLED
C     LMTMJR = MAXIMUM NUMBER OF REQUESTS FOR ALL FIRMS
C     LMTSTD = MAXIMUM NUMBER OF STUDENTS
C     LMTRCT = MAXIMUM NUMBER OF RECRUITERS FOR ALL FIRMS
      DATA LMTMJR,LMTSTD,LMTRCT/
     1 5000,500,1000/
C
C     TELL USER WHAT PROGRAM THIS IS
      WRITE(ITTY,1)
    1 FORMAT(' JOBBIG'/
     1' Fast but large ranking program for interview signup system'/
     21X)
C
C     **********************************
C     *                                *
C     *  ASK FOR RANDOM NUMBER KERNEL  *
C     *                                *
C     **********************************
C
C     ESTABLISH RANDOM FUNCTION KERNEL
      WRITE(ITTY,2)
    2 FORMAT(' Base random sequence upon what kernel? ',$)
      READ(ITTY,3)KERNEL
    3 FORMAT(I)
      IF(KERNEL.LT.0)WRITE(ITTY,4)
    4 FORMAT(' Negative kernel indicates verification not real run')
      IF(KERNEL.GE.0)CALL SETRAN(KERNEL)
C
C     **************************************
C     *                                    *
C     *  READ THE ADMINISTRATOR FIRM FILE  *
C     *                                    *
C     **************************************
C
      WRITE(ITTY,5)
    5 FORMAT(' ***** Input files *****')
      CALL LCLOPN( 1,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      READ(IDISK,6)IAUTHR,ICLASS,JMOVE,JPASS,IVERSN,NUMADM
    6 FORMAT(6I)
      READ(IDISK,7)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
    7 FORMAT(8I)
      KNTRCT=0
      IF(KNTINC.LE.0)GO TO 16
      DO 15 NOWINC=1,KNTINC
      READ(IDISK,8)(LTRINC(I,NOWINC),I=1,LMTINC)
      READ(IDISK,9)(LTRDPT(I,NOWINC),I=1,LMTDPT)
      READ(IDISK,10)(LTRADR(I,NOWINC),I=1,LMTADR)
      READ(IDISK,11)NUMBER(NOWINC),LENGTH(NOWINC),
     1KNTOPN(NOWINC),INTRVW(NOWINC),IUSDUP(NOWINC),
     2INCLSD(NOWINC),JNCLSD(NOWINC)
    8 FORMAT(40A1)
    9 FORMAT(30A1)
   10 FORMAT(30A1)
   11 FORMAT(7I)
      LIMIT=INTRVW(NOWINC)
      IF(LIMIT.LE.0)GO TO 14
      DO 13 I=1,LIMIT
      KNTRCT=KNTRCT+1
      IF(KNTRCT.GT.LMTRCT)GO TO 16
      READ(IDISK,12)JDATE(KNTRCT),
     1JFIRST(KNTRCT),JFINAL(KNTRCT),JSCHDL(KNTRCT)
   12 FORMAT(4I)
   13 CONTINUE
   14 CONTINUE
   15 CONTINUE
   16 CALL LCLCLS( 1,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     CHECK THAT THIS WAS CORRECT VERSION OF FIRM FILE
      IF(IAUTHR.LT.1)GO TO 204
      IF(IAUTHR.GT.3)GO TO 204
      IF(IAUTHR.EQ.2)GO TO 202
      IF(IAUTHR.EQ.3)GO TO 202
      IF(KNTRCT.GT.LMTRCT)GO TO 214
C
C     STORE SOME STUFF NEEDED LATER
      JCLASS=ICLASS
      JVERSN=IVERSN
      IF(KNTINC.EQ.0)GO TO 200
      I=NUMBER(1)
      J=I
      DO 17 K=1,KNTINC
      IF(I.GT.NUMBER(K))I=NUMBER(K)
      IF(J.LT.NUMBER(K))J=NUMBER(K)
   17 CONTINUE
      WRITE(ITTY,18)I,J
   18 FORMAT(' Firms',1I5,' through',1I5,' are interviewing')
C
C     ***********************************
C     *                                 *
C     *  READ THE STUDENT REQUEST FILE  *
C     *                                 *
C     ***********************************
C
   19 CALL LCLOPN( 2,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ THE STUDENTS DECISION FILE
   20 MAXSTD=0
      KNTMJR=0
      KNTSTD=0
   21 MAXSTD=MAXSTD+1
      KNTSTD=KNTSTD+1
      READ(IDISK,22,END=37)IAUTHR,ICLASS,IMOVE,IPASS,
     1 IVERSN,NUMWHO,LTRPSW
      READ(IDISK,23)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,KNTALL,IGVBAK
   22 FORMAT(6I,20A1)
   23 FORMAT(7I)
      READ(IDISK,24)LTRWHO
   24 FORMAT(40A1)
      IF(MAXSTD.GT.LMTSTD)READ(IDISK,25)LTRNAM
      IF(MAXSTD.LE.LMTSTD)READ(IDISK,25)(LTRSTR(I,MAXSTD),I=1,LMTNAM)
   25 FORMAT(30A1)
      IF(KNTSIN.LE.0)GO TO 33
      DO 32 KOMPNY=1,KNTSIN
      READ(IDISK,26)NUMVOT,KNDVOT,KNTPRF,
     1IDATE,KLOSED,IRANK,JRANK,
     2KLOCK,MTIME,MDATE,MRECRT,ISOURC
   26 FORMAT(12I)
      IF(IMOVE.NE.JMOVE)GO TO 30
      IF(ISUBMT.EQ.4)GO TO 30
      IF(KLOSED.GT.1)GO TO 30
      IF(KNTINC.EQ.0)GO TO 28
      DO 27 I=1,KNTINC
      IF(NUMBER(I).EQ.NUMVOT)GO TO 29
   27 CONTINUE
   28 GO TO 30
   29 KNTMJR=KNTMJR+1
      IF(KNTMJR.GT.LMTMJR)GO TO 30
      MJRPNT(KNTMJR)=MAXSTD
      MJRFRM(KNTMJR)=NUMVOT
      MJRPRI(KNTMJR)=KNDVOT
      MJRRNK(KNTMJR)=IRANK
      MJRCLS(KNTMJR)=KLOSED
      MJRSRC(KNTMJR)=ISOURC
      MJRKLK(KNTMJR)=KLOCK
   30 CONTINUE
      LIMIT=KNTPRF
      IF(LIMIT.GT.0)READ(IDISK,31)(IPREFR(I),I=1,LIMIT)
   31 FORMAT(13I)
   32 CONTINUE
   33 READ(IDISK,34)LTREND
   34 FORMAT(1A1)
C
C     CHECK IF THIS WAS THE CORRECT VERSION OF DECISION FILE
      IF(LTREND.NE.LTRMIN)GO TO 194
      IF(IAUTHR.LT.11)GO TO 208
      IF(IAUTHR.GT.15)GO TO 208
      IF(IAUTHR.EQ.12)GO TO 206
      IF(IAUTHR.EQ.13)GO TO 206
      IF(ICLASS.NE.JCLASS)GO TO 210
      IF(IMANNR.NE.MANNER)GO TO 212
C
C     CHECK IF THIS STUDENT NEEDS TO BE INCLUDED IN NAME LIST
      IF(KNTMJR.LE.0)GO TO 35
      IF(KNTMJR.GT.LMTMJR)GO TO 36
      IF(MJRPNT(KNTMJR).EQ.MAXSTD)GO TO 36
   35 MAXSTD=MAXSTD-1
   36 GO TO 21
C
C     ALL DONE READING STUDENT DECISIONS
   37 CALL LCLCLS( 2,1,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      MAXSTD=MAXSTD-1
      KNTSTD=KNTSTD-1
      WRITE(ITTY,38)MAXSTD,KNTMJR
   38 FORMAT(
     1' ',1I4,' students requested a total of',1I5,' interviews')
      IF(KNTMJR.EQ.0)GO TO 192
      IF(KNTMJR.GT.LMTMJR)GO TO 198
      IF(MAXSTD.GT.LMTSTD)GO TO 196
C
C     ***********************
C     *                     *
C     *  SORT THE REQUESTS  *
C     *                     *
C     ***********************
C
C     START OF SORTING FOR ALGORITHMS THAT NEED RESORTING
   39 CONTINUE
C
C     OUTER LOOP OF SORTING
      DO 46 IOUTER=1,KNTMJR
      LOWEST=IOUTER
      LOWFRM=MJRFRM(LOWEST)
      LOWRNK=MJRRNK(LOWEST)
      LOWPRI=MJRPRI(LOWEST)
      LOWSTD=MJRPNT(LOWEST)
      DO 45 INNER=IOUTER,KNTMJR
C
C     SORT BY FIRM NUMBER
      IF(LOWFRM.LT.MJRFRM(INNER))GO TO 45
      IF(LOWFRM.GT.MJRFRM(INNER))GO TO 44
C
C     SORT BY RANKING IN FIRST STAGE
C     NOTE THAT RANK ZERO SORTS ABOVE ANY POSITIVE VALUE
      IF(LOWRNK.GT.0)GO TO 40
      IF(MJRRNK(INNER).GT.0)GO TO 44
C     NEITHER REQUEST HAS BEEN RANKED
      GO TO 41
   40 IF(MJRRNK(INNER).EQ.0)GO TO 45
C     BOTH INTERVIEWS ALREADY RANKED
      IF(LOWRNK.LT.MJRRNK(INNER))GO TO 45
      IF(LOWRNK.GT.MJRRNK(INNER))GO TO 44
C
C     SORT BY PRIORITY
   41 IF(MANNER.GT.20)GO TO 42
      IF(LOWPRI.LT.MJRPRI(INNER))GO TO 45
      IF(LOWPRI.GT.MJRPRI(INNER))GO TO 44
      GO TO 43
   42 IF(LOWPRI.GT.MJRPRI(INNER))GO TO 45
      IF(LOWPRI.LT.MJRPRI(INNER))GO TO 44
      GO TO 43
C
C     SORT BY STUDENT NUMBER
   43 IF(LOWSTD.LT.MJRPNT(INNER))GO TO 45
      IF(LOWSTD.GT.MJRPNT(INNER))GO TO 44
   44 LOWEST=INNER
      LOWFRM=MJRFRM(LOWEST)
      LOWRNK=MJRRNK(LOWEST)
      LOWPRI=MJRPRI(LOWEST)
      LOWSTD=MJRPNT(LOWEST)
   45 CONTINUE
      IF(LOWEST.EQ.IOUTER)GO TO 46
C
C     EXCHANGE STUDENT NUMBER
      ISAVE=MJRPNT(LOWEST)
      MJRPNT(LOWEST)=MJRPNT(IOUTER)
      MJRPNT(IOUTER)=ISAVE
C
C     EXCHANGE FIRM NUMBER
      ISAVE=MJRFRM(LOWEST)
      MJRFRM(LOWEST)=MJRFRM(IOUTER)
      MJRFRM(IOUTER)=ISAVE
C
C     EXCHANGE RANKING
      ISAVE=MJRRNK(LOWEST)
      MJRRNK(LOWEST)=MJRRNK(IOUTER)
      MJRRNK(IOUTER)=ISAVE
C
C     EXCHANGE PRIORITY
      ISAVE=MJRPRI(LOWEST)
      MJRPRI(LOWEST)=MJRPRI(IOUTER)
      MJRPRI(IOUTER)=ISAVE
C
C     EXCHANGE BEING PLACED ON CLOSED SCHEDULE
      ISAVE=MJRCLS(LOWEST)
      MJRCLS(LOWEST)=MJRCLS(IOUTER)
      MJRCLS(IOUTER)=ISAVE
C
C     EXCHANGE SOURCE OF REQUEST
      ISAVE=MJRSRC(LOWEST)
      MJRSRC(LOWEST)=MJRSRC(IOUTER)
      MJRSRC(IOUTER)=ISAVE
C
C     EXCHANGE IF ALREADY ASSIGNED INTERVIEW
      ISAVE=MJRKLK(LOWEST)
      MJRKLK(LOWEST)=MJRKLK(IOUTER)
      MJRKLK(IOUTER)=ISAVE
   46 CONTINUE
C
C     *****************************************
C     *                                       *
C     *  ASSIGN RANKINGS TO THE NEW REQUESTS  *
C     *                                       *
C     *****************************************
C
      IF(MANNER.NE.1)GO TO 69
C
C     *********************************************
C     *                                           *
C     *  PRIORITY TYPE 1                          *
C     *  ONE PRIORITY CLASS PER ALLOWED REQUEST   *
C     *  WASTED PRIORITY BUMPS ALL THOS BELOW UP  *
C     *                                           *
C     *********************************************
C
C     IF PERSON CAN MAKE 6 REQUESTS, HE CAN ASSIGNE PRIORITY VALUES
C     OF 2,4,6,8,10 AND 12.   IF HE DOES NOT GET ANY REQUEST,
C     THEN ALL THOSE LOWER GET BUMPED UP BY 1.  IF HE DID NOT GET
C     FIRST CHOICE (VALUE 2), THEN THE 4 BECOMES 2, THE 6 BECOMES 5,
C     ETC.  IF HE DOES NOT GET HIS SECOND CHOICE EITHER, THEN THE
C     PRIORITY WHICH WAS ORIGINALLY 6 BECOMES A 4, THE 8 BECOMES 6, ETC.
C
C     FIND THE MAXIMUM VALUE OF PRIORITY IN NEW REQUESTS
   47 NOWPRI=0
      IAGAIN=0
   48 IF(IAGAIN.NE.0)GO TO 39
C
C     FIND THE NEXT HIGHER VALUE OF THE PRIORITY
      MINMUM=0
      INIREQ=0
   49 INIREQ=INIREQ+1
      IF(INIREQ.GT.KNTMJR)GO TO 51
      IF(MJRRNK(INIREQ).NE.0)GO TO 49
      IF(MJRPRI(INIREQ).LE.NOWPRI)GO TO 49
      IF(MINMUM.EQ.0)GO TO 50
      IF(MJRPRI(INIREQ).GE.MINMUM)GO TO 49
   50 MINMUM=MJRPRI(INIREQ)
      GO TO 49
   51 IF(MINMUM.EQ.0)GO TO 68
      NOWPRI=MINMUM
C
C     FIND START AND END OF CURRENT FIRM
      LSTREQ=0
   52 INIREQ=LSTREQ+1
      IF(INIREQ.GT.KNTMJR)GO TO 48
   53 LSTREQ=LSTREQ+1
      IF(LSTREQ.GT.KNTMJR)GO TO 54
      IF(MJRFRM(INIREQ).EQ.MJRFRM(LSTREQ))GO TO 53
   54 LSTREQ=LSTREQ-1
C
C     FIND START OF THE UNRANKED REQUESTS FOR THIS FIRM
      LMTRNK=INIREQ
      IOFFST=MJRRNK(INIREQ)
   55 IF(LMTRNK.GT.LSTREQ)GO TO 67
      IF(MJRRNK(LMTRNK).EQ.0)GO TO 57
      LMTRNK=LMTRNK+1
      IF(IOFFST.LT.MJRRNK(LMTRNK))IOFFST=MJRRNK(LMTRNK)
      GO TO 55
C
C     FIND START OF CURRENT PRIORITY VALUE
   56 LMTRNK=LMTRNK+1
   57 IF(LMTRNK.GT.LSTREQ)GO TO 67
      IF(MJRPRI(LMTRNK).NE.NOWPRI)GO TO 56
C
C     FIND END OF CURRENT PRIORITY VALUE
      INIRNK=LMTRNK
   58 LMTRNK=LMTRNK+1
      IF(LMTRNK.GT.LSTREQ)GO TO 59
      IF(MJRPRI(LMTRNK).EQ.NOWPRI)GO TO 58
   59 LMTRNK=LMTRNK-1
C
C     ASSIGN RANDOM VALUES TO THE UNRANKED REQUESTS
      CALL RANK(KERNEL,MJRRNK,INIRNK,LMTRNK,IOFFST)
C
C     SORT THE REQUESTS BY RANK
      DO 62 IOUTER=INIRNK,LMTRNK
      LOWEST=IOUTER
      LOWRNK=MJRRNK(LOWEST)
      DO 61 INNER=IOUTER,LMTRNK
      IF(LOWRNK.LT.MJRRNK(INNER))GO TO 61
      IF(LOWRNK.GT.MJRRNK(INNER))GO TO 60
   60 LOWEST=INNER
      LOWFRM=MJRFRM(LOWEST)
      LOWRNK=MJRRNK(LOWEST)
      LOWPRI=MJRPRI(LOWEST)
      LOWSTD=MJRPNT(LOWEST)
   61 CONTINUE
      IF(LOWEST.EQ.IOUTER)GO TO 62
C
C     EXCHANGE STUDENT NUMBER
      ISAVE=MJRPNT(LOWEST)
      MJRPNT(LOWEST)=MJRPNT(IOUTER)
      MJRPNT(IOUTER)=ISAVE
C
C     EXCHANGE FIRM NUMBER
      ISAVE=MJRFRM(LOWEST)
      MJRFRM(LOWEST)=MJRFRM(IOUTER)
      MJRFRM(IOUTER)=ISAVE
C
C     EXCHANGE RANKING
      ISAVE=MJRRNK(LOWEST)
      MJRRNK(LOWEST)=MJRRNK(IOUTER)
      MJRRNK(IOUTER)=ISAVE
C
C     EXCHANGE PRIORITY
      ISAVE=MJRPRI(LOWEST)
      MJRPRI(LOWEST)=MJRPRI(IOUTER)
      MJRPRI(IOUTER)=ISAVE
C
C     EXCHANGE BEING PLACED ON CLOSED SCHEDULE
      ISAVE=MJRCLS(LOWEST)
      MJRCLS(LOWEST)=MJRCLS(IOUTER)
      MJRCLS(IOUTER)=ISAVE
C
C     EXCHANGE SOURCE OF REQUEST
      ISAVE=MJRSRC(LOWEST)
      MJRSRC(LOWEST)=MJRSRC(IOUTER)
      MJRSRC(IOUTER)=ISAVE
C
C     EXCHANGE IF ALREADY ASSIGNED INTERVIEW
      ISAVE=MJRKLK(LOWEST)
      MJRKLK(LOWEST)=MJRKLK(IOUTER)
      MJRKLK(IOUTER)=ISAVE
   62 CONTINUE
C
C     LOCATE THE FIRM IN ADMINISTRATOR DATA
      LOCATN=0
   63 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTINC)GO TO 67
      IF(NUMBER(LOCATN).NE.MJRFRM(INIRNK))GO TO 63
C
C     DETERMINE WHETHER ANY STUDENTS DID NOT GET CHOICE
      K=0
      NOWRNK=INIREQ-1
   64 NOWRNK=NOWRNK+1
      IF(NOWRNK.GT.LMTRNK)GO TO 67
      IF(MJRCLS(NOWRNK).EQ.0)K=K+1
      IF(K.LE.KNTOPN(LOCATN))GO TO 64
      DO 66 I=1,KNTMJR
      IF(MJRRNK(I).NE.0)GO TO 66
      IF(MJRPRI(I).LE.NOWPRI)GO TO 66
      J=MJRPNT(I)
      IF(NOWRNK.LT.INIRNK)NOWRNK=INIRNK
      DO 65 K=NOWRNK,LMTRNK
      IF(J.NE.MJRPNT(K))GO TO 65
C     FOLLOWING STATEMENT ADJUSTS ALL YET UNFILLED PRIORITIES
C     FOR A STUDENT WHICH FAILED TO GET THE CURRENT FIRM.
C     THE ADJUSTMENT MUST BE LESS, NOT EQUAL TO, 10.
      MJRPRI(I)=MJRPRI(I)-6
      IAGAIN=1
      GO TO 66
   65 CONTINUE
   66 CONTINUE
   67 CONTINUE
      GO TO 52
   68 CONTINUE
      GO TO 79
C
C     **********************************************
C     *                                            *
C     *  OTHER PRIORITY TYPES                      *
C     *  SEVERAL PRIORITY CLASSES                  *
C     *  NO COMPENSATION FOR WASTED HIGH PRIORITY  *
C     *                                            *
C     **********************************************
C
C     FIND START AND END OF CURRENT FIRM
   69 LSTREQ=0
   70 INIREQ=LSTREQ+1
   71 LSTREQ=LSTREQ+1
      IF(LSTREQ.GT.KNTMJR)GO TO 72
      IF(MJRFRM(INIREQ).EQ.MJRFRM(LSTREQ))GO TO 71
   72 LSTREQ=LSTREQ-1
C
C     FIND START OF THE UNRANKED REQUESTS FOR THIS FIRM
      LMTRNK=INIREQ
      IOFFST=MJRRNK(INIREQ)
   73 IF(LMTRNK.GT.LSTREQ)GO TO 78
      IF(MJRRNK(LMTRNK).EQ.0)GO TO 75
      LMTRNK=LMTRNK+1
      IF(IOFFST.LT.MJRRNK(LMTRNK))IOFFST=MJRRNK(LMTRNK)
      GO TO 73
C
C     FIND START AND END OF SAME PRIORITY VALUE
   74 LMTRNK=LMTRNK+1
   75 INIRNK=LMTRNK
   76 LMTRNK=LMTRNK+1
      IF(LMTRNK.GT.LSTREQ)GO TO 77
      IF(MJRPRI(INIRNK).EQ.MJRPRI(LMTRNK))GO TO 76
   77 LMTRNK=LMTRNK-1
C
C     ASSIGN RANDOM VALUES TO THE UNRANKED REQUESTS
      CALL RANK(KERNEL,MJRRNK,INIRNK,LMTRNK,IOFFST)
      IOFFST=IOFFST+LMTRNK-INIRNK+1
      IF(LMTRNK.LT.LSTREQ)GO TO 74
   78 CONTINUE
      IF(LSTREQ.LT.KNTMJR)GO TO 70
C
C     ***********************************
C     *                                 *
C     *  SORT THE REQUESTS BY RANKINGS  *
C     *                                 *
C     ***********************************
C
C     FIND START AND END OF CURRENT FIRM
   79 LSTREQ=0
   80 INIREQ=LSTREQ+1
   81 LSTREQ=LSTREQ+1
      IF(LSTREQ.GT.KNTMJR)GO TO 82
      IF(MJRFRM(INIREQ).EQ.MJRFRM(LSTREQ))GO TO 81
   82 LSTREQ=LSTREQ-1
C
C     SORT THE REQUESTS BY RANK
      DO 85 IOUTER=INIREQ,LSTREQ
      LOWEST=IOUTER
      LOWRNK=MJRRNK(LOWEST)
      DO 84 INNER=IOUTER,LSTREQ
      IF(LOWRNK.LT.MJRRNK(INNER))GO TO 84
      IF(LOWRNK.GT.MJRRNK(INNER))GO TO 83
   83 LOWEST=INNER
      LOWFRM=MJRFRM(LOWEST)
      LOWRNK=MJRRNK(LOWEST)
      LOWPRI=MJRPRI(LOWEST)
      LOWSTD=MJRPNT(LOWEST)
   84 CONTINUE
      IF(LOWEST.EQ.IOUTER)GO TO 85
C
C     EXCHANGE STUDENT NUMBER
      ISAVE=MJRPNT(LOWEST)
      MJRPNT(LOWEST)=MJRPNT(IOUTER)
      MJRPNT(IOUTER)=ISAVE
C
C     EXCHANGE FIRM NUMBER
      ISAVE=MJRFRM(LOWEST)
      MJRFRM(LOWEST)=MJRFRM(IOUTER)
      MJRFRM(IOUTER)=ISAVE
C
C     EXCHANGE RANKING
      ISAVE=MJRRNK(LOWEST)
      MJRRNK(LOWEST)=MJRRNK(IOUTER)
      MJRRNK(IOUTER)=ISAVE
C
C     EXCHANGE PRIORITY
      ISAVE=MJRPRI(LOWEST)
      MJRPRI(LOWEST)=MJRPRI(IOUTER)
      MJRPRI(IOUTER)=ISAVE
C
C     EXCHANGE BEING PLACED ON CLOSED SCHEDULE
      ISAVE=MJRCLS(LOWEST)
      MJRCLS(LOWEST)=MJRCLS(IOUTER)
      MJRCLS(IOUTER)=ISAVE
C
C     EXCHANGE SOURCE OF REQUEST
      ISAVE=MJRSRC(LOWEST)
      MJRSRC(LOWEST)=MJRSRC(IOUTER)
      MJRSRC(IOUTER)=ISAVE
C
C     EXCHANGE IF ALREADY ASSIGNED INTERVIEW
      ISAVE=MJRKLK(LOWEST)
      MJRKLK(LOWEST)=MJRKLK(IOUTER)
      MJRKLK(IOUTER)=ISAVE
   85 CONTINUE
C
C     ITEM SORTED
      IF(LSTREQ.LT.KNTMJR)GO TO 80
C
C     **********************************
C     *                                *
C     *  COUNT REQUESTS FOR EACH FIRM  *
C     *                                *
C     **********************************
C
C     INITIALIZE LOCATION IN ARRAY
      LSTREQ=0
      LSTFRM=0
      IF(KNTINC.GT.0)LSTFRM=NUMBER(1)-1
      LOOP=0
C
C     FIND START AND END OF CURRENT FIRM
   86 INIREQ=LSTREQ+1
      LSTFRM=LSTFRM+1
      IF(INIREQ.GT.KNTMJR)GO TO 89
      IF(MJRFRM(INIREQ).NE.LSTFRM)GO TO 89
   87 LSTREQ=LSTREQ+1
      IF(LSTREQ.GT.KNTMJR)GO TO 88
      IF(LSTFRM.EQ.MJRFRM(LSTREQ))GO TO 87
   88 LSTREQ=LSTREQ-1
C
C     LOCATE THE FIRM IN ADMINISTRATOR DATA
   89 LOCATN=0
   90 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTINC)GO TO 97
      IF(NUMBER(LOCATN).NE.LSTFRM)GO TO 90
      LOOP=LOOP+1
C
C     NUMBER OF STUDENTS WHO REQUESTED INTERVIEWS
      IUSDUP(LOCATN)=LSTREQ-INIREQ+1
C
C     NUMBER OF STUDENTS WHO ARE IN CLOSED SCHEDULE
      J=0
      IF(INIREQ.GT.LSTREQ)GO TO 92
      DO 91 I=INIREQ,LSTREQ
      IF(MJRCLS(I).NE.0)J=J+1
   91 CONTINUE
   92 INCLSD(LOCATN)=J
C
C     NUMBER OF STUDENTS ABOVE LINE WHO ARE IN CLOSED SCHEDULE
      J=0
      K=0
      IF(INIREQ.GT.LSTREQ)GO TO 94
      DO 93 I=INIREQ,LSTREQ
      IF(K.GE.KNTOPN(LOCATN))GO TO 94
      IF(MJRCLS(I).EQ.0)K=K+1
      IF(MJRCLS(I).NE.0)J=J+1
   93 CONTINUE
   94 JNCLSD(LOCATN)=J
C
C     MAKE SURE RANKING IS CONTINUOUS
      IF(INIREQ.GT.LSTREQ)GO TO 96
      J=0
      DO 95 I=INIREQ,LSTREQ
      J=J+1
      MJRRNK(I)=J
   95 CONTINUE
   96 CONTINUE
C
C     DONE WITH THIS FIRM
   97 CONTINUE
      IF(LOOP.LT.KNTINC)GO TO 86
C
C     ***********************************
C     *                                 *
C     *  LIST STUDENTS BY RANK IN FIRM  *
C     *                                 *
C     ***********************************
C
C     OPEN LISTING FILE
      WRITE(ITTY,98)
   98 FORMAT(' ***** Output files *****')
      CALL TTYSIM(JDISK)
      CALL LCLOPN( 4,1,2,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     GET THE CURRENT DATE AND TIME
      CALL TSTAMP(LTRTIM)
C
C     RECORD WHAT THE RANDOM NUMBER KERNEL WAS
      WRITE(JDISK,99)KERNEL
   99 FORMAT(' Kernel for random number generator',1I12)
      WRITE(JDISK,100)LTRTIM
  100 FORMAT(' (printed ',15A1,')')
C
C     INITIALIZE LOCATION IN ARRAY
      LOCATN=0
      LOCDAT=0
C
C     FIND START AND END OF CURRENT FIRM IN SCHEDULE DATA
  101 LOCATN=LOCATN+1
      IF(LOCATN.GT.KNTINC)GO TO 147
      INIDAT=LOCDAT+1
      LOCDAT=LOCDAT+INTRVW(LOCATN)
      LSTFRM=NUMBER(LOCATN)
C
C     FIND START AND END OF CURRENT FIRM IN REQUESTS
      LSTREQ=0
      INIREQ=0
  102 INIREQ=INIREQ+1
      IF(INIREQ.GT.KNTMJR)GO TO 104
      IF(MJRFRM(INIREQ).NE.LSTFRM)GO TO 102
      LSTREQ=INIREQ
  103 IF(LSTREQ.GE.KNTMJR)GO TO 104
      IF(MJRFRM(LSTREQ+1).NE.LSTFRM)GO TO 104
      LSTREQ=LSTREQ+1
      GO TO 103
C
C     WRITE THE TABLE FOR CURRENT FIRM
  104 NOWREQ=INIREQ-1
      KNTLIN=-1
      LMTLIN=KNTOPN(LOCATN)+INCLSD(LOCATN)
      IF(LMTLIN.LT.IUSDUP(LOCATN))LMTLIN=IUSDUP(LOCATN)
      LMTLIN=LMTLIN+1
      NOWLIN=0
      MRKLIN=KNTOPN(LOCATN)+JNCLSD(LOCATN)+1
      KANCEL=0
      ISLOT=0
      I=NOWREQ+MRKLIN
      J=NOWREQ+IUSDUP(LOCATN)
  105 IF(I.GT.J)GO TO 107
      IF(MJRKLK(I).EQ.0)GO TO 106
      KANCEL=KANCEL+1
      MRKLIN=I-NOWREQ+1
  106 I=I+1
      GO TO 105
  107 DO 142 NEWLIN=1,LMTLIN
      IF(KNTLIN.GT.0)GO TO 123
      IF(KNTLIN.EQ.0)WRITE(JDISK,108)JCLASS,JMOVE,JPASS,LTRTIM
  108 FORMAT(1X/
     1' * by name indicates student was invited to closed schedule'/
     2' - by name indicates student was invited, but is shown',
     3' on open schedule'/
     4' Class',1I5,', Round',1I3,', Stage',1I3,
     5' (printed ',15A1,')')
      WRITE(JDISK,109)LSTFRM,(LTRINC(I,LOCATN),I=1,LMTINC)
  109 FORMAT('1Code:',1I10,' Firm: ',40A1)
C
C     CONSTRUCT DATE IN FORM DD-MMM-YY
      LOWBFR=0
      ISMITH=0
      JSMITH=0
      IF(KNTOPN(LOCATN).LE.0)GO TO 112
      DO 111 I=INIDAT,LOCDAT
      IF(JDATE(I).LT.0)GO TO 111
      IF(JFIRST(I).LT.0)GO TO 111
      IF(ISMITH.EQ.0)GO TO 110
      IF(ISMITH.GT.JDATE(I))ISMITH=JDATE(I)
      IF(JSMITH.LT.JDATE(I))JSMITH=JDATE(I)
      GO TO 111
  110 ISMITH=JDATE(I)
      JSMITH=ISMITH
  111 CONTINUE
      IF(ISMITH.EQ.0)GO TO 112
      CALL DAWHEN(ISMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
      IF(ISMITH.EQ.JSMITH)GO TO 112
      CALL DAWHEN(JSMITH,NDAY,NMONTH,NYEAR,LTRBFR,LOWBFR,LMTBFR)
  112 CONTINUE
C
      IF(ISMITH.NE.JSMITH)GO TO 118
      IF(ISMITH.NE.0)GO TO 115
C
C     CANCELLED
      WRITE(JDISK,113)(LTRDPT(I,LOCATN),I=1,LMTDPT)
  113 FORMAT(' Date: CANCELLED Dept: ',40A1)
      WRITE(JDISK,114)(LTRADR(I,LOCATN),I=1,LMTADR)
  114 FORMAT(' ',15X,' Adrs: ',40A1)
      GO TO 121
C
C     SINGLE DATE
  115 WRITE(JDISK,116)(LTRBFR(I),I=1,9),(LTRDPT(I,LOCATN),I=1,LMTDPT)
  116 FORMAT(' Date: ',9A1,' Dept: ',40A1)
      WRITE(JDISK,117)(LTRADR(I,LOCATN),I=1,LMTADR)
  117 FORMAT(' ',15X,' Adrs: ',40A1)
      GO TO 121
C
C     RANGE OF DATES
  118 WRITE(JDISK,119)(LTRBFR(I),I=1,9),(LTRDPT(I,LOCATN),I=1,LMTDPT)
  119 FORMAT(' Date: ',9A1,' Dept: ',40A1)
      WRITE(JDISK,120)(LTRBFR(I),I=10,18),(LTRADR(I,LOCATN),I=1,LMTADR)
  120 FORMAT('   to: ',9A1,' Adrs: ',40A1)
  121 CONTINUE
C
C     ADDRESS
      WRITE(JDISK,122)
  122 FORMAT(1X)
C     FULL NUMBER OF LINES ON PAGE
      KNTLIN=62
C     REDUCE FOR HEADER
      KNTLIN=KNTLIN-4
C     REDUCE FOR TRAILER
      KNTLIN=KNTLIN-4
  123 KNTLIN=KNTLIN-1
      IF(NEWLIN.EQ.MRKLIN)GO TO 139
      NOWLIN=NOWLIN+1
      NOWREQ=NOWREQ+1
      IF(NOWREQ.GT.LSTREQ)GO TO 137
      NOWSTD=MJRPNT(NOWREQ)
      NOWPRI=MJRPRI(NOWREQ)
      LNGNAM=LMTNAM
  124 IF(LTRSTR(LNGNAM,NOWSTD).NE.LTRSPA)GO TO 125
      LNGNAM=LNGNAM-1
      IF(LNGNAM.GT.1)GO TO 124
  125 LTRNOW=LTRSPA
      IF(MJRSRC(NOWREQ).NE.0)LTRNOW=LTRMIN
      IF(MJRCLS(NOWREQ).NE.0)LTRNOW=LTRSTA
      IF(MANNER.GT.20)GO TO 133
      IF(MANNER.GT.10)GO TO 129
C
C     PRIORITY VALUE 1.0 THROUGH N.0
      IONE=NOWPRI/10
      ITWO=NOWPRI-(10*IONE)
      IF(NEWLIN.GT.MRKLIN)GO TO 127
      IF(MJRCLS(NOWREQ).NE.0)GO TO 127
      ISLOT=ISLOT+1
      WRITE(JDISK,126)ISLOT,IONE,ITWO,LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  126 FORMAT(1X,1I5,1I3,'.',1I1,1X,1A1,30A1)
      GO TO 142
  127 WRITE(JDISK,128)IONE,ITWO,LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  128 FORMAT(1X,5X,1I3,'.',1I1,1X,1A1,30A1)
      GO TO 142
C
C     PRIORITY TYPES A AND B
  129 IF(NEWLIN.GT.MRKLIN)GO TO 131
      IF(MJRCLS(NOWREQ).NE.0)GO TO 131
      ISLOT=ISLOT+1
      WRITE(JDISK,130)ISLOT,LTRPRI(NOWPRI),LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  130 FORMAT(1X,1I5,2X,1A1,1X,1A1,30A1)
      GO TO 142
  131 WRITE(JDISK,132)LTRPRI(NOWPRI),LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  132 FORMAT(1X,5X,2X,1A1,1X,1A1,30A1)
      GO TO 142
C
C     BIDS 0 AND UP
  133 IF(NEWLIN.GT.MRKLIN)GO TO 135
      IF(MJRCLS(NOWREQ).NE.0)GO TO 135
      ISLOT=ISLOT+1
      WRITE(JDISK,134)ISLOT,NOWPRI,LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  134 FORMAT(1X,1I5,1I10,1X,1A1,30A1)
      GO TO 142
  135 WRITE(JDISK,136)NOWPRI,LTRNOW,
     1(LTRSTR(I,NOWSTD),I=1,LNGNAM)
  136 FORMAT(1X,5X,1I10,1X,1A1,30A1)
      GO TO 142
C
C     UNUSED SLOT
  137 ISLOT=ISLOT+1
      WRITE(JDISK,138)ISLOT
  138 FORMAT(1X,1I5)
      GO TO 142
C
C     DIVIDING LINE
  139 IF(KANCEL.EQ.0)WRITE(JDISK,140)
      IF(KANCEL.GT.0)WRITE(JDISK,141)KANCEL
  140 FORMAT(' ',10X,'---------------')
  141 FORMAT(' ',10X,'---------------',1I6,' of above ar',
     1'e on cancelled schedules')
  142 CONTINUE
C
C     SPACE DOWN TO DATE AT BOTTOM OF PAGE
  143 IF(KNTLIN.LE.0)GO TO 145
      KNTLIN=KNTLIN-1
      WRITE(JDISK,144)
  144 FORMAT(1X)
      GO TO 143
  145 WRITE(JDISK,108)JCLASS,JMOVE,JPASS,LTRTIM
  146 CONTINUE
      GO TO 101
  147 WRITE(JDISK,148)
  148 FORMAT(1H1,'END')
      CALL LCLCLS( 4,1,2,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     ***************************************
C     *                                     *
C     *  WRITE THE ADMINISTRATOR FIRM FILE  *
C     *                                     *
C     ***************************************
C
      CALL LCLOPN( 5,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      IVERSN=JVERSN+1
      ICLASS=JCLASS
      IAUTHR=2
      WRITE(KDISK,149)IAUTHR,ICLASS,JMOVE,JPASS,IVERSN,NUMADM
  149 FORMAT(5I6,1I7)
      WRITE(KDISK,150)KNTINC,MAXNUM,MANNER,MAXSTG,MAXRND,
     1 MAXALL,MAXBID,MAXPAY
  150 FORMAT(6I6,2I10)
      IF(KNTINC.LE.0)GO TO 159
      LOCDAT=0
      DO 158 NOWINC=1,KNTINC
      WRITE(KDISK,151)(LTRINC(I,NOWINC),I=1,LMTINC)
      WRITE(KDISK,152)(LTRDPT(I,NOWINC),I=1,LMTDPT)
      WRITE(KDISK,153)(LTRADR(I,NOWINC),I=1,LMTADR)
      WRITE(KDISK,154)NUMBER(NOWINC),LENGTH(NOWINC),
     1KNTOPN(NOWINC),INTRVW(NOWINC),IUSDUP(NOWINC),
     2INCLSD(NOWINC),JNCLSD(NOWINC)
  151 FORMAT(40A1)
  152 FORMAT(30A1)
  153 FORMAT(30A1)
  154 FORMAT(7I6)
      INIDAT=LOCDAT+1
      LOCDAT=LOCDAT+INTRVW(NOWINC)
      IF(INIDAT.GT.LOCDAT)GO TO 157
      DO 156 I=INIDAT,LOCDAT
      WRITE(KDISK,155)JDATE(I),
     1JFIRST(I),JFINAL(I),JSCHDL(I)
  155 FORMAT(4I6)
  156 CONTINUE
  157 CONTINUE
  158 CONTINUE
  159 CALL LCLCLS( 5,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     ************************************
C     *                                  *
C     *  WRITE THE STUDENT REQUEST FILE  *
C     *                                  *
C     ************************************
C
C     OPEN THE ORIGINAL STUDENT FILE
      CALL LCLOPN( 2,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     OPEN THE NEW STUDENT FILE
      CALL LCLOPN( 6,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ THE STUDENTS DECISION FILE
      NOWSTD=0
      LCLSTD=0
  160 NOWSTD=NOWSTD+1
      LCLSTD=LCLSTD+1
      IF(LCLSTD.GT.KNTSTD)GO TO 178
      READ(IDISK,161)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,LTRPSW
      READ(IDISK,162)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,KNTALL,IGVBAK
  161 FORMAT(6I,20A1)
  162 FORMAT(7I)
C
C     COPY THE HEADER INFORMATION FOR THIS STUDENT
      IAUTHR=12
      LOCKUP=KNTSIN
      IF(ISUBMT.LE.1)ISUBMT=2
      WRITE(KDISK,163)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,LTRPSW
      WRITE(KDISK,164)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,KNTALL,IGVBAK
  163 FORMAT(5I6,1I7,1X,20A1)
  164 FORMAT(1I6,1I10,4I6,1I10)
      READ(IDISK,165)LTRWHO
      WRITE(KDISK,165)LTRWHO
  165 FORMAT(40A1)
      READ(IDISK,166)LTRNAM
      WRITE(KDISK,166)LTRNAM
  166 FORMAT(30A1)
C
C     COPY THE REQUESTS FOR THIS STUDENT, UPDATING THEM
      NOWMJR=0
      IF(KNTSIN.LE.0)GO TO 176
      DO 175 KOMPNY=1,KNTSIN
      READ(IDISK,167)NUMVOT,KNDVOT,KNTPRF,
     1IDATE,KLOSED,IRANK,JRANK,
     2KLOCK,MTIME,MDATE,MRECRT,ISOURC
  167 FORMAT(12I)
      IF(IMOVE.NE.JMOVE)GO TO 171
      IF(ISUBMT.EQ.4)GO TO 171
      IF(KLOSED.GT.1)GO TO 171
C
C     LOCATE STUDENT RANKING FOR THIS COMPANY
      INIREQ=0
  168 INIREQ=INIREQ+1
      IF(INIREQ.GT.KNTMJR)GO TO 171
      IF(MJRFRM(INIREQ).NE.NUMVOT)GO TO 168
      K=0
      IRANK=0
      JRANK=0
  169 IF(INIREQ.GT.KNTMJR)GO TO 171
      IF(MJRFRM(INIREQ).NE.NUMVOT)GO TO 171
      IF(MJRCLS(INIREQ).EQ.0)K=K+1
      IF(MJRPNT(INIREQ).EQ.NOWSTD)GO TO 170
      INIREQ=INIREQ+1
      GO TO 169
  170 IRANK=MJRRNK(INIREQ)
      JRANK=K
      KNDVOT=MJRPRI(INIREQ)
      NOWMJR=1
  171 CONTINUE
C
C     WRITE THE NEW LINE FOR THIS COMPANY
      WRITE(KDISK,172)NUMVOT,KNDVOT,KNTPRF,
     1IDATE,KLOSED,IRANK,JRANK,
     2KLOCK,MTIME,MDATE,MRECRT,ISOURC
  172 FORMAT(1I6,1I10,10I6)
      LIMIT=KNTPRF
      IF(LIMIT.LE.0)GO TO 175
      READ(IDISK,173)(IPREFR(I),I=1,LIMIT)
  173 FORMAT(13I)
      WRITE(KDISK,174)(IPREFR(I),I=1,LIMIT)
  174 FORMAT(13I6)
  175 CONTINUE
C
C     COPY THE - AT END OF STUDENT ENTRY
  176 READ(IDISK,177)LTREND
      WRITE(KDISK,177)LTREND
  177 FORMAT(1A1)
C
C     DETERMINE IF THIS STUDENT NOT INCLUDED IN NAMES
      IF(NOWMJR.EQ.0)NOWSTD=NOWSTD-1
      GO TO 160
  178 CONTINUE
      CALL LCLCLS( 2,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 6,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     *********************************
C     *                               *
C     *  WRITE LIST OF STUDENT NAMES  *
C     *                               *
C     *********************************
C
      CALL LCLOPN( 7,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     GET NAME OF INPUT FILE
      CALL LCLOPN( 2,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
C
C     READ THE STUDENTS DECISION FILE
      WRITE(KDISK,179)JCLASS,JMOVE,JPASS,LTRTIM
  179 FORMAT(' Class',1I5,', Round',1I3,', Stage',1I3,
     1' (printed ',15A1,')'/1X)
      NOWSTD=0
  180 NOWSTD=NOWSTD+1
      IF(NOWSTD.GT.KNTSTD)GO TO 191
      READ(IDISK,181)IAUTHR,ICLASS,IMOVE,IPASS,IVERSN,NUMWHO,LTRPSW
      READ(IDISK,182)ISUBMT,IUSED,KNTSIN,LOCKUP,IMANNR,KNTALL,IGVBAK
  181 FORMAT(6I,20A1)
  182 FORMAT(7I)
      READ(IDISK,183)LTRWHO
  183 FORMAT(40A1)
      READ(IDISK,184)LTRNAM
  184 FORMAT(30A1)
      IF(ISUBMT.NE.4)WRITE(KDISK,185)NUMWHO,LTRNAM,LTRPSW
  185 FORMAT(1X,1I6,1X,30A1,20A1)
C
C     SPACE DOWN OVER REQUESTS FOR THIS STUDENT
      IF(KNTSIN.LE.0)GO TO 189
      DO 188 KOMPNY=1,KNTSIN
      READ(IDISK,186)NUMVOT,KNDVOT,KNTPRF,
     1IDATE,KLOSED,IRANK,JRANK,
     2KLOCK,MTIME,MDATE,MRECRT,ISOURC
  186 FORMAT(12I)
      LIMIT=KNTPRF
      IF(LIMIT.LE.0)GO TO 188
      READ(IDISK,187)(IPREFR(I),I=1,LIMIT)
  187 FORMAT(13I)
  188 CONTINUE
C
C     READ THE - AT END OF STUDENT ENTRY
  189 READ(IDISK,190)LTREND
  190 FORMAT(1A1)
      GO TO 180
  191 CONTINUE
      CALL LCLCLS( 7,1,3,ITTY,IDISK,JDISK,KDISK,LDISK)
      CALL LCLCLS( 2,0,1,ITTY,IDISK,JDISK,KDISK,LDISK)
      GO TO 216
C
C     ********************
C     *                  *
C     *  ERROR MESSAGES  *
C     *                  *
C     ********************
C
  192 WRITE(ITTY,193)
  193 FORMAT(' No students have requested interviews in this round')
      GO TO 216
  194 WRITE(ITTY,195)KNTSTD
  195 FORMAT(' Composite request file not correctly term',
     1'inated for student',1I4)
      GO TO 216
  196 WRITE(ITTY,197)LMTSTD,MAXSTD
  197 FORMAT(
     1' Increase dimension of student storage arrays from',1I6,
     2' to',1I6)
      GO TO 216
  198 WRITE(ITTY,199)LMTMJR,KNTMJR
  199 FORMAT(
     1' Increase dimension of major arrays from',1I6,' to',1I6)
      GO TO 216
  200 WRITE(ITTY,201)
  201 FORMAT(' No schedules supplied by administrator')
      GO TO 216
  202 WRITE(ITTY,203)
  203 FORMAT(' Firm file was written by wrong program')
      GO TO 216
  204 WRITE(ITTY,205)
  205 FORMAT(' Input file is not a firm file')
      GO TO 216
  206 WRITE(ITTY,207)
  207 FORMAT(' Composite request file was written by wrong program')
      GO TO 216
  208 WRITE(ITTY,209)
  209 FORMAT(' Input file is not a composite request file')
      GO TO 216
  210 WRITE(ITTY,211)
  211 FORMAT(' Composite request file is for wrong class')
      GO TO 216
  212 WRITE(ITTY,213)
  213 FORMAT(' Priority allocation in decision file is wrong type')
      GO TO 216
  214 WRITE(ITTY,215)LMTRCT
  215 FORMAT(' More than',1I5,' total schedules in firm file')
      GO TO 216
  216 STOP
      END
